/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.architecturemaker.unit;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import net.wasamon.mics.architecturemaker.unit.DataBuffer;
import net.wasamon.mics.architecturemaker.unit.HardwareUnit;
import net.wasamon.mics.architecturemaker.unit.InitAttribute;
import net.wasamon.mics.architecturemaker.unit.MicsNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HardwareUnitManager
extends MicsNode {
    private static HardwareUnitManager instance = new HardwareUnitManager();
    private ArrayList<HardwareUnit> rankingList = new ArrayList();
    private HashMap<String, String> serialTable = new HashMap();
    private HashMap<String, HardwareUnit> idTable = new HashMap();
    private int selectedUnitsCount = 0;

    private HardwareUnitManager() {
        this.tag = "mics";
        this.indent = "";
    }

    public static HardwareUnitManager getInstance() {
        return instance;
    }

    public void setValue(MicsNode micsNode, String string, String string2) {
        if (string.equals("id") && micsNode instanceof HardwareUnit) {
            if (this.registerID((HardwareUnit)micsNode, string2)) {
                micsNode.set(string, string2);
            }
            return;
        }
        micsNode.set(string, string2);
    }

    public void addUnit(HardwareUnit hardwareUnit) {
        if (hardwareUnit.getID().equals("") || !this.uniqueID(hardwareUnit.getID())) {
            String string = this.registerUniqueID(hardwareUnit.getBaseID(), hardwareUnit);
            hardwareUnit.setID(string);
        } else {
            this.registerID(hardwareUnit, hardwareUnit.getID());
        }
        this.rankingList.add(hardwareUnit);
        this.childList.add(hardwareUnit);
    }

    public void deleteUnit(HardwareUnit hardwareUnit) {
        if (hardwareUnit == null) {
            return;
        }
        if (this.getUnitsCount() == 1) {
            this.clearAllUnits();
            return;
        }
        if (this.selectedUnit(hardwareUnit)) {
            --this.selectedUnitsCount;
        }
        this.rankingList.remove(hardwareUnit);
        this.childList.remove(hardwareUnit);
        this.idTable.remove(hardwareUnit.getID());
        for (int i = 0; i < this.childList.size(); ++i) {
            ((HardwareUnit)this.childList.get(i)).disconnect(hardwareUnit);
        }
    }

    public void deleteUnits(ArrayList<HardwareUnit> arrayList) {
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                this.deleteUnit(arrayList.get(i));
            }
        }
    }

    public void deleteUnits(HardwareUnit[] hardwareUnitArray) {
        if (hardwareUnitArray != null) {
            for (int i = 0; i < hardwareUnitArray.length; ++i) {
                this.deleteUnit(hardwareUnitArray[i]);
            }
        }
    }

    public void disconnectUnits(ArrayList<HardwareUnit> arrayList) {
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                for (int j = 0; j < arrayList.size(); ++j) {
                    arrayList.get(i).disconnect(arrayList.get(j));
                }
            }
        }
    }

    public void disconnectUnits(HardwareUnit[] hardwareUnitArray) {
        if (hardwareUnitArray != null) {
            for (int i = 0; i < hardwareUnitArray.length; ++i) {
                for (int j = 0; j < hardwareUnitArray.length; ++j) {
                    hardwareUnitArray[i].disconnect(hardwareUnitArray[j]);
                }
            }
        }
    }

    public void addInitFile(HardwareUnit hardwareUnit, String string, String string2) {
        if (hardwareUnit instanceof DataBuffer) {
            ((DataBuffer)((Object)hardwareUnit)).addInitFile(new StringBuilder(string), new StringBuilder(string2));
        }
    }

    public boolean registerID(HardwareUnit hardwareUnit, String string) {
        if (!this.uniqueID(string)) {
            return false;
        }
        this.idTable.remove(hardwareUnit.getID());
        this.idTable.put(string, hardwareUnit);
        return true;
    }

    public boolean uniqueID(String string) {
        return !this.idTable.containsKey(string);
    }

    private String registerUniqueID(String string, HardwareUnit hardwareUnit) {
        String string2;
        int n;
        if (!this.serialTable.containsKey(string)) {
            n = 0;
            while (!this.uniqueID(string2 = String.format("%s:%02d", string, n++))) {
            }
        } else {
            n = Integer.parseInt(this.serialTable.get(string));
            while (!this.uniqueID(string2 = String.format("%s:%02d", string, n++))) {
            }
            this.serialTable.remove(string);
        }
        this.serialTable.put(string, Integer.toString(n));
        this.idTable.put(string2, hardwareUnit);
        return string2;
    }

    public HardwareUnit[] getAllUnits() {
        return this.rankingList.toArray(new HardwareUnit[this.getUnitsCount()]);
    }

    public void clearAllUnits() {
        this.childList.clear();
        this.serialTable.clear();
        this.idTable.clear();
        this.rankingList.clear();
        this.clearSelectedUnits();
    }

    public int getUnitsCount() {
        return this.childList.size();
    }

    public HardwareUnit getUnit(int n) {
        return (HardwareUnit)this.childList.get(n);
    }

    public HardwareUnit getUnit(String string) {
        return this.idTable.get(string);
    }

    public HardwareUnit[] getSelectedUnits() {
        HardwareUnit[] hardwareUnitArray = new HardwareUnit[this.selectedUnitsCount];
        for (int i = 0; i < this.selectedUnitsCount; ++i) {
            hardwareUnitArray[i] = this.rankingList.get(i);
        }
        return hardwareUnitArray;
    }

    public void clearSelectedUnits() {
        this.selectedUnitsCount = 0;
    }

    public void deselect(HardwareUnit hardwareUnit) {
        if (hardwareUnit == null || !this.selectedUnit(hardwareUnit)) {
            return;
        }
        this.rankingList.remove(hardwareUnit);
        this.rankingList.add(--this.selectedUnitsCount, hardwareUnit);
    }

    public void select(HardwareUnit hardwareUnit) {
        if (hardwareUnit == null || this.selectedUnit(hardwareUnit)) {
            return;
        }
        this.rankingList.remove(hardwareUnit);
        this.rankingList.add(0, hardwareUnit);
        ++this.selectedUnitsCount;
    }

    public void selectAll() {
        this.selectedUnitsCount = this.rankingList.size();
    }

    public int getSelectedUnitsCount() {
        return this.selectedUnitsCount;
    }

    public boolean selectedUnit(HardwareUnit hardwareUnit) {
        int n = this.rankingList.indexOf(hardwareUnit);
        return 0 <= n && n < this.selectedUnitsCount;
    }

    public void deleteSelectedUnits() {
        this.deleteUnits(this.getSelectedUnits());
    }

    public void deleteInitFile(HardwareUnit hardwareUnit) {
        int n;
        ArrayList arrayList = new ArrayList();
        for (n = 0; n < hardwareUnit.childList.size(); ++n) {
            if (!((MicsNode)hardwareUnit.childList.get(n)).getTag().equals("init")) continue;
            arrayList.add(hardwareUnit.childList.get(n));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            hardwareUnit.childList.remove(arrayList.get(n));
        }
    }

    HardwareUnit[] copy(HardwareUnit[] hardwareUnitArray) {
        MicsNode micsNode;
        int n;
        int n2;
        HardwareUnit[] hardwareUnitArray2 = new HardwareUnit[hardwareUnitArray.length];
        HashMap<HardwareUnit, HardwareUnit> hashMap = new HashMap<HardwareUnit, HardwareUnit>();
        for (n2 = 0; n2 < hardwareUnitArray.length; ++n2) {
            hardwareUnitArray2[n2] = hardwareUnitArray[n2].copy();
            hashMap.put(hardwareUnitArray[n2], hardwareUnitArray2[n2]);
        }
        for (n2 = 0; n2 < hardwareUnitArray.length; ++n2) {
            for (n = 0; n < hardwareUnitArray[n2].connectedUnits.size(); ++n) {
                micsNode = (HardwareUnit)hashMap.get(this.getUnit(hardwareUnitArray[n2].connectedUnits.get(n).getID()));
                if (micsNode == null) continue;
                hardwareUnitArray2[n2].connect((HardwareUnit)micsNode);
            }
        }
        for (n2 = 0; n2 < hardwareUnitArray.length; ++n2) {
            for (n = 0; n < hardwareUnitArray[n2].childList.size(); ++n) {
                micsNode = (MicsNode)hardwareUnitArray[n2].childList.get(n);
                if (!(micsNode instanceof InitAttribute)) continue;
                hardwareUnitArray2[n2].childList.add(new InitAttribute(new StringBuilder(micsNode.get("file")), new StringBuilder(micsNode.get("offset"))));
            }
        }
        return hardwareUnitArray2;
    }

    @Override
    public void printXML(OutputStream outputStream) throws IOException {
        outputStream.write(new String("<?xml version=\"1.0\" encoding=\"euc-jp\"?>\n").getBytes());
        super.printXML(outputStream);
    }
}

