/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.architecturemaker;

import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Random;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.wasamon.mics.architecturemaker.SelectorBoxAction;
import net.wasamon.mics.architecturemaker.SelectorCellRenderer;
import net.wasamon.mics.architecturemaker.unit.BitmapDumpDisplay;
import net.wasamon.mics.architecturemaker.unit.CharacterDisplay;
import net.wasamon.mics.architecturemaker.unit.DirectMemoryAccessController;
import net.wasamon.mics.architecturemaker.unit.HardwareUnit;
import net.wasamon.mics.architecturemaker.unit.Mediator;
import net.wasamon.mics.architecturemaker.unit.MultiDataBus;
import net.wasamon.mics.architecturemaker.unit.RandomAccessMemory;
import net.wasamon.mics.architecturemaker.unit.ReconfigurableUnit;
import net.wasamon.mics.architecturemaker.unit.SH3;
import net.wasamon.mics.architecturemaker.unit.SimpleProcessor32;
import net.wasamon.mics.architecturemaker.unit.SingleDataBus;

public class HardwareUnitSelector
extends JPanel {
    private HashMap<String, ImageIcon> iconTable;
    private Mediator mediator;
    private static HardwareUnitSelector instance = new HardwareUnitSelector();

    private HardwareUnitSelector() {
        this.setLayout(new GridLayout(4, 1, 10, 10));
        this.mediator = Mediator.getInstance();
        Image image = this.newImageIcon(SimpleProcessor32.getDefaultImageFile()).getImage();
        Image image2 = this.newImageIcon(SH3.getDefaultImageFile()).getImage();
        Image image3 = this.newImageIcon(ReconfigurableUnit.getDefaultImageFile()).getImage();
        Image image4 = this.newImageIcon(BitmapDumpDisplay.getDefaultImageFile()).getImage();
        Image image5 = this.newImageIcon(CharacterDisplay.getDefaultImageFile()).getImage();
        Image image6 = this.newImageIcon(DirectMemoryAccessController.getDefaultImageFile()).getImage();
        Image image7 = this.newImageIcon(RandomAccessMemory.getDefaultImageFile()).getImage();
        Image image8 = this.newImageIcon(MultiDataBus.getDefaultImageFile()).getImage();
        Image image9 = this.newImageIcon(SingleDataBus.getDefaultImageFile()).getImage();
        this.iconTable = new HashMap();
        this.iconTable.put("cb_SimpleAudio", this.newImageIcon("icons/unit/pk_speaker1_4.gif"));
        this.iconTable.put("cb_SimpleNetworkInterface", this.newImageIcon("icons/unit/pp_tvcard1_4.gif"));
        this.iconTable.put("SimpleProcessor32", new ImageIcon(image.getScaledInstance(32, 32, 4)));
        this.iconTable.put("SH3", new ImageIcon(image2.getScaledInstance(32, 32, 4)));
        this.iconTable.put("ReconfigurableUnit", new ImageIcon(image3.getScaledInstance(32, 32, 4)));
        this.iconTable.put("BitmapDumpDisplay", new ImageIcon(image4.getScaledInstance(32, 32, 4)));
        this.iconTable.put("CharacterDisplay", new ImageIcon(image5.getScaledInstance(32, 32, 4)));
        this.iconTable.put("DirectMemoryAccessController", new ImageIcon(image6.getScaledInstance(32, 32, 4)));
        this.iconTable.put("RandomAccessMemory", new ImageIcon(image7.getScaledInstance(32, 32, 4)));
        this.iconTable.put("MultiDataBus", new ImageIcon(image8.getScaledInstance(32, 32, 4)));
        this.iconTable.put("SingleDataBus", new ImageIcon(image9.getScaledInstance(32, 32, 4)));
        DefaultComboBoxModel<SelectorBoxAction> defaultComboBoxModel = new DefaultComboBoxModel<SelectorBoxAction>();
        DefaultComboBoxModel<SelectorBoxAction> defaultComboBoxModel2 = new DefaultComboBoxModel<SelectorBoxAction>();
        DefaultComboBoxModel<SelectorBoxAction> defaultComboBoxModel3 = new DefaultComboBoxModel<SelectorBoxAction>();
        DefaultComboBoxModel<SelectorBoxAction> defaultComboBoxModel4 = new DefaultComboBoxModel<SelectorBoxAction>();
        defaultComboBoxModel.addElement(new SelectorBoxAction("Processor", this.iconTable.get("cb_Processor")));
        defaultComboBoxModel.addElement(new SelectorBoxAction(new JSeparator()));
        defaultComboBoxModel.addElement(new SelectorBoxAction("SimpleProcessor32", this.iconTable.get("SimpleProcessor32")));
        defaultComboBoxModel.addElement(new SelectorBoxAction("SH3", this.iconTable.get("SH3")));
        defaultComboBoxModel.addElement(new SelectorBoxAction("ReconfigurableUnit", this.iconTable.get("ReconfigurableUnit")));
        defaultComboBoxModel2.addElement(new SelectorBoxAction("Peripheral", this.iconTable.get("cb_Peripheral")));
        defaultComboBoxModel2.addElement(new SelectorBoxAction(new JSeparator()));
        defaultComboBoxModel2.addElement(new SelectorBoxAction("BitmapDumpDisplay", this.iconTable.get("BitmapDumpDisplay")));
        defaultComboBoxModel2.addElement(new SelectorBoxAction("CharacterDisplay", this.iconTable.get("CharacterDisplay")));
        defaultComboBoxModel2.addElement(new SelectorBoxAction("DirectMemoryAccessController", this.iconTable.get("DirectMemoryAccessController")));
        defaultComboBoxModel2.addElement(new SelectorBoxAction("SimpleAudio", this.iconTable.get("cb_SimpleAudio")));
        defaultComboBoxModel2.addElement(new SelectorBoxAction("SimpleNetworkInterface", this.iconTable.get("cb_SimpleNetworkInterface")));
        defaultComboBoxModel3.addElement(new SelectorBoxAction("Memory", this.iconTable.get("cb_Memory")));
        defaultComboBoxModel3.addElement(new SelectorBoxAction(new JSeparator()));
        defaultComboBoxModel3.addElement(new SelectorBoxAction("RandomAccessMemory", this.iconTable.get("RandomAccessMemory")));
        defaultComboBoxModel4.addElement(new SelectorBoxAction("Bus", this.iconTable.get("cb_Bus")));
        defaultComboBoxModel4.addElement(new SelectorBoxAction(new JSeparator()));
        defaultComboBoxModel4.addElement(new SelectorBoxAction("MultiDataBus", this.iconTable.get("MultiDataBus")));
        defaultComboBoxModel4.addElement(new SelectorBoxAction("SingleDataBus", this.iconTable.get("SingleDataBus")));
        JComboBox<Object> jComboBox = new JComboBox<Object>(defaultComboBoxModel);
        JComboBox<Object> jComboBox2 = new JComboBox<Object>(defaultComboBoxModel2);
        JComboBox<Object> jComboBox3 = new JComboBox<Object>(defaultComboBoxModel3);
        JComboBox<Object> jComboBox4 = new JComboBox<Object>(defaultComboBoxModel4);
        jComboBox.setRenderer(new SelectorCellRenderer());
        jComboBox2.setRenderer(new SelectorCellRenderer());
        jComboBox3.setRenderer(new SelectorCellRenderer());
        jComboBox4.setRenderer(new SelectorCellRenderer());
        jComboBox.addActionListener(new SelectorBoxActionListener());
        jComboBox2.addActionListener(new SelectorBoxActionListener());
        jComboBox3.addActionListener(new SelectorBoxActionListener());
        jComboBox4.addActionListener(new SelectorBoxActionListener());
        this.add(jComboBox);
        this.add(jComboBox3);
        this.add(jComboBox4);
        this.add(jComboBox2);
    }

    private ImageIcon newImageIcon(String string) {
        return new ImageIcon(this.getClass().getClassLoader().getResource(string));
    }

    public static HardwareUnitSelector getInstance() {
        return instance;
    }

    class SelectorBoxActionListener
    implements ActionListener {
        Point position;

        SelectorBoxActionListener() {
        }

        private void reset(JComboBox jComboBox) {
            jComboBox.setSelectedIndex(0);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HardwareUnit hardwareUnit;
            int n;
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            if (jComboBox.getSelectedIndex() <= 1) {
                this.reset(jComboBox);
                return;
            }
            Random random = new Random();
            String string = ((SelectorBoxAction)jComboBox.getSelectedItem()).text;
            int n2 = HardwareUnitSelector.this.mediator.getCanvasWidth();
            int n3 = HardwareUnitSelector.this.mediator.getCanvasHeight();
            int n4 = n2 < 100 ? n2 / 2 : random.nextInt(n2 - 100) + 50;
            int n5 = n = n3 < 100 ? n3 / 2 : random.nextInt(n3 - 100) + 50;
            if (string.equals("SingleDataBus")) {
                hardwareUnit = new SingleDataBus("", n4, n);
            } else if (string.equals("MultiDataBus")) {
                hardwareUnit = new MultiDataBus("", n4, n);
            } else if (string.equals("SimpleProcessor32")) {
                hardwareUnit = new SimpleProcessor32("", n4, n);
            } else if (string.equals("SH3")) {
                hardwareUnit = new SH3("", n4, n);
            } else if (string.equals("ReconfigurableUnit")) {
                hardwareUnit = new ReconfigurableUnit("", n4, n);
            } else if (string.equals("RandomAccessMemory")) {
                hardwareUnit = new RandomAccessMemory("", n4, n);
            } else if (string.equals("DirectMemoryAccessController")) {
                hardwareUnit = new DirectMemoryAccessController("", n4, n);
            } else if (string.equals("CharacterDisplay")) {
                hardwareUnit = new CharacterDisplay("", n4, n);
            } else if (string.equals("BitmapDumpDisplay")) {
                hardwareUnit = new BitmapDumpDisplay("", n4, n);
            } else {
                this.reset(jComboBox);
                return;
            }
            HardwareUnitSelector.this.mediator.addUnit(hardwareUnit);
            this.reset(jComboBox);
        }
    }
}

