/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.architecturemaker;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.ImageIcon;
import javax.swing.JButton;

class RoundedCornerButton
extends JButton {
    private static final float arcwidth = 8.0f;
    private static final float archeight = 8.0f;
    protected static final int focusstroke = 0;
    protected Shape shape;
    protected Shape border;
    protected Shape base;

    public RoundedCornerButton(String string) {
        super(string);
        this.setMargin(new Insets(2, 2, 2, 2));
        this.setContentAreaFilled(false);
        this.setBackground(new Color(250, 250, 250));
        this.initShape();
    }

    public RoundedCornerButton(String string, Color color) {
        super(string);
        this.setMargin(new Insets(2, 2, 2, 2));
        this.setContentAreaFilled(false);
        this.setBackground(color);
        this.initShape();
    }

    public RoundedCornerButton(String string, ImageIcon imageIcon) {
        super(string, imageIcon);
        this.setMargin(new Insets(2, 2, 2, 2));
        this.setContentAreaFilled(false);
        this.setBackground(new Color(250, 250, 250));
        this.initShape();
    }

    public RoundedCornerButton(String string, ImageIcon imageIcon, Color color) {
        super(string, imageIcon);
        this.setMargin(new Insets(4, 4, 4, 4));
        this.setContentAreaFilled(false);
        this.setBackground(color);
        this.initShape();
    }

    protected void initShape() {
        if (!this.getBounds().equals(this.base)) {
            this.base = this.getBounds();
            this.shape = new RoundRectangle2D.Float(0.0f, 0.0f, this.getWidth() - 1, this.getHeight() - 1, 8.0f, 8.0f);
            this.border = new RoundRectangle2D.Float(0.0f, 0.0f, this.getWidth() - 1 - 0, this.getHeight() - 1 - 0, 8.0f, 8.0f);
        }
    }

    protected void paintComponent(Graphics graphics) {
        this.initShape();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.getModel().isArmed()) {
            Color color = this.getBackground();
            Color color2 = new Color((int)((double)color.getRed() * 0.9), (int)((double)color.getGreen() * 0.9), (int)((double)color.getBlue() * 0.9));
            graphics2D.setPaint(new GradientPaint(0.0f, this.getHeight() / 2, color2, 0.0f, this.getHeight(), this.getBackground(), true));
            graphics2D.fill(this.shape);
            graphics2D.setPaint(new GradientPaint(0.0f, this.getHeight() / 2, new Color(0, 120, 180), this.getWidth(), this.getHeight(), new Color(0, 100, 150), true));
            graphics2D.draw(this.shape);
        } else if (this.isRolloverEnabled() && this.getModel().isRollover()) {
            graphics2D.setPaint(new GradientPaint(0.0f, this.getHeight() / 2, this.getBackground(), 0.0f, this.getHeight(), this.getBackground().brighter(), true));
            graphics2D.fill(this.border);
            graphics2D.setPaint(new GradientPaint(0.0f, this.getHeight() / 2, new Color(0, 120, 180), this.getWidth(), this.getHeight(), new Color(0, 100, 150), true));
            graphics2D.draw(this.shape);
        } else if (!this.hasFocus()) {
            graphics2D.setColor(this.getBackground());
            graphics2D.fill(this.shape);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setColor(this.getBackground());
        super.paintComponent(graphics2D);
    }

    private void paintFocusAndRollover(Graphics2D graphics2D, Color color) {
        graphics2D.setColor(this.getBackground());
        graphics2D.fill(this.border);
        graphics2D.setColor(Color.BLACK);
        graphics2D.draw(this.shape);
    }

    protected void paintBorder(Graphics graphics) {
    }

    public boolean contains(int n, int n2) {
        this.initShape();
        return this.shape.contains(n, n2);
    }
}

