/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.architecturemaker.unit;

import java.util.regex.Pattern;
import net.wasamon.mics.architecturemaker.unit.Channel;
import net.wasamon.mics.architecturemaker.unit.ChannelConnectable;
import net.wasamon.mics.architecturemaker.unit.DataBuffer;
import net.wasamon.mics.architecturemaker.unit.ExecutableElement;
import net.wasamon.mics.architecturemaker.unit.HardwareUnit;

public class DirectMemoryAccessController
extends HardwareUnit
implements Channel,
ChannelConnectable,
ExecutableElement {
    private static String baseID = "dmac";
    private static String defaultImageFile = "icons/unit/square_g.gif";

    public DirectMemoryAccessController(String string, int n, int n2) {
        super(string, "net.wasamon.mics.peripheral.DirectMemoryAccessController", n, n2, 16, 16, defaultImageFile);
        this.conditionTable.put("width", Pattern.compile("\\p{Digit}+"));
        this.conditionTable.put("src", Pattern.compile(".{0}&&[^.]"));
        this.conditionTable.put("dest", Pattern.compile(".{0}&&[^.]"));
        this.setValue("width", "3");
        this.setValue("src", "");
        this.setValue("dest", "");
    }

    public String getBaseID() {
        return baseID;
    }

    public void setBaseID(String string) {
        baseID = string;
    }

    public static String getDefaultImageFile() {
        return defaultImageFile;
    }

    public void addChannel(StringBuilder stringBuilder, StringBuilder stringBuilder2) {
    }

    public String getInformation() {
        return "";
    }

    public void register(HardwareUnit hardwareUnit) {
        HardwareUnit hardwareUnit2 = this.getConnectedUnit(this.getValue("src").toString());
        HardwareUnit hardwareUnit3 = this.getConnectedUnit(this.getValue("dest").toString());
        if (hardwareUnit2 == null) {
            if (hardwareUnit instanceof Channel) {
                this.setValue("src", hardwareUnit.getValue("id"));
            }
        } else if (hardwareUnit3 == null && hardwareUnit instanceof Channel) {
            this.setValue("dest", hardwareUnit.getValue("id"));
        }
    }

    public void remove(HardwareUnit hardwareUnit) {
        block3: {
            HardwareUnit hardwareUnit2;
            HardwareUnit hardwareUnit3;
            block2: {
                hardwareUnit3 = this.getConnectedUnit(this.getValue("src").toString());
                hardwareUnit2 = this.getConnectedUnit(this.getValue("dest").toString());
                if (hardwareUnit3 != hardwareUnit) break block2;
                this.setValue("src", new StringBuilder(""));
                for (int i = 0; i < this.connectedUnits.size(); ++i) {
                    HardwareUnit hardwareUnit4 = (HardwareUnit)this.connectedUnits.get(i);
                    if (hardwareUnit4 == hardwareUnit || hardwareUnit4 == hardwareUnit2) continue;
                    this.register(hardwareUnit4);
                    return;
                }
                break block3;
            }
            if (hardwareUnit2 != hardwareUnit) break block3;
            this.setValue("dest", new StringBuilder(""));
            for (int i = 0; i < this.connectedUnits.size(); ++i) {
                HardwareUnit hardwareUnit5 = (HardwareUnit)this.connectedUnits.get(i);
                if (hardwareUnit5 == hardwareUnit || hardwareUnit5 == hardwareUnit3) continue;
                this.register(hardwareUnit5);
                return;
            }
        }
    }

    public boolean isConnectable(HardwareUnit hardwareUnit) {
        if (!(hardwareUnit instanceof DataBuffer || hardwareUnit instanceof Channel || hardwareUnit instanceof ChannelConnectable)) {
            return false;
        }
        HardwareUnit hardwareUnit2 = this.getConnectedUnit(this.getValue("src").toString());
        HardwareUnit hardwareUnit3 = this.getConnectedUnit(this.getValue("dest").toString());
        return !(hardwareUnit instanceof Channel) || hardwareUnit2 == null || hardwareUnit3 == null;
    }

    public HardwareUnit copy() {
        DirectMemoryAccessController directMemoryAccessController = new DirectMemoryAccessController(this.getID(), this.getX(), this.getY());
        directMemoryAccessController.setImage(this.appearance.get("image"));
        return directMemoryAccessController;
    }
}

