/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.architecturemaker.unit;

import java.awt.Image;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import net.wasamon.mics.architecturemaker.unit.MicsNode;
import net.wasamon.mics.architecturemaker.unit.UndefinedImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HardwareUnit
extends MicsNode {
    AppearanceAttribute appearance;
    ArrayList<HardwareUnit> connectedUnits;

    public HardwareUnit(String string, String string2, int n, int n2, int n3, int n4, String string3) {
        this.appearance = new AppearanceAttribute(n, n2, n3, n4, string3);
        this.connectedUnits = new ArrayList();
        this.tag = "element";
        this.indent = "  ";
        this.setID(string);
        this.conditionTable.put("class", Pattern.compile(".{0}&&[^.]"));
        this.setUnitClass(string2);
        this.childList.add(this.appearance);
    }

    public boolean inRange(int n, int n2) {
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        int n5 = this.getX() - n3 / 2;
        int n6 = this.getY() - n4 / 2;
        return n >= n5 && n < n5 + n3 && n2 >= n6 && n2 < n6 + n4;
    }

    public void setPosition(int n, int n2) {
        this.appearance.set("x", Integer.toString(n));
        this.appearance.set("y", Integer.toString(n2));
    }

    public int getX() {
        return Integer.parseInt(this.appearance.get("x"));
    }

    public int getY() {
        return Integer.parseInt(this.appearance.get("y"));
    }

    public void setSize(int n, int n2) {
        this.appearance.set("width", Integer.toString(n));
        this.appearance.set("height", Integer.toString(n2));
    }

    public int getWidth() {
        return Integer.parseInt(this.appearance.get("width"));
    }

    public int getHeight() {
        return Integer.parseInt(this.appearance.get("height"));
    }

    public String getID() {
        return this.get("id");
    }

    public void setID(String string) {
        this.set("id", string);
    }

    public String getUnitClass() {
        return this.get("class");
    }

    private void setUnitClass(String string) {
        this.setValue("class", string);
    }

    public HardwareUnit[] getConnectedUnitList() {
        return this.connectedUnits.toArray(new HardwareUnit[this.connectedUnits.size()]);
    }

    public void setImage(String string) {
        this.appearance.set("image", string);
    }

    public Image getImage() {
        return this.appearance.getImage();
    }

    public boolean isConnectedWith(HardwareUnit hardwareUnit) {
        return this.connectedUnits.contains(hardwareUnit);
    }

    public void disconnect(HardwareUnit hardwareUnit) {
        this.remove(hardwareUnit);
        hardwareUnit.remove(this);
        hardwareUnit.connectedUnits.remove(this);
        this.connectedUnits.remove(hardwareUnit);
    }

    public boolean connect(HardwareUnit hardwareUnit) {
        if (hardwareUnit == null || !this.isConnectable(hardwareUnit) || !hardwareUnit.isConnectable(this)) {
            return false;
        }
        if (this.isConnectedWith(hardwareUnit)) {
            return true;
        }
        this.register(hardwareUnit);
        hardwareUnit.register(this);
        this.connectedUnits.add(hardwareUnit);
        hardwareUnit.connectedUnits.add(this);
        return true;
    }

    public HardwareUnit getConnectedUnit(String string) {
        for (int i = 0; i < this.connectedUnits.size(); ++i) {
            HardwareUnit hardwareUnit = this.connectedUnits.get(i);
            if (!string.equals(hardwareUnit.getID())) continue;
            return hardwareUnit;
        }
        return null;
    }

    public abstract String getBaseID();

    public abstract void setBaseID(String var1);

    public abstract String getInformation();

    public abstract void register(HardwareUnit var1);

    public abstract void remove(HardwareUnit var1);

    public abstract boolean isConnectable(HardwareUnit var1);

    public abstract HardwareUnit copy();

    public ArrayList<HardwareUnit> connectedUnits() {
        return this.connectedUnits;
    }

    public AppearanceAttribute appearance() {
        return this.appearance;
    }

    class AppearanceAttribute
    extends MicsNode {
        private Image image;

        AppearanceAttribute(int n, int n2, int n3, int n4, String string) {
            this.tag = "appearance";
            this.indent = "    ";
            this.conditionTable.put("x", Pattern.compile("\\p{Digit}+"));
            this.conditionTable.put("y", Pattern.compile("\\p{Digit}+"));
            this.conditionTable.put("width", Pattern.compile("\\p{Digit}{1,3}"));
            this.conditionTable.put("height", Pattern.compile("\\p{Digit}{1,3}"));
            this.conditionTable.put("image", Pattern.compile("[^<>*?|\"]+"));
            this.setValue("x", Integer.toString(n));
            this.setValue("y", Integer.toString(n2));
            this.setValue("width", Integer.toString(n3));
            this.setValue("height", Integer.toString(n4));
            this.setImage(string);
        }

        public void set(String string, String string2) {
            if (this.check(string, string2)) {
                if (string.equals("image")) {
                    this.setImage(string2);
                } else {
                    this.setValue(string, string2);
                }
            }
        }

        public Image getImage() {
            return this.image;
        }

        public void setImage(String string) {
            if (string == null) {
                this.setValue("image", "icons/unit/pw_hatena1_8.gif");
                this.image = UndefinedImageIcon.getInstance().getImage();
            } else {
                this.setValue("image", string);
                this.image = new ImageIcon(this.getClass().getClassLoader().getResource(string)).getImage();
            }
        }
    }
}

