/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.architecturemaker.unit;

import java.util.regex.Pattern;
import net.wasamon.mics.architecturemaker.unit.Channel;
import net.wasamon.mics.architecturemaker.unit.ChannelAttribute;
import net.wasamon.mics.architecturemaker.unit.ChannelConnectable;
import net.wasamon.mics.architecturemaker.unit.DataBuffer;
import net.wasamon.mics.architecturemaker.unit.ExecutableElement;
import net.wasamon.mics.architecturemaker.unit.HardwareUnit;
import net.wasamon.mics.architecturemaker.unit.InitAttribute;
import net.wasamon.mics.architecturemaker.unit.MicsNode;

public class ReconfigurableUnit
extends HardwareUnit
implements DataBuffer,
ChannelConnectable,
ExecutableElement {
    private static String baseID = "rlu";
    private static String defaultImageFile = "icons/unit/rlu.png";

    public ReconfigurableUnit(String string, int n, int n2) {
        super(string, "net.wasamon.mics.processor.rlu.ReconfigurableUnit", n, n2, 50, 50, defaultImageFile);
        this.conditionTable.put("size", Pattern.compile("\\p{Digit}+"));
        this.setValue("size", "8");
    }

    public String getBaseID() {
        return baseID;
    }

    public void setBaseID(String string) {
        baseID = string;
    }

    public static String getDefaultImageFile() {
        return defaultImageFile;
    }

    public void addInitFile(StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        this.childList.add(new InitAttribute(stringBuilder, stringBuilder2));
    }

    public void addChannel(StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        this.childList.add(new ChannelAttribute(stringBuilder, stringBuilder2));
    }

    public String getInformation() {
        return "";
    }

    public void register(HardwareUnit hardwareUnit) {
        this.addChannel(hardwareUnit.getValue("id"), new StringBuilder(String.format("0x%x", 0)));
    }

    public void remove(HardwareUnit hardwareUnit) {
        StringBuilder stringBuilder = hardwareUnit.getValue("id");
        for (int i = 0; i < this.childList.size(); ++i) {
            if (stringBuilder != ((MicsNode)this.childList.get(i)).getValue("id")) continue;
            this.childList.remove(i);
        }
    }

    public boolean isConnectable(HardwareUnit hardwareUnit) {
        return hardwareUnit instanceof Channel;
    }

    public HardwareUnit copy() {
        ReconfigurableUnit reconfigurableUnit = new ReconfigurableUnit(this.getID(), this.getX(), this.getY());
        reconfigurableUnit.setImage(this.appearance.get("image"));
        return reconfigurableUnit;
    }
}

