/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.architecturemaker.unit;

import java.util.regex.Pattern;
import net.wasamon.mics.architecturemaker.unit.Channel;
import net.wasamon.mics.architecturemaker.unit.ChannelConnectable;
import net.wasamon.mics.architecturemaker.unit.DataBuffer;
import net.wasamon.mics.architecturemaker.unit.HardwareUnit;

public class SingleDataBus
extends HardwareUnit
implements Channel {
    private static String baseID = "sbus";
    private static String defaultImageFile = "icons/unit/square_w.gif";

    public SingleDataBus(String string, int n, int n2) {
        super(string, "net.wasamon.mics.bus.SingleDataBus", n, n2, 16, 16, defaultImageFile);
        this.conditionTable.put("ram", Pattern.compile(".{0}&&[^.]"));
        this.setValue("ram", "");
    }

    public String getBaseID() {
        return baseID;
    }

    public void setBaseID(String string) {
        baseID = string;
    }

    public static String getDefaultImageFile() {
        return defaultImageFile;
    }

    public String getInformation() {
        return "";
    }

    public void register(HardwareUnit hardwareUnit) {
        HardwareUnit hardwareUnit2 = this.getConnectedUnit(this.getValue("ram").toString());
        if (hardwareUnit2 == null || hardwareUnit2 instanceof ChannelConnectable && !(hardwareUnit instanceof ChannelConnectable)) {
            this.setValue("ram", hardwareUnit.getValue("id"));
        }
    }

    public void remove(HardwareUnit hardwareUnit) {
        HardwareUnit hardwareUnit2 = this.getConnectedUnit(this.getValue("ram").toString());
        if (hardwareUnit2 == hardwareUnit) {
            this.setValue("ram", new StringBuilder(""));
            for (int i = 0; i < this.connectedUnits.size(); ++i) {
                HardwareUnit hardwareUnit3 = (HardwareUnit)this.connectedUnits.get(i);
                if (hardwareUnit3 == hardwareUnit) continue;
                this.register(hardwareUnit3);
                return;
            }
        }
    }

    public HardwareUnit copy() {
        SingleDataBus singleDataBus = new SingleDataBus(this.getID(), this.getX(), this.getY());
        singleDataBus.setImage(this.appearance.get("image"));
        return singleDataBus;
    }

    public boolean isConnectable(HardwareUnit hardwareUnit) {
        if (!(hardwareUnit instanceof DataBuffer) && !(hardwareUnit instanceof ChannelConnectable)) {
            return false;
        }
        HardwareUnit hardwareUnit2 = this.getConnectedUnit(this.getValue("ram").toString());
        return hardwareUnit2 == null || hardwareUnit instanceof ChannelConnectable || hardwareUnit2 instanceof ChannelConnectable;
    }
}

