/*
Midbar
Distributed under the MIT License
© Copyright Maxim Bortnikov 2023
For more information please visit
https://sourceforge.net/projects/midbar/
https://osdn.net/projects/midbar/
https://github.com/Northstrix/Midbar
Required libraries:
https://github.com/zhouyangchao/AES
https://github.com/peterferrie/serpent
https://github.com/ddokkaebi/Blowfish
https://github.com/Northstrix/DES_and_3DES_Library_for_MCUs
https://github.com/ulwanski/sha512
https://github.com/adafruit/Adafruit_ILI9341
https://github.com/adafruit/Adafruit-GFX-Library
https://github.com/adafruit/Adafruit_BusIO
https://github.com/intrbiz/arduino-crypto
https://github.com/GyverLibs/EncButton
*/
#include <TFT_eSPI.h> // Hardware-specific library
#include <SPI.h>

TFT_eSPI tft = TFT_eSPI();       // Invoke custom library
TFT_eSprite mvng_bc = TFT_eSprite(&tft);

const uint16_t Dallas [320][181] = {
{392,392,392,392,392,392,392,424,424,424,424,424,424,425,425,425,425,425,425,425,457,457,457,457,457,457,457,457,457,490,490,490,490,490,490,490,490,490,522,522,522,522,522,522,522,522,522,522,522,522,554,555,555,555,555,555,555,555,555,587,587,587,587,587,588,2636,2636,2636,2636,2668,2668,2668,2668,2668,2668,2668,2668,2700,2700,2700,4748,4748,4748,4781,4781,4781,4781,4780,4781,4781,6829,6861,6861,6861,6861,6861,6861,6861,6893,6893,8941,8941,6893,6926,8974,8974,8974,8974,9006,9006,11054,11054,11054,11054,11054,11086,11054,11086,13134,13134,13134,13166,13166,13166,15214,15214,15214,15214,15214,15246,17294,17294,17294,17294,19342,19374,19374,19373,19373,19373,21421,21421,21420,21420,21420,21420,21388,21388,21388,21388,23404,23403,23403,23403,23403,23371,23370,23370,21290,19177,19145,17032,29544,29512,20996,12578,6306,4225,6306,4193,21028,48168,12578,6338,4257,2145,2112,4225,4225,4193,255},
{392,392,392,392,392,392,392,424,424,424,424,424,425,425,425,425,425,425,425,425,457,457,457,457,457,457,457,457,489,490,490,490,490,490,490,490,490,490,522,522,522,522,522,522,522,522,522,522,554,554,554,554,555,555,555,555,555,555,555,555,587,587,587,587,2636,2636,2636,2636,2668,2668,620,2668,2668,2668,2668,2668,2700,2700,2700,2700,4748,4748,4748,4748,4781,4781,4781,4781,4781,6829,6829,4813,4813,6861,6861,6861,6861,6861,6861,6893,8941,6893,6925,8974,8974,6926,8974,8974,9006,11054,11054,11054,11054,11054,11054,11054,11054,11054,13134,13134,13134,13166,13134,13166,15214,15214,15214,15214,15214,15246,17294,17294,17294,17294,19342,19374,19374,19373,19373,19373,21421,21421,21421,21421,21421,23468,23468,23468,23435,21323,23403,23370,17130,17130,17097,17065,14985,14952,8517,4291,4258,4258,2178,2145,2178,4226,6338,4226,6274,2145,16835,44008,6273,2145,2112,2145,2112,4225,4225,4193,255},
{392,392,392,392,392,392,392,424,424,424,424,424,425,425,425,425,425,425,425,425,457,457,457,457,457,457,457,457,489,490,490,490,490,490,490,490,490,522,522,522,522,522,522,522,522,522,522,522,522,555,554,555,555,555,555,555,555,555,555,587,587,587,587,2636,2636,2636,2636,2668,2668,2668,620,620,620,2668,2668,2700,2700,2700,2700,2700,4748,4748,4748,4748,4781,4781,4781,4781,4781,6829,6829,4813,4813,4813,4813,6861,6861,6861,6893,6893,8941,6893,6926,8974,6926,8974,8974,8974,9006,11054,11054,11054,11054,11054,11054,11054,11054,13134,13134,13134,13134,13134,13134,13166,15214,15214,15214,15214,15246,15246,17294,17294,17294,17326,19374,19374,19374,19374,19373,19373,21389,23371,25450,25418,25386,23305,23240,21160,27400,37834,25287,19047,10759,12775,12775,12774,12742,12742,8484,6306,6338,6338,6338,6338,6338,6338,8451,6306,4258,2145,14723,44007,6273,2145,2112,2112,2112,4193,4225,4193,255},
{392,392,392,392,392,392,392,424,424,424,424,425,425,425,425,425,425,425,425,425,457,457,457,457,457,457,457,457,490,490,490,490,490,490,490,490,490,522,522,522,522,522,522,522,522,522,522,523,523,523,555,555,555,555,555,555,555,555,555,587,587,587,587,587,2636,2636,2636,2636,2668,620,620,2668,2668,2668,2668,2668,2700,2700,2700,2700,2700,4749,4749,4781,4781,4781,4781,4781,4781,6829,6861,4813,4813,4813,4813,4813,6861,6861,6893,6893,8941,8941,6925,6926,6926,8974,8974,8974,9006,9006,11054,11054,11054,11054,11054,11054,11054,11054,11086,13134,13134,13134,13134,13166,15214,15214,15214,15214,15246,17294,17294,17294,17294,17326,19374,19374,19374,19373,19373,19373,21193,16869,16869,18917,14756,14756,14756,12644,35754,54704,14887,12774,12774,12774,12774,12775,14823,14823,10597,6370,6338,6371,6371,6371,6371,6371,8483,6306,4225,2145,12643,35654,4225,4193,2113,2112,4225,4225,4225,4225,255},
{392,392,392,392,392,392,392,424,424,424,424,425,425,425,425,425,425,425,425,457,457,457,457,457,457,457,457,457,490,490,490,490,490,490,490,490,490,522,522,522,522,522,522,522,522,522,522,523,523,555,555,555,555,555,555,555,555,555,555,587,587,587,587,587,2636,2636,2636,2636,2668,2668,2668,620,620,2668,2668,2668,2700,2700,2700,2700,4749,4748,4749,4781,4781,4781,4781,6829,4781,6829,6861,6861,4813,4813,4813,4845,6893,6861,6861,6893,8941,8941,8941,6926,8974,8974,8974,8974,9006,9006,11054,11054,11054,11054,11054,11054,11054,11054,13134,13134,13134,13134,13134,13166,15214,15214,15214,15246,15246,15246,17294,17294,17326,17326,19374,19374,19374,19374,19373,19341,14822,6338,4258,12644,14724,14724,14756,12644,42092,48399,12775,12807,12807,12807,12807,12807,14855,14855,14790,8483,8451,8451,8451,8451,8451,8419,8419,4226,4225,2145,6338,10530,4193,2145,2145,4225,6305,4225,4225,4225,255},
{392,392,392,392,392,392,424,424,424,424,425,425,425,425,425,425,425,425,425,457,457,457,457,457,457,457,457,457,490,490,490,490,490,490,490,490,490,522,522,522,522,522,522,522,522,522,523,523,523,523,555,555,555,555,555,555,555,555,587,587,587,587,587,2636,2636,2636,2636,2668,2668,2668,2668,620,2668,2668,2668,2700,2700,2700,2700,4749,4748,4748,4781,4781,4781,4781,4781,4781,4781,4781,4813,4813,4813,4813,4813,4845,4845,6861,6861,6893,8941,8941,8941,8974,8974,8974,8974,8973,8974,9006,11054,11054,11054,11054,11054,11054,11054,11054,13134,13134,13134,13134,13166,13166,15214,15214,15214,15246,15246,17294,17326,17294,17326,19374,19374,19374,19374,19373,19373,19341,14790,6306,6371,14724,14724,14724,14789,14789,50479,40045,12775,12807,12807,12775,12775,12774,10661,8549,8484,6339,6339,8387,6338,10499,10531,10499,14659,4225,4225,2145,2145,6305,2145,4193,4225,4225,4225,4193,4193,4225,255},
{392,392,392,392,392,424,424,424,424,424,424,425,425,425,425,425,425,425,425,457,457,457,457,457,457,457,457,457,490,490,490,490,490,490,490,490,490,522,522,522,522,522,522,522,522,522,522,523,523,555,555,555,555,555,555,555,555,555,555,587,587,587,587,2636,2636,2636,2668,2668,2668,2668,2668,2668,2668,2668,2700,2700,2700,2700,2700,4748,4748,4748,4749,4781,4781,4781,4781,4781,4781,4781,4813,4813,4813,4813,4845,4845,4845,6893,6893,6893,8941,8941,8941,8974,8974,8974,8973,8973,8974,9006,11054,11054,11054,11054,11054,11054,11054,13102,13134,13134,13134,13166,13166,13166,13166,15214,15246,15246,15246,17294,17326,17294,17326,19374,19374,19374,19374,19373,19373,19341,14790,6338,8451,14756,14724,14757,12872,14984,46285,33674,12677,14790,14790,16902,18950,18950,21030,16804,21029,20997,18949,25222,18949,23142,21029,16869,20997,4258,6306,4193,2113,4225,4193,2145,2145,4225,2145,2144,4225,4225,255},
{392,392,392,392,392,392,424,424,424,424,424,425,425,425,425,425,425,425,425,457,457,457,457,457,457,457,457,489,490,490,490,490,490,490,490,490,522,522,522,522,522,522,522,522,522,522,523,523,523,555,555,555,555,555,555,555,555,555,587,587,587,587,2636,2636,2636,2636,2668,620,2668,2668,2668,2668,2668,2668,2668,2700,2700,2700,2700,4749,4749,4749,4749,4781,4781,2733,2733,4781,4781,4781,4813,4813,4813,4813,4813,4845,4845,6893,4845,6893,8941,8941,6925,8974,8974,8974,8973,8973,8973,8974,11054,11054,11054,11054,11054,11054,11086,13134,13134,13134,13166,13166,13166,13166,15214,15246,15246,15246,15246,17294,17326,17326,17326,19374,19374,19374,19374,19373,19374,17164,14757,14724,14724,16837,14756,12677,8582,14854,42091,33706,21094,25288,21062,21127,19014,16902,16902,10596,10628,8483,6371,8451,4290,6371,6338,4258,8419,6306,6338,4225,4225,4225,6338,4225,2112,2145,2113,2112,2145,4193,255},
{392,392,392,392,424,424,424,424,424,424,425,425,425,425,425,425,425,425,457,457,457,457,457,457,457,457,457,457,489,490,490,490,490,490,490,490,522,522,522,522,522,522,522,522,522,522,522,523,523,555,555,555,555,555,555,555,555,587,587,587,587,587,587,2636,2636,2668,2668,620,2668,2668,2668,2668,2668,2668,2700,2700,2700,2700,4749,4749,4748,2701,2701,2733,2733,2733,2733,2733,4781,4813,4813,4813,4813,4813,4845,4845,4845,6893,6893,6893,6893,6893,6926,6926,8974,8974,8973,8973,8974,9006,11054,11054,11054,11054,11054,11086,11086,13134,13134,13134,13166,13166,13166,13166,15246,15246,15246,15246,17294,17294,17326,17326,17326,19374,19374,19374,19374,19373,19406,12840,12611,8451,4290,14724,16805,12677,8581,10629,12644,10564,10629,10597,10597,10597,10597,10597,8483,4258,6371,6338,6306,8419,4258,8451,8419,6306,8419,4225,6338,4193,2145,4225,4225,4225,2145,2145,2112,32,2113,2145,255},
{392,392,392,392,424,424,424,424,424,424,425,425,425,425,425,425,425,425,457,457,457,457,457,457,457,457,457,489,489,490,490,490,490,490,490,490,522,522,522,522,522,522,522,522,522,522,522,555,555,555,555,555,555,555,555,555,555,587,587,587,587,587,2636,2636,2636,2636,2636,2668,620,2668,620,2668,2668,2668,2700,2700,2700,2700,4748,4748,2701,2733,2733,2733,4781,4781,2733,4781,4813,4813,4813,4813,4813,4813,4845,4845,4845,4845,6893,8941,8941,8941,8941,8974,8974,8974,8974,8973,8974,8974,11054,11054,11054,11054,11086,11086,11086,13134,13134,13134,13166,13166,13166,13166,15246,15246,15246,15246,17294,17326,17326,17326,17326,17326,19374,19374,19374,19374,19374,14921,10531,14724,10563,12676,12644,10596,8581,10629,12612,12612,10629,10597,10629,12677,10629,10597,10532,6338,8419,6338,6306,8419,4258,8419,6370,6338,10531,4258,4225,2145,4193,4225,4193,2145,2145,2145,64,32,2112,2112,255},
{392,392,392,392,392,424,424,424,424,424,425,425,425,425,425,425,425,425,425,457,457,457,457,457,457,457,457,489,490,490,490,490,490,490,490,490,490,522,522,522,522,522,522,522,522,522,522,555,555,555,555,555,555,555,555,555,555,587,587,587,587,587,2636,2636,2636,2636,2668,620,620,620,620,2668,2668,2668,2700,2700,2700,2700,4749,4748,2701,2701,4781,2733,4781,4781,2733,2733,4781,4813,4813,4813,4813,4813,4813,4845,6893,6893,6893,6893,8941,8941,8973,6926,8974,8974,8974,8973,8974,9006,11054,11054,11086,11086,11086,11086,13134,13134,13134,13134,13166,13166,13166,15214,15246,15246,15246,15246,17294,17326,17326,17326,17326,17326,19374,19374,19374,19374,19374,19276,10597,8451,8484,8451,6371,6403,8581,10629,12612,12612,10629,10597,10629,12677,12677,10597,10564,6339,8419,6338,6306,8419,6338,10499,6370,6338,10499,4225,2145,4193,4225,4225,2145,2145,2145,2113,32,2113,4193,2113,255},
{392,392,392,392,392,424,424,424,424,425,425,425,425,425,425,425,425,425,457,457,457,457,457,457,457,457,490,489,490,490,490,490,490,490,490,490,522,522,522,522,522,522,522,522,522,522,522,522,555,555,555,555,555,555,555,555,555,587,587,587,587,587,2636,2636,2636,620,620,620,620,620,620,2668,2668,2700,2700,2700,2700,2700,4749,4748,4749,4749,4781,2733,4781,4781,2733,4781,4781,4813,4813,4813,4813,4813,4845,4845,6893,6893,6893,6893,6893,6893,6926,6926,6926,8974,8974,8974,9006,9006,11054,11054,11086,11086,11086,11086,13134,13134,13167,13167,13166,13166,13167,15246,15246,15246,15246,15247,17326,17326,17326,17326,17326,19374,19374,19374,19374,19374,19374,21389,8516,4290,6371,6371,6371,6339,8581,10629,12644,12612,10629,10597,10629,12677,12677,10629,10564,8451,8451,8451,6371,6371,8419,10531,6338,6338,8419,4225,4225,2145,2145,4225,2145,2112,2145,2112,2112,4193,4193,4193,255},
{392,392,392,424,424,424,424,424,424,425,425,425,425,425,425,425,425,425,457,457,457,457,457,457,457,458,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,522,522,522,522,522,522,555,555,555,555,555,555,555,555,555,555,587,587,587,587,587,2636,2636,2636,620,620,620,620,620,620,2668,2668,2700,2700,2700,2700,4749,4749,4748,4748,4748,2733,2733,2733,2733,2733,4781,4781,4813,4813,4813,4813,4813,4845,6893,6893,6893,6893,6893,6894,6894,6926,6926,8974,8974,8974,9006,9006,11054,11054,11054,11086,11086,11086,13134,13134,13134,13167,13167,13167,13167,15215,13166,15246,15246,15247,15247,17326,17326,17326,17326,17326,19374,19374,19374,19374,19406,19374,21389,8484,6306,6338,8419,10531,8451,10596,8484,12644,12644,10629,10629,12677,10629,10629,10629,10597,10564,8516,10596,8484,6371,6403,4258,2178,2145,2145,2145,4225,2145,2145,4225,2145,4193,4193,4225,4193,4225,4225,4225,255},
{392,392,392,424,424,424,424,424,424,425,425,425,425,425,425,425,425,425,457,457,457,457,457,457,457,458,490,490,490,490,490,490,490,490,490,490,522,522,522,523,522,523,522,522,522,522,522,555,555,555,555,555,555,555,555,555,555,587,587,587,587,588,2636,588,620,620,620,620,620,620,2668,2668,2668,2700,2700,2700,2700,2700,4749,4749,4748,2701,2733,2733,2733,2733,2733,4781,4813,4813,4813,4813,4813,4845,4845,6893,6893,6893,6893,6893,6926,6926,6926,6926,8974,8974,9006,9006,9006,9006,11054,11054,11086,11086,11086,13134,13134,13167,13167,13167,13167,13167,15215,15214,15247,15247,15247,15246,15278,17326,17327,17326,17326,19374,19374,19374,19406,19406,19374,19373,17065,19113,19177,21290,21323,21323,21258,21290,12742,8549,8581,10629,10629,10629,10629,10629,10629,10629,10629,10629,12677,12677,10564,10531,10467,10498,10499,4225,4225,2145,2113,2145,2145,4193,4225,4225,2145,2145,4225,4193,255},
{392,392,392,424,424,424,424,424,425,425,425,425,425,425,425,425,425,457,457,457,457,457,457,457,457,458,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,522,522,522,523,523,555,555,555,555,555,555,555,555,587,587,587,587,587,587,2636,2636,620,620,620,620,620,620,2668,2668,2700,2700,2700,2700,2700,4749,4748,4748,4748,2733,2733,2733,2733,2733,2733,4813,4813,4813,4813,4813,4813,4845,4845,6893,6893,6893,6893,6894,6926,6926,6926,8974,8974,8974,9006,9006,9006,9006,9006,9006,11086,11086,11086,13134,13134,13134,13167,13167,13167,13167,15215,15246,15247,15247,15246,15247,15278,17327,17327,17326,17326,19374,19406,19374,19406,21454,19406,19373,21454,21454,21453,21453,21453,21453,23501,23501,14855,12709,14822,14854,16902,16902,16934,18982,18982,18982,16934,18982,16902,16902,16869,14789,12644,10531,8451,4226,2145,2145,4225,4225,4193,4225,6305,2112,2112,2145,4225,4225,255},
{392,392,392,424,424,424,424,424,425,425,425,425,425,425,425,425,425,457,457,457,457,457,457,457,457,458,490,490,490,490,490,490,490,490,490,522,522,522,522,523,523,522,522,522,522,522,522,523,555,555,555,555,555,555,555,555,555,587,587,587,587,587,2636,2636,620,620,620,620,620,620,2668,2668,2668,2700,2700,2700,2700,2700,2700,4748,4749,2733,2733,2733,2733,2733,2733,4813,4813,4813,4813,4813,4813,4845,4845,6893,6893,6893,6893,6894,6926,6926,6926,8974,8974,9006,9006,9006,9006,9006,9006,9006,9006,11086,11086,13134,13134,13167,13167,13167,13167,13167,15247,15247,15247,15247,15247,15279,15278,17326,17327,17326,17326,19374,19406,19406,19406,21454,21454,21454,21454,21453,21453,21453,21453,21453,23501,23468,21160,19047,16837,14789,12742,12709,10661,10629,10597,8548,8516,8484,6436,6403,6403,6338,6306,8418,4226,4225,2145,2145,4193,4225,4193,4225,2145,2112,2112,2112,4225,4225,255},
{392,392,424,424,424,424,424,424,425,425,425,425,425,425,425,425,425,457,457,457,457,457,457,457,457,490,490,490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,555,587,587,587,2636,2636,620,620,620,620,620,620,620,2668,2700,2700,2700,2700,2700,2700,653,653,4748,2701,2733,2733,2733,2733,2733,4781,4781,4781,4813,4813,4813,4845,4845,4845,6893,6893,6893,6893,6926,6926,6926,6926,6926,8974,8974,9006,9006,9006,9006,9006,9006,9038,11086,11086,11086,13134,13167,13167,13167,13167,13167,15215,15246,15247,15247,15247,15279,15278,17327,17327,17326,17326,19374,19406,19406,21454,21454,21454,21454,21486,21454,21453,21453,21453,23501,23501,23501,23501,23371,14692,6371,4290,4258,4258,4258,4226,4226,4226,4226,4226,6306,4225,2113,6338,12579,2145,4225,4193,2145,4225,4225,4225,2113,2112,2112,2113,2112,4193,4225,255},
{392,392,424,424,424,424,424,425,425,425,425,425,425,425,425,425,425,457,457,457,457,457,457,458,458,458,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,555,555,587,587,587,2636,2636,588,620,620,620,620,620,620,2668,2700,2700,2700,2700,2700,652,652,2700,2700,2701,2733,2733,2733,2733,4781,4781,4781,4813,4813,4813,4813,4813,4845,6893,6893,6893,6893,6893,6926,6926,6926,6926,6926,6926,8974,9006,9006,9006,9006,9006,9006,11086,11086,11086,11086,13134,13167,13167,13167,13167,13167,15247,15247,15247,15247,15247,15279,15278,17327,17327,17326,17326,19374,19406,19406,19406,21454,21454,21454,21486,21486,21453,21453,23501,23501,23501,23501,23501,23468,16805,8386,6338,10498,10531,12579,12579,12611,14691,14691,16739,16772,14659,2145,8418,10531,2145,4193,2145,2113,2145,4193,2145,2112,2113,2145,2113,2145,2145,2145,255},
{392,424,424,424,424,424,424,425,425,425,425,425,425,425,425,425,425,457,457,457,457,457,457,458,458,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,555,555,555,587,587,588,2636,588,620,620,620,620,620,620,2668,2668,2668,2700,2700,652,652,653,2700,2701,2733,2733,2733,2733,2733,4781,4781,4813,4813,4813,4813,4813,4813,6861,6893,6893,6893,6893,6894,6926,6926,6926,6926,8974,8974,9006,9006,9006,9006,9006,9006,9006,11086,11086,11086,11086,13166,13167,13167,13167,13167,13199,13199,15247,15247,15247,15247,15279,15279,17327,17327,17326,17326,19406,19406,19406,21454,21454,21454,21486,21486,21486,21485,21453,23501,23501,23501,23501,23500,23436,16805,10498,16804,20997,20997,20997,20997,20997,20997,20997,18916,18884,16772,2113,6306,10531,2113,4193,2145,2113,4193,4193,2145,2112,2113,32,32,2112,2145,2113,255},
{392,424,424,424,424,424,424,425,425,425,425,425,425,425,425,425,425,457,457,457,457,457,458,458,490,490,490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,555,555,587,587,587,2636,2636,2636,620,620,620,620,620,620,2668,2668,2668,2668,2700,652,2700,652,653,2701,2701,2733,2733,2733,2733,4781,4781,4813,4813,4813,4813,4813,6861,6893,6893,6894,6893,6893,6894,6926,6926,6926,6926,8974,8974,9006,9006,9006,9006,9006,9006,11086,11086,11086,11086,11118,11118,13167,13167,13167,13167,13199,15247,15247,15247,15247,15279,15279,15279,15279,17327,17326,17326,17358,19406,19407,21454,21454,21486,21486,21486,21486,21485,21453,23501,23501,23501,23501,23500,23468,16805,8418,12611,12644,10563,10531,8451,8418,6338,6338,4258,4225,4225,4193,8418,12579,2145,4225,2145,2113,4193,4193,2112,4225,2145,32,32,2080,4193,2113,255},
{392,392,424,424,424,424,424,425,425,425,425,425,425,425,425,425,425,457,457,457,457,457,458,458,490,489,490,490,490,490,490,490,490,522,522,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,555,555,555,587,587,587,588,588,2668,620,2668,620,620,620,620,2668,2668,2700,2700,2700,653,653,2701,2701,2701,2733,2733,2733,2733,2733,4781,4781,2765,2765,4813,4813,4813,4813,6893,4846,4846,6893,6893,6894,6926,6926,6926,6926,8974,9006,9006,9006,9006,9006,9006,9006,11086,11086,11086,11086,11118,11118,13167,13167,13167,13167,13199,13199,15247,15247,15247,15279,15279,15279,15279,17327,17327,17358,17358,19406,19407,21454,21454,21486,21486,21486,21486,21485,21453,23501,23501,23501,23469,23468,23468,16837,6306,2177,2145,2145,2145,2113,2145,2145,2145,2145,4193,4225,2113,6338,12579,2145,4193,2145,2145,6273,4225,2112,2112,2112,32,32,2112,4193,2112,255},
{392,424,424,424,424,424,424,424,425,425,425,425,425,425,425,425,425,457,457,457,457,457,457,457,489,489,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,555,555,555,587,587,587,588,620,620,620,620,2668,2668,620,620,620,2668,2700,652,653,653,652,2701,2701,2701,2733,2733,2733,2733,2733,4781,4781,2765,2765,4813,4813,4813,4845,4845,4846,4846,4846,6893,6893,6926,6926,6926,6926,8974,8974,9006,9006,9006,9006,9006,9006,11086,11086,11086,11086,11118,11118,11119,13167,13167,13199,13199,15247,15247,15247,15279,15279,15279,15279,15279,17327,17327,17358,17358,19406,19407,21454,21454,21486,21486,21486,21486,21486,23533,23501,21453,21421,23468,23500,23436,16805,8386,6306,8386,8418,10466,10499,10499,10498,12579,12611,14691,12579,2145,8418,12579,2145,4193,2145,2113,4193,2145,2112,32,2080,2112,32,2112,4193,2112,255},
{392,424,424,424,424,424,424,424,425,425,425,425,425,425,425,425,457,457,457,457,457,457,457,489,490,490,490,490,490,490,490,490,490,522,522,522,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,587,587,587,587,2636,588,620,620,620,620,2668,2668,620,2668,2668,2668,2668,652,653,652,652,652,653,2733,2701,2733,2733,4781,2733,4781,4781,4813,4813,4813,4813,4813,4846,4846,4846,4846,4846,6894,6894,6926,6926,6926,6926,8974,8974,9006,9006,9006,9006,9006,9006,9038,11086,11086,11118,11118,11118,11119,13167,13167,13167,13199,13199,15247,15247,15247,15279,15279,15279,17327,17327,17358,17358,17358,19406,19407,19406,21454,21454,21486,21486,21486,21485,21453,21453,21453,21421,23468,23468,23468,19047,10466,16772,20997,20965,20997,20997,20997,20965,20965,18917,18916,16772,2145,6306,12579,2145,2145,4193,2113,4225,12578,4193,2113,4225,6306,6305,6273,4193,2112,255},
{392,424,424,424,424,424,424,425,425,425,425,425,425,425,425,425,457,457,457,457,457,457,457,490,490,490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,555,587,587,587,587,587,2636,588,588,620,620,620,2668,2668,2668,2668,2668,2700,2668,652,652,652,652,653,2701,2701,2733,2733,2733,2733,4781,2765,4813,4813,4813,4813,4813,4845,4845,4846,4846,4846,4846,4846,6894,6926,6926,6926,8974,8974,9006,9006,9006,9006,9006,9006,9006,9038,11086,11086,11086,11118,11119,11119,13167,13167,13199,13199,15247,15247,15279,15247,15279,15279,15279,17327,17327,17359,17358,19406,19407,19407,21454,21454,21486,21486,21486,21486,21485,21453,23501,21453,23469,23468,23468,23468,21290,10466,10531,12644,10563,10531,8451,8418,6338,6338,4258,4258,4258,4225,8418,12579,4225,4193,2145,2145,12611,29447,12579,2112,4225,6306,6305,4225,4225,2113,255},
{424,424,424,424,424,424,424,425,425,425,425,425,425,425,425,425,457,457,457,457,457,457,457,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,522,523,523,523,523,555,555,555,555,555,555,555,555,555,555,555,587,587,587,587,587,587,2636,620,620,620,620,2668,2668,2668,2668,2668,2700,652,652,652,652,653,2701,2701,2701,2733,2733,2733,2733,4781,4781,4813,4813,4813,4813,4813,4845,4846,4846,4846,4846,4846,6894,6926,6926,6926,6926,8974,8974,8974,9006,9006,9006,9006,9006,9006,11086,11086,11086,11086,11118,11119,11119,13167,13167,13199,13199,15247,15247,15247,15279,15279,15279,15279,17327,17327,17359,17359,19406,19406,19407,21454,21454,21486,21486,21486,21486,21485,21453,23501,23501,23501,23501,23468,23468,21258,8386,2145,2145,2145,2145,2145,2145,2145,4193,4193,4193,4225,2113,6338,12611,2145,2145,2145,4193,4225,4258,4226,2112,2113,6338,10499,4193,4193,2145,255},
{424,424,424,424,424,424,424,424,425,425,425,425,425,425,425,457,457,457,457,457,457,457,457,458,490,490,490,490,490,490,490,490,522,522,522,522,522,522,522,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,555,587,587,587,587,587,587,2636,588,620,620,2668,2668,2668,2668,2668,2668,652,652,652,653,652,653,2701,2701,2733,2701,2733,2733,2733,4781,4781,4813,4813,4813,2797,2797,4845,4846,4846,4846,6894,6894,6893,6926,6926,6926,6926,8974,8974,9006,9006,9006,9006,9006,9006,11086,11086,11086,11086,11086,11118,11118,11119,11151,13199,13199,13199,15247,15279,15279,15279,15279,15279,15279,15311,17327,17359,17359,19406,19407,19407,21454,21454,21486,21486,21486,21486,21485,23533,23501,23501,23501,23501,23468,23468,23338,10467,6306,8418,10466,10499,12579,12579,14659,14691,16739,16739,16739,10466,16739,20932,12546,4226,6338,6305,6305,6306,4225,32,12611,12547,6273,4193,4193,4193,255},
{424,424,424,424,425,424,424,425,425,425,425,425,425,425,425,425,457,457,457,457,457,457,457,457,490,490,490,490,490,490,490,490,522,522,522,522,522,522,522,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,555,587,587,587,587,587,2636,2636,620,620,620,2668,2668,2668,2668,2668,2668,652,652,653,653,653,653,2701,2733,2733,2733,2733,2733,2733,4781,4781,4813,4813,2765,2765,2797,4846,4846,4846,4846,4846,6926,6894,6926,6926,6926,6926,8974,8974,6958,6958,9006,9006,9006,9006,11086,11086,11086,11086,11086,11118,11118,11119,13199,13199,13199,13199,15247,15279,15279,15279,15279,15279,15279,15311,17359,17359,17359,19406,19407,19407,21454,21486,21486,21486,21486,21486,23533,23533,23533,25581,25581,27628,27596,27596,27498,20964,25157,29350,29350,29382,31430,29382,29382,29350,29350,27270,27302,27302,27270,27302,33575,14659,6338,6305,6306,6306,6306,32,33738,56687,16739,4193,4193,4193,255},
{392,424,424,424,424,424,424,425,425,425,425,425,425,425,425,457,457,457,457,457,457,457,457,457,489,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,555,555,523,555,555,555,555,555,555,555,555,587,587,587,587,587,587,588,588,620,620,620,620,2668,2668,2668,2668,2668,652,652,652,653,653,2701,2701,2733,2733,2733,2733,2733,2733,4781,4781,4813,2765,2765,2765,4845,4846,4846,4846,4846,4878,4878,6926,6926,6926,6926,6926,6958,6958,6958,9006,9006,9006,9038,9038,9038,11086,11086,9038,11086,11118,11118,11119,13199,13199,13199,13199,15279,15279,15279,15279,15279,15279,15311,15311,17359,17359,17359,19406,19406,19407,21454,21487,21486,21486,21486,23534,37964,33804,29578,29545,27433,27368,27367,25254,25222,25222,25254,27334,27334,27302,27270,29350,29382,29382,29382,31430,31462,31430,31462,33543,21029,10498,6305,4225,6274,4225,4225,4193,19111,33901,12676,2145,4225,4193,255},
{424,424,424,424,424,424,425,425,425,425,425,425,425,425,425,457,457,457,457,457,457,457,457,457,457,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,555,587,587,587,587,587,588,588,588,620,620,2668,620,2668,2668,2668,620,2668,2700,652,652,653,653,653,2701,2701,2733,2733,2733,2733,2733,2765,2765,2765,2765,2797,4846,4845,4846,4846,4846,4846,4878,4878,6926,6926,6926,6926,6926,6958,6958,9006,9006,9006,9006,9038,9038,9038,11086,11086,11086,11086,11118,11118,11119,11119,13199,13199,15247,15279,15279,15279,15279,15279,15279,15311,15311,17359,17359,17359,19407,19406,19407,21454,21487,21487,21486,27661,37801,41895,39848,29415,29415,31495,31462,31495,31430,31462,33510,33542,33575,33542,33542,33542,35622,33542,33510,31461,33510,33510,31429,31429,33510,23077,6338,4257,4225,4225,6306,4225,6306,4193,32,2145,4225,4225,4193,255},
{424,424,424,424,424,424,424,425,425,425,425,425,425,425,425,457,457,457,457,457,457,457,457,457,457,490,490,490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,555,555,587,587,587,587,588,620,620,620,620,2668,2668,2668,2668,620,620,2668,2668,2668,652,653,653,2701,2701,2733,2733,2733,2733,2733,2733,2765,2765,2765,2765,2797,4846,4845,4846,4846,4846,4846,4878,4878,6926,6926,6926,6926,6926,6958,9006,9006,9006,9006,9038,9038,9038,9038,11086,11086,11086,11118,11118,11118,11119,11119,13199,13199,15247,15279,15279,15279,15279,15279,15279,15311,17359,17359,17359,17359,19407,19406,19407,21455,21487,21487,21487,23338,27204,33445,33542,31430,31430,31429,31430,31429,31430,31429,33542,33542,33575,31462,31462,31462,31463,29414,27334,25222,25189,23142,21029,18916,16836,14756,6306,4225,2145,4225,4258,4225,6306,4225,4225,6273,4225,4193,4193,255},
{392,424,424,424,424,424,425,425,425,425,425,425,425,425,425,457,457,457,457,457,457,457,457,457,457,490,490,490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,587,587,587,587,587,588,588,588,620,620,620,2668,2668,620,620,620,652,2668,2700,2700,652,653,653,2701,2733,2733,2733,2733,2733,685,2765,2765,2765,2765,2765,2765,4845,4845,4845,4846,4846,4846,6926,6926,6926,6926,6926,6926,6926,6958,9006,9006,9006,9006,9038,9038,9038,9038,9038,11086,11086,11086,11118,11119,11119,13167,13199,13199,13199,15279,15279,15279,15279,17327,15279,15311,17359,17359,17359,17359,19439,19407,19439,21487,21487,21487,23566,29449,20964,27302,25254,25222,23142,21061,21029,18949,16836,14756,12676,12644,10564,8451,6370,6371,6338,6338,4258,4258,4226,4225,4258,4225,6306,6338,4258,4225,4225,4193,10498,8386,6305,2112,2145,4225,4193,2145,4193,255},
{2440,392,424,424,424,424,425,425,425,425,425,425,425,425,457,457,457,457,457,457,457,457,457,457,490,490,490,490,490,490,490,490,490,522,522,522,523,523,523,522,523,523,523,555,555,555,555,555,555,555,555,555,555,555,587,587,588,588,587,588,588,620,620,2668,2668,2668,620,620,620,652,652,652,652,653,653,653,2701,2701,2733,685,685,685,685,717,2765,2765,2765,2765,2765,4845,4845,4846,4846,4846,4846,4878,4878,6926,6926,6926,6926,6926,9006,9006,9006,9006,9006,9038,9039,9039,9039,9038,11086,11086,11086,11118,11119,11119,13167,13199,13199,15247,15279,15279,15279,15279,15279,17327,17359,17359,17359,17359,17359,19439,19439,19439,21487,21487,19438,29774,46155,12579,6339,4258,4258,4258,4225,4226,6306,4226,4226,4226,6306,6306,6306,6306,8386,8386,8354,8386,8386,10466,10466,10498,12546,14756,10563,6305,6338,14691,6306,16804,10531,12546,8353,4193,2112,4193,4193,4193,255},
{392,424,424,424,424,424,425,425,425,425,425,425,425,425,457,457,457,457,457,457,457,457,457,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,555,587,587,588,588,588,588,588,588,588,620,2668,2668,620,620,620,652,652,652,652,652,653,653,653,2701,2701,2733,2733,2733,685,2733,685,2765,2765,2765,2765,2765,4845,4845,4846,4846,4846,4878,4878,4878,6926,6926,6926,6926,6926,6958,9006,9006,9006,9006,9038,9039,9039,9039,9038,11086,11086,11118,11118,11119,11119,13199,13199,13199,13199,15279,15279,15279,15279,15279,17327,17359,17359,17359,17359,17359,19439,19439,19439,21487,21487,19407,33902,52395,16707,14659,10466,10434,10498,12546,12546,14627,14659,14659,16739,16739,18819,16771,18819,18851,18851,16771,16771,16803,16803,16804,14723,16901,12966,10563,4193,2145,2113,4225,8386,6338,16803,12578,4193,2112,4193,2145,4225,255},
{2440,424,424,424,424,425,425,425,425,425,425,425,425,425,425,457,457,457,457,457,457,457,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,522,523,523,555,555,555,555,555,555,555,555,555,555,555,587,587,588,588,587,588,620,620,620,2668,620,620,620,620,620,652,652,652,652,653,653,653,653,2701,2701,2701,2733,2733,2733,2733,2733,2765,2765,2765,2765,4845,4845,4845,4846,4846,4846,4846,4878,4878,6926,6926,6926,6926,6958,6958,9006,9006,9006,9007,9038,9039,9039,9039,9038,11086,11086,11118,11118,11119,11119,13199,13199,13199,13199,15279,15279,15279,15279,15279,17327,17359,17359,17359,17359,17391,19439,19439,19439,21487,21487,21487,21323,33575,31462,25156,20964,18884,18884,16804,14724,14724,14724,12643,10563,10531,8451,8451,6371,6338,4290,4258,4258,4226,2178,2178,4194,16997,19237,8483,6306,6306,4225,6306,8386,6338,14691,16739,12546,4193,2145,2112,4193,255},
{392,424,424,424,424,425,425,425,425,425,425,425,425,425,457,457,457,457,457,457,457,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,587,588,588,588,588,588,620,620,620,620,620,620,620,620,652,652,652,652,653,653,653,2701,2701,2701,2733,685,685,685,685,2765,2765,2765,2765,2765,4845,4845,4846,4846,4846,4878,4878,4878,6926,6926,6926,6926,6926,6958,9006,9006,9006,9006,9007,9039,9039,9039,9039,9038,11118,11119,11118,11118,11119,11119,13199,13199,13199,15247,15279,15279,15279,15279,15279,17327,17359,17359,17359,17359,19439,19439,19439,19439,21487,21487,21519,21291,12611,4258,4226,2210,2210,2178,2178,2146,2146,2146,2146,2146,2146,2146,2146,4226,4226,4226,4226,4226,4226,4226,4226,6338,21253,23073,10531,12611,2113,2113,10466,10466,16837,31528,23044,16706,18786,10433,4193,2112,255},
{392,424,424,424,424,425,425,425,425,425,425,425,425,425,457,457,457,457,457,457,458,458,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,522,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,587,587,587,588,588,588,620,620,620,620,620,620,620,620,620,620,652,652,652,653,653,2701,2701,653,685,2733,685,2733,685,685,2765,2765,2765,2765,4846,4846,4846,4846,4846,4846,4846,4878,6926,6926,6926,6926,6926,6926,6958,9006,9006,9006,9007,9007,9038,9039,9039,9039,9038,11118,11119,11119,11118,11119,13199,13199,13199,13199,13199,15279,15279,15279,15279,15311,17327,17359,17359,17359,17359,19439,19439,19439,19439,21487,21487,21487,21454,16968,4226,2178,2178,2178,4258,4258,4258,4258,4258,4258,4258,6306,4258,6306,6338,6306,4258,6306,4226,4258,4258,4225,4226,10531,18884,33576,37736,35590,37702,39815,37767,37800,23109,18851,18819,31363,33411,8385,32,255},
{424,424,424,424,425,425,425,425,425,425,425,425,457,425,457,457,457,457,457,458,490,490,490,490,490,490,490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,587,587,587,587,588,588,588,620,620,620,620,620,620,620,620,620,620,652,652,652,652,653,2701,2701,2701,685,685,685,685,685,685,2765,2765,2765,2765,4846,4845,4845,4846,4846,4846,4846,4878,6926,6926,6926,6926,6926,6926,6958,9006,9006,9006,9007,9007,9039,9039,9039,9039,9038,11119,11119,11118,11119,11119,13199,13199,13199,13199,15247,15279,15279,15279,15311,15311,17359,17359,17359,17359,17391,19439,19439,19439,19439,21487,21487,21486,21519,19211,16903,14692,12612,10532,6371,6306,6306,4258,4226,4258,4258,6306,6306,6306,6306,6306,6306,10531,16837,18917,18950,18917,10466,29382,42059,56816,56750,54637,54637,39913,29415,33575,23011,16707,14658,25091,29251,6273,2113,255},
{424,424,424,425,425,425,425,425,425,425,425,425,425,457,457,457,457,457,457,458,458,490,490,490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,587,588,588,588,588,588,620,620,2668,2668,620,620,620,620,620,620,652,652,653,653,653,2701,2701,2701,685,685,685,685,2733,2733,2765,2765,2798,2798,2798,4846,4846,4846,4846,4846,4878,4878,6926,6926,6926,6926,6926,9006,6958,9006,9006,9006,9007,9039,9039,9039,9039,9039,11086,11118,11119,11118,11118,11119,13199,13199,13199,13199,15247,15279,15279,15279,15311,15311,17359,17359,17359,17391,17391,19439,19439,19439,19439,21487,21487,21487,21486,21486,21291,23110,21030,14822,12677,10564,10596,12677,12709,14757,12677,14789,14790,14725,12677,12644,18885,23239,29383,23045,23012,20900,18754,14594,23012,50543,56751,54605,54604,50379,35558,27074,35525,16771,18787,29283,37635,6273,2145,255},
{424,424,424,424,424,425,425,425,425,425,425,425,457,457,457,457,457,457,457,458,458,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,555,587,587,588,588,588,588,620,620,2668,2668,620,620,620,620,620,652,652,652,652,653,2701,2701,2701,2701,685,685,685,685,2733,2765,2765,2765,2765,2798,4846,4846,4846,4846,4846,4846,4878,6926,4878,4878,4878,6926,6926,6958,9006,9006,9006,9007,9007,9039,9039,9039,9039,9039,11086,11119,11119,11119,11119,13199,13199,13199,13199,13199,15247,15279,15279,15279,15311,15311,17359,17359,17359,17391,17391,19439,19439,19439,19439,21487,21487,21519,21519,21551,21290,25190,21062,14822,14822,12742,12742,14822,14854,14854,12710,14822,14790,14757,12677,12644,25223,23239,27141,18819,20834,14626,18754,14594,27172,54736,58929,56783,56718,56717,37736,8353,10531,16771,18851,27171,31331,4193,2112,255},
{424,424,424,424,425,425,425,425,425,425,425,425,425,457,457,457,457,457,458,458,458,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,587,587,588,588,588,588,620,620,620,2668,2668,620,620,620,620,652,652,652,652,653,653,2701,653,653,685,685,685,685,685,2765,2765,2765,2765,2765,2798,4846,4846,4846,4846,4846,4846,4878,4878,4878,4878,4878,4878,4878,6958,6959,9007,9006,9007,9007,9039,9039,9039,9039,9039,11118,11119,11119,11119,11119,13199,13199,13199,13199,13199,13199,15279,15279,15279,15311,15311,17359,17359,17359,17391,17391,19439,19439,19439,19439,21487,21519,21519,21519,21551,21323,25255,21062,12710,12710,10597,10629,12710,12742,14790,10597,12709,12644,12676,12644,10564,14789,21094,25028,16739,20802,12546,18722,12513,44009,44204,37898,35754,33640,33640,21029,4161,6273,20931,20964,29283,29284,4225,2112,255},
{424,424,424,424,424,425,425,425,425,425,425,425,457,457,457,457,457,457,458,458,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,587,587,588,588,588,588,588,588,620,620,2668,620,620,620,620,620,652,652,652,652,653,653,653,653,685,685,685,685,685,685,685,2765,2765,2798,2798,2798,2798,4846,4846,4846,4846,4878,4878,4878,4878,4878,4878,4878,6958,6959,6958,6958,9006,9006,9038,9038,9039,9039,9039,9039,11118,11119,11119,11119,11119,13199,13199,13199,13199,13199,13231,15279,15279,15279,15311,15311,17359,17359,17359,17391,17391,19439,19439,19439,19439,21519,21519,21519,21519,21519,23566,25516,23208,16935,14823,14790,14822,19015,19048,19080,33674,31561,21094,18950,18982,16869,25320,25288,25028,16739,20802,14562,18722,14594,44074,39913,33607,35720,37832,27302,10466,6273,8354,18852,16771,18819,18884,4225,2112,255},
{424,424,424,425,425,425,425,425,425,425,425,425,457,457,457,457,457,457,457,458,490,490,490,490,490,490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,587,588,588,588,588,588,620,620,620,2668,620,620,620,620,620,652,652,652,652,653,653,653,685,685,685,685,685,685,685,717,2765,2765,2798,2798,2798,2798,2798,2798,4846,4846,4846,4878,4878,4878,4878,4878,4878,6958,6958,6958,6958,9006,9006,9007,9038,9038,9039,9039,9039,11119,11119,11119,11119,11119,13199,13199,13199,13199,13199,13231,15279,15279,15279,15311,15311,17359,17359,17391,17391,17391,19439,19439,19439,21519,21519,21519,21519,21519,21551,23599,23599,25549,25549,23501,25548,25548,25581,25581,25580,35916,23240,10629,8451,8451,8451,16966,25320,24995,22883,22882,20802,20802,16674,14723,16901,14789,14756,12644,6338,4225,6338,10466,6305,6306,8386,6338,4225,2112,255},
{424,424,424,425,425,425,425,425,425,425,425,425,457,457,457,457,458,458,458,458,458,458,490,490,490,490,490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,587,587,588,588,588,588,588,620,620,620,2668,620,620,620,620,652,652,652,652,652,653,653,653,685,685,685,685,685,685,685,717,2765,2765,2798,4846,4846,2798,2798,2798,4846,4846,4878,4878,4878,4878,4878,4878,4878,6958,6959,6959,6958,6958,9006,9007,9038,9039,9039,9039,9039,11119,11119,11119,11119,11151,11151,13199,13199,13199,13231,13231,13231,15279,15279,15311,15311,17359,17359,17391,17391,17391,19439,19471,19439,19471,21519,21519,21519,21551,21551,23599,23599,23598,23598,25614,25614,23566,23565,23533,25613,21160,8451,4258,4258,4258,4258,10596,18949,10466,10466,8354,6305,4193,4193,4193,4225,4225,4226,6370,4193,2145,8418,10499,2113,4225,2145,2145,4193,2112,255},
{424,424,425,425,425,425,425,425,425,425,425,457,457,457,457,457,457,458,458,458,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,587,587,588,588,588,588,588,620,620,620,620,620,620,620,620,652,652,652,652,653,653,653,653,685,685,685,685,685,685,685,2765,2765,2765,2765,4846,4846,2798,2798,4846,4846,4846,4846,4878,4878,4878,4878,4878,6926,6958,6958,6959,6959,6958,9006,9007,9039,9039,9039,9039,11119,11119,11119,11119,11119,11151,11151,11151,13199,13231,13231,13231,13231,15279,15279,15311,15311,17359,17359,17391,17391,17392,19472,19471,19471,21519,21519,21519,21551,21551,21551,23599,23599,23598,25646,25646,25646,25646,25646,25613,25613,12742,2145,2145,2145,2145,2145,8483,12644,6274,8418,6338,4258,2145,2145,8386,8354,8354,6306,8450,6306,4225,6338,8418,2145,4225,4193,4225,4225,2112,255},
{424,424,425,425,425,425,425,425,425,425,425,457,457,457,457,457,457,458,458,458,490,490,490,490,490,490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,587,588,588,588,588,588,620,620,2668,2668,620,620,620,620,652,652,652,652,652,653,653,685,685,685,685,685,685,685,2733,2765,2765,2765,2765,2798,2798,2798,2798,4846,4846,4846,4846,4878,4878,4878,4878,6926,6926,6958,6959,6958,6958,6958,6958,9039,9039,9039,9039,9039,11087,11119,11119,11119,11119,11119,11151,11151,13199,13231,13231,13231,13231,15280,15279,15311,15311,17359,17391,17391,17392,19472,19472,19472,19472,21520,21520,21551,21551,21551,21551,21518,21518,21486,21485,21453,21420,21388,19307,19275,19242,12742,8516,10596,10597,10596,10596,12677,12677,12709,14789,14789,14789,12741,10564,10532,10563,8419,10498,18884,6338,4225,6305,8418,2145,4225,4225,4193,2145,2112,255},
{424,424,425,425,425,425,425,425,425,425,425,425,457,457,457,457,457,458,458,458,490,490,490,490,490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,555,555,587,588,588,588,588,588,620,620,2668,2668,620,620,620,620,652,652,652,652,653,653,653,685,685,685,685,685,685,685,2733,2765,2765,2765,2798,2797,2797,2798,2798,2798,4846,4846,4846,4878,4878,4878,4878,6926,6958,6958,6958,6959,6958,6958,6990,9039,9039,9039,9039,9039,9071,11119,11119,11119,11119,11151,11151,11151,13199,13231,13231,13232,13231,15279,15311,15311,15311,15311,17359,17359,17359,17359,17326,17326,15148,13002,12970,12970,12937,12905,12904,12872,12871,12839,12839,12807,12807,12806,12774,12774,12774,12806,12807,12807,12806,12806,12806,14854,14854,14854,14854,14822,14822,14822,12677,6371,10531,10531,10498,20964,10498,4225,6306,6306,2145,4193,4225,2145,2145,2112,255},
{424,424,425,425,425,425,425,425,425,425,425,425,457,457,457,457,457,457,458,458,490,490,490,490,490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,555,587,588,588,588,588,588,588,588,620,2668,620,620,620,620,620,652,652,652,652,653,653,653,653,685,685,685,685,685,717,2765,2765,717,2765,2766,2797,2798,2798,2798,4846,4846,4846,4878,4878,4878,4878,4878,6926,6958,6959,6958,6959,6958,6990,9038,9039,9039,9039,9039,9071,9071,11119,11119,11119,11119,11151,11151,13199,13199,13231,13231,13231,13232,15279,15311,15311,15312,10923,10793,10792,10760,10760,10760,10727,10727,10695,10727,10727,10727,10727,12775,12806,12806,12807,12807,12807,12807,12807,12807,12807,12807,12807,12807,12807,14855,12806,14854,14886,14854,14854,14854,14822,14822,14822,12677,8451,10531,10531,8418,18916,12643,6306,6306,6305,2145,4193,4193,2145,4225,2145,255},
{424,425,425,425,425,425,425,425,425,425,425,457,457,457,457,457,457,457,458,490,490,490,490,490,490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,555,587,588,588,588,588,588,620,620,620,620,620,620,620,620,652,652,652,652,653,653,653,653,685,685,685,685,685,685,717,2765,717,2765,2765,2766,2797,2798,2798,2798,4846,4846,4846,4878,4878,4878,4878,6926,6958,6959,6959,6958,6959,6958,6990,6990,9039,9039,9039,9071,9071,11119,11119,11119,11119,11119,11151,11151,13199,13199,13231,13231,13232,13232,15280,15311,15312,15246,10728,10695,10727,10727,10727,10727,10727,10759,10759,12807,10759,12807,12807,12807,12807,12807,12807,12807,12807,12807,12807,12806,12806,12807,12807,12806,12806,14854,14854,14854,14854,14854,14854,14854,14854,14854,14822,14789,12644,12676,10531,8450,18916,18950,12612,10466,6306,8418,6338,4225,2112,4225,2145,255},
{424,425,425,425,425,425,425,425,425,425,425,457,457,457,457,457,457,457,457,490,490,490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,555,555,587,588,588,588,588,620,620,2668,620,620,620,620,620,652,652,652,652,652,653,653,685,685,685,685,685,685,685,717,717,717,2765,2765,2797,2797,2798,2798,4846,4846,4846,4878,4878,4878,4878,6926,6926,6926,6959,6959,6958,6959,6958,6990,9039,9039,9039,9039,9071,9071,11119,11119,11119,11119,11119,11151,13199,13231,13231,13232,13232,13264,15312,15312,15312,15344,13003,10695,10727,10727,10727,10727,10727,10727,10727,10759,10759,10759,12807,12807,12807,12807,12807,12807,12807,14887,12839,12807,12807,12807,12807,14855,12807,12806,14854,12806,12806,14854,14854,14822,14854,14822,14822,14822,14789,12676,12644,10531,10498,16804,18950,23078,20932,6306,10531,8418,4193,2112,4225,2145,255},
{424,424,425,425,425,425,425,425,425,425,425,457,457,457,457,457,457,457,458,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,555,555,587,587,588,588,588,588,620,620,620,620,620,620,620,620,620,652,652,652,653,653,685,685,685,685,685,685,685,685,685,717,717,2765,2765,2798,2797,2798,2798,4846,4846,4846,4846,4878,4878,4878,4878,6926,6958,6959,6959,6959,6959,6958,9038,9039,9039,9039,9039,9071,9071,11119,11119,11119,11119,11151,11151,11151,11151,11119,13167,13166,13166,11086,13101,13101,13068,10792,10728,10760,10727,10727,10727,10727,10759,10759,10759,10759,10759,12807,12807,12807,12806,12806,12774,12774,12806,12806,12774,12774,12806,12806,12806,12806,12806,12806,12806,14854,14854,14854,14854,14854,14854,14854,14822,14821,14757,14724,10531,10499,16837,18982,29317,39523,12546,4258,4225,2145,2112,4225,2145,255},
{424,424,425,425,425,425,425,425,425,457,457,457,457,457,457,457,457,458,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,555,523,555,555,555,555,555,555,555,555,555,555,587,588,588,588,588,588,588,2668,620,620,620,620,620,620,652,652,652,652,653,653,685,685,685,685,685,685,685,2765,2733,717,717,717,2765,2766,2798,2798,4846,4846,4846,4846,4878,4878,4878,4878,4878,4878,6958,6959,6959,6958,6958,6990,9038,9039,9039,9039,9071,9071,9071,11119,11119,11119,11151,10989,8713,8713,8712,8712,8680,8680,8680,8647,8647,8647,8647,10695,10727,10727,10727,10727,10727,10727,10727,10727,10759,10759,12807,12807,12807,12807,12807,12839,12807,12807,12807,12807,12807,12807,12807,12774,12774,12806,12806,12774,12774,12774,12774,14822,14822,14822,14822,14821,14821,14789,14757,14724,12611,8418,16804,18950,27172,35395,12513,2145,4193,4193,2112,4225,2145,255},
{425,425,425,425,425,425,425,425,425,457,457,457,457,457,457,457,457,457,458,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,555,555,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,652,652,652,653,653,685,685,685,685,685,685,685,685,685,717,717,717,2765,2798,2798,2798,4846,4846,4846,4846,4878,4878,4878,4878,4878,6926,6958,6958,6959,6959,6958,6990,9039,9039,9039,9039,9071,9071,11119,11119,11119,11119,11119,8713,8615,8647,8647,8647,8680,8680,8680,8680,8680,8680,8680,8679,8680,10727,10727,10727,10727,10727,10727,10727,10727,10727,10727,10727,10727,10726,12774,12774,12806,12806,12807,14887,14886,14887,16935,16967,16967,16999,19047,19047,19079,21127,21127,21127,21127,21095,21095,19014,18982,16869,14756,14724,12643,12611,14691,14723,18883,37474,14594,2177,4225,2145,2112,4225,2145,255},
{425,425,425,425,425,425,425,425,425,457,457,457,457,457,457,457,457,458,458,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,555,523,555,555,555,555,555,555,555,555,555,555,587,588,556,588,588,588,588,588,620,620,620,620,620,620,620,620,652,652,652,653,653,653,685,685,685,685,685,685,685,2765,2765,2765,2765,2766,2798,2798,2798,4846,4846,4846,4846,4878,4878,4878,4878,4878,4878,6958,6958,6959,6959,6958,6991,9039,9039,9039,9071,9071,9071,11119,11119,11151,11151,8876,6567,8615,8615,8615,8647,8647,8647,8647,8647,10695,10727,10727,10727,12807,12807,12840,14920,14920,17000,17000,17032,19112,19113,19112,19112,19144,19144,19144,19144,21192,21192,21192,21192,19112,19079,19047,16999,14886,14822,12741,12741,12709,12676,10596,10596,10596,10563,10563,10563,10563,10499,6338,4225,4226,4258,4226,4258,10498,31235,12514,4225,4225,4193,2145,4225,2145,255},
{425,425,425,425,425,425,425,425,425,425,457,457,457,457,457,457,457,490,458,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,555,555,588,588,588,588,588,588,620,620,620,620,620,620,620,620,652,652,652,652,653,653,653,653,653,685,685,685,685,685,685,2765,2765,2765,2766,2798,4846,2798,4846,4846,4846,4878,4878,4878,4878,4878,6926,6958,6958,6958,6958,6958,6959,6991,9038,9039,9039,9071,9071,9071,11119,11119,11151,11119,14985,14953,17033,17033,17033,17065,17065,17065,17065,17097,19145,19145,19145,19145,19113,19113,19112,17032,17032,14952,14951,14951,17000,14951,14919,14951,14919,14919,14886,14919,16999,17032,19112,19144,19144,21257,23338,25450,23305,21224,23272,25385,27465,27497,27530,29642,31723,31787,33868,31755,31755,29643,14821,6338,6370,6338,6338,4258,23011,39522,12514,4258,4225,4225,2112,4225,2145,255},
{424,425,425,425,425,425,425,425,425,425,457,457,457,457,457,457,458,490,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,587,588,588,588,587,588,588,588,620,620,620,620,620,620,652,652,652,652,652,653,653,653,653,685,685,2733,685,685,685,717,717,717,2766,2765,2798,4846,4846,4846,4846,4846,4846,4846,4878,4878,4878,6926,6926,6958,6959,6958,6958,6991,9039,9039,9039,9039,9071,9071,9071,11119,11119,11151,10956,17000,14920,14953,14952,12872,12872,14952,14952,14952,14985,17065,17065,19146,17130,19210,19275,19307,21388,21420,23468,23500,25613,27693,23533,23533,25645,25677,27726,27758,27725,27725,27758,27725,25645,25613,25612,25580,25580,23467,21386,21354,21322,21321,19208,19208,19209,17096,19144,19144,14951,14951,14886,8451,4258,4258,4226,4226,8386,25091,43910,14659,6306,4225,4225,2112,4225,4193,255},
{424,425,425,425,425,425,425,425,425,425,457,457,457,457,457,457,458,458,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,587,588,588,587,587,588,588,620,620,620,620,620,620,620,652,652,652,652,652,653,653,653,685,685,2733,2733,2733,685,685,717,717,717,2766,2797,2798,4846,4846,4846,4846,4846,4845,2798,4878,4878,6926,6926,6926,6926,6958,6958,6959,9039,9039,9039,9039,9039,9071,9071,11119,11119,11119,11151,21453,23501,25581,25614,25679,25678,27759,27759,25678,27727,25710,25678,23598,23566,21485,21485,21485,19372,19340,19307,17227,17194,17194,17162,15049,15049,15017,15016,15017,17097,15016,14984,15016,14984,14984,14984,14984,14984,17064,16999,17031,14919,10628,8484,6403,6403,6403,6403,6403,6370,6338,4258,4258,4225,4225,4225,4225,4225,4225,14658,46122,16772,2145,4225,4193,2145,4225,4225,255},
{424,425,425,425,425,425,425,425,425,457,457,457,457,457,457,458,458,458,490,490,490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,555,523,555,555,555,555,555,555,555,555,555,587,588,588,588,588,587,588,588,620,620,620,620,620,620,620,652,652,652,652,652,653,653,653,653,685,685,2733,2733,685,717,717,2765,2766,2766,2798,2798,4846,4846,4846,4846,4813,4845,4846,4846,4878,6926,6926,6926,6926,6958,6959,6991,6991,9039,9039,9039,9039,9071,9071,9071,9071,11151,11151,17196,15115,15083,15050,15050,12970,12937,12937,12905,12905,12905,10857,10825,12905,12905,12905,12905,12937,12937,12937,12937,15017,15017,15049,15049,15049,15082,17130,17162,17162,17161,17193,17193,17161,17193,19242,17193,17161,19241,19209,14951,8516,4225,4225,4225,4225,4225,4225,4225,4225,4225,4225,4225,4225,4225,4225,2145,2145,2145,8386,39914,14659,2145,4225,4225,4193,4225,4225,255},
{424,425,425,425,425,425,425,425,425,457,457,457,457,458,458,458,458,458,490,490,489,489,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,555,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,652,652,652,653,653,653,653,685,685,2733,2733,2733,2733,717,717,717,2766,2766,2766,2798,4846,4846,4846,4845,4845,4845,4846,4846,4878,6926,6926,6926,6926,6958,6959,9006,9006,9006,9006,9006,8973,11021,11021,11021,11021,11020,10988,10857,10857,10857,10858,12938,12970,12970,12970,12970,13002,13002,13002,13002,13034,13034,13034,13034,15115,15114,15114,13034,15082,15082,15082,15114,17162,17195,17194,17194,17194,17162,17194,17226,17161,17161,17193,17161,17161,17161,19177,16999,8516,4226,4225,4225,4225,4225,2145,2145,4225,4225,4225,4225,4225,4225,4225,2145,2145,4225,8386,33348,10466,4225,4225,2145,2145,2145,4225,255},
{425,425,425,425,425,425,425,425,457,457,457,457,457,457,458,458,458,490,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,555,555,555,555,555,555,555,555,555,555,555,555,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,652,652,652,653,653,653,653,653,685,685,685,2733,2733,2733,717,717,717,2766,2766,2766,2798,4846,4846,4846,4846,4845,4845,2798,4878,4878,6926,6926,6926,6926,6958,6958,10891,12938,10890,10890,10890,10858,10890,12938,12938,12938,12938,12938,12970,12970,12938,12970,12970,12970,12970,13002,12970,13003,13003,13035,15083,13034,15083,13034,13034,15082,13034,12970,12969,15082,15082,15114,15114,15114,15114,17130,15081,17161,17161,17129,17161,17129,17129,17129,17129,17129,17096,17096,19177,10693,4258,4225,4225,4225,4225,4225,4225,4225,4225,4225,4225,4225,4225,2145,2145,2145,4225,10434,31234,10466,4225,4193,2145,2112,2145,6305,255},
{425,425,425,425,425,425,425,425,457,457,457,457,457,457,457,458,458,490,490,490,490,490,490,490,490,490,490,490,490,522,522,522,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,556,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,652,652,653,653,653,653,653,653,685,685,685,2733,685,2733,2733,717,718,2766,2766,2798,2797,2798,4846,4846,4846,4846,4846,4846,4878,4878,4878,6926,6926,6926,6926,6958,6958,10858,10890,10858,10858,10890,10858,10890,12970,12938,12938,12938,10858,12970,10922,10858,12938,12938,12938,12970,12938,12937,13002,13002,13002,13002,12969,12969,13002,13034,15082,15082,15049,15050,15082,15082,15082,17162,17162,15114,17162,17162,17162,17194,17194,17194,17162,17161,19242,17161,17161,19241,19209,17096,6370,4225,4225,4258,4225,4258,4258,4225,4225,4225,4225,4225,4225,4225,2145,2145,2145,2145,22979,29186,10499,4225,4225,4193,2112,4225,4257,255},
{424,425,425,425,425,425,425,425,457,457,457,457,457,457,457,458,490,490,490,490,490,490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,555,555,555,555,555,555,555,555,555,555,556,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,652,653,653,653,653,653,685,685,685,685,685,685,685,685,685,2765,717,717,2766,2797,2798,4846,4846,4846,4846,4878,4878,4878,4878,4878,4878,6926,6926,6958,6959,6926,10825,10825,10825,10858,10858,10857,10858,12906,12938,12905,12938,12970,12970,12938,10890,12970,12938,12938,13002,12970,12970,13002,13002,13002,15083,13002,13002,15082,15114,15114,15114,15082,15082,15114,15082,15082,17162,15114,17194,17226,17194,17194,17194,17193,17194,17162,17161,17194,17161,17161,19241,19209,19209,12709,4225,4258,4258,4258,4258,6338,6306,4258,4225,4225,4225,4225,2145,2145,2145,2145,4225,27139,20866,12611,4225,4225,4193,2145,4225,6305,255},
{424,425,425,425,425,425,425,425,457,457,457,457,457,457,457,458,458,490,490,490,490,490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,555,555,555,555,555,555,555,555,555,555,555,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,652,653,653,653,653,653,653,685,685,685,685,685,685,685,2733,2733,2765,2765,2765,2765,2797,2798,4846,4846,4846,4878,4878,4878,4878,4878,4878,4878,4878,6958,6959,6959,8941,10825,10890,10890,10890,10858,10857,10890,10890,12938,10890,12938,12938,12970,12970,12970,13003,12970,12970,13002,13002,13003,13002,13002,13002,15083,13002,13002,15082,15082,13034,15115,15082,15082,15082,15114,15114,15114,15114,17162,17194,17194,17194,17194,17194,17194,17226,17194,17161,17193,19241,19241,19209,19241,14854,6306,6306,4258,6338,4258,6338,4258,4225,4225,4225,4193,4225,4225,2145,2145,2145,8386,25092,12514,16772,4225,4225,4225,2145,4225,6306,255},
{425,425,425,425,425,425,425,425,457,457,457,457,457,457,457,458,458,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,522,523,523,523,523,555,555,555,555,555,555,555,555,555,556,556,588,588,588,588,588,588,588,620,620,620,620,620,620,620,652,652,652,653,653,653,653,653,653,653,685,685,685,685,685,685,2765,2765,2765,2765,2765,2798,2798,4846,4846,4846,2830,2830,2830,2830,2830,2830,2830,4910,4910,4911,4911,8908,10858,10890,10890,10890,10890,10890,10890,10890,10922,10890,10890,10890,10922,12970,12970,13003,13002,12970,13003,13003,13003,13035,13003,13002,13002,13002,13002,13034,13035,15082,15115,15114,15114,15114,15114,15114,17162,17162,17162,17194,17194,17194,17194,17194,17226,19274,17194,17193,17193,17161,19241,19209,19209,12774,10564,6338,4258,6306,4258,6306,4258,4258,4225,4225,4225,4193,2145,2145,2145,2145,4225,27204,25255,29449,2145,4225,4225,4193,4225,6338,255},
{425,425,425,425,425,425,425,425,457,457,457,457,457,457,457,458,490,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,555,555,555,555,555,555,555,555,555,556,556,588,588,588,588,588,620,620,620,620,620,620,620,620,620,620,652,653,653,653,653,653,653,653,685,685,685,685,685,717,717,2765,2765,2765,2765,2766,2766,2798,4846,4878,4846,2830,2830,2830,2830,2830,2830,2863,4911,4911,4911,4911,8875,10890,10890,10890,10890,10890,10890,12970,10922,10890,10890,12938,12938,10890,12971,12970,13003,13002,12970,13002,13002,13002,13035,13002,13002,13034,13034,13002,15082,13034,13034,15082,15114,15146,15146,15114,15114,17194,17194,17162,17194,17194,17194,17194,17193,17161,17161,17129,17161,19241,19209,17129,19177,19176,17064,14854,10563,10564,10563,6338,6338,6306,6306,6306,4258,4258,4225,4225,4225,4225,2177,6338,39718,14692,16869,4193,4225,2145,4193,4225,6338,255},
{425,425,425,425,425,425,425,425,457,457,457,457,457,457,458,458,490,490,490,490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,556,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,652,652,653,653,653,653,653,653,653,653,685,685,685,685,685,685,717,717,2765,717,2765,2797,2798,4846,2830,2798,2798,2830,2830,2830,2830,2862,4911,4911,4911,4911,4911,8843,10890,10890,10890,10890,10857,10890,10922,10890,10890,10890,10890,12938,12970,10922,12970,13003,12970,12938,12938,12970,12970,13002,13002,13002,13002,13002,13002,15050,13002,15050,15050,15082,15114,15082,15081,17130,17130,17130,17129,17129,17097,17129,17129,17129,17129,17129,17129,17129,19209,17129,19177,19209,19176,19176,19209,19144,21257,14918,4225,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2113,10498,37605,6273,18884,4225,4225,2145,4193,4225,6338,255},
{425,425,425,425,425,425,457,457,457,457,457,457,457,457,458,458,458,490,490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,556,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,652,653,652,653,653,653,653,653,653,685,685,685,685,685,685,685,717,717,717,717,2765,2797,2798,4846,4878,4846,2830,2830,2830,2830,2863,4911,4911,4911,4911,4911,6958,10858,10890,10857,10858,10858,10825,12906,12970,12905,12938,12938,12937,12938,12938,12905,12938,12970,12938,12937,12969,12970,15018,15050,15050,13002,15050,15050,13034,13034,15082,15114,15114,17194,15114,15114,15114,17194,17194,17194,17194,17194,17226,17194,17193,17194,17161,17161,19242,19242,19242,19241,19241,19241,19209,19209,19209,19176,12838,10693,4258,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,18916,37605,18786,27238,4225,4225,2145,2145,4225,6338,255},
{425,425,425,425,425,425,425,457,457,457,457,457,457,457,458,458,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,556,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,652,653,653,653,653,653,653,653,653,685,685,685,685,685,717,2765,717,717,717,717,2765,2797,2798,4846,4878,2830,782,2830,2830,4878,6860,8908,8908,8908,8908,8908,10923,10858,10825,12905,12938,12938,12906,12938,12970,12938,12938,12970,12970,12970,12970,12970,12970,13003,13002,13035,15083,13002,13003,13035,15083,15083,15083,13035,15115,15147,15147,15146,15147,15179,15146,15114,15114,17194,17162,17194,17194,17194,17227,17161,17193,19274,17161,17161,17194,17161,19209,19209,19209,19209,19176,19177,19177,17064,17031,10596,4193,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2113,12579,27172,10498,21029,4225,4225,2145,2145,2177,6338,255},
{425,425,425,425,425,425,457,457,457,457,457,457,457,457,457,458,490,490,490,490,490,490,490,490,490,522,522,522,522,522,522,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,556,588,588,588,588,588,620,620,620,620,620,620,620,620,620,652,652,653,653,653,653,653,653,653,653,653,685,685,685,685,685,717,717,717,717,717,2766,2765,2798,4846,4878,2798,2830,2830,2830,6893,10825,10825,10858,10858,10857,10858,10858,10890,10858,10890,10890,10890,10890,10922,10922,10890,12938,12970,12970,12970,12970,12970,12970,13003,13002,13002,12970,13002,15083,15115,15050,15050,13035,13034,15115,15114,15082,15082,15114,15114,15114,15082,15082,17162,17162,17130,17162,17162,17194,17162,17161,17194,17161,17129,17129,17129,19209,19209,19209,19209,19209,19209,19176,17064,19144,14854,4226,2113,2145,2145,2113,2113,2145,2145,2145,2145,2145,2145,2145,4193,8386,16837,4225,4225,2145,2145,2177,6338,255},
{425,425,425,425,425,425,425,457,457,457,457,457,457,457,458,490,490,490,490,490,490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,556,588,588,588,588,588,588,588,620,620,620,620,620,620,620,652,652,652,653,653,653,653,653,653,653,685,685,685,685,685,685,685,717,717,717,717,2765,2798,2798,4846,4878,2830,782,2830,2830,4813,10825,10858,10890,10858,10857,10858,10858,10890,10890,10857,10857,10825,10890,12938,12938,10858,10858,12938,12970,12938,12906,12970,12970,12970,13002,15050,12970,13002,13002,13034,13002,13002,15083,15083,15082,15082,15082,15114,15147,15114,15114,15114,17162,17195,17162,17194,17194,17194,19307,17194,17194,19274,17193,17193,19274,19242,19242,19241,19241,19241,19209,19241,19209,19176,19176,12741,2145,2113,2145,2145,2113,2145,2113,2145,2145,2145,2145,2113,12579,14626,2113,14724,4225,4225,2145,2145,4225,6338,255},
{425,425,425,425,425,425,425,457,457,457,457,457,457,458,458,490,490,490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,556,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,652,652,653,653,653,653,653,653,653,685,685,2733,685,685,685,2733,717,717,717,2765,2765,2765,2798,4846,4846,2830,782,782,2830,2830,6828,10825,10825,10858,10825,10825,10825,10858,10858,10890,10857,10857,10857,10890,12938,12938,12938,12938,12970,12970,12970,12938,13003,13003,15083,15051,13002,12970,13035,13002,13002,13003,13035,15115,13067,13067,15115,15115,15147,15179,15147,15147,15146,17162,17227,17194,17162,17194,17194,17194,17226,17194,19274,17194,17194,19274,19241,19241,19241,19241,19241,19209,19241,19208,17064,17096,8483,4258,4225,2145,2145,2145,2145,2113,2145,2145,2145,2145,2145,10499,18852,23044,25190,4225,4258,4193,2145,2145,6338,255},
{425,425,425,425,425,425,457,457,457,457,457,457,458,458,458,490,490,490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,556,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,652,652,653,653,653,653,653,653,653,685,685,2733,685,2733,685,685,717,717,2766,2766,2765,2765,2798,4846,4846,2830,2830,2830,2830,2830,8843,10858,10858,10890,10890,10858,10858,10890,10890,10890,10890,10890,10890,12970,12970,12970,12938,12938,12970,13003,12970,13002,12970,13002,13002,12970,12970,15051,15083,13035,13003,15050,13035,15083,13067,15115,15115,15115,15115,15147,15147,15179,17227,17194,17195,17194,17194,17227,17194,17194,17226,17194,19242,17162,17194,19306,19242,19274,19241,19209,19209,19209,19209,19241,19209,19209,19112,8516,4290,2145,4225,2145,2145,2113,2113,2113,2145,2145,2145,2145,35753,48298,35655,4225,4225,4225,4225,2177,6338,255},
{425,425,425,425,425,425,457,457,457,457,457,458,458,458,490,490,490,490,490,490,490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,652,653,653,653,653,653,653,653,653,685,685,685,2733,2733,685,717,717,718,2766,2766,2798,2798,2797,2798,4878,4878,2830,782,2830,4878,8810,10858,10858,10858,10858,10858,10858,10858,10857,10857,10890,10890,10890,12970,12970,12938,12938,12970,12970,12970,12970,12970,13002,12970,12970,13002,13002,15083,15115,15083,15083,15083,13035,13034,13067,13067,15147,15082,15114,15179,15179,17259,17227,17195,17195,17194,17194,17259,17194,17194,17226,17194,19274,17194,17193,19274,19242,19274,19242,19209,19241,19209,19209,19209,19209,19209,12774,6338,2145,2145,4225,4225,2145,2113,2113,2113,2145,2145,2145,4225,37866,48364,39882,4225,4225,2145,4193,4225,6338,255},
{425,425,425,425,425,425,457,457,457,457,458,458,458,458,490,490,490,490,490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,556,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,652,652,653,653,653,653,653,653,653,685,685,685,2733,2733,685,685,718,718,2766,2766,2766,2766,2798,4846,4846,2830,2830,782,782,4846,10858,10858,10858,10858,10858,10858,10858,10858,10825,10857,10890,10890,10890,12970,12970,12938,12970,12970,12970,12970,13003,12970,12970,13003,13002,13035,15051,15083,15083,13002,15083,15083,13035,15115,15115,15115,15115,15114,15115,15179,15146,15179,17227,17194,17227,17195,17194,17227,17194,17194,17194,17194,19274,17194,17161,19242,17161,19209,19241,19209,19241,19241,19209,19209,19208,19176,6403,6338,4225,4225,6306,6306,6306,4193,2145,2145,2145,2145,2145,4258,18981,21159,23142,6306,4193,2145,2145,2145,6338,255},
{425,425,425,425,425,457,457,457,457,457,457,457,458,458,490,490,490,490,490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,555,556,556,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,652,652,653,653,653,653,653,653,653,685,685,685,2733,2733,685,718,718,718,2766,2766,2766,2798,2798,2798,4846,4878,2830,2798,4878,6860,10858,10858,10858,10858,10858,10857,10890,10890,10890,10890,10890,12970,10890,10890,12970,12938,12938,12970,12970,12971,13003,12970,12970,13003,13002,13002,13002,13002,15083,15083,13035,13002,15083,15115,15115,15115,15114,15082,15082,15114,15114,15114,15114,17162,17162,17162,17162,17194,17162,17161,17161,17161,17161,17129,17129,19209,17129,19209,19209,19177,19209,19177,19176,19208,19176,17031,19079,10596,6338,6370,6338,4258,4258,4225,4225,4225,4193,4225,4225,4225,6306,4225,16836,6306,2145,2145,2145,2145,8450,255},
{425,425,425,425,425,425,457,457,457,457,457,457,458,458,490,490,490,490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,556,588,588,588,588,588,620,620,620,620,620,620,620,620,620,620,652,652,653,653,653,653,653,653,685,685,685,685,2733,2733,2733,718,718,718,2766,2766,2766,2765,2798,2798,4846,4878,6861,10890,10890,10857,10858,10858,10826,10825,10825,10825,10858,10890,10890,10857,10857,10890,10890,10890,10825,10857,12906,12938,12938,12970,12938,12970,12970,12970,12970,13002,12970,15050,15082,15050,15050,15050,15082,15082,15082,15082,15114,15114,15082,15114,17227,17194,17195,19275,19275,19275,19275,19275,19275,17194,19274,17161,17161,19242,19242,19274,19242,19242,19242,19209,19209,19241,19209,19241,19241,19176,19112,8418,4225,6338,6338,2145,2145,2145,2145,2145,2145,2145,4225,4225,6306,18916,20997,4258,8419,4225,4225,2145,8450,255},
{425,425,425,425,425,425,457,457,457,457,457,457,458,458,490,490,490,490,490,490,490,490,490,490,490,490,522,522,523,522,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,652,653,653,653,653,653,653,685,653,685,685,685,2733,2733,685,685,718,2766,2766,2766,2766,2765,2798,2798,4846,4878,8876,10858,10858,10825,10858,10825,10825,10825,10825,10825,10858,10890,10890,10858,10890,10890,10922,12970,12970,12970,12970,12970,13003,13003,13003,13003,13003,13003,15051,15083,15083,15083,15083,13002,15115,15083,15115,15148,15147,15147,15147,17227,15147,15179,17292,17227,17227,19307,17195,17195,17227,17227,19307,17194,17226,19274,19242,19274,17194,19242,19274,19242,19274,19241,19241,19273,19209,19209,19241,21289,16999,8483,6338,6306,4226,4225,2145,2145,2145,2145,4225,4225,4225,4225,6338,29382,21029,4258,18951,4225,2113,2145,8451,255},
{425,425,425,425,425,457,457,457,457,457,457,457,458,490,490,490,490,490,490,490,490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,652,652,653,653,653,653,653,653,653,685,685,685,2733,2733,2733,685,685,718,718,2766,2766,2766,2766,2798,2798,4846,4878,8875,10857,10858,10825,10858,10858,10825,10858,8810,10826,10858,10890,10890,10890,10890,10890,10890,10890,12938,12970,10890,12938,12970,13003,15083,15051,15051,15083,15083,15083,17163,17195,17195,15082,15115,15083,15115,15148,15115,15147,15115,15115,15179,15179,15211,17227,17227,17259,17195,17194,17227,17226,17227,17162,17194,19274,17193,19241,17161,17161,19241,19241,19274,19241,19209,19241,19209,19177,19209,21257,19112,14789,16902,16934,6370,4258,4225,4225,4225,4225,4225,4225,4225,4258,20997,42059,35754,4225,4258,4225,14757,2145,6338,255},
{425,425,425,425,425,425,457,457,457,457,457,458,458,458,490,490,490,490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,555,556,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,652,653,653,653,653,653,653,653,685,685,685,685,685,685,685,717,718,718,2766,2766,2765,2798,2798,2798,4846,4878,10923,10890,12938,12938,15018,12970,12970,15051,17131,17131,17131,17163,19211,19276,21324,21356,23404,23404,21356,25484,25452,23404,25484,23403,23403,23371,23403,23403,21291,21291,21291,21258,19177,15050,15083,15050,15083,15115,15082,15147,15050,13034,15115,15114,15114,15146,17194,17227,17194,17194,17227,17194,17194,17162,19242,19306,19242,19242,19209,17161,19241,19241,19241,19241,19241,19273,19241,21321,21321,21321,21257,19111,23337,19079,12709,6338,4225,4225,4225,4258,4258,4225,4225,6306,35785,42091,20997,4225,2145,2145,10596,8451,10563,255},
{425,425,425,425,425,457,457,457,457,457,457,458,458,458,490,490,490,490,490,490,490,490,490,490,490,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,556,555,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,620,652,653,653,653,653,653,653,685,685,685,685,685,685,685,685,718,718,717,2766,2765,2766,2766,2797,2798,4878,6894,12938,12938,14986,23339,21291,19178,17066,17066,17098,14985,14953,14953,12872,12873,12840,10760,10760,10727,8679,8679,8647,6566,6566,6534,6534,6534,6534,6534,4486,6534,6534,4454,6534,12938,15115,15083,15083,15147,15115,15179,15147,15147,15147,15147,17227,17227,17227,17259,17259,17227,19339,19307,19275,19274,17226,19306,17194,17194,19274,19242,19242,19241,19241,19241,19241,19274,19241,19241,21321,21321,21321,19176,21256,12709,10564,6306,4225,4225,4225,4258,4258,4225,4225,6338,33639,33607,23077,4257,2145,4225,8451,6338,12675,255},
{425,425,425,425,425,457,457,457,457,457,458,458,458,490,490,490,490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,555,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,652,652,653,653,653,653,653,653,653,685,685,685,685,717,685,717,718,718,717,717,2765,2766,2765,2798,4846,4878,6893,12938,12938,10857,4422,2374,2374,2374,2374,2374,2374,2406,2406,2406,4454,4454,2406,4454,4454,4486,4486,4486,4486,4487,4486,4519,4518,4486,6567,6567,6567,6567,6567,6599,15050,15115,15083,15083,15147,15147,15147,15147,15147,15179,15179,17227,17227,17227,17259,17259,17227,19339,17227,17227,19307,17226,17226,17194,17226,19274,19242,19241,19241,19241,19209,19209,19242,19241,19273,19241,19241,21321,19079,14886,21256,12676,8483,4225,4225,4225,4225,4225,4225,4225,6338,33640,37800,27270,4225,2145,2145,2145,2145,8483,255},
{425,425,425,425,425,457,457,457,457,458,458,458,458,490,490,490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,556,555,556,588,588,588,588,620,620,620,620,620,620,620,620,620,620,652,652,653,653,653,653,653,653,653,685,685,685,685,685,717,718,718,718,718,2766,2766,2766,2798,2798,2798,6861,8876,12938,12938,12938,4487,4454,4454,4454,4454,4422,4454,4454,4454,4454,4454,4422,4422,4454,4422,4422,4422,4421,4421,4421,4389,4389,4389,4389,4388,4356,4356,4356,4356,6469,15082,15115,15115,15083,15147,15115,15114,15147,15147,15211,15179,17227,17259,17227,17259,17259,17227,19307,17194,17194,19307,17226,17226,17226,19274,19274,19242,19274,19241,19241,19241,19209,19242,19242,21321,21321,21321,21321,21321,23401,23337,12741,12741,4258,4258,4226,4225,4225,4225,4225,6306,35720,37800,27302,4225,2145,2145,2145,2145,8450,255},
{425,425,425,425,425,457,457,457,457,457,458,458,458,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,555,555,556,588,588,588,588,620,620,620,620,620,620,620,620,620,620,652,653,653,653,653,653,653,653,685,685,685,685,685,685,717,718,718,718,2766,2766,2766,2798,2798,750,2798,6893,10891,12938,12938,12938,6535,2244,2276,2244,4291,2243,2243,2243,2211,2211,2211,2211,2211,2211,2211,2211,2211,2211,2211,4259,4259,4259,4259,4291,2211,2211,2211,2211,2211,6468,15115,15115,15115,15115,15115,15147,15115,15147,15179,15179,15211,17227,17259,17227,17259,17227,17227,17227,17227,17227,19307,19274,19306,19274,17226,19306,19274,19274,19241,19241,19241,19209,19274,19241,19241,21321,21321,21354,21321,23401,23369,12709,6338,4226,4258,4258,4225,4225,4226,4226,6338,29479,31527,29447,4193,2145,2145,4193,4225,6338,255},
{425,425,425,425,457,457,457,457,457,457,458,458,490,490,490,490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,555,556,556,588,588,588,588,588,620,620,620,620,620,620,620,620,620,652,653,653,653,653,653,653,653,685,685,685,685,685,685,718,718,718,718,718,750,750,750,750,750,2798,4846,10891,12938,12938,12970,8550,2178,2210,2210,2211,2211,2211,2211,2211,2211,2211,2211,4259,2211,2211,2211,2211,4259,4259,4291,4291,4291,4291,4291,2243,4291,4291,2243,2211,6533,15115,15083,15083,15115,15147,15147,15147,15179,15179,15179,17292,17227,17259,17259,19307,17227,17227,19307,19275,17227,19339,17226,19306,19274,17194,19274,19242,19274,19241,19241,19242,19241,19274,19241,19241,19209,19241,21354,21321,23401,23401,14821,6338,4258,4225,4225,4225,4225,4225,4225,8418,8418,2145,16868,6305,2145,2145,4258,4225,6306,255},
{425,425,425,425,457,457,457,457,457,457,458,458,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,522,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,555,556,588,588,588,588,588,588,620,620,620,620,620,620,620,620,652,652,653,653,653,653,653,653,653,685,685,685,685,685,717,717,717,718,750,750,750,750,750,750,750,750,4846,10890,12938,12938,12970,10728,4259,2211,2211,2211,2211,2211,2178,2178,2211,2211,2211,2211,2211,2211,2211,2211,2211,2211,2211,2211,2211,2211,2211,2211,2211,4259,2210,2210,8614,15083,15051,13034,15115,15147,15114,15082,15114,15115,15115,15147,17194,17227,17226,17227,17226,17194,19275,17194,17194,19274,17194,17193,19242,17161,17193,19209,19209,19209,19209,19241,19209,19209,19209,19209,19209,21257,21289,21256,21321,21256,12709,10564,6370,6306,4258,4258,6306,4258,6338,8386,6306,2112,16836,6305,2145,2145,4225,6306,6305,255},
{425,425,425,457,457,457,457,457,457,457,458,458,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,555,556,588,588,588,588,588,620,620,620,620,620,620,620,620,620,652,652,653,653,653,653,653,653,653,685,685,685,685,685,685,718,718,718,718,750,750,750,750,750,750,782,4845,12938,12938,12938,12970,12970,6404,2211,2210,2178,2210,2211,2178,2178,2211,2211,2211,2211,2211,2211,4291,4291,4291,4291,4291,4291,4291,4291,4323,4291,4291,4323,4323,4291,10727,15083,15050,13035,15115,15147,15147,15115,15147,15147,15179,17227,17194,17162,19275,17227,17227,19275,19275,19307,19274,19307,19274,19274,19274,19274,19274,19274,19274,19274,19242,19242,19274,21354,19241,21321,21321,21321,21321,23401,25514,23337,14854,12676,6370,4225,6306,4258,4258,4226,6306,6306,4225,6338,23077,6305,2113,2145,4193,4225,4225,255},
{425,425,425,457,457,457,457,457,457,457,458,458,458,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,556,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,652,653,653,653,653,653,653,653,653,685,685,685,685,685,685,718,718,718,750,750,750,750,750,750,750,782,8876,10858,12938,12938,12938,12938,6502,4291,4291,4291,2243,2211,2243,4291,2243,2243,2243,2243,4291,4291,4291,4291,4291,4291,4323,4323,4323,4323,4323,6403,6403,6403,6403,8451,12872,15115,15083,15115,15115,15115,15212,15115,15147,15179,15179,17259,17194,17194,19307,19275,19275,19307,19275,19339,19307,19307,19306,19274,19274,19306,19306,19306,19274,21354,19241,19242,19241,19274,19274,19241,21322,21321,21353,23401,23433,23337,16998,14789,6338,4258,4225,4258,4225,4258,4225,6306,4225,16869,37801,6273,2113,2145,4193,4225,6338,255},
{425,425,425,425,457,457,457,457,457,458,458,490,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,555,556,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,653,653,653,653,653,653,653,685,685,685,685,685,685,685,717,718,718,750,750,750,750,750,750,750,750,782,10924,14985,14986,15018,15018,17098,12775,10597,10629,12709,12742,12774,12774,14855,14855,14919,16968,17000,17032,19113,19145,19177,21258,23338,21258,21291,23371,23403,23468,27596,25516,25581,27662,27597,17195,17196,17163,17195,17227,17228,19308,19308,19340,19372,21388,21420,21387,17194,19307,19307,19275,17227,17227,19339,19274,19307,19339,19274,19306,19274,19274,19274,19274,21354,19242,19274,19242,19241,19241,19209,21289,21321,23433,23401,23401,21224,14886,14821,6338,4225,4225,4225,4225,4225,4225,4258,4193,19047,29481,4225,2113,2145,4193,2145,8418,255},
{425,425,425,425,457,457,457,457,457,458,458,490,490,490,490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,555,556,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,653,653,653,653,653,653,653,685,685,685,685,685,685,717,717,717,718,718,750,750,750,750,750,750,750,750,29840,42321,38160,36112,36080,33967,31854,29742,29774,27693,29742,25613,23533,25582,23501,21420,23469,21388,19275,19308,21324,17195,19243,19243,15082,15082,17131,15017,15049,15017,14953,12905,12905,17033,17130,19243,19211,17163,19211,19211,19210,17130,17130,17130,17097,17130,17065,17194,17227,19275,17194,17162,17194,19275,17162,19242,19307,17194,17193,19241,19241,19241,19241,19274,19241,19241,19241,19241,19273,19241,21289,21321,23401,23401,23401,25481,23369,12708,8418,6306,4258,4225,6306,4258,4258,4225,4225,16836,31463,6305,2113,2145,4225,2145,6370,255},
{425,425,425,457,457,457,457,457,457,458,490,490,490,490,490,490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,588,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,652,652,653,653,653,653,653,685,685,685,685,685,685,685,685,717,718,718,718,750,750,750,750,750,750,750,4814,10858,12872,10760,10727,10695,8615,8582,8550,6502,6501,6502,6469,4421,6437,4388,4356,4356,4324,4324,4324,4291,4291,4323,4291,4291,4291,4291,4259,4258,4258,4258,4291,4291,4291,6469,6501,6501,6501,6501,6501,6501,4421,4421,6469,6469,6469,10726,17259,17259,17227,17227,17227,17227,19307,19339,19339,19371,19306,19306,19306,19306,19274,19274,21386,19274,19274,21354,21322,21354,21321,21354,21321,21353,23434,25481,23369,19111,16934,14853,8451,6306,4226,6306,6306,4258,4258,4225,14788,37801,6305,2113,2145,4225,4225,8418,255},
{425,425,425,425,457,457,457,457,457,458,490,490,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,556,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,620,653,653,653,653,653,685,685,685,685,685,685,685,685,718,718,718,718,750,750,750,750,750,750,750,2830,2374,2178,2178,2178,2178,2178,2210,2210,2210,4258,2211,2211,2211,2243,2243,4291,4324,4324,4324,4324,4356,2276,2308,4357,4356,4389,4389,4389,4421,4421,4421,4454,4454,4454,4356,2210,2210,2210,2210,2210,2210,2178,2210,2210,2210,2178,8581,17259,17259,17259,17227,17259,17259,19339,19339,19306,19306,19306,21387,17193,19242,19306,19274,19338,19241,19242,21354,19274,21354,19241,21321,21289,21289,23401,23369,25482,21191,8515,12708,8418,6338,4258,4258,4258,6338,6306,6306,14756,35720,6306,2145,4193,4225,12676,12644,255},
{425,425,425,425,425,457,457,457,457,457,458,490,490,490,490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,556,556,556,588,588,588,588,588,588,620,620,620,620,620,620,620,652,620,652,652,653,653,653,685,685,685,685,685,685,685,685,685,718,718,718,718,750,750,750,750,750,750,750,782,2570,2341,4454,2374,2374,2374,2374,4422,4422,4422,2406,4454,2406,4487,4487,4454,4487,4487,4454,4487,4487,4454,4487,4487,4454,4487,4487,4454,4487,4519,4454,4486,4486,6502,10694,8516,8516,8516,8516,8548,10629,8581,8613,10661,10629,12742,23273,17227,17227,17259,17227,17259,19307,19339,19371,19339,19306,19274,19339,17097,17129,19306,19274,19306,19241,19241,19306,19306,21354,19273,21321,21289,21353,23434,21289,21321,21256,16934,10563,4225,4258,4225,4225,4225,4258,6306,8450,8418,27334,8386,4225,4225,6338,10531,12643,255},
{425,425,425,425,457,457,457,457,457,457,458,490,490,490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,556,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,652,652,653,653,653,653,653,685,685,685,685,685,685,685,685,718,718,718,718,750,750,750,750,750,750,750,782,2700,2374,2374,2374,2406,2374,2374,2374,2374,2373,2406,2406,2374,2374,2406,4422,4454,4454,4454,4454,4487,4454,4454,4487,4454,4487,4487,4454,4486,4487,4486,4486,4486,6502,15017,15114,15082,15114,17162,15146,17227,17227,17227,17227,17227,19307,19275,17227,17227,17259,17227,19339,19339,19339,19371,19307,19371,19306,19306,17032,14919,21419,19274,21386,19242,19242,19306,19274,21386,21354,19273,21321,21321,23434,23433,23401,23337,25481,10596,8451,8419,4225,6338,4225,2145,10563,27463,33738,39979,6306,2145,4225,4258,8450,8451,255},
{425,457,457,425,457,457,457,457,457,457,458,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,556,588,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,652,652,653,653,653,653,685,685,685,685,685,685,685,685,685,718,718,718,718,718,750,750,750,750,750,782,782,717,2407,2374,2374,2374,2406,2406,2406,2374,2406,2406,2406,2374,4454,2406,2374,2406,2407,4454,4487,4487,4455,4487,4519,4487,4487,4487,4486,4519,4551,4519,4486,4519,4486,10824,13035,13002,13034,13002,13002,13002,12969,12969,12969,12937,12937,15049,17259,17227,17259,17259,19307,19339,19339,21420,19339,19339,19306,19306,19306,19241,21419,19306,21386,19241,19242,19274,19274,21386,21354,21354,21321,21321,23434,23434,25514,23433,23369,12708,10563,6338,4225,4225,6338,8418,10531,14756,21159,23208,6306,2145,4193,6306,10531,4257,255},
{425,457,457,457,457,457,457,457,457,457,458,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,556,588,588,588,588,588,588,588,588,620,620,620,620,620,620,620,652,652,652,653,653,653,653,685,685,685,685,685,685,685,685,686,718,718,718,718,718,750,750,750,750,750,782,782,783,2472,2374,2406,2374,2374,2406,2406,2406,4454,2406,2407,2406,2406,2439,2406,4455,4487,2406,2406,4487,4454,4487,4487,4487,4454,4487,4487,4487,4519,4487,4486,4519,4487,6502,6566,6534,6566,6534,8582,6566,6534,6534,8582,8582,8582,15017,17259,17227,17259,17227,19307,19339,19339,19371,19339,21419,19306,19306,19306,19274,19306,19306,21386,19274,19274,19274,19242,21354,21321,21321,21289,21289,21321,21321,23369,23336,23336,14821,8418,4225,4225,4225,6370,10531,10531,6338,12611,20997,8418,4225,4225,6338,8418,4225,255},
{425,457,457,457,457,457,457,457,457,458,490,490,490,490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,556,556,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,652,652,653,653,653,653,685,685,685,685,685,685,686,686,686,718,718,718,750,718,750,750,750,750,750,782,782,815,2570,2374,2406,2374,2374,2406,2406,2374,2374,2374,2407,2406,2374,4454,2406,4454,4455,4454,4454,4455,4454,4454,4487,4487,4454,4487,4487,4454,4487,4487,4454,4487,6567,8517,4259,4259,4291,4259,4259,4259,2210,2210,2178,2178,2210,12936,17227,17194,17227,17194,17194,19242,19274,19339,19307,21387,19274,19274,19274,19242,19274,19274,19306,21322,21322,21354,19273,21322,19241,19241,21321,21321,23369,23369,21224,19111,23304,16902,12676,10563,8451,10563,12644,12611,8451,14724,40012,35657,4225,2113,2145,4225,4225,4258,255},
{425,457,457,457,457,457,457,457,458,458,490,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,556,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,620,652,652,653,653,653,653,653,685,685,685,685,686,686,718,718,718,718,750,750,750,750,750,750,750,782,782,782,815,2668,2341,2374,2374,2374,2406,2406,2374,2374,2374,4454,4454,4421,4422,4421,4454,4487,4487,4422,4422,4422,4422,4487,4487,4454,4487,4487,4454,4519,4519,4486,4519,4519,6469,6469,6469,6469,6501,6502,8582,8582,10694,10694,10694,10726,15081,17292,17227,19339,17259,17259,19339,19339,21419,19339,19339,19306,19306,19306,21386,21387,19306,19306,21386,21354,21386,21354,21354,21321,21354,23434,23401,23433,25481,27594,25481,27594,27562,21223,25449,21191,23272,14821,10563,6338,16869,18982,27335,8418,2113,2145,4225,10563,8418,255},
{425,457,457,457,457,457,457,458,458,458,490,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,556,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,652,652,652,653,653,653,653,685,685,685,685,685,685,685,718,718,718,718,750,718,750,750,750,750,750,782,782,782,815,2765,2374,2374,2374,2374,2374,2374,2374,2406,2406,4454,2406,4422,4454,4486,4454,4486,4486,4454,4454,4454,4454,4486,4487,4454,4486,4487,4454,4519,6567,4486,6567,6567,6567,6631,6599,6469,4291,4323,4356,6436,8548,8548,8516,8548,15082,17259,17227,17259,17259,17227,19339,19307,19339,19274,19274,19306,19274,19306,21419,21419,21387,19306,21386,21354,21387,21354,21354,21386,21386,23434,25481,25546,25514,25514,25481,25514,25513,27594,23368,19111,23336,12708,16902,6370,8451,6306,12676,6306,2145,2145,2145,8483,18981,255},
{457,457,457,457,457,457,457,458,458,458,490,490,490,490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,652,652,652,653,653,653,653,685,685,685,685,685,685,717,717,718,718,718,718,718,750,750,750,750,750,782,782,782,782,4846,4618,4585,4617,4617,4650,4650,4617,4454,4454,4454,4454,4454,4454,4454,4454,4486,4486,4486,4454,4486,4486,4486,4487,4486,4487,4519,4486,4518,6567,6567,6567,6567,6567,6567,6599,6534,2178,2146,2146,2146,2146,2146,2146,4323,19307,21420,21420,21420,23500,23468,23467,23500,25612,23500,23499,25580,25580,23435,19339,21354,21387,19306,21386,21354,21418,21386,21386,21386,23434,23434,25481,25514,25481,25514,25481,25513,25513,25481,16902,12676,12741,10628,10564,6306,4258,10531,14691,4225,2145,6338,6338,8418,16869,255},
{457,457,457,457,457,457,457,458,458,490,490,490,490,490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,652,652,652,653,653,653,685,685,685,685,685,685,685,717,718,718,718,718,718,718,750,750,750,750,750,782,782,782,2830,2831,2863,2863,2863,2863,2895,2895,4911,4487,4454,4454,4454,4454,4487,4487,4487,4487,4487,4487,4487,6567,6567,4519,6567,6567,6567,6599,6599,6599,6632,6632,8712,8712,8712,8712,8745,8712,4259,2178,2178,2178,2178,2178,2146,4323,15017,17097,17065,17064,17065,17032,17032,14952,14984,14952,14951,14919,14887,17064,19274,19274,21387,21354,21322,19306,21386,21354,21386,21353,21353,23434,23401,23433,23401,27562,25449,25481,25481,25481,19046,10531,8451,10596,8451,4258,4225,16901,29415,6338,2145,4225,2145,4258,8483,255},
{457,457,457,457,457,458,457,458,458,458,490,490,490,490,490,490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,652,652,652,653,653,653,685,685,685,685,685,685,717,717,718,718,718,718,718,718,750,750,750,750,750,782,782,782,782,2831,2863,4911,2863,2863,2863,2863,2895,4748,4747,4748,6828,6828,6860,6861,6893,6893,8973,8974,8974,9006,9006,9038,11119,11119,11151,11151,11151,11184,13232,13232,13264,13264,15312,15312,15312,15247,4324,2178,2178,2178,2178,2178,2178,2210,6468,6436,6436,6436,6436,6436,6436,6403,6403,4355,4355,4355,4323,14951,21387,21386,21387,21354,21386,21386,23467,21386,21386,21386,21386,25546,25514,25546,25514,27594,25513,27594,27594,27626,23304,16901,14821,8451,6338,4258,6306,12611,21029,6338,2145,2145,2113,4258,12676,255},
{425,457,457,457,457,458,458,458,458,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,522,522,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,588,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,652,652,653,653,653,653,685,685,685,685,685,685,685,718,718,718,718,718,718,718,750,750,750,750,750,782,782,782,782,783,2863,2863,2831,2863,2863,2863,2895,2896,848,880,2928,4976,4976,7024,7024,7056,7056,7056,9104,9136,9136,9136,9168,9169,9168,11216,11216,11217,11216,11248,13296,13264,13264,13264,13264,13134,4259,2178,2178,2178,2178,2178,2178,2178,4258,4258,2210,2210,2210,2210,2210,2210,4290,4258,4290,4290,4225,12871,21451,21387,21387,19306,21418,21386,21386,21386,21386,21386,21386,23466,23466,25546,25514,25546,25481,25481,25481,27594,25416,19046,21191,8451,6338,6338,14757,27368,37801,6338,2177,2145,2145,4258,12643,255},
{425,457,457,457,457,458,458,458,458,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,522,522,523,523,523,523,523,555,555,555,555,555,555,555,555,555,556,588,588,588,588,588,588,588,588,620,620,620,620,620,620,620,621,653,653,653,653,653,653,685,685,685,685,685,685,686,718,718,718,718,718,718,750,750,750,750,750,750,782,782,782,782,783,2863,2863,2831,2831,815,2863,2895,2895,847,2895,2928,2927,4976,7024,7024,7024,7056,7056,9104,9104,9136,9136,9136,9136,9168,11216,11216,11216,11216,11216,13264,13264,13264,13264,13232,10989,2178,2178,4226,4226,2178,2178,2178,4291,12839,12774,10694,10694,10726,12774,14887,12806,12839,12838,12839,12838,25320,21257,21451,21419,21451,21387,21419,21386,21386,21386,21386,21386,21354,23466,23434,25546,25514,25546,25546,27594,27562,27562,25481,23304,21159,8451,6370,4225,2145,21127,31594,6273,2145,2145,4225,8451,16869,255},
{425,457,457,457,457,458,458,458,458,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,522,523,523,523,523,523,555,555,555,555,555,555,555,555,555,556,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,621,621,653,653,653,653,685,685,685,685,685,685,685,686,718,718,718,718,718,718,750,750,750,750,750,782,782,783,783,783,815,2863,2863,2863,2863,815,2863,2895,2895,847,2896,2927,4975,4976,4976,4976,7056,7056,9104,9104,9104,9136,9136,9136,9136,9168,11216,11216,11216,11216,11216,13264,13264,13264,13264,13264,10923,2113,2178,4258,4258,4258,4226,2178,4291,17162,19339,17227,17227,19307,19307,21419,21387,21419,19306,19306,21387,23435,21355,21452,21419,21451,21354,21386,21386,21386,21386,21386,21386,21386,25546,25546,29739,27626,27626,25513,25514,25449,23336,23368,21159,16934,8483,8451,4258,6371,12611,14724,6306,2145,2145,4225,6338,14820,255},
{457,457,457,457,457,458,458,458,490,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,556,556,556,588,588,588,588,588,588,620,620,620,620,620,620,620,620,653,653,653,653,653,653,685,685,685,685,685,685,685,718,718,718,718,718,718,718,750,750,750,750,750,782,782,783,783,783,815,2863,2863,815,815,2863,2863,4943,2895,2896,2895,2927,2927,2928,2928,5008,5008,7056,7056,9104,9104,9136,9136,9136,9136,9168,9168,11216,11216,11216,11216,13264,13264,13264,13264,13264,8843,2113,2146,4290,6338,4258,4226,4226,4290,12936,15082,12969,15049,15050,15017,15017,15016,15049,14984,14984,15016,12904,19274,21484,21387,21451,21354,21386,21386,21386,21386,21386,23467,23434,25578,25546,27659,25514,25514,23336,23337,25514,23368,23336,16966,12741,6370,4258,4225,6338,14788,20997,8418,8418,4225,2145,10596,12676,255},
{457,457,457,457,457,457,457,458,490,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,556,556,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,653,653,653,653,653,653,685,685,685,685,685,685,685,718,718,718,718,718,718,718,750,750,750,750,750,782,783,783,783,783,783,815,815,815,815,2863,2863,2895,2895,2895,2895,2895,2927,2927,4976,5008,5008,5008,7056,7056,9136,9136,9136,9136,9136,9136,9168,11216,11216,11216,13264,13264,13264,13264,13264,15312,10858,4226,4226,4258,4258,6338,4258,4226,4258,8549,8614,8614,8614,8614,8582,8614,8613,10662,10661,10661,10661,10661,19242,21451,21387,21419,21355,21419,21419,21419,21419,21386,23466,21386,25578,25546,27594,25514,25514,25481,23401,25481,23368,21191,21224,19047,8451,6338,4258,6338,12676,21029,6338,4258,2145,2145,10596,8451,255},
{457,457,457,457,457,457,457,458,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,555,556,588,556,588,588,587,588,588,588,620,620,620,620,620,620,620,652,621,620,653,653,653,653,653,685,685,685,685,685,686,718,718,718,718,718,718,718,750,750,750,750,750,750,783,783,783,783,783,2863,2863,2863,815,2863,2863,2895,847,4943,4943,4943,4976,2927,2928,5008,5008,5008,7056,7056,9104,9136,9136,9136,9136,9136,9168,11184,11216,11216,13264,13264,13264,13264,15312,15344,10825,4258,4258,4258,4258,4258,4258,2178,10531,18949,18949,16804,16836,18884,16803,16836,20996,16836,20996,18916,16803,16836,19241,21419,19306,21387,21354,21387,23499,21419,21419,21386,21354,21353,25546,25514,25514,25481,25481,23401,25449,23336,21191,23368,23304,21159,12708,8451,4225,6370,14756,23109,4257,2112,2113,2145,8451,10563,255},
{457,457,457,457,457,458,458,458,458,490,490,490,490,490,490,490,490,490,522,522,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,555,556,556,556,556,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,652,653,653,653,653,653,685,685,685,685,685,718,718,718,718,718,718,718,750,750,750,750,750,750,751,783,783,783,783,783,2863,2863,2863,2863,2863,2863,2895,847,2895,2927,2927,4976,4976,4976,5008,5008,5008,5008,7056,7088,9136,9136,9136,9136,9136,9168,11184,11184,11216,11216,13264,13264,13264,15312,15345,10760,4291,4258,4258,6338,6338,4258,4226,4258,12709,14854,12709,12708,16836,16804,12643,14788,12676,14756,12676,12709,12709,19241,21419,21386,21419,21386,21386,21451,21419,23499,23467,21386,23434,27659,27626,27627,27594,27626,27626,27594,27594,25513,27561,23304,21159,8483,6338,4225,25254,39913,33607,4225,2113,2113,2145,6370,14756,255},
{457,457,457,457,458,458,458,458,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,556,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,652,652,653,653,653,653,653,685,685,685,685,685,718,718,718,718,718,718,718,718,750,750,750,750,750,750,751,783,783,783,783,815,815,2863,2863,2863,2863,847,847,847,847,2927,2927,4976,7024,7024,7024,7056,5008,5008,7056,9104,9136,9136,9136,9136,9136,11184,11216,11216,11216,11216,13264,13264,13264,13264,15344,8647,4323,4258,4258,6338,6338,4290,4226,2178,4291,4323,4291,2210,4290,8613,8614,10694,8614,8646,8646,8614,6403,19274,21483,21419,21451,21386,21386,23499,21419,21419,21386,23499,23466,25579,27594,27659,27626,27626,27626,27594,27594,25513,29674,23336,19046,8483,6370,4225,29479,42025,33575,4225,2113,2145,4225,10596,12676,255},
{457,457,457,458,458,458,458,490,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,588,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,652,653,653,653,653,653,685,685,685,685,685,685,718,718,718,718,718,718,718,750,750,750,750,750,750,783,783,783,783,783,815,815,815,2863,2863,2863,847,847,847,2896,2927,2927,4976,7024,7024,7024,7056,5008,7056,9104,9104,9136,9136,9136,9136,11184,11184,11216,11216,11216,11216,13264,13264,13264,13296,15312,8582,4323,4258,4258,6306,6338,4258,2178,2145,2146,2146,2145,65,2145,8646,8679,8712,8711,8711,10791,10759,6468,19274,21451,19338,21419,19306,21386,21418,21386,21419,21386,23467,23466,25611,27626,27659,25513,25513,25514,23401,25514,23336,25481,23336,16966,6338,4258,4225,31527,41993,31527,6306,2145,2145,4225,8483,10595,255},
{457,457,457,458,458,458,458,489,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,652,652,653,653,653,653,653,685,685,685,685,685,685,718,718,718,718,718,718,718,750,750,750,750,750,751,783,783,783,783,783,815,815,815,815,815,815,847,847,847,847,879,4975,2927,7024,7024,7024,5008,5008,9104,9104,9104,9136,9136,9136,9136,11184,11184,11216,11216,11216,11216,11248,13296,13264,15344,15279,12743,10629,6371,6339,6338,6338,4258,2178,2145,65,97,2146,65,65,6566,8679,8711,8711,10759,8711,8678,8581,25548,27692,27660,27692,27660,27660,27659,27627,29740,27660,29740,29707,31787,31787,33868,31755,29642,29610,31722,33835,29610,25384,21127,14756,10498,10531,12611,35752,48266,35688,6338,4225,4225,4225,6338,10595,255},
{457,457,457,458,458,458,458,490,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,588,588,588,587,587,588,588,588,620,620,620,620,620,620,620,620,620,620,652,653,653,653,653,653,653,685,685,685,685,685,686,718,718,718,718,750,718,750,750,750,750,750,750,783,783,783,783,783,815,815,847,815,815,815,847,847,847,847,847,2927,4976,7024,7024,7024,5008,7056,9104,9104,9104,9136,9136,9136,9136,11184,11184,11216,11216,11216,11248,11248,13296,15344,13296,17392,29871,29903,14920,8549,8484,6371,6403,4290,4226,2178,2178,2145,65,65,6534,8711,10792,8711,8711,10759,10759,8516,16869,19014,18982,18949,18981,18949,18949,21061,18949,16836,18949,16869,16836,16836,18916,16804,16836,18916,16804,16804,16836,16804,14691,14691,14691,14691,16803,37865,48266,31463,6306,4225,2145,2177,6338,14788,255},
{457,457,457,458,458,458,458,490,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,555,587,588,588,587,588,588,588,588,620,620,620,620,620,620,620,620,620,652,652,653,653,653,653,653,685,685,685,685,685,685,718,718,718,718,718,718,718,750,750,750,750,750,750,751,783,783,783,783,815,815,815,815,815,815,847,847,847,847,2927,4975,4976,7024,7024,7024,7056,7056,9104,9104,9104,9136,9136,9136,11184,11184,11184,11216,11216,11216,11248,11248,13296,15344,15345,15279,17195,17227,15115,15115,15115,15114,15114,15114,15050,13002,15114,8646,65,65,6501,8711,8743,8711,10792,10759,10726,6435,6306,6370,6338,6338,6370,6370,6370,6402,6370,6338,6338,6338,6370,6338,6370,6338,6338,6338,6338,4258,6338,6370,6338,4225,4225,4225,6338,37865,48331,27270,4258,6306,4226,2177,6370,12644,255},
{457,457,457,458,458,458,458,458,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,556,587,588,587,588,588,588,588,620,620,620,620,620,620,620,620,620,652,653,653,653,653,653,653,685,685,685,685,685,685,718,718,718,718,718,718,750,750,750,750,750,750,750,783,783,783,783,783,815,815,815,815,815,847,847,847,847,847,2895,4975,7024,7024,7024,7056,7024,7056,9104,9104,9104,9136,9136,9136,9136,11216,11184,11216,11216,11216,11216,11248,13296,15344,15377,13199,8711,8711,10792,10792,10792,10792,10792,10792,10759,8711,10791,8679,4291,65,6468,8679,8711,8646,8614,8646,8646,6436,4290,4290,4258,4290,4290,4290,4290,4290,4290,4290,4290,4290,4290,4258,4290,4290,4290,4258,4258,4290,4258,4226,2145,2145,2145,2145,6338,25254,23142,12611,4258,6306,4258,2145,10563,12643,255},
{457,457,457,458,458,457,458,458,490,490,490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,587,588,588,588,587,588,588,588,588,620,620,620,620,620,620,620,620,620,620,653,653,653,653,653,653,685,685,685,685,685,686,718,718,718,718,718,750,750,750,750,750,750,750,750,783,783,783,783,783,815,2863,815,815,815,847,847,847,847,847,2927,2927,4976,4976,4976,5008,7056,7056,7056,9104,9104,9136,9136,9136,9136,11184,11184,11216,11216,11216,11248,13296,13296,15344,15345,15247,8582,6502,6534,6534,6534,6534,6534,6534,6534,6534,8614,8614,8549,2145,4388,10759,10791,8516,4226,8548,10662,8548,19144,17032,14951,14951,17031,17032,17064,17064,19144,19112,19144,19111,19176,21224,23304,21256,21224,19111,21159,21159,23304,21159,12709,4258,6338,6370,6338,10531,4193,4193,6338,4258,4225,4225,8450,10595,255},
{457,457,457,458,458,457,458,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,555,587,587,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,620,652,653,653,653,653,653,653,685,685,685,685,685,685,718,718,718,718,718,750,750,750,750,750,750,750,750,783,783,783,783,815,2863,2863,847,815,815,847,847,847,847,847,2895,2927,2927,2928,5008,5008,5008,5008,7056,9104,9136,9136,9136,9136,9168,9168,11184,11216,11216,11216,11248,13296,13296,13296,15345,15247,8615,6566,6567,6567,6567,8614,8614,10694,10694,10694,10662,10662,8614,2178,4356,10759,12871,12774,8451,10596,10629,8516,19339,21451,21419,21451,23499,23499,23531,23499,25579,25547,25579,25547,25579,25546,27659,27626,27594,19143,25482,23336,25514,12708,6403,4258,4258,4225,4258,6306,4225,4258,4225,2145,2145,4225,4258,10563,255},
{457,457,458,458,458,458,458,490,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,587,587,587,587,588,588,588,588,620,620,620,620,620,620,620,620,620,652,620,652,653,653,653,653,685,685,685,685,685,686,718,718,718,718,718,750,750,750,750,750,750,750,750,783,783,783,783,815,815,2863,815,847,847,847,847,847,847,879,879,2927,2927,2927,5008,5008,5008,5008,7056,9104,9104,9136,9136,9136,9136,9168,11216,11216,11216,11216,11248,13296,13296,13296,15345,15344,8778,6534,6534,6566,6534,6534,6566,10694,12741,10661,10597,10629,8516,2178,4291,10694,12774,12774,10596,12708,8516,8516,14984,15049,15016,17097,17097,17096,17096,17064,17064,17031,17096,17032,14919,14919,17031,19111,19111,14886,16966,12773,16999,12741,6338,4290,6338,4258,4225,4225,6306,6306,4225,4225,4225,4225,4258,10563,255},
{457,457,458,458,458,458,458,490,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,555,555,555,555,555,555,555,555,555,556,556,588,587,587,588,588,588,588,620,620,620,620,620,620,620,620,652,652,652,652,653,653,653,653,685,685,685,685,685,685,718,718,718,718,718,750,750,750,750,750,750,750,751,751,783,783,783,783,815,2863,815,847,847,847,847,847,2895,2895,879,2927,2928,2928,5008,5008,5008,7056,7056,7088,9136,9136,9136,9136,9168,9168,11216,11216,11216,11248,11248,13296,13296,13296,15345,15377,15312,13101,15181,15181,15181,15213,17261,17262,17294,17294,19342,19374,12905,2145,4259,8646,12774,10628,4323,4323,4323,4323,8613,10693,10693,10694,10694,10694,10694,10693,10693,10661,10694,10661,12742,10661,10629,10661,10629,6403,8483,10629,10564,8484,8516,4258,8451,8451,4225,4225,6306,6306,4258,2145,4225,4225,6338,10595,255},
{457,457,458,458,458,458,458,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,522,523,523,523,523,523,555,555,555,555,555,555,555,555,555,556,555,587,587,587,588,588,588,588,620,620,620,620,620,620,620,620,652,652,652,653,653,653,653,685,685,685,685,685,685,685,718,718,718,718,718,750,750,750,750,750,750,750,751,783,783,783,783,783,2863,815,815,847,847,847,847,847,2895,2896,2896,2927,2927,2928,5008,5008,5008,5008,7088,7088,9136,9136,9136,9136,9168,9168,11216,11216,11216,11248,13296,13296,13296,13296,15345,15377,15377,17457,17457,17457,17457,17489,19537,19537,21585,21585,21585,21585,15083,2177,2210,8711,12774,14821,4291,4291,2243,14854,12742,10694,10694,10726,10694,10694,10694,10693,10661,10661,10694,10661,10661,10629,10661,12741,10629,2177,2113,4226,4258,6338,8451,4225,4225,4225,18916,25221,12611,4225,6306,6306,4225,4225,4258,12708,255},
{457,458,458,458,458,458,458,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,556,556,587,587,587,587,588,588,588,620,620,620,620,620,620,620,620,652,652,652,653,653,653,653,685,685,685,685,685,685,685,718,718,718,718,718,750,750,750,750,750,750,750,751,783,783,783,783,815,815,815,815,847,847,847,847,847,2895,2896,2928,2927,2928,5008,5008,5008,5008,5008,7088,9136,9136,9136,9136,9136,9168,9168,11216,11216,11216,11248,13296,13296,13296,13297,15377,15377,15377,17425,17424,17424,17424,17456,17456,19504,19537,21585,21552,21552,12970,2178,2178,8679,10726,16934,6403,4323,4323,4323,10629,10661,10661,10661,12742,12774,10726,12806,21094,21126,27367,25254,27367,25286,21126,25254,23141,18884,10498,2145,2145,2145,4226,2145,2145,4225,10563,12611,8450,18916,6338,6306,4225,4225,4258,14788,255},
{458,458,458,458,458,458,458,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,556,587,587,587,587,588,588,588,620,620,620,620,620,620,620,620,620,652,652,653,653,653,685,685,685,685,685,685,685,686,718,718,718,718,750,750,750,750,750,750,750,750,751,783,783,783,783,815,815,815,815,847,847,847,847,847,2896,2896,2928,2927,2927,4976,5008,5008,5008,5008,7088,7088,9136,9136,9136,9136,9168,11216,11216,11216,11216,11248,13296,13296,13296,13297,15377,15377,15377,17425,17425,17424,17424,17457,17456,19504,19505,19505,19504,19504,10825,2178,2178,8679,10726,14822,6403,4291,4291,2210,4290,4290,4258,4258,6339,6403,6403,6403,10563,10563,12675,10563,12643,10563,6338,10563,14788,16900,25254,6306,12643,14724,18948,21029,21061,12643,6306,32,6337,27269,8386,6306,4258,4225,6338,12708,255},
{457,457,458,458,458,458,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,555,556,556,556,588,588,587,588,588,588,588,620,620,620,620,620,620,620,620,652,652,652,653,653,653,653,685,685,685,685,685,685,718,718,718,718,718,718,750,750,750,750,750,750,750,750,783,783,783,783,815,815,815,815,847,847,847,847,847,2896,2896,2928,2927,2928,5008,5008,5008,5008,5008,7088,7088,9136,9136,9136,9168,9168,11216,11216,11216,11249,11248,13296,13297,13297,13297,15377,15377,15377,15377,17425,17424,17457,17457,19505,19504,19505,19505,19504,19504,10825,4291,2146,8678,12774,16934,4323,4291,4290,4290,97,2146,2178,2145,2210,10661,10661,8613,8581,8581,10629,8581,10661,8483,4225,8450,12611,21061,31527,14724,14756,12643,12643,23141,25253,10498,4225,64,6337,23108,6338,4258,6338,4258,6338,10595,255},
{457,457,458,458,458,458,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,556,588,588,588,587,588,588,620,620,620,620,620,620,620,620,620,620,652,653,652,653,653,653,653,685,685,685,685,685,685,718,718,718,718,718,718,750,750,750,750,750,750,750,750,783,783,783,815,815,815,815,815,847,847,847,847,847,2896,2896,2928,4976,2928,4976,5008,5008,5008,7056,7088,7088,9136,9136,9136,9168,9168,11216,11216,11216,11216,11248,11248,13297,13297,13297,13329,15377,15377,15377,17425,17457,17457,17457,19505,19504,19505,19505,19504,19472,8615,2145,2146,8646,12774,8548,4355,4323,4323,4290,2145,2146,2178,2145,2178,10758,12839,12839,12806,12806,12807,12806,12806,8548,6305,12611,14691,23109,33672,35784,25221,12611,4257,25253,27302,10466,2112,32,4257,20996,6306,4258,4225,4225,6370,12708,255},
{457,458,458,458,458,458,490,490,490,490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,556,588,588,587,588,588,588,588,588,620,620,620,620,620,620,620,620,652,653,653,653,653,653,653,685,685,685,685,685,685,718,718,718,718,718,750,750,750,750,750,750,750,750,750,783,783,783,815,815,815,815,815,847,847,847,847,847,2896,2896,2928,4976,4976,5008,5008,5008,5008,5008,7088,7088,9136,9136,9136,9136,9168,11216,11216,11216,11248,11216,11248,13296,13296,13297,13329,15377,15377,15377,17425,17457,17457,17457,19505,19504,19504,19505,19472,19472,8582,2145,2178,8581,12806,10661,4355,4291,4323,4291,2145,2146,2178,2145,2178,10726,10759,12839,10726,10694,12774,12774,12806,8548,6337,14691,18884,25189,31527,33671,27268,21028,4225,23173,23141,8418,14724,23110,23110,33608,10499,4225,4225,4225,6338,12676,255},
{458,458,458,458,458,490,490,490,490,490,490,490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,556,556,556,588,588,588,588,588,588,620,620,620,620,620,620,620,620,652,652,652,653,653,653,653,653,685,685,685,685,685,686,718,718,718,718,718,750,750,750,750,750,750,750,750,751,783,783,815,815,815,815,815,815,847,847,847,847,2895,2896,2896,2928,2928,4976,5008,5008,5008,5008,7088,7088,7088,9136,9136,9136,9168,9168,11216,11216,11216,11248,11216,11248,13296,13297,13297,13329,15377,15377,15377,17425,17457,17457,17457,19505,19504,19504,19504,19504,19472,8550,4226,4226,10629,14854,6436,2242,4355,4323,4323,2146,2145,2146,2145,2145,8645,10694,12807,12774,10726,12774,10661,12806,10596,8386,16771,27268,29381,27236,27301,27301,16771,4225,25253,23141,10530,37932,65368,63189,63190,18885,2145,4225,4225,4258,10531,255},
{458,458,458,458,458,490,490,490,490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,556,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,652,652,652,652,653,653,653,653,685,685,685,685,685,685,718,718,718,718,718,718,750,750,750,750,750,750,750,751,783,783,815,815,815,815,815,847,847,847,847,847,2896,2896,2896,2928,2928,4976,5008,5008,5008,5008,7088,7088,7088,7088,7088,9136,9168,9168,11216,11216,11216,11248,11248,11248,13297,13297,13329,13329,15377,15377,15377,17425,17457,17457,17457,19505,19505,19505,19504,19504,19439,8516,4226,4226,8548,12806,6468,2243,4323,4323,4323,2146,2145,2146,2145,2145,6468,6436,6403,8580,8581,6403,6403,6468,6403,10498,18883,25188,29348,25188,27236,27300,16771,4258,23141,18916,14723,37964,65369,63190,63190,18885,4225,6338,8451,8451,8483,255},
{458,458,458,458,458,490,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,556,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,652,652,652,652,653,653,653,685,685,685,685,685,685,686,718,718,718,718,718,750,750,750,750,750,750,783,783,783,783,783,783,815,815,815,815,847,847,847,847,847,847,2896,2928,2928,2928,4976,5008,5008,5008,5008,7088,7088,7088,7088,7088,9136,9168,11216,11216,11216,11216,11216,11248,11248,13297,13297,13297,15377,15377,15377,17425,17425,17457,17457,19505,19505,19505,19505,19504,19504,19407,6404,4226,4226,6468,14886,10629,4291,4290,4323,4291,2145,2145,2145,2145,2145,4290,2242,2210,4322,4355,2210,4290,2210,2177,8418,23044,27236,29348,25188,27268,29349,20964,10531,21029,23109,10530,37997,65369,63223,65271,18885,2145,6338,6370,4257,8418,255},
{458,458,458,458,458,458,490,490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,555,556,588,587,588,588,588,588,588,620,620,620,620,620,620,620,620,652,652,652,653,653,653,653,685,685,685,685,685,685,718,718,718,718,750,750,750,750,750,750,750,783,783,783,783,783,783,815,815,815,815,847,847,847,847,847,847,2896,2928,2928,4976,4976,5008,5008,5008,5008,7088,7088,7088,7088,7088,7088,9168,11216,11216,11216,11216,11248,11248,13296,13297,13297,13297,13329,15377,15377,17425,17457,17457,17457,19505,19505,19505,19505,19504,19504,19374,6339,2145,2145,6371,14854,8516,4291,4291,2242,4291,2178,2145,2145,2145,2145,4290,4290,4290,4323,4322,4290,4323,2242,2178,8386,16803,27268,29348,27236,27268,27268,25189,14723,25221,20996,10498,40045,65369,63223,65304,18853,65,2145,2145,2145,4225,255},
{458,458,458,458,458,490,490,490,490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,556,588,588,588,587,588,588,588,620,620,620,620,620,620,620,620,620,652,652,652,652,653,653,653,653,685,685,685,685,685,685,717,718,718,718,718,750,750,750,750,750,751,751,783,783,783,783,783,815,815,815,815,847,847,847,847,847,847,2896,2928,2928,2928,4976,5008,5008,5008,5008,7056,7088,7088,7088,7089,9137,9168,11216,11216,11216,11248,11249,11249,13297,13297,13297,13297,13329,15377,15377,17425,17457,17457,17457,19505,19505,19505,19537,19504,19504,19309,6338,4225,4225,4258,2210,2210,2242,4290,4290,4290,2145,2146,2145,2145,2145,4290,4290,8548,8580,4355,6403,6403,4290,4290,12578,18883,27236,29348,27236,27268,27300,18883,8418,23141,18948,10531,37997,65369,63223,56785,29316,23011,23043,23011,23043,23043,255},
{458,458,458,458,458,490,490,490,490,490,490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,556,588,588,588,587,588,588,588,620,620,620,620,620,620,620,620,620,652,652,652,652,653,653,653,685,685,685,685,685,685,685,717,718,718,718,718,750,750,750,750,750,750,751,783,783,783,783,815,815,815,815,815,847,847,847,847,847,2895,2896,2896,2928,4976,4976,5008,5008,5008,7056,7056,7088,7088,7088,7088,9136,9168,11216,11216,11216,11216,11249,11248,13296,13297,13297,13297,13329,15377,15377,17425,17457,17457,19505,19505,19505,19537,19537,21552,19504,21519,27693,27725,19145,8451,10661,8549,6468,6500,6468,8548,4290,65,2145,97,2145,4290,8483,12708,12741,10628,10628,6403,4290,6338,10498,12611,14723,18915,16771,16771,20964,12611,4225,25253,23109,10530,37997,65369,63158,43974,46020,50181,50213,50213,50213,52261,255},
{458,458,458,458,458,490,490,490,490,490,490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,556,556,587,587,587,588,588,588,588,620,620,620,620,620,620,620,620,652,652,652,653,653,653,653,653,685,685,685,685,685,685,717,718,718,718,718,718,750,750,750,750,750,751,783,783,783,783,815,815,815,815,815,847,847,847,847,847,847,2896,2896,2928,4976,4976,5008,5008,5008,7056,7088,7088,7088,7088,9136,9136,9168,11216,11216,11216,11248,11216,11248,13296,13297,13297,13297,13329,15377,15377,17457,17457,17457,17457,19505,19505,19505,19537,21552,21553,19438,21419,21452,19242,12871,17097,17162,15017,15048,15016,15016,14984,10694,2145,65,2145,2178,6338,10564,6403,8516,8548,8483,6338,10531,6306,6338,6305,10498,8386,8450,16803,10531,6306,27333,25189,12611,40046,65402,61045,41861,43940,46020,46053,48166,48198,48199,255},
{458,458,458,458,490,490,490,490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,556,556,587,588,588,588,588,588,620,620,620,620,620,620,620,620,620,652,652,652,653,653,653,653,653,685,685,685,685,685,685,718,718,718,718,750,750,750,750,750,750,750,750,783,783,783,783,783,783,815,815,815,847,848,848,848,847,847,2895,2896,2928,4976,4976,5008,5008,5008,5008,7056,7088,7088,7088,9136,9136,9168,11216,11216,11216,11249,11248,11248,13296,13297,13297,13329,13329,15377,15377,17425,17457,17457,17457,17457,19504,19504,19537,21585,21585,17261,10759,10791,12904,12904,12904,12936,14984,15016,14984,14984,12968,14984,6404,33,2146,2178,4322,8483,8515,6435,6435,6403,16835,23076,4193,2113,2145,2145,2113,2145,6338,8418,10563,27334,23109,12611,40110,65401,56785,39780,46020,48100,41861,14724,14724,20964,255},
{458,458,458,458,490,490,490,490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,556,556,556,587,588,588,588,588,588,620,620,620,620,620,620,620,620,620,652,652,653,653,653,653,653,653,653,685,685,685,685,685,718,718,718,718,750,750,750,750,750,750,750,751,783,783,783,783,815,815,815,815,815,847,848,848,848,847,847,2896,2896,2928,4976,4976,4976,5008,5008,5008,7056,7088,7088,7088,9137,9137,9168,11216,11216,11216,11248,11249,11248,13296,13297,13297,13329,15377,15377,15377,17425,17425,17457,17425,17456,19504,19504,19537,21585,21585,17164,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,65,2146,2210,4290,4322,4322,4355,4323,6403,25188,25156,2145,2145,2177,2145,2145,2145,4258,8418,10531,21029,18948,8450,40110,65402,61044,46054,46020,48101,43941,25190,29382,50214,255},
{458,458,458,458,458,490,490,490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,556,588,587,588,588,588,588,588,620,620,620,620,620,620,620,620,652,652,652,652,653,653,653,653,685,685,685,685,685,685,686,718,718,718,718,718,750,750,750,750,750,750,751,783,783,783,783,815,815,815,815,815,847,848,848,848,847,2896,2896,2896,2928,4976,4976,4976,5008,5008,7056,7056,7088,7088,7088,9137,9136,9168,11216,11216,11216,11249,11249,11248,13296,13297,13297,13329,15377,15377,15377,17457,17457,17457,17457,17456,19504,19505,19537,21584,21585,17196,8581,8646,8614,8582,8614,8614,8614,10694,8613,8613,8613,8613,10661,2145,2146,4290,4322,4323,4322,4322,4323,6403,23076,25124,2113,2113,2113,2113,2113,2113,2113,2145,2145,2113,2145,2144,40110,65369,63157,46087,43940,46020,41861,25222,25222,33574,255},
{458,458,458,458,490,490,490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,556,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,652,652,652,652,653,653,653,685,653,685,685,685,685,686,718,718,718,718,718,718,750,750,750,750,750,750,783,783,783,783,783,815,815,815,815,815,847,848,847,847,2895,2896,2896,2896,2928,4976,4976,4976,5008,5008,7056,7088,7088,7088,7088,7088,9136,9168,9168,11216,11216,11248,11249,11248,13296,13297,13297,13329,15377,15377,17425,17457,17457,17457,17457,19505,19505,19537,19537,21585,21616,19406,12774,12741,10596,12709,10628,12677,8516,8516,10596,8516,10596,8483,6435,4258,2146,2210,4290,4323,4322,4322,4322,8515,25188,25156,4193,4258,4225,2145,2145,4225,2177,2145,32,32,64,2112,40110,65369,63125,46054,43908,46020,41861,14691,16804,31396,255},
{458,458,458,490,490,490,490,490,490,490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,556,556,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,620,652,652,653,653,653,653,653,685,685,685,685,685,718,718,718,718,718,718,750,750,750,750,750,751,751,783,783,783,783,815,815,815,815,815,847,847,847,848,2896,2895,2896,2928,2928,4976,4976,5008,5008,5008,7056,7088,7088,7088,7088,9136,9136,9168,11216,11216,11216,11248,11249,11248,13296,13296,13297,13329,15377,15377,17425,17425,17457,17457,17457,19505,19505,19537,21585,21585,21584,21616,19374,19309,21421,23501,23533,23468,19308,19275,19275,19275,21323,21323,14919,4290,2145,2178,4290,4322,4290,4322,4290,6403,23076,25123,4257,6435,6435,6435,6403,6403,6370,4290,4225,2113,2112,2145,40110,65369,63125,46054,43940,48101,46054,29415,33607,50279,255},
{458,458,458,490,490,490,490,490,490,490,490,490,490,490,490,522,522,522,522,523,523,522,522,523,523,523,523,555,555,555,555,555,555,555,555,555,555,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,652,652,653,653,653,653,653,685,685,685,685,685,685,718,718,718,718,718,718,750,750,750,750,750,751,783,783,783,783,783,815,815,815,815,815,847,847,848,847,2896,2896,2896,2928,2928,4976,4976,5008,5008,5008,7056,7088,7088,7088,7088,9136,9136,9168,9168,11216,11216,11216,11248,13296,13296,13296,13296,13329,15377,15377,15377,17425,17457,17457,17457,19505,19537,19537,19537,21585,21585,21616,23665,23665,23697,23697,23697,25777,25776,25776,25776,25744,27792,27824,21291,4290,97,2210,4323,4323,4290,4290,4290,4323,16803,23011,4257,6467,6435,6435,4322,6435,6371,4290,4290,2145,2113,2177,40142,65369,63125,46086,43940,46020,41829,16804,16804,23044,255},
{458,458,490,490,490,490,490,490,490,490,490,490,490,490,490,522,522,490,490,522,4650,6763,8843,8811,6730,4683,2603,555,523,555,555,555,555,555,555,555,555,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,652,652,652,653,653,653,685,685,685,685,685,685,717,718,718,718,718,718,718,750,750,750,750,750,750,783,783,783,783,783,783,815,815,815,815,847,847,847,848,848,2896,2896,2928,2928,4976,4976,5008,5008,5008,7056,7088,7088,7088,7088,9136,9136,9168,11216,11216,11216,11216,11248,11248,13296,13296,13296,13297,15377,15377,15377,17425,17457,17457,17457,19505,19537,19537,21585,21585,21585,21616,21617,23665,23665,23664,23664,23696,23696,23663,25711,25711,25711,27791,19243,4290,2145,2210,4322,4355,2242,2242,4290,6403,16804,18883,4257,6435,6435,6435,6370,6403,6403,6371,4225,2145,2145,4289,42191,65369,63157,48134,46020,48101,43974,25190,29382,50246,255},
{458,458,490,490,490,490,490,490,490,490,490,490,490,490,490,490,4650,10891,17099,25386,29547,33773,29580,25355,29515,31693,25452,19114,12971,2603,555,555,555,555,555,555,555,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,652,653,653,653,653,653,685,685,685,685,685,685,717,717,718,718,718,718,718,750,750,750,750,750,750,783,783,783,783,783,783,815,815,815,815,815,847,847,847,847,2896,2896,2928,4976,4976,4976,5008,5008,5008,7056,7088,7088,7088,7088,9136,9168,11216,11216,11216,11216,11249,11248,11248,13296,13296,13296,13329,15377,15377,15377,17425,17457,17457,17457,19505,19505,19537,19537,21585,21585,21616,21617,23664,23664,23664,23664,23696,23664,23663,25711,25711,25679,27791,21258,6403,2145,2178,4355,6403,4355,4322,4290,6370,8418,8418,4225,6435,6435,6435,6371,6403,6435,6371,4258,2113,2113,2177,42190,65369,63125,43973,43940,46053,41894,25223,25255,35655,255},
{458,458,490,490,490,490,490,490,490,490,490,490,490,490,6699,19179,27435,35820,40045,37901,37934,35885,31693,29547,33806,33806,31628,27434,25321,23209,17034,10825,555,555,555,555,555,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,652,652,653,653,653,653,685,685,685,685,685,685,685,717,718,718,718,718,718,718,750,750,750,750,750,751,783,782,782,783,783,783,815,815,815,847,847,847,847,847,2896,2896,2928,4976,4976,5008,5008,5008,5008,7056,7088,7088,7088,7088,9136,9136,9168,11216,11217,11216,11249,11248,13296,13296,13296,13297,13329,15377,15377,15377,17425,17425,17457,19505,19505,19504,19537,21585,21585,21585,21616,23633,23632,23664,23665,23664,23696,23696,23663,25711,25711,25679,27759,19178,8516,2178,2178,4323,4355,4323,4322,4290,4290,4225,2113,2145,6435,6435,6403,2177,6403,6435,6370,4257,2145,2113,2177,42190,65369,63157,46054,43940,48101,46021,35556,35556,33476,255},
{458,458,490,490,490,490,490,490,490,490,490,490,4586,21259,29548,37868,39980,29480,35753,35819,35754,39946,33673,33673,37866,37834,35721,18949,10498,16804,21031,29514,25484,10956,2635,555,555,556,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,652,652,653,653,653,653,685,685,685,685,685,685,685,685,717,718,718,718,718,718,750,750,750,750,750,751,783,782,782,783,783,815,815,815,815,847,847,847,847,847,2896,2928,2928,2928,2928,5008,5008,5008,5008,5008,7088,7088,7088,7088,9136,9136,9168,11216,11216,11216,11249,11248,13296,13296,13297,13329,15377,15377,15377,15377,17425,17425,17457,19505,19505,19504,19537,21585,21585,21585,21616,23633,23632,23664,23665,23664,23696,23696,25711,25711,25679,25679,27759,19113,6371,2178,2178,4290,4322,4323,4322,4290,4258,4225,2113,2145,6403,6435,4290,4257,6403,6403,4258,4225,2113,2113,2177,42190,63223,61011,43974,43973,48101,48134,50246,50214,50246,255},
{458,458,490,490,490,490,490,490,490,490,458,8778,31628,27468,33675,48332,21062,27336,25288,16837,18950,25223,25255,18917,12644,14724,12643,6305,16803,27270,37833,37867,29448,27368,14985,555,555,555,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,652,653,653,653,653,653,685,685,685,685,685,685,685,717,717,718,718,718,718,750,750,750,750,750,751,750,782,783,783,783,815,815,815,815,815,847,847,847,2895,2896,2928,2928,2928,2928,5008,5008,5008,5008,5008,7088,7088,7088,7088,9136,9136,9168,9168,11216,11216,11216,11248,13296,13296,13296,13297,15377,15377,15377,17425,17425,17425,17457,17457,19504,19504,19537,21585,21585,21585,21616,23633,23665,23665,23664,23696,23696,23696,23663,25711,25711,25679,27759,14920,4258,2178,2178,4323,4322,4322,4322,4290,4322,2177,2145,2145,6403,6403,4290,4225,6371,6370,4258,4258,2145,2145,4290,42157,63156,52526,20931,10498,10498,10498,10498,10498,10498,255},
{458,458,490,490,490,490,490,490,490,458,14987,37933,25387,27403,50445,25288,18950,25256,23175,12677,21063,21095,29481,21063,18982,16837,16772,10499,16771,39914,35753,35721,23110,14659,14723,12905,555,587,588,588,588,588,588,588,588,588,620,620,620,620,620,620,620,652,652,653,653,653,653,653,685,685,685,685,685,685,685,685,717,717,718,718,718,718,750,750,750,750,750,783,783,783,783,783,815,815,815,815,847,847,847,847,847,2896,2896,2928,2927,2927,5008,5008,5008,5008,7088,7088,7088,7088,7088,9136,9168,9168,9168,11216,11216,11216,13296,13296,13296,13296,13297,15377,15377,15377,17425,17425,17424,17457,17457,19504,19504,19537,21585,21585,21585,21616,23632,23665,23665,23664,23696,23696,23664,23663,25711,25679,25679,27759,14888,4258,4226,2178,4322,4323,4323,4322,4322,4355,4290,2145,2145,6435,6403,6403,2177,6403,6435,6370,4258,2145,2145,6370,42189,63189,52526,10466,2145,2145,2145,2145,2145,2113,255},
{458,490,490,490,490,490,490,490,458,14986,25387,25355,23242,50380,44204,12709,16870,16870,21095,18982,16903,10597,21095,12677,14757,10499,16771,14691,31462,52656,37833,21062,6273,16804,6305,16804,12840,2603,587,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,652,652,652,653,653,653,653,685,685,685,685,685,685,685,717,717,718,750,718,750,750,750,750,750,750,783,783,783,783,783,815,815,815,815,815,847,847,847,847,2896,2896,2928,2927,2928,5008,5008,5008,5008,5008,7088,7088,7088,9136,9136,9136,9168,9168,11216,11216,11216,13296,13296,13296,13296,15344,15345,15377,15377,17425,17425,17425,17457,17457,19505,19504,19537,21585,21585,21584,21616,23632,23665,23665,23664,23664,23696,23696,23663,25711,25679,25679,27759,12775,4258,4258,2178,4290,4290,4290,4322,4290,6435,4323,4258,2177,6435,6403,6403,4290,6435,6435,6370,6370,2145,2145,4290,42190,63157,60978,25191,2113,2145,2145,2145,2145,20997,255},
{458,458,490,490,490,490,490,458,12939,31692,19147,25452,29514,54638,42059,25320,19047,21096,35787,27433,16903,16902,23175,27368,16837,6338,8418,16771,50445,44140,42092,8386,8354,12546,10498,6273,14724,12840,587,587,587,587,588,588,588,588,588,620,620,620,620,620,620,620,620,652,652,653,653,653,653,653,685,685,685,685,685,685,685,717,717,718,2766,718,750,750,750,750,750,750,782,783,783,783,783,815,815,815,815,2895,2895,2895,2895,847,2927,2927,2928,2927,4976,5008,5008,5008,7056,7088,7088,7088,9136,9136,9168,9168,9168,11216,11216,11216,11248,13296,13296,13296,15344,15345,15377,15377,17425,17425,17424,17457,17457,19504,19505,19537,21585,21585,21584,21584,23632,23664,23664,23664,23664,23664,23664,25711,25711,25711,25711,27759,12742,4258,4290,4258,4323,4323,4290,4322,4323,4355,4323,4290,2177,6435,6435,6435,6370,6371,6403,6403,4290,2145,2113,4257,44270,63157,61043,50414,6273,2145,4225,4225,2145,8450,255},
{458,490,490,490,490,490,490,6698,31692,25386,19147,27500,35722,54670,23208,19015,14790,19015,27401,19080,10662,21095,25288,29481,12644,8418,4193,31430,54704,44139,23110,12546,6273,6273,14691,4193,12643,17001,10890,555,587,587,587,587,588,588,2636,588,620,620,2668,2668,2668,620,620,652,652,652,653,653,653,685,685,685,685,685,685,685,685,685,718,717,718,2766,2766,750,750,750,750,750,2830,2830,782,782,2830,815,2863,2863,2863,2895,4943,4943,4943,2895,2927,4975,4976,4976,7024,7056,7056,7056,9104,9104,9104,9136,9136,9136,9136,11216,11216,11216,11216,11216,11248,13296,13296,13296,15344,15345,15345,15377,17425,17424,17424,17457,17457,19504,19504,19537,21585,21585,21584,21584,23632,23664,23664,23664,23664,23663,23631,25711,25711,25711,25711,27759,12710,6338,4290,4258,4323,4323,4355,4323,4355,4355,4355,4323,2177,6435,6435,6403,4290,6403,4258,4290,6338,2145,2113,4258,44270,61076,58930,54672,10466,2145,4225,2145,64,19046,255},
{458,490,490,490,490,490,2538,25355,29677,8714,21227,23274,50380,42125,16903,27401,27401,23273,27433,27434,19048,29514,21161,23176,6306,8418,14691,39848,37767,37898,8354,14659,8354,8386,16771,4225,8418,12840,14856,4618,555,555,555,555,555,555,555,588,556,588,588,588,588,588,620,588,620,620,620,621,621,621,653,653,653,653,653,685,653,685,685,685,685,685,718,718,718,718,2798,2798,2798,2798,2798,2830,2830,2830,2831,2863,2863,2863,4911,2895,2895,4943,4943,4944,4976,4944,7024,7024,7024,7056,7056,7056,9104,9136,9136,9136,11184,11184,11184,11216,11216,13264,13264,13264,13264,13296,15344,15344,15377,15377,17425,17424,17424,17457,17456,19504,19505,21553,21585,21584,21616,21584,23664,23664,23664,23664,23664,23599,23599,23631,25711,25711,27759,27727,10597,4258,4258,4258,4322,4290,4322,4322,4322,4322,6371,4290,2145,6435,8515,6371,6370,6403,4290,4290,4258,2145,2113,6338,46382,63124,58962,56752,10466,2145,4225,2145,65,25320,255},
{458,490,490,490,490,458,12938,27500,21324,29580,39947,50413,60878,25353,19016,39980,27466,23273,27401,37867,27401,23273,17032,25255,8418,6305,23044,52558,31527,27335,6273,14691,6241,8353,14691,8418,6306,27204,37768,25255,42092,42060,44173,39946,37834,40012,37932,35785,35851,35852,31658,31691,31691,29545,31691,31692,29546,29611,29644,29579,27531,27596,25451,23371,23436,23404,21323,21323,23437,21356,19276,19276,21357,21357,19276,17228,19309,17229,17229,15181,15213,15181,15181,17229,15181,13133,13133,13134,13166,13134,11086,11086,11118,11119,11118,11119,11119,11119,11119,11119,11119,11151,11151,11151,11183,11184,11184,11184,11184,11184,11184,11184,13264,13264,13264,13264,13264,13264,13264,13297,15345,15345,15344,15377,17425,17425,17425,17457,19505,19505,19505,19537,19537,21585,21617,23665,23665,23664,21584,21551,23599,23631,23663,25711,25711,25646,8516,4258,4258,2178,2145,2145,2210,2177,2177,2113,65,65,64,6403,6371,4290,4290,4290,4290,4258,2177,2113,65,8483,52688,61044,58962,54672,10466,2145,4225,2145,32,23207,255},
{458,458,490,490,490,490,29580,23273,39980,58832,63090,56751,39946,21128,23274,35820,23370,23338,23241,27401,23240,25418,31691,31529,25190,8418,33543,54638,44073,14756,8353,16771,8418,8386,10498,8418,4193,27236,54473,31495,52393,65005,62958,58665,60713,65038,60779,58600,65005,62859,56487,60779,58665,56454,62860,60714,58566,62793,64940,58600,60745,62859,56454,58566,62859,58600,56453,58600,62892,58567,56487,60745,62925,60779,58568,58633,62860,58633,56520,56552,58666,56520,56520,58731,56618,54440,52295,54440,56619,54441,52360,52392,56619,54538,52393,52425,54539,50346,46120,46119,50378,52459,50313,48265,48265,50444,46218,44072,41992,41992,46283,48397,44138,42025,44203,46317,44171,42091,44237,42124,40010,40043,42221,40076,37963,40044,40109,37964,37963,37996,40109,37964,35916,38029,38029,35948,38094,35949,35916,35981,33868,33836,33868,36013,35981,35916,38028,37963,23109,18916,23141,18981,18949,18981,18949,18916,18949,16868,12578,12578,12611,12611,12611,12643,12643,12611,8450,8418,8418,16901,56915,61076,61043,54672,8418,4225,2145,2145,32,27465,255},
{458,490,490,490,490,10826,29514,27369,54672,54638,60977,52459,46318,33739,35885,46416,38129,35886,37998,35853,35853,42224,46548,18983,10466,6273,44041,52590,42025,10466,10466,14659,8386,4193,8418,8418,4193,27203,52392,39847,37669,58665,56586,52359,54472,58731,54440,52326,58731,54472,50213,56585,52359,50213,58698,52391,50213,56519,58665,52293,56519,54472,48100,52261,58633,50213,48100,54407,58666,52294,52261,56520,58666,56553,52326,56520,58666,54407,52293,54406,56552,52294,54407,58665,56584,52326,52261,54439,56552,54406,52294,54406,58665,56519,54374,56487,58633,54374,50181,50181,58601,56520,54342,56454,54406,58698,52326,50181,50148,50181,58633,60714,54342,52228,58600,58665,54374,54374,60714,56455,52261,56454,60713,54374,54309,58567,58633,54342,52261,56519,56552,52293,52261,56520,52326,52294,58666,54374,54407,58666,52294,50213,52294,56553,54407,52326,58698,56520,52326,56552,56552,54406,54407,56585,54439,52326,56553,52359,48166,50246,54473,50279,48166,52360,52424,50279,48167,52360,48167,44072,58963,61044,61011,54639,8386,4258,4225,2113,2112,33770,255},
{458,490,490,490,490,23274,25354,44141,65202,65203,61010,54605,52721,33772,33772,42256,46514,48627,42223,44303,50642,52854,46548,6371,6305,6273,48266,46220,27334,8386,6273,12578,8386,6305,8418,8418,4193,16739,31429,23044,18851,37669,37701,35589,39781,46119,43974,43974,46054,43941,37668,46054,43941,39748,48134,43941,41796,46021,46022,37668,43909,43941,35555,37668,48134,41796,37635,43941,50246,41828,41796,46053,50246,48166,43909,48133,52294,43909,41796,43908,48133,41828,43941,50246,50214,43941,41861,46021,50214,46021,43908,43941,52327,48134,46020,46021,52327,45989,41796,41796,50246,48134,43940,46021,48101,52360,43908,41796,39716,41796,52327,52327,43908,41828,50247,54407,46021,46021,52359,48101,43940,48101,54407,46021,43908,50214,54407,46020,43908,50246,50246,46020,43940,50246,46053,46053,54440,48101,48133,54439,46020,45988,48068,54407,50181,50213,54472,50246,48100,52358,52358,50180,50213,54439,50214,50181,54471,50246,48133,48166,54472,48165,48133,52326,52359,48166,46053,52359,48134,46119,58963,61076,61043,54640,8418,4225,4193,2113,64,35851,255},
{458,490,490,490,6698,23306,25354,54606,65102,62991,58798,56718,52624,25354,21096,27434,35885,40045,21193,23241,37964,31658,23273,8418,12611,18819,54572,44139,25254,6273,6273,12578,6338,4193,10498,10530,8386,8418,4225,8418,6305,6273,8386,6305,18851,29383,23077,35655,12546,12578,12546,14626,14626,12578,16706,23076,23076,37734,16771,14626,14658,16706,14594,14626,22978,48101,50180,54440,56585,52293,52293,54439,58633,56520,50214,52359,56585,50246,50181,52294,54439,48133,50214,54472,54440,48134,48102,50214,52360,48134,46021,41829,29251,27203,27171,27171,31364,29284,25091,31396,33508,29316,29251,29283,31363,35589,29251,31363,39716,39716,48166,50214,39716,37603,46054,48134,39748,39716,46054,39748,35556,39748,46053,39716,35555,41828,46053,37603,35523,41828,41828,35555,33475,39748,35588,35588,41893,35556,35588,41861,33475,33475,35555,43941,39716,39780,46054,41860,39716,43941,43973,41796,41828,43973,41828,39748,43973,41860,37668,39780,46053,41828,39780,43940,43941,39780,35588,41861,37668,37767,58963,61044,61043,54640,8386,4225,2145,2113,64,35851,255},
{458,490,490,490,12906,25322,35657,60977,58896,50411,54604,54572,33707,19048,14757,19048,23241,27433,14758,16902,29514,23208,16869,6338,16771,23076,54605,39945,23142,4193,8354,10498,6306,4225,8386,6305,12578,31462,25254,12677,27238,29448,25321,25321,29481,33576,35656,39848,18916,19015,19048,16935,16935,16936,18983,25255,25222,37735,12611,12775,12743,12710,10662,10630,20997,52293,54373,60713,58633,54406,56486,60745,62859,58633,54407,58665,60746,56486,54406,58600,60713,54406,56519,60779,58665,54439,56487,58601,60746,56520,56487,41861,4226,6339,6339,6306,8419,14691,12611,31429,14659,6306,8386,8386,8386,10466,8354,27203,54373,52293,58665,58665,52293,52261,56584,58633,54374,52326,58665,54375,50213,54406,58666,52326,50213,54439,56585,50213,50213,56552,54440,50181,48133,54440,50214,48166,25091,16706,16738,18818,16706,18851,25124,25156,33508,22979,23011,20931,20898,23043,25091,22978,27203,43973,37636,33476,41861,37636,31363,33476,41828,33443,29283,35556,37636,33476,31363,37700,29315,31494,58963,61043,61011,54639,8386,4225,4225,2145,2112,35883,255},
{458,490,490,458,17002,33510,52360,62925,58764,58731,44073,52557,21160,19015,14822,19047,16968,23241,10597,16871,21193,16968,10596,4225,12579,10498,39880,44105,16869,4161,6306,16739,25156,20964,23044,27237,44007,60844,50346,37702,60844,60844,60778,62957,60844,58633,62860,60844,58600,58666,60779,56520,58666,58698,54440,58633,60779,56553,54472,58699,52392,52327,54506,54539,52327,54406,60746,58665,56487,56487,60778,60811,58666,56520,58698,60747,56552,56487,56552,58665,56519,56520,60746,58666,56488,54439,56553,58666,56552,54407,56487,48168,31560,31625,31593,31659,31626,33575,31462,41927,29415,25386,25353,25353,25386,23306,23241,35687,52261,52294,56552,54407,50180,48101,54440,50247,46021,50182,54440,48133,48100,52326,56553,50181,50212,56519,56553,52261,50212,56553,54439,52261,52293,56552,52294,52294,16837,8517,8517,8517,8517,14757,20997,21030,33542,12611,8419,12579,10499,10466,8418,8386,16771,52327,48101,43940,52359,50213,46020,48133,54472,48133,46021,50214,52327,50246,48134,54439,48134,46152,58963,61044,61043,54640,10466,10564,4226,4225,2113,37964,255},
{458,490,490,490,19016,37735,50214,56586,52393,54407,41992,52525,12742,10629,19048,14855,10662,14822,12742,16902,10694,8549,16869,8386,8386,16771,46251,35687,14724,6338,8418,37702,46087,39750,50378,48266,50346,50412,48266,48232,52459,52459,50280,52425,56652,52360,54440,56586,54407,54439,58699,56520,56487,58666,58666,58567,60811,60746,56486,58599,60746,58600,56519,58599,60746,58600,58632,58632,60746,60746,60746,60745,60746,60713,60713,58600,58632,60681,58632,58633,60713,60746,60714,58633,56520,58600,58665,58665,56520,56520,58600,60778,58632,58599,58600,60779,58600,56487,56519,60746,58665,56487,56520,56552,60779,54440,52326,52294,54407,60779,60811,54407,52293,56552,60779,56488,54407,58666,56553,52294,52294,58666,56520,52326,54406,60746,56520,54374,54407,60714,54407,52326,54406,58698,52327,56553,48298,44105,46251,46251,44105,44105,44105,48331,48232,44106,44204,54572,50379,50412,48266,46154,48266,54472,50246,48133,54440,50214,46021,48166,52392,46053,46021,50246,50279,48166,48134,52327,43941,46120,58963,61043,58962,52559,8418,8451,4226,4225,2145,37996,255},
{458,490,490,490,25354,37767,41829,46120,35687,31397,44040,50445,21096,16871,35755,21096,18950,18983,31529,23176,16870,16903,18950,18949,6306,25124,50477,29382,8418,4193,12578,54440,31429,37702,10661,4389,6469,6502,6502,6502,8582,8582,8581,10630,10662,10662,10662,12742,12742,12742,14822,14789,14821,16935,16967,16934,19079,21095,18982,21062,23207,23142,23109,23142,27335,25254,25222,27335,31560,31560,31495,31527,33673,33607,33574,33542,37768,37768,35654,37767,41993,41927,39814,41895,46120,46153,44007,43974,46087,50313,48200,48167,50280,54539,54539,50280,50214,54506,56586,52360,52359,54407,56586,56553,52327,52294,52294,54439,60779,58666,52327,52294,58633,60746,58600,56487,58633,58600,56487,56487,58633,58600,56486,56519,60746,58632,56487,56486,58665,58633,56455,56487,58665,56520,56488,60746,58633,56487,60746,58600,56454,56487,60746,60746,56487,58665,58698,54406,56519,60811,56519,54439,58600,58666,54439,54472,58698,54439,52326,54439,58666,52326,52294,54505,56585,52392,52327,54472,48166,48265,58996,61076,61076,52559,8354,2145,4225,4225,64,40077,255},
{458,490,490,490,25354,35655,27204,33509,33542,18819,31429,33608,12677,12678,23208,19015,12709,14789,21095,16902,12676,12742,14724,12611,6306,23044,42026,33607,8451,6306,10498,39814,23076,27236,8581,6502,6502,6502,6502,4454,4422,4454,4422,6502,4454,4454,4422,4454,4454,4454,4454,4422,4422,4454,4454,4454,2406,4455,4487,4455,4454,4422,4422,4454,4487,4487,4454,4454,4487,4487,4487,4552,4552,4487,4487,6567,4486,4486,4487,4486,6567,6567,4486,6534,6567,6566,6567,8615,6566,8614,8647,8647,10792,12872,10792,10759,12807,12872,12839,12807,14855,14887,17000,16968,14887,16935,16967,19079,21192,21127,19014,21094,25288,25287,25286,25286,27399,27367,29512,31560,31593,29447,29446,33607,35753,33574,33606,33606,37833,35687,35654,37767,42058,37766,39879,44072,41926,44007,46185,43974,44006,46054,50313,48167,48167,52458,50279,48134,50247,54473,50246,50246,54472,54473,52327,52359,56553,50246,52327,56585,56585,50246,50246,54504,56585,52391,50279,54504,48166,48264,58963,61043,61011,52526,6305,4225,4225,2145,16836,52524,255},
{458,490,490,490,19082,21030,10531,10466,18884,10466,23012,37865,8549,8517,10629,12742,6436,10629,6436,10564,8517,6404,12612,4225,8386,23012,46218,33607,6306,4193,12578,16803,12611,12578,14724,12611,12644,14724,12611,12611,14724,12676,12612,12644,12676,12612,12644,12644,10596,12644,12677,10596,10597,12709,12709,10597,10629,10629,10629,10629,10629,10597,8549,10629,10662,10630,8582,8614,10694,10662,10662,10760,10760,8647,8647,10727,8646,8615,8615,8647,8679,8647,6567,6599,8647,8647,8679,8647,6599,6599,6599,6664,8745,6664,6632,6632,6664,6664,6632,6632,6664,6664,8777,8745,6632,6664,6664,8777,8745,8745,6664,6664,8712,6664,8744,8712,8712,8680,8712,8712,8744,8744,8712,8744,8712,8776,10857,8776,8744,8776,8744,8776,13035,13002,10888,10856,10856,10823,12904,12871,12903,14984,14984,14984,14984,17064,14983,14951,17031,19111,19079,19079,19111,21191,19079,21127,21159,21094,23207,25384,25319,21061,25286,27367,25157,20996,23076,25156,20963,29446,58995,61044,61044,50479,8386,4258,4225,2113,21061,44073,255},
{458,490,490,490,19081,14790,17000,6339,10531,16869,20931,46185,21095,12742,10564,10597,12709,14822,8484,8517,12677,14822,10531,6273,6306,23044,44138,29381,12611,8386,10498,4193,2145,4193,4193,4193,4225,4225,4225,4225,4225,4225,4225,4225,6305,4225,6273,6306,6273,6305,6306,6305,6306,6338,8386,6306,8386,8386,6306,8386,8418,8386,8386,8386,10466,8418,8418,10498,12579,12579,10498,10499,12611,10531,10498,10499,12611,12579,10531,14692,14692,12611,12579,12611,12644,14724,12612,12612,12644,14725,12644,12676,12709,14822,14789,12677,12677,14822,12741,12709,12709,12741,12806,12774,12742,10694,10694,14919,17000,12807,10694,10727,14887,12839,12840,12839,12839,12807,12807,12839,12872,12840,10792,12872,12872,12937,15017,12936,12936,12936,10856,12937,17228,15115,15081,12969,12969,12936,15017,12968,12969,15049,15049,15081,15049,15081,15048,15049,15048,15080,15048,15048,15048,15016,15016,15016,15016,14983,15016,14983,17064,10725,17063,14983,6371,2145,4290,2145,65,16933,58995,61043,61011,50446,8386,4225,4225,4193,6338,23142,255},
{490,490,490,458,25388,23176,21063,23110,23109,33608,31430,41993,25288,19015,14757,14790,23208,18983,12709,16903,18983,25255,12644,8418,8418,20932,27334,25189,8450,4225,6338,2112,2113,6338,4257,2145,2145,2145,2145,2145,4225,4193,4225,4225,4193,4193,4225,2145,2145,4193,2145,2145,4193,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,4193,4193,2145,4193,4193,4225,4225,4193,4225,4225,4193,4193,4225,4225,4225,4225,4225,4225,4225,4225,4225,4225,4225,4225,4225,6305,6305,4225,4225,6306,6306,6305,6305,6305,6338,6338,6305,6305,6305,8418,10498,8418,8386,8386,10499,10498,8418,10466,10531,10498,10498,10498,12579,10498,10498,10531,12611,12611,10531,10531,12644,12611,12611,12644,14757,12644,12676,12708,12676,12676,14756,12676,12708,12709,14789,14789,14821,16901,14821,14821,14853,19046,16966,16966,16998,16934,14886,16966,19079,16998,16966,16999,17031,14821,14789,19079,10564,6370,6338,6306,4225,21094,58995,61044,61043,50414,6273,2145,4193,4193,2145,40044,255},
{489,490,490,490,14987,23306,12743,35688,35655,35655,25222,33574,12709,12677,8484,8484,12677,12677,6404,8452,10597,10597,8419,2112,32,16739,33672,14691,6306,8418,4225,2112,4193,10498,4258,4225,4193,4225,2145,2145,4225,4225,4193,4225,4225,4193,4225,4225,4193,4193,4193,4193,4193,4193,4193,4193,4225,4193,4193,4193,4193,4193,4225,4193,2145,4193,4225,4193,4193,4225,4225,4225,4225,4225,4226,4225,4193,4193,4225,4193,2145,4225,4225,4193,4193,4193,4225,4225,2145,2145,4193,4193,2145,4193,4193,4193,2145,2145,2145,4193,2145,2145,2145,4193,4193,2145,2145,2145,2145,4225,4193,2145,2145,2145,2145,2145,2145,2145,2145,2145,4225,4193,2145,4193,4225,4225,4193,4193,4225,4193,4225,4225,4225,4225,4225,4225,4225,4225,4225,4193,4193,4225,6305,4225,4225,6305,6273,4225,6273,6306,6306,6305,8386,6338,6305,8386,8418,8418,8386,8418,8418,8386,8418,10531,12611,10499,10498,12579,8418,23207,58995,61043,61043,50414,4225,2145,4193,4193,2145,40109,255},
{489,490,490,490,6633,21128,12841,21062,27302,20965,20997,31462,14757,10564,12677,10565,12677,12709,12710,10565,14790,10597,6371,4193,2113,14691,27334,8419,6306,8450,4193,6273,6306,6305,2145,4193,4225,2145,4356,4357,4324,4389,2407,4454,4389,4291,4258,4225,4356,4357,4356,4324,4324,4324,4291,4258,4258,4225,4258,4259,4258,4258,4258,4226,4193,4225,4226,4225,4225,4225,4226,4226,4225,4226,4226,4225,4225,4225,4226,4225,4225,4225,4226,4225,4225,4225,4225,4225,4225,4193,4225,4225,4193,4193,4193,4193,4193,4193,4193,4225,4193,4193,4193,4193,4225,4193,4193,4193,4193,4226,4225,4193,4193,4225,4225,4193,4193,4225,4225,4193,4225,4225,4193,4193,4225,4225,4225,4193,4193,4225,4193,4193,4225,4225,4193,4225,4193,2145,4225,4193,2145,2145,2145,2145,2145,2145,4193,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,4193,4193,4225,2113,19046,58995,61011,61011,48333,4193,2145,4225,4225,2145,40109,255},
{489,490,490,490,2538,23209,23274,10597,20997,18917,16772,29350,16837,12644,14757,8484,8484,8484,8549,8517,12709,8484,8451,4225,10499,10499,31495,16836,16804,6306,4225,4193,4193,2112,2113,4193,6306,2112,4356,4455,2309,2504,2602,2602,2407,4357,4292,2113,2569,2668,2668,2668,2668,652,2570,4454,4357,2113,4617,653,653,652,652,2701,2341,2112,2145,2145,2145,2145,4193,4225,4225,2145,4225,4225,4193,2145,4225,4225,4193,4193,4225,4225,4225,4225,4225,4225,4225,4225,4193,4258,4389,4389,4356,4356,4323,4258,4226,4226,4258,4291,4258,4258,4258,4226,4226,4193,4225,4226,4225,4225,4225,4225,4226,4225,4225,4226,4225,4225,4225,4226,4225,4225,4225,4226,4226,4225,4225,4225,4225,4225,4225,4225,4225,4225,4193,2145,4193,2145,2145,2145,4193,4225,4225,4225,4225,4225,4225,4225,4193,4193,4193,4225,4225,4193,4225,4193,4193,4193,4225,4193,4193,4193,4225,4193,4193,4225,2113,21126,58995,61044,61076,48302,4193,2145,4225,4225,4225,42221,255},
{489,490,490,490,458,17099,23275,21096,8452,12611,14724,27270,23143,23144,23144,21063,16902,16902,18983,21063,16869,16902,14757,8418,8418,6305,29382,14724,14756,2113,2113,2112,4257,2112,2112,6306,6306,2113,2113,2113,2113,2113,2145,2145,2113,2113,2145,2113,2178,2178,2210,2211,2211,2243,4291,2178,2178,2113,4291,2341,2341,2374,2374,2407,2244,2113,2145,2145,2113,2113,2145,2145,2145,2145,2145,2145,2145,2145,2145,4193,2145,2145,2145,4193,2145,2145,2145,4225,4193,2145,2145,4291,4910,4943,4943,7024,6893,6568,6535,2178,8875,7023,6991,6991,7023,9038,6958,4324,2145,2145,4193,2145,2145,2145,4225,4193,4193,4225,4225,4225,4225,4225,4225,4225,4225,4225,4225,4225,4225,4225,4225,4225,4225,4225,4225,4226,6436,6436,6436,6404,6403,4290,4258,4258,4225,2145,4225,4225,4225,4225,4225,4193,4225,4225,4225,4225,4225,4225,4225,4225,4225,4225,4225,4225,4225,4225,4225,4226,2113,21127,58995,58963,61010,46221,4193,2145,4193,4193,4257,44270,255},
{489,490,490,490,490,4618,25420,21129,19049,8451,6306,12579,16837,12645,12677,12644,12677,12677,14758,12677,10564,10597,8451,2145,4193,6273,23077,16836,10531,2113,2145,4193,4193,2112,4193,6306,4193,2145,2145,2113,2113,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2113,2145,2145,2145,2145,2145,2145,2145,2145,2112,2113,2113,2145,2145,2145,2145,2145,2145,2145,2145,4225,2145,2145,4225,2145,2145,2145,4225,2145,2145,2145,4225,4225,2145,2145,4225,4225,2145,2145,2145,4323,4356,4356,4389,4389,4291,4291,2145,4389,6567,6567,4552,6632,6664,6665,4291,2113,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,4225,4193,4193,2145,2145,2145,4193,4193,4225,2145,4258,19437,23696,25712,23664,25744,19243,12839,14855,8484,12839,6403,4258,4193,4258,6306,4193,4258,2145,2145,2113,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,4225,2113,21159,61043,61011,61043,46221,6273,4225,4193,2145,4225,44270,255},
{489,490,490,490,490,490,12873,23242,12874,23176,12644,6305,12611,12676,12677,12644,12677,12644,14757,12644,12612,12612,10564,4226,2113,4193,12579,16837,6306,4225,4225,4225,4193,2113,6305,4257,2145,2145,2145,2145,4225,4225,4225,4193,4225,4225,4193,4225,4225,2145,4193,2145,2145,4193,2145,2145,2145,4225,2145,2145,4225,2145,2145,4193,2145,2145,2145,4225,2145,2145,2145,4193,4225,2145,2145,4225,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,4193,2145,2145,2145,2145,2145,2113,2113,2113,2113,2113,2145,2145,2113,2113,2112,2112,2113,2112,2112,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,6436,8581,8581,10661,10694,8549,8484,8484,6338,14919,12807,6371,2145,4225,4225,4225,4258,2145,2145,2113,2145,2113,2113,2113,2145,2113,2113,2145,2145,2145,2145,2145,2113,21158,58963,58930,58930,46188,6306,4225,4225,4193,4225,44270,255},
{489,490,490,490,490,490,4618,29515,14954,12874,14856,16838,21030,16870,12645,16838,16870,16838,16838,14725,14725,16838,14757,8451,6338,8386,12611,10499,4225,4193,4225,4225,2113,2112,4225,4193,2145,2145,2113,4193,4193,4193,4193,4193,4225,4193,4193,4193,4193,4193,4193,4193,4193,4193,4225,4193,4225,4225,4193,4193,4225,4193,4193,4225,4193,2145,4193,4225,4193,4193,4193,4225,4225,2145,4193,4225,2145,2145,2145,4225,2145,2145,4225,4225,2145,2145,2145,4225,2177,2145,2145,4225,4225,2145,2145,2145,4193,2145,2145,4225,4225,2145,2145,2145,4225,2177,2145,2145,2145,4225,4225,4225,2145,2145,4225,4193,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2113,2113,2112,2112,2112,2113,2113,2113,2113,2080,2113,2145,2145,2145,2145,4193,4193,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,4225,2113,23239,61043,61011,61043,44108,6273,4225,4193,2145,4225,44270,255},
{489,490,490,490,490,490,490,12939,27468,14954,4586,4487,10499,16805,18951,18918,23208,21095,18982,23175,23143,23143,16902,8451,2145,2113,8418,6370,4225,4193,4193,2113,2113,2145,2145,2145,4258,4324,4323,2374,2374,4389,2341,2308,4356,4356,4324,4324,4323,4291,4291,4291,4258,4258,4258,4226,4226,4258,4226,4226,4225,4193,4193,4193,4193,4193,4193,4193,4193,4193,4193,4193,4193,4193,4193,4193,4193,4193,4193,4193,4193,4193,4193,4225,4193,4193,4193,4225,4225,4193,4193,4225,4225,4193,4193,4225,4225,4193,4193,4225,4225,4225,2145,4225,4225,4225,4193,4193,4193,4225,4226,4225,4225,4193,4225,4225,4193,4225,4225,4193,4225,4225,4225,4193,4193,4225,4193,2145,2145,2145,4193,2145,4193,4193,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,4193,2113,23239,61043,58931,61043,44076,4193,4225,4225,2145,4225,44302,255},
{489,490,490,490,490,490,490,490,12874,14824,19114,12939,6404,6338,4291,4291,6371,8484,6371,6403,6371,10596,10564,4291,2112,2113,2112,6338,8451,4258,4193,4193,4193,2145,2145,2145,4356,4422,2603,588,588,588,588,588,620,620,620,620,620,620,620,588,588,588,587,587,2635,2603,2603,2603,2602,2570,2570,2537,2537,2505,2504,2504,2472,2472,2471,4487,4487,4454,4422,4422,4421,4389,4389,4389,4356,4356,4356,4324,4323,4291,4291,4291,4290,4258,4226,4258,4226,4225,4225,4225,4225,4193,4193,4193,4193,4193,4193,4193,4193,4193,4193,4193,4193,4193,4225,4193,4193,4193,4193,4193,4193,4193,4225,4193,4193,4225,4225,4193,4193,4225,4193,4193,4193,4225,4225,4193,4193,4225,4193,4225,4225,4193,4225,4225,2145,2145,4193,4193,4193,4193,4193,4193,2145,4193,4193,4193,4193,4193,4193,4193,4225,4193,2145,4193,4193,2145,2145,2145,4225,2145,4193,4225,2113,25319,61075,58963,61043,42027,4193,4225,4225,2145,4257,46383,255},
{489,490,490,490,490,490,490,490,490,6600,19081,21260,12808,12644,12644,10564,6404,4291,4259,4259,6339,6371,4259,8484,6338,6306,6338,6306,12644,6338,4193,4193,4193,2113,2145,4193,4356,2537,555,555,555,555,588,588,588,588,588,620,620,620,620,620,620,620,620,652,653,653,653,653,653,685,685,685,685,685,686,718,718,718,718,718,750,750,750,750,750,750,750,750,750,750,750,2798,2798,2797,2765,717,2765,2765,4813,2732,4780,4748,4748,4747,4747,4715,4682,6730,6730,6698,6665,6665,6633,6632,6600,6567,6567,6535,6535,6502,6502,6469,6469,6437,6404,6404,6404,4323,4323,4291,4291,4258,4258,4258,4258,4226,4225,4225,4225,4225,4225,4225,4193,4225,4225,4193,4225,4225,4193,4193,4225,4225,4193,4225,4225,4193,4193,4225,4193,4193,4225,4225,4225,4193,4225,4193,2145,4193,4225,4193,4193,4225,4225,4225,4225,4225,2113,25352,61076,61011,61075,42027,2145,4225,4225,2145,4257,48496,255},
{489,490,490,490,490,490,490,490,490,490,10858,19114,4553,6404,8451,10597,10565,4291,8484,8484,6339,2210,2178,4291,6338,2113,2112,4193,8451,4226,4193,4193,2145,2145,2145,4357,2570,555,555,555,555,555,588,588,588,588,588,620,620,620,620,620,620,620,620,620,652,652,652,653,653,653,653,653,653,653,685,685,685,685,685,685,685,685,717,717,718,718,750,750,750,750,750,750,750,782,782,782,782,2830,2862,2863,2862,2863,2863,4911,4911,4911,4943,4943,4943,4943,4975,7023,7023,7023,7023,9071,9103,9104,11152,11151,11151,11151,11151,11151,11151,13199,13199,13199,13167,13166,13166,13166,15214,15214,15213,15214,6437,2146,2178,2178,2178,6403,6371,2178,4258,4226,4226,4225,2145,2145,2145,4225,2177,2177,2177,2145,2145,4225,4225,4193,4225,4225,4225,4225,4225,2145,4258,4225,4225,4225,4193,4193,4225,2145,2145,4225,65,25384,61076,61011,61043,41995,2145,4193,2145,2113,27367,54571,255},
{489,490,490,490,490,490,490,490,490,522,490,8648,14823,8648,8452,4226,2211,2211,2178,2178,2178,2178,2211,4258,6339,6306,4193,6306,2145,4258,4225,4193,2145,4193,4357,555,555,555,555,555,555,556,588,588,588,588,620,620,620,620,620,620,620,620,620,652,652,653,653,653,653,653,653,653,653,685,685,685,685,685,685,685,685,717,717,717,718,718,750,750,749,750,750,750,750,782,782,782,2830,2830,2830,2830,2830,2830,4910,4910,4911,4911,4911,4911,6959,6991,6991,6991,6991,6991,7023,7023,9071,9071,11119,9071,11119,11119,11119,11151,11151,11151,13199,13231,13231,15279,15311,15311,15311,17391,17391,17424,6470,2146,2178,2178,2178,8612,6500,4290,4290,4258,4258,4258,4258,2178,2178,2178,2178,2178,2178,2178,2178,2177,2177,2177,2177,2177,2177,2145,4225,14627,23109,25157,23109,25189,23109,23109,25157,23077,23109,25157,16803,35786,61076,61044,63156,41995,2145,4225,4225,2145,25254,37767,255},
{489,490,490,490,490,490,490,490,522,522,522,490,10859,25452,19049,10564,8451,8484,4258,6338,8451,10532,10564,10531,8451,6338,2145,2112,2112,2177,4324,4259,4356,2407,522,555,555,555,555,555,556,588,588,588,588,588,620,620,620,620,620,620,620,620,620,653,653,653,653,653,653,653,685,685,685,685,685,685,685,685,685,717,717,717,718,718,750,750,750,750,750,750,750,750,750,782,782,783,782,782,2862,2863,2830,4911,4911,4911,4911,4943,4943,4943,4943,6991,6991,7023,7023,7023,7023,7023,9071,9071,9103,11151,11151,11151,11151,11151,11183,11151,13231,13231,13231,15279,15279,15279,15311,15311,17359,17392,6469,2146,2178,2178,2178,6435,4355,4355,4356,4388,4356,4388,4355,4323,4355,4323,4323,4355,4355,4355,4355,4323,4322,4323,4323,4323,4322,4290,14626,14594,16772,14691,12579,16772,14691,14691,18852,16771,18851,20964,16771,35786,61076,61011,61043,39882,2113,4193,4193,4193,6370,23175,255},
{489,490,490,490,490,490,490,490,490,522,522,522,490,2570,12939,14823,14823,8549,6470,6535,6502,6437,4356,4357,2309,2276,4324,4291,2276,4356,4357,4454,2570,555,555,555,555,555,555,588,588,587,588,588,620,620,620,620,620,620,620,620,620,620,652,652,653,653,653,653,685,685,685,685,685,685,685,685,717,717,717,717,717,718,718,750,750,750,718,2798,750,750,782,782,782,782,783,783,815,815,2863,2863,2863,2863,2895,4943,4943,4943,4943,4943,4975,7023,7023,7024,7023,7023,7055,9103,9103,9103,9103,9103,11183,11183,11183,11183,11183,13231,13231,13231,13232,15312,15311,15311,15311,17359,17391,17392,6437,2146,2178,2178,2178,4355,4356,4421,4421,4453,6501,6501,4421,4420,4420,4420,4420,6533,6500,4420,4420,6501,6468,6468,6500,6468,6468,6468,8483,10466,27237,25157,20964,27237,23044,20964,27205,16771,23045,27269,12578,33738,61109,61044,63156,39883,2113,4193,2145,2145,6338,48496,255},
{489,490,490,490,490,490,490,490,490,522,522,522,522,522,490,2602,4650,4520,4422,4422,4487,4455,4454,6503,4487,4422,4389,4422,4487,2440,457,555,555,555,555,555,555,555,587,587,587,588,588,588,588,620,620,620,620,620,620,620,652,652,652,653,653,653,653,653,685,685,685,685,685,685,685,717,717,717,718,718,718,718,750,750,750,750,750,750,750,750,782,782,782,783,815,815,815,2863,2863,2863,2863,2895,4943,4943,4943,4943,4943,4975,4976,4976,7024,7024,7056,7055,7055,7056,9104,9104,9103,9135,9135,11183,11183,11184,13232,13263,13264,13264,13264,15312,15312,15312,15311,17391,17391,17392,6437,2146,2178,2178,2178,4356,4453,4421,4421,4453,4421,4421,4421,4421,4421,4453,4453,6533,6501,4420,6500,6501,6501,6500,6500,6500,6468,6468,4290,10466,18852,16804,16804,20964,20932,18884,20964,20964,23044,25124,23011,40011,61076,61011,61075,37802,2113,4193,2145,2145,4289,50576,255},
{490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,490,457,2538,2505,2407,2472,2505,2505,2440,490,555,555,555,555,555,555,555,555,555,587,587,588,588,588,588,588,588,620,620,620,620,620,620,652,652,652,652,653,653,653,653,653,685,685,685,685,685,685,718,718,718,718,718,718,750,750,750,750,750,750,750,750,750,782,782,783,783,783,815,815,815,815,847,847,847,847,2895,2895,2895,2927,2927,2927,2928,2928,5008,5008,7056,7056,7056,9136,9136,9136,9136,11184,9135,11184,11184,11216,11216,13264,13264,13264,15312,15344,15344,15344,15344,17392,17392,17392,6437,2146,2178,2178,2211,4421,6501,4453,4453,4453,6533,6501,6501,6501,4453,6501,4453,6533,6501,6501,6501,6500,6500,6468,6468,6500,6468,6403,4290,16837,25157,18916,14691,23077,16771,14691,20964,10498,16803,23044,6337,33738,63189,61044,63156,37770,2113,4225,4193,2145,6370,50576,255},
{490,490,490,490,490,490,490,490,490,522,522,522,522,522,522,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,555,555,555,555,555,555,588,587,588,588,588,588,588,588,620,620,620,620,620,620,620,652,652,653,653,653,653,653,685,685,685,685,685,685,686,718,718,718,718,718,718,750,750,750,750,750,750,750,750,750,782,783,783,783,815,815,815,815,815,847,847,847,847,847,2896,2928,2927,2927,2928,4976,5008,5008,5008,5008,5008,7088,7088,7088,9136,9136,9136,11184,11184,11216,11216,11216,11216,13264,13264,13264,15344,15344,15344,15344,15344,15344,17392,17392,6405,2146,2178,2178,2243,4388,4388,4388,4389,4421,4421,4421,4388,4388,4420,4421,6469,4453,6533,6501,6501,6533,6501,6533,6533,6533,6468,6403,4290,8483,23077,23109,25157,27269,25189,27269,27237,27237,27269,27269,25124,42091,61109,61044,63124,37769,2112,2177,2145,2145,6370,50608,255},
{490,490,490,490,490,490,490,490,490,522,522,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,555,555,555,587,588,588,588,588,588,588,588,588,620,620,620,620,620,620,620,652,653,653,653,653,653,653,685,685,685,685,685,685,685,718,718,718,718,718,718,718,750,750,750,750,750,750,782,782,782,782,783,783,783,815,815,815,815,815,847,847,847,2896,2896,2896,2928,2927,2928,5008,5008,5008,5008,5008,7088,7088,7088,7088,7088,9136,9136,9168,11216,11216,11216,11216,11216,11248,13296,15344,15344,15344,15344,15376,17424,17424,17392,17392,17391,4356,2146,2178,2178,2178,4291,4323,4291,4291,4291,4291,4291,4291,4291,4291,4323,4323,4355,4355,4323,4323,4355,4323,4355,4355,6435,4290,4290,4290,6403,27269,29349,27269,31429,27237,27236,27236,23043,25124,27204,20931,40011,63157,61043,63124,35689,2113,2177,2145,2145,6370,50608,255},
{490,490,490,490,490,490,490,490,522,522,522,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,555,587,587,588,588,588,588,588,588,588,620,620,620,620,620,620,620,653,653,653,653,653,653,653,653,653,685,685,685,685,685,718,718,718,718,718,718,750,750,750,750,750,750,750,783,783,783,783,783,783,815,815,815,815,815,815,815,847,848,2896,2896,2896,2896,2928,2928,5008,5008,5008,5008,5008,7056,7088,7088,7088,7088,7088,7088,9168,9168,11216,11216,11216,11248,11248,13296,13296,15344,15345,15345,15377,15377,17424,17424,17392,17392,17359,4356,2146,2178,2178,2178,4290,4323,4291,4323,4323,4291,4290,4290,4290,4290,4290,4290,4323,4322,4290,4290,4290,2210,4290,2210,4322,2210,8483,12611,20900,44138,48331,50379,50379,50411,50379,50378,50378,48297,48233,46120,50510,61109,61044,63156,35689,2112,2145,4225,4258,8450,52689,255},
{490,490,490,490,490,490,490,490,522,522,522,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,555,587,588,588,588,588,588,588,588,588,620,620,620,620,620,620,653,653,653,653,653,653,653,653,685,685,685,685,685,685,685,718,718,718,718,718,750,750,750,750,750,750,783,783,783,783,783,783,783,815,815,815,815,815,815,847,847,848,2896,2896,2896,2928,2928,4976,4976,5008,5008,5008,5008,7056,7088,7088,7089,7088,7089,9169,9168,9169,9168,11216,11216,11249,11248,11248,13296,13296,13297,15345,15377,15377,15376,17424,17424,17424,17424,17359,4324,2146,2178,2178,2178,2210,4290,4323,4355,4323,4323,4323,4290,4290,4290,4290,4322,4355,4323,4322,4323,4323,4323,4323,4290,4322,4322,10628,18917,10531,18852,18884,20964,23044,23044,23044,23076,25124,25157,25157,25124,42124,61109,61011,63124,33609,2113,2145,4225,4225,6402,52689,255},
{458,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,587,587,588,588,588,588,588,588,588,588,620,620,620,620,620,621,621,653,653,653,653,653,653,653,653,685,685,685,685,685,686,718,718,718,718,718,718,750,750,750,750,750,750,783,783,783,783,783,783,815,815,815,815,815,815,847,847,847,848,2896,2928,2896,2928,4976,4976,4976,5008,5008,7056,7056,7056,7088,7088,7089,9137,9137,9169,9169,9169,9169,11217,11248,11249,11249,11248,13297,13297,13297,15377,15377,15377,17425,17424,17424,17424,17424,17360,4324,2146,2178,2178,2178,2210,2178,2178,2210,2178,2210,2178,2178,2178,2178,2178,2178,4290,2210,2210,2210,2210,2210,2210,2210,4290,4290,2210,2210,6403,20965,20964,18852,20996,18852,18852,20964,16803,18883,20964,10498,35883,63189,61044,63157,33609,2113,4225,4225,2145,8450,52689,255},
{490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,587,588,588,588,588,588,588,588,588,620,620,620,620,620,620,621,653,653,653,653,653,653,653,653,653,685,685,685,685,685,718,718,718,718,718,718,718,750,750,750,750,750,783,783,783,783,783,783,783,815,815,815,815,815,847,847,847,847,848,2896,2928,2928,2928,4976,4976,4976,5008,5008,7056,7088,7088,7089,7089,7089,9137,9169,9169,9169,9169,9169,9169,11249,11249,13297,13297,13297,13297,13329,15377,15377,15377,17425,17425,17424,17424,17456,17359,4291,2145,2178,2178,4258,2210,2210,2178,2178,2178,2178,2178,2178,2178,2178,2178,2178,4258,2178,2178,2178,2178,2178,2178,2178,2178,2178,2178,2178,6338,18916,18916,16804,20996,18884,18884,20964,16803,20964,20964,14658,40044,63157,58963,63123,33544,2113,4225,4225,2145,8483,52721,255},
{490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,587,587,588,588,588,588,588,588,588,588,620,620,620,620,620,620,621,653,653,653,653,653,653,653,653,685,685,685,685,685,686,718,718,718,718,718,718,750,750,750,750,750,782,783,783,783,783,783,783,783,815,815,815,815,815,815,848,847,848,848,2928,2928,2928,4976,4976,4976,4976,5008,7056,7056,7056,7088,7088,7089,7089,9169,9169,9169,9169,9169,9201,9201,9201,11249,13297,13297,13329,13329,13329,15377,15377,17425,17425,17425,17457,17456,17457,17391,6502,2243,2210,2178,2178,2178,2178,2178,2178,2178,2178,2178,2178,2178,2178,2178,2178,2210,2210,2178,2178,2178,2178,2178,2178,2178,2178,2178,2178,8451,23109,25157,23077,25157,25125,25124,27205,25124,27204,27204,20899,40076,63189,61044,63156,31496,2113,4225,4193,2145,8483,54802,255},
{490,490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,587,587,588,588,588,588,588,588,588,588,620,620,620,620,620,620,621,621,653,653,653,653,653,653,653,653,685,685,685,685,685,686,718,718,718,718,718,718,750,750,750,750,750,782,783,783,783,783,783,783,783,815,815,815,815,815,815,847,847,848,2896,2928,2928,4976,4976,4976,4976,5008,5008,7056,7056,7088,7088,7089,7088,9137,9169,9169,9169,9169,9169,9201,9201,11249,11249,13297,13329,13329,13329,13329,15377,15377,17425,17457,17457,17457,17457,17456,19504,17424,17327,15181,13003,10792,10694,10694,10662,10629,10629,8549,8516,8484,4291,6403,6403,6403,6371,4258,6338,6338,4290,4226,2145,2145,2145,2145,2145,2145,2177,8386,10498,10499,12611,12611,14659,16707,14659,16739,16771,16738,42156,61109,61011,63124,31464,2113,4225,4225,2113,10595,56915,255},
{490,490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,555,555,587,588,588,588,588,588,588,588,588,588,620,620,620,620,620,620,620,621,653,653,653,653,653,653,653,653,685,685,685,685,685,685,686,718,718,718,718,718,718,750,750,750,750,782,783,783,783,783,783,783,783,815,815,815,815,815,815,847,847,848,848,2896,2928,2928,2928,4976,4976,5008,5008,7056,7056,7056,7088,7088,7089,9137,9169,9169,9169,9169,9169,9201,9201,11249,11281,11249,13297,13329,13329,13329,15377,15377,15377,17425,17457,17457,17457,17457,19504,19504,19504,19504,21584,21584,21585,23664,23664,23664,23664,23664,23632,23631,23599,23566,23534,23533,23500,23468,21355,21355,21322,19242,17097,14952,14919,12839,12806,12742,12709,10629,10597,8516,6371,2113,2145,4257,8418,6337,2145,2112,4225,40076,61076,58930,61043,29351,2112,4193,2145,4257,42058,54538,255},
{490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,587,588,588,588,588,588,588,588,588,620,588,620,620,620,621,621,621,653,653,653,653,653,653,653,653,685,685,685,685,685,685,686,718,718,718,718,718,750,750,750,750,750,750,783,783,783,783,783,783,783,815,815,815,815,815,815,848,848,848,848,2896,2928,2928,2928,4976,4976,4976,5008,7056,7056,7056,7088,7088,7089,9137,9169,9169,9169,9169,9169,9201,9201,11249,11281,11281,13329,13329,13329,13329,15377,15377,17425,17457,17457,17457,17457,19505,19505,19505,19504,19504,19536,21584,21584,21584,23632,23664,23664,23696,23696,23695,25711,25711,25711,27759,27759,27758,27758,25710,25678,27725,27693,25613,27661,27660,27660,27660,27628,29676,29676,29676,25418,8484,65,25188,56518,56519,31364,2113,6305,42157,61109,61011,63124,29351,64,2145,2145,4225,27334,29381,255},
{490,490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,587,588,588,588,588,588,588,588,588,620,620,620,620,620,620,621,653,653,653,653,653,653,653,653,653,685,685,685,685,685,685,718,718,718,718,718,718,750,750,750,750,750,782,783,783,783,783,783,783,783,815,815,815,815,815,847,847,848,848,2896,2896,2928,4976,4976,4976,4976,5008,5008,7056,7056,7056,7088,7088,7089,9137,9169,9169,9169,9169,9169,9201,11249,11249,11249,11281,13329,13329,13329,13329,15409,15409,17425,17457,17457,17457,17457,19505,19537,19537,19537,21584,21584,21584,21584,21584,23632,21584,23664,23664,23663,23663,23663,25679,25679,25678,25678,25646,25645,25645,25645,25613,25613,25580,25580,25548,27596,27596,27596,27596,27596,27596,29676,21160,65,35719,60646,60678,35524,2145,6273,42189,61109,61011,63092,27270,32,2145,2145,2113,10563,25288,255},
{490,490,490,490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,555,587,588,588,588,588,588,588,588,588,620,620,620,620,620,620,621,653,653,653,653,653,653,653,653,685,653,685,685,685,685,686,718,718,718,718,718,718,750,750,750,750,750,783,783,783,783,783,783,783,783,815,815,815,815,815,847,848,848,848,848,2896,2928,4976,4976,4976,4976,4976,5008,7056,7056,7056,7088,7088,7089,9137,9169,9169,9169,9169,9169,9201,11249,11249,11281,11281,13329,13329,13329,13329,15377,15409,15377,17457,17457,17457,17457,19505,19537,19537,19537,21585,21585,21616,21584,23632,23632,21584,23664,25711,25711,25711,23631,25679,25678,25646,25646,25645,23597,23565,23565,25581,25580,25548,25548,25548,25548,27596,27596,27596,27595,27595,29675,23273,2210,39977,60678,60678,45989,8385,6305,44269,63157,61043,63124,25190,2112,2145,2145,2112,12676,58963,255},
{490,490,490,490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,587,588,588,588,588,588,588,588,588,620,620,620,620,621,620,620,653,653,653,653,653,653,653,653,653,685,685,685,685,686,718,718,718,718,718,750,750,750,750,750,750,750,783,783,783,783,783,783,783,783,815,815,815,815,847,847,848,848,848,848,2928,2928,2928,2928,2960,5008,5008,7056,7056,7089,7056,7088,7089,7088,9137,9169,9169,9169,9169,9201,9201,9201,11249,11281,11281,13329,13329,13329,15377,15377,15377,15377,17425,17457,17457,17457,19505,19505,19536,19537,21585,21585,21616,21584,23632,23664,23663,27791,38160,38095,38095,38127,38095,36014,33934,33966,31886,29773,29773,27725,27692,27692,27692,27660,27660,29708,29708,29708,29643,29643,29675,31723,27530,8483,39912,60679,45989,14625,8386,10498,44269,61108,58930,61043,25158,2113,2145,2145,2112,12676,56915,255},
{490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,587,588,588,588,588,588,588,588,588,588,588,620,620,620,621,621,621,653,653,653,653,653,653,653,685,685,685,685,685,686,685,686,718,718,718,718,718,750,750,750,750,750,750,750,750,783,783,783,783,783,815,815,815,815,815,815,848,848,848,848,848,880,2928,2928,2928,2960,2960,5008,7056,7056,7089,7089,7088,7089,7089,9169,9169,9169,9169,9169,9201,9201,11249,11249,11249,11281,13329,13329,13329,15377,15377,15377,15377,17425,17425,17457,17457,19505,19504,19505,19537,21585,21585,21616,21616,21616,23664,34032,42288,40240,31789,33934,38127,36014,33901,36014,40239,40207,33901,36046,36046,33933,33933,36046,33933,33901,31756,33803,31689,27367,27431,31657,33705,23175,20867,41862,60647,22978,4193,25255,27302,44269,63157,61043,63124,25158,2113,2145,2145,2112,12708,56882,255},
{490,490,490,490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,588,620,620,620,621,621,621,653,653,653,653,653,653,653,653,653,685,685,685,685,685,685,718,718,718,718,750,718,750,750,750,750,750,750,750,750,783,783,783,783,783,815,815,815,815,815,815,847,848,848,2896,2896,880,880,880,2928,2960,2960,5008,7056,7056,7089,7089,7088,7089,9137,9169,9169,9169,9169,9169,9201,9201,11249,11249,11281,11281,13329,13329,13329,15377,15377,15377,15377,17425,17457,17457,17457,17457,19537,19472,21584,21584,21584,21584,21616,21616,25744,46547,48659,50708,42353,44434,48594,46514,44401,44433,46578,46545,42256,44400,44433,42320,40239,42352,42319,40207,38094,40174,40142,33771,29544,33704,33737,21029,22979,43942,62791,31331,6273,18916,16803,44302,61076,58962,61043,23077,2113,2145,2145,2112,12708,58963,255},
{490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,588,588,620,620,620,621,621,621,653,653,653,653,653,653,653,653,653,685,685,685,685,685,686,718,718,718,718,750,718,750,718,750,750,750,750,750,750,783,783,783,783,815,815,815,815,815,815,815,847,848,848,848,848,880,880,880,2928,2960,2960,2960,5008,7056,7089,7089,7089,7089,9137,9169,9169,9169,9169,9201,9201,9201,11249,11249,11281,11281,13329,13329,13329,15377,15377,15377,17425,17425,17425,17457,19537,19472,12970,6469,10694,17226,19403,19403,19371,19371,19371,29741,31853,29773,29741,31821,33934,33934,36014,36014,40207,38127,38094,38127,54836,44400,40174,40174,42255,38094,40174,46480,46513,44368,40109,35882,33769,25287,27140,31331,43909,35556,8385,6273,6337,46382,63157,61043,61044,23045,2113,2145,2145,2113,14788,58963,255},
{490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,556,555,555,588,588,588,588,588,588,588,588,588,588,620,620,620,620,620,621,621,653,653,653,653,653,653,653,653,653,685,685,685,685,685,686,686,718,718,718,718,750,750,750,750,750,750,750,750,750,783,783,783,783,783,815,815,815,815,815,847,848,848,848,848,848,880,880,880,2960,2960,2960,5008,5008,7056,7056,7089,7089,7088,9137,9169,9169,9169,9169,9169,9201,11249,11249,11249,11281,11281,11281,13329,13329,15377,15377,15377,15377,15377,17457,17392,12971,6469,2210,2211,2211,4291,8613,15080,19338,17258,17258,15177,15145,15113,15080,17161,17128,15080,15048,15015,12967,12967,12967,15015,33738,35851,38029,48497,35819,35851,42190,35851,40077,37996,35883,40109,35916,35883,37769,25158,25191,25223,25222,12579,6305,46383,63157,58963,61043,20997,2113,4193,4225,2113,14821,58995,255},
{490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,555,556,588,588,588,588,588,588,588,588,588,588,620,620,620,620,620,620,621,621,653,653,653,653,653,653,653,653,685,685,685,685,686,686,718,718,718,718,718,750,750,750,750,750,750,750,750,782,783,783,783,783,783,815,815,815,815,815,847,848,848,848,848,880,880,880,2928,2928,2960,5008,5008,5008,7056,7056,7089,7089,7089,9169,9169,9169,9169,9169,9169,9201,11249,11249,11249,11249,11281,11281,13329,13329,13329,13329,15377,15409,17392,12971,6469,2210,2243,4291,2243,4291,4291,4291,6371,10726,17161,17290,17258,17225,15113,25515,56982,56982,54902,52789,50708,48595,46515,46482,44370,48498,42224,40176,61109,48365,48398,54737,44139,52592,48333,41994,52624,41961,44172,50446,37800,48430,42026,35656,12578,6338,48463,63157,58963,61043,20965,2113,2145,4193,2112,14853,58962,255},
{490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,556,587,555,588,588,588,588,588,588,588,588,588,620,620,620,620,620,620,620,653,653,653,653,653,653,653,653,653,653,685,685,685,686,686,686,718,718,718,718,750,750,750,750,750,750,750,782,783,783,783,783,783,783,815,815,815,815,815,815,847,848,848,848,848,880,880,2928,2928,4976,4976,5008,5008,5008,5040,7056,7089,7089,9137,9137,9169,9169,9169,9169,9169,9201,11249,11249,11249,11281,11281,13329,13329,13329,13329,15409,15312,12971,6436,4258,2211,2243,4291,2243,4291,4291,4323,6403,6403,6371,4323,10725,17193,17258,15113,33869,65401,65337,65369,65369,65369,65369,65369,65369,65370,65369,65402,65402,65337,65369,65337,65337,65369,65337,65304,65336,65304,63223,63255,63223,61109,63190,61077,48366,6305,8418,48495,63157,61044,61043,18885,2113,4225,4225,2113,16933,58995,255},
{490,490,490,490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,556,588,588,588,588,588,588,588,588,588,588,620,620,620,620,620,620,621,621,653,653,653,653,653,653,653,653,653,685,685,685,686,686,686,718,718,718,750,750,750,750,750,750,750,750,783,783,783,783,783,783,783,815,815,815,815,815,815,847,848,848,848,880,880,880,2928,2960,2928,4976,4976,5008,5008,5040,5040,7088,7089,7089,9137,9169,9169,9169,9169,9201,9201,11249,11249,11249,11281,13329,13329,13329,15409,15344,12971,6436,2210,2178,2211,4259,2210,2210,4258,4258,4258,6339,6371,6371,6403,4291,2178,4291,10758,15112,40175,65369,65304,65337,65337,65304,65304,65304,65304,65337,65337,65337,65337,65337,65337,65337,65337,65337,65337,65304,65337,65337,65305,65337,65337,65304,65304,65304,63157,16739,8450,50576,61076,58963,60978,18852,2145,4225,4225,2113,18981,61043,255},
{490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,556,588,588,588,588,588,588,588,588,588,588,620,620,620,620,620,621,621,621,653,653,653,653,653,653,653,653,653,685,685,685,686,686,718,718,718,718,750,750,750,750,750,750,750,750,783,783,783,783,783,783,783,815,815,815,815,815,847,848,848,848,848,880,880,880,2928,2960,2960,4976,5008,5008,5008,5040,5040,5040,7089,7089,9137,9169,9169,9169,9169,9201,9201,9201,11249,11281,11281,13329,13361,13296,10988,6534,4291,2211,2243,2243,2243,2211,2211,2211,4259,4258,4258,4258,6371,6371,6371,4258,4258,4258,4226,4290,42223,65369,65304,65337,65304,65336,65304,65337,65337,65304,65337,65337,65337,65337,65337,65337,65304,65305,65337,65304,65304,65304,65304,65304,65304,65304,65304,63223,65336,37835,10498,50576,63157,61043,61011,18852,4225,4225,4225,2112,19014,61108,255},
{490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,556,588,588,588,588,588,588,588,588,588,588,620,620,620,620,620,620,621,621,653,653,653,653,653,653,653,653,685,685,685,685,686,686,718,718,718,718,718,750,750,750,750,750,750,750,782,783,783,783,783,783,783,815,815,815,815,815,847,847,848,848,848,880,880,880,2928,2960,2960,2960,2960,2960,5008,5040,5040,5040,7088,7089,9137,9169,9169,9169,9169,9201,9201,11249,11249,11281,11281,13264,10988,8615,6469,4421,4389,4323,2243,4291,2243,2243,2243,2211,2211,4259,4258,4258,4258,4291,4291,4258,4291,4290,4290,2178,44304,65369,65304,65337,65337,65337,65337,65337,65337,65304,65305,65337,65337,65337,65337,65337,65304,65337,65305,65304,65337,65305,65304,65304,65304,63256,63256,63223,65336,58899,14691,50576,61076,58930,58897,18852,4225,4225,4193,2113,23207,63189,255},
{490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,556,588,588,588,588,588,588,588,588,588,588,620,620,620,620,621,620,621,621,653,653,653,653,653,653,653,653,685,685,685,685,685,718,718,718,718,718,718,718,750,750,750,750,750,750,782,783,783,783,783,783,783,815,815,815,815,815,847,847,848,848,848,880,880,880,2928,2960,2960,2960,2960,2960,5008,5040,5041,7088,7088,7089,9169,9169,9169,9169,9169,9201,9201,11249,11249,11281,11281,6729,6436,6469,6501,6502,6502,6469,4388,4388,6436,4324,4324,4323,4323,4323,4291,4323,4291,4291,4291,4291,4291,4290,4290,6403,50643,65369,65304,65304,65304,65304,65304,65304,65304,65304,65304,65304,65305,65337,65337,65337,65304,65304,65337,65336,65305,65304,65304,65304,65304,65304,65304,63224,65336,48399,12578,50641,61109,61011,58898,16772,4225,4225,2113,10563,52491,54538,255},
{490,490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,620,620,620,620,620,620,621,621,621,653,653,653,653,653,653,653,653,685,685,685,685,685,718,718,718,718,718,718,718,750,750,750,750,750,750,782,783,783,783,783,783,783,815,815,815,815,815,815,847,848,848,848,880,880,880,880,2960,2928,2960,2960,2960,5040,5041,5041,7088,7088,7089,9137,9169,9169,9169,9169,9201,11249,11249,11249,11281,11281,6893,2244,4389,6501,6501,6502,6501,6501,6501,6501,6501,6501,6501,6501,6501,6469,6469,6469,6501,6469,6469,6468,6468,6500,10661,56917,65337,65304,65304,65304,65304,65304,65304,65304,65304,65304,65304,65304,65304,65304,65305,65304,65304,65305,65304,65305,65304,65304,65304,65336,65337,65337,65304,65304,61077,31528,50608,61076,58963,58898,14691,2145,4225,2145,6338,31494,29317,255},
{490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,556,588,588,588,588,588,588,588,588,588,620,620,620,620,620,621,621,621,621,653,653,653,653,653,653,653,653,685,685,685,685,686,718,718,718,718,718,718,718,750,750,750,750,750,750,783,783,783,783,783,783,815,815,815,815,815,815,815,848,848,848,880,880,880,880,2928,5008,4976,2960,2960,5008,5008,5041,5040,7088,7088,7089,7121,9169,9169,9169,9201,9201,11249,11249,11249,11281,11281,11249,4617,2309,4356,4421,6501,6501,6501,6501,6501,6501,6502,6534,6502,6501,8581,6501,6501,6533,6533,6533,6533,8613,8581,14886,61110,65304,65304,65304,65304,65304,65304,65304,65304,65304,65337,65337,65305,65304,65304,65304,65304,65304,65304,65304,65304,65304,65304,61110,54739,54739,54706,58964,61077,63190,56851,54801,61076,61043,58898,12579,2145,4193,4225,2113,16933,25321,255},
{490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,556,588,588,588,588,588,588,588,588,588,588,620,620,620,620,620,621,621,653,653,653,653,653,653,653,653,653,685,685,685,685,685,686,686,718,718,718,718,718,718,750,750,750,750,750,783,783,783,783,783,783,783,815,815,815,815,815,815,847,848,848,848,848,880,880,880,4976,5008,4976,2960,5008,5008,5040,5041,5040,7088,7089,7089,9169,9169,9169,9169,9169,9201,11249,11249,11249,11281,11281,11281,11313,9006,4487,2276,4357,6469,6501,6501,6501,6501,6502,6502,6501,8549,8581,6501,8549,8581,6533,6533,8581,8613,6533,19112,63223,65304,65304,65304,65304,65304,65304,65304,65304,65304,65336,65337,65337,65336,65337,65304,65304,65304,65304,65304,65304,65304,65337,50481,10531,10531,8451,12676,14757,16837,23175,54802,61077,61043,58866,12579,2145,4225,4225,2112,25351,63188,255},
{490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,555,555,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,588,620,620,620,620,620,621,621,621,653,653,653,653,653,653,653,653,653,685,685,685,685,686,686,718,718,718,718,718,750,750,750,750,750,750,783,783,783,783,783,783,783,815,815,815,815,815,815,847,848,848,848,880,880,880,880,2928,5008,2960,2960,2960,5008,5040,5040,5040,5040,7088,7089,7121,9169,9169,9169,9201,11249,11249,11249,11249,11281,11281,11281,11281,13362,11281,6828,2341,2276,4389,6501,6501,6501,6501,6501,6501,6501,8581,6501,6501,6533,6533,6533,8581,8613,6501,33771,65369,65337,65336,65337,65304,65304,65304,65304,65304,65304,65304,65305,65337,65305,65337,65304,65304,65336,65304,65304,65304,65304,65336,52659,12644,10564,8451,10597,12677,10564,16901,54802,61076,58963,56785,12546,2145,4225,4225,2112,25352,61076,255},
{490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,588,588,588,620,620,620,620,620,621,621,653,653,653,653,653,653,653,653,653,685,685,685,685,685,686,718,718,718,718,750,750,750,750,750,750,750,783,783,783,783,783,783,783,815,815,815,815,815,815,847,848,848,848,848,880,880,2928,4976,2960,2960,2960,2960,5008,5040,5040,5040,5040,7088,7089,7121,9169,9169,9169,9201,9201,11249,11249,11249,11281,11281,11281,13329,13361,13361,15442,11184,4617,2308,4356,6469,6501,6502,6501,6501,6501,6501,8581,6501,6533,6533,6533,6533,8581,6501,25385,58964,58997,61077,61110,63190,63191,65304,65304,65336,65336,65369,65369,65369,65369,65369,65369,65337,65369,65369,65337,65337,65337,65369,58933,18917,21127,21030,10531,10531,10563,14756,54834,61109,61043,56785,10466,2145,4225,4225,2112,25384,61075,255},
{490,490,490,490,490,490,490,490,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,620,620,620,620,620,620,621,621,653,653,653,653,653,653,653,653,653,685,685,685,685,685,685,718,718,718,718,718,750,750,750,750,750,750,750,783,783,783,783,783,783,783,815,815,815,815,815,847,847,848,848,848,880,880,880,880,2928,2960,2960,2960,2960,5008,5040,5041,7089,7088,7089,7089,7121,9169,9169,9169,9201,9201,11249,11249,11281,11281,11281,11281,13361,13361,13361,13361,15442,15442,9006,4487,2276,4389,6469,6501,6501,6501,6501,6501,6501,6533,6533,6533,6533,6533,6533,12774,25255,25255,27303,29383,29448,31561,33609,35721,35786,37834,42027,44141,44173,46285,46318,48399,50512,52625,54705,54738,56851,58964,61077,56818,52590,58963,56784,31495,37833,54671,33672,54802,61076,61011,54672,10466,2145,4225,4193,2112,27432,61076,255},
{490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,555,523,555,555,555,555,555,588,588,588,588,588,588,588,588,588,588,620,620,620,620,621,621,621,621,653,653,653,653,653,653,653,653,653,685,685,685,685,685,718,718,718,718,718,718,750,750,750,750,750,751,783,783,783,783,783,783,783,815,815,815,815,815,847,847,848,848,848,880,880,880,880,880,2960,2960,2960,5008,5008,5041,5041,7088,7089,7089,7089,9169,9169,9169,9169,9201,9201,11249,11249,11281,11281,11281,11281,13361,13361,13361,15409,15409,15441,15442,13329,6795,2341,2276,4421,6501,6501,6501,6501,6501,6501,6501,6501,6533,6533,6533,10693,21095,21063,23142,23143,23174,25223,23142,25223,27303,27335,25222,27302,27269,25189,29447,35752,35557,33346,37735,41960,35654,27204,25156,33673,65302,63124,63124,63222,63190,63156,58963,56882,61077,61076,54673,8386,2145,4193,2145,2112,27465,61076,255},
{490,490,490,490,490,490,490,522,522,522,523,522,523,523,523,523,523,523,523,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,588,620,620,620,620,621,621,621,653,653,653,653,653,653,653,653,653,685,685,685,685,685,685,718,718,718,718,718,718,750,750,750,750,750,750,751,783,783,783,783,783,783,815,815,815,815,815,847,847,848,848,848,848,880,880,880,2928,2960,2960,2960,5008,5040,5040,5041,7089,7089,9137,9169,9169,9169,9169,9169,9201,9201,11249,11249,11249,11281,11281,11281,13361,13361,13361,15409,15441,15441,15442,17490,17522,13231,6632,2276,4356,6501,6501,6501,6501,6501,6501,6501,6533,6533,6501,8581,10661,12709,12644,12611,14691,14723,18852,20932,23044,33607,18884,18884,46285,35622,44105,44139,52526,50347,54671,48266,37702,14691,14658,40012,65269,63123,63124,65303,65303,63223,61076,58930,61044,61011,54640,8353,2145,2145,2112,32,29545,61076,255},
{490,490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,523,523,555,555,555,555,555,587,588,588,588,588,588,588,588,588,588,588,620,620,620,620,621,621,621,653,653,653,653,653,653,653,653,653,685,685,685,685,685,686,718,718,718,718,718,718,750,750,750,750,750,750,750,783,783,783,783,783,783,815,815,815,815,815,847,848,848,848,848,880,880,880,880,880,2960,2960,2960,5008,5040,5041,5040,7089,7089,9137,9169,9169,9169,9169,9169,9201,11249,11249,11249,11281,11281,11281,11281,13361,13361,13361,15409,15441,15410,15442,17490,17489,17522,17489,11021,4454,4356,6502,6566,6566,6566,8614,8614,8614,8614,8614,8614,8614,10694,14724,10498,12579,12579,12611,14659,16739,31528,6338,6370,56883,39815,35687,44106,48136,45990,54605,48266,35623,14659,14691,27302,35688,33575,33576,37769,46318,65271,61044,58931,61076,61076,52560,6305,2145,2145,2112,32,29577,61076,255},
{490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,588,588,620,620,620,620,621,621,653,653,653,653,653,653,653,653,653,653,685,685,685,685,685,685,718,718,718,718,718,718,750,750,750,750,750,750,782,783,783,783,783,783,783,815,815,815,815,815,847,847,848,848,848,880,880,880,880,880,2960,2960,2960,5008,5040,5040,7089,7089,7089,7089,7121,9169,9169,9169,9169,9201,11249,11249,11249,11281,11281,11281,13361,13361,13361,13361,15409,15409,15410,15442,17490,17490,17489,17489,19570,17457,8843,6599,6631,6599,6599,8615,8614,6566,8614,6534,8614,8614,10694,14724,10530,12611,12611,14691,14659,16739,31528,4225,19014,58963,39815,37767,48332,43779,35458,50412,44041,37703,18916,16803,21029,23045,27269,18884,18851,35754,65303,61044,58931,61076,61043,52559,6305,2145,2145,2112,32,31657,61076,255},
{490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,556,588,588,588,588,588,588,588,588,588,620,620,620,620,620,621,621,653,653,653,653,653,653,653,653,653,653,685,685,685,685,685,685,718,718,718,718,718,718,750,750,750,750,750,783,783,783,783,783,783,783,783,815,815,815,815,815,847,847,848,848,848,2896,880,880,880,880,2960,2960,2960,5008,5040,5040,7089,7089,7089,7089,7121,9169,9169,9169,9201,9201,11249,11249,11249,11281,11281,11281,11281,13361,13361,15409,15441,15409,15410,15442,17490,17490,17489,17489,19537,19569,19602,19537,19537,19536,19504,19472,19471,19439,19406,17326,17293,17293,19308,16837,10498,12579,10531,12611,14659,14691,35786,37932,50543,58931,46253,46285,52558,41699,35491,50413,41960,29349,16771,16771,21029,23109,27302,18852,8386,25254,61109,63157,58996,61076,61043,52527,6305,2145,2145,2112,32,33770,63156,255},
{490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,588,556,588,588,588,588,588,588,588,588,588,620,620,620,620,621,621,621,621,653,653,653,653,653,653,653,653,653,685,685,685,685,685,685,686,718,718,718,750,718,750,750,750,750,750,750,783,783,783,783,783,783,783,815,815,815,815,847,847,848,848,848,848,2896,2928,880,880,880,2960,2960,5008,5008,5040,5040,7089,7089,7121,7121,7121,9169,9169,9201,9201,11249,11249,11249,11249,11281,11281,11281,13361,13361,13361,15409,15441,15409,15410,17490,17490,17489,17489,19569,19569,19569,21617,21649,21650,23697,23729,23729,23729,25810,25809,25842,25842,27922,25516,14724,10466,12579,10498,12579,14691,14691,12579,12611,25157,23109,31430,33543,46251,54573,46121,52558,44073,46186,39848,44041,35687,29414,29382,23044,37768,50445,63222,63223,63190,61076,63124,50447,6273,2145,2145,2113,32,35850,63189,255},
{490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,555,555,555,555,555,555,556,588,588,588,588,588,588,588,588,588,588,620,620,620,621,621,621,621,653,653,653,653,653,653,653,653,653,653,685,685,685,685,685,685,718,718,718,718,750,750,750,750,750,750,750,782,783,783,783,783,783,783,815,815,815,815,815,847,847,847,848,848,2896,848,2928,2928,2928,2928,2960,2960,5008,5008,5040,5040,5040,7089,7121,7121,7121,9169,9169,9169,9201,11249,11249,11249,11249,11281,11281,11281,13361,13361,13361,15409,15441,15409,15410,17490,17490,17489,19569,19569,19569,19569,21617,21617,21649,23697,23697,23697,23697,23729,23729,25809,25841,27856,21127,14692,10466,10530,12578,14659,14691,14723,10466,2113,20996,23109,14659,16739,46219,52263,48102,54638,48266,52458,46121,50345,35655,31527,31462,27301,35622,44172,65270,63223,63158,61076,61076,50414,4225,2145,4193,2145,6338,42124,65237,255},
{490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,588,588,620,620,621,621,621,621,653,653,653,653,653,653,653,653,653,653,685,685,685,685,685,685,718,718,718,718,718,750,750,750,750,750,750,750,783,783,783,783,783,783,815,815,815,815,847,847,847,848,848,2896,2896,2928,880,2928,2928,4976,2960,2960,5008,5008,5040,5040,5040,7089,7121,7121,7121,7121,9169,9169,9201,11249,11249,11249,11249,11281,11281,11281,13361,13361,13361,15409,15441,15442,15442,17490,17490,17489,19569,19569,19569,19569,21617,21649,21649,23697,23697,23697,23697,23729,25809,25809,25841,25809,12807,12611,8418,10498,12578,12611,14691,14723,10499,2145,6338,25190,18819,16739,20932,22849,24993,35655,35622,37703,39815,48299,44106,37767,35654,25188,29381,44204,65303,63223,63190,61109,63222,50447,4193,2113,2145,32,25286,56683,56618,255},
{490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,556,588,588,588,588,588,588,588,620,620,620,620,620,620,621,621,621,653,653,653,653,653,653,653,653,653,653,685,685,685,685,685,686,718,718,718,718,718,750,750,750,750,750,750,783,783,783,783,783,783,783,815,815,815,815,847,847,847,848,848,848,848,880,880,880,2928,4976,5008,2960,5008,5040,5040,5040,5041,7089,7089,7121,7121,9169,9169,9169,9201,11249,11249,11249,11249,11281,11281,11281,13361,13361,13361,15409,15441,15442,15442,17490,17489,17489,17489,19537,19569,19569,21617,21649,21649,23697,23697,23697,23697,23729,25809,25809,25809,25809,14952,12611,8418,10498,10498,12579,14691,18851,12579,4225,16837,29415,16771,12579,8418,6273,8386,16772,10466,10498,8418,48497,61044,56817,52590,37768,37766,46219,63222,63223,63190,61109,61010,50380,16804,14756,12675,10531,18916,37734,37669,255},
{490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,556,588,588,588,588,588,588,588,588,620,620,620,620,620,620,621,621,653,653,653,653,653,653,653,653,653,653,685,685,685,685,686,686,718,718,718,718,718,750,750,750,750,750,750,783,783,783,783,783,783,815,815,815,815,815,815,847,848,848,848,848,880,880,880,880,880,4976,5008,2960,5008,5040,5040,5041,5040,7089,7089,7121,7121,9169,9169,9201,9201,11249,11249,11249,11249,11281,11281,11281,13361,13361,13361,15409,15441,15409,15410,15441,17489,17489,17489,19537,19569,19569,21617,21649,21617,23665,23665,23697,23697,23729,25809,25809,25809,25809,17033,12611,10466,10498,10498,10531,12578,29448,33641,46384,48464,29383,14723,12611,12579,10401,8386,16804,12579,12611,12611,40012,61076,65368,65302,46253,18819,21029,61109,63223,58898,58897,48266,46086,41926,44007,44007,44006,41959,39782,29316,255},
{490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,588,620,620,620,621,621,621,653,653,653,653,653,653,653,653,653,653,653,685,685,685,685,686,718,718,718,718,718,718,750,750,750,750,750,750,783,783,783,783,783,783,783,815,815,815,815,815,847,847,848,848,848,880,880,880,880,2928,2928,2960,5008,5008,5040,5040,5040,7089,7089,7121,7121,7121,9169,9169,9201,9201,11249,11249,11249,11249,11281,11281,11281,13361,13361,13361,15409,15441,15409,15442,17490,17489,17489,17489,19537,19569,19569,21617,21617,21617,21617,23665,23665,23697,23729,25809,25809,25809,25809,17130,12644,10498,10498,10498,10530,10498,40045,44205,65400,61044,29382,29480,37965,16804,8353,8386,16772,12579,12579,10499,18884,48397,63124,65204,58865,31496,18981,61109,63223,50478,46284,44073,46054,48166,48166,48166,48166,48198,50246,50246,255},
{490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,588,588,588,588,588,588,588,588,588,588,620,620,620,620,620,621,621,621,653,653,653,653,653,653,653,653,653,653,685,685,685,685,685,686,718,718,718,718,750,750,750,750,750,750,750,782,783,783,783,783,783,783,815,815,815,815,815,847,847,848,848,848,880,880,880,880,2928,2928,2960,2960,5008,5040,5040,5040,5040,7089,7089,7121,7121,9169,9169,9169,9201,11249,11249,11249,11249,11281,11281,11281,13361,13361,13361,15409,15441,15442,17490,17490,17489,17489,17489,19537,19569,19569,21649,21649,21617,21617,23665,23665,23697,23729,25809,25809,25809,25808,25776,19047,8386,10498,10498,12579,10498,44270,44140,50512,37769,35654,52558,63223,23078,8321,10466,14691,12579,6338,6306,16868,46218,54670,63124,58831,46087,25222,61142,63223,48366,44172,42025,46054,46086,48166,48166,50279,50279,52359,52359,255},
{490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,556,588,588,588,588,588,588,588,588,588,588,588,620,620,620,620,621,621,653,653,653,653,653,653,653,653,653,653,653,685,685,685,685,686,718,718,718,718,718,718,750,750,750,750,750,750,782,783,783,783,783,783,815,815,815,815,815,847,847,847,848,848,848,880,880,880,880,880,2928,2960,2960,5009,5040,5040,7089,7089,7089,7089,7121,7121,9169,9169,9169,9201,11249,11249,11249,11281,11281,11281,11281,13361,13361,13361,15409,15442,15442,17490,15441,17489,17489,21520,23502,23470,23534,25615,25615,27728,31953,31953,31985,34097,34097,31985,27727,25581,27629,27726,19015,8386,10466,10498,10530,10530,50577,33609,10498,18950,41960,46154,50479,20933,8321,10434,16771,12579,6306,4193,18916,50509,61011,63123,60977,29284,25189,61142,63191,46285,42091,41993,46053,46053,48166,31397,16771,20964,25156,27236,255},
{490,490,490,490,522,490,490,522,522,522,522,522,523,523,523,523,523,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,588,588,620,620,620,620,620,621,621,653,653,653,653,653,653,653,653,653,653,685,685,685,685,686,718,718,718,718,718,750,750,750,750,750,750,750,750,782,783,783,783,783,815,815,815,815,815,847,847,848,848,848,848,848,2896,2928,880,2928,2960,2960,2961,5009,5040,5041,7088,7089,7089,7089,7121,7121,9169,9169,9201,9201,11249,11249,11249,11249,11281,11281,13361,13361,13361,13361,15441,15442,15442,15442,15441,17490,17489,19537,19505,21552,21552,23600,23600,27760,31919,31822,33869,38062,38094,35982,27597,27597,27661,29709,21095,8386,10498,10498,10498,12611,52691,54771,52723,61175,54672,33444,20964,10498,8321,10433,14691,12579,6305,4225,10530,52623,65303,63124,63189,31398,25189,61142,63190,48365,44204,44105,46054,48134,48166,31462,14756,31462,46118,44006,255},
{490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,556,588,588,588,588,588,588,588,588,588,588,588,620,620,620,620,621,621,653,653,653,653,653,653,653,653,653,653,685,685,685,685,718,718,718,718,718,718,718,750,750,750,750,750,750,750,783,783,783,783,783,783,815,815,815,815,815,847,848,848,848,848,880,880,880,880,2928,2960,2960,5009,5008,5040,5040,5040,7089,7121,7121,7121,9169,9169,9169,9201,9201,11249,11249,11249,11281,11281,11281,11281,13361,13361,13362,15442,15442,15442,15442,15441,17489,17489,19569,19569,19601,19601,21650,21617,14921,12710,16902,18917,20965,20997,20997,18884,18917,20997,23110,18917,8418,10498,10498,12643,37963,50510,54703,56817,56817,56752,41961,27368,25287,23110,18949,21061,31658,48464,44238,40078,58996,65303,63156,65270,29351,23109,63222,63190,46317,44204,44105,46053,46054,48134,31462,23077,33542,46086,46086,255},
{490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,588,588,620,620,620,621,653,653,653,653,653,653,653,653,653,653,653,685,685,685,685,685,686,718,718,718,718,718,718,750,750,750,750,750,750,782,783,783,783,783,783,815,815,815,815,815,815,815,847,848,848,880,880,880,880,880,2928,2960,5008,5008,5008,5040,5040,7089,7089,7121,7121,7121,9169,9169,9201,9201,9201,11249,11249,11249,11249,11281,11281,13361,13361,13361,13362,15442,15442,15442,15442,17490,17489,17489,19569,19569,19569,19569,19406,17000,14790,12709,16870,18918,16837,16804,16804,16804,16804,16804,16772,16804,10466,10498,10498,14723,46349,48429,48429,48462,48397,50477,48429,50509,50477,48397,48397,46284,54769,65302,63124,65368,63256,63255,63157,65303,46255,25190,63223,61110,46285,44204,44105,46053,48134,48198,27237,12579,20964,25188,25156,255},
{490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,588,556,588,588,588,588,588,588,588,588,588,588,620,620,620,620,621,621,653,653,653,653,653,653,653,653,653,653,685,685,685,685,685,686,718,718,718,718,718,718,750,750,750,750,750,750,750,783,783,783,783,783,815,815,815,815,815,815,847,847,848,848,848,848,880,880,880,2928,2960,2960,5008,5040,5040,5040,7089,7089,7121,7121,7121,9169,9169,9201,9201,9201,11249,11249,11249,11249,11281,11281,11281,13361,13361,13362,15409,15442,15442,15442,17490,17490,17489,19537,19537,19537,19309,10630,14757,14822,12742,16870,16869,16805,16804,14692,12579,12611,12644,12611,14724,10498,10498,10466,21029,50510,48429,48429,50510,48429,37866,35817,37898,37930,37898,39978,37833,50544,65270,61043,63256,63255,63255,63157,65303,58899,35721,63223,61109,48365,48365,46185,44005,46085,48166,31462,21029,39879,56520,54439,255},
{490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,588,556,588,588,588,588,588,588,588,588,588,588,620,620,620,620,621,653,653,653,653,653,653,653,653,653,653,653,685,685,685,685,685,718,718,718,718,718,718,718,718,750,750,750,750,750,751,783,783,783,783,783,815,815,815,815,815,815,847,847,848,848,848,880,880,880,880,2928,2960,2960,5008,5008,5040,5040,7089,7089,7121,7121,7121,9169,9169,9201,9201,9201,9201,11249,11249,11281,11281,11281,13329,13361,13361,13362,15409,15442,15442,17490,17490,17489,17489,17457,19504,17196,10597,10532,14789,12710,12677,14757,14724,12612,12611,12579,10499,10499,10499,18950,27368,10466,10498,8418,25287,52623,48397,48429,48462,50477,42027,39978,39978,40010,35850,37930,29479,46383,63124,60978,63190,63190,63190,63091,65303,46253,37800,63255,61077,46284,46284,46185,43973,46053,48166,27237,16804,23076,33477,33477,255},
{490,490,490,490,490,522,490,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,556,588,588,588,588,588,588,588,588,588,588,620,620,620,620,621,621,653,653,653,653,653,653,653,653,653,653,685,685,685,685,685,718,718,718,718,718,718,718,750,750,750,750,782,782,783,783,783,783,783,783,783,815,815,815,815,815,815,815,848,848,848,880,880,880,2928,2928,2960,5009,5009,5009,2993,5040,7089,7089,7089,7121,7121,9169,9169,9201,9201,9201,9201,9234,11281,11281,11281,11281,11281,13361,13362,13361,13361,15441,15442,17490,17490,17489,17456,19504,21357,10565,10565,8484,14757,12677,10597,14725,12611,10499,10499,10499,10499,10499,8419,33674,37801,8418,10531,10466,29480,46284,48397,48461,50542,43880,35365,33413,35494,35526,37639,37639,37639,54737,56818,54704,56882,56882,56850,54671,56849,46187,39913,63255,61077,46285,48365,48298,46086,48166,48166,27269,14724,31494,39846,37734,255},
{490,490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,556,588,588,588,588,588,588,588,588,588,588,588,588,620,620,620,621,621,653,653,653,653,653,653,653,653,653,685,685,685,685,685,685,686,686,718,718,718,718,718,750,750,750,750,750,783,782,783,783,783,783,783,815,815,815,815,815,815,847,847,848,848,848,880,880,880,880,2928,2960,5008,5009,5009,5041,5040,7089,7089,7089,7121,7121,9169,9169,9201,9201,9201,9201,9234,11282,11281,11281,11281,13361,13361,13361,13362,15409,15442,15442,17490,17457,17457,17424,19472,19309,8517,8452,8451,14725,12612,12612,16805,14692,12612,12612,10531,10499,10531,10499,42093,39948,8418,10498,10531,37899,35785,48429,48462,50510,41606,22915,16869,18917,18917,18917,18917,20964,52625,65270,63157,63256,63255,65303,63156,65303,52526,44138,63255,58996,44171,44139,44007,46053,46086,48166,29350,21029,37766,50278,52359,255},
{490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,556,588,588,588,588,588,588,588,588,620,620,620,620,620,621,621,621,653,653,653,653,653,653,653,653,653,653,685,685,685,685,685,686,718,718,718,718,718,750,750,750,750,750,750,783,782,783,783,783,783,783,815,815,815,815,815,815,847,847,848,848,848,880,880,880,2928,2928,2960,5009,5009,5009,5040,5040,7089,7089,7089,7121,7121,9169,9169,9201,9201,9201,9234,9234,11281,11281,11281,11281,13361,13361,13361,13362,15442,15442,15410,17457,17425,17456,17424,19472,19505,13101,6372,6306,14724,10532,12644,18917,18885,18885,16837,12644,10531,10531,10499,46351,46286,8418,10498,10498,25287,39979,48430,50510,50542,39526,20900,18949,16901,18949,18949,18949,16836,50609,63189,63125,63255,63223,63223,63156,60912,27204,35753,65335,58964,44171,39978,39846,48134,48166,48198,33509,23076,23076,23076,23076,255},
{490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,588,588,620,620,620,621,621,621,653,653,653,653,653,653,653,653,653,653,685,685,685,685,685,685,718,718,718,718,718,750,750,750,750,750,782,783,783,783,783,783,783,783,815,815,815,815,815,847,847,848,847,848,2896,880,880,880,2928,2960,2960,5009,5009,5009,5040,5040,7089,7089,7089,7121,7121,9169,9169,9201,9201,9201,9234,9234,11281,11281,11281,11281,13361,13361,13361,13362,15441,15442,15409,17457,17425,17456,17457,19505,19537,19570,13101,6404,14692,14660,8386,12611,12611,14692,14692,14724,14724,14724,14724,50577,44141,10466,10498,10498,27367,39946,48365,44236,48364,39429,22980,18949,18981,18981,18949,18949,18949,54770,63156,61076,63223,63223,63223,65204,50348,12513,31560,65335,58964,42091,42059,35655,43973,50246,50278,50246,50279,50279,50279,46118,255},
{490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,556,588,588,588,588,588,588,588,588,588,588,588,620,620,620,621,621,621,653,653,653,653,653,653,653,653,653,653,685,685,685,685,685,686,686,718,718,718,750,750,750,750,750,750,750,783,783,783,783,783,783,815,815,815,815,815,815,847,848,848,848,848,2896,2928,880,880,2928,2960,2960,5009,5041,5040,5040,5040,5041,7089,7121,7121,7121,9169,9169,9201,9201,9201,9234,11282,11281,11281,11281,11281,13361,13361,13362,15410,15441,15409,15409,17457,17457,17457,17489,19537,19569,19569,19602,13166,4324,4193,8451,8451,6306,6306,4258,4258,4258,6306,6338,52690,48399,10466,10531,10530,29448,33673,46317,31625,29480,35236,29511,23207,27560,23238,23303,21062,18981,58996,63156,63124,63223,63223,63222,63124,58964,23109,35785,65336,56883,42091,39979,39946,20932,18786,20898,20930,23042,27171,29283,31363,255},
{490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,556,588,588,588,588,588,588,588,588,588,588,620,588,620,620,621,621,621,621,653,653,653,653,653,653,653,653,685,685,685,685,685,685,685,686,718,718,718,718,750,750,750,750,750,782,783,783,783,783,783,783,815,815,815,815,815,815,815,848,848,848,2896,2896,2928,880,880,2960,2960,2960,5009,5009,5008,5040,5040,5040,7089,7121,7121,7121,9169,9201,9201,9201,9201,9234,11282,11281,11281,11281,13361,13361,13361,13362,15409,15441,15409,15409,17457,17457,17489,19569,19569,19569,19570,19569,21650,13068,4291,8452,14757,14725,14757,14725,14724,14724,12644,14788,58996,50448,10466,10498,10498,33705,46284,46316,48429,48365,37316,25158,21062,25254,21062,23174,18949,27432,63189,63091,61076,63223,63223,63222,63091,65271,44073,48332,65336,56818,42091,42059,44204,18885,32,2113,2113,2113,32,0,0,255},
{490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,588,588,620,620,620,621,621,621,653,653,653,653,653,653,653,653,653,653,685,685,685,685,685,686,686,718,718,718,718,750,750,750,750,750,750,783,783,783,783,783,783,815,815,815,815,815,815,847,847,848,848,848,848,2896,880,880,880,2960,2960,5009,5009,5040,5040,5040,7089,7089,7121,7121,9169,9169,9201,9201,9201,9201,9234,11282,11281,11281,11281,13329,13361,13361,13362,15409,15441,15409,15409,15409,17489,19538,19570,19569,19570,19602,19601,21617,19569,15181,10890,6469,4291,4291,6339,6306,6306,6306,14724,63123,50414,10466,10498,10498,31560,40010,37897,42058,44074,31075,16804,16804,16869,16837,16836,14756,33706,65270,61011,61109,63223,63223,63190,63090,63223,41993,48429,65336,52591,42059,39979,44172,18885,2112,2145,4193,2112,2144,2112,32,255},
{490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,620,620,620,620,621,621,621,621,653,653,653,653,653,653,653,653,653,653,685,685,685,685,685,686,718,718,718,718,718,718,750,750,750,750,750,783,783,783,783,783,783,815,815,815,815,815,815,847,847,848,848,848,848,2928,2928,880,880,2960,2960,5009,5009,5040,5040,7088,7089,7089,7121,7121,9169,9169,9201,9201,9201,9201,9234,11249,11249,11281,13330,11281,13361,13362,13362,15441,15441,15410,15410,17490,17490,17522,19570,19570,19570,19601,19602,21650,21649,23698,23730,19472,15246,15213,15148,13035,10889,8744,19178,52493,31462,10498,10498,10499,12611,14724,14724,18885,18885,14530,8418,8418,10499,10499,10531,10498,42125,65270,61043,63157,63223,63223,63190,63091,61043,41895,46284,65335,48397,42091,42059,46252,18852,2112,2145,2145,2112,2145,2112,2112,255},
{490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,620,620,620,620,621,621,621,621,653,653,653,653,653,653,653,653,653,685,685,685,685,685,685,686,718,718,718,718,718,750,750,750,750,750,783,783,783,783,783,783,783,815,815,815,815,815,815,847,847,848,848,848,2896,2928,2928,880,2928,2960,2960,5009,5041,5040,5040,7089,7089,7089,7121,7121,9169,9201,9201,9201,9201,9201,11249,11249,11281,11281,11281,11281,13361,13362,13362,15409,15442,15442,15442,17490,17522,17522,19570,19570,19602,19602,21650,21650,21650,23697,23697,23697,23729,23729,23729,23729,23729,23696,34097,50480,23077,12579,10498,10499,12579,10531,6306,12612,12580,6274,4225,4225,4225,4225,4225,4193,40077,65270,61010,63157,63223,63223,63189,63123,46154,16739,37899,65335,50478,42091,42091,46285,16772,2112,2145,2145,2112,2112,2112,2112,255},
{490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,556,588,588,588,588,588,588,588,588,588,620,620,620,621,621,621,621,621,653,653,653,653,653,653,653,653,653,685,685,685,685,685,685,686,718,718,718,718,718,750,750,750,750,750,783,783,783,783,783,783,783,815,815,815,815,815,815,847,847,848,848,848,2896,2896,880,880,880,912,2960,5009,5041,5040,5040,5041,5041,7121,5073,7121,9169,9169,9169,9201,9201,9201,9202,11249,11281,11281,11281,11281,13361,13362,13362,15441,15441,15442,17490,17490,17522,17522,19570,19570,19602,19602,21650,21650,21650,23698,23698,23697,23729,23729,23729,23729,25777,23696,38258,65336,42061,12546,10498,12643,12612,10531,4258,12644,12612,6273,4225,4258,4258,4258,4258,4225,44271,65270,61010,63157,63222,63222,63189,65171,44108,16804,37932,65368,41996,23110,27367,35721,14659,2112,4193,2112,2145,2145,2112,32,255},
{490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,556,588,588,588,588,588,588,588,588,588,620,620,620,621,621,621,621,621,653,653,653,653,653,653,653,653,653,685,685,685,685,685,685,685,685,718,718,718,718,750,750,750,750,750,782,783,783,783,783,783,783,815,815,815,815,815,815,815,815,847,847,847,2896,2896,2928,880,880,912,2960,5008,5008,5008,5040,7089,5041,5073,5073,7121,9169,9201,9201,9201,9201,9201,11282,11249,11249,11281,11281,11281,13362,13362,13362,15410,15442,15442,17490,17490,17522,17522,19570,19570,19602,19602,21650,21650,21650,23730,23698,23729,23729,23729,23729,25809,25777,25776,31854,44172,42059,14724,12611,21061,16869,10499,4258,12644,12612,6273,4225,4225,4258,4225,4258,4225,44270,65270,61010,63157,63222,63190,63189,63091,61077,20964,35819,65368,42093,18983,16869,16837,10498,2112,4225,4225,4193,4193,2112,32,255},
{490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,620,620,620,621,621,621,621,621,653,653,653,653,653,653,653,653,653,685,685,685,685,685,685,685,686,718,718,718,718,750,750,750,750,750,750,783,783,783,783,783,783,815,815,815,815,815,815,815,815,815,847,847,847,2896,880,880,880,2960,2960,5008,5008,5040,5040,7089,5041,5073,7121,7121,9169,9169,9201,9201,9201,9201,9234,11282,11281,11281,13361,13361,13362,13362,13362,13362,15442,15442,15442,17490,17490,17522,19570,19570,19602,19602,21650,21650,21682,23730,23730,23730,23729,25778,23729,25809,25809,25809,25581,23142,23142,23175,23207,21029,14692,10531,4225,10531,12612,8322,4225,4225,4226,4226,4258,2145,35819,65270,61010,63190,63222,63222,63189,63124,61011,20964,37931,65367,65270,65302,35755,6241,8418,2113,4225,6305,4193,2145,2145,2112,255},
{490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,555,588,588,588,588,588,588,588,588,620,620,620,620,620,621,621,621,653,653,653,653,653,653,653,653,653,653,653,685,685,685,685,685,685,718,718,718,718,718,750,750,750,750,750,783,783,783,783,783,783,783,815,815,815,815,815,816,816,847,847,847,847,2896,2928,880,880,2928,2960,2960,5008,5040,5040,5040,7089,7121,7121,7121,9169,9201,9201,9201,9201,9201,9234,11282,11282,11281,11282,13330,13361,13362,13362,13394,13394,15442,15442,15442,17490,17490,17522,19570,19602,19602,21650,21650,21650,21650,21682,23730,23730,23729,25778,25809,25809,25809,25809,25744,23501,25516,27596,29514,16869,12644,10531,2145,8419,12612,8322,4225,4258,4258,4258,4258,4225,35819,65270,61010,63190,63190,63190,63157,63124,63157,50412,31495,44075,41994,35623,20964,4193,12611,8418,4257,4225,4225,2145,2145,2112,255},
{490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,556,588,588,588,588,588,588,588,588,620,620,620,620,621,621,621,621,621,653,653,653,653,653,653,653,653,653,685,685,685,685,685,685,685,718,718,718,718,718,718,750,750,750,750,2830,782,782,783,783,783,4910,4878,6958,15149,13004,10988,11053,8973,8974,6926,6958,4943,4943,4943,2928,2928,2928,2960,2960,2993,5041,5041,5041,7121,7121,7121,7121,9169,9169,9201,9201,9201,9201,9202,11282,11282,11282,13330,13330,13362,13362,13394,13394,13394,15442,15442,15442,17490,17522,17522,19570,19602,19602,21650,21650,21650,21682,23730,23730,23730,23730,25778,25809,25809,25809,25809,25808,25809,27856,27889,16968,44271,42159,14724,6338,10564,14724,8322,2145,2177,2145,2145,2145,2113,29545,65270,61010,63190,63190,63222,63157,63091,56719,39782,14691,8452,8419,32,16803,29348,20996,20996,18851,18851,23173,14788,2113,4193,255},
{490,490,490,490,522,490,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,620,620,620,621,621,621,621,621,653,653,653,653,653,653,653,653,653,653,685,685,685,685,685,718,718,718,718,718,718,750,750,750,750,6893,17000,21258,17098,17131,15050,12971,21259,17001,17034,19146,19081,19113,21226,19114,19114,19114,19114,21226,19146,17130,17131,17131,15116,15116,13101,11053,11086,11118,11151,9103,9136,9136,9169,9169,9169,9201,9201,9202,9234,9234,9234,11282,11314,13330,13362,13362,13362,13394,13394,13394,15442,15442,15474,17522,17522,17522,19602,19602,19602,21650,21682,21682,23730,23730,23730,23730,25778,25810,25809,25809,25809,25809,25808,25776,27824,27824,31823,42061,44173,39850,29351,37899,39980,39947,35851,33739,31659,27466,25353,21095,35851,65237,61011,63222,63190,63190,63189,63090,33478,25124,12644,8516,8451,2113,25188,54373,31396,2145,4225,4225,4193,4193,2145,2113,255},
{490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,556,588,588,588,588,588,588,588,588,620,620,620,620,620,621,621,621,621,653,653,653,653,653,653,653,653,653,653,685,685,685,685,686,718,718,718,718,718,718,718,750,750,6991,21324,19014,25386,14921,19114,19114,12840,21194,17033,14953,17034,17066,14953,19114,19146,17033,17033,19146,17033,17033,19146,19113,17033,19146,19113,19081,21194,19145,19113,19146,19146,19146,19178,19211,17163,17196,17228,15181,15213,15246,15279,13263,13264,13296,13329,13329,13361,13362,13394,13426,15474,15474,15474,17522,17522,17522,17554,19602,19602,19634,21682,21682,21682,23730,23730,23730,23730,25778,25810,25810,25809,25809,25809,25808,25776,27824,27791,57080,42094,21030,20965,4193,6273,8418,27303,25222,29383,31496,33609,35721,33641,48431,65270,61011,63223,63222,63190,65237,65236,44141,18787,10531,8516,8451,2113,25188,52293,48101,10498,2145,2145,2145,2145,2112,32,255},
{490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,620,620,620,620,620,620,621,621,621,653,653,653,653,653,653,653,653,653,685,685,685,685,685,686,718,718,718,718,718,718,718,750,2830,15215,23241,23240,21226,17033,23339,17001,25419,14985,19114,14953,14953,19114,17033,17033,19146,19114,14953,19114,19114,14953,17066,19146,17001,19114,19178,17033,17065,19146,17033,17066,19146,17065,17065,21226,19113,19113,21226,19113,19113,21193,19113,19113,21225,19145,19146,19210,19211,19243,19276,17260,19341,19374,19406,19439,19471,19504,19537,21617,21552,19374,19439,21519,21584,23665,23665,23697,25778,25810,25810,25842,25842,25842,27890,27889,25809,27856,27824,61241,44175,23142,23078,4193,2145,4258,21062,14789,19014,14724,18950,10564,16837,46351,61010,56784,61076,61076,61044,46220,46188,48398,27270,10499,8516,8451,2146,27301,50213,50213,31396,2145,4193,2145,8515,19046,21191,255},
{490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,556,588,588,588,588,588,588,588,588,620,620,620,620,620,620,621,621,621,653,653,653,653,653,653,653,653,653,685,685,685,685,686,686,718,718,718,718,718,718,750,750,2798,13102,16966,25386,17033,21226,21227,17033,27499,14921,17066,17065,14953,17066,19146,17033,17033,19146,14953,17033,19146,17033,17033,19146,17033,14953,19178,19146,17033,19146,19146,17033,19146,19146,17033,19146,19146,17033,19178,19146,17033,19146,19146,17033,21226,19178,17033,21226,19146,17065,21226,19145,19113,21225,19113,19113,21193,19145,19177,21258,19145,17000,17000,17000,17000,17000,19080,19113,19113,19177,19210,21291,21355,23436,23469,23533,25614,25646,27726,46352,35722,23143,23078,4225,4225,6338,21094,14756,21062,16837,21062,16837,18949,44205,58930,52591,56850,56817,54672,14692,4225,6305,8386,8451,8516,8484,8452,31462,52293,50213,48101,10498,2145,2145,6338,14691,20997,255},
{490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,556,588,588,588,588,588,588,588,588,588,620,620,620,620,620,621,621,653,653,653,653,653,653,653,653,653,653,685,685,685,685,685,686,718,718,718,718,718,718,750,750,750,13003,19047,25419,14921,25387,17034,21226,21258,14953,14953,19146,17033,17033,19146,17066,14953,19146,19114,14953,17066,19146,14985,17065,19146,14953,19114,21226,17033,17066,19178,17033,17066,19178,17033,17066,19178,17065,17066,19178,17033,17065,19178,17065,19146,21258,17065,19146,21226,17065,19146,21258,17065,19178,21258,17098,19178,21258,17065,19178,19178,17097,21258,19178,17097,21258,19145,19113,19145,19112,19112,19080,16999,19080,16967,16967,19047,16967,19047,14789,18950,25255,23078,4225,4258,6371,23175,21095,29351,31431,18950,16869,16869,44238,65302,61011,63223,65271,63092,16805,4258,4225,2145,6371,8516,8484,8452,31461,52293,50213,50213,31364,2113,4193,2145,2145,2113,255},
{490,490,490,490,490,522,522,522,523,523,523,523,523,523,555,523,555,555,555,555,555,556,555,588,588,588,588,588,588,588,588,588,620,620,620,620,621,621,621,621,653,653,653,653,653,653,653,653,653,685,685,685,685,686,686,718,718,718,718,718,750,750,750,11087,17065,23208,23306,14953,25419,19114,25419,17066,17066,14953,17034,19114,17001,17033,19146,17033,17033,19146,14985,14985,19146,17033,14985,19146,17065,17033,21226,19146,17033,19178,17066,17033,19178,19146,17066,19178,17098,14985,19178,19146,17033,19178,19146,17065,21226,19145,17065,21226,17098,17065,21258,19145,19146,21258,19146,19146,21290,17098,19146,21258,17097,19178,21258,17097,21258,19210,17097,21258,19177,19113,21258,19177,19145,21257,19145,21225,21257,19112,19015,18950,25255,23078,4193,2145,6338,21062,18982,44074,33511,18982,21030,21030,50609,65237,61010,63223,63222,61012,12612,2178,4225,4226,6371,8484,8484,8452,31461,52326,52294,50181,48101,10498,2145,4193,4193,4193,255},
{490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,620,620,620,621,621,621,621,621,653,653,653,653,653,653,653,653,653,653,685,685,685,686,686,718,718,718,718,718,750,750,2798,17230,19047,23305,19114,19146,23307,27466,27467,14953,19146,17033,14953,19114,17066,14953,19146,19114,14953,17066,19114,14953,17066,19146,14953,17066,19146,17033,19146,19178,17065,17098,19178,17033,17098,21226,17065,19146,19178,17033,19146,19146,17033,19146,21226,17065,19146,21226,17065,19178,19178,17065,19178,19178,17065,21258,19178,17066,21258,19178,17065,21258,19178,19178,21258,17097,19177,21290,17097,19178,21258,17097,21257,21257,19145,21258,19177,19177,23338,19145,21128,18950,25255,23078,4225,2177,6338,21062,21062,27335,21062,23207,21062,27335,56850,65269,63091,65303,65303,61012,12580,4226,4226,2145,6371,8484,6371,4258,31429,54373,52293,52261,52293,37668,6338,4225,4225,2145,255},
{490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,555,588,588,588,588,588,588,588,588,620,620,620,620,620,621,621,621,621,653,653,653,653,653,653,653,653,653,685,685,685,685,686,686,718,718,718,718,750,750,718,4878,19244,19015,25419,14953,23306,19114,19146,23339,14985,17034,19146,17033,17033,19146,17033,17033,19146,17033,14985,19146,17033,14985,19146,17033,14985,19178,19114,17065,21226,19114,17033,19178,19146,17033,21226,19146,17065,19178,17066,17033,19178,17066,17066,21258,19114,17065,21258,17065,19146,21258,17098,19146,21258,17065,19178,21258,17065,19210,19210,17065,21258,19210,17097,21258,19177,19145,21290,19177,19177,21258,19145,19177,21258,19145,21257,21257,19177,23338,21225,23143,20998,25255,23078,4225,4258,8451,21062,12676,18982,14724,21030,14756,21030,29383,37801,39849,46188,52558,52493,8419,2178,4225,2145,6371,8483,6338,4225,23076,20898,20898,25058,27170,31363,27204,23043,23043,18851,255},
{490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,588,588,588,588,588,588,588,588,620,620,620,620,620,621,621,621,653,653,653,653,653,653,653,653,653,653,685,685,685,685,686,686,718,718,718,718,718,718,750,9007,12873,12644,19048,12808,25354,14953,21194,14855,14823,14855,16968,14920,14888,19081,17033,14953,19113,19113,14953,19114,19146,14953,17066,19146,14953,19146,19178,17033,19146,19178,17033,19146,19178,17033,19178,19178,14985,19146,19146,14985,19146,19178,17065,19178,19146,17033,21226,19146,17065,21258,19178,17098,21258,17098,17098,21258,17097,19178,21290,17097,19178,21258,17097,21258,21258,19146,21290,19210,19177,21290,19177,19177,23338,19145,21225,21290,19177,21290,21257,23078,25125,25223,23078,6273,4225,6338,23143,25255,21062,23175,21062,21095,21062,12676,8451,6339,10531,12643,16772,4258,4226,2177,2145,6371,8483,6338,2145,29349,20963,6338,4258,4226,2145,2145,2145,4193,4193,255},
{490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,556,588,588,588,588,588,588,588,620,620,620,620,621,621,621,621,653,653,653,653,653,653,653,653,653,685,685,685,685,685,686,686,686,718,718,718,718,718,2798,9006,6698,4226,6404,6469,8550,8582,10662,16968,12710,12742,14790,12709,12710,12742,12710,12710,12710,12742,12742,14855,16935,14855,14888,17000,16968,17000,19146,17065,17033,21226,17065,17033,19146,17033,17065,19210,17066,17066,21258,17033,17065,19178,17066,19146,21226,17033,19146,19178,17065,21258,21258,17065,21258,19178,17066,21258,19178,17098,21290,19178,19178,21291,17098,19178,21290,17097,21258,21290,19145,21258,19177,19145,21290,19177,19177,23338,19177,21258,23338,25094,35623,31593,29383,6306,6370,10563,23175,16837,18982,16837,18982,16869,21062,12644,8451,4258,4258,6403,8484,6371,8451,8452,8452,8451,8451,6371,4290,20964,35588,35556,33508,33508,31428,31428,29380,27268,27236,255},
{490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,556,588,588,588,588,588,588,588,588,620,620,620,620,621,621,621,653,653,653,653,653,653,653,653,653,653,685,685,685,685,686,686,718,718,718,718,750,718,718,2798,2700,10564,14854,4389,6437,6437,6469,16936,14855,12743,16935,16935,14822,16935,16935,12710,12742,14822,10629,12742,12742,10629,12710,12709,12677,12709,14790,12742,12742,14854,14855,14855,16935,14887,14888,19081,17033,17001,19146,19113,17033,21258,19146,17066,21258,17098,17065,21258,17098,19146,21290,17065,19178,21258,17066,21258,19210,17098,21291,19178,17098,21291,19178,19178,21290,19177,21258,21290,17097,21258,21258,19145,23338,19177,19177,23338,19177,21257,23370,18853,25189,33640,35591,23077,31624,37898,42123,42091,40011,37930,37930,33705,25287,8483,4290,4226,4225,8451,8484,6371,8484,8516,10564,8484,8451,6403,6338,6338,6306,4225,6305,8353,10434,8385,25189,20932,16706,255},
{490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,556,588,588,588,588,588,588,588,588,620,620,620,620,621,621,621,621,653,653,653,653,653,653,653,653,653,685,685,685,685,686,686,718,718,718,718,750,718,718,9006,11022,6469,10564,6437,6437,8518,12743,6437,6470,6469,6470,8550,8550,8582,10662,10662,10662,14823,12742,12742,16935,14823,14822,16967,14822,14790,16935,14822,12710,14854,12742,12709,14790,12709,12677,12742,12709,12709,14822,12742,12742,14822,14854,14855,16967,17000,14920,19113,19113,17065,21258,17065,17065,21258,19146,19178,21291,17098,19210,21290,17098,21291,21258,17097,21290,19210,19210,23370,19177,19209,21290,19145,21290,21257,19145,23370,19209,21225,25418,12677,2113,6306,8386,8354,10466,10466,14691,16739,18852,20964,25157,27270,27334,14724,4290,4258,4258,6371,8451,6371,8451,8452,8484,8451,8451,6370,6338,6338,6305,4225,6306,4225,4225,4193,12643,16805,33,255},
{490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,556,588,588,588,588,588,588,588,620,620,620,620,621,621,621,621,653,653,653,653,653,653,653,653,653,653,685,685,685,685,686,718,718,718,718,718,718,718,750,4846,13135,4454,6339,6437,6437,6437,8518,4389,4421,4389,4389,6470,6470,6470,6470,6470,6469,6437,6469,6470,6470,8550,8550,8582,10662,10662,12742,12775,12710,14855,14855,12742,16935,16935,12742,16935,16935,12742,16934,14822,12709,14822,12741,12677,12742,12677,10629,12741,10661,12709,14822,12709,12742,14855,14855,14887,17000,16968,17032,19145,17033,19178,21258,17097,21290,21258,19178,23370,19210,19177,23338,19177,21290,23338,19145,23370,21257,19177,23370,14855,21127,18982,8419,8386,10563,18917,20771,20706,20739,16610,14562,12482,12514,8419,6371,4258,16869,10531,6371,6371,6339,4258,4290,6403,6338,4225,4225,6306,4193,4225,6306,4193,2145,4193,6370,23142,4193,255},
{490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,555,556,588,588,588,588,588,588,588,620,620,620,620,620,621,621,621,621,653,653,653,653,653,653,653,653,685,685,685,685,685,686,718,718,718,718,718,718,750,750,718,4878,14954,6339,6437,6469,6437,6437,6437,4422,6437,6437,6437,6469,6470,6470,6470,6470,6469,6470,6470,6470,6470,6470,6470,6470,6470,6470,6470,6502,6470,6470,6502,8550,8582,8582,10662,12743,10662,12774,14855,12742,14855,16935,14822,16935,16935,12742,16935,14854,12742,16935,12742,12709,14854,12709,12709,12742,10629,12709,12709,10629,12709,12741,12709,12774,14822,12806,16967,14919,16967,19112,17032,19144,21225,19113,23338,23338,19177,25418,21257,29481,23174,6339,4193,8451,20965,26818,28834,32930,37058,37090,35042,35042,14563,6371,4258,8418,8419,6371,6371,6339,4225,6338,6403,6338,4225,4225,4225,4225,4193,4193,4225,6306,6306,10563,27270,6273,255},
{490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,555,555,555,555,555,555,556,556,588,588,588,588,588,588,588,588,620,620,620,620,620,621,621,621,621,653,653,653,653,653,653,653,653,685,685,685,685,686,686,686,718,718,718,718,718,718,750,750,750,2635,6338,6372,6437,6405,6469,6437,6469,6469,6469,6469,6470,6470,6502,6470,6470,6469,6469,6470,6470,6470,6470,6470,6470,6470,6470,6470,6502,6470,6470,6502,6470,6470,6502,6502,6469,6502,6470,6470,6502,6502,8550,8582,8582,10662,10662,10662,12742,10694,14823,14855,12742,16935,14887,12742,16967,14854,14822,19015,12774,14822,16934,12709,14822,12774,10629,12741,12709,10629,12709,10629,10629,12709,10629,12741,12741,12741,14854,16934,35786,27367,8419,4225,12579,14692,6241,4193,4193,6273,6241,8289,10338,8419,6371,6339,6403,12741,12709,10596,8516,8484,6404,6370,6305,4225,4193,2145,4225,2145,4193,6306,8418,6338,8418,10498,6273,255},
{490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,556,556,588,588,588,588,588,588,588,620,620,620,620,621,621,621,621,621,653,653,653,653,653,653,653,653,653,685,685,685,685,686,686,718,718,718,718,718,718,750,750,750,685,2439,4455,4422,6469,6502,6437,6437,6469,6469,6470,6470,6470,6502,6470,6470,6470,6469,6469,6470,6470,6470,6470,6470,6470,6470,6470,6470,6470,6502,6502,6502,6502,6502,6502,6502,6502,6502,6502,6502,6502,6502,6502,6501,6502,6502,6502,6502,8582,8550,8550,8582,8582,8582,8582,10630,10662,10662,12743,12742,12742,14855,12774,14822,16935,12742,16935,16902,12742,16934,14822,14822,16934,12709,14822,14822,12709,12741,14789,42092,46318,18917,6274,6306,10531,6273,2145,4226,4226,2178,2178,2145,6371,6371,4290,29546,58995,54802,50576,48529,44336,40142,33739,12611,6305,4225,4225,4225,4193,2145,4225,4193,2145,4225,8385,6273,255},
{490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,588,588,588,588,588,588,588,620,620,620,620,620,621,621,621,621,653,653,653,653,653,653,653,653,653,653,653,685,685,685,686,718,718,718,718,718,718,750,750,750,750,750,783,750,718,2733,2700,2602,4422,6469,4421,6470,6470,6470,6502,6470,6470,6470,6469,6470,6470,6470,6470,6470,6470,6470,6502,6502,6502,6470,6502,6470,6502,6502,6502,6502,6502,6502,6502,6502,6502,6502,6502,6502,6502,6502,6502,6502,8550,8582,8550,8550,8582,8582,8582,8582,6502,8582,8582,8582,8582,8582,8582,8614,8582,10630,10662,10662,10662,10662,12742,12774,12742,14854,12774,14854,16935,14822,16935,14853,44206,65369,44206,6241,4225,12579,8322,4225,8451,10563,8451,8451,6370,6371,6371,6339,33673,58865,58897,60945,63189,65270,65334,60978,18851,4225,6305,6305,6273,4193,4225,4225,2113,2145,8418,8385,4225,255},
{490,490,490,490,522,522,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,556,588,588,588,588,588,588,588,588,620,620,620,620,621,621,621,621,653,653,653,653,653,653,653,653,653,653,685,685,685,685,686,718,718,718,718,718,718,750,750,750,750,750,750,750,783,783,783,783,2472,6470,4421,6470,6470,6470,6470,6469,6470,6470,6469,6470,6502,6502,6502,6470,6470,6470,6502,6502,6502,6502,6502,6470,6502,6502,6502,6502,6502,6502,6502,6502,6502,6502,6502,6502,6502,6502,6502,6502,8550,6534,8550,8582,8582,8582,8582,8582,8582,8582,8582,8582,8614,8582,8582,8582,8582,8582,10662,8582,8582,10662,8582,8581,8614,8581,10662,10662,10629,10661,10661,10629,33739,65270,54706,18885,12741,16869,10402,4225,10531,12611,10563,10531,10564,8451,6371,6371,12644,23109,25190,25157,29351,31495,33608,35624,12578,4193,6273,4225,4225,4225,6305,14723,8418,4193,6305,4225,4193,255},
{490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,588,588,588,588,588,588,588,588,620,620,620,621,621,621,621,621,621,621,653,653,653,653,653,653,653,653,685,685,685,685,686,686,718,718,718,718,718,718,750,750,750,750,750,783,783,783,783,783,750,718,2733,2700,4715,4683,4617,4585,6600,4519,6534,6502,6470,6470,6470,6470,6470,6469,6469,6470,6470,6502,6502,6502,6502,6502,6502,6502,6534,6502,6502,6502,6502,6502,6502,6502,6502,6534,6502,6502,8582,8582,8550,6534,8582,8582,8582,8582,8582,8582,8582,8582,8614,8582,8582,8582,8582,8614,10662,10662,8614,8614,8582,10630,10662,8581,10662,10662,10629,10661,10661,8549,40045,63124,61012,50447,58962,39816,10369,4225,10531,12612,10531,10531,10531,8451,6371,8451,8451,16869,25222,18917,18917,23110,25254,12610,4225,4225,4225,4225,4225,4225,4225,8418,6305,4225,6337,4225,4193,255},
{490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,588,588,588,588,588,588,588,620,620,620,620,620,621,621,621,621,653,653,653,653,653,653,653,653,653,653,653,685,685,685,685,718,718,718,718,718,718,718,750,750,750,750,750,750,783,783,783,783,783,815,815,815,815,848,848,848,848,2863,2863,2830,2797,4813,4780,6763,6730,4617,6632,4552,6567,6535,6502,6502,6502,6469,6469,6502,6502,6502,6502,6502,6502,6502,6502,6502,6502,6502,6502,6502,8582,8582,8582,8582,8582,8582,8583,8582,8582,8582,8582,8582,8582,8582,8582,8614,8582,8614,8614,8614,8582,8614,10630,8614,8614,8581,10662,10662,10661,10661,10661,10661,37834,50413,46123,44043,35688,27237,22754,4193,10499,12612,12612,12612,10531,8451,6371,6371,10532,23174,25222,20997,10531,8418,14724,8386,4225,4225,4225,4193,4225,4225,4193,4225,4193,4193,6305,4225,4193,255},
{490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,620,620,620,620,621,621,621,621,653,653,653,653,653,653,653,653,653,653,685,685,685,685,686,718,718,718,718,718,718,750,750,750,750,750,750,783,783,783,783,783,783,783,815,815,815,815,815,847,848,848,848,880,880,880,912,2961,5009,5008,7088,5008,7056,7023,6990,6926,4845,6828,6795,6762,6697,6632,6600,6567,6534,6534,6502,6502,6501,6502,6502,6502,6502,8550,6534,8582,8582,8582,8583,8582,8582,8582,8582,8582,8614,8582,8582,8614,8582,10662,10662,8582,8614,8614,8582,8614,8614,8581,10662,10662,10662,10662,10661,12773,35819,37932,33576,27270,25287,23109,12418,2145,6338,8418,8386,8418,8419,8451,6338,6338,10564,27367,27303,18949,18981,35785,31495,8386,4225,4225,4225,4225,4225,4193,2145,4225,4225,4193,4225,4225,4193,255},
{490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,556,588,588,588,588,588,588,588,588,620,620,620,620,620,621,621,621,621,653,653,653,653,653,653,653,653,653,685,685,685,685,686,686,718,718,718,718,718,750,750,750,750,750,783,783,783,783,783,783,783,815,815,815,815,815,815,847,847,848,848,848,848,880,880,880,2928,5008,7056,7056,7089,5041,7089,7121,7121,7121,7153,7153,9201,9169,9169,9136,9104,9071,9038,8973,8940,8875,8810,8745,8712,8648,6567,6567,8582,8550,8582,8550,8550,8582,8582,8582,8614,8582,8614,10662,10630,10662,10662,8614,10662,10662,8582,10662,10662,8582,10662,10662,10662,10662,10629,12709,52657,65368,58834,56720,61174,56786,35333,37996,27368,14691,23207,25352,14756,10531,14756,10564,10564,21062,25223,18917,21062,27335,25222,10499,4225,4193,4225,4257,4225,4225,4225,8385,4225,4193,4225,4225,4193,255},
{490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,620,620,620,620,621,621,653,653,653,653,653,653,653,653,653,653,653,685,685,685,686,686,718,718,718,718,718,750,750,750,750,750,750,750,783,783,783,783,783,783,783,815,815,815,815,815,815,847,848,848,848,880,880,880,880,2928,5008,7056,7056,5040,5040,7088,7089,7089,7121,7121,9169,9169,9201,9233,9234,11282,11282,11282,11314,11314,13362,13394,13394,13362,13361,13329,13296,13231,13198,13133,11020,10955,10890,10825,8744,8615,8582,8614,8614,10662,10662,10662,8614,8614,10662,8614,10662,10662,10662,10662,10662,10661,10662,10661,8516,27303,37801,35592,37736,46220,46091,31172,42026,29383,14756,35785,48396,27303,18949,46316,42059,12676,23142,25223,18917,21095,25255,25255,18917,4225,4225,6305,6306,4257,4225,4225,6273,4193,4225,4193,8418,10498,255},
{490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,620,620,620,620,620,621,653,653,653,653,653,653,653,653,653,653,653,685,685,685,685,686,718,718,718,718,718,718,750,750,750,750,750,750,750,783,783,783,783,783,783,815,815,815,815,815,815,847,848,848,848,880,880,880,880,2928,4976,5008,7056,5040,5040,5040,7089,7121,5073,7121,9169,9136,10922,13003,13068,13133,13198,13231,13264,13297,13329,13362,13394,13394,15474,15474,15475,15507,17555,17555,17555,19635,19603,19602,19602,15116,6469,8517,8549,8517,8517,10597,14822,12774,12742,12709,10694,10662,10661,10662,10662,10662,10694,10662,10597,21030,18917,16739,16739,20965,20932,8354,12611,8386,4225,12611,18884,8418,8418,23109,23110,12644,23175,27303,18917,18916,20997,29415,37866,21029,6338,4225,4225,4225,4193,4193,4193,4193,4225,4225,10531,12611,255},
{490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,588,620,620,620,620,621,621,653,653,653,653,653,653,653,653,653,653,685,685,685,685,686,686,686,718,718,718,718,750,750,750,750,750,750,750,782,783,783,783,783,783,783,815,815,815,815,815,815,815,847,848,2896,880,880,880,2928,2928,4976,5008,5008,5040,5040,5040,7089,7121,7089,7089,7121,9039,8517,10597,10629,10629,10662,12710,12742,12807,12839,14921,15018,15083,15148,17261,17294,17359,17423,19537,19569,19602,19634,21682,21682,19635,15376,11085,8842,6664,4454,4324,12644,16739,18851,22947,20899,12611,6338,8419,8451,8451,8484,8516,10628,18917,12612,6241,6241,6241,6273,6273,6273,4225,4193,6273,6306,4225,4193,8386,6338,12644,31561,27335,18917,10531,10563,18917,12611,8386,6306,4225,4225,4193,4225,4225,4225,4225,4225,4225,4225,6338,255},
{490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,556,588,588,588,588,588,588,588,588,588,588,620,620,620,621,621,621,621,653,653,653,653,653,653,653,653,685,685,685,685,686,686,718,718,718,718,718,718,750,750,750,750,750,750,783,783,783,783,783,783,815,815,815,815,815,815,815,815,847,848,2896,880,880,880,2928,2960,2960,5008,5040,5040,5040,5041,7089,7088,15376,15409,13361,10989,8549,10629,10629,10629,10630,10629,10629,10662,10629,10629,10629,10630,10629,10661,12710,10694,12774,12807,14887,14952,17065,17098,19243,19308,21454,21519,23632,23664,21584,19504,13035,2276,14724,31365,18787,12514,2145,2145,4193,4193,4193,4225,4225,10531,12579,6273,6241,6241,6241,6273,6273,4193,4225,4193,4225,6273,6273,4193,4193,14724,27367,27303,16837,23207,39914,31527,27400,25287,25254,10498,6305,6305,4225,4225,4225,6338,6306,4257,4257,4225,255},
{490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,588,588,620,620,620,621,621,621,621,653,653,653,653,653,653,653,653,653,685,685,685,685,686,718,718,718,718,718,718,750,750,750,750,750,750,750,783,783,783,783,783,783,815,815,815,815,815,815,815,847,848,2896,880,880,2928,2928,2960,2960,5008,5040,5040,5040,7089,5041,13003,33771,40176,38128,19146,8516,10629,10661,10662,10629,10629,10662,10629,10629,10629,10662,10662,10661,10662,10662,10661,10662,10662,10661,10661,10661,12709,12709,10661,12709,12742,12774,14822,14887,16967,17000,14984,19047,31464,16804,12612,6371,6338,4290,4258,4225,4225,4225,4193,4225,6273,6241,6241,6241,6273,6241,4225,4225,4193,4193,4193,4193,4193,4161,12644,21062,25190,16837,21062,23142,23110,14724,16837,23142,10531,4225,6305,4225,4225,4225,6370,8450,8451,10531,10531,255},
{490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,588,588,588,620,620,621,621,621,621,653,653,653,653,653,653,653,653,653,685,685,685,685,686,718,718,718,718,718,718,750,750,750,750,750,750,750,783,783,783,783,783,783,815,815,815,815,815,815,815,847,848,2896,880,880,2928,2928,2960,2960,5008,5008,5041,5040,5040,7089,6958,23469,38031,37998,14855,8549,8581,10629,10629,10629,10629,10661,10662,10630,10662,10629,10662,10662,10662,10662,10662,10662,10662,10662,10661,10661,10661,10661,10661,10661,10662,10694,10662,10661,10661,12742,10694,10694,12774,12742,12774,12742,12742,12742,10661,10661,10629,10596,10596,8483,6273,6241,6241,6241,6273,6241,4193,4193,4193,4193,4193,4225,4225,4193,12611,21062,25255,18917,25255,25287,27400,25320,23175,23175,21062,8419,4225,4225,4225,4225,4193,4225,4193,4225,2113,255},
{490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,588,588,588,620,620,621,621,621,621,653,653,653,653,653,653,653,653,653,685,685,685,685,686,718,718,718,718,718,718,750,750,750,750,750,750,750,783,783,783,783,783,815,815,815,815,815,815,815,847,847,848,2896,880,880,2928,2928,2960,2960,5009,5009,5041,5040,5040,7089,7089,15377,40175,35885,10629,8581,10662,10662,10661,10661,10661,10662,10662,10629,10629,10629,10629,10630,10661,10662,10662,10662,10662,10694,10662,12710,12742,12742,12742,10694,10694,10694,10694,10661,10629,10661,10661,12742,12742,12742,12742,10694,12774,12774,10694,12774,12774,12806,12774,12741,6274,6241,6241,6241,6273,6241,4193,6273,4225,4193,4193,4193,4193,4193,10531,25255,27303,16837,12611,12643,27302,31528,25189,23077,25190,16804,6306,4225,4225,4225,4225,4257,4225,4193,4193,255},
{490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,588,588,620,620,620,621,621,621,621,653,653,653,653,653,653,653,685,685,685,685,685,685,686,686,718,718,718,718,718,750,750,718,718,750,750,750,783,783,783,783,783,783,815,815,815,815,815,847,847,848,848,2896,880,880,2928,2960,2960,2960,5008,5009,5041,5040,5040,7089,7089,27825,52656,31626,8549,10629,10629,10629,10629,10629,10629,10662,10662,10662,10662,10662,10662,10662,10662,10662,10662,10662,10661,10661,10661,10661,10661,10661,10629,10629,10662,10661,10694,10694,12742,12774,12774,12774,12774,12774,12774,12774,12774,12741,12742,10661,12742,12741,12741,12709,6306,6241,6241,6241,6273,6273,4193,4193,4193,4193,4193,4193,4193,4193,14756,31561,27303,16805,16869,25320,23142,12644,10531,10595,10563,8483,8450,8386,4225,4193,4225,6306,4225,4225,6305,255},
{490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,556,588,588,588,588,588,588,588,588,588,588,620,620,621,621,621,621,621,653,653,653,653,653,653,653,653,653,685,685,685,685,685,686,718,718,718,718,718,718,718,718,718,718,750,750,783,783,783,783,783,783,815,815,815,815,815,847,847,848,848,2896,2896,880,880,2960,2960,5008,2960,5040,5040,5040,5040,7089,9136,33968,44107,27368,8517,10629,10662,10662,10662,10661,10662,10662,10662,10662,10662,10662,10630,10629,10629,10629,10629,10661,10661,10662,10661,12742,10662,12742,12742,10694,12742,12742,12742,10694,10694,12742,10693,10693,12742,12742,12742,12742,12774,12742,12774,12774,12774,12806,12741,12741,6306,6241,6241,6241,6273,6273,4193,4225,6273,4225,6273,6273,6273,4225,14756,23143,25223,16837,25255,31528,27335,27367,27335,35721,35818,39946,33639,10466,4225,4225,4225,4225,4225,4225,6337,255},
{490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,556,588,588,588,588,588,588,588,588,588,588,620,620,621,621,621,621,621,653,653,653,653,653,653,653,653,653,653,685,685,685,686,718,718,718,718,718,718,718,718,718,718,718,750,750,783,783,783,783,783,815,815,815,815,815,815,815,847,847,848,2896,2928,880,2928,2960,2960,2960,2960,5008,5040,5040,5040,7089,25680,54803,37965,12677,10597,10629,10629,10629,10629,10629,10629,10662,10694,10662,10662,10662,10662,10662,10629,10662,10662,10629,10662,12774,10662,10661,10661,10661,10661,10662,10694,12742,10694,10693,12742,12774,12774,12774,12742,12774,12774,12774,12774,12742,12774,12742,12742,10661,10661,10661,6306,6241,6241,6241,6273,6273,4225,6273,4225,4193,4193,4193,4193,4193,14756,21094,25223,16869,21095,23143,21062,12644,16837,23142,21062,23142,23077,10466,4225,4225,4225,4225,6306,4225,6305,255},
{490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,556,588,588,588,588,588,588,588,588,588,588,588,620,621,621,621,621,621,653,653,653,653,653,653,653,653,653,653,685,685,685,686,718,718,718,718,718,718,750,718,718,750,750,750,750,783,783,783,783,783,783,815,815,815,815,815,847,847,848,848,2896,2928,4976,4976,5008,5008,2960,5008,2960,2960,5008,5008,9136,35982,44269,25417,14822,8549,10629,10630,10662,10662,10662,10662,10694,10694,10662,10661,10662,10629,10662,10629,10597,10662,10629,10662,10661,10661,12742,12742,12742,12742,12742,12742,12774,12742,10693,12742,10694,10693,12742,10693,10694,12742,12742,12774,12742,12774,12774,12774,12774,12742,12774,6306,6241,6241,6241,6273,6273,6273,6273,4225,4225,6273,6273,6273,4225,12644,23175,25255,16836,23077,25190,33641,35818,29448,25255,25255,23175,12611,4225,4225,4225,6305,6306,6305,6305,6305,255},
{490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,588,620,620,620,621,621,621,621,653,653,653,653,653,653,653,653,685,685,685,685,685,685,718,718,718,718,718,718,718,718,750,750,750,750,750,783,783,783,783,783,783,815,815,815,815,815,847,847,848,848,2896,2928,4976,2928,8973,25516,29872,29872,31952,34098,27858,27890,40175,35980,42286,33739,8549,8581,10630,10662,10630,10629,10661,10629,10662,10662,10629,10630,10662,10662,10694,10694,10662,10662,10662,10662,10629,10694,12742,10661,12709,12710,10661,10661,10693,12742,10694,12774,12774,12774,12774,12742,12774,12774,12774,12806,12774,12774,12774,12742,12774,12774,12741,6306,6241,6241,6241,6273,6273,6274,6273,4193,6273,6273,6273,6273,4193,14724,31593,27335,16804,8418,10563,20997,16740,12579,12578,14659,16804,8418,4225,4225,4225,4225,6305,6305,6338,6305,255},
{490,490,490,490,490,522,522,522,523,522,523,523,523,523,523,523,523,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,588,620,620,620,621,621,621,653,653,653,653,653,653,653,653,653,685,685,685,685,685,686,718,718,718,718,718,718,718,750,750,750,750,750,783,783,783,783,783,783,783,815,815,815,815,815,847,847,848,848,2896,2928,2928,2960,6861,27433,40143,44336,42224,40209,40177,44369,50543,52656,52624,37932,8549,8549,10630,10662,10662,10629,10662,10662,10662,10662,10662,10630,10662,10662,10662,10662,10662,10661,10662,10662,10661,12710,12742,12742,12742,12710,12742,12742,12774,12742,12742,12742,12742,10661,12742,12742,12742,12742,12742,12742,12742,12774,12774,12774,12774,14822,14854,10564,8451,8419,8386,8386,6306,6306,6273,4225,4193,4193,4193,4193,4193,16836,29447,25255,16804,29447,37833,27303,25287,23174,27400,27367,29512,16836,4225,4225,2145,4193,4193,4193,4225,4225,255},
{490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,523,523,555,555,555,555,556,588,588,588,588,588,588,588,588,588,588,620,620,620,620,621,621,653,653,653,653,653,653,653,653,653,653,685,685,685,685,686,718,718,718,718,718,718,750,750,750,750,750,750,783,783,783,783,783,783,783,815,815,815,815,815,847,847,848,848,2896,2928,2928,880,880,9104,13232,21552,38129,38129,40209,31724,37866,48398,50543,29514,8516,8581,10630,10630,10630,10629,10630,10629,10662,10662,10662,10662,10662,10662,12742,12742,12774,10694,10662,12710,12710,10694,10694,10662,10661,10661,10661,10661,10694,10694,10694,12774,12774,12774,12774,12742,12774,12806,12774,12774,12774,12774,12774,12774,12774,12774,12774,12774,12774,12741,12709,12741,12709,12741,12709,10628,12676,10596,10564,10531,6370,14757,21062,25255,16837,23175,23143,21030,16804,21030,27335,31495,31528,25190,6305,4225,4225,4225,4225,4225,4225,8385,255},
{490,490,490,490,522,490,522,522,522,523,523,523,523,523,523,523,523,523,555,555,555,555,555,588,588,588,588,588,588,588,588,588,588,620,620,620,620,621,621,653,653,653,653,653,653,653,653,653,653,685,685,685,685,686,718,718,718,718,718,718,718,750,750,750,750,750,751,783,783,783,783,783,783,815,815,815,815,815,815,848,848,848,2896,2928,880,880,2960,2928,2960,2960,5008,7056,11217,10988,25320,35818,42091,25288,10629,10694,10662,10662,10662,10629,10629,10662,10694,10694,10662,10662,10662,10662,10662,12742,10694,10661,10661,10661,10661,10694,10694,12742,10662,12742,12774,12742,12774,12774,10694,12774,12742,10694,12742,12742,12774,12774,12742,12742,12774,12774,12774,12806,12774,12774,14854,12806,12806,12774,12709,12741,12773,12773,12741,12709,12741,12741,14821,14789,10596,14757,23175,25255,16869,25287,25255,27400,23240,23143,23143,21063,21062,25222,10498,4193,4225,4225,4225,4193,4193,6305,255},
{490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,523,523,555,555,555,555,555,588,588,588,588,588,588,588,588,588,588,620,620,620,620,621,621,621,653,653,653,653,653,653,653,653,685,685,685,685,685,686,718,718,718,718,718,718,750,750,750,750,750,750,750,783,783,783,783,783,783,815,815,815,815,815,815,847,848,848,2896,2928,880,880,2928,2960,2960,2960,5008,5008,5008,5041,11151,19015,21030,16870,14757,14822,14822,14822,16902,14822,14822,12742,14822,12742,12742,12742,10662,10662,10694,10694,10694,10662,12710,12742,12742,10694,10662,10694,10661,10662,10662,10661,12742,10662,10661,12774,12774,12774,12774,12774,12806,12806,12806,12774,12742,12774,12742,12742,10661,12741,12774,12741,12773,12774,12773,14821,14822,14822,14821,14821,14854,14821,14822,14821,10596,23207,37899,25222,14724,12579,14724,29382,27334,20964,18884,23077,23110,23077,10466,4225,4225,4225,2145,2112,4225,4225,255},
{490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,555,556,588,588,588,588,588,588,588,588,588,620,620,620,620,621,621,621,653,653,653,653,653,653,653,653,653,685,685,685,685,685,718,718,718,718,718,718,750,750,750,750,750,750,750,783,783,783,783,783,815,815,815,815,815,815,815,848,848,2896,2896,2928,880,880,880,2928,2960,2960,5008,5008,5040,5041,7089,8713,8484,8484,10597,10597,10597,10597,10597,10564,10597,12677,12709,12709,14789,14790,14790,14822,14822,14822,14822,14822,12742,12774,12742,12774,12774,12742,10694,10694,10694,12774,12774,10662,10694,12742,12742,10694,12742,12742,12774,12742,12742,12742,12742,12742,12774,12806,12774,12774,14854,14854,14854,14822,14821,14821,14821,14821,14789,14789,14821,14789,12741,12709,12708,33673,35753,25190,14756,23207,31528,20997,12676,10596,12708,14756,16901,14723,4225,6305,6305,4225,4193,2112,6338,8451,255},
{490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,588,620,620,620,621,621,621,621,653,653,653,653,653,653,653,653,685,685,685,685,685,718,718,718,718,718,718,750,750,750,750,750,750,782,783,783,783,783,783,783,815,815,815,815,847,847,848,2896,2896,880,880,880,880,880,2928,2960,2960,5008,5008,5040,5040,5041,17392,40077,12677,8484,10597,10597,10629,10597,10597,10629,10629,12677,10629,10597,10597,10597,10597,10597,10597,12677,12677,12709,12709,12709,14789,14790,14822,14822,12773,14822,12774,12774,12774,12806,12806,12774,12774,10694,12774,12806,12774,12807,12774,12742,12774,12742,12774,12774,12774,12774,12741,14821,12773,14821,14822,14822,14854,14822,14821,14821,14821,14854,12741,12708,21030,21030,23110,16837,27335,29383,25222,25222,29415,33673,37801,42026,29350,6305,6305,4225,4225,4193,2145,6305,6273,255},
{490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,588,588,620,620,620,620,621,621,621,653,653,653,653,653,653,653,653,685,685,685,685,686,686,686,718,718,718,718,750,750,750,750,750,750,782,783,783,783,783,783,783,815,815,815,815,847,848,2896,2928,880,880,880,880,880,880,2928,2960,2960,2960,5008,5040,5040,7089,15312,35788,8451,10564,12645,10629,10629,10629,10597,10629,10629,10597,10597,8516,8517,10597,10597,10629,10597,10629,10597,10597,10597,10597,10597,10597,10597,10564,10564,12677,10564,10531,10531,10563,12644,12644,12709,12709,14789,12741,14822,12806,12774,12806,12774,12806,12806,12774,12806,12806,12774,14854,12773,14821,14821,14821,14821,14789,14789,10531,8418,8451,10531,10531,8418,6306,8418,8418,10531,12611,12579,8386,14692,18884,18852,14691,8385,6273,6273,4225,6305,4225,4225,8385,4193,255},
{490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,588,620,620,620,620,620,621,621,621,653,653,653,653,653,653,653,653,685,685,685,685,685,718,718,718,718,718,718,718,750,750,750,750,750,782,783,783,783,783,783,783,815,815,815,815,815,848,2896,2896,2896,880,880,880,880,880,880,2928,2960,5008,5008,5040,7088,7089,9136,27597,16903,10597,10597,10597,10629,10629,10597,10597,12677,10629,10629,8517,6404,6404,6404,6436,6404,8484,8484,8516,8516,8516,10597,10597,10597,10596,10597,10597,10564,8484,8419,8419,6371,6338,6338,6338,8386,8418,8418,10499,10531,12644,16836,18981,16901,16901,14821,14821,14821,14854,14822,14854,14854,14854,14854,14822,14822,8451,4225,4225,6306,4257,4225,2145,2145,2145,2113,2145,2112,32,2112,2113,6305,4225,4225,4225,4225,4193,12643,12611,10499,10498,4193,255},
{490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,620,620,620,620,620,621,621,621,621,653,653,653,653,653,653,653,653,685,685,685,685,685,718,718,718,718,718,718,718,750,750,750,750,750,750,783,783,783,783,783,783,815,815,815,815,848,848,2896,2896,2896,880,880,880,880,880,880,2960,2960,2960,5040,5040,7089,9038,23500,31854,27564,12678,8516,10597,10629,10629,10629,10629,12709,12677,10629,8517,6404,4324,4324,4324,4324,6404,6404,6404,6404,6404,6404,6436,6436,6404,8452,8484,8484,8516,8484,8484,10564,10564,8516,8484,8484,8483,8451,8451,6338,8418,16771,23044,23076,14691,10466,10466,10530,12579,12643,14691,14724,14756,14756,14789,14789,10531,6370,6338,6370,6338,6306,4257,4225,4225,2145,4193,2113,2112,2113,4225,6305,6273,4225,4225,4193,4225,8385,10466,12611,14659,8450,255},
{490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,556,588,588,588,588,588,588,588,588,588,620,588,620,620,620,621,621,621,621,653,653,653,653,653,653,653,653,685,685,685,685,685,718,718,718,718,718,718,718,750,750,750,750,750,750,783,783,783,783,783,783,815,815,815,815,848,848,848,848,2896,2928,880,880,880,880,2928,2960,2960,5008,5040,5040,7089,6892,27465,42191,38030,14855,10565,10629,10629,10630,10629,10629,12709,12677,12677,10597,6436,4324,4324,4324,4291,4324,4324,4324,4323,4291,4324,4324,6372,6371,6371,6404,6404,6436,6403,8451,8484,8484,8484,6403,8451,8484,8483,8484,8451,6338,12611,18851,18851,8418,6338,6338,6306,6306,6274,6306,6306,6306,6306,8386,8386,8418,8418,10498,10531,10531,12579,10499,8450,10531,6306,2145,2145,2145,6305,6337,6305,4225,4225,4193,2145,2145,2145,4225,8386,10498,8386,255},
{490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,588,620,620,620,621,621,621,621,653,653,653,653,653,653,653,653,653,653,685,685,685,685,718,718,718,718,718,718,718,718,750,750,750,750,782,783,783,783,783,783,783,815,815,815,847,847,848,848,2896,2896,2928,880,880,880,880,2928,2960,2960,2960,5008,5040,7088,5040,13199,19407,23535,14953,10565,10629,10630,10629,10629,10597,10629,12677,12709,10629,6436,4324,4324,4324,4291,4324,4324,4324,4324,4291,4324,4324,4258,4258,4258,4258,4258,4290,4291,6339,6371,6371,6403,6371,6403,8451,8451,8451,6371,6306,10498,8418,10466,4225,4193,4225,4225,4225,4225,4226,6306,6306,6306,4258,6306,6306,6306,4225,4257,6306,6306,6306,6305,10531,8418,2145,4225,4193,6305,6273,6305,4225,4225,4225,2145,2145,2145,4225,16771,12546,4225,255},
{490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,620,620,620,620,620,620,621,621,653,653,653,653,653,653,653,653,653,653,685,685,685,686,686,718,718,718,718,718,718,750,750,750,750,750,782,783,783,783,783,783,783,783,815,815,847,848,848,848,848,2896,880,880,880,880,880,2960,2960,2960,2960,5008,5040,5040,7088,7089,7089,7121,6795,8516,10597,10629,10629,10629,10597,12678,12677,12677,10597,6436,4324,4324,4356,4324,4324,4356,4356,4324,4291,4324,4323,4226,4226,4226,4226,4226,4226,4226,4226,4226,4226,4226,4226,4226,4258,4258,6338,6306,4225,12611,14691,12579,6306,2145,2145,2145,2145,2145,2145,2145,2145,2145,4193,4193,4193,4225,4225,4225,4225,4225,4225,4225,12644,10531,4193,4225,4193,4225,4225,4225,4225,4225,4225,4225,4225,4225,4257,6337,8386,6306,255},
{490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,556,588,588,588,588,588,588,588,588,588,620,620,620,620,621,621,621,653,653,653,653,653,653,653,653,653,685,685,685,685,686,686,718,718,718,718,718,718,718,750,750,750,750,750,783,783,783,783,783,783,815,815,815,847,847,848,848,848,2896,880,880,880,880,880,2928,2960,2960,2960,5008,5040,5040,7088,7089,7089,7121,6893,10532,10597,10597,10597,10597,10565,10629,10629,10629,10629,8517,4356,4356,4356,4324,4324,4356,4324,4324,4324,4324,4291,4258,6339,4258,4226,4226,4226,4226,4226,4226,4226,4226,4193,2146,2145,2145,2145,2145,4226,4225,4258,6306,4226,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2113,18981,27432,2145,4225,4225,6305,4225,4225,4225,4225,4225,4225,4225,4225,4225,4225,8450,6305,255},
{490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,588,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,621,653,653,653,653,653,653,653,653,653,653,685,685,685,685,685,686,718,718,718,718,718,750,750,750,750,750,782,783,783,783,783,783,783,815,815,815,847,847,848,848,848,880,880,880,880,880,880,2928,2960,2960,5008,5008,5041,5040,7088,7089,7089,7121,9104,10989,10955,10858,10793,10760,10662,10662,10629,10597,10597,10597,6404,4324,4324,4324,4324,4356,4356,6404,4324,4356,4291,6339,6403,4258,4258,4226,4226,4226,4226,4226,4226,4226,4226,4226,2145,2145,2145,2145,2146,2146,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,32,19013,44236,10595,4193,4225,4225,6273,4225,4225,4225,2145,4193,4225,4225,4225,4225,8418,10499,255},
{490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,588,620,620,620,620,620,620,620,621,621,653,653,653,653,653,653,653,653,685,685,685,685,685,686,718,718,718,718,718,750,750,750,750,750,750,783,783,783,783,783,783,815,815,815,847,847,848,848,848,880,880,880,880,880,880,2928,2960,5008,5008,5040,5040,5040,7088,7089,7089,7121,9169,9169,9201,9201,9201,11249,11216,13232,13199,13133,13004,12742,8516,4324,4324,4324,4356,4356,4356,4356,4323,4291,4258,6339,6339,4258,4258,4258,4226,4226,4226,4226,4226,4226,4226,4226,2145,2145,2145,4226,4226,4226,2145,4226,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,65,21094,52557,20996,2145,2145,4257,6305,6273,4225,4225,2145,4225,6305,6306,6305,4225,4257,14723,255},
{490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,523,523,555,555,555,555,555,588,588,588,588,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,653,653,653,653,653,653,653,653,685,685,685,685,685,686,718,718,718,718,718,750,750,750,750,750,750,783,783,783,783,783,783,815,815,815,848,847,848,848,2896,880,880,880,880,880,2928,2960,2960,2960,5008,5040,5040,5040,7088,7089,7089,9169,9169,9169,9169,9169,9169,9169,9201,9201,11249,11249,11151,4356,2145,4226,2178,4226,4226,4258,4259,4291,6371,6339,4226,4258,4259,4226,4226,4258,4226,4226,4226,4226,4226,4226,4226,4226,2145,4226,2145,4226,4226,4226,4226,4226,4226,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,65,23207,39947,8418,2145,4193,6305,6305,4225,4193,2145,4225,4225,6306,8386,6306,8418,8386,6305,255},
{490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,556,556,588,588,588,588,588,588,588,588,588,588,620,620,588,588,620,620,620,620,653,653,653,653,653,653,653,685,685,685,685,685,685,718,718,718,718,718,718,750,750,750,750,750,750,783,783,783,783,783,783,815,815,815,848,847,848,848,2896,848,880,880,880,880,2928,2960,2960,2960,2960,5008,5040,5040,7089,7089,7089,9137,9169,9169,9169,9169,9169,9169,9169,9168,11216,11216,11086,4291,2145,2145,2145,2145,2145,2145,2146,2145,6339,6338,19013,21224,16934,10596,4258,4258,4226,2146,2145,2145,2145,2145,2145,2146,4226,4194,2146,4226,4226,4226,4226,4226,4226,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2113,25287,50510,29447,2113,2113,4225,4225,4193,2145,4225,4225,4225,4225,4225,4225,4225,6305,6305,255},
{490,490,490,490,490,522,522,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,556,588,588,588,588,588,588,588,588,588,620,620,588,588,588,588,620,620,620,620,653,653,653,653,653,653,653,685,685,685,685,686,718,718,718,718,718,718,750,750,750,750,750,750,783,783,783,783,783,783,815,815,815,848,848,848,848,2896,848,880,880,880,880,880,2928,2960,2960,2960,5008,5040,5040,5041,7089,7089,9137,9169,9169,9169,9169,9169,9169,9169,9136,9136,11184,11021,4226,2145,2145,65,2113,2113,2113,2113,2113,4226,6338,41992,56816,50444,41960,21029,23142,21029,16901,14756,12644,10563,6371,6338,4258,4226,2178,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2113,27399,44172,25255,4193,32,2145,4225,4225,2145,4225,4225,4193,4225,4225,4225,6273,6305,6305,255},
{490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,588,620,620,588,588,588,588,588,620,620,652,653,653,653,653,653,653,653,685,685,685,685,685,686,718,718,718,718,750,750,750,750,750,750,750,783,783,783,783,783,815,815,815,847,848,848,848,848,2896,848,880,880,880,880,880,880,2960,2960,2960,5008,5040,5040,5041,7089,7089,7121,9169,9169,9169,9169,9169,9169,9168,9136,9136,11184,8778,2145,2145,2145,2145,97,2113,2113,2113,2113,2145,8451,44072,52491,52426,39847,27269,29382,29382,29414,29382,29414,29414,27334,25222,25221,23109,21061,16869,14756,12644,10563,8451,6338,4258,4226,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2145,2113,29512,52590,46220,6338,64,2145,4225,4225,4193,4225,4225,4193,4225,4225,2145,4193,4225,4225,255},
{490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,588,620,588,588,588,588,588,620,620,620,653,653,653,653,653,653,653,685,685,685,685,685,686,718,718,718,718,718,750,750,750,750,750,750,783,783,783,783,783,783,815,815,815,847,847,848,848,848,848,848,880,880,880,880,880,880,2960,2960,2960,2960,5040,5040,5040,7088,7089,9137,9169,9169,9169,9169,9169,9169,9168,9136,11184,11216,6665,2146,2146,2145,97,97,2145,2113,2113,4225,12676,21062,48265,50345,52458,35655,27302,27301,27301,29382,27301,29350,29414,29382,29382,27269,27301,29382,29382,27301,27301,27334,27302,25221,23109,23141,21029,16836,14723,12643,10531,6370,6338,4258,4226,2145,2145,2145,2113,2113,2113,2145,2145,2113,31624,44204,37834,8386,2145,4193,4225,4225,4193,4225,4225,2145,2145,4225,2145,4193,6273,4225,255},
{490,490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,588,588,588,588,588,588,620,620,621,653,653,653,653,653,653,653,685,685,685,685,685,718,718,718,718,718,718,750,750,750,750,750,783,783,783,783,783,783,815,815,815,815,847,848,848,848,848,848,848,880,880,880,880,880,880,2960,2960,2960,5008,5008,5040,7088,7089,7089,7089,9137,9169,9169,9169,9169,9168,9168,9136,9136,11216,6763,4259,4291,4291,4259,4259,2210,2178,2178,2146,12643,27302,46120,50345,54506,33542,31494,27302,27334,27302,27301,27301,27302,29382,29382,27269,27269,27301,29382,27301,27269,27302,27301,27301,27269,29381,29349,27269,25189,27269,27301,25221,23108,25189,23109,20996,16836,16804,14723,10563,8483,8450,6338,2177,16836,33576,25157,4225,4225,4225,4225,2145,2112,2113,4225,4225,2145,4193,6305,6305,4193,2145,255},
{490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,588,588,588,588,620,620,620,621,621,653,653,653,653,653,653,653,653,685,685,685,685,686,718,718,718,718,750,750,750,750,750,750,751,783,783,783,783,783,815,815,815,815,847,848,848,848,848,848,848,880,880,880,880,880,880,2960,2960,2960,5008,5008,7056,7088,7088,7089,9137,9169,9169,9169,9169,9168,9168,9168,9136,11184,11216,8876,2178,2178,2178,2178,2178,4258,4258,4259,4259,6371,12611,23044,27236,31429,29349,33542,33574,35654,33607,35655,31527,29446,31494,31462,27334,27269,27301,29382,27302,27269,27302,27301,27301,27269,27269,27301,27269,25189,25189,27269,27269,25189,25189,27237,27269,25156,27237,27237,25189,25157,25189,23076,27432,27400,10531,2145,4225,4193,4225,4225,2145,2112,2080,2113,4193,2145,4193,8386,6273,2113,2145,255},
{490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,556,556,588,588,588,588,588,588,588,588,588,588,588,620,620,620,620,621,653,653,653,653,653,653,653,653,685,685,685,685,685,686,718,718,718,718,718,718,750,750,750,750,783,783,783,783,783,783,815,815,815,815,847,847,848,848,848,848,848,848,880,880,880,880,880,2960,2960,2960,5008,5008,7056,7088,7088,7088,9169,9169,9169,9169,9168,9168,9168,11216,9136,11184,11216,10989,6339,6339,6371,6371,6339,4291,4258,4258,4226,6338,10531,12644,14692,14692,12579,12611,12611,16739,18851,20964,23076,27236,29349,31461,33542,33574,33606,33607,33574,31494,29414,29382,29382,27269,27302,27301,27269,25189,27269,27269,27269,25189,25189,25188,25189,25156,25188,25189,25189,25156,25156,23076,31560,27335,6338,4225,4225,2145,4225,2145,2113,2113,32,32,6273,10401,4225,6306,8386,2113,8418,255},
{490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,588,620,620,620,620,620,621,621,621,653,653,653,653,653,653,653,685,685,685,685,685,718,718,718,718,718,718,718,750,750,750,782,783,783,783,783,783,783,815,815,815,815,847,847,847,848,848,848,848,880,880,880,880,880,880,2960,2960,2960,5008,5008,7056,7088,7088,7089,9137,9169,9169,9169,9136,9168,9168,9168,9136,11184,11216,10956,8483,8483,8451,8451,6371,6371,6339,6339,4258,4226,6371,14724,14724,14756,12611,12611,12611,12611,12611,10531,10531,10531,10531,10531,12579,12611,16739,18851,20964,23044,27236,29317,31429,31462,33574,33574,33574,31494,31494,29382,29381,27269,25189,25189,27269,23108,25156,25189,25189,25156,25188,25189,25189,21029,8451,4193,4193,4225,4225,2145,2145,4193,2112,32,8353,10369,2145,10499,4225,2113,10498,255},
{490,490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,620,620,620,620,620,620,621,620,653,653,653,653,653,653,653,685,685,685,685,685,718,718,718,718,718,718,718,750,750,750,750,750,783,783,783,783,783,783,815,815,815,815,815,847,847,847,848,848,848,880,880,880,880,880,2928,2960,2960,2960,2960,5008,5008,7088,7088,7089,7089,9169,9169,9169,9169,9168,9168,9168,11216,11216,11216,13069,8419,6371,8419,8451,10531,10564,10564,10532,6403,4258,4258,12644,14724,14724,12611,12643,12611,12611,12611,12611,12611,12611,12611,12611,12611,10531,12579,10531,10531,10499,10499,10531,10531,10531,12579,14691,16771,18851,23043,25124,27236,29349,29381,31461,33542,31462,31494,31462,29381,25221,25189,25157,23108,21029,12611,4193,4193,4225,4225,4193,4193,2145,2145,2112,4193,4193,4225,12579,4193,2145,12578,255},
{490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,620,620,620,620,620,621,621,653,653,653,653,653,653,653,653,685,685,685,685,685,685,718,718,718,718,718,718,718,750,750,750,750,782,783,783,783,783,783,783,815,815,815,815,847,847,847,848,848,848,880,880,880,880,880,880,2960,2960,2960,5008,5008,5008,7088,7088,7089,7089,9137,9169,9169,9169,9169,9169,9168,11216,11216,11216,11086,10564,10531,10564,10532,8484,8483,8451,6371,25319,31690,27465,29513,27368,23175,14724,10531,10563,12643,12611,12611,12611,12611,10531,12579,12579,10531,12611,12611,12611,10531,10531,10531,12579,10531,10531,10531,10531,10498,8450,8451,10499,10498,10498,12546,14658,16771,20931,23076,27268,31461,35622,35654,35686,35654,16803,2145,2145,4225,4225,2145,4193,2145,2145,2112,2113,2145,4193,6306,4225,2113,12578,255},
{490,490,490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,556,588,588,588,588,588,588,588,588,588,620,620,620,620,620,621,653,653,653,653,653,653,653,653,653,685,685,685,685,685,686,718,718,718,718,718,718,750,750,750,750,750,782,783,783,783,783,783,783,815,815,815,815,815,815,815,847,848,848,848,880,880,880,880,880,2960,2960,2960,5008,5008,5040,7088,7089,7089,7089,9137,9169,9169,9169,9169,9169,9168,11216,11216,11216,11184,8550,6371,6371,6371,8451,8451,10532,10564,37866,50444,46219,46251,46284,46252,31625,23272,27432,27368,16869,25320,16901,16837,16901,12644,12676,12644,10563,10531,12579,10499,10531,10531,10531,10531,10531,10531,10531,10531,10531,10498,10499,10499,10498,10498,10498,10498,10499,8418,10466,10498,10498,12578,16771,20931,14690,2145,2145,4193,4225,2145,4193,2145,2145,2113,4193,2145,4225,6306,4193,2113,14691,255},
{490,490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,620,620,620,620,621,621,621,653,653,653,653,653,653,653,653,685,685,685,685,685,686,686,718,718,718,718,718,750,750,750,750,750,750,782,783,783,783,783,815,815,815,815,815,815,815,815,847,848,848,848,848,880,880,880,2960,2960,2960,2960,5008,5008,5008,7088,7088,7089,9137,9137,9169,9169,9169,9169,9169,9168,11216,11216,11216,11216,8647,8451,8484,8484,10564,10564,10564,10596,42026,52492,44171,39945,48364,33641,14789,23174,42091,23142,25287,37833,18981,31560,31560,18982,33705,23142,21062,27400,16837,18981,16869,12676,14756,12643,10563,10531,10531,10498,10498,10499,10498,10498,10498,10498,10499,10531,10531,10498,10499,10499,10498,10498,8450,12643,23174,6338,2145,4225,2145,2112,4225,4193,4257,2145,4225,2145,4225,8418,2145,4225,20963,255},
{490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,620,620,620,620,621,621,653,620,621,652,652,653,653,653,685,685,685,685,685,685,685,718,718,718,718,718,718,750,750,750,750,750,782,782,783,783,783,783,815,815,815,815,815,815,815,815,815,848,848,2896,2896,2928,880,880,2960,2960,2960,2960,5008,7056,7056,7088,7088,7089,7089,9137,9169,9169,9169,9169,9169,9168,11216,11216,11216,11248,8745,8419,8451,8451,8451,8484,8484,12676,44171,52525,44140,25222,29317,39913,40043,37963,33640,18949,35786,27335,19014,37866,23110,25255,37834,18981,31560,33640,18949,35785,27335,21062,37866,21062,27335,31528,18916,23175,18917,14724,16836,12611,10563,10531,10531,10498,10498,10498,10498,10531,10498,10499,10531,12579,12578,4225,2145,4193,2145,2145,4193,2112,23174,12644,6338,4225,8386,12611,6338,12676,37932,255},
{490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,588,588,588,588,588,588,588,588,620,620,620,620,620,621,621,621,653,652,652,652,653,653,653,653,685,685,685,685,685,685,686,718,718,718,718,718,750,750,750,750,750,782,782,783,783,783,783,815,815,815,815,815,815,815,815,815,848,848,848,2896,2928,2928,2928,2928,2960,2960,2960,5008,5008,7056,7088,7088,7088,7089,7088,9169,9169,9169,9169,9169,9168,11216,11216,11216,11248,10923,8419,8419,8451,8452,8484,8484,16869,48332,52558,33641,18885,8386,14691,31527,50543,25319,27432,40011,21094,29544,35753,18982,33705,29448,18982,37866,23174,21094,37866,20997,27367,37801,18949,35753,33575,25157,39946,27270,27302,37833,20997,29415,29383,18884,25255,16836,12643,14756,10531,10531,10531,10499,10498,4225,4225,2145,2145,2145,2145,2145,2112,29480,20964,6338,32,6306,12611,4193,27433,44174,255},
{490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,588,588,588,588,588,588,588,588,588,588,620,620,620,620,620,621,621,620,620,620,652,652,653,653,653,653,685,685,685,685,685,685,685,718,718,718,718,718,750,718,750,750,750,750,783,783,783,783,783,815,815,815,815,815,815,815,815,847,847,848,848,848,880,880,2928,2928,2960,2960,5008,5008,5008,5008,7088,7088,7088,7089,7088,9137,9169,9168,9169,9169,9168,9168,11216,11216,11249,11021,8419,8419,8452,8484,8484,8452,21062,50412,52558,31593,12612,8451,19046,21127,54704,29544,37963,46285,25319,46317,35818,25352,46350,27368,29512,42092,21094,31625,35753,18982,35785,29448,21030,39946,29318,27302,39913,25125,31527,37768,23077,35720,29382,20964,39913,25189,25189,37800,20964,25286,27302,14723,18949,6338,4225,2145,2145,2145,4193,2145,2112,29447,25157,10531,32,8386,14691,6305,42157,46222,255},
{490,490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,588,588,588,588,588,588,588,588,588,620,620,620,620,620,620,621,621,621,620,652,652,653,653,653,653,653,653,685,685,685,685,685,685,686,718,718,718,718,718,750,750,750,750,750,783,783,783,783,783,815,815,815,815,815,815,815,815,815,847,848,848,848,880,880,880,880,880,2960,4976,5008,5008,5008,7088,7088,7088,7088,9137,9137,9169,9169,9169,9169,9169,11216,11216,11248,11248,11151,8648,8582,8549,8517,8484,8451,27335,52525,50478,27368,21061,25287,37963,35915,52559,27399,42124,42124,27399,50478,35785,31625,52591,29512,40011,46318,25319,46317,37899,23239,39978,23110,18917,29383,20964,25190,31495,23012,33575,31463,23077,37833,27270,23077,39913,23077,27270,37768,20964,31527,31495,20996,20964,4225,4225,4193,4193,4225,2145,2145,2145,25222,23077,10498,32,8386,18884,20931,42124,48335,255},
{490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,555,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,588,620,620,620,620,621,621,621,620,620,620,652,653,653,653,653,653,685,685,685,685,685,686,718,718,718,718,718,718,718,750,750,750,750,782,783,783,783,783,815,815,815,815,815,815,815,815,815,847,848,848,848,880,880,880,880,2928,4976,4976,5008,5008,5008,7088,7088,7088,7088,7089,9137,9169,9169,9169,9169,9168,9200,11249,11248,11248,11248,13296,15279,15247,15182,13101,13003,33771,54605,46285,25288,10466,10499,23142,42123,48398,25319,46285,40011,29512,50511,31592,33705,50478,27399,42124,44205,27367,44171,31560,21062,23142,10564,8483,10532,8516,12612,12611,8418,18916,14691,14691,33608,25157,27334,39978,25125,29415,35688,20964,31560,31463,20964,16804,4225,4193,4225,4193,4225,2145,4193,4225,14691,20964,16738,64,8418,18884,27107,42124,48400,255},
{490,490,490,490,490,490,490,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,588,620,620,620,620,621,621,621,620,620,620,652,653,653,653,653,653,685,685,685,685,685,685,686,718,718,718,718,718,718,750,750,750,750,750,783,783,783,783,815,815,815,815,815,815,815,815,847,848,848,848,848,880,880,880,880,2960,4976,4976,5008,5008,5008,7088,7088,7088,7088,7088,9137,9169,9169,9169,9169,9168,9200,11249,11248,11248,11248,13264,13231,15279,15279,15312,17424,40142,54605,46285,21062,8418,10531,12676,42124,44205,25351,48398,35818,29544,52591,29512,35850,48398,25351,44204,39979,23174,35753,25255,16869,10532,6403,6371,6371,8451,6371,4226,2178,6338,4226,4258,14724,12611,25254,44171,21061,35785,39946,21029,37898,33576,18884,6305,4193,4193,4193,2145,2145,2145,6305,4225,4193,10465,22913,12546,8450,16836,27106,44173,48400,255},
{490,490,490,490,490,490,490,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,556,588,588,588,588,588,588,588,588,588,620,620,620,620,620,620,621,621,620,620,620,652,652,653,653,653,653,685,685,685,685,685,685,686,718,718,718,718,718,750,750,750,750,750,750,783,783,783,783,815,815,815,815,815,815,815,815,815,847,848,848,2896,880,880,880,880,4976,4976,4976,5008,5008,7056,7056,7088,7088,7088,7088,9137,9169,9169,9169,9169,9168,11248,11248,11248,11248,13296,13264,13231,15279,15279,15312,17424,44269,54605,37867,21094,8418,12676,10628,44237,42059,25351,50510,31625,31657,50510,27399,37963,46285,25351,44139,29415,14789,23142,14789,10564,6371,6403,6371,6371,6403,6339,4226,2145,4258,4226,4225,4258,4226,10531,27302,21061,40010,42059,21093,44204,35721,18981,4225,2112,4225,4225,2145,2112,2113,6273,4225,4225,4225,4193,4193,10531,16835,25026,44237,50481,255},
{490,490,490,490,490,490,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,556,556,588,588,588,588,588,588,588,588,588,588,588,620,620,620,620,621,621,620,620,620,652,652,653,653,653,653,685,685,685,685,685,685,686,718,718,718,718,718,750,750,750,750,750,750,783,783,783,783,815,815,815,815,815,815,815,815,815,847,847,848,2896,2896,2928,2928,2928,4976,4976,4976,5008,5008,5008,7056,7088,7088,7088,7088,9137,9169,9169,9169,9169,9168,11216,11249,11248,11248,13296,13264,15312,15312,15312,15344,19504,48397,52557,37899,16869,6338,12676,12709,48430,35818,27464,50510,29512,35818,48398,25351,42124,42124,25319,33640,14757,6403,6371,8452,6403,6371,8452,6371,6371,6403,6339,4258,4258,4291,4290,4258,4258,4225,4225,8419,14723,37898,42026,21093,46284,33673,21093,8450,4193,4225,4225,4193,2112,4193,6273,4225,4225,4225,4225,4193,10498,18819,25059,46349,50481,255},
{490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,556,556,555,588,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,620,620,620,652,653,653,653,653,685,685,685,685,685,685,685,718,718,718,718,718,718,750,750,750,750,750,783,783,783,815,815,815,815,815,815,815,815,815,815,847,848,848,848,2896,2896,2928,4976,4976,4976,4976,5008,5008,5008,7056,7056,7088,7088,7088,9137,9169,9168,9169,9169,9168,11248,11249,11248,11248,13296,13296,13264,15312,15344,15376,23600,50445,52558,37866,19013,19046,21191,16998,52623,33673,31624,50511,27432,37931,46317,25319,46285,37899,21094,21062,8516,6403,6371,6403,6371,6371,8484,6371,6371,6403,6339,6403,6403,6339,6403,6371,6339,4290,4226,6338,6371,27334,33607,21093,46219,35720,21029,14691,4225,4225,4225,4193,4193,6273,4225,4225,4225,4225,4225,4193,10530,16706,18786,44204,50513,255},
{490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,620,652,653,653,653,653,653,685,685,685,685,685,685,685,718,718,718,718,718,718,750,750,750,750,750,783,783,783,783,815,815,815,815,815,815,815,815,815,847,847,847,2896,2896,2896,2928,2928,4976,4976,4976,5008,5008,5008,7056,7056,7088,7088,7088,9137,9169,9169,9169,9169,9200,11248,11249,11248,11248,13296,13296,13296,15344,15344,15376,27727,52525,52558,33706,16804,14691,23142,23239,52623,29512,33737,50478,27399,42124,44172,25319,48365,33641,18982,18982,8484,6403,6371,8451,6371,6371,6436,6371,6403,8451,6339,6403,6403,6339,6403,6371,6339,6403,6371,6371,8451,10531,12579,10531,23109,20997,16804,10499,4225,4193,4225,2145,4225,6305,4225,4225,4225,4225,4225,4225,10498,18786,29122,42091,50480,255},
{490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,620,653,653,653,653,653,653,653,685,685,685,685,685,685,718,718,718,718,718,718,718,750,750,750,750,783,783,783,783,815,815,815,815,815,815,815,815,815,815,847,847,2896,2896,2896,2928,2928,4976,4976,4976,5008,5008,5008,5008,7088,7088,7088,7088,7089,9169,9168,9169,9168,9168,11216,11248,11248,11248,13296,13296,13296,15345,15377,15377,31887,52557,52558,33641,10499,8451,16934,40011,48364,25287,33673,44171,25286,44172,39947,27399,48364,25255,14757,12677,8484,6403,6371,6403,6371,6371,6403,6339,6371,8451,6339,6403,6403,6339,6403,6371,6338,6403,6371,6371,8483,6338,6371,6403,4258,6338,4225,6338,4225,4225,2145,2145,4225,4225,4225,4193,4225,4193,4193,4225,8418,18851,16738,40010,48334,255},
{490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,555,555,555,555,555,555,555,555,588,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,653,653,653,653,653,653,653,685,685,685,685,685,685,685,718,718,718,718,718,718,718,718,750,750,750,783,783,783,783,815,783,815,815,815,815,815,815,815,847,847,847,847,2896,2896,2928,2928,4976,4976,4976,5008,5008,5008,5008,7088,7088,7088,7088,7089,9168,9168,9169,9168,9168,11216,11216,11248,11248,13296,13296,13296,15345,15377,15344,36014,52525,50477,29481,10499,12611,40011,54638,46252,23174,33673,39946,21093,39978,31560,23174,42026,18949,10596,8451,6403,6371,6339,6403,6339,6371,6435,6339,6371,6403,6339,6403,6371,6338,6403,6371,6339,6403,6371,6371,8483,12676,12676,10596,12709,8483,4258,6338,4225,4225,2145,2145,4193,4225,6306,6338,6338,4225,4225,4225,10498,16771,14658,40044,50480,255},
{490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,555,555,587,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,653,653,653,653,653,653,653,653,685,685,685,685,685,685,718,718,718,718,718,718,718,718,750,750,750,783,783,783,783,783,815,815,815,815,815,815,815,815,847,847,847,848,2896,2896,2928,2928,4976,4976,4976,5008,5008,5008,5008,5008,7088,7088,7088,7088,9136,9168,9168,9168,11216,11216,11216,11216,13296,13296,13296,15344,15344,15376,15344,42190,52525,50477,29480,8386,21061,50477,52557,44204,23174,35753,37866,21093,39978,31560,23174,39978,16869,10564,8451,6339,6339,6339,6371,4290,6339,6403,6339,6371,6371,6339,6403,6371,6338,6403,6371,6339,8451,6339,6371,8483,18949,18949,16901,35785,18982,10563,12708,4257,2145,2113,2113,4225,4225,4225,6273,6305,6305,6305,8386,14658,16771,12578,31527,52560,255},
{490,490,490,490,490,490,522,522,522,522,523,523,523,523,523,523,523,523,523,555,555,555,555,555,555,587,588,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,653,653,653,653,653,653,653,653,685,685,685,685,685,685,718,718,718,718,718,718,718,718,750,750,750,783,783,783,783,783,783,783,815,815,815,815,815,815,815,847,847,848,847,2896,2928,2928,4976,4976,5008,5008,5008,5008,7056,7056,7088,7088,7088,7088,7088,9168,9169,9168,11216,11216,11216,11216,13296,13296,13296,15344,15344,15344,17424,44270,52524,48365,21062,8450,37866,52525,52558,44172,23206,35785,37866,21094,42091,29480,23206,42059,16869,8451,6371,6339,6339,6339,6339,6338,6339,6371,4290,6339,6339,4258,6371,6339,6338,6371,6338,6338,6403,6338,6371,8451,8451,10531,10564,23077,14756,10563,14756,6306,2145,4193,4225,4225,4225,4193,2145,4193,4193,2145,2113,6305,12578,10498,12578,35753,255},
{490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,555,555,555,555,555,555,555,555,555,555,588,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,652,653,653,653,653,653,653,685,685,685,685,685,685,686,718,718,718,718,718,718,718,750,750,750,750,783,783,783,783,783,783,783,815,815,815,815,815,815,815,847,847,847,847,2895,2928,2928,4976,2928,2928,5008,5008,5008,5008,7056,7088,7088,7088,7088,7088,9136,9168,9168,11216,11216,11248,11216,13296,13296,13296,15344,15344,15344,19472,48365,50444,48365,31625,25384,50509,54670,54670,42091,21126,37866,35786,21094,42091,29480,25287,44172,18981,8451,6339,6339,6339,6339,6339,6338,6339,6371,4290,6371,6339,6338,6371,4290,6338,6338,4290,4258,4226,4226,4226,4226,4258,6338,6338,4258,6338,4226,6306,4225,4225,4225,6273,4225,4225,4193,4193,4225,2145,2145,2112,2145,6305,10466,14690,31593,255},
{490,490,490,490,490,490,522,522,522,522,522,523,523,523,523,523,523,523,523,555,555,555,555,555,555,555,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,620,652,652,652,653,653,653,685,685,685,685,685,685,685,686,718,718,718,718,718,718,718,750,750,750,783,783,783,783,783,783,815,815,815,815,815,815,815,815,847,847,847,847,2896,2928,2928,2928,2927,4976,5008,5008,5008,5008,7056,7088,7088,7088,7088,7088,9136,9168,9168,11216,11216,11216,11216,13296,13296,13296,15344,15344,15345,23600,50412,50412,44172,25222,46283,46317,35721,44107,42091,21094,37898,35753,21126,44139,27399,25319,44172,21094,8516,6338,6339,6339,6339,6371,4290,6339,6371,6338,6338,6339,6338,6371,4290,6338,6371,4290,4290,4258,4226,4226,2145,4226,2145,2145,4226,2145,2145,4226,2145,2145,4225,4225,4225,4225,4225,6305,6305,6305,4225,2145,4257,6306,10465,31592,50577,255},
{490,490,490,490,490,490,522,522,522,522,522,522,523,523,523,523,523,523,555,555,555,555,555,555,555,555,556,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,620,652,652,652,653,653,653,685,685,685,685,685,685,718,718,718,718,718,718,718,750,750,750,750,783,783,783,783,783,783,783,815,815,815,815,815,815,815,847,847,847,847,2896,2896,2928,4976,2928,5008,5008,5008,5008,5008,7056,7088,7088,7088,7088,7088,7088,9168,9168,11216,11216,11216,11248,11248,13296,13296,15344,15344,13297,25647,50412,50380,44204,33673,50477,27368,6436,25352,42091,21126,39978,33705,23174,44139,27367,25319,44204,23206,14789,8451,6339,6339,6339,6371,6338,6338,6339,6338,6371,6371,6338,6371,6338,4290,6371,4258,4290,4258,4226,4226,2145,4258,2177,2145,4258,2145,2145,4226,2145,4225,6305,6273,4225,6305,6305,6305,6305,6305,4193,4225,8386,6338,10465,35785,56786,255},
{490,490,490,490,490,490,490,522,522,522,522,522,522,522,523,523,523,523,555,555,555,555,555,555,555,555,556,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,620,652,652,652,653,653,653,685,685,685,685,685,685,718,718,718,718,718,718,718,718,750,750,750,783,783,783,783,783,783,783,783,815,815,815,815,815,815,815,847,847,847,2896,2928,2928,4976,4976,5008,5008,5008,5008,5008,5008,7088,7088,7088,7088,7088,9168,9168,11216,11216,11216,11216,11216,11248,13296,13296,13297,15345,13297,31822,50411,48299,48430,50477,50477,16870,2243,29513,40011,23206,39946,31592,23174,44139,25287,27399,44172,23206,23207,16869,6403,6339,6338,6339,6338,6339,6371,6338,6338,6339,6338,6371,6338,6338,6371,4290,4290,4258,4226,4226,2145,4258,4193,2145,4226,2145,2145,4226,2145,4225,6305,4225,6305,8353,6305,6273,6273,6305,6305,8386,8386,6305,10465,35753,56786,255},
{490,490,490,490,490,490,490,522,522,522,522,522,522,522,523,523,523,555,555,555,555,555,555,555,555,555,555,588,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,652,652,652,653,653,653,685,685,685,685,685,685,685,686,718,718,718,718,718,718,750,750,750,783,783,783,783,783,783,783,783,815,815,815,815,815,815,815,847,847,847,2896,2896,2928,2928,4976,4976,5008,5008,5008,5008,7056,7088,7088,7088,7088,7088,9136,9136,9168,11216,11216,11216,11216,11248,13296,13296,13296,15345,15345,35950,50411,46187,44171,52590,50445,14789,4323,31625,39978,23174,39978,31560,23206,44171,25255,27399,42091,23206,31592,25287,8484,6339,6338,6338,6338,6339,6339,6338,6371,6339,4290,6371,4290,4290,6339,4290,6338,4290,4258,4226,2177,4258,2145,2145,4226,2145,2145,4226,2145,4225,6305,4225,6305,6305,6305,6273,8386,6337,6305,8386,8386,8418,10465,33705,56818,255},
{490,490,490,490,490,490,490,522,522,522,522,522,522,522,523,523,523,555,555,555,555,555,555,555,555,555,555,588,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,620,652,652,652,653,653,653,685,685,685,685,685,685,685,686,718,718,718,718,718,750,750,750,750,782,783,783,783,783,783,783,783,815,815,815,815,815,815,815,847,847,847,2896,2896,2928,2928,4976,2928,5008,5008,5008,5008,7056,7088,7088,7088,7088,7088,9136,9168,11216,11216,11216,11216,11216,11248,13296,13296,13296,15345,15344,40109,50411,46251,48364,52525,48365,12742,4355,31625,37898,23206,42059,29480,23206,44171,25254,29479,42059,23174,33705,29480,12676,8484,6339,6338,6339,6371,6339,6339,6371,6339,6338,6339,6338,4290,6371,4290,4290,6338,4290,4290,4290,4258,4226,4225,4226,2145,2177,4226,4225,4225,6306,6306,6305,6305,6305,6273,8386,8386,4225,6305,8417,8418,12545,35753,58898,255},
{490,490,490,490,490,490,490,522,522,522,522,522,522,522,522,523,523,523,523,555,555,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,652,652,652,653,653,653,653,653,685,685,685,685,685,718,718,718,718,718,718,718,750,750,750,782,782,783,783,783,783,783,783,815,815,815,815,815,815,815,847,847,847,847,2896,2928,2928,2928,2928,4976,5008,5008,5008,5008,7088,7088,7088,7088,7088,9136,9168,11216,11216,11216,11216,11216,13296,13296,13296,13296,15345,17392,44205,50412,50412,52558,52525,50445,40076,33803,42124,35753,23174,42059,29480,25286,44139,23206,29512,42059,21093,35785,33673,14789,16901,10564,6403,6339,6339,6339,6338,6371,6339,6338,6338,4290,4290,6371,4290,6338,4290,4290,4290,4290,4258,6338,4258,4258,4225,2177,4226,4225,4225,6305,6305,8385,6305,6305,6273,6273,4225,6305,6337,6305,6305,12546,31560,61011,255},
{490,490,490,490,490,490,522,522,522,522,522,522,522,522,523,523,523,555,555,555,555,555,555,555,555,555,555,588,588,588,588,588,588,588,588,588,620,620,620,620,620,620,620,620,652,652,652,652,653,653,653,685,685,685,685,685,685,718,718,718,718,718,718,718,750,750,782,782,782,782,783,783,783,783,783,815,815,815,815,815,815,815,847,847,847,847,2895,2896,2927,2927,2928,5008,5008,5008,5008,5008,7088,7088,7088,7088,7088,9136,9136,11216,11216,11216,11216,11216,11248,13296,13296,13296,15345,19472,46252,50412,50445,52525,50412,50412,52558,52590,52525,33705,21126,39978,25254,25222,42059,23174,31592,39979,16966,35785,35753,18949,27335,18982,14789,12677,6371,6339,6338,6371,6338,6338,6338,4290,6338,6371,4258,4290,4290,4290,4290,4290,4258,6338,4258,4258,4226,4225,4226,4225,6305,6305,6305,8385,6273,4225,4225,6273,4193,4225,4193,4193,6338,12545,29447,61044,255}
};

const uint16_t Denver [320][181] = {
{42684,48990,49022,51070,51070,51102,48925,36281,46844,48924,42489,38361,38296,36184,38264,40344,40344,42392,42424,42424,42424,42424,42424,42424,44504,44536,46584,48664,48664,50744,40213,29747,29747,35988,46389,19281,13007,12974,12974,10893,12941,8748,10861,23473,17134,10795,29713,27567,27567,25487,23342,27601,25586,25586,23505,25586,23440,21328,21327,27667,23505,10728,8615,10662,31826,38199,36085,27632,27600,25520,25519,25519,25520,21327,4487,229,27698,46682,31794,33874,31728,31564,31597,21293,36052,33939,15020,21294,33972,33939,33939,33939,33907,23343,23341,16937,10501,21065,10631,25323,14955,23210,21163,25323,16970,27436,31759,40179,31727,25454,21293,19213,14987,15084,17133,29780,23408,16938,18823,16743,16807,23081,40081,12745,10697,33874,27665,38330,42491,21295,10763,27633,42324,46550,46550,46517,44405,40147,38034,38098,40178,36083,19179,29679,46484,40017,29192,29127,31240,31240,31240,31207,31207,31207,31207,31207,31207,29127,29127,29127,29126,29127,29288,35822,38033,31727,31663,38000,46322,35692,42127,46484,44503,33939,2245,35952,40211,35920,29679,40311,255},
{44764,48990,49022,51070,51102,51102,48989,38361,46812,53052,44602,40409,38296,36184,38264,40344,40344,40376,42424,42424,42424,42424,42424,42424,44504,46584,48664,48696,50744,42358,36020,31828,27667,40116,44309,17201,13007,12974,17135,15021,12941,10860,12909,21392,15054,12940,29713,25454,29680,27567,25454,31858,31925,27699,19247,19280,19279,19279,19215,23473,21360,19148,14922,14888,25616,36118,36085,27600,27600,31794,29745,29681,23439,10858,2341,261,19245,44602,27633,31826,33873,29517,25324,14890,34003,33940,6504,21262,36020,36020,36020,36020,31827,23342,33808,8486,12549,14662,16904,19115,12680,23308,21098,29549,14792,31694,16969,27566,29647,23276,27599,19084,10599,10730,14924,19247,14956,21034,20936,21034,18920,18823,27306,38033,19116,38099,23310,34102,40443,19280,12875,35987,44404,38163,42356,46517,38098,40243,42291,40147,44404,36019,14857,27501,42323,44405,35694,31370,31273,31240,31208,31207,31207,31239,31207,31207,31207,31207,31207,31207,29127,29127,29126,37935,31499,27078,33678,42389,35887,29127,31271,33611,42390,19148,12744,42324,40178,33806,33938,46747,255},
{46910,49022,49022,51102,51102,51102,48989,40474,48892,55132,46682,40442,36216,36184,38296,40344,40344,40344,42424,42424,42456,42456,42424,42424,44504,46584,48664,50744,50744,38100,33940,31827,27667,42196,42228,17201,15087,12974,19248,15022,12941,10893,17102,27699,23441,15053,33906,27567,29712,29680,25486,29745,31957,25619,19247,19279,19247,19247,17134,27699,27699,27698,25553,19246,2438,23406,36052,27600,29680,42357,36051,33938,19212,2341,261,164,10792,33905,29549,31695,29550,21164,21098,16872,17067,21261,21164,25519,36084,36052,38100,38133,29714,27470,40081,14826,16775,8421,21130,14922,23212,19116,29517,23308,27404,27534,21098,23341,21195,27470,23373,27502,18985,14825,17035,14923,14858,21001,18888,18985,21033,20839,18823,44403,40147,35953,35954,27665,25716,17134,27568,38098,42291,21195,29646,44405,21195,10760,29712,42259,42291,29743,29711,38065,46484,42324,42357,46453,44308,44178,39887,35629,33418,31273,31240,31207,31207,31240,31240,31207,31207,31175,31337,40114,29257,27079,37969,42423,31467,25129,20936,29387,38164,6438,29646,42356,38065,29646,42488,50973,255},
{49022,49022,49054,51102,51102,51102,51037,40507,48924,55100,46682,42522,36184,36184,40344,40344,42392,42424,42424,42424,42456,42456,42424,42456,44504,46584,48664,50744,50744,36052,33908,33908,27699,44277,42228,17200,15120,13006,12974,12941,12941,15022,23440,31892,23537,12941,31826,29712,29712,29712,29680,27632,27699,25618,23473,23473,23441,21328,19247,36085,25553,19280,12941,12908,4454,19212,36052,35954,35986,42325,35986,29680,21260,6567,4422,2277,8613,25292,25161,25128,27143,27208,20967,10597,6535,10630,12742,8744,17197,19277,21390,25616,23407,33743,40113,29615,12744,21098,25389,14792,23243,21098,31695,19017,31695,19082,29614,12809,25389,27534,25389,42260,37969,29550,19050,23212,12744,18855,18791,18920,21001,18726,21033,33872,38098,35921,38066,33874,10762,25487,46485,40178,48564,46420,46451,44371,40113,33775,35986,42292,35954,12809,14921,42259,46517,36019,34003,46549,36018,33904,48630,46518,46453,44307,42097,37807,35564,33386,31240,31208,29191,29127,35693,40081,23243,25323,40245,38066,29257,27176,25161,33841,27567,4357,40243,40243,35952,27599,42488,38230,255},
{49022,49022,49055,51102,51102,51102,48989,44699,51037,55100,44602,40442,36184,34103,40377,40376,42424,42424,42424,42424,42456,42456,42424,44504,44504,46584,48664,50744,48664,35988,35988,36020,29779,48437,40148,15120,15087,13006,10893,10861,12973,15054,21360,27699,21360,10795,25553,12907,12907,12939,15053,12907,10827,17166,19279,15118,17199,17231,23440,38198,25586,15021,15021,17134,8649,2374,12972,35986,33873,38131,40212,31728,25454,14890,4423,4453,6534,17099,31532,37675,41835,37642,29321,16839,6372,2275,8645,261,196,4485,6597,4517,12810,37968,40081,38001,12777,23308,17035,21065,14889,29484,25453,25291,27501,23178,25420,14825,23341,23243,35954,52891,48532,48597,29582,33645,29387,27274,33516,20968,33483,20806,25227,23308,33840,33840,33873,29746,23343,23407,38066,40179,40276,42324,46517,44404,46484,48565,42259,42291,46517,35954,27566,44404,42324,44437,46518,48630,42260,38099,48630,38164,38164,48598,42357,44437,48598,46485,44275,42033,37742,33451,40049,35725,19017,29679,46584,37871,29160,29127,27144,38132,23310,23309,42356,38130,31727,36051,42521,25617,255},
{49022,49023,51103,51103,51102,53150,48989,44699,53117,55067,44602,40441,34103,34103,40376,40344,42392,42424,42424,42424,42456,42456,42424,44504,44504,46584,48664,50776,46551,33907,33907,35988,33908,50517,38036,13039,15087,15054,12974,12941,10893,10860,21360,21392,17166,10828,23473,12908,12908,10828,10828,10795,4554,10763,12876,6569,12941,8715,8649,33972,27699,10731,10763,8745,6567,10696,17004,36019,36019,31793,36084,36019,33939,27600,17068,10760,2308,4488,8683,16971,31499,37675,33514,27241,23113,10597,8645,260,196,196,4485,4485,17003,38001,27566,38000,21228,12744,6342,16937,12744,29582,14825,29582,19050,29581,14856,27469,17035,25324,33906,59327,50679,48499,42194,25193,47881,49994,48077,22918,44111,25161,35790,23146,35823,27371,33841,38067,38099,29680,42227,33905,27631,15050,17163,31824,27631,38163,42227,31499,37837,27404,33840,46517,40179,36052,44437,44405,36050,46550,48630,46550,48598,48630,40245,40244,48630,27599,40243,48663,44469,44405,40082,31272,29192,37969,46616,33516,27242,14759,27470,38132,27598,42357,40211,36018,25454,36084,38295,19246,255},
{49023,49023,51103,51103,51102,53182,48957,42619,53117,53020,44635,40442,34103,34071,40344,40344,40344,42424,42424,42424,42456,42424,42424,44504,44504,46584,48664,52824,44438,31827,33908,31860,38068,52565,33875,15055,17168,15054,12974,12941,12941,12909,19247,19247,15021,8747,17166,12908,12940,12908,10795,10828,4522,12909,17069,17101,15054,12942,4424,27633,25586,19215,17134,6567,6502,38066,46551,27633,25585,21327,19247,19246,19311,21392,21360,12874,2308,6569,6603,4523,6570,16906,29322,35594,25193,12805,6563,227,131,131,2340,6534,21196,40114,21261,35887,33840,8551,12648,12810,19018,21294,18985,19115,16905,23308,16904,27533,14825,23373,42359,50874,48597,48532,50678,33710,39756,50027,47881,43624,49896,37480,33351,45736,50189,33450,23113,37870,44306,42259,40179,31793,25518,8711,14985,27567,16969,31792,37871,31370,27242,27275,44339,46484,46517,48598,48630,44405,38099,46518,40244,31793,46518,44437,40276,48663,48663,44373,46517,46518,31825,38131,37969,29421,40051,48631,42227,31272,25193,14889,36084,29648,10662,42291,38098,33872,23374,48730,38167,23473,255},
{49023,51103,51103,51103,51102,53182,46844,42554,53117,51005,44634,40409,34071,34071,40344,40344,40344,42392,42424,42424,42456,42456,42456,44504,44504,46584,48696,52824,42326,29747,31827,31860,40116,52565,31795,13039,15087,12974,12974,10893,12973,12941,15054,17102,12876,8715,15053,12908,15086,15021,15053,12973,4522,15021,23376,19117,8747,12907,4359,21360,25586,15021,8747,6569,14955,27633,36117,19214,12844,19182,17102,10730,10730,10730,10730,10730,12809,8682,6603,6571,6571,4522,14761,31369,27241,18918,10660,2339,163,99,99,4357,27502,42162,29615,35888,40113,14825,16873,14729,23243,12842,23309,4358,25324,10696,27436,14921,25389,12842,50876,40180,35920,46550,63421,52856,56985,56887,54709,56693,54449,50256,52140,50157,52074,47914,43656,43688,44078,46484,40178,46485,38066,29614,29679,27566,23275,38099,35661,29517,25617,31825,46485,42291,35725,37870,40080,44371,48630,48630,48631,46518,48631,40212,29680,48630,33938,33970,48663,46582,46550,42259,33613,27501,23406,40244,29387,27242,27275,25227,40245,16937,25388,40211,33904,29678,36052,50876,50844,48763,255},
{51103,51103,51103,51103,51135,53182,46812,40474,53117,50940,40442,38296,34071,36183,40377,42392,42392,42392,42392,42424,42456,42456,42456,44504,44536,46616,50744,52824,38133,31827,31859,33908,42164,56725,31795,21393,17200,13006,12974,10861,12941,12941,19247,21295,19182,8747,12973,10762,8715,6602,8683,8715,4490,8747,21230,17004,8780,14986,4392,17102,25586,12941,12876,10796,19247,25553,23441,17069,12844,21295,17069,10763,10763,10731,10730,12843,21327,8682,4490,6570,6570,10666,12679,20837,14629,14597,6308,4389,4421,6470,12744,17003,33873,56886,48468,37968,38033,27470,12744,14890,19083,16937,16969,8454,21227,14792,25453,14824,29646,21165,52956,35987,33873,46584,61308,50711,38163,38195,48695,48760,50808,59195,54904,58935,47914,45898,54187,52269,52205,48174,48403,44372,42258,44404,42324,44340,40179,40179,31370,33547,31499,40081,42291,31402,29160,29192,29192,31337,33482,35692,39983,42226,44372,48630,50743,48663,44438,44405,48663,33939,31825,40147,23049,17031,10728,33743,29258,23341,17230,31827,33906,16871,33742,33807,29613,27566,48730,53020,57214,53021,255},
{51103,51103,51103,51103,53182,53182,46844,40442,51005,48827,40442,36184,34071,38264,42425,42392,42392,42392,42392,42424,42456,42456,44504,44504,44536,46616,50744,50744,36020,35988,35988,35988,46325,56725,27634,15088,15087,13006,12974,10861,15021,12909,23441,27601,21359,6667,12941,15021,17102,15053,15021,12941,2441,2407,19019,14956,12876,12842,10698,13006,8779,8714,15021,17069,12907,25553,21295,14989,12844,21328,14989,10730,10730,10762,14988,8649,12874,8649,8650,10730,14858,18888,20870,20838,20838,18790,16678,12647,16970,27502,23309,25421,33873,52726,59097,44339,37968,31727,4390,10632,8583,21130,8583,19018,10728,25324,12841,29484,21162,38067,50908,35954,38100,50842,59196,57050,29614,19082,31792,19114,31824,23372,38163,48728,44046,27242,33384,31271,39624,41640,43850,42032,29517,31629,33840,36018,38066,40049,31435,16904,21034,44339,40049,29160,29192,31273,31273,33353,31240,31240,31240,31305,31337,33515,35725,40015,44339,46517,48630,50744,42324,35791,21000,21455,21454,33613,29192,27209,19083,36051,33939,19051,29517,33579,27306,29679,46681,46649,55166,55166,255},
{51103,51103,51102,51103,53182,53182,48957,40474,50972,48795,40410,34136,34071,38264,42425,42424,42392,42392,42392,42424,42456,42456,44504,44504,46584,48664,50745,50744,36020,38068,38068,42197,46324,54677,25554,13039,15087,15055,12941,12909,15054,15022,17134,27633,25520,12909,17102,10828,10828,8715,6635,8715,6602,6602,10665,17069,25357,18921,18889,18954,16841,10567,10664,6502,261,8745,23440,17069,14957,21360,14956,19051,23212,31728,25422,19084,19084,23374,23342,21197,23081,20903,20870,18790,16709,16677,16710,8487,23245,27404,27535,19051,33776,40180,42358,38099,44372,25422,2246,6374,99,8519,132,18953,10469,25389,10566,29582,10599,40310,50843,33841,42358,52955,57149,61308,54872,42227,48534,35921,35856,29453,25420,31824,48533,33677,33579,37838,23080,35595,18887,39853,35888,29581,38099,50809,50711,35661,33612,18985,25486,48565,35726,29291,29258,29225,31241,31273,31273,31240,31272,31273,31273,33321,31240,31272,31305,31370,35628,37903,40211,31370,23080,2764,21261,33451,29193,23049,12876,31826,29843,23473,27633,42099,41836,37773,38066,48794,53053,55166,255},
{51103,51135,51102,53150,53183,53182,51070,42619,48892,46715,38361,34104,34071,38296,42457,42424,42392,42392,42392,42424,42424,42424,44504,44504,46584,48664,50745,52824,38101,33908,35988,42196,46324,54677,23474,13007,13039,15087,12973,12941,12941,12941,19248,29747,23472,17135,23572,21459,21459,21426,19314,19313,19216,8682,21164,23245,23212,14761,14728,21034,16841,12680,10632,261,4357,2342,19246,17069,19182,27633,29681,29582,33514,35986,31728,27567,27535,27567,27535,27534,35954,40180,38002,33809,31631,25357,27373,21132,19051,23146,29647,25422,40147,40245,44471,40114,46552,19148,4359,4293,6504,6374,2181,16744,14598,23244,12550,25325,10535,46617,46649,33905,48664,55068,57214,59228,61276,48695,48760,52857,59228,52824,54905,52824,50743,48338,35626,37935,37675,42193,31435,42096,42227,29517,27500,36017,42259,29355,33418,29192,37870,46452,33679,36184,33646,31403,33776,33484,31273,31273,31272,31272,31240,31273,33321,33353,33353,31273,31240,33548,42227,29420,25259,23244,31566,31370,25356,19148,23408,36051,29779,19214,40311,42392,42033,46030,35628,40276,55133,50908,255},
{51135,51135,51103,53150,53183,53183,53150,44699,46747,46715,40409,34104,34071,40377,42457,42424,42392,40344,40344,42424,42424,44504,44504,44504,46584,48664,50776,52824,38133,31827,33908,40116,46357,52597,19345,13007,15087,13006,12973,12941,12941,12941,25553,31892,19312,17167,19379,19379,19411,21491,19346,25751,23605,6569,21132,33810,21164,18889,14663,16809,14696,6309,4325,197,18953,23146,23310,19247,12875,10794,8714,10665,18888,33873,35922,29615,25454,25422,23341,21228,29712,44504,44471,42391,42358,42326,42358,35889,18953,16937,33808,27534,40179,42293,40212,40146,40212,12810,8552,2180,12810,6374,8552,18855,14792,25260,16776,23212,10665,50876,40310,25486,46583,57181,59295,57182,61308,42292,31695,38098,31824,33937,42454,40373,52921,57017,33677,21097,42096,23210,41966,29483,42130,35824,29516,31662,33775,31630,35823,31597,48565,42194,33581,33841,31370,33710,38262,35596,33646,33906,35564,35597,31501,33386,33385,33321,33353,31273,31272,40017,40049,23309,31858,52858,35694,29257,29288,31532,38165,23308,23340,38199,48763,42424,42391,59261,57019,44471,52987,40212,255},
{51135,51103,51103,53182,53182,53182,53182,44699,44667,44635,38329,34103,34071,42457,44505,42392,40312,40312,40344,42424,42456,44504,44504,44504,46584,48664,52825,52824,36053,33908,33908,38068,48405,48469,19313,13039,17200,13038,12973,15022,10861,10861,23440,27698,19280,12973,17265,25619,25619,19345,13104,17330,19346,6570,17003,27536,19182,29453,23050,23082,20969,25195,12744,8551,23146,23081,18953,12778,21263,17037,10730,10600,18953,33939,48664,44471,42358,42293,40213,38067,36019,36084,36116,38197,38229,40310,42390,38100,16873,14825,33775,29583,40146,40180,25453,31760,29647,6440,10600,67,12777,2213,12778,6374,16971,16841,21034,18954,25423,50843,21392,25487,52857,59229,59327,57214,48729,48696,50744,38163,50679,35920,40244,25421,35985,46518,41999,14726,31661,21000,29548,21065,27501,42227,23243,31662,36051,46551,42325,48564,46485,40147,25194,27112,31273,31337,33483,31305,33613,35888,33418,38067,33971,35531,25292,27372,33418,31403,33516,42260,31435,29291,38101,46553,31436,31273,22984,33776,40212,29583,33972,44569,48763,40278,42424,42455,48793,53020,50875,29582,255},
{51135,51103,53150,53183,53182,53182,53182,46844,46747,42587,36249,34103,34103,42457,44537,42392,38264,38264,40344,42424,42456,44504,44504,44504,46584,48697,52825,50776,36052,35988,35988,35988,42229,40181,17265,15088,15120,13006,10893,12973,12973,10861,21360,23473,19215,6634,10795,19149,25293,18987,2440,296,4490,10666,14890,17036,19214,25260,23049,25194,25227,29614,14954,29583,31599,27209,20904,10502,19117,19215,19247,19084,23309,27567,48664,48664,46584,46584,46616,46616,46552,27535,21260,21293,21293,23373,23374,25487,25260,16873,29582,33808,35953,38197,23375,21294,21196,2213,10600,2213,10632,2245,14858,101,14923,6309,25260,10600,33940,55069,33875,44472,44536,59261,59327,59263,46518,40146,40211,21162,42356,33872,40275,46518,40243,52889,42259,33580,29320,39821,21000,25193,16872,29386,18985,27404,27404,33840,25388,44403,46484,38034,23147,27275,31435,14695,29322,29257,25032,31273,33353,33483,33515,35498,25324,35759,35564,31858,38164,42292,31697,33647,48732,40180,33451,27535,19083,33906,38099,40212,40279,46683,46683,46682,44505,23342,25192,27467,29614,25420,255},
{53183,53151,55166,53183,53182,53182,53182,51037,48892,42554,36216,34103,36151,42457,44505,40312,38231,38264,40344,42424,44504,44504,44504,44504,46584,48697,52825,50712,31860,33908,33876,35988,40149,36021,17233,15088,15120,12974,10893,12974,12973,12909,15021,23473,12941,4521,4553,12875,23375,14858,2408,295,2376,14859,19084,8552,25390,23147,23049,27243,37904,27534,8648,33809,21067,25130,18856,14630,8389,2181,101,2214,19181,27600,42357,40277,42325,42390,44471,44503,46584,35954,25389,23341,21228,21228,19116,19115,25357,23179,29582,38066,29648,27698,19279,19214,12745,2148,6342,4294,8519,4424,16938,2278,17003,10470,25325,8520,46585,40311,36084,48763,44537,52889,59261,59327,55003,46452,40146,27436,27500,39919,21097,40081,23243,38130,25226,39722,25127,37772,37545,44176,29321,29419,33710,29582,27403,31760,40180,33808,33840,29582,25160,29353,27273,25161,31403,27275,16873,35597,23049,16742,33418,29225,31273,33386,33450,33613,42259,38066,29778,33874,46715,33678,33418,29550,29583,40244,38099,38132,38198,46747,46683,50909,38165,21099,27079,22951,20903,21130,255},
{53183,53183,53151,53183,53183,53182,53182,51037,48892,40506,34136,34071,36152,44537,44505,38264,38231,38264,40344,42424,44504,44504,44504,44504,46584,50745,52825,46551,31860,29747,29715,33908,33941,33941,15153,15120,15088,12974,10893,12973,12941,12941,19215,23473,19215,6634,4521,6569,12908,8681,327,263,2376,19181,17037,16776,33712,23115,21001,27340,35920,12938,6568,31729,16775,12615,10535,10503,8422,6309,6309,6277,21197,23373,35953,31695,29582,29614,29647,29679,31792,35954,40180,38067,33874,31761,29616,25487,27502,25259,27437,40279,29747,19181,38034,31663,14826,6342,4229,8520,4261,8584,12712,6535,14825,14695,23212,14859,55036,44504,34004,46682,46650,44503,59228,59327,59294,48566,42259,37968,21097,41803,22983,37772,20937,29516,29289,23210,37806,20935,43981,27240,43851,35530,37740,40082,29549,25388,29809,44471,36084,40213,23309,27500,14823,23308,29550,31566,27275,31403,25129,25129,33516,16808,21002,33484,18856,25194,40147,31338,27178,27601,40310,33516,31306,31338,40083,38131,33840,38133,36085,46715,48796,44602,33907,20936,27144,27177,20968,21193,255},
{53183,53183,53151,53183,53150,53182,53182,51005,48892,38394,34104,34071,36184,44569,42457,38231,38231,38264,40344,42424,44504,44504,44504,44504,46616,50745,52825,44439,31860,29747,31828,42229,33941,33909,15153,15088,13007,12974,12941,12941,12941,12941,12941,17199,19312,8715,8682,6569,6602,8682,2408,231,2376,12907,10731,18857,33711,21034,21001,29453,17066,229,12874,23278,8357,6374,4326,8520,8520,6375,6407,10600,27568,27502,35954,33808,27501,27469,27469,27469,27469,31695,46584,48664,46584,46552,44471,42391,42294,27372,25259,38100,38198,23375,44274,37936,12810,10632,4261,10665,4260,10665,10535,10696,18985,21067,21034,29616,50875,34069,36151,42424,48763,44504,52955,59262,61375,54971,55003,48598,29582,31629,37806,21033,37838,20967,35627,18984,35562,29191,39917,27144,35854,31467,23178,48500,38034,25291,27436,31727,23275,36050,36019,33841,25389,16969,31793,29680,21229,27536,23277,18986,23082,27209,27242,27209,20937,29583,38002,12582,10599,19083,33774,35661,38166,42294,44471,35987,29615,31826,40311,48796,48796,42424,25390,23016,21131,25391,14728,21095,255},
{53215,53183,53150,53183,53150,53182,53182,48925,46812,36281,32023,32023,36216,42457,40377,36183,38264,38232,40344,42424,44504,44504,44504,44536,48665,50745,52825,38165,31828,31827,33876,44309,44309,38069,15120,17168,15087,13006,12973,12941,10861,12941,15022,19247,17101,6634,6634,10795,10828,8715,2408,327,2408,23310,8585,25196,33679,21002,18921,25259,27502,17035,12874,16874,10535,6374,4294,6374,6407,6407,4294,10632,27568,23341,38067,46453,40114,38001,35888,33775,31695,31662,44438,48664,48664,46616,46584,44536,44504,35824,25194,33775,38033,25422,44340,33840,8616,12680,6374,10633,35,12680,8552,19116,4358,19084,21098,42326,52956,31858,38264,31924,46683,48731,44570,42423,59294,59295,59294,52857,57018,48598,42292,33840,46388,29485,37968,33613,23177,37740,20935,39821,27176,33482,18855,37707,42162,31663,27436,29549,29549,25356,25323,23307,38098,16905,25454,27535,25390,29713,29681,19084,12842,19050,14857,6470,8485,19147,25356,25162,14826,40179,35661,33548,35921,37969,40245,42391,36086,25487,42489,48796,42392,31859,21033,29191,27241,21131,8518,29580,255},
{53215,53183,53183,53183,53150,53182,55230,46844,44699,36249,32023,34071,38264,40409,38296,36151,38264,38264,40344,42424,44504,44504,44504,46584,48665,50777,50777,36021,35988,35988,33908,35989,50518,35988,15120,19281,17168,12974,15087,15054,10861,10861,19313,31924,25488,6634,6633,10794,6634,6634,2440,327,328,27600,10665,27309,29486,16970,17068,27535,29646,10825,8616,16907,14827,4261,6374,6374,8519,6375,4262,12681,25422,25389,35987,52857,50744,48664,48632,48632,48599,48599,40179,33873,35986,36051,36083,38164,40278,38035,25226,31598,42194,27502,42391,29680,6471,10535,6439,12680,3,10600,8585,21229,100,19084,16906,48730,57182,40245,48697,31859,44537,48796,42457,42358,59262,59327,59359,55035,57115,55002,40180,38066,38131,31793,38099,35986,35985,42195,27469,40114,25292,29581,31435,21097,46387,40147,25291,18985,29646,35954,27502,31663,27502,25358,19115,21228,29648,38133,27601,21229,17003,16970,19082,10697,2342,4390,8648,19083,19116,33808,33581,27340,27210,40114,38131,44570,42490,25553,42424,42392,44602,27568,22983,29191,27111,25161,27404,31758,255},
{53215,53183,53183,53183,53182,53182,55230,46812,42586,34168,32023,34104,38297,40409,38264,36183,38264,38264,42392,42424,44504,44504,44536,46584,48697,50777,50777,36053,33908,35988,38068,40149,54646,31828,15120,17233,15087,15054,15086,12974,12941,10861,15086,25650,15021,6634,4553,6601,4521,4521,2440,4456,6569,23375,25390,31534,27373,14890,12907,25520,25454,6534,2342,8455,8422,6407,8486,8519,8519,8487,6374,16939,25455,33776,40147,48696,50777,48631,48664,48664,48664,48696,42292,27469,27469,27469,23308,23276,21228,25422,27340,27372,35888,27567,35986,25422,4327,4293,6471,12615,2148,8487,8617,17004,4359,19084,12778,55069,44536,42423,50810,29714,36117,48796,44537,48729,59262,59295,55166,57213,52889,59228,48696,52922,54970,44438,50745,40213,40179,38131,31792,36018,31792,33905,35953,27599,42226,44340,37970,42163,25356,25388,23275,31825,16937,29647,25356,23275,35987,40278,27634,10762,21228,14923,17002,19050,10729,12842,6535,6503,27598,37903,31403,27405,31729,42293,31761,42456,44504,31859,40311,42424,38198,23179,27144,27242,23080,31661,42225,8583,255},
{53215,53215,53183,53183,53182,53182,55230,48925,42587,34168,32023,36184,40409,40409,38264,36183,38264,38264,42424,42456,44504,44536,44536,46584,48697,50777,50777,38133,29780,25587,31860,42229,54646,29780,15153,15120,15087,13006,12973,15054,15054,12941,12941,12973,19214,6634,6634,6601,8714,10795,2407,21261,29680,38100,38068,29454,27405,14922,12908,27632,27567,12874,2407,8618,8422,8487,8455,10665,6406,8487,8520,23277,19082,31727,38066,42390,42391,42391,44471,44471,44471,46551,44438,33841,31695,29614,27469,23341,21228,21196,31533,29452,23211,23407,27567,17036,6407,2181,8584,4228,6374,4293,10730,10632,8585,16939,25423,57214,42424,36052,55069,44440,40278,48828,46683,40278,59293,59295,55101,59327,55002,57115,55035,46615,59228,46616,55035,48696,50842,52858,46518,52858,40212,44373,38067,31760,35953,29711,44437,44535,48567,38067,40115,35921,35921,27502,42323,23274,29745,29680,25487,8552,14922,19148,14922,19083,16938,6567,6535,6502,6534,16904,27469,29452,40115,38035,31729,40312,38264,25552,40311,46650,31762,20936,27339,29746,25356,33869,19145,8646,255},
{53215,53215,53183,53183,53183,53182,55230,51037,40474,34136,32023,38264,42490,42457,38264,38232,40312,40312,42424,42456,44504,44536,44536,46584,48697,52825,50745,36085,31860,25619,25619,40149,56726,29748,15120,19313,15087,12974,12941,12941,12973,15022,17200,15022,19247,6602,8714,4521,6633,8682,2440,23407,25520,38132,35987,21229,25293,14890,12908,29713,25454,4551,2374,14826,10503,6439,10567,10665,4261,2245,2214,19149,21163,27468,40146,38165,29811,25553,27634,27666,29746,29779,29779,29714,29746,31794,31794,31794,31793,27567,29550,19017,8646,4453,17099,6536,6407,2181,10665,3,8519,100,12713,4294,12810,12713,38133,50875,31891,50778,48762,59294,57149,48763,46683,44505,55035,61407,57181,59327,55100,50809,59229,46616,40342,42423,48729,48761,44503,55068,44503,52922,46583,50809,48664,44503,52857,40180,48599,40245,52922,42325,52922,44470,44438,44439,42358,29583,21162,29680,31728,27503,6503,19148,17035,14923,12809,4422,4422,4422,6503,16937,21163,46485,44503,33712,33907,44570,27700,15053,42457,40279,25358,25063,29192,27177,27404,31789,10790,15016,255},
{53215,53215,53183,53183,53183,53182,55230,53117,38362,34104,31991,40345,46650,42457,38264,38232,40344,40312,42424,42456,44504,46585,46585,46617,48697,52825,52825,36085,31860,27667,29780,46357,58806,27668,15153,21394,15087,13006,12941,10861,12941,15054,12974,21328,19214,10795,21197,10795,6633,4520,2408,19214,17069,29746,31892,21262,23147,18889,16841,29615,12873,2405,293,19018,10535,6374,8519,8519,100,133,133,14955,21229,25388,40178,38166,31892,29779,29714,27634,27633,27601,25488,21262,21262,21262,21295,23375,23408,27666,23277,12712,8743,4517,10825,4423,6406,4293,10632,3,10599,35,14793,36,16939,6439,46584,55068,38132,52923,38133,50874,57182,46683,46682,46650,48729,52988,46617,59326,50875,42423,48794,46616,40180,40277,42358,31825,42390,34003,40277,44535,42455,44503,50874,42389,50842,44470,48696,44470,44503,52889,48696,50777,48696,50810,38164,44438,21130,19147,29713,29713,14858,16971,21261,17003,12842,12777,6503,4422,12842,17003,19083,33970,33873,29615,38198,48796,38134,33973,50909,38199,23049,27111,29159,27370,25515,21321,12934,15048,255},
{53215,53183,53183,53183,53183,53150,55230,53117,38361,32023,31991,42457,48730,44537,38264,38232,40344,40344,42424,42456,44536,46585,46585,46617,50745,50777,52857,38166,27700,27667,35989,50518,56758,23507,15153,21394,15087,15054,12974,12974,15054,15086,12941,19280,27698,17134,25422,19181,10762,8682,6601,21360,17101,21360,29779,27568,23115,18921,21002,27534,6567,4486,229,12712,8519,6406,8519,8454,68,133,133,19117,17069,19116,27567,36085,31892,31860,31860,31827,31827,31827,27633,23407,23407,23375,23375,23375,23407,27601,19019,16970,6631,4549,325,228,196,8647,10599,6342,14889,6501,21131,6439,19084,2278,42390,55069,42391,52923,31793,36116,59294,50811,48763,48796,44504,48763,42424,57181,50843,44504,36018,38098,33970,21390,40277,36019,40309,40245,38197,42326,31826,29778,27632,34003,36116,38164,42390,46616,40244,50809,38164,40309,42422,42455,46584,36018,27274,22983,27502,33874,33842,38101,25423,19084,14923,21163,19116,12874,12874,10793,4519,12841,23243,31794,44570,44635,38166,44569,46748,31730,22983,27438,27501,23337,17192,19272,17160,10854,255},
{53215,53151,53183,53183,53182,51037,55230,51037,36281,32023,31991,44537,52858,46585,38264,38232,40376,40344,42424,42457,44537,46585,46585,48665,50777,50777,52857,42359,31828,31860,40149,50518,52630,21427,15120,27634,15119,13006,12942,12941,17135,12974,17167,19247,19279,19182,21229,19116,19149,19181,21229,25586,19182,19084,27633,38101,21034,18921,20969,23276,8647,4454,23081,12615,8552,6374,8519,6341,6245,10470,10502,31696,21229,19116,21197,36086,33940,33940,33941,33941,33941,31892,29714,25521,25520,25520,25488,23407,23408,25520,16873,12679,10760,324,228,4389,260,2373,12839,19145,17130,15082,23406,19214,25519,19182,25585,59261,52923,50810,27568,27633,57213,61375,52989,48764,48796,48828,42425,48762,52956,52891,46485,42292,42292,21194,25323,33614,25389,33711,27371,35986,25389,29616,27536,23342,27536,23407,25520,23406,33971,42390,38164,25519,29777,38197,50875,38100,25258,18821,27469,31761,31760,38230,23441,19149,17035,17003,23276,12874,4487,4487,2374,12874,31729,46651,48796,38198,36117,42456,42457,25260,27112,27339,29580,15016,8741,15079,17192,12967,255},
{53215,53151,53183,53183,53150,48892,55230,51005,36249,32023,31991,48698,57018,48665,38264,38264,42425,42425,42425,44505,44537,46617,46617,48697,50777,50777,52857,42359,33908,36021,40181,50518,50550,19379,15120,25522,15087,12974,15054,12941,15054,15022,15022,17167,15020,19181,29648,33809,29648,27535,29583,25553,19149,27405,33807,35921,21002,21002,20937,21066,19180,4454,33580,14630,20968,18888,18888,16743,18823,16775,14663,35954,38100,21196,21230,36118,33941,33973,33973,31892,31893,31893,27666,27633,27633,27601,27601,27601,27569,25455,21031,21033,12871,292,2276,10760,260,227,8677,17128,15114,17098,14987,8713,19212,10794,12843,44568,59230,44472,25455,23408,46681,61407,59295,48796,44537,48796,46683,40311,52955,55068,54971,44372,46550,38034,19050,40213,25391,29615,33645,16872,35628,37676,31533,23081,33775,23147,33776,29615,27632,33906,21130,21130,25356,33906,38229,40278,21229,8485,25388,33873,31760,38132,23407,10729,21229,17003,19116,21163,8648,2406,2309,14987,34037,46682,40409,15054,29778,40279,38134,25097,29192,31272,29482,17160,17128,10886,15047,10854,255},
{53215,53151,55231,53183,53182,48892,55230,51005,36249,31991,32023,52858,57018,50745,38264,38264,42457,42425,42457,44505,44537,46617,46617,48697,50777,52857,52857,40246,33941,33973,44310,52598,48470,19379,15120,17200,15087,12974,15054,15054,17134,15021,17134,21295,12908,19182,31793,44438,44470,44438,33645,14727,27242,29419,31564,29419,18856,27242,29322,27275,25291,18984,31500,16743,25129,27209,25129,25129,25129,23081,20968,31696,44504,27535,25455,33973,31860,31892,31892,31892,31893,31860,27601,25553,27601,27601,27601,27601,27601,21229,16903,21033,27535,12906,2437,2373,163,227,10790,12935,6726,17066,19245,10793,10760,8583,6504,27698,59262,38133,29681,31892,31924,61375,61407,50908,50778,50908,48763,42457,48762,59262,61375,48566,44438,46584,23309,33710,33580,21098,37904,12614,27469,27210,23244,27275,12646,33483,35563,31565,31370,33678,23114,23178,25389,31727,27469,23276,19018,19050,31726,19146,25485,33970,29713,4391,17003,21197,17003,23276,21163,8648,10696,8680,19310,40310,42425,27602,38198,44570,27471,25096,25390,27307,25451,12967,17160,12967,12967,6661,255},
{55263,53183,55231,53183,53182,53085,55198,48892,36217,31992,34104,52890,57018,48665,38297,40345,44538,42489,42489,44569,46649,46649,46649,50777,50809,52858,52857,38134,33974,31893,42294,48471,48503,19379,15120,17200,15087,15086,17167,15022,19248,17134,15086,19247,19182,19117,31793,44438,44471,42358,33612,12550,25096,27209,27209,27209,12582,25161,29354,27241,27209,27241,27209,14662,18855,23081,23048,23016,20968,20936,18855,23244,40311,23342,25520,31827,29714,29715,29714,29714,29714,27666,29747,29714,27634,27633,27601,27601,27569,17003,14759,23147,29844,8713,4485,196,132,163,10758,4452,259,19147,21327,17099,19147,21196,6472,17069,50875,33907,31794,27633,14923,55068,55102,44570,61407,52988,48763,42392,50810,61407,63487,54970,42259,33841,23309,16937,42032,27144,35693,37578,37708,35694,12679,33710,14727,21131,23049,19050,33547,21130,29517,21065,25421,31858,40277,31794,38132,29615,33906,19081,14887,21292,29712,12778,10730,23374,19116,19116,25356,17003,14955,8744,15084,27698,42424,44570,44570,42425,23082,27176,27307,29484,21289,12903,10855,8741,8710,4485,255},
{53215,55263,55263,53183,53182,53053,57245,44731,36249,32089,34137,52824,42357,38132,33939,33906,36019,33971,36019,38132,38164,40244,40277,42357,44438,46518,46550,36020,31860,31860,40181,44310,46422,21427,17168,25489,17199,15054,15054,12941,12941,21361,21327,25489,17134,19182,27601,31891,34004,34004,33645,16775,27209,27241,29289,31369,18823,25161,31402,29322,29322,29322,27242,16775,14695,23049,20968,20968,20968,20969,18888,16840,21196,23277,29746,31827,29747,29747,29714,29714,27666,29714,31860,31860,31860,31860,31860,31859,31827,19019,16776,21066,21295,14858,4422,2309,163,130,8615,19209,4548,19116,23406,15019,10793,21293,8583,12809,29842,33874,31827,21360,10697,40343,50876,50875,53021,46683,48828,46650,55068,61375,61439,61342,46485,42292,40212,16970,29582,27340,14890,42032,35595,33743,20871,23146,29323,25096,27307,10534,25259,8485,25389,29485,21097,21163,29679,16905,29745,29745,17099,29614,16935,19114,25422,27600,23409,17069,23374,19116,21228,25357,14922,12906,21392,12939,36117,46683,44570,31762,25064,29191,31272,33579,46418,29743,17130,12904,12936,8710,255},
{55263,55263,55263,53182,53182,52988,57245,46812,34136,29746,33807,33740,31563,31595,31563,29483,31563,29515,29483,31596,31596,31596,31628,31596,31628,31661,31628,31596,31596,31629,33677,31597,31597,31597,29517,29517,31598,29485,29517,29518,27437,31663,33744,31663,29583,33776,27535,25422,25423,27503,37773,20935,27209,29289,29289,29321,18887,20968,27209,29289,27241,25129,25129,18888,14695,18920,18856,16808,16808,16775,14727,14695,18953,33841,33972,29779,29747,29747,29747,29746,29714,29747,31892,31860,31860,31860,31860,31860,29779,16874,14727,14825,21197,27503,14891,10663,12711,6532,8678,15080,12871,25423,23373,12905,8647,8615,10663,19083,17035,38164,37937,29518,40050,40181,46683,55133,52989,36150,42456,48731,44536,50908,57149,63487,52825,44372,44471,31793,19115,37905,20969,31662,25194,19083,35759,12712,33613,29322,29549,20871,16872,25162,27209,35758,23146,23211,25356,29517,25356,23178,21065,25388,31693,16936,25454,19147,27634,12876,21261,23309,19116,25389,23276,10760,6632,4519,19311,44602,42457,25228,27209,29648,31501,39982,46451,31891,19246,21357,10823,4517,255},
{55263,55263,55263,55230,51037,50907,55165,44633,33774,33643,37869,37869,33676,31628,31628,31564,33677,31628,31596,33709,33709,33676,33709,33677,33676,33709,33709,33677,33709,33709,33709,33709,27403,33644,31564,31564,33677,31532,31564,35725,31564,33645,35725,31564,33645,35758,33645,33645,35790,35758,33677,35757,35725,33645,37805,35725,33580,35660,35692,37773,35692,35660,31467,27274,20968,23081,20968,18856,16775,14663,12582,10502,14695,38034,33972,29779,29779,29779,29747,29746,29714,31827,31892,31860,31860,31892,31892,31860,33907,21002,12614,4423,19116,31697,16938,16905,12775,10790,8645,8709,17033,23341,17099,12840,8615,14857,17003,25422,19116,17068,19147,25550,48762,52923,57214,59295,40408,29811,36084,50876,50909,42457,50810,63487,59229,46453,38066,33808,16937,33678,50517,52760,44341,29615,40115,29388,29485,27340,14857,33678,10566,27339,23113,27437,27340,21065,29680,40310,42326,38165,38067,29615,33874,12744,19148,31793,23405,23310,4358,19148,23309,23277,29550,17002,10760,10860,12940,25649,27633,27177,27176,29518,31598,48531,42324,29810,17131,21356,8743,6630,255},
{55263,55263,55231,55231,44667,52988,53085,31857,29614,29614,29581,35822,35757,33676,33741,33709,35757,33741,35757,35789,35822,35757,35789,35790,33709,35789,35790,35790,35822,35822,35790,35790,29484,33645,31564,31597,33677,31532,31532,35725,31564,31597,35725,31564,33645,35757,31564,33677,37806,33677,33645,37838,33677,33645,37838,35758,33677,37838,35757,40016,40015,37903,37838,39951,37870,37838,37838,37838,35725,33645,31533,27339,27307,38034,36053,27602,27634,27634,27634,27634,27634,29779,31860,31860,27601,29518,33743,33776,37905,27242,18855,12646,23244,29616,25260,21227,8709,4452,4421,31726,35789,31694,31661,23275,21195,14825,21164,31728,25390,17003,12841,8712,42423,55069,57214,55134,48665,27601,38198,50909,50876,44505,57116,61439,63487,50744,44405,46518,29582,25128,44210,59294,52955,48697,59197,50713,50712,50713,35954,40082,33582,29485,25259,8583,31662,23211,23211,25389,38196,25519,38229,36084,25552,29680,25356,27632,27631,33939,4294,8584,25455,21229,25422,29549,14922,14956,10599,10662,6437,19018,25130,25162,16872,27631,19181,23438,25551,12937,6663,8710,255},
{55263,55231,55230,53150,44634,48827,51004,19377,10861,8780,8715,21163,37902,35821,37902,35822,35789,35822,37870,35822,37902,37870,35822,37903,35822,35822,35854,37870,37902,37903,37870,35822,29516,33677,31565,31597,35725,31564,31564,35725,31564,31596,35725,31564,33645,35757,31564,33677,35758,31597,33645,37806,33645,35725,37838,33677,35725,37838,35757,39983,39983,37903,35758,37871,35790,35790,37870,37870,35790,37870,33710,29517,31597,33874,33940,29714,29714,27634,27601,27601,27569,27602,27602,27634,25456,25161,29289,33547,35530,27176,25128,31402,29322,25194,25194,21162,4452,2340,4454,40213,42160,31693,50547,33741,44274,37870,37935,42226,31695,31630,27470,23308,42390,57181,53021,55101,57214,50843,50843,52989,48796,42359,59261,61407,63487,57116,46485,46551,40244,19083,38034,52955,46617,40342,36214,40375,46682,46714,44536,57149,46616,50745,35792,6341,19083,31695,21130,25356,27436,25291,27469,23244,19018,29647,27500,19081,19178,21356,21164,6439,17035,25422,25390,23276,2311,6439,31211,29099,14761,23310,23277,23375,25358,14891,23440,40246,31825,19179,8647,10792,255},
{55263,53118,55198,53118,42619,44667,51005,19410,10861,10828,8715,8650,21261,33709,37902,39982,37870,37935,39983,37902,39983,39983,37935,40015,37935,37935,37935,37903,37935,39983,39950,35790,31597,35757,33645,31565,35757,31565,31564,35725,31565,31597,35757,31564,33644,35757,31564,33677,35758,33677,35725,37838,33645,35757,37838,33677,35757,37838,37870,37903,39951,37903,37838,39919,35790,35790,39918,37838,35758,37871,33678,29549,31597,29517,25357,25389,25357,23309,25390,25422,23342,25488,25520,27601,27666,29681,35693,37642,37642,33417,27209,25193,29419,27340,27242,21000,12710,4421,8648,40181,50580,31628,44306,37902,35919,42161,31693,42226,25356,40113,31694,33774,44372,57182,42456,55101,55102,40311,40310,55102,50942,44570,52955,63487,63487,63455,52759,40146,33905,21163,23373,33938,52890,35987,17003,27665,36052,21358,42455,31923,36149,46649,44276,12550,6405,29453,21131,23211,33906,44439,33841,33776,33776,23275,25419,16935,14887,10758,21292,14891,10665,25455,25390,23309,10763,14891,18953,41550,19020,35987,33842,23375,25553,19181,33940,42392,46618,42424,21293,25453,255},
{55263,53150,55230,53150,42587,38329,53052,21458,10861,10861,10795,8682,15120,23506,21327,21358,25421,23308,29549,27436,29581,31661,31629,33774,33742,33710,33775,35822,35822,37935,35790,35790,33710,35758,33678,31597,35758,33645,33645,35757,31597,33677,37838,33645,33645,35758,31564,35725,35757,33645,35725,37838,31597,35757,35758,33645,35758,37838,37871,39983,39951,37871,37870,37870,37838,37870,37871,37838,37838,37870,33678,31597,31598,27437,27372,25324,23179,21098,21098,18986,16873,16873,16905,14792,14825,23342,44309,41803,43883,41771,41803,35530,23080,16775,14727,12582,14759,8582,19051,33939,52759,35854,38032,44273,29581,46387,29581,40114,29549,31694,33775,25355,48696,55069,44537,48762,59262,55037,50810,55101,50876,46617,50810,63487,63487,63487,57050,48532,44405,38034,19018,29549,50809,40147,23244,14922,25519,12810,25584,21196,17133,36149,38197,31598,14695,16905,21099,25291,27534,29777,46649,36182,46616,38132,29679,19114,14888,14888,10792,17034,17004,29648,25454,25422,23309,19018,19083,25358,23277,36052,35987,25422,29746,40279,42424,42456,48795,38198,23342,29615,255},
{55263,55263,53182,53150,40474,40409,53085,23506,12942,10861,10796,8650,15152,25652,17233,13072,15086,10665,10632,10632,12712,14825,12744,14825,14825,14825,14857,14825,14825,12744,14824,16905,18985,16937,16937,18986,19018,19050,21130,23179,23243,25291,27404,27404,27404,29517,29517,31597,33678,31629,33678,35790,33677,35790,37838,35758,37838,37838,35758,42064,39951,37871,39951,37871,35790,39951,37871,37870,39951,37871,35758,33710,31598,27437,27437,27372,23179,21131,21099,18986,18986,18953,16873,12712,12712,19116,40147,41804,39755,37577,37610,37642,37610,33450,27176,25096,16807,14727,25358,29746,48631,44241,31693,48466,29581,42226,33775,31727,35888,23275,35920,25356,52955,53021,44602,46617,59294,55036,61375,55102,48828,48796,42424,57181,63487,63487,61342,50678,48630,50776,29550,33808,48696,61342,48600,40147,48599,35987,27503,33809,16970,19181,25552,40180,29453,29387,35889,25389,23178,29517,33808,23243,33937,33971,19083,29680,21195,17001,25422,33938,44472,38199,29648,25422,25422,31662,27469,21229,27535,29680,35922,27535,38132,44505,44569,48763,48763,29713,25454,25422,255},
{55263,53183,53150,51070,36281,36216,50940,19346,12942,12941,10796,6602,17200,27732,17233,13072,12973,10697,10632,10632,12713,14857,14792,14857,14793,12712,12745,14793,14761,10567,12647,10599,10567,12647,12647,12615,12647,10567,10567,12680,10567,10567,12647,10599,12647,12680,12680,14760,14760,12712,14792,16873,16905,18986,19018,21098,23211,25292,25324,27436,29517,31630,33678,33710,33710,37871,37903,37871,39984,37904,35823,37904,31630,31598,29518,25357,23212,23211,21131,19018,19018,16905,16905,10632,10664,14858,46551,52564,44144,35529,35530,25063,23016,18888,18855,16775,16807,18985,31729,29714,40246,52660,31628,46353,35854,33806,40080,25388,40113,23243,31727,35889,59262,55102,42456,55069,52956,44471,65535,59294,48731,48796,48763,48794,63487,63487,63487,54937,48533,40178,29614,21195,42194,59261,61277,55003,63423,50745,57051,55003,42293,50713,40213,44471,39952,27307,25454,25324,23178,29517,31727,37937,31630,27436,29549,31694,40177,21097,31728,36051,25713,29812,29779,27535,25455,25454,33743,23309,21229,31761,35986,29615,44472,46618,46715,50811,44342,23375,29615,21294,255},
{51070,51038,55263,46877,32056,34136,52988,19346,12974,12974,10796,6570,17200,29845,19346,13072,12973,10697,10632,12712,12745,14825,12745,12745,14825,12745,14825,14825,14793,12712,12680,12680,12647,12680,12680,12648,12712,12680,12680,14760,12680,12680,14760,14760,12680,14760,12680,12680,14760,12647,14728,14760,12615,12647,12647,10567,12647,12647,12647,12680,12680,12680,12712,14760,14792,16873,16938,19018,21131,21163,23276,25324,23309,25357,25357,23277,23277,23244,21164,21099,21099,16938,17003,21230,12713,23244,50581,44274,35889,29256,31369,31337,35498,29224,29224,27242,27242,23114,31794,29714,33907,54838,35821,35919,44273,29548,44306,27468,38001,29549,25356,44406,63487,50843,40278,59262,46585,33939,61374,63487,59262,50877,46683,46584,61407,63487,63487,59229,52694,48533,46420,21098,39560,52596,65535,50809,55003,63422,50842,59261,55035,59262,52858,52890,52825,27405,12744,35921,37936,27404,38132,46681,48632,44439,46551,31728,40245,21228,23340,38099,14984,12907,27667,25487,27568,25422,29615,29550,21391,29713,35922,33939,46682,46682,50909,50811,31762,23342,23342,25487,255},
{46845,51038,55263,42619,32024,34104,55035,21426,12942,12942,10828,6602,17200,29877,19378,15185,15086,10729,12712,12712,14793,16906,14793,14793,14858,12745,14825,14825,14825,12745,14760,14728,12680,12680,14760,12648,12712,14760,12648,14760,12712,12680,14760,12712,12680,14760,14760,14760,14792,12712,14728,14760,12680,14760,16841,12680,14728,14792,14760,14760,14760,14760,14760,16808,14728,14760,14728,14728,16841,16841,12712,14760,12712,12745,12745,12712,14857,14825,10665,10664,12713,12713,19117,27634,35890,46322,48500,44275,37872,29354,25193,25161,25096,27144,25031,25096,23016,23147,29714,29714,29714,50744,44240,29580,48466,31628,42225,35855,31694,37968,23243,50744,65535,50809,46584,59295,40278,25520,50875,65535,61375,52956,50876,44537,55068,57181,61407,63487,54872,48565,50743,29615,23211,42161,59261,54970,52987,52987,52890,59293,57083,50777,63422,48729,55035,42195,12615,27534,40115,21130,27469,29647,46648,34004,46649,44537,31826,40245,31728,35986,31760,15049,31826,12810,29680,29616,29615,33807,29647,23374,33906,40278,42424,42489,52989,40278,23342,23375,23342,29681,255},
{53150,53150,55231,40474,29943,34104,55067,19378,12974,12974,10829,8683,17201,29877,21458,15185,15119,10730,12744,12712,14825,14858,14793,14825,16906,14793,14825,14825,14793,12745,14760,14760,12647,12680,14760,12680,12712,14760,12680,14760,14760,12680,14760,14760,12680,14760,14760,14760,14760,14760,14728,14793,12712,14760,14793,14760,14760,16841,14760,14760,16840,14760,14793,16873,14760,14760,16841,16808,14793,16873,12712,12712,12713,12712,12713,12680,14825,12713,10599,8487,10567,6439,19149,25456,48664,48499,37968,40113,52726,46354,46387,42161,44242,37936,37903,35758,35726,40050,27568,27633,29746,44439,52660,29548,46353,37967,35886,42161,23307,40114,29517,44437,65535,48762,52956,57181,36020,27632,36117,65535,61375,57117,50876,55069,55102,42424,52922,63487,59196,50645,48630,44340,25291,35888,48696,52825,36051,17132,38229,40310,34003,52955,44600,50810,57181,52630,37382,39593,39659,27404,29484,33775,35855,31597,35920,33808,25291,38099,35953,23275,40244,19178,23470,12778,19181,31793,27567,27567,33775,25389,36019,50876,50681,50908,44505,27568,23342,23374,25487,31826,255},
{55295,55263,53150,38362,29911,36152,55067,19378,12941,12941,10828,8683,17200,29877,21458,15153,15086,12778,10664,12744,14857,16938,14825,14825,14858,14825,14826,14793,14793,12745,16873,14793,12713,12712,14793,14793,12712,14760,12712,14760,14760,12680,14760,14760,12680,14760,14760,12680,14760,14760,12680,14793,12712,12680,14793,14792,14760,16841,16873,14760,14793,14760,14760,14793,14760,14760,16841,16840,14792,16873,16905,12680,14793,12680,12713,12680,12712,12712,10600,10567,10600,8552,21295,35955,52956,48532,38033,44339,48565,52693,46452,46452,48565,44372,44372,44372,46584,42391,27502,25455,29746,33972,54871,35789,37967,46354,29580,46386,27468,35920,35855,33872,61374,57117,57181,52923,31794,23473,25586,57213,63487,61407,52989,55134,46683,29779,38197,57181,63455,54839,52758,52856,35856,29451,44144,57115,46485,33776,23341,42324,21163,33938,27469,25551,40375,46583,37806,31239,31402,33840,23243,29549,38131,48631,42195,35855,40081,33775,46517,35854,31792,38099,33938,27535,19149,31793,31761,25455,29615,33807,33939,38230,46617,42423,29681,23342,23375,23374,29746,31826,255},
{53183,55231,46877,36249,29911,34072,50907,19378,12941,12974,10829,8683,17201,29909,21458,15185,15086,10730,12712,14793,14857,19018,14793,14825,16906,14825,14826,14825,14826,12745,16906,14825,12745,12713,14793,14793,12712,14760,12680,14760,14761,12680,14760,14793,12712,12680,14760,12680,14760,14760,12680,14793,14760,14760,14760,14760,14793,16873,16873,14760,16841,14760,14760,16841,14793,14760,18921,16840,14760,18954,18986,12680,14793,14761,12713,14761,14761,12680,12680,10600,10600,10665,25488,44537,57182,40114,33742,38000,40113,42226,38033,40146,40211,40178,42292,40178,42325,44405,46387,29615,27601,29746,52824,44241,31661,50579,29580,40113,35855,27533,38033,25421,52955,61342,61407,44504,33907,36020,23440,42423,65535,63487,59262,48763,44538,21295,33972,52922,63487,57082,50613,40113,31662,23080,42031,52857,57050,52792,35824,46518,35824,29647,50744,23244,36019,40309,42195,31467,14792,27404,25259,25323,35986,40407,55068,46617,52955,42357,46551,38131,23373,42260,31857,21453,42392,31860,31793,29615,27503,31761,31826,29713,27632,27568,25455,23342,25455,25455,31826,31793,255},
{51070,51037,40507,34136,29943,31991,46715,19378,12942,12974,10828,8683,17233,29877,21458,15185,17167,12778,12712,14825,16905,16970,14825,14825,14858,14825,14858,14858,14825,12745,16906,14826,12778,12745,14858,12745,12713,14760,12680,12680,14793,12712,12680,14793,14761,14760,14793,12712,12680,14760,14728,14792,14793,14793,14760,16841,16905,16873,16873,14793,16841,14760,12680,16841,14793,14793,18921,18921,14760,18954,16938,12680,14761,12712,12680,14761,14761,10600,12648,12680,10600,12778,25554,46618,52989,54938,42160,44273,44274,50580,42194,37935,31661,33775,31695,31662,31760,40245,44371,35888,27568,29681,44471,52693,31661,48467,37967,38000,44274,27501,42194,27436,42325,63455,59327,40213,36052,38133,17004,31598,63487,63487,61343,48731,48731,38134,38263,48663,61374,61342,54839,50645,50646,31597,35595,50483,65535,61309,52922,61309,57018,50711,57083,46421,42292,46518,48631,44112,25097,31500,37838,29549,31565,29517,40244,33873,40341,50842,29777,44470,44406,35954,38131,15015,31955,36086,31794,33874,29648,27568,33907,33971,27535,25455,23374,25455,23375,29681,31794,35987,255},
{55231,44732,38362,34104,29944,32024,46715,21459,12909,12909,10796,8683,17200,29877,21458,15153,15119,10730,10632,12712,14825,19018,14825,14857,14890,14858,14858,14826,14825,14825,16906,14793,14826,14793,16906,14793,12713,14761,14761,12680,14761,14761,12680,14793,14760,14761,14793,14760,14760,14793,14760,14760,16841,14760,16841,16841,16841,16905,18953,16841,14761,14792,14760,14760,14793,14792,18953,18953,14793,16873,18986,14793,14761,14793,12680,12712,14793,10600,12680,12712,8520,14891,29747,50811,55036,55004,46354,46483,46419,54871,44339,48532,46419,48500,42226,44274,33873,38133,48532,48532,27567,29713,38133,56919,37967,40080,48434,33774,46419,31727,38033,35920,31792,61374,57149,36020,31859,29714,12745,29421,55068,63487,63487,55037,48796,44635,42391,50810,63455,63487,56985,52725,54904,48468,27371,42193,57148,65502,57083,65535,59164,55002,65535,52922,59228,61276,57083,54710,41804,45899,48208,42130,27404,29517,33841,52824,33742,42260,35855,31759,40212,27533,25485,29678,19275,42358,31793,46584,46519,33874,38165,29681,25455,25455,23375,25487,25455,31826,33842,46584,255},
{55295,46845,36281,32024,29944,36185,52956,21459,10861,12909,10796,8683,17233,31957,23539,15153,15086,10697,14825,14825,16905,19051,14825,14826,14858,14826,14858,16906,16874,14826,16938,14826,14826,12745,14793,14793,12713,14761,14793,12712,14761,12712,12680,14760,14760,14793,16873,14793,14793,16873,16841,16873,16873,16873,16841,18954,18954,16873,18953,14793,14760,14792,14793,14760,14792,14760,18953,18953,16841,16873,18986,16905,16873,14825,14825,14793,16873,12713,12713,14793,16873,27438,31697,59131,57116,57149,44339,42160,44274,50645,52725,46484,46484,48565,46452,50613,35986,38165,52759,52692,33808,29714,31827,52824,46321,33774,50579,33676,44273,37935,29549,42194,25356,52955,50810,33939,33973,27633,16906,29520,52956,65535,61407,50876,46715,38264,44537,44537,52955,65535,61276,54839,54871,54871,29517,39625,40079,59228,50809,46616,44600,59229,57181,59196,61374,63390,50744,63390,48175,47947,44047,37807,27404,31630,36018,46648,50777,50907,54938,35954,46551,33776,23275,40244,36051,40375,23504,19471,34036,38132,36084,27568,25455,25487,25488,25455,29681,35987,38132,44633,255},
{55263,42684,36282,32024,32024,42490,48795,21459,12909,12942,10796,8683,17200,31957,23539,15185,17232,10730,14825,14825,16906,19051,14793,14826,16938,14826,14858,14826,14826,14826,14858,14826,14858,12745,14825,14826,12713,14761,14793,12680,14761,14760,12680,14760,14761,14793,16873,14825,14793,16873,18953,16873,16873,18954,16873,18954,18986,16873,18954,16873,14792,14793,14793,14728,14792,16841,21001,18953,16873,14793,16938,16873,12680,12712,12680,12680,14761,12680,10567,14793,35856,44177,35727,59163,61244,55069,31793,27665,38164,40245,42357,44437,46485,46517,46485,48598,40180,33906,48631,56983,42227,29681,29682,44471,46419,37935,48531,39950,37902,48435,27339,40114,29517,38164,46552,31827,25618,17101,21230,36021,46683,61374,63455,50876,44570,42392,50811,52956,48730,63455,65535,56952,52758,54904,46355,27306,39689,54904,57017,48501,23308,46550,31728,36083,52922,38229,52987,59229,54807,48109,50059,44014,50549,33710,35790,35953,38000,38033,44470,44535,46550,44406,29744,35953,44470,36148,13036,4614,31986,48568,31761,27535,21261,23342,25455,25423,31826,35954,27695,15146,255},
{51070,36314,36249,34104,32056,48795,46747,19379,12909,12974,10796,8683,17200,31925,23539,17266,17232,10730,12712,14825,16906,19051,14857,14825,16938,14858,14858,14826,14826,14826,14858,14826,14858,12745,14825,14826,12713,14761,14793,12712,14761,14761,12680,14760,14793,14793,16906,18953,16873,18921,16873,16873,18953,18954,16873,18954,18986,18954,16905,16873,16841,14792,14792,14760,14792,16873,21001,16873,16873,14760,18986,16906,14761,14761,14793,12712,12680,12680,10600,12680,10698,23310,31762,61244,61275,48730,27502,19083,23310,25455,27600,27665,25552,31891,31891,34004,29778,33842,42358,54837,46420,29680,29714,38133,29647,25486,33840,35953,35953,38098,38001,40146,35856,33808,40212,38133,29746,12712,23277,44538,36150,50842,65535,61342,42457,46649,52957,50876,42359,61375,65535,61244,54838,52856,52856,27437,39951,48566,59196,59195,37969,38131,54873,29614,55002,37969,36083,50776,50679,47946,52042,50190,56724,44243,31597,35888,37935,35888,35888,35887,33873,35855,31694,31694,44438,33904,10855,10952,42487,50551,35954,27568,23342,25423,25455,27568,25550,19338,17194,4516,255},
{46845,34136,34137,34104,34169,48795,46747,19411,10861,12941,10828,8683,17200,29877,23539,17233,15119,10730,12713,14825,16906,18986,16906,16906,14858,14858,14858,14858,14793,16906,16938,14826,14826,14826,14826,14826,12713,14793,14793,12745,14793,14793,14760,14793,16841,14793,16906,16938,16905,16873,16905,16873,18953,18953,16873,16873,18953,18985,16905,16873,16873,14760,16841,14760,16841,18921,21001,16873,16873,16906,16938,16906,14793,14793,14792,12712,10632,12680,10600,12680,10665,12876,33907,59197,63323,46519,19050,21164,19051,31728,36019,33874,31760,33905,33938,33873,31793,36052,38197,54871,52692,33809,29746,38132,25355,18919,31695,17002,19050,29583,17002,27567,23374,23374,29680,27567,29615,27470,31663,38263,36118,42424,65535,63487,52924,50777,55036,46682,50843,63487,65535,59196,42324,44438,48695,33808,27404,42064,57148,50808,50678,27566,50841,27534,40309,52824,25453,55035,50809,50320,45670,37382,50027,54742,33678,33742,40146,40049,40081,37968,31695,35888,38000,40112,33840,42293,21355,23533,46649,48729,35986,23342,23277,25423,27535,29744,15112,8773,6628,8741,255},
{42620,34104,34137,34137,36249,48795,46715,21459,12909,12942,10796,8683,17168,31925,23539,17233,15119,12778,14793,16938,19018,19051,16906,16938,14858,14858,14858,14858,14826,16906,16906,14826,16874,14826,14826,14826,14793,14761,14793,12713,14793,14793,12712,14793,16873,14825,16905,16873,14793,16841,16873,14792,16841,16873,16841,16841,18953,21034,16905,18953,16873,14760,16841,14761,14760,18921,21001,16841,16906,16970,16906,16873,12712,10600,12647,10599,10567,10567,10567,10600,8552,10633,38067,57149,59130,48566,33644,40049,37936,37968,23244,16970,12777,19083,12810,23341,23342,33907,38165,40277,44340,31761,31859,38067,27469,29582,33808,25357,31663,31695,23243,31728,19017,19082,27502,10630,27502,19083,14955,27535,29646,29680,59294,55101,57149,65535,61375,42359,52923,65535,65535,50777,33906,29811,34005,19116,18953,37774,50843,38262,48795,27503,42325,42259,23373,48663,31663,34003,44470,50711,48240,25226,35595,54545,42227,33677,42357,52987,54970,42292,52824,42292,44437,44437,25420,40211,36050,36083,42391,50843,40278,17196,19115,25422,23373,15080,10886,12967,12967,8709,255},
{42652,32056,34104,34104,36217,48763,44635,21459,12909,12974,10796,8683,15120,31925,23571,17266,15086,10730,12745,16905,16938,19018,16906,16938,16938,14826,14858,14858,14826,16906,16906,14858,14858,14794,14793,14793,14761,14793,16873,12713,14761,14793,14760,14760,14825,14793,14825,16873,16841,14793,16873,14793,14793,16873,16873,16841,18954,18986,16873,16905,16873,14760,16873,16841,14760,18953,18953,14793,16873,16906,16906,14793,12680,10632,12679,12680,10599,10599,10599,8520,6472,31598,50745,52956,48632,48664,40081,42194,42194,46420,35855,29485,29452,25259,23146,25258,23243,33907,40246,38133,34005,25487,36020,33841,18821,25258,25357,10695,29647,17035,19180,31728,21293,31760,29680,27502,33808,25357,25357,31728,33839,29583,46616,65535,61407,50876,48762,52890,59229,65535,63487,42326,40180,40278,33972,14793,25324,40246,44505,19247,19312,12907,31988,33971,17101,40408,29681,23439,48729,46616,42195,29420,19083,44470,33874,27437,33775,38066,42357,42325,48761,50874,46615,46583,29712,33872,44437,48696,46649,48796,46716,40409,35988,16939,23406,15048,6661,8742,4549,8742,255},
{44732,32024,32024,34169,34137,46682,46715,21492,12909,15022,10796,8683,15087,29844,23539,17266,15119,12778,14793,16938,19018,19051,16938,16938,16938,14858,14858,14826,14793,16906,16906,14826,14826,14826,12745,14793,12713,14793,16841,27308,21034,23147,21034,21066,23147,21066,21034,21034,18986,18953,18954,16873,18953,18953,18921,18921,16873,16873,16873,16841,16873,14760,16873,16873,14760,18921,18953,18954,16906,18986,19018,19018,16905,14792,14759,12647,10599,8486,10567,8487,4391,23374,55036,50843,48632,42359,25422,31793,31826,36052,36052,44406,44406,44405,44372,46452,42227,36052,40278,35987,29681,25455,38133,31728,25389,31727,29582,25323,33776,16937,21163,25421,8582,29647,16970,19115,31728,17034,27567,23406,27535,29648,33939,63487,59294,40311,46519,44471,61341,65535,57149,40180,38132,40278,31761,18856,37448,50681,40344,42359,17036,25455,42424,23374,19117,27698,23375,15053,25716,40376,27340,37546,37481,43950,29420,27469,27567,27600,38067,31727,31662,33840,33840,40114,52855,42194,38033,48697,50810,46716,44667,42652,44571,14891,29713,25518,10855,4549,2372,4517,255},
{40539,32024,31991,36249,34137,44570,46747,21492,10829,12974,10796,8683,13007,27732,21458,17265,15118,12778,16938,16938,19018,19018,18986,16938,16938,14826,14858,14858,14826,14858,14858,14858,14858,14793,12745,14793,14793,12713,16873,31566,27308,29453,29453,29582,31727,27566,27437,27437,16937,25259,23178,29582,27437,21066,25324,29484,25324,27437,29485,27404,23147,23146,21034,23114,21034,21033,21066,21067,25260,21099,21132,35889,35921,33841,31727,29582,27469,23244,23276,21131,8584,12778,52955,52891,50778,38133,17003,23309,23277,33776,23179,40213,36019,35987,38133,38165,42359,36020,38165,31761,23342,27568,40213,19050,4357,29615,12744,23341,27534,14954,31728,25454,27534,33841,27502,31696,31728,23275,31695,16937,25389,25389,10761,48795,44635,31925,55068,48631,59228,65535,50777,36019,38165,38165,23277,25227,35792,48763,31826,42392,19149,36117,42456,21295,42456,44537,21262,40213,38198,36053,25520,39822,42130,31762,25292,27437,21359,29811,42522,25585,44504,33972,17036,40245,40340,33775,25389,40277,48763,44636,44700,42619,29617,14858,31761,36019,38098,17096,8709,8742,255},
{40474,34104,31991,38330,32056,44570,50908,23572,17102,21263,19182,14989,15088,25619,21426,17265,15119,12810,12745,16938,18986,19051,18986,16938,16906,14858,14858,14858,14826,16906,14826,14858,14826,12745,12745,14794,14793,14761,18954,31566,25227,29421,29421,25389,27534,21196,27501,29646,16840,25324,27534,27534,27437,18986,27534,31662,27501,27469,29582,31792,23211,25291,19018,25357,29550,31760,25324,25356,29582,27405,29518,33905,33776,31728,33841,33873,33873,31793,31760,31728,25357,21197,46617,57182,50876,33841,16938,19083,33841,38099,38067,50745,50778,50745,50745,48665,48697,36020,38133,25422,19149,29714,38067,27469,27437,33776,23211,29583,25389,12743,31696,10599,21131,23309,4359,29648,21228,25486,29680,21293,31761,29648,27502,50810,50811,38100,44601,57116,52923,63487,44406,33874,36183,34037,17003,19084,44472,52924,52760,48664,33776,44405,33841,21228,38230,33940,21326,44602,46650,33516,39561,43656,46063,31631,25324,33809,40181,46650,38166,31858,48795,23505,21262,36085,14988,19246,29681,42391,46683,44603,44700,44569,39883,25357,27567,42423,50809,25546,8838,8806,255},
{40507,34104,31991,38330,32024,44570,48827,29944,40312,44537,44505,34039,15087,23505,21425,17200,15119,12810,16938,16970,19018,19083,16906,16938,16938,16906,14858,14858,14826,16906,16906,16906,14826,14794,14793,14793,12713,12713,23245,31598,25227,29453,29453,23179,23211,29646,25356,23243,21098,27404,27534,25356,29517,25324,29614,31695,29614,27469,31662,31760,25292,23211,19018,25324,27469,31824,27437,23244,29647,27437,23244,27566,27437,23244,25454,27534,25487,25519,23245,25260,23147,18987,29713,55101,52956,31696,23244,23341,29680,27535,29745,46617,48697,48730,50810,50810,52891,40246,36020,25422,21262,33940,33841,18887,23243,25421,21065,31728,23308,27534,31760,25389,33808,29615,25325,33841,25356,29615,25389,14823,31696,8551,25455,59262,50875,59196,44471,44536,59295,59197,40212,40213,42358,27633,18889,33647,50908,55134,50973,55102,57182,57215,52891,52858,57084,42261,44341,46551,42359,27340,39496,43917,39725,27210,27469,48763,59295,57215,55037,52988,50908,42326,33842,38166,31827,17068,29745,48763,44570,42587,42586,29682,14792,27568,29680,46616,36049,15142,11013,10982,255},
{40539,32056,31991,36249,32024,44537,42554,29944,42458,44602,44570,42458,27667,21360,19280,15087,15086,12842,14858,16938,16938,19019,16906,16938,14858,14858,14826,14826,14793,16906,16906,16906,14826,14825,14793,14793,14761,12680,16874,29485,25227,29453,29420,27502,31727,27533,27469,27469,27533,29550,25356,29582,31662,27534,29614,31695,19050,29550,31727,29647,25357,23211,19018,27469,31759,29679,29550,21163,29647,29550,25324,25356,27437,25357,23244,25357,25422,25487,25357,23180,21067,21067,25390,57149,48665,33841,40115,38034,38035,40115,40180,36019,42326,35987,42390,44471,42423,44439,33874,31728,25455,38101,33808,29517,33776,31662,27371,33808,23145,29549,27437,16839,31728,18984,27437,25455,23342,25487,25455,35922,33809,25390,44374,52956,38197,57148,57052,44471,63455,50777,36019,27601,27600,14890,24999,46161,57247,48763,29876,53021,44602,36215,57215,46747,48860,57247,55167,57215,44505,33777,41739,37807,31501,27405,33841,46813,57279,55199,57279,57279,57279,52989,46584,55068,38198,12840,38132,48763,40377,44668,42489,10665,17068,27567,40244,50809,29708,11014,13158,13126,255},
{42587,32024,31991,38362,32024,44537,44602,31991,42490,42522,44570,42458,42490,36119,27699,25553,23408,19084,19083,21131,21099,21131,19018,18986,16906,16906,14825,14826,14793,14825,14793,14826,14793,14793,14760,14761,12713,12648,16874,31566,25227,29421,29388,25356,27469,23340,29550,31727,27566,31662,29679,27534,31695,27598,29614,31727,23178,29582,33808,29647,29517,23211,21098,27437,31727,29582,29582,21131,31727,33808,21196,29518,31663,27502,25357,27470,29745,27535,27535,23148,23148,23148,21164,55068,31858,14955,21294,23440,36052,27665,31827,27666,34004,36052,38165,40278,40245,46584,40212,27568,27601,38100,27468,21162,31695,23211,29647,33808,27501,33841,29615,31695,33873,27501,33776,12778,17003,10695,21196,38133,25324,16970,52923,59196,52890,46584,50875,50842,63455,44406,33939,36150,31892,14858,17004,33875,42391,40474,44504,50909,42521,44569,55102,34037,46682,50876,27763,50941,40116,39953,41772,33940,23310,29582,31728,34004,46747,38263,48861,48861,44732,46617,34069,32086,23504,21260,44569,36147,25679,32052,27666,6504,25454,29647,48697,44437,21352,13126,15207,13094,255},
{40475,34104,34104,44635,32056,44537,46714,31991,38297,44570,44570,42457,40409,38329,40410,44602,44537,40344,42360,42359,42359,44407,44407,44406,38069,35956,31795,29683,27603,35891,33811,25555,19216,17103,19150,23278,35823,35791,31663,31599,25227,29453,29420,25324,27436,16905,27404,29679,25421,29582,29679,27469,29550,29647,29614,31727,27501,29550,27502,29679,31630,21131,21131,25324,31727,23179,25259,19018,29614,33840,21163,31727,35953,29614,29582,29582,25422,25422,27503,21067,23148,23180,16906,44504,33841,31696,29583,29681,27534,25389,21197,19116,14955,17036,16971,21294,19149,25552,19247,25521,31859,38067,29582,27437,33776,21098,29582,29517,25193,31696,16839,29582,25324,19017,31728,6438,12777,4292,33906,36019,29615,33841,55036,57213,57181,52891,40278,57181,59197,40180,38132,44602,29747,21196,38036,25227,25357,21327,27243,25488,23538,35825,36280,42424,44537,42522,42424,48763,35498,41544,43657,39562,25259,27437,31727,33775,31695,31663,31793,33841,31858,38197,23439,27665,10824,27696,36147,21385,17191,17192,12904,17002,27534,33938,48761,33838,17224,19433,19336,12966,255},
{36249,34072,36216,48796,34104,42457,42522,32023,36216,44602,44570,42457,40377,36217,38329,44602,44570,42489,42490,44538,46618,46650,48730,46650,40279,38167,36054,31895,31927,42296,40248,27831,17331,17266,21459,31794,52791,52823,40244,23245,23115,25260,27340,27469,29646,19018,27404,29679,27501,31662,29679,27469,31695,21228,27437,29582,25421,29582,29614,29647,31727,29614,23211,25292,29679,27404,27372,19018,29550,33873,25356,29582,27534,29615,31695,29647,29615,29615,29712,23115,23147,21035,16874,29681,29583,29648,31729,31762,31762,31826,31794,31794,35955,31794,33842,31794,33906,31826,29649,27634,36053,35922,25354,25388,25389,19018,31760,23276,27534,31760,27469,33841,29582,29517,33841,25356,27404,23178,36019,29648,8615,40245,59261,44471,42456,57181,48697,63487,50777,35987,34037,36182,21229,27567,37938,14825,29518,33679,14793,27504,19052,21098,36085,27438,27373,21360,31501,23342,25455,41707,29486,27372,25292,31761,31859,31760,25454,25422,31695,29614,31663,31695,31695,25484,12935,25580,21385,15046,15047,15047,8741,17192,19241,33969,42356,23336,17256,19304,17159,12934,255},
{36217,34072,36184,50876,34137,44505,44634,32024,38297,46650,44570,42457,40377,38265,38297,46682,44570,42457,42457,44537,46617,46650,48730,46617,38166,38134,33974,29813,40215,40183,38135,29847,17266,17233,17233,29681,46420,44307,31728,10601,6343,8488,21002,27469,31727,16937,25291,21098,21163,25324,19050,25292,25292,21131,27405,27469,25356,29517,21131,29614,31728,27501,25324,23211,27501,31662,31760,21099,27437,33937,25356,29517,29582,31759,33808,27470,29615,29648,27632,25228,23180,18987,18986,25293,27341,25260,23179,23147,23180,19019,16939,8552,25455,23342,21294,19214,33906,35986,40245,36020,36053,33808,29581,31695,27437,23146,31696,18887,27437,23179,14727,29647,10599,27502,27535,27568,35954,27568,29713,29680,29550,48665,61375,57116,50777,38230,55068,63487,42358,40180,40343,31859,16971,29714,17102,10729,29811,17134,17166,36150,23375,19051,37905,16906,29583,35890,16873,29616,21164,25259,27569,25357,27405,33841,33873,33808,27535,29615,31826,27666,31728,21293,21356,19272,17159,21384,17191,10885,17160,12935,10821,10821,8773,19243,29645,15045,15143,15111,10822,8677,255},
{36217,34104,36184,48828,36249,46617,50875,36217,40377,46650,44570,42457,40377,38265,38297,48762,44570,42457,44537,44537,46617,46650,48730,46617,38166,36054,31861,33941,42295,38103,36087,27766,15186,15153,17200,27600,48435,46322,31631,10601,6375,8456,18890,27437,29646,27534,29549,18953,25324,27437,16873,27404,29550,21131,29485,31759,27437,29517,25324,29582,31759,27599,27437,21099,29614,33743,33872,23244,27437,33905,25356,27404,33873,31695,31728,31792,29615,29615,27567,27405,25260,21067,23180,19019,23180,21099,21099,19019,21067,18986,18986,10566,27502,29583,17003,17003,33808,33775,38067,42294,38100,25356,21162,31695,21098,27469,29615,23276,33841,27470,29615,31760,25324,31728,12745,27568,25423,14890,16970,8649,35988,57117,44536,48795,61309,42326,61342,59197,40180,33874,31760,19148,20838,39496,20904,25031,29323,6374,23114,25422,10632,19214,25489,10729,23408,16874,12875,36150,19149,19051,31599,25357,29583,29615,38001,33808,31662,31695,33776,31728,31728,25453,19272,19271,19303,17158,15046,8773,15047,8709,10823,12935,10854,17098,12773,8772,13062,10951,10886,10822,255},
{36184,34136,38329,48860,38362,50778,59163,42490,42490,42457,42490,42457,40377,36216,40377,50842,46618,42457,44505,44537,44569,46649,48730,46649,38134,33973,29780,40182,38102,42263,38103,27766,15153,17200,17168,27568,48435,44274,31663,10568,8423,8455,8488,8520,10664,14955,14891,14760,12713,14826,12648,19019,23309,16905,21131,23341,18987,21099,25486,25422,29615,19018,25292,21098,27502,31663,27501,27405,27404,33905,29550,23244,33873,33776,31760,31760,31695,27534,29680,29615,25228,23180,25293,16906,21099,18986,18987,16906,14825,14761,21034,10534,25357,35922,19084,17003,38001,35921,33841,46519,38100,29550,29582,33776,25226,29550,25259,18888,31663,12581,27437,21131,16905,29615,8519,35987,14858,14890,8551,12778,42359,63423,44406,46616,57181,50810,63487,50777,35987,31891,29714,14858,27567,44146,37481,35596,39594,35336,41642,31175,24966,39497,22887,22984,27211,6374,18986,14988,4455,21295,23310,29518,35987,38133,50843,36053,33939,42326,23374,29615,29648,25453,21353,21385,21385,17159,17159,17159,15014,10822,12871,10855,10789,8677,6563,6692,8837,8869,10950,6661,255},
{34104,36184,40442,46748,42555,46682,46715,40409,44570,40377,42457,42457,40345,36184,42489,50843,44569,42457,44505,44537,44569,46649,48730,48697,36054,33973,33909,36021,33942,40183,36055,27733,19281,21328,23375,29648,44242,44242,31664,8488,8423,10568,12713,4294,6438,12939,10665,6438,8519,10632,4261,10730,15053,10631,10632,6471,6439,8552,6438,12778,17069,8519,14793,16970,16971,19084,12745,16938,19019,21197,23212,21099,25455,27535,27567,27535,31696,29680,29616,31728,25260,27341,27373,18954,21099,21099,21099,19019,19019,14826,25259,16807,21196,38034,21197,17003,35921,36020,27567,44439,33809,19017,27501,25357,16970,33808,21228,29615,31696,27437,33841,27469,29550,31728,27502,35987,21099,21130,16840,21165,50778,63487,50778,52923,59229,57117,61407,44406,38100,44537,34005,19084,33939,31664,31500,25651,37742,40050,38263,41740,31598,39823,39562,39724,39529,29095,39561,25095,22853,29323,21164,27437,31989,44667,53054,40441,53021,48796,36020,38100,31762,17002,21322,21417,15047,10854,15079,17127,6596,10822,8741,6661,8677,6564,6531,6596,6628,6627,8739,6855,255},
{34104,34104,36217,42587,44603,46682,38361,40377,50811,40377,40377,42457,38264,36184,44602,52955,46617,44537,42457,44537,44569,46617,48730,46649,36053,33941,33941,27700,33942,42263,33974,25653,15120,17200,23408,31793,44210,44275,31664,8488,8423,10568,12681,6439,10632,10762,8552,8519,8551,10632,6439,10730,12908,6438,10632,10665,8487,10632,10632,12875,17134,12712,10632,10729,10730,12778,6439,12777,12777,10600,10632,10632,15086,14923,8584,10665,12778,10633,12746,14859,14794,18955,19020,16907,18987,19019,19019,19019,19019,16906,21099,12583,12744,35986,21229,21197,31727,35954,31663,40213,31695,29517,31727,27404,23210,31663,12647,27469,21066,16808,29615,8551,27535,21196,23308,29680,21293,33874,31728,31760,55035,63487,50843,55003,61374,65535,57116,38100,36052,40343,19247,23277,42163,19019,27470,35955,19018,40213,35988,27340,29779,31631,37807,31957,41870,35857,38067,41707,39985,27340,25324,29550,29713,40376,38263,27732,48861,32087,38263,40343,40375,25519,23466,17191,12966,8741,12967,12966,8741,6628,6564,2371,4484,6564,6531,6532,6564,10757,17030,13064,255},
{34071,34071,36217,42587,44603,44602,42490,40377,46682,40345,42425,42457,38264,36184,48762,55003,48698,44505,42457,44537,44569,46617,48730,46617,36053,36021,29780,25620,31861,42231,33974,23540,17201,23473,25488,31761,42194,42162,31664,8456,8488,10536,12714,6406,8519,6503,8552,10697,6439,10600,8552,6471,10665,8519,12713,14923,12875,12810,14956,10665,12778,10697,10600,10633,8520,10633,10665,14857,14858,14923,12777,14890,12941,12778,10697,8552,10633,8520,8488,10601,10536,10569,12649,8456,10600,10600,10633,12681,10633,10601,19052,29421,12616,31729,19116,25422,25389,38066,33775,31727,31662,31695,31695,31728,31695,38001,42261,40049,35791,35857,31696,25389,31760,25291,29549,25422,14824,31728,8551,19115,50842,65535,61407,46552,55003,65535,50745,38067,38165,31957,10730,27665,35955,12680,21229,29421,14858,38035,27373,19051,38003,19019,29583,35922,23147,40213,31729,33647,36183,25487,29485,31728,33840,31663,31663,33841,33906,31728,40245,38131,27631,25452,23465,21384,10886,12967,15047,10854,8709,4516,4516,6596,8677,4452,6500,10757,19176,23434,19176,17063,255},
{31991,36184,36217,42522,48860,46683,50843,46650,42522,38264,42425,44505,38296,38264,50875,52922,48665,42457,42457,44537,44569,46617,48730,46617,36053,36021,29748,25588,27701,40150,31894,23540,17232,17167,21262,31728,42162,40081,31631,8455,8456,8520,14762,8519,12713,12777,10665,12745,10762,10665,10632,8552,12713,14922,10664,14890,19246,12778,12745,8617,10665,8584,8519,10600,10729,14891,17069,14857,12810,14988,8552,12746,10665,10633,12746,10633,12713,12778,8585,12746,12649,10569,14762,8455,12681,12713,12713,12713,10600,8488,21165,25196,12649,29616,19149,29616,35855,17034,27566,48533,46420,42194,42194,40048,42063,44339,50876,48468,39916,25420,12807,6566,8615,10729,12842,21261,25455,27567,31696,33808,40245,65535,59294,40212,46584,65503,44406,42293,44471,25488,14630,39562,27210,14695,31469,18921,19116,35988,16873,17101,29584,12745,31826,29454,16971,40115,21100,27470,40148,27405,29582,33808,33841,29550,29647,29550,29550,31695,42358,35952,27469,29612,27660,15080,10822,17160,10854,8773,6628,6629,8677,6564,4484,4452,19241,19241,17128,19209,14951,19209,255},
{31958,38297,40442,38362,44667,57116,59163,48763,44602,38264,42425,44505,38264,38264,50875,50810,44537,42457,42457,44537,44537,46617,48730,48697,36053,36053,31828,25620,31861,40182,31862,25620,15087,19247,17069,27503,42162,40082,29519,6375,8488,6343,8520,2148,6504,8682,2181,4326,4359,4294,8520,8715,8584,8519,10762,10698,10697,10665,10665,8520,10633,10632,10665,14826,14923,10698,12843,17002,12745,12778,8617,12746,12875,8552,12681,8519,10633,10698,8617,12714,16843,12649,14794,8487,12713,12713,12713,12681,10633,14826,25260,14728,12778,23309,21196,35987,46453,21129,21228,50678,48598,46420,48597,48630,52726,42258,50743,44371,40080,35886,27435,25322,21065,18920,16774,18952,12680,16971,31826,33938,25550,59261,59229,36019,38164,57116,42325,35986,31793,19117,24934,39399,18693,31110,35238,14565,35303,35467,16776,37547,25130,16840,33744,18954,21294,29714,8552,29811,29616,29485,27503,27601,46617,31761,35987,35921,27535,38067,36052,23341,23374,38165,38261,21387,17097,10823,8709,2436,4484,4516,6564,2339,2307,8710,23435,21290,17128,14983,15015,19209,255},
{29878,36216,40475,38362,38297,57116,63356,48762,44602,38264,42425,42457,38264,38264,48794,48730,42457,42457,42457,44537,44537,46617,48730,48697,36053,38101,33908,29780,31861,38070,31894,23540,15087,15120,17200,35954,42162,40050,27438,12616,12649,8455,10601,4326,6471,6472,4359,6374,4326,2246,8456,6569,4326,6406,8747,6440,6439,4294,6407,4327,4359,6439,4359,4326,10600,10665,10665,8552,10698,14891,8617,14794,14826,10698,14859,14858,12843,14891,14988,12681,14794,12681,12682,10600,14793,12745,14793,12713,10600,14826,21065,6308,16842,25422,23309,42326,52857,25323,19050,46452,46452,48565,44339,48598,48598,42258,48565,44404,38032,35952,31662,35887,33839,37968,37935,37903,16905,6471,14955,27665,29648,48729,52890,38100,40213,40278,36084,40180,25390,10665,21326,37872,39692,37937,37579,35499,37710,38068,42261,50647,27438,39953,41935,18922,39724,23082,16775,33549,25357,27405,25618,42489,48893,38296,50973,40344,29682,31793,33809,35889,31728,40245,29713,25454,25486,19208,10789,2372,4516,4517,4548,2404,6597,6565,19210,21322,15016,10822,17161,17161,255},
{31958,38297,38329,38329,36216,57115,61275,46650,48730,38264,42425,42425,38232,38264,48794,46682,42457,42457,42457,44537,44537,46617,48730,46649,38133,38101,31828,27700,31861,40150,33974,21427,15088,15087,17167,33874,42162,40114,25325,25260,25292,12681,6407,4359,6536,6504,4262,8552,8552,4327,10600,8747,4358,8552,13038,8519,8455,4294,8585,12940,4326,8552,8617,4327,12714,12680,10633,10632,14956,14923,10665,10665,12778,8584,12746,12811,17232,15022,17264,10569,14762,12649,10569,12680,12713,12713,12713,14761,12713,16939,18888,8422,18988,21229,23309,46584,57084,31662,23340,42292,48598,50711,48630,50710,50710,50645,50678,50678,42161,33742,37935,35822,37967,35887,35855,35855,25323,4325,6503,17165,35987,33970,46552,42326,42358,31924,15217,33973,25391,14662,35531,41739,43918,37970,43885,40115,40279,55102,38328,44635,48731,44667,46618,42424,52924,33875,44374,42098,25291,29583,27535,44505,36021,31860,48828,27764,29747,27535,27568,27502,29614,36019,31728,25422,27534,33928,25510,15046,4484,2436,4484,4485,2308,2340,4485,12904,15016,10791,8678,8711,255},
{31959,40410,38297,38297,42425,59196,59163,48730,46650,38264,42425,42425,38232,38264,48762,48762,42457,42457,42457,44537,44537,46649,48730,46617,38133,35988,27667,27668,33941,42198,36022,21427,15088,15120,17167,35922,42195,40082,25324,23244,23244,14762,4327,4358,4391,6440,4294,6536,8584,6406,10633,10665,10665,12713,10730,10633,10633,8552,12778,12876,8487,10698,12941,6440,12714,6407,10665,12810,8617,12778,12810,10698,14859,12778,10665,12746,10731,12811,14924,12649,12682,12714,10536,14793,12713,12713,12681,12713,12681,21131,22982,10568,21133,35857,31663,52858,59230,38033,19017,31695,46517,46517,46485,48598,44404,48597,44436,46550,40146,33710,35855,33774,37967,35855,35823,33742,31629,16937,4358,4391,25453,19146,21390,23439,23504,35955,42360,29715,14728,24869,43526,45607,45639,45671,45671,41674,48698,55102,40278,50908,44537,29811,53022,31957,40377,52989,38361,29714,27405,31663,33808,33938,35954,38100,40311,29583,25357,23408,25553,29615,36019,46585,31729,25390,31755,33927,27590,19205,12899,8677,4485,4485,227,2372,227,4453,15049,10791,6598,8743,255},
{34071,44667,38329,38297,46650,59196,59131,42490,40377,40344,42425,40377,36184,36216,48794,50874,44570,42457,42457,44537,44537,46617,48730,46617,36053,33908,31828,31828,35989,44278,33942,23507,15088,15120,17135,38035,44276,42163,25325,23212,23212,14794,8552,8584,6407,6439,4359,6471,8519,8584,4326,6472,13005,8487,8520,6407,6407,6439,8650,8552,6440,8520,8488,6407,14794,10600,10665,12778,12810,12746,12778,10730,12746,8553,6472,10633,8520,8585,12746,12682,12649,14794,10536,14793,14761,14761,12713,12713,12714,21132,16775,10568,14860,46486,46421,57117,57116,44373,25388,29679,44372,42259,46485,44437,38066,42292,38098,46453,33872,35855,35920,33807,35887,35855,35855,33742,33710,21130,8486,4293,21228,21226,10661,10662,4422,25227,50681,31697,12680,33418,45639,43722,43722,45639,45704,41837,55102,55134,57215,57215,57182,57150,57182,48698,52989,50876,33939,27470,29615,31728,40115,31695,29582,31695,31662,33743,40145,40048,23276,21260,44504,42424,27535,23309,35947,38055,36006,29636,25507,17123,6564,6564,259,2372,195,227,8711,10791,8711,12968,255},
{36184,46780,38297,40409,57115,61243,59131,42457,40377,40344,40344,40344,36184,38264,46682,44602,44569,42457,42457,44537,44569,46617,48698,46617,36021,29780,27667,31828,42230,44278,29781,23507,15088,15120,17135,35955,44308,44275,25357,25324,25325,23244,23212,21132,19051,21099,21100,19019,19019,19019,16874,16906,16971,14793,10569,6406,6439,8519,12940,8584,6439,6569,10698,12875,10763,12746,12811,12778,12811,10666,12778,10600,12714,14859,12746,12746,12714,10633,14762,14762,12649,14762,8488,14793,14793,14793,12713,12713,14826,19052,6472,8488,12812,38132,52825,57182,59230,50712,25421,21325,42260,40146,46485,42324,42227,38034,38066,42260,33840,31759,29743,31694,27468,33840,31727,33742,31662,31662,31597,27404,25388,31792,23275,17001,10630,14857,44276,27438,18986,39854,33288,39756,41707,41544,39822,44342,50908,42457,55102,46683,52989,53054,53022,55167,55167,57279,42327,27405,36052,44602,55102,33972,36085,46649,33971,38099,33905,31759,17002,21292,29842,25487,21261,23308,31754,40199,38119,36006,31784,17125,17126,17063,6533,4388,195,4453,4453,4388,4451,4581,255},
{42458,48795,36216,48795,63356,63355,61243,42489,40377,38264,38264,38264,36184,38264,42457,40409,44569,42457,44505,44537,46617,46617,48730,46585,36021,29748,23507,31796,42230,42230,29781,19314,15088,15087,17167,31794,33907,33875,23309,23309,23309,25358,23309,23277,21197,23277,23277,23277,23245,23277,21196,23212,25357,25358,16907,12745,12713,14793,12843,12745,12745,8519,12843,15021,8650,10730,8747,6634,10633,6472,6407,8488,8520,10665,10698,12876,10698,10634,10569,12681,14762,12714,10601,14761,14762,14794,14794,14762,16939,14859,10601,6408,17070,31826,52891,59262,59262,55036,31630,16937,38066,44373,46517,40179,44372,42259,44340,42292,40114,33807,29549,31662,29516,31694,29549,27403,25290,29451,27371,25290,21065,25454,33874,23373,19049,16969,31436,16809,27633,38100,12745,35987,35890,21033,35726,50844,48763,44570,40441,44537,48828,48795,44537,55134,46682,48796,29648,25324,23407,36215,44635,29941,50973,42619,40409,42424,34036,27664,17063,23434,15016,14985,17065,25511,25509,25476,36006,33865,29677,19242,17097,19178,12807,8647,8679,8646,4388,4259,4483,2532,255},
{46682,57148,36216,44602,63387,65402,61275,40409,40377,38264,38232,40344,36184,38264,40377,40377,44569,42457,44537,44537,46617,46617,48730,46552,33940,29780,27667,33909,40117,40150,29781,17234,13039,15087,19247,25554,17396,19217,17004,19116,19117,19117,19117,19117,19117,19117,19117,19149,19149,19116,19084,19116,14924,17004,14988,14923,14858,12778,12713,12778,14858,14858,14826,12778,12745,21197,23376,21231,10601,6471,4295,8488,6440,6472,10634,12876,8585,10698,8488,8456,14762,12682,12713,12681,12681,12681,12713,12714,16939,6440,6472,8488,21295,31794,55036,59262,59295,59262,40114,14857,25422,44373,42292,38066,42292,38098,44372,38066,44405,35985,29614,29646,29581,31694,29582,29549,23309,25487,29680,33775,21163,25422,36018,23274,21224,17000,21131,16906,29648,21164,10599,27698,23179,19181,36085,55069,40376,38296,19182,38295,27698,29875,42456,29877,48795,42425,25357,29517,31630,33840,31696,25421,40311,21229,25520,31795,19312,25549,23433,17126,10821,14981,19205,29732,27587,23393,29732,29670,10821,10823,17098,17098,12840,8647,12840,6534,195,4290,2499,2596,255},
{50875,61373,42522,38297,50842,65371,57115,38297,40345,38232,38232,40344,36184,38264,40377,38296,42489,44537,42457,44537,46617,46617,48730,44472,33940,31828,31828,35989,40117,42198,31829,17234,13039,15087,19215,27667,19346,23506,14891,14924,14924,14924,14924,14924,14956,17004,17004,14956,17004,17036,14924,14924,12779,14924,8617,19149,21197,19084,14858,14891,12810,10697,10665,8616,8584,21327,29911,29845,14827,10633,14826,12713,12746,10633,12811,17166,10665,12714,12649,8488,16908,10633,16940,12714,12714,12714,12714,12714,19052,8456,10568,14859,25488,36052,57149,57149,59295,61375,46486,21130,21196,44372,42259,42259,42259,38034,42259,40179,44373,31728,29581,27501,29582,29582,25453,27501,10566,68,6471,21261,8616,19114,27532,21225,23338,14887,14857,25325,27274,12713,27307,29387,18921,33678,44504,50843,36150,29812,21327,31924,19182,21391,25585,12940,38360,29681,29517,29616,31794,40180,29615,38001,31695,33743,38033,42161,27371,23402,19272,10821,15045,29734,29796,29795,27683,27651,21282,17154,6626,2370,6597,6565,8614,6566,8647,4486,2276,2339,4643,8837,255},
{48828,63486,48860,38265,52858,63322,52890,38297,40345,38232,38232,40344,36184,38264,40377,38264,44537,48762,42457,46650,46617,46617,48698,42359,33908,31860,29748,44277,42165,40150,29781,17233,15088,15087,19215,27667,19216,21328,12811,14892,14892,14892,14924,14924,14924,14924,14924,14924,14924,14892,14892,12843,12811,14924,6472,19149,21261,23342,19116,21197,21228,19116,17035,14923,14923,23375,27765,32024,14892,8456,23212,6439,10665,8552,6472,6472,6472,6472,6472,8488,16908,12682,19052,12746,12714,10633,10633,10633,23246,21004,18988,23213,27568,44472,57181,52923,57149,61375,50777,25324,19083,42324,38098,46485,42324,44372,38099,42292,42292,42260,33808,29549,31662,29549,31630,29549,21066,35,4326,29615,25388,25386,25418,25418,25420,19081,19082,35888,27437,21131,35887,29517,29648,57050,57116,50777,25586,17101,23472,27667,17037,33972,19084,25487,34037,27438,31663,38263,46715,48828,40376,52989,36052,31761,27533,25518,29646,23434,17127,19205,36038,33924,27618,23458,19265,29797,21317,12900,8709,8613,4419,2339,4387,4451,2468,2468,2435,12933,10917,10886,255},
{42554,59326,44635,36184,57082,65466,50842,38297,40377,36151,38232,42425,36184,38296,40377,38264,46649,52922,44537,48730,46617,46617,48730,42359,33908,29780,35956,46358,40117,38070,27701,17201,15088,15087,19215,27667,19248,19216,12779,14891,14892,14892,14924,14924,14892,14892,14924,14892,14892,14924,14892,14924,12843,14956,6504,17068,23342,23374,19116,21229,25390,21196,17003,14890,14923,25488,19247,25619,12714,12746,25260,4359,8584,6472,4391,6439,4359,4326,4326,4359,12714,8521,10666,12682,14827,12779,14827,14859,23278,21068,21133,44375,31729,52924,59230,57084,57149,61375,57116,31662,23374,40244,36018,42324,40276,44405,38131,42292,38099,42325,35921,25420,29614,25454,29614,27534,25324,2148,133,19181,35918,27465,23305,25387,25419,23305,14887,29679,40147,31695,35920,48631,48630,57083,59228,46486,14858,14890,23179,14793,21066,21099,16971,42294,23310,27404,27437,27568,44537,31891,42521,44602,36215,31794,36084,33939,17066,21322,19273,17191,33957,33987,27650,29763,25538,23427,10821,6596,8709,8645,6500,6500,4291,6531,2530,2595,4643,13030,8806,6692,255},
{44602,57213,42522,38232,61274,65498,52890,40345,40377,36151,38232,42424,36184,38296,38329,36216,48730,52954,46617,52890,46649,46617,48698,42359,33908,31860,42197,40117,40117,35989,27700,17201,15087,15087,19215,27667,21329,21296,12811,14859,14891,14892,14924,14924,14924,14924,14924,14892,14892,14892,14924,10731,8650,12811,8585,14955,21261,21229,17003,21262,23374,21196,14923,12810,14923,23440,19214,27699,10601,16939,27405,6471,8552,6472,6439,6439,4359,4327,4359,2278,2214,2246,134,68,10633,8521,14924,12778,8553,10601,29584,44505,42293,57149,48729,50777,61342,61407,57182,38001,16937,27535,46485,46485,44437,46518,42292,44405,38098,44373,33872,31662,29582,29549,27501,27469,29549,8454,68,8615,29579,23305,19048,29677,25418,21225,14886,21259,38099,31630,46420,46551,44437,52857,57050,33777,19051,19083,29420,35595,33482,37839,35921,44373,31631,31662,40180,29648,25487,25422,31858,31761,27502,35919,35952,25454,16969,36052,23502,15080,25606,29797,31876,27684,27651,21314,8707,6564,6629,4452,2339,2339,6371,8644,6692,6756,8805,8804,10918,10885,255},
{46747,57213,42522,42424,65499,65466,52890,40344,40377,36183,42360,48633,36184,40376,40377,38264,50842,55034,48730,52922,48697,46617,48698,40246,33908,29748,31828,31796,50518,31861,25620,17233,13039,15119,17135,19280,21360,19247,14956,23342,27503,19117,17004,12843,10763,12811,12811,12811,12811,12811,14924,6504,2278,4391,8552,17036,17068,17036,17068,17036,17068,19116,17068,17004,14923,21294,19214,29747,8456,21100,31599,8552,6504,4424,6472,4391,4359,4359,4359,4359,4326,4327,2246,2213,8520,8553,19117,16972,6472,19053,36085,44439,54971,50876,42326,48631,61342,61407,59295,44373,23340,31825,46518,42325,44405,42324,38067,40179,38131,42292,38099,33775,29646,31694,31727,31662,31662,18985,36,6504,35951,27531,25388,25451,21192,19080,12742,10760,19180,25486,50744,54970,40147,50744,50712,21164,19084,25292,35628,37708,33548,48664,50745,48632,50712,48632,46519,44406,21001,14695,21229,19148,25520,29778,21261,25422,35954,40344,21390,12934,19271,29798,27748,29828,25603,17155,6562,194,290,4516,6628,12902,12902,10854,12934,8773,6693,4516,4579,6690,255},
{44667,50908,44602,44537,65499,63387,52890,40377,40377,36184,42360,50745,36184,40377,40377,38264,52922,52954,46649,54970,48729,46617,48698,38166,33908,31828,29715,33876,50518,40150,25588,15153,15088,15087,17167,15055,15022,15054,15022,29714,42261,19182,8584,8551,4327,101,69,69,37,36,10535,12745,2278,6439,10633,17036,19149,19116,19149,17068,19116,19116,17036,17004,17003,19213,19247,36020,23181,27406,33712,12648,6439,6439,8519,6439,6504,10665,8585,6471,6471,6439,4327,4294,4294,4229,12778,14891,10601,23279,33972,50843,50777,52923,48697,44471,59229,61375,61407,52857,29581,27599,44438,40277,46550,42324,44405,36018,44405,42325,40212,31760,27534,29582,29744,31695,23341,27404,101,4357,29579,27499,19047,21192,19111,10661,8549,6469,10694,14952,40276,59195,42293,44405,35987,17003,19083,27340,39788,35563,35856,50777,48632,50777,50777,48664,46551,48632,29419,18822,16872,25422,21261,29681,25389,33972,44537,42457,21324,12903,17065,17129,12933,29797,23493,12965,10852,8708,8708,15014,12902,12934,8741,12934,10822,6564,6564,2370,2371,4514,255},
{40409,44570,42522,44537,63387,61243,52890,44537,40377,38232,42359,50745,38232,38296,38296,38296,52922,52922,48697,57050,50809,46617,48698,40214,35988,36021,31795,35924,50486,42198,25588,15153,15088,15087,17135,17167,15054,15022,12941,29715,36020,21263,8552,12713,12778,101,68,68,36,4,21065,16938,198,4391,8552,17003,19116,19084,17035,17003,17004,17036,17003,17003,21196,19213,25520,44538,23539,27470,35857,16809,6342,6342,10535,6438,6374,8520,6407,6310,6375,4294,4294,6375,4261,4229,6342,6407,16972,29682,27665,40212,46551,59197,52890,44471,57149,59262,61342,59197,33775,16872,29582,31727,29647,31728,29712,33840,36018,36019,36019,31695,29582,29581,29582,31695,29549,31630,6374,12774,29643,31691,27465,23272,16999,12774,10629,12742,16935,19112,31824,57050,48599,44437,25390,16971,21163,33516,25194,29354,42228,50744,50712,52858,52857,50809,50745,52858,42227,29484,29516,31695,29647,35987,35954,38165,46682,38165,23373,25452,23373,23407,21352,29799,25607,10884,12997,15110,15079,12934,12934,8708,8709,8741,6628,6629,6596,6531,4451,6499,255},
{36216,42457,44602,50810,63388,61243,54970,44569,40344,36151,42360,48665,38264,38296,38264,40344,52954,52954,50809,54970,50809,46617,48698,40246,38036,33908,31795,42165,44278,40118,25620,17201,15088,15087,17135,17135,15022,15054,15022,29715,29682,23408,21295,21262,16971,12454,2246,2246,2214,133,23211,14890,198,4391,10633,14923,19116,17036,17036,17036,19084,19116,19148,19116,19116,14955,23440,40376,19281,27471,35890,21067,6375,10536,10535,8423,10535,10535,8422,10503,10535,6374,8455,10568,6342,6342,12615,23177,23211,29648,27568,42325,48631,48795,44537,40310,48762,50810,52922,61375,40081,31596,35887,44307,40113,37968,33742,35855,31629,25356,25356,29550,25324,25324,23275,23276,23308,29549,18985,19080,25418,29643,23305,19079,19080,19080,12709,14823,21194,21193,29744,48663,59163,46454,19051,19083,25292,37708,33483,33613,50712,48598,50711,54938,52890,52858,52890,55003,50744,40081,42161,42226,42324,42324,44405,38067,40278,27600,23342,27502,23342,27601,27657,25607,21412,15107,17221,12998,10853,12902,10789,6628,6596,6629,10822,6596,2403,6597,6532,6532,255},
{36184,40377,48763,46650,59195,63323,57050,44537,40312,38199,40279,44472,38264,38296,38264,40376,57114,57114,55002,54970,52858,46617,48698,40279,33908,33876,31795,38037,35957,40118,25588,17201,15087,12974,15054,17167,15054,17134,15022,29715,17070,23408,27699,17167,10697,16550,2246,2278,2246,2213,14923,12777,2278,6472,12779,14923,21229,21164,21197,19148,19116,21164,19116,19116,23309,23309,21294,31958,21393,25358,31729,25260,10503,14696,12583,8390,12583,10503,6342,10503,8422,6310,10535,8455,6342,8488,16873,50644,50710,54772,31761,44373,48631,40245,46584,29779,31924,42423,48631,61374,46453,33774,33872,48598,42324,46453,40147,44405,42292,44340,42259,44373,35888,31727,31662,25388,25388,23341,27404,12775,27562,25385,19080,19048,19047,17000,14887,14855,21193,17033,19180,40277,59163,38068,16970,21163,29420,37708,33514,37871,52890,48631,48599,54938,52857,50744,54970,57083,57083,48500,48499,44371,50711,50743,46518,40245,33874,23342,27535,25422,25488,21261,27719,23526,19332,23589,13092,8806,12934,10822,6596,8709,4452,4516,8742,4484,2404,6597,2371,2307,255},
{36152,40312,57051,50810,59163,63323,54970,44505,42392,36119,38199,38264,38232,40344,38264,42424,57115,57115,57082,57050,50809,46617,48698,38166,31828,33876,35924,38037,38037,40118,23508,15120,15088,12974,15054,15054,15022,15054,14989,23441,23376,27634,23441,15086,12811,14826,2214,2214,2246,2214,14923,17037,198,2279,6440,6472,10698,8618,8650,8618,10730,10762,10730,12843,17069,19181,14988,12908,12974,21197,33809,29486,8487,14793,12680,10600,16873,12680,12648,14761,12648,12648,14761,12680,12648,14729,21099,42259,54936,56951,29680,36052,36085,33939,55004,29648,29584,52759,57017,61341,52825,35822,25420,46453,38099,48566,44405,46485,42324,44372,40179,44405,38033,31792,31760,27566,31694,17034,29582,16904,29643,27530,21160,16935,19048,21194,19081,14855,17000,17000,12841,27665,52857,23342,19083,23211,35628,37676,33482,39984,52858,50744,50744,57083,59229,52889,57083,57083,57050,42226,40113,38033,42324,50777,44471,40246,27568,25422,29615,23342,29681,23277,29769,19365,19364,19333,6755,10886,10854,10854,10822,6597,4484,4484,10790,4516,4484,6629,4451,2307,255},
{36151,38232,61243,59195,65500,59162,48698,42457,40344,36119,42360,40312,38232,38296,38264,44505,59195,57114,57082,57050,48697,46617,46617,36021,33908,40117,38036,38037,40085,42198,23507,15120,15088,12975,15022,19248,17134,15022,21231,29650,21328,25521,21264,6603,6473,14923,2246,2213,2246,36,14826,14957,167,232,4328,12811,17069,14957,12876,12843,12876,12844,10764,8650,8618,8618,10731,8586,6505,17037,42130,27406,4358,10664,10632,6536,12843,10697,6504,12810,10697,8552,12713,10632,10697,14858,25422,35986,52823,57082,36019,23408,21262,25520,48698,50778,55003,59131,59065,61276,57116,37968,31662,44340,46485,48631,46518,50679,44437,48566,38099,48566,38099,33743,31662,31694,31662,31630,33742,16905,17033,27498,23338,21161,16936,25453,27533,19080,14855,19081,12808,17099,33906,19051,21164,27339,37708,37676,35595,33580,46551,52857,57051,59262,61407,57116,59196,59163,52825,40114,33742,35953,42358,44536,42358,40278,25455,27503,29615,27601,42391,33840,38127,19367,15173,15140,13059,13029,10886,10822,6597,2436,8678,10822,8710,2404,4484,8709,6564,4387,255},
{34071,36152,59131,52922,65500,57114,44537,42425,38231,36119,46552,44504,36183,38296,36184,46617,59195,57114,57082,57050,48697,46617,46617,33940,31828,29747,29715,40085,40085,40118,23507,15121,15088,15054,15022,17135,17135,12973,19183,33875,17069,29682,21231,4,4327,17036,2214,165,2214,36,12745,10795,167,232,2215,8553,10731,10731,10731,10699,10699,10763,10731,10699,10699,10731,10764,10764,8683,14925,40050,21132,6407,8617,12745,6536,12843,12843,6537,10762,12810,6440,12681,10697,6569,16971,27568,31794,52790,57115,44405,25488,25456,25487,36085,52923,57149,52890,54872,59163,59262,42194,31662,38033,44340,42292,42259,42324,44470,46550,40212,44438,40180,33808,36017,33808,25389,33808,33840,25291,4390,21224,21225,21161,19048,21227,33873,29646,14887,19082,12840,19178,19115,21164,23244,33548,39789,37676,37676,27307,36019,52890,55003,57149,59261,59196,59228,61276,46518,35888,35855,40180,37971,42293,46617,38100,25422,29647,23309,36150,40441,38131,33936,8805,6724,13093,21477,10978,10950,8742,6597,4484,2404,4517,4516,4484,8677,4451,4387,4386,255},
{34039,36151,59163,61243,65499,61306,46650,40344,38199,38167,48632,44504,36183,38264,38232,46617,59195,57114,57082,54970,46617,46617,46617,33940,31828,27635,29715,42197,35956,40118,21459,15153,15088,15054,15054,19247,12973,12909,29617,42195,25423,35987,27569,10698,12810,14891,2213,36,4,4,8584,8618,167,232,4295,16940,14859,10731,12779,12747,12747,10698,10666,10634,10666,8586,8585,8585,6505,12811,35889,16906,8487,8552,12746,8617,10827,12875,8649,8682,12778,8455,10600,12810,6569,19051,29681,29681,52790,57049,52757,25488,27569,29681,25520,50842,59294,52858,44373,50810,63455,46453,33742,25421,48598,40211,48566,40211,48630,46550,46421,46485,42195,35921,29744,31727,19018,31695,27631,31662,4326,4422,23340,38033,29646,29614,31792,33839,19081,17002,14954,17034,19082,19084,29485,39821,39789,39756,37741,21067,31761,52857,54970,52857,57083,61309,61309,54970,42226,37968,40179,42325,42130,44439,46649,29680,25486,27567,25455,38199,27696,21354,12967,6661,4580,4612,15141,10915,4579,6693,6693,4548,4517,2404,4549,4549,8710,2404,4387,2402,255},
{34039,36151,61242,65499,65530,63386,50778,42425,40279,38199,48633,42392,36184,38264,38232,44537,57114,59162,57082,50809,44537,46617,46617,33940,31828,29747,38036,40117,35924,40150,21427,15121,15087,12974,15054,17135,12941,12941,29747,33842,19182,38100,27634,21294,19214,10762,2213,4,4,4,6440,4425,167,232,2215,10666,10665,6506,8554,8553,6538,8586,8554,8586,8586,8554,8586,8619,8586,14924,33777,10633,10600,6504,10665,10665,8682,12875,10794,8682,12745,10568,8519,14923,8617,23244,33874,29681,42356,48630,52756,27568,29714,38133,34005,40343,52923,48664,44373,52891,63487,48632,33742,31694,48566,48598,50711,44339,50711,44437,48598,42292,46453,29583,33743,31694,33742,33743,31662,33743,14760,68,2375,29680,21228,21292,23406,31760,23242,8519,19084,14890,25488,21164,35661,39821,39821,39789,37742,18954,29582,50744,59261,61309,57051,61341,63389,50679,38033,40179,38067,42258,46485,48698,36050,23403,17128,15080,21389,31988,23500,17159,10853,8773,2468,323,355,2467,354,386,2531,4613,4548,355,2404,2436,4516,2468,387,2563,255},
{34039,38199,63354,65531,65531,55034,52858,46617,38231,40247,44472,38264,38264,38264,38264,42424,55034,59194,57114,50777,44537,46617,46617,33940,33908,33843,42165,40085,35924,40118,19379,15120,15087,15054,15022,17135,12941,15022,21328,31795,19215,33939,21360,17069,17004,6439,4326,4261,2213,2213,6471,2344,167,2280,6375,14924,14891,16908,14827,12778,12747,12747,10698,10634,10634,10633,8553,8521,6473,14956,29584,6439,10633,6504,8553,12746,8649,10763,12843,6569,10697,14826,8584,12875,12778,33776,54904,33874,10730,12810,29583,21262,33908,40246,27666,40278,48697,44438,42293,57084,63487,40213,25388,27469,42293,46519,46519,46551,46519,48631,48632,50712,50680,48567,35888,37968,37936,37969,35888,35888,27372,16938,16937,25357,16937,10759,8614,19147,19051,4294,19051,17035,17164,35954,39919,33613,39887,37773,31533,21099,31695,50777,63487,59229,59196,61309,61276,44340,38033,42292,35986,33838,42390,42422,23434,17126,15078,15078,10885,12966,21353,17159,10821,4548,323,2404,2404,2404,2275,2434,4643,6789,6789,4645,2500,4645,4644,4612,483,4707,255},
{34039,36119,61274,65531,65499,46682,52858,50778,38231,40279,40312,38232,38264,38232,38264,42424,55002,59162,59162,48729,44537,46617,44505,33908,31828,40084,40084,35956,38005,40118,19347,17233,15120,15054,15022,19248,15022,17135,17134,29779,19215,31794,17102,17036,16971,8551,8519,8552,8552,8616,10697,2279,199,2312,4295,10698,8586,10666,10666,8618,10666,10666,8650,10666,12747,12779,10667,12747,10698,17101,23343,12746,14859,10665,6440,12746,10730,10665,14890,8617,8584,12778,10697,10697,14890,35986,63256,42226,16905,29419,27338,25357,36053,33972,17101,33972,42391,44439,46519,59230,59295,31761,25389,29615,44438,44439,44438,44438,46486,46487,46487,46519,46487,42294,29583,29550,27469,29550,29550,29550,29518,44406,46551,44405,40179,21194,10695,21293,23211,12744,16971,19147,8679,38295,33972,31860,36020,35987,33906,25357,27502,46583,57116,55003,61309,61309,54937,40114,42291,40179,31792,31792,40211,23434,19239,17159,17158,12933,8772,10885,21418,17192,12966,4548,2436,2404,291,2307,4259,2467,4675,8933,11045,8965,6853,4740,4740,4708,4708,6852,255},
{36119,36119,59162,65531,65531,48730,46585,52858,38231,40279,40312,38232,38264,38232,38264,40376,50810,57114,59162,50809,44537,46617,44505,33908,31796,40116,35924,33876,38005,38070,19347,17233,15120,15087,15054,17135,15021,17102,17134,23408,21295,35955,23375,14955,14858,8551,8519,8552,6439,8520,14858,10696,12744,14859,8553,19117,16972,16972,14923,14892,14892,14859,16971,16972,14891,12811,8586,8554,6505,17069,23473,34039,29846,10926,2344,8584,4391,23277,29550,25389,29616,19084,10632,8520,14891,40146,50578,37967,21164,54902,58998,46354,38101,31761,25422,33874,38165,40311,50778,59262,55036,29583,25389,35922,46519,44439,44438,46486,46487,46487,46519,46487,46487,35954,29518,27470,27437,27469,27437,25356,29582,33841,33874,33874,33939,33906,29615,12874,27469,25356,14924,23309,25419,23404,21292,17132,21326,27698,38165,23341,27470,42292,54969,54970,61309,63390,46485,40081,46518,36019,33938,38131,27661,17158,21352,19239,10852,4547,6660,6660,17192,12967,10855,4517,324,323,323,291,4387,4643,4707,11013,13126,11045,8932,6852,6852,6851,6884,11044,255},
{38199,38199,61242,65530,65531,57083,46553,48698,38231,42360,40312,38232,38264,38264,38264,40344,48697,57082,59162,50809,44537,46617,46585,33940,33908,35956,35924,40084,35925,35989,17299,17201,17168,13006,15022,17134,14989,15021,23376,27569,27601,21295,15020,17068,12875,25356,35823,29550,21132,21132,21131,27502,25455,12811,6440,14891,14891,12811,12811,12779,12811,12843,17037,19117,14956,17069,12844,10699,10698,17101,23474,31958,29878,15087,4424,8617,2311,29550,33775,25455,38133,29681,10599,10567,16939,46354,44240,44307,25390,56983,63322,61109,61078,56884,56885,54740,38099,29714,52956,61375,42391,27470,27469,40212,46520,46519,46519,46519,46519,46519,46520,46487,44407,31663,27404,25356,25356,25324,25324,23243,21130,21098,21131,21131,21163,21163,21228,6469,17034,27436,12746,23307,25417,21192,19112,10662,12710,19115,31892,12844,25389,42227,57050,55003,61309,59164,42227,42227,42260,29647,31792,29742,19240,21384,19271,10820,6660,10853,15111,10853,12967,8807,6662,291,2436,4581,387,386,2562,4707,6852,11077,13157,11045,11045,11045,8964,8964,11044,13157,255},
{40312,40279,63354,65530,65499,59163,54938,48665,38231,40311,38264,38232,38264,38264,38264,40344,46617,57082,55002,50777,44537,46617,46585,33941,33876,31763,42132,42165,35925,33909,19347,17168,17168,12974,12941,17135,15054,14989,23376,29715,29747,21229,14923,12875,17069,33808,42259,40212,29648,29550,29452,35889,21197,8520,10666,17005,17005,17004,14924,14892,14891,12843,19084,21197,14923,12843,12812,8553,8617,19182,25619,31958,29845,8716,4359,6504,4392,33743,29582,21261,27666,31762,14793,12712,25291,52691,40080,38066,31761,52790,63355,63190,63190,63190,61109,59029,52824,52858,59262,57182,29648,23276,27470,40213,40213,40213,42293,42325,44406,44406,44439,44407,40181,25356,23243,23243,23243,23211,23211,19050,31532,27241,20936,20936,18888,18888,19082,14951,8709,19081,6406,19113,21256,19112,19145,12775,8549,14856,23342,8584,35889,38002,50743,57050,59229,50679,38033,42259,35921,35954,27629,19239,17159,21384,15078,10885,17191,10853,6693,8741,10886,2435,323,226,194,2468,387,483,4707,6820,11077,13157,15238,13158,13158,13157,13157,13157,13157,15237,255},
{40377,42359,63418,65530,63354,48697,57018,48665,40279,42392,38264,38232,38264,38264,38296,40344,44505,54970,57017,52858,46585,46617,46617,33941,33875,29683,42132,42133,38005,31829,17266,17201,17168,12974,14990,19280,12941,10828,21296,25489,25488,27503,27503,17036,12941,19149,38067,36020,31728,31598,33645,40082,27470,12648,10633,12746,12778,12778,12811,14891,12843,12843,14924,19117,17036,14989,12844,10698,12875,23375,25619,31958,27765,4425,2247,6472,6504,35824,25389,17068,17102,31762,14825,10599,31662,52692,35887,37969,29616,46485,59195,59094,61109,61110,61109,56917,57116,57149,63455,50811,27502,21131,33841,38100,40180,38100,40180,40180,40181,40180,38100,35987,33842,27470,27437,25324,23244,21130,19018,19018,42096,33449,14630,16742,27209,29320,14886,8677,6564,2339,4293,19145,25482,21193,21225,17000,10726,14920,25389,27469,40114,38001,50711,59130,57083,42292,40114,40179,35987,42358,27628,17127,15046,17191,12933,8773,17191,10853,6660,4548,2403,8774,2371,259,161,354,451,2595,6819,8964,13190,15238,15270,15271,13190,11109,15238,15238,15238,15269,255},
{44505,46552,65498,65530,63322,44505,50777,48665,42360,42424,38264,38232,38264,38264,38264,40344,44505,52890,54938,52857,44537,46617,46585,31860,33875,31763,52501,42133,35925,29749,17266,15120,17168,12974,15022,17135,15022,17102,23376,29682,25488,35923,33810,14956,10795,19117,33842,27634,40180,35824,29420,29681,16971,14792,12712,12647,12647,10599,10599,10599,10599,10599,10599,10599,10600,10600,8520,8487,21262,25553,25684,29910,25652,4360,4327,4391,12778,37904,23308,33874,17069,29681,19050,12712,31695,44371,33774,39982,31663,40179,42358,46419,42225,44338,42193,46452,55036,57116,61407,44439,25389,21196,38100,35987,40212,35987,42293,38132,42326,40213,40181,33907,35955,31761,33841,33809,29616,29583,23277,25291,42161,44014,29386,27241,31434,29385,19014,10693,6500,8582,6404,10696,23371,27563,23369,19113,8582,12743,25388,42227,40114,42162,44340,61243,52792,40113,38034,33809,23440,31859,40244,25516,19209,15079,17192,15078,10853,8806,10822,8742,4516,2436,194,97,194,418,2595,4740,8964,13157,15238,15238,13158,15238,17351,15270,15270,15270,15302,17382,255},
{52922,50713,65498,65466,63354,46585,44472,48665,42360,42392,38264,38232,38264,38264,38264,40344,42425,52857,52857,50777,44537,48697,46617,33908,33843,40052,46293,35924,38005,29781,17266,17200,17168,12974,15022,17134,15021,15022,23408,29682,23375,35922,35922,17036,12843,21229,29649,29715,33972,29681,38035,14858,10599,10567,10567,10567,8487,8487,8487,8487,8487,8487,6439,6439,6439,6439,8487,6439,25554,23473,27798,29878,23506,2311,2279,4359,23341,31663,25357,42293,23309,29649,21131,12680,27470,46486,42161,44208,29550,42292,42357,42193,42193,40080,40080,50745,50811,57148,59230,35987,25389,23342,35955,23342,33907,27568,33874,29681,33907,31826,31794,33874,44307,27535,46388,40114,35660,27242,31500,31467,37871,44046,35693,35628,29419,31499,31596,27434,19016,12841,16904,10666,14955,29709,27532,21194,8518,10631,21226,42259,44275,42194,40146,57049,46485,35855,29484,29550,21164,27535,46552,33842,29679,19240,15111,17159,10886,6629,4516,6629,2371,290,291,194,290,483,2659,4804,11077,15238,15270,13157,13157,15270,17383,15238,13189,15302,17382,17382,255},
{63355,54905,65402,65402,65402,48697,46584,50745,44440,42424,38264,38264,40376,38264,38264,40344,42424,52857,52793,52825,46585,48697,46617,33941,31763,35924,37972,37972,40085,31829,17266,19313,19281,12942,15022,19247,12941,12908,21263,25521,23375,27536,25423,12875,10762,12875,21262,27699,27634,19215,21262,21066,16873,10600,10599,10599,10599,8519,8486,6406,4326,4294,2214,2181,133,133,101,2181,23441,23506,29911,29878,21361,4359,2247,6439,29680,25454,19116,27601,29681,27569,27470,14825,25357,46518,48631,27341,31728,42325,46485,40112,44273,37967,40113,57116,57116,61343,57117,31696,23308,33809,40213,42261,40213,42261,40180,40180,38067,38067,29616,38034,52725,37903,48500,35790,37740,22950,27273,20870,25161,31402,37610,20870,25064,31369,35595,27306,33710,8582,23243,21001,19051,31759,27533,23308,23277,21164,21258,42325,44307,42194,42227,48566,42194,35888,35888,40179,42358,46584,40213,29616,33840,25578,15080,12967,8774,8710,6661,4548,6629,6628,4516,290,354,2627,4771,8964,11109,15238,15270,13190,15270,17350,17318,15238,15270,17350,19430,19462,255},
{65531,65402,65402,65402,63322,46585,52825,56986,46552,42424,40312,40312,42457,38264,38264,40344,42425,50745,50745,50745,46617,48697,46617,35989,33876,33875,42165,38004,38005,29781,19346,15152,15087,15022,17135,21360,14989,12941,21295,25521,21262,29681,33809,10762,12843,17004,27503,38099,25521,14989,23342,42326,29681,16971,17004,14891,21230,17037,14923,14891,12810,12778,10698,8552,8552,4295,69,6375,21131,21426,29944,29845,21360,2247,2279,6471,29648,19084,12810,29714,29714,29682,31696,18953,25259,44405,44439,23180,38034,42357,46518,40146,44339,35920,42259,59262,61343,61375,50778,27502,25356,38067,40115,42261,35954,42261,33874,42293,33874,40181,29681,31728,31760,40146,46453,52726,46322,42063,39918,39885,35693,37740,41868,29192,25161,27209,33450,14596,31694,21161,14953,27403,31695,29616,29583,25390,27503,27503,31695,48599,44339,40081,44307,42194,40082,44307,38066,38099,38100,48730,35954,29616,31791,23435,19274,12999,10887,8742,355,6661,13000,8742,6661,355,418,4739,8965,11077,13157,15238,17350,17318,17351,17350,17350,17351,17350,17382,19462,21543,255},
{65531,65466,65466,65498,65434,48633,54905,59098,44504,42424,40312,42424,44569,38264,40344,42425,42425,50745,50745,52793,46617,48697,46585,35989,33876,29683,27635,31764,35925,29749,19347,15120,15087,12974,15022,17167,15021,12908,17134,27570,25456,35955,27535,10730,12843,14923,29648,25520,21360,15022,27568,36019,29649,25423,25390,29389,27535,27503,21262,21263,23343,23408,23408,14989,10763,12779,6278,6407,10632,27537,27700,23507,19215,23179,23146,25292,33841,25356,23244,40147,38100,29551,33808,25291,50545,48565,33907,29616,42227,40245,44503,38164,40277,36051,36052,55069,59262,61407,44406,27437,27502,42325,44471,46487,46519,46487,48567,46519,44406,42326,31729,31760,46387,46420,48532,56984,50646,50646,42227,54839,48500,46322,42194,42161,35692,33612,33580,33579,17033,6565,2340,10694,29713,29616,29616,25422,29616,31696,35922,46486,42291,42227,44307,44307,42194,46420,40146,31695,44503,48730,31761,29711,23466,15047,12934,15080,12968,6662,2436,4517,2404,2372,2435,354,515,8932,11077,15270,15238,15270,17383,17350,17382,17350,17350,17383,17382,21543,19495,21543,255},
{65531,65531,65530,65530,65434,48632,52793,59098,46552,42424,40344,42425,44537,38264,40344,42425,40377,50745,48665,50745,46617,48698,46585,35989,31828,29715,27635,31764,33845,27669,19346,15120,15055,12974,15054,15021,12908,12909,21295,29715,29714,44439,25488,10762,12843,8649,21295,15054,27600,25422,31729,38067,33842,23310,23212,31371,35921,37937,29616,27633,27569,25455,19149,10697,14891,19084,16679,14759,16939,42326,33742,25421,14955,46420,33775,42291,40147,52759,44307,50678,46485,44340,48598,40146,52724,42225,27535,31793,42292,42358,38165,38165,38165,36052,36019,52891,61342,57182,35954,27469,29615,42261,35955,40180,38100,38068,38100,38100,38133,40213,27568,25488,40146,31792,35954,54871,46486,54871,50678,56984,52791,54838,50645,52726,46322,35628,31434,37838,17000,4420,227,2308,14792,27502,29648,27503,29616,31761,35987,38033,33806,44339,44307,42227,46388,42227,42259,40114,52923,48665,29679,23465,19271,12934,4548,6630,8743,6662,290,323,130,162,290,386,2596,8964,15270,15270,15237,17350,17351,17351,17382,17382,19463,17383,19463,21543,19463,21542,255},
{65531,65531,65530,65530,63354,46552,50712,61178,48632,44504,40344,42425,42425,38264,40344,42425,42425,50778,46617,46617,46617,48698,46585,38069,33908,27603,46261,31764,33877,25620,19314,15120,15055,12974,17102,17102,12941,12941,19215,25522,23376,40246,31729,12875,12842,10730,19215,15119,25618,21294,31729,40180,35987,31663,29550,29389,29648,23342,19149,14923,12810,12907,12939,17132,21359,14988,12874,12842,19213,23536,21293,21293,19115,46420,40081,40146,44339,50678,44339,50679,46453,46485,50711,42324,50644,33774,29616,33841,33874,42326,25488,31794,27633,29713,33971,46585,61343,50843,29615,16970,31729,27568,36019,36052,40213,33875,40213,33907,40213,31794,21230,21295,29681,46387,44275,52759,48565,50581,44242,48468,44404,50613,37969,50678,42292,37773,37871,37740,33709,35789,16903,14857,23243,25194,23213,31696,27503,31761,35987,33807,31693,44371,42226,44340,46420,44307,42227,44438,57149,44470,21354,17126,21352,12966,10855,8743,4548,2403,355,225,162,290,386,2563,4739,11045,15270,13157,13189,17350,17382,17382,17350,19463,19463,19463,19463,19463,21575,23688,255},
{65531,65531,65530,65498,63322,44472,48600,63226,50745,46584,40312,42425,40377,38264,42425,42425,42425,48697,46585,46585,46617,48698,42327,35956,31828,29683,46325,33844,33877,25588,19346,15120,15055,12974,17167,21263,15021,12941,21296,23408,19215,35988,29648,15021,12842,10762,17070,19214,15152,14989,27536,29714,42228,52725,44340,27567,25486,17002,19115,19180,19115,17099,19212,23471,21422,17067,17067,14987,17164,21455,10859,8746,17101,44372,42226,35921,44372,48598,46420,52791,42291,48630,48566,44405,48630,31694,31761,31695,33613,40148,23245,33842,23278,33874,29681,42359,61343,48632,27437,25357,40180,38067,42293,40277,42325,33874,40148,29616,38100,17069,21295,21295,27568,48467,40081,40147,46387,33710,33514,35723,29419,27339,31500,44079,37806,33547,33515,37676,31660,29612,25516,21258,21129,22984,20938,29616,27503,31696,35987,38099,27532,44339,44371,44340,42259,46420,40146,50842,55069,38163,21319,21351,17191,8709,10823,15080,6628,2468,4548,290,258,2435,2563,4739,6852,13125,15238,17351,15270,19495,19495,19463,17414,19495,19463,19495,19463,19463,21543,23688,255},
{65531,65530,65530,65498,63322,42424,48632,63225,54905,48664,40312,42457,40377,38264,42425,42425,40377,46617,46585,46585,46618,46617,36053,33908,29748,31763,35956,33844,38005,27668,19346,15088,15054,15022,12941,17070,12941,10828,17069,27569,19182,31795,23343,12875,12842,8682,17004,23342,19182,15022,23342,25456,46486,46485,35954,29647,27534,25422,25422,23374,25454,25422,25454,23374,25519,23406,23374,21294,25519,25520,17101,17068,23342,40180,48533,40211,46452,46453,48565,50710,44340,50711,46485,46517,46550,35920,31761,35661,33385,31337,31337,31338,29289,29290,27209,31598,59262,40180,25389,25455,33874,27568,35987,31793,35987,36020,36020,38165,38100,19117,19182,19215,31761,54806,37935,29517,50581,44209,39788,33513,33514,33548,29386,39853,33482,25291,21032,37708,23240,12870,10789,6564,12837,16839,18921,29648,27503,29583,38132,44536,31693,42193,44338,31760,19149,42226,42292,55036,48729,27659,19238,12965,12934,8742,17161,12999,6693,2435,4548,2370,257,2435,4675,6852,11045,15238,17351,17350,17382,19528,21576,19495,19430,19463,19463,21544,19495,19495,21543,23656,255},
{65499,65498,65530,65498,65402,46584,48632,65305,61145,50745,40344,44537,40377,38264,44505,42425,40377,44537,44537,44537,46617,44537,33941,31796,29748,33844,40085,40085,35957,27701,21394,15087,15087,15022,14989,15021,12908,14989,17102,27634,21295,33874,21327,6633,14923,12843,17003,29713,17068,19181,23375,29649,48632,38099,35920,25421,19116,14923,12809,12906,14923,17003,14955,12907,17068,19149,19149,19149,19181,19182,14989,27502,44274,44307,48565,38098,46452,44307,50678,50678,44340,54872,46452,50710,48565,40146,31695,35726,25031,35661,42032,37806,35661,35628,31467,31468,55003,33809,25356,33809,44373,42260,42260,42228,38099,40180,33809,38068,36052,21229,14956,21295,27536,44372,46354,46322,46388,40082,31370,27112,31369,33385,31305,37708,46061,33579,35530,37675,25287,16998,8645,4419,6532,10501,29549,31696,29583,27503,33874,42425,29647,35887,44405,19149,14924,42194,48664,52923,40244,23465,17158,10885,15079,10886,17161,8741,6661,2435,2307,194,322,483,4707,8932,13125,15238,15238,15270,17382,17383,19463,21543,19463,19463,19495,19495,19495,19495,21576,21608,255},
{65499,65466,65530,65498,65434,50712,50680,65337,63257,52825,42424,46650,40377,38264,42489,42457,42425,44505,44537,44537,46617,46618,33973,29748,33876,33844,46293,40117,29716,25588,21394,15087,15055,12974,15022,17102,10828,12908,17102,23408,23375,29746,23375,12907,10794,8682,27503,27601,19116,27536,25456,31761,50613,40179,44339,23309,23276,19115,16970,17066,19051,19051,17067,17067,19083,19115,17067,14955,17133,17165,8714,31728,61110,52725,48500,35953,48533,42226,52759,46485,48533,52759,46452,50711,46453,44340,33840,31468,12712,27794,52923,50809,50744,48664,48599,46486,46552,29550,27437,40115,46519,46519,46486,46487,46519,46519,46519,44439,42262,29616,44275,25455,21295,46454,44340,50646,46453,39984,31369,27079,31337,27047,27177,27339,46094,31532,39821,37935,25320,21192,16999,6532,6598,14759,31695,29746,29615,27503,33842,31729,12809,25484,42293,25358,25389,44372,52923,46617,38098,29707,17159,10821,10821,8741,10887,10854,4581,2468,226,161,2435,2531,6820,11044,13158,15238,15238,15270,17383,17382,17383,19495,19463,19495,21543,19495,21576,21576,21576,21576,255},
{65466,65466,65498,65466,65402,50712,48632,65337,63225,52792,48665,46650,40344,38264,42457,42457,42425,42457,44537,44537,46618,46650,36086,31828,33876,38004,50454,35957,31797,25588,21394,15087,15054,12974,17134,23376,12909,12941,21295,23408,25488,25586,21327,10828,10762,8682,19149,27536,33873,40245,27633,33841,46420,38099,38067,31695,27566,25422,25390,23341,23373,23341,25422,23406,23341,23341,23342,21293,21229,21261,17068,35987,56950,52725,48532,38066,48565,42194,54904,46453,50646,50678,46485,52823,44372,48598,35888,27405,8584,25553,40312,40344,40312,40311,40279,40279,33907,27502,29582,38100,42294,42326,42326,44406,44406,44406,44439,44439,35955,29649,59064,33776,27536,46356,44243,44275,44275,35628,29289,29160,31403,27047,29257,29355,48304,35530,27274,31467,33578,31466,27338,21193,10695,21163,40212,29779,29615,29583,31696,33842,14891,31724,46416,44405,35887,44437,52923,40245,54971,42354,17160,15079,12967,15080,10822,4548,2467,4548,226,258,2499,515,8932,13157,15237,15238,15270,15270,17351,17350,17382,19463,19463,19463,19463,21544,21576,21576,21543,19462,255},
{65434,65434,65466,65401,65338,50712,46552,61145,61145,50712,46585,46650,40344,38296,42457,42457,42457,42457,44537,44537,46618,46650,40247,33876,33908,33844,48374,33876,29749,25620,21394,15087,13006,12942,17135,19215,12941,12941,19182,25455,25488,23408,14989,6569,12875,14891,14988,27568,35921,40212,29648,42261,42163,36018,35920,27502,21164,17068,14955,17035,17100,19181,19181,21261,19181,21262,21294,21294,21294,21294,21262,38035,42193,35920,48500,38033,46452,42194,52791,44340,52759,46485,46517,50711,44340,48631,35920,29486,21066,29714,36152,36152,36119,34006,31893,29812,29747,29779,25456,16841,21002,17003,17067,44439,50746,46585,46552,46520,31795,29714,52759,48500,31566,29224,25064,25064,25096,25096,20805,25063,22886,24966,22854,31631,50515,39723,27339,25227,39853,29256,8420,17000,21196,33873,46486,42228,33809,31696,29583,31761,21199,40138,54893,48763,33872,48729,52891,42293,61374,44568,27694,8774,8742,12968,12968,4580,8773,6596,225,386,2531,4707,11012,13125,15270,17318,15270,15270,15270,17350,17350,19431,19463,19431,17383,19496,19495,21575,19462,17382,255},
{65370,65402,65434,65401,65370,50744,44472,61113,65273,48664,44537,48794,38296,40345,42457,42457,42457,44505,44537,46617,46618,46650,42392,38069,35956,23475,27636,27636,27668,23508,19314,15087,15022,12941,19215,21295,12909,10828,21263,23376,27568,29682,27601,19117,14988,10730,12810,29583,39983,44406,27567,46519,44308,38066,46419,29615,21164,19148,17002,14922,17003,17003,16970,14922,17035,17035,14986,12841,12874,14922,12843,42227,54773,29549,46420,40146,46452,44307,50711,46387,52791,46452,50678,50678,42292,52824,29550,40016,33711,34006,36184,36152,36151,34006,31893,31860,27667,29779,21197,16743,16776,14824,10695,38132,52956,48731,44538,40247,25424,31795,44406,48566,40049,46159,33417,29257,25063,25128,16710,20968,16710,18823,16549,29551,42097,33450,29257,29192,31337,33417,27241,23243,29549,33841,40212,48599,42195,31728,27502,31696,33841,42258,38163,52891,48697,55036,48632,46616,46614,23501,15049,4516,8742,10854,4516,8806,4548,258,289,2498,2595,6852,11045,13125,15238,15270,15270,17318,15270,15270,17351,17350,19431,17350,19463,19496,19495,21608,21543,19463,255},
{65370,65370,65434,65369,65401,52824,44472,63225,65337,48664,46585,50875,38297,40377,42457,42457,42458,44537,46618,46618,46618,46650,40279,33908,31796,23475,31796,38037,23508,23508,19314,13007,12974,12942,23376,19215,15021,12941,21296,25456,25488,27569,40245,17101,4521,6601,12810,27437,35855,44438,40180,48631,48566,42227,44340,33808,23309,25421,23309,23341,23341,23341,23309,21293,21325,23374,21261,19180,19181,19180,19149,35986,56918,42161,44340,33775,33743,46419,48565,46452,52791,44372,50711,46517,46485,48663,33743,46257,42129,29780,21329,27732,23539,25619,25586,23409,25554,23474,21035,16776,16776,8551,2310,27600,48731,42392,44504,38101,19149,31794,50679,38035,25520,48468,46191,44078,46127,46159,41869,39788,37643,35562,31272,33612,33547,25030,22885,22886,24999,22951,20902,31597,40048,29549,35953,35790,44340,35921,27502,29583,33841,42325,33840,44535,55069,55068,38067,38164,29741,15015,10790,4516,4548,8741,4516,2468,2371,226,354,2531,4676,8932,13125,13124,15237,15270,17318,17318,17351,15270,15270,17350,19431,15270,17350,19463,19463,21576,19495,19462,255},
{65370,65338,65402,65369,65401,52824,44472,63257,65337,44439,40278,42423,36150,38199,38231,38231,40311,40311,42391,42391,42392,44472,38166,33875,33843,35923,40084,40085,31796,25587,21361,17167,17134,17102,21295,25456,17102,17102,21230,27536,29648,29616,40213,23407,10794,8681,19084,35823,33841,44405,42325,48663,48630,44340,35921,35888,25422,23309,23341,23341,23342,25390,25422,25454,25454,25455,25422,23374,25455,23375,25455,33841,56918,37968,40114,42161,35855,48500,48533,48533,52759,46452,52824,46485,48630,37839,35725,46321,40147,21329,21263,17135,21328,19182,25489,12812,25489,8488,18825,8454,14824,6598,228,25519,46650,38099,42326,35857,19149,29746,46486,27536,19181,42260,46127,41934,46160,46224,46160,41999,39756,39789,41934,35790,29256,22950,22853,29257,27046,33384,27208,37969,44340,38033,40081,31531,46420,38034,29615,27503,31729,38066,35887,40244,55069,50778,31728,31727,27629,15015,10789,10822,8708,258,2275,226,66,194,2466,2530,6788,10980,13125,15205,17350,17351,17318,15237,15237,15270,17383,17383,17383,15270,17350,19463,19463,21543,19463,19462,255},
{63290,65338,65402,65369,65402,54872,44439,63225,63225,38001,25388,27469,29582,29582,29582,29582,29582,31662,31662,31662,33743,33775,37903,39983,39983,44176,44176,44176,44176,44176,40016,35823,33743,31663,31695,31695,31663,29583,29615,31696,29615,31696,31761,29583,27502,27470,29583,33775,31728,35954,35987,38132,42325,38099,38034,31761,25421,19179,14954,17002,17002,14954,15019,14955,14954,14954,14922,12842,14955,10826,25487,38066,56918,44241,38001,44307,27501,48533,44339,52726,48598,46485,52823,44405,52759,35660,35660,46322,40181,14958,27634,12845,25554,17004,25553,12844,23408,8487,14696,10471,14888,6598,4356,25486,46617,50810,44440,25195,21229,27667,25521,21262,19150,40147,31305,27112,27079,29224,31369,29159,33385,31240,33353,31369,25031,20741,20740,20805,39820,33416,25193,40114,44340,37903,40081,33775,40179,42228,29615,25389,27632,31826,33840,44439,57019,40245,31728,27566,25515,15015,12871,15047,17127,2307,2275,226,65,290,2530,6724,8837,8868,8868,11045,15205,17318,15270,15270,15237,13189,15270,17350,15270,17350,17350,19430,19463,19495,19430,19494,255},
{63290,65338,65402,65337,65369,52792,44439,65273,61112,35921,27437,29549,31662,29582,31662,29582,31662,31694,31662,33710,33742,35823,35822,40015,44175,46256,46256,44176,46256,42096,46256,37935,33743,31663,31695,31663,29583,29583,29583,29582,29550,29583,29583,29583,29583,29583,29615,29615,29583,27470,25422,27503,38002,35954,33874,23343,19117,23342,17003,19148,17099,15019,17100,17068,17100,17099,19116,19180,17067,17068,31759,38066,58999,48467,35856,48532,33774,48565,42259,52759,48533,48565,52791,44405,50743,29323,29420,46322,36021,10764,29780,14957,27635,17005,23441,19150,19150,14696,8455,12583,8550,8678,21127,21224,40277,48731,46455,25064,23277,25554,25619,19182,23408,38132,31337,25193,20870,20935,25063,20902,31272,27078,24934,25030,22886,20741,18628,20805,41998,33481,23113,42226,40147,33808,35986,40114,40113,46648,35921,27535,29583,31728,40212,50745,50745,33874,29678,21354,12934,8709,15015,19207,10821,6597,19178,4483,225,6660,15078,19272,10885,8740,8739,8868,13125,15237,13157,15238,15237,13157,17350,15270,15237,13156,15237,17382,19431,19463,19495,21575,255},
{63290,65338,65402,65305,65369,54872,44439,65273,56951,33808,25388,29549,31662,31662,31662,31630,31662,31662,31662,33742,33775,35855,35822,39983,42095,46256,46256,48336,44176,44176,44176,37903,33743,31663,31695,31663,29583,29583,29583,29583,29583,31631,29583,29583,29583,29583,31695,31695,29583,27503,27503,29583,38002,35954,33874,19149,14891,10698,4359,23309,23308,21195,21260,21164,19115,19115,19082,17067,14954,14890,38000,35985,52758,48532,37968,50613,25420,48533,40114,54872,44339,50711,48598,46453,50679,35823,31565,46322,29780,14925,27635,19182,23409,25423,17102,23441,14891,16776,6310,12679,2373,17000,27433,19111,31825,48731,46487,29290,27405,23408,19182,23375,23440,31859,39984,23210,25226,33645,42030,31531,46094,31337,35595,35530,45931,33352,31304,35530,44046,41835,37674,39886,33677,23275,33776,44307,35887,46650,35921,31696,27535,29648,40246,40245,38132,33905,23434,15014,12902,21320,23400,19207,12934,14984,19178,6628,4515,12933,12933,15014,6596,2370,2467,4644,11012,11044,15205,15238,13125,15270,17415,17350,15205,15204,15237,19431,17382,17382,19462,19494,255},
{63258,65338,65402,65337,65369,54872,46519,65273,56984,35889,25356,27469,31630,31630,31695,29582,31630,29582,31662,33710,33742,35822,37902,40015,42063,46256,46256,46256,44143,44176,42096,35855,35823,31695,31663,31663,29583,29583,29583,29583,29583,29583,29583,29583,29583,29615,31695,29615,29583,29551,27503,29616,38034,31826,31793,19149,17068,14858,8552,17101,12811,12843,14956,15021,17036,17101,19149,19214,21262,21230,38033,31728,38099,35954,33841,50646,31662,46452,44307,52791,46420,52791,46485,48533,48631,42324,35888,42195,23442,21296,23441,31794,23375,29681,21197,29682,14793,18921,10567,12839,6565,19079,21160,14854,25453,50844,37970,27177,29453,25488,25456,25455,25489,27601,48533,37707,37806,48565,56885,44241,46191,33449,31597,27305,48142,25127,21162,27209,44046,31272,27306,25128,39820,10890,19050,42260,46387,42260,42260,33808,27503,31729,40213,33874,31793,27628,21287,19207,17095,21288,17127,15015,10790,10823,12903,17126,19239,17126,15046,10821,8708,6531,6466,8707,10979,11044,15173,15206,13126,15270,15270,15237,13093,13125,15237,17350,17349,17349,19430,19462,255},
{61178,63258,65337,65337,65369,54872,46519,63193,54840,35856,25356,29517,31662,31662,31695,31662,31662,31662,31694,31662,33742,35822,35855,40015,42095,44208,46256,44176,46256,44144,44144,35855,35823,31695,31663,31695,29583,29583,29583,29583,29583,29583,29582,29583,29583,29583,31663,29615,29583,29551,29551,29648,35954,31794,33906,19149,21294,17004,14858,14891,12746,12713,10697,10697,10633,8617,8617,8585,6505,8521,35887,40179,33874,29648,21164,50646,27534,40178,44307,52791,44340,54904,44372,52759,46518,42325,35921,38100,17135,27667,21361,46519,38035,35955,40180,38100,33842,33874,33873,31760,27534,27534,23339,21161,27534,48666,33613,25129,35890,27569,23408,21262,25489,23408,36052,52498,38001,38034,46550,50711,50613,52596,46322,50417,46224,48304,39950,41966,46191,41901,35693,31434,39820,19114,12841,35856,38001,31792,52857,42260,27503,31794,35987,29648,27598,25513,23368,21288,17127,12870,10789,8742,6597,8710,17127,19239,19239,15046,17095,12901,10788,8676,10627,10691,8867,11012,13092,15205,13125,13158,15238,15142,13029,10948,15204,15269,17349,17317,19462,19462,255},
{61178,63258,65306,65305,65401,59097,46520,59033,54872,35889,25389,29549,31662,31662,31662,31662,31662,31662,33743,33742,33742,35823,37935,40015,42095,46256,44208,44144,44176,44144,44176,37936,33743,31663,31695,31695,29615,29583,29583,29583,29583,29583,29583,29583,29583,31631,31695,31663,29583,29583,29583,31728,35922,27601,35955,27438,21262,19083,17036,17004,17004,14955,17036,19117,17004,17036,17036,17004,17036,17036,38098,40212,35954,25422,23309,50646,38000,40113,46452,50678,46452,52824,46452,52791,44437,46518,35986,31860,12877,29780,23442,52890,42260,42292,42325,40212,38099,40180,40180,35954,33874,35954,27468,19145,17065,38100,31370,27210,42295,31795,19150,23342,27569,23408,29746,50451,25390,44340,52758,54904,52758,59064,48565,58999,44242,56951,42194,56887,35888,46257,44274,44014,44145,31629,15049,31565,35791,25453,46616,50745,31729,35987,29681,27535,27564,25481,19207,15015,14983,17095,10789,8709,4484,8710,12935,15046,17159,12901,10821,6595,10724,8643,8676,10724,6627,8834,10979,17285,17287,17256,17159,17127,17062,10819,13091,17318,17317,17316,19462,19463,255},
{61178,61178,61177,61145,65369,59129,46520,56985,48599,31695,25389,29549,31694,31662,31662,31630,31662,31662,31694,33742,33742,35855,37935,40015,44144,46288,46257,46256,44176,44144,46289,37936,33743,31695,31695,31695,29615,29583,29583,29583,29583,29615,29583,29583,29615,31663,31663,29583,29583,29583,29583,33776,33841,27503,31729,27600,23342,21230,21230,21230,21230,21230,21230,21262,21229,21262,21262,21229,21229,21197,33874,31826,29713,29615,25422,48566,35920,29614,48565,46485,50646,52791,46452,54904,44372,48631,40212,36020,31729,27536,33940,55004,42260,44405,44405,40212,40212,42292,40212,38099,40180,38067,29582,31695,14952,23211,27209,25129,38068,38101,17036,25521,25520,23408,35988,39985,21230,38133,52824,48631,46453,59065,54871,59097,56984,59097,56919,59065,56886,52563,46225,43949,42032,37838,10825,25290,40016,27437,50810,54971,38099,33906,29648,29648,27564,21288,17127,12870,6597,15015,8709,6597,2371,8677,15014,15014,10788,8643,10788,15015,15015,15015,12869,10756,10756,8706,10947,21448,19240,17095,14982,14983,14853,12771,10947,15237,15205,15237,19430,19430,255},
{61178,59097,59065,59033,63289,59097,46552,54872,42293,31663,27437,29581,31694,31662,31662,31662,31662,31662,31662,33742,33742,35855,37903,40016,42095,46256,46288,46256,44176,42096,40015,35855,33743,31695,31695,31663,29583,29583,29583,29583,29583,29583,29583,31631,29583,29583,31663,31663,29583,29583,29583,33776,33841,29551,29551,25455,21294,10763,10763,12843,10763,12876,12844,12844,12844,12876,14924,14924,14988,12909,23342,35987,29713,27600,23342,44372,44307,31727,50645,46420,52758,50678,48533,54872,44308,50712,40180,38100,35987,50679,54971,52923,38067,40180,38099,35986,38099,38100,35986,35986,38100,36019,29648,38067,23275,21163,25355,29549,33972,38166,23343,27602,19149,23407,33907,35922,25488,27602,42390,54937,44339,56919,44242,52726,54904,54839,48532,48533,57049,46419,44112,39919,44047,44176,19243,21227,35791,40082,52923,55036,44406,31761,29616,31760,25515,21288,17127,19175,8709,10822,12902,10789,258,10790,15014,10821,12869,14982,14982,12902,15015,10822,12870,10789,10724,8675,12997,21386,15015,8645,8612,14950,14885,14883,10946,13060,13092,13124,15237,17318,255},
{61178,59065,56985,56953,61178,52825,46552,56985,46519,31695,29549,29581,33775,33775,33742,31662,31694,31662,31694,33742,33710,35823,37935,40016,40015,44176,46256,46256,46256,42096,37903,35855,33743,31663,31695,31663,29583,29583,29583,29583,29583,29583,29583,29583,29583,29583,31663,29583,29615,29583,29583,33776,35857,29551,29551,27503,25390,21132,21165,10762,8617,8682,6601,6536,6537,6537,4456,4488,6537,4489,10763,33907,33874,25390,23310,44341,46452,23308,52726,42227,56984,48533,52759,52791,46421,52824,40147,44373,36053,55069,55003,52890,50744,50712,48631,46519,44406,44373,42293,40180,38132,36019,31761,33873,23275,23243,19048,14855,19279,40311,27536,27634,25456,25488,21229,21230,27634,23408,31762,52693,46420,48467,43981,35725,39886,46159,48240,41999,48338,46289,50353,44080,44014,44177,29516,10825,31564,48566,52923,54971,40148,29648,29616,29647,21257,17064,17128,12903,4484,4517,12902,6564,4483,6597,14983,17127,17127,19208,17095,8708,15015,8677,8645,8677,8644,8676,17160,19208,17094,14949,23400,21319,19238,19236,19299,15140,13060,15205,15237,17317,255},
{61178,59066,56985,56953,57018,46552,46552,56985,46519,31695,29549,29549,33775,33742,31694,31662,31662,31662,33743,33743,33710,35855,37935,40016,40015,44176,46256,46256,42096,42096,40016,37904,33743,31695,33743,31663,29615,29583,29583,29583,29583,29583,29583,29615,29583,29615,31663,31663,29615,29583,29583,33808,33809,29583,29583,29583,29583,29583,29583,29551,27503,29583,25422,25390,25357,23309,27568,17003,21294,14923,12778,19117,42227,52627,44242,35955,40212,31727,44405,40147,48631,42324,48631,46550,46485,50744,42260,46551,42392,52957,52956,52890,54970,54970,54970,55003,54938,52890,52890,52857,50712,46584,44471,40213,29615,21162,8613,2372,10859,36151,27536,27634,25488,25456,44275,44275,25521,23408,38067,56853,46354,42194,46061,25128,31499,35692,48077,27241,31564,33612,48239,27241,31500,33580,39918,17131,31532,42227,52923,54874,38002,29648,27536,27503,29647,19177,15016,12903,8709,4484,15015,12934,10821,12903,21321,15014,15014,15015,10756,12902,10757,6565,6564,4451,8612,12902,19240,25544,25576,23463,21415,21384,12997,17190,15107,13059,13027,15204,15205,15204,255},
{61178,57017,56985,54905,54938,42392,46520,52825,48665,33808,25356,29517,31662,31662,31662,31630,31662,31662,31662,31662,33710,35822,37903,37935,40015,42128,44208,44176,44143,39983,39983,37903,33743,31695,33743,31695,31663,29583,29550,29583,29583,29583,29583,29583,31631,31631,31663,31663,29615,29583,29583,35857,33809,31664,29616,31696,29648,29615,31696,31664,29584,29583,25390,25390,31664,25227,21034,21100,23375,8520,10437,12583,42227,63223,52725,31794,25456,21196,31826,27601,36053,29714,36020,36020,29715,38133,31827,38133,34005,34071,48730,54970,52890,57083,57083,55035,55003,55003,55003,52890,52858,48665,44471,38132,25292,19017,12805,6532,2374,21295,31729,29682,25488,25488,50711,59032,25390,27569,33874,56951,48434,44274,48208,41771,41804,41836,48077,41804,39821,39788,50320,37675,35693,33613,46159,17067,25229,37936,52923,55003,35922,29616,27503,27536,31761,25485,19176,14983,12901,17159,17159,12901,12934,17128,19208,12901,12869,8709,8677,8677,6532,2275,6565,8581,6500,14982,23496,21351,19271,15078,10884,8805,6692,15078,10917,15108,13026,8866,13091,15204,255},
{61178,57017,54905,54905,52858,40312,46552,54873,50713,48533,40148,36020,36052,40181,40213,44405,40213,40181,40181,40213,40213,40213,33874,29649,29649,31729,29681,31761,31762,27601,25488,25455,23374,25422,29583,25422,23374,27503,33809,31728,27535,29615,31663,31728,25422,25422,29551,29518,29551,35856,35889,33841,31728,31728,31696,31696,31696,31696,31696,31664,29551,27535,25390,25326,29616,27308,25227,25293,29714,10600,10437,14663,38068,44438,38034,31762,25390,23244,31826,31761,33940,33940,31827,38166,29682,38198,27634,36053,27569,27601,48698,55069,38198,40343,42392,42424,44504,44504,44537,46585,46617,44537,42391,35955,25291,18984,14918,4484,291,10761,31827,25488,27601,38166,44373,61080,35889,21295,23375,48566,56919,54741,37643,31305,31305,35530,37611,31337,31338,35498,41934,37676,35531,35563,41804,37708,39822,42031,52858,52826,31729,29616,25423,29649,31761,31729,27596,21351,15045,17190,15015,10790,8741,17160,15015,12902,12934,8644,8644,10757,10757,6500,10790,8613,10692,21384,23463,19270,12998,8740,12966,10917,10885,6692,8805,10916,17252,6753,10978,15204,255},
{61178,56985,54905,52825,52825,40312,46552,54873,52793,61145,44505,40345,40377,42458,44570,50843,44570,44538,44538,46618,44570,44570,31861,25555,27603,25555,29749,27636,25621,21427,17201,15055,10861,15022,23408,12941,12941,14989,33810,33874,21230,25456,27471,25456,6602,17003,21100,14761,23180,52793,50679,31793,23342,35954,33874,33842,14988,21229,27536,23310,33711,29583,31728,25390,23212,14923,14956,8617,12843,14826,18986,23180,38133,31762,31729,31794,27502,29648,31794,38100,31794,38133,31762,38165,31827,33972,33907,31795,33907,38101,52989,48764,36118,38232,38231,40280,40312,40312,40312,40312,38199,36119,36054,29617,23310,19049,12838,4484,260,4423,31826,25423,29747,31828,38067,52759,35922,19182,25455,52792,52825,48371,37773,37611,39854,39724,35596,35563,35596,39821,39854,33450,31370,33450,31500,8745,22951,31630,50810,50648,29583,27535,25423,29648,31729,36020,36016,25513,12933,10853,10822,6629,6629,15015,10822,12935,10789,10821,10822,12870,6564,6532,8613,2339,19207,25576,19238,8740,10885,8772,8773,10886,12966,2403,4579,8836,4546,2369,8867,19334,255},
{59098,56985,54905,52825,52825,40312,46552,52825,54873,61176,42424,38264,40345,42425,44537,48762,44537,42457,44505,46586,46618,40345,29748,27603,25523,27636,27668,25588,27668,21459,17201,15087,12942,15022,21328,12909,12908,17101,31729,35954,23342,25423,29584,25488,4489,21164,23211,25162,29421,50745,46486,27600,12875,19214,17069,29648,19083,16970,21229,19116,29616,29616,25423,25358,14793,4359,2245,2244,6471,14857,17068,25423,38101,33874,29681,31827,27469,33874,31728,42326,27601,40278,31794,38133,35988,31827,38166,27601,36053,50844,55102,42392,23442,29748,27668,27668,29813,33974,31861,31861,31893,31861,29683,27503,27437,23210,12742,8613,4356,8581,29713,29649,29747,27601,42261,50647,25423,25456,40180,56986,56986,44015,37643,37578,37644,37611,39756,35563,37709,44079,39854,35596,35596,39790,21163,14921,25226,40082,44504,44407,31663,27470,29616,27568,35987,40213,27630,25515,19207,17158,19240,15015,19239,15047,12935,10823,6597,10790,8678,6565,2371,8645,10758,4420,15047,23497,17126,10821,10853,10886,8741,6661,2403,4515,6692,6659,2434,2402,6754,13093,255},
{59098,57018,54905,52825,50777,38232,46552,50745,54905,59097,44505,38264,40345,40377,42457,46650,44537,42457,42457,44538,44538,34007,29748,25555,25523,27636,33877,27668,25620,21427,17201,15055,12942,15022,17102,12909,12908,14989,27568,35954,23342,25423,33809,33907,8650,21164,23212,18921,25260,48632,42293,21261,17035,19214,12843,23276,23276,19115,21357,25390,25423,27504,19084,19052,21197,21263,6504,6472,6504,19084,21197,12811,31859,33874,31762,29714,23342,33907,29681,40214,31794,36053,33939,33907,38133,31794,38166,29682,40279,48796,46683,36086,21264,23442,25522,21296,21296,25522,23377,21263,23376,23409,16940,27437,25357,27372,16903,10629,12741,8580,21293,33842,25520,38068,50711,40148,21230,29714,48567,52793,48501,37709,35531,35531,33450,39724,37676,35531,37644,41934,39756,35499,37579,33483,10793,16807,33678,42326,48697,35922,29582,25390,31729,31729,40246,36019,21259,19208,19271,19270,15046,12967,19240,10854,4517,4517,8678,6565,4485,8710,10790,8645,4452,12903,14950,14982,19240,15047,8741,8741,4516,323,4516,4515,6692,10885,4579,2401,6754,11045,255},
{59066,59066,54905,52825,50745,38232,46520,48665,52825,59065,44505,38264,40345,40377,42457,46618,44505,44505,42457,42458,44538,33974,31829,27668,23475,25555,33909,27668,27669,21427,17201,15055,15022,15022,17102,12909,12940,19182,31729,35922,23342,27535,35856,31858,8714,21196,25195,16808,23147,46519,44405,23406,19181,21262,10793,19082,31662,8648,17068,23277,25423,29649,21197,21132,21230,25456,10731,8585,12778,23245,21035,14761,23278,29714,33907,23343,10666,31794,27601,36053,33940,31827,38165,33907,40246,31827,36021,33907,48699,46651,40310,29747,23409,23376,25522,25522,23409,25489,25522,23408,23376,21329,25293,31662,25389,29517,23177,18952,14790,4356,10697,35955,23408,25553,29811,23375,21262,33907,54905,50712,39951,37709,33515,33483,31435,39855,33581,35563,35693,39854,31435,33483,31371,27372,6632,21064,35856,38100,40181,35921,25389,25423,31761,40180,38100,31729,29648,35985,27627,15046,8740,8772,12998,12967,6629,2372,4517,10791,10790,6597,8678,4517,17128,21289,17031,19144,23434,15047,15080,8774,4580,8773,12934,4548,8741,8740,2467,2465,6787,11045,255},
{57018,59066,54905,52793,50745,38200,44472,48665,54873,59065,44505,38264,40345,42457,42457,46650,42457,44505,42457,42457,44538,36119,31829,27668,21395,23475,25588,25588,27669,21460,21362,15055,17135,15022,14989,12908,14989,17101,33842,35922,21262,29551,33809,31762,6601,23244,25260,21099,33679,38100,46486,25455,17100,19181,12873,17001,27534,8615,17035,25357,31567,33810,29551,27471,27503,23343,16971,23244,29549,37904,35694,37806,37936,31794,31859,21262,21197,31794,31794,33907,38133,29714,40246,33907,38165,33940,31827,38134,48764,40343,36052,23442,25554,23441,21329,25554,25522,23409,25457,25489,23344,17038,33678,35823,25389,27469,31629,21097,14790,10629,14857,31632,25456,19182,19182,21230,23342,44406,52760,48567,50614,46323,50484,44146,48371,44146,46226,44145,41967,37773,33515,33483,33548,14922,21096,33645,42260,31696,21163,31695,23309,29616,44373,44406,31761,38034,29649,31761,44404,27564,19175,10852,10950,15048,4550,2437,260,2372,6630,6565,2404,4518,17161,19209,17032,19145,14983,10758,12967,10887,6661,15080,6694,2468,4580,2467,419,4675,8900,11044,255},
{57018,59066,54905,52793,50745,38232,44472,46585,52825,61145,42425,38264,40345,40377,44537,48730,42457,42457,42457,42457,44538,34039,31829,27668,21362,19314,21427,25556,27669,21460,21395,15055,19215,17135,21295,14989,15021,17069,33874,27568,19149,23310,35922,38100,10795,19083,23244,29615,31598,29583,44405,23374,17035,27469,25356,23275,25324,27470,35921,31630,31598,31697,29615,29615,27470,25423,19116,10696,16970,21197,25390,21131,27438,31794,31859,14924,25423,27601,36052,29714,38133,29714,38133,35988,35987,38133,29682,38166,38198,36053,36021,19216,25522,25522,23377,23409,25554,23409,23376,23409,23409,16973,42031,42031,23309,25356,31663,25387,14853,16936,31598,29291,25455,21263,29714,17069,25488,50647,50680,50680,50745,50712,54873,50647,56954,50647,57051,48566,39887,35726,35628,33549,29517,8778,14824,35889,38067,14891,16938,27470,25423,35954,54937,42260,33874,38034,29616,27536,40180,46518,42290,19175,10983,31857,12935,8710,4485,6565,4517,6597,4517,356,6630,12935,10822,12935,6693,8741,10887,10918,2596,6757,6725,6725,10918,4676,2563,6787,8932,11045,255},
{57018,59066,54905,52793,50745,42392,44472,44505,52793,59065,42425,38264,40345,42457,44537,48762,42457,42457,42425,42457,42490,36119,29748,27636,19314,25523,29717,25588,27701,23508,21362,15087,23408,19215,19183,12941,15021,19150,31729,29616,21230,23310,33874,33972,19116,14922,17003,27568,27341,35921,46518,25487,31630,37806,35758,25324,25259,25291,25291,23212,23244,31697,23211,21131,16938,27471,25358,10630,14824,16939,14826,21131,19051,31762,31795,12778,29649,27536,40246,29681,38165,33875,36020,38166,33907,40246,29682,42359,29714,29616,33941,19216,21329,25522,23441,21296,25489,25522,21296,23344,23344,19085,46159,44111,29615,31696,31663,27500,25323,29582,38033,19146,25422,27634,31860,23408,35987,40081,31729,33808,25422,31664,29583,29648,33842,31761,35987,35889,33613,29420,31468,33516,25292,21066,29485,40180,29616,4360,19018,25422,29616,44405,56986,48567,38068,29616,33841,25422,29681,48665,52858,44438,33937,36051,29711,17129,8678,6598,4517,4485,4580,2531,2532,4580,6692,4612,2563,4676,4612,2563,2595,6788,10949,6820,8901,6788,4707,6820,11012,11044,255},
{54938,56985,54905,50713,50713,46585,46553,44505,50745,56953,40344,38264,40377,44538,44537,48762,42457,42457,42425,42457,42458,34039,27668,23475,23443,27636,29749,25556,29749,23540,23474,17168,27569,23344,15021,14989,15021,17102,33842,29681,23375,21230,29681,31761,23374,21196,27502,17003,18922,40116,48631,23406,25421,33613,29452,27438,19084,25291,23211,19051,14826,16841,16776,18987,12777,23211,25324,21098,21098,21098,19018,10664,10630,31761,27602,17004,33874,29648,36053,31794,33907,36020,31794,38165,33907,36053,33907,33940,25487,25195,27602,23409,21264,23409,25522,23376,23376,25522,25489,21295,19151,27438,46159,44112,29583,29615,27470,27503,21197,19114,19143,12870,21292,27634,27666,25488,46421,50581,46355,40017,35791,35824,31533,31598,31565,23211,23308,23211,12679,19082,21033,17036,6665,6307,29615,42260,25390,19051,23277,21229,31761,46453,56922,52663,35922,27535,35921,27503,27536,38165,55036,55036,52858,46584,44504,42325,31791,23403,19144,12903,12967,10854,8741,10855,10823,6725,4643,8805,8868,6787,6787,6819,10980,11012,8932,8932,8932,11044,15205,13157,255},
{52825,56985,52857,48633,52793,50713,46552,42424,50745,56953,40344,38264,40345,44537,44537,46682,42425,42425,42425,42425,42458,34007,27668,23475,23475,25556,27636,27669,29781,25588,21394,17135,19248,17134,12941,12909,14989,14989,33810,29616,25455,21230,27536,29681,17036,14923,29582,31565,31532,35823,37968,31629,31597,31565,27371,29517,29517,35726,27176,27176,25096,23048,23048,23048,23048,23017,23048,20968,20968,20968,20968,18855,16775,29649,25456,19083,33875,31761,33940,36020,31794,40246,31794,38198,36020,33907,38133,27634,33907,31600,21296,23409,23376,21296,23409,25489,23344,23376,23409,21296,14958,35824,46159,39853,27145,29323,27210,25227,27601,21321,21255,10788,14985,27634,19214,25488,52727,48566,54873,52792,54873,52695,52760,52695,52695,52727,44178,33548,29257,29322,29225,23244,14984,19047,33873,35954,25357,29550,23277,27503,44373,54840,56759,52500,42195,29584,33809,31729,27535,27568,40278,50810,55036,52858,46552,46617,38100,44373,44340,40212,42260,38065,29646,27501,27501,25419,25482,25483,23401,21320,17222,15142,15175,15143,11014,17354,15176,13063,13094,17288,255},
{52825,56985,52857,48665,54873,48665,44472,42424,52826,54905,40312,38264,40377,44537,42425,46618,42425,40377,40377,42425,42458,34039,27668,27635,25555,25556,27669,27669,29781,25588,19281,15055,15087,15022,12941,10828,12909,17069,29681,31729,25455,21198,25423,29713,21262,23309,21099,31565,27372,27371,31596,31597,29517,31597,31629,35823,33808,41966,20837,20871,16742,4,2116,2116,2148,2148,4196,4197,4229,6277,6309,8357,8390,14925,17037,19085,23343,25456,29617,29715,29681,36020,33875,36020,38133,33907,38166,31794,38166,33876,19215,23377,23409,21296,23408,23409,23377,21295,21264,23344,19151,42031,48239,37611,29193,29226,27112,25260,36149,17094,12901,6596,12872,23375,19182,38035,54840,52727,46324,44211,48404,46323,50549,48436,50582,52728,42032,39821,35596,37807,33613,12874,16967,27500,35921,27470,25389,27437,21229,31696,52792,54710,56563,60691,50517,31729,29616,35921,29616,27536,27568,31826,42359,44504,46552,46552,40245,44438,48599,46519,48599,46486,44373,40114,38002,42162,44307,44307,46419,46452,44339,42258,42258,40210,40209,38128,31854,27660,25547,29774,255},
{54906,56986,50745,50713,54873,46584,42392,42424,50778,52825,40312,38264,40377,44537,42425,46650,42425,40377,40377,40377,42458,36152,27668,27635,25523,21427,23508,25588,29749,25588,17201,15055,15087,12941,12941,12909,12908,21230,29681,27536,25455,23278,25390,27568,15020,25358,14663,25194,27339,29451,29484,27372,29484,27372,31597,29648,31631,41998,25030,22983,25031,8324,8356,8324,6276,6276,6244,4196,4164,4164,4164,2084,2084,2084,2117,2117,37,69,21002,10633,19117,17004,27438,27438,23245,19051,23309,35921,33809,40148,27601,17070,17103,19150,21263,17103,21296,25489,25424,21231,27439,44079,46191,31305,29258,29193,27145,23244,27600,17095,14983,12838,12904,23342,27666,48599,48566,42097,35661,33516,37676,33580,35628,33580,37709,35694,39919,35629,37677,35629,31500,23275,27306,38002,38035,25357,29550,23277,25390,33841,52759,56596,58677,60758,54678,35954,27536,31729,29681,27568,27536,27536,27568,29616,27568,27568,31794,31793,33874,36020,31761,31761,31826,31761,35954,38034,38034,44404,44339,46420,44306,42258,46452,44404,54904,52792,50711,50678,50710,52888,255},
{52857,56986,48697,46585,52793,44504,42392,44473,54938,52825,40312,38264,40345,42457,42457,48762,42457,40345,40377,40377,42457,38232,27668,25555,23475,23475,25588,25556,27669,25620,19281,13007,15022,12941,12909,12941,12876,17069,33842,25456,25391,25326,29551,31729,14988,23277,14663,27306,29452,31565,33677,33677,31630,33678,33776,27601,29518,44079,27111,18790,25064,4196,6277,6277,6309,8357,8357,8389,8389,8389,8390,10470,10470,10470,10470,10503,10502,10438,23082,17004,17102,25358,29551,27470,27437,21131,19018,23276,35855,44340,35988,14826,12749,12907,21294,10666,10764,29714,35987,19116,31597,44111,44046,29160,29258,27112,31467,27405,27503,38132,29614,35855,25420,25422,31794,54873,56986,44145,37643,35531,37579,37643,39724,35531,35596,39854,39822,35596,35628,35661,39789,37773,39984,42228,27502,25357,27470,23309,27471,31761,44373,50452,52565,56693,52597,35954,31729,27536,29681,29681,29616,27536,27536,27536,29616,27536,27503,27503,27535,27535,27503,27503,25455,27503,25455,27503,27567,29648,29680,29714,31794,33906,36018,42292,46551,44437,46550,52889,52889,57050,255},
{52825,59066,50777,44472,50713,42424,40344,44505,61210,59065,40344,38264,40344,44505,42425,50842,42457,40345,40377,40377,42457,38265,25588,21362,23475,29716,25588,23508,25621,27701,19249,12975,12974,15022,12941,12909,14957,14989,35987,31729,29648,38002,37775,27568,12843,21099,16744,27306,25258,29451,29516,29484,27372,27404,27372,29648,31631,44079,29223,20903,27176,4164,4196,4196,4164,4164,2116,2084,2084,36,4,4,4,4,4,4,4,4,16809,8423,6473,19085,25390,29550,31663,27437,21196,23275,42194,42195,37970,24741,33219,21191,23373,14891,10698,27536,31729,19084,33645,44079,39788,27080,29192,29257,35726,23277,23310,38231,33874,44308,38002,29616,40148,54873,54807,39821,35530,35498,35498,37643,37611,35466,39756,41934,37644,35531,35498,37612,39757,37352,39985,42423,23277,27470,25389,25422,25390,33906,38100,33906,35987,38067,40147,35954,33841,29616,29616,29649,29681,29681,29649,27568,27568,27503,27471,25422,27535,27536,27536,27536,27568,29648,29648,29649,29649,31729,29648,27668,23605,36250,27568,29615,31761,33874,33874,35986,36019,40212,255},
{52793,56985,54905,44473,46585,42392,40312,46553,63354,61209,42425,38264,40344,44505,44505,55002,44537,40345,40377,40377,40377,38265,23507,19314,21395,23508,23508,23540,23540,29781,17201,13007,12942,19183,12909,12909,12941,17069,35987,31697,27535,29746,31696,27601,17003,23212,20969,33645,33645,33709,33677,31597,33677,33677,33677,31662,29550,42031,29191,20903,27176,16710,16743,18791,18791,18823,18823,18855,20904,20904,18856,20904,20936,18856,18824,16776,16743,16743,23049,20936,12551,8455,16808,27437,27503,25356,19083,27531,42193,42130,46356,32999,33217,25254,19343,21229,12843,27536,25358,21164,37805,44079,35531,27080,29224,27209,29485,21165,25424,33973,33809,44308,40115,33809,52760,52760,48371,37676,35530,37709,37611,35628,37611,39822,41967,41999,37644,35531,35531,37676,33482,31467,44472,36053,23309,29582,21229,23342,27503,29648,33842,27535,29648,31729,31761,31729,29649,29649,29616,29649,31729,31729,31762,31762,31729,31728,29584,27503,27503,25455,25455,27503,27503,27536,29616,29648,31729,31729,31761,27568,21295,23473,25423,33874,35954,35987,38067,38067,33841,35922,255},
{50745,56985,54905,44505,44505,40312,40312,46585,65466,61209,42424,38264,42425,46585,46617,61242,44537,40345,40345,40377,40377,40377,23540,21394,19314,17266,23508,21460,21460,27701,17168,13007,12942,15022,14989,12941,10828,17101,36019,31696,23277,21262,21295,23407,17003,21132,21001,31532,27339,29484,33677,29484,27404,27404,29549,25324,33711,37806,25031,14662,23016,3,36,35,3,3,3,36,68,2149,2181,4261,6406,2246,2214,2182,2214,2214,14728,14695,6374,6342,16743,31630,31696,29583,25420,21288,40113,40049,46453,17329,4716,6701,15346,23277,17069,23375,23310,25390,42064,46192,31305,31338,29192,29322,25324,33907,33940,27601,38100,42227,42227,25453,36053,42228,35660,33547,31435,33678,33581,33515,31370,33580,35725,35628,33483,33483,35563,35595,29288,33646,40279,27568,25421,19176,12903,17066,27535,27502,27535,25422,29616,29616,29648,29648,29616,29681,31729,29649,29681,29649,31729,31762,33842,38034,40049,38001,37936,35856,31695,29615,29615,27535,27568,29616,29648,29648,31729,31729,29681,29616,31761,33874,33874,33874,35987,35987,35987,38068,255},
{50713,54905,54905,48633,44472,40312,40312,46585,65465,61209,42392,38264,42425,44537,46617,63323,46617,40345,40377,40377,40377,40377,23508,19314,19314,25556,25588,21460,23573,25620,17168,13007,12942,12941,15022,12941,12909,17102,33875,31696,27470,21229,25391,27536,14923,25391,21001,31564,29484,31597,29452,31564,29484,27372,29517,27372,33711,35725,25031,16743,23016,35,4228,2148,35,35,3,3,35,68,69,4229,4294,69,69,36,69,68,14696,10502,2213,2181,18888,35823,31696,31696,21194,19207,40113,40081,48501,21588,4880,8880,21329,31762,23408,19181,27536,31793,44177,44046,29225,31273,31273,29452,23277,34038,36119,29681,31794,35921,25386,19081,33908,31697,27208,33613,33678,31860,29681,21129,14824,23211,14792,18953,10599,19018,25324,31499,31433,25325,16874,25390,23337,17061,12900,6628,17033,29549,29517,31696,33809,33809,31729,31729,29681,31729,31762,31762,31762,29649,29649,29648,29649,27600,27600,29649,29648,31695,33776,35888,37968,40048,38001,38001,37969,35921,33841,33809,31761,31729,31761,31761,31761,31761,31761,33841,33842,33842,255},
{48665,54905,54905,48633,44440,40312,40312,46585,65497,61209,42392,38264,44505,46617,46617,61242,48697,40345,40377,40377,40377,38297,25588,19282,23475,33877,25588,21460,27701,25620,15120,13007,12942,12941,14989,12941,10828,21295,38068,29616,21229,17069,19117,21294,12875,25391,21001,31565,29484,31564,27371,27372,31597,27404,29517,27405,35791,39918,27111,22983,27176,16710,18855,18823,16710,16710,16678,14662,14630,16711,16743,18823,16776,12583,14630,12582,12583,10502,23017,16743,8422,8389,20968,31663,31664,33809,27532,17094,38033,42227,48533,27828,4782,25101,39341,40020,29714,17068,27536,35987,40016,39788,29225,29192,29257,19018,10666,23409,25456,29616,29616,21258,19242,23309,31827,29616,27307,37937,31663,33940,29551,29419,27403,27371,25291,23178,18952,16905,27503,35889,37903,18922,14729,27502,23337,19207,12932,8707,8708,23304,23401,29709,40146,31728,35954,38034,35954,33874,31794,31794,33842,31762,31730,31791,23401,19209,17128,25455,25423,23309,23309,25422,27503,27568,31729,33841,35921,38002,40114,42194,42162,42162,40114,38034,35953,33874,33842,33842,33842,31761,255},
{48633,52825,54905,48665,44472,38232,40312,48665,65465,59161,40344,38264,44505,44537,46617,57082,48697,40345,40377,40377,42458,34072,25588,19314,25523,27636,27637,23540,27701,23540,15120,12975,12942,15022,12941,12941,12876,23408,40213,23408,8715,10795,19182,10762,8681,12842,23179,29484,27339,29451,25258,23146,29419,23147,29484,23211,35791,44079,22950,18823,20903,3,2148,2148,2116,68,36,68,2148,4229,4229,4261,4262,2149,4229,4229,6342,4262,18889,14695,8454,8422,21001,35856,31696,35922,23339,17063,42194,42194,46420,31958,11057,39405,39561,39920,27568,19117,25423,38035,40049,33483,29225,29224,31467,16971,19052,23246,23279,25390,33710,21222,21388,23310,33973,27601,23245,38101,29584,33940,35956,37774,33741,33677,33710,29516,27371,23146,29550,31696,42293,31696,23277,29646,19207,12933,10852,8707,8740,6596,8804,19367,44403,42162,29740,33870,48500,40178,31762,31762,31794,31762,31793,27628,19238,15013,12965,17067,23341,23309,23309,25422,25390,27535,27535,29616,29616,29648,31729,31761,31761,33842,35954,38034,40114,42194,44274,44274,44242,42162,255},
{48665,52793,54905,50713,44472,38232,40344,54970,65465,59129,40345,38264,42457,44537,46650,55002,46617,40345,40377,40377,38297,27701,25588,23475,21395,23475,27669,25621,27701,23507,15088,15055,12974,15022,15022,12941,17070,17102,31794,19215,8683,23277,27600,8682,8649,4456,33712,37968,40049,37969,35856,37936,37936,37969,35888,33808,42129,41999,27111,25063,27144,14629,16710,16710,16678,14630,14630,14630,14630,14630,14630,14630,12518,10438,10438,8390,10470,8390,20969,14663,8421,4261,14759,29549,31696,31696,19081,23338,46356,44307,46388,36248,9072,37519,37516,41808,29616,19116,25423,40116,37968,29258,29192,29225,27340,27536,25390,18922,27537,29584,31595,19174,21325,21262,33907,23343,21197,36118,33907,31860,36151,38001,35889,40049,38034,37968,31663,25291,31597,27405,33875,33874,27503,29582,17159,15077,12965,4547,8740,6500,6627,19367,44500,52790,23496,23498,46516,35982,31794,27567,27597,25548,23434,17159,12933,12933,10821,10823,10855,8616,12777,27502,27502,31761,33842,33874,33842,33841,31761,31729,29649,29648,29648,29648,31729,31761,33842,33874,38002,38034,255},
{48665,48665,54873,50713,42424,38232,40345,57083,65465,57049,40345,40312,42425,44537,46650,55002,48665,40345,40345,40377,34104,23507,25588,23475,29684,29717,23508,25621,27669,23540,15088,13007,12974,15022,12941,12909,12908,12909,27569,23343,21262,40049,40081,27469,23309,23276,37969,38066,38099,38132,38100,35987,35922,38133,38165,38133,44275,41999,20838,18855,20903,35,2116,2149,2148,2116,4229,4261,4261,4261,4261,4262,4294,6342,6342,6342,8422,8454,23049,16776,14695,23017,10630,25356,33809,33842,19082,29613,42227,46420,44275,44374,36120,38168,40183,46521,27568,19149,25422,33743,31630,21034,27339,29419,21099,27503,29582,29616,40345,31861,23337,19208,21358,29681,29714,25553,17133,36054,36021,27601,38165,37969,31728,33840,25487,31663,14955,27470,23242,27534,35955,25423,29583,25422,19177,8773,8806,4516,6597,12808,19209,25579,44469,44435,21414,23530,42387,33869,31794,25519,23435,21320,15013,10853,8708,8708,8708,4514,6628,2242,10630,25387,27469,31728,33841,35987,38067,38067,38068,38067,35954,33874,33841,31729,31728,31729,31729,29681,31729,31728,255},
{48665,48633,54873,50745,42393,38264,40345,57115,65434,54905,40345,40312,40377,44537,44569,55002,48665,40345,40345,40377,36184,23508,25588,23475,23475,21427,23508,23541,27701,23508,15088,15087,12974,14990,12941,14989,12876,12876,23343,31762,25422,35855,35823,38000,38033,33840,33841,29615,27470,25421,25389,25357,23276,21163,21163,21163,23309,33678,27143,27176,27176,18822,16743,16743,16710,14630,14630,14630,12582,12550,12550,10470,10438,10470,10470,8390,6341,6309,20969,10534,10534,20937,6309,25357,33841,38068,23276,29582,38001,48501,44274,48665,33974,36022,40345,40312,23375,16971,21230,38002,33743,27405,33743,40017,31630,29583,35856,33874,29814,29811,19110,14884,19374,29681,31892,34037,27405,36053,36053,31826,38067,35921,31694,33677,27371,35758,23244,27469,12806,33906,31762,25423,29583,23310,25454,25484,15047,8709,10759,25422,40342,50810,52823,50742,42386,40175,46417,29739,27629,25515,23433,23465,14981,14981,12868,10787,12868,10787,8707,12772,21223,21254,21320,23499,29709,31791,36018,38067,40115,33871,23435,31759,35922,35922,35952,27628,23466,29679,33842,31696,255},
{48665,48633,52825,50745,42392,38264,40313,55067,65498,54905,40345,40312,40377,44537,46617,57050,48697,40345,40345,40377,36152,23508,23507,21362,17266,21395,23508,23541,27701,21427,15088,15055,12974,17135,15022,14989,12909,17069,27504,35955,31695,37968,27469,31630,38001,33808,35986,31728,27470,27502,29615,25422,25422,23244,23309,21196,25357,23082,23049,20969,18889,18921,18889,16809,18889,16776,14695,14631,14631,12582,12550,12550,12583,14663,12582,14695,14695,14695,16808,12615,14728,16808,16808,29615,33842,35922,29551,33776,33776,46388,42162,44505,36055,33942,50844,38198,25455,21229,27601,33809,29550,35921,31662,40049,37969,33809,35888,31696,23472,21258,14916,12869,19407,27568,34005,36086,27372,33875,38199,38166,37969,29583,31565,31662,29517,23471,14987,23275,12806,29680,27536,29583,27470,23310,31729,46421,48564,40113,35986,31727,29644,33871,46517,48630,48761,54904,42321,21352,15045,15046,25610,25577,17126,21319,23398,19173,17060,21253,16996,10724,14949,12900,12932,15274,13030,13062,21385,29804,35981,25513,17158,17128,29647,33808,29708,23463,19302,25547,29743,36019,255},
{46585,46585,52793,50713,42393,40312,40312,57115,65498,52857,40345,40312,40377,42457,46617,55002,50778,40345,40345,40377,38265,23508,21395,19314,17234,17267,23508,23540,27701,21427,15088,15055,12974,19248,15022,17102,14989,17102,31729,31664,33776,35856,31727,33808,35953,33841,33841,31760,29615,29615,29648,29583,29615,29615,25454,25422,35922,25129,25097,8358,6245,8390,10536,8455,6310,6343,8423,14728,14761,14761,14728,16873,14759,12615,8486,6374,4293,2180,6309,68,2246,6440,16906,31663,35922,33777,27276,38035,33776,48500,48534,40280,36087,36055,50812,33842,27536,23310,25521,31761,29583,35889,33775,38001,44242,33841,27565,23371,19144,14983,10789,8611,10825,21424,38134,33907,17101,29648,36151,38099,33808,31695,35824,29517,29582,10989,8681,29582,21193,29648,27471,29583,25390,25390,42260,54872,56984,52759,50678,31825,25389,38001,44373,40113,35950,40143,23431,12901,12934,10821,17158,21320,17094,25479,21285,14948,14949,17061,12900,12932,12932,10819,12932,6659,12964,15109,17189,23494,25510,21318,12901,8804,23465,31820,33962,27655,21414,17157,13031,29876,255},
{44505,46553,48633,48633,42425,40312,40312,54970,65498,52825,40345,40344,42425,42425,46617,52890,52858,40345,40345,40377,40377,25621,19282,19315,19315,21395,23508,23508,25621,21395,15088,15055,15055,15054,12941,12941,10828,23343,38067,31695,31728,31630,29583,33776,35921,33840,31695,31728,31696,27534,27502,29648,31696,29615,25390,25390,38067,25162,23017,8358,6245,8390,10568,6342,6310,4230,10536,23277,23276,31663,31630,23244,25357,21164,16840,16840,16840,14728,12647,12712,14826,10665,21196,29551,29583,33777,27406,35922,31728,48500,48600,38232,40247,42360,40279,31761,29616,25487,23375,23375,21132,40049,35824,38001,42194,31759,21289,15015,14949,10755,8675,8578,12936,31826,35988,27601,31794,31761,34005,35888,33776,35888,31662,33743,27469,23243,8645,21324,38067,29615,29583,29551,25455,29648,48599,56952,50745,52792,54871,35954,21229,40115,46454,46486,44372,27658,17126,21288,14951,14983,12869,21319,17093,23398,15012,10756,12837,17126,25544,21319,15077,17126,12932,15013,17093,12900,12996,19302,27688,27591,15014,23495,31911,27719,27688,21414,15109,10851,6628,10825,255},
{42425,42425,44472,48633,44473,40312,38264,57050,65530,52857,40345,40345,42425,40344,46617,50810,54970,40377,40345,40345,40410,27766,19314,21395,23475,25556,27669,25589,25653,21427,15087,15087,15054,12942,12941,12941,10828,19150,33810,29648,31695,29517,25389,33776,35889,33776,33808,33808,29647,29615,29583,27535,27534,27470,25390,25422,38067,23049,22952,10438,8357,12551,12584,8325,8390,10503,10536,27503,25357,31695,31663,21099,27535,23342,20969,23082,25227,27275,25194,29518,25391,14892,14858,27438,29615,25358,23180,23310,27503,48501,46553,33974,36054,36119,31827,31697,27536,31729,19117,23310,35856,40049,35856,37936,38000,21290,14950,12870,12901,10755,8675,14883,17060,23503,29616,29714,36020,36020,33906,29550,14857,33709,25258,33710,23211,21097,6627,10822,29616,27535,29615,25423,25423,40148,52792,57017,54904,52824,54904,31761,23310,42260,46454,46454,42258,23434,31760,42196,40147,35985,29709,27560,29671,19172,19205,23463,23335,21287,17126,17094,10788,15013,15045,17126,15013,19143,21319,17125,15107,31786,23399,27720,27752,25607,19302,12997,10884,15044,8707,8738,255},
{42393,42392,44440,48633,44473,40312,38232,57082,65529,52857,40345,40345,40377,40344,44537,48697,52890,40377,40345,40377,42458,29911,19314,21362,25523,25556,27669,25589,27701,23475,15088,15055,15022,12941,12909,12909,12909,14957,29682,27601,21229,29550,25356,33743,38034,35921,38034,33841,31728,31696,29648,33841,33809,29615,25422,27502,40148,25097,22984,8358,8325,12583,14696,8390,10535,10503,6342,14793,14793,16874,16874,19050,21197,19051,23114,23146,27307,27307,25227,29583,31762,19117,8520,19019,29583,21003,21165,33776,31631,44307,44441,36054,35989,29682,27600,29681,27503,40181,19117,21262,35987,35856,37969,27308,25450,17095,14983,10790,14949,8643,14948,19108,12803,21388,25455,31860,33940,40310,44208,37935,29516,33711,25291,33743,23211,27468,6691,14952,23245,29584,29551,23310,29616,48566,56985,56985,56985,52824,46453,31794,19151,40147,46454,46518,40342,29746,33973,52989,53022,55070,36082,21319,29703,21253,21350,25640,29738,29609,21255,21255,12837,15014,15013,15045,14949,31726,44339,42258,40144,42225,38126,29801,21382,19303,21415,23526,17189,25638,21444,21413,255},
{42393,40312,42392,46553,44473,38264,38232,57049,65529,52857,40345,40377,42425,40345,44537,48730,54970,42425,40345,40377,42458,31959,19282,21362,25523,23475,29781,27669,27701,23507,15120,15055,12974,15022,12941,12909,14989,17037,29682,29714,21262,29582,25324,33775,40146,35921,33808,31696,31728,31696,29615,33841,31728,31761,27502,27534,40148,25097,25033,12486,10406,14664,12616,10470,12583,10438,8422,6277,6245,4197,4165,14760,14825,18986,23049,23082,23146,25194,25226,31663,38198,23343,21132,23211,29583,31534,16906,31728,31728,42260,40215,38134,36054,19084,29615,25423,23342,33842,21197,14924,27536,37936,33711,21033,21288,17096,14983,10758,12869,14948,21285,14948,14948,19307,31696,29682,25520,27795,40146,38033,40081,35889,33807,35856,31662,17031,4611,27469,27503,29615,25422,25390,38067,52792,59065,57017,57017,52792,40082,27502,29583,44406,44373,46454,44372,27566,31892,55167,59359,57247,36050,25542,21285,19142,14885,23400,25576,25480,23368,19239,17094,21319,17094,15014,10756,19111,17159,25515,33903,44404,48598,42351,25542,17127,27721,25574,19301,19269,12963,12963,255},
{42393,40312,42392,44473,42392,38264,40312,59162,65529,52825,40345,42425,42457,40377,46585,50810,57018,42425,40345,40345,40410,29814,21395,25523,27636,27636,33910,27701,27701,23475,15088,15055,12974,12974,12941,12909,14989,14956,29650,29714,23343,31663,25356,33776,38034,35953,33841,31728,33873,31761,29647,33873,33841,33841,27535,29615,33810,20904,20872,10406,8325,12616,12648,8422,6309,6309,10535,6277,6278,4229,6245,16873,18986,21099,25162,25259,27340,27372,27372,33776,31762,19118,29682,29517,29583,37841,27341,38002,33776,42359,44506,44473,44473,31664,29648,27502,31760,33842,23310,14924,29583,42130,37936,23370,17063,17064,14983,10726,6597,17061,17060,10723,10723,12969,21391,27568,29779,21489,35888,27534,38034,33841,38002,31793,27501,4611,15049,33776,29615,29551,25390,27535,46518,56985,59097,59098,59098,54904,44275,25390,27470,46453,44373,46454,42194,42257,55069,59327,55102,50843,31794,19240,15013,17029,16965,25512,27689,23400,19143,14982,14982,17158,17095,12901,8675,8643,6627,10852,10884,25514,21352,25643,27722,34026,29832,27687,17093,21382,19301,10851,255},
{42393,40312,42360,44473,40312,38232,40313,59226,65497,50745,40345,42425,42457,42457,44505,50778,57018,44505,40345,40377,40345,25621,23508,21362,21362,25556,29749,25621,27701,21427,15088,13007,15054,15054,12941,12909,12909,12876,31794,31762,21295,27536,25390,21260,12875,8714,14956,14954,10762,8649,29713,33907,27436,31501,33777,25260,31599,12583,14696,10406,8325,12616,12616,8390,6277,8357,12616,8390,10438,8358,10470,21033,21066,21099,25129,25194,25259,25259,25291,35954,35922,19018,27568,33775,27470,42261,31664,40147,35889,38133,38133,38134,38133,40181,31696,29583,35954,29583,25423,17037,31664,44242,25451,17095,10758,8646,14951,8678,6597,14981,17093,8675,10691,12903,23504,29746,25715,33873,35888,38001,40114,40049,35888,33808,19113,2530,17035,29583,31663,27471,25422,35955,52824,59098,54839,54872,56985,56985,46291,27276,33679,44373,44341,44341,40114,46484,59229,48763,48730,48698,29682,19242,19206,17029,21222,25513,21384,19239,21288,17095,15046,15047,14950,12901,6628,4515,6628,10789,10822,21289,10916,13028,25607,27687,23494,23431,21287,25608,17125,15012,255},
{40345,40312,40312,42393,40280,38232,40313,59194,65465,46585,40345,42457,44505,46585,44505,50777,59066,46585,40345,42425,38265,23540,21427,17202,19282,19315,23508,23540,25621,19346,15088,13007,15054,17167,12941,12941,12909,12908,29681,31729,25422,29584,23310,19212,8617,8649,14890,10761,2375,2343,25488,31892,27499,35756,42230,35824,31598,23310,21165,10373,10406,14696,12584,8390,8358,12551,29420,35757,31532,29451,31596,35790,35758,33678,33677,33645,33709,33710,31629,35888,35856,29517,31630,31727,27470,27536,21164,38035,40115,29649,29550,29583,25390,38002,29647,33809,33776,27503,29681,17004,29615,35919,12934,12870,8646,8645,12838,12839,10693,12837,14980,12868,10755,10919,25584,29746,23602,35888,29614,38001,31695,38001,35954,31662,6660,4549,12844,27503,29583,25423,27503,42326,52824,59097,48533,52759,50614,50679,46259,25164,27341,44373,44373,42260,42193,50645,50679,46519,50811,46552,29811,15211,21351,17062,21223,25512,21352,19175,21320,10821,12966,15046,15014,8709,8677,2403,4548,6660,8676,19176,10883,15140,29800,19237,25575,27624,21287,15045,12900,8707,255},
{40312,40312,40312,40280,38232,36184,40313,59194,65466,44505,40312,42457,44505,46585,44505,50778,56985,46585,42425,42425,38232,23540,23476,23443,25555,25556,23508,23508,25621,19346,15120,15087,12974,12974,12909,12909,12909,14989,31762,35955,27535,33809,25390,17100,10698,10794,14922,8649,10697,10730,21197,23342,23244,31533,42229,48631,31566,18922,21003,8325,8325,14729,10503,6277,8390,14695,39950,40015,33710,29516,31564,31629,33677,33677,31629,33710,35790,31629,31629,31629,31629,31597,29549,25389,19084,25422,29551,35922,42227,29583,16971,27470,33744,42228,29648,31696,27502,23309,33874,17004,25455,27597,10822,4452,21195,40014,33739,23306,25289,16998,14948,12868,12868,8643,13101,25845,27633,33775,33808,35888,27469,35953,31761,21226,2466,14954,16972,31663,27502,23310,33842,48632,54905,54905,46551,42260,42194,44274,48434,35856,38002,44341,42260,42195,38033,44471,57183,57150,55102,55070,27699,13071,21324,25352,25321,25513,15078,12902,14983,12838,6628,12934,12967,6564,4419,4420,4516,4451,14854,25419,19174,15140,29832,17157,21383,27689,21286,12900,12900,12963,255},
{40312,40312,40312,38200,36152,36152,40313,61242,63354,42425,38264,42425,44505,44505,42425,50745,59033,46585,42393,42425,38265,23540,23475,25523,29684,27636,25621,25621,25621,19346,17168,17168,12974,15022,12941,12909,12876,17102,25456,33777,25455,27503,21262,10795,6569,6601,17003,14923,6537,10698,17004,17036,23309,33647,31534,33712,25227,25259,31501,10405,10438,16777,14664,10438,10503,12584,31598,40048,37902,31596,31596,33709,33709,33645,33709,33677,33710,33709,31597,33709,33709,31596,29516,27469,27470,40114,37970,33809,40115,31695,21131,27503,31728,48502,33809,31695,21132,19116,33842,17036,21262,23403,10822,8645,23405,52627,42029,42194,39982,25352,14948,10756,10788,10756,15082,17131,17002,27632,38001,23341,33808,25422,29582,12870,2469,12746,25390,31663,25390,25390,42261,50712,56985,46453,34006,40441,40440,40440,46583,35888,42195,44341,42228,42196,38034,46585,59295,59295,57215,57150,25715,23764,29680,35953,33839,31627,19239,12902,12870,14951,6596,8709,6598,6534,2276,10696,17066,19081,33839,23306,29612,17190,25640,23494,19270,12964,21350,25447,21349,15076,255},
{40312,40280,38232,36119,34071,36120,42393,61307,63321,42425,38264,40377,44505,42457,40345,48665,61113,50713,42393,42425,38265,23540,19282,19282,25556,27636,27669,25653,23573,19346,15120,15088,15022,12942,12941,12909,12909,19215,27504,33777,23343,33744,29616,19181,4488,6536,19148,25455,12745,18921,16906,17002,19114,37872,29388,25261,23082,25389,33679,6244,8325,14728,10503,8357,10471,14663,33679,44241,44241,44241,44241,44241,44241,44209,44209,42128,42128,42128,42096,42128,42096,40015,40015,35823,31630,35888,38035,35857,37904,33809,27535,27470,31663,42262,27471,37969,19051,16971,35954,21197,21230,21290,8741,8645,17034,48566,46419,38033,37935,33675,19110,14980,8643,14917,17030,14853,8613,10631,19084,21228,23276,17035,19114,4548,6537,10698,29583,27502,25390,31729,50679,52792,52792,42261,25455,30138,30332,30267,23667,23244,35922,42260,42228,42227,38034,46584,59295,59263,59295,55037,25456,12941,25357,41934,44014,41998,33740,19143,17096,14982,8678,8582,8518,6471,6439,12777,19149,31793,38098,33904,23404,21319,25607,23495,15045,25512,27623,25575,21382,12964,255},
{38232,38232,36120,34039,34039,34071,42425,63419,61241,40345,38264,40345,44537,42457,40345,48665,59065,50713,44473,42425,38265,23540,17202,17202,17234,21428,27669,27702,25654,19314,15120,17200,15055,12974,12941,12941,12876,19149,31697,31697,25455,42228,33744,23374,2440,6537,10794,17101,23277,23114,14825,10729,17035,37937,29453,25163,25162,21196,21099,16679,16744,20970,14632,10470,16744,39951,48401,37968,29648,29648,29680,29680,27632,25615,27695,27663,25615,27663,29711,29743,29743,31759,33839,33807,29581,29582,35921,31728,35856,38068,27601,27470,40148,33876,25390,35922,21198,14891,33776,25422,19117,27533,19176,8678,21293,54937,52857,42292,48533,37869,19143,14981,10723,14917,12741,12741,10629,6404,6438,12843,14792,14855,4613,4613,10730,19084,27502,27600,23310,44406,54904,52857,40213,40279,29713,30137,30235,30234,21522,12680,31695,42228,42228,42228,38032,46583,59327,57182,59295,52924,25553,19279,29517,44013,43981,39853,35693,29482,29547,15016,17132,23374,25520,29681,29518,29420,21197,29615,21162,27533,27467,31691,29738,21319,25544,29800,23462,17189,17157,10819,255},
{38232,38200,36119,34039,31959,34072,42425,63388,57018,38265,38264,40344,46585,42457,40344,48665,59097,52825,44505,42425,40345,23573,17234,17234,17234,19347,25621,23541,27734,19346,17168,19281,15055,12942,12941,12941,12909,19182,31730,21262,29649,42326,29583,21261,4488,10730,8714,8682,25358,25195,14825,2343,21197,31501,35758,31500,27340,23309,10696,31598,33679,31664,21197,19018,31564,46323,48369,35920,23440,23439,21423,21454,19374,21454,23502,25550,25518,27566,27565,29613,29581,29581,31661,31629,29549,27469,25227,29518,42228,35889,27470,31695,46519,27569,31631,31663,23278,14923,29583,29583,17004,29648,42161,14952,29647,52825,50712,40180,44405,31596,16998,14981,10756,19078,14821,12677,14854,10661,4292,6438,12712,16969,6692,10824,12811,27470,27470,25455,31696,50711,31822,29741,23435,25582,17130,25943,28089,26040,32021,27469,35921,42228,44308,42162,37934,46518,59327,50876,57150,52924,23634,27925,35888,42227,42096,29418,16937,25323,44177,33711,27633,29713,31827,31859,39984,52336,39952,40081,39983,39950,41998,41998,40013,31850,27721,23527,27687,17188,17189,6658,255},
{38232,36152,34039,31959,31959,34071,42425,63387,52858,38232,38232,40312,50778,44505,40344,48665,54937,54873,48601,44473,40345,25621,19347,17202,19315,19347,25589,23541,25654,21395,17201,21362,17103,12974,12941,12909,12909,21263,31730,27471,29616,35987,29584,27568,6537,8617,4488,12810,27471,23115,12776,6600,25423,31566,31501,25194,23179,21165,12777,31631,29517,23179,23179,21130,21131,44340,48401,42128,33807,33807,33806,35887,35854,35854,35854,35854,35822,35822,33742,33742,33742,33709,33742,31661,31661,29549,25259,31631,40148,35889,27470,31696,29713,38002,46256,27537,23278,19117,25390,33777,17004,25455,29649,25420,46453,50778,40245,48598,46320,23241,17062,14949,10724,21191,14853,10597,12742,8581,4356,6470,14793,19017,10822,25455,21164,27502,25390,25390,35985,31789,21287,19207,17095,8709,12934,17161,13231,23862,23538,23375,35856,44308,44275,44209,35921,31859,44602,55135,57215,50843,21263,17134,35758,45996,41803,37870,35887,25225,35823,29486,25552,31859,33972,34004,39919,50256,44177,42129,44209,42064,43981,48175,35725,29642,27625,21383,23527,19269,12996,10884,255},
{38232,36152,34039,31959,31959,34039,42425,61307,48729,36184,38232,40345,50746,44505,40345,50745,56986,56921,52761,44473,40345,25686,21460,17234,23476,21428,19380,21460,27702,21427,17201,23442,15023,12974,15022,12941,10829,23343,29649,27471,31697,38068,29616,19149,2408,8682,10762,12908,29551,21002,6535,4455,27535,40082,40049,37871,29550,19052,10632,31598,33646,29485,14760,14792,12712,40115,44240,44241,46321,44241,44273,46321,46321,44274,44274,44241,44241,44241,42161,44209,44241,44241,44241,44241,33677,35888,35823,38067,40180,38002,31663,40115,29648,50745,46449,17165,19018,21165,19051,27503,23309,23277,14794,31662,48566,44438,38133,59163,37933,12774,12870,12869,10757,21224,14854,10629,14886,8581,8582,4356,23309,29615,23341,38035,25389,27470,31925,29680,25482,21288,21320,17062,17095,10789,19239,10789,8742,13099,10859,19018,35856,42195,44373,31891,27634,23441,46683,55070,48796,44505,21490,15183,29582,29354,35692,29354,23178,27370,23242,25422,23375,33972,33972,40213,52401,52401,42129,44209,42097,35758,37675,48143,39887,35757,27592,19270,17157,10788,8707,10852,255},
{38232,36152,34071,31959,31959,34039,44537,59228,44537,36184,38232,42393,54938,42457,40345,50777,59066,54873,52761,42425,40377,27766,21428,17234,21363,21428,19380,23541,27702,21395,17168,19281,15055,15022,15022,12909,10861,21295,33778,27407,27536,40181,25455,14956,296,12876,14955,19019,27275,25162,8616,8520,31631,38099,38066,42194,35953,19116,10696,29518,31631,25293,14792,10599,8486,31630,46289,40048,39983,33742,35822,33710,33709,35855,37903,33742,33710,35823,35823,35822,35822,37903,37935,37903,25388,35920,42194,33809,33809,40115,33776,40180,35955,52923,46452,27470,23244,21067,12615,14663,18856,21131,25324,29582,44340,35921,38099,55036,39855,23048,6469,12806,12869,16998,14886,12709,10597,21162,25390,14857,25455,35987,40213,35922,25357,25357,27830,36117,27529,19176,21288,17095,12902,12902,8645,6597,10889,10890,101,10600,31695,40114,35982,23500,25584,27666,42424,44537,48698,38068,17198,13037,33710,37675,41933,39755,33580,23178,19050,27568,23342,31827,31826,36019,42097,44112,42129,40049,37936,33678,39755,46095,39887,37839,33963,23494,19302,17125,8740,12901,255},
{38232,38200,34039,31959,31959,34039,46618,57180,42457,36184,38232,40345,57049,44505,40345,50745,57018,56921,50713,42393,40377,27766,21460,17234,19315,19348,23508,23541,27702,21395,17168,17201,15087,15022,12942,12941,21231,23407,31698,27440,27568,38068,33841,12908,328,6602,19116,29486,27275,25194,12776,6504,21262,38099,35920,42162,29615,23342,23277,21197,21229,19116,19084,19051,14890,27437,48369,40015,37902,31629,33677,31565,31596,35790,35790,31629,31597,33710,31629,31629,31661,33741,33709,33742,25421,29680,40113,35759,25390,40181,35987,42261,29648,46585,52726,33742,21196,16970,12810,29550,19019,14891,29485,31630,44373,59165,44439,52859,25067,31436,29452,27370,23305,19078,14886,8548,14823,40082,35987,19051,25487,40214,44504,31696,25357,25358,29649,44437,27530,21256,17095,12871,6566,6598,130,2276,8778,10924,8518,14759,35855,36014,23431,15012,21387,42392,38166,42425,44505,33875,19117,17069,39853,52172,48011,39851,29449,16970,33809,35825,21164,25454,33906,36052,35824,42032,40016,37904,37903,37936,48174,41967,42000,39887,31596,25481,21222,23110,23239,20966,255},
{38232,36152,34071,31991,31991,34040,44570,59260,42457,36152,36184,42393,54969,42425,40345,50745,57018,56921,50713,42393,38297,25686,23541,19314,17234,17267,23508,23508,27702,21427,15153,17201,17168,17135,17135,12974,19215,25553,31730,23311,25488,38068,33873,8714,4521,2441,21229,23245,14729,12648,19050,35856,33711,40048,40015,37935,33743,25422,31793,29680,29648,27600,25487,25487,23342,29614,48434,42128,40015,35822,35790,33677,35790,37870,37870,33677,35822,37903,33710,35790,35822,35822,37902,35790,29581,21293,25388,42195,31697,33841,35856,33809,27470,48697,29747,12811,19085,19084,12843,33809,25390,14924,33809,37969,42325,61342,54904,42229,21100,42161,50547,48466,48434,33740,25353,12774,17002,44373,44472,27471,23342,38133,38133,29518,23309,25390,35922,42257,25449,19143,14983,10760,18985,14727,8420,8551,15019,12776,18951,16806,25354,29770,19302,12900,23469,44570,38100,40279,48698,40278,17263,17198,37805,31466,43980,29545,17095,21258,29582,33842,31729,29681,38068,44179,48241,42129,42162,37904,37903,33645,29289,39855,42000,35662,33549,27307,29321,33353,35401,31763,255},
{38200,36152,36119,34039,34039,34040,44570,59260,42457,36152,36184,40345,54938,42425,40345,50777,59130,59001,48633,40345,36184,23573,23541,21395,19347,19347,23508,23508,27669,17136,12909,10829,10666,12844,14957,10763,10795,19149,23310,21197,23343,23343,19148,8649,8616,8585,21132,19052,25325,29550,25389,31696,27405,31597,33742,31629,25324,21197,27567,21293,21293,21294,21293,21229,21196,17035,19051,23243,27468,29549,29549,29549,29581,29549,31662,31662,33742,37871,35823,37935,37936,40049,37968,38000,37936,35887,35823,44308,38035,33841,35857,27503,29550,44440,19282,8683,14891,19149,12778,31696,27503,19150,31761,38034,38100,61308,52791,29550,27438,40114,40081,40048,42161,42161,40048,23243,14858,42325,50778,35955,23342,25423,23310,27470,23277,25423,44373,38031,23337,14887,12872,14922,27470,37774,46029,48141,46094,46126,41933,37708,31594,25544,17157,10852,23470,44505,40311,52924,52988,46520,17133,17198,39917,31594,27465,25385,21289,19176,23405,33907,31795,29714,31860,50387,50419,42129,37903,37904,37904,31500,39821,42000,37774,37840,37839,29420,35627,39626,45836,39856,255},
{38200,36152,36120,34071,34039,34072,46682,57213,42457,34104,36152,38264,50777,42425,40312,50777,59130,52793,44473,40345,31992,23541,23508,21363,23476,25589,23541,21460,25621,14957,10698,10698,2181,10698,12810,10697,10665,16971,16971,21196,27503,14858,10665,8552,8551,12712,21067,18986,35954,35921,19115,12809,19051,21099,19018,19018,21164,25357,16971,8487,12777,8552,10632,12681,12582,2181,6406,6406,4326,6471,8552,6407,6439,6374,4293,4390,8487,20969,16937,19018,19018,23245,29551,25358,17004,23245,31501,31761,31761,33874,38002,27405,33776,33940,12714,21100,21230,23343,12778,25422,29583,19183,29649,40115,33842,54938,52758,46385,42193,35888,35855,37903,42128,42161,35855,27536,17004,35987,50843,42294,27536,21197,23277,25357,23277,33842,46453,46420,37967,17031,12872,21229,31859,34005,35988,42194,50482,54675,52594,50546,35947,19237,19269,8708,27697,42425,36085,46682,57215,38102,17070,19183,41932,39817,23271,23272,19144,23372,31794,31827,29681,29681,27634,35955,46161,40016,39984,37903,37904,31500,41935,39887,37774,42099,39986,31500,39853,43788,52402,45996,255},
{38200,38200,36152,36120,34071,34072,48763,59293,42489,34104,36152,38264,46618,40345,40313,52858,61210,48665,44473,40345,34104,23573,23540,21363,23443,25588,25589,21460,25621,14924,8617,10666,2181,8584,10665,8585,8552,12778,10665,12778,19084,10697,6504,6471,6471,8584,14825,14761,27535,25389,14858,8551,12712,12680,16872,18985,16938,16938,14858,6439,12777,12745,6439,12713,10566,2213,4326,8552,6439,8519,10632,6471,12551,8454,6406,4262,2181,6437,12774,12775,10632,19018,21164,23310,17004,16971,23277,35987,40213,40148,44439,31632,31729,27505,14631,29519,25521,27634,14923,19084,31728,12746,25423,42228,31664,48729,42164,42129,46354,46288,44208,44240,44241,42193,31694,29649,27536,29647,50811,46585,29616,21229,23310,23310,25358,40115,42258,46420,48500,40112,31662,23375,33940,38166,38199,36021,35724,41997,46256,42190,23398,17157,21386,23471,29779,33907,46650,46682,52989,33939,19343,21326,41900,44045,25384,17031,21260,33875,31794,31794,27568,27601,27633,29714,35792,37936,39984,39984,37903,29355,39855,39855,37774,37775,35694,33612,41901,45836,47819,41610,255},
{36120,36120,36120,36120,34039,34072,50875,61372,44537,36152,36152,38264,44537,40345,40313,52858,61242,52793,42425,40345,36185,23573,21460,19315,21395,23508,23508,23541,25555,27307,18953,23146,8487,10665,10632,4359,4391,2214,68,68,100,36,2245,4391,2245,2245,4325,8519,10631,14857,14857,12712,12712,10696,12744,12680,10631,8551,6438,6438,8519,4294,2213,4326,2245,2245,4294,2214,4326,4294,4294,4359,23211,23211,23179,18986,19018,8582,6532,2339,8550,14760,14858,19051,19084,17004,21197,38034,38035,31761,36086,25488,33875,27342,16874,19019,12713,16972,12810,19116,38002,19085,23310,42261,31695,46551,29357,40017,50547,48433,46353,46353,44273,33741,25387,23276,21197,29648,50746,48600,29584,23278,23310,25423,27503,42228,38001,44308,50581,50581,44308,29681,36053,38134,38166,38068,39917,29483,37870,37966,25480,17126,21421,25618,33973,38199,48698,50876,50811,25520,17360,25519,42030,42128,31562,14888,17132,29715,29714,31762,29681,27601,29681,29714,35921,39984,37936,40016,42096,37741,42033,39887,37774,37774,35694,33580,35529,43722,47819,45739,255},
{36120,36119,36120,34071,34071,34072,50907,59228,42457,36152,34104,38265,44538,40345,40345,52858,63290,54873,42425,40345,36185,23573,21460,19314,21395,21428,21428,23509,23409,25227,18986,27339,8487,10665,12777,4359,4391,2246,101,133,4261,6374,8519,6471,2246,2245,4358,6438,10631,14857,14889,12744,12776,10664,12744,6373,8486,6438,6438,8519,8519,4326,2245,2213,2148,2246,133,101,8552,4326,4262,6407,27534,27437,31662,29549,25356,21130,12743,4420,4388,12712,12680,19084,21164,19084,19116,27536,21165,33874,33842,29616,29683,29683,31795,16907,8455,12876,16971,19116,40115,21197,21197,31760,21195,23308,27436,48467,50578,52627,52659,50547,50547,31660,25421,21197,21230,29616,50713,46487,27535,23310,23310,25390,33809,46454,38002,42227,40081,48500,40082,29682,40312,40344,44472,38035,42063,42063,44176,42127,33804,27561,15013,6663,27698,42392,50843,50843,48729,27533,10697,19018,41705,39592,37577,35529,27306,21295,29682,31794,27568,29681,29714,33874,42032,40016,39984,40016,46258,44015,39855,37775,37774,37775,37775,35692,41803,47852,47819,45739,255},
{36119,36087,36119,34071,36120,36184,52988,55100,40345,36184,34104,38265,44537,40345,40345,52858,63290,54905,42393,40345,36184,23573,19347,19282,21395,27637,25589,23541,27471,27339,14825,29419,10567,10697,10697,4391,6472,4359,133,2213,14792,19083,19083,12777,10632,8584,2278,6438,8584,6439,8616,12777,10664,10664,10665,10664,6471,6471,6471,8519,10599,4326,2213,4326,2181,4326,133,4261,8487,6342,2246,10599,37807,29583,27437,35856,29517,27436,25324,12776,8614,16937,21066,25422,25228,25195,23244,25422,29552,40019,33842,29518,18889,25587,29715,19052,12746,10665,14892,14891,35922,25390,21229,27467,16935,12709,14856,35920,37936,37968,38000,33742,29581,27532,23309,21229,23310,27535,46584,46520,27503,23309,27503,33809,46388,48501,44275,44307,42194,44340,35890,31827,40344,38166,40312,35987,44209,50515,50449,35947,23399,21286,15012,8644,15084,48795,46614,33967,33933,25545,19209,21225,35690,33545,35561,48466,50611,25453,27633,33940,29682,29649,29714,33842,43983,39984,37936,37936,33678,31434,41903,39855,37774,37807,35726,37773,46062,49932,47819,52012,255},
{34039,34039,34071,34039,36152,38232,52955,52987,38297,36184,34104,40377,44537,40345,40345,52890,63290,59033,44473,40345,36152,23541,19347,19314,23475,29717,21428,23476,31598,29419,14825,27339,8487,12745,10697,4391,8552,2181,36,101,8519,10665,10632,12777,6439,4358,2245,4358,10664,6471,8616,12842,10664,6438,8552,12809,6471,8519,8584,10664,8486,2245,2213,4293,100,4358,2213,8487,8519,6342,4294,8486,29291,37775,27502,29550,31695,29550,29550,25389,19083,16840,21033,21164,29551,25358,23212,31696,42164,31340,31761,33777,20871,19182,29748,19052,12745,10697,14858,12778,33841,29648,25451,23271,14854,10629,8517,14856,16938,21131,27470,23244,25292,31728,21196,21229,21229,27567,46551,44374,25390,23309,35921,46552,59100,54807,44307,42194,48566,44341,35922,38132,36053,40279,40312,35954,44242,42291,46288,31753,21286,17092,14948,14918,17130,46646,31852,21288,21319,25543,19238,17127,21352,21255,25289,46451,52788,29610,21290,19179,19213,21294,23407,31794,37839,37936,37936,37903,33678,37675,43982,37774,39855,37807,35694,39886,48078,49900,52012,58253,255},
{34039,34039,34039,34039,34072,38265,52924,46650,38265,36184,34104,42425,46585,40345,40345,52890,63257,65241,48633,40345,36184,21493,19347,19315,25524,31797,23508,23475,33678,29419,16905,27339,10599,12777,10697,4391,6504,4327,101,101,133,2149,4326,10664,4358,4391,2181,2245,4358,2213,2246,4391,4390,2245,2246,2246,101,2181,4326,8486,10599,4358,2181,2213,2148,6407,6407,8552,6439,6374,2214,8486,14857,25195,31534,27535,31728,33809,33808,27534,6567,261,8583,14858,31696,38034,27535,29583,40115,25163,31794,35955,14663,17004,14990,19051,10632,12778,19150,10730,29615,33776,21256,16997,12741,14822,10629,14855,27502,29517,29615,33776,38034,31761,21229,23310,25422,33874,54971,38067,23310,25357,35889,33841,35954,55004,54970,40114,40147,38035,33809,38165,36053,38198,38231,35922,46322,50547,50481,40077,27496,27464,12901,25513,36012,31884,25513,21288,19207,17092,12899,21320,19206,19141,16837,16904,23369,23367,19174,14949,8709,2371,2341,21327,27567,37936,35823,37936,33645,43949,44048,37775,37774,37775,37774,44078,48045,49932,52045,51947,255},
{34039,34039,34039,34039,34039,40345,46715,38297,36184,36184,36152,38264,42457,40345,40345,54970,63257,61081,48633,42425,29911,21493,19347,21363,35893,33877,23476,27635,33678,27339,14825,27339,10567,12745,10697,4391,6504,8552,2246,101,100,68,4326,6471,2245,4358,100,2180,133,100,100,100,133,2213,100,100,2181,2181,101,4293,8486,6406,2213,6406,2148,2214,6439,6407,8422,2245,165,14793,27404,12776,25292,27470,31695,29647,29615,19147,2340,2276,8486,16906,29615,40083,40149,33906,33874,29551,31794,33875,10566,14891,19249,25455,21229,14859,29714,17004,29550,35857,21227,14886,12709,12743,19016,27437,31696,31663,31696,35856,40147,25422,23310,23342,27503,44373,46552,31696,23310,27470,33841,35889,29583,46552,52924,40344,33776,35921,33809,36020,38199,36053,38199,35888,46322,46321,48369,46321,42063,37837,25417,31817,29738,25512,23400,19143,21289,14980,12804,17094,25480,21318,16997,17062,12804,17061,19174,17062,14950,4484,6598,25521,31729,39984,35823,37904,31565,43949,41935,37807,37774,37774,35694,44045,43884,49900,45771,45739,255},
{34039,34039,34039,34007,34039,38265,40409,38265,36184,36152,36152,38265,44505,42425,40345,57050,63257,61049,48633,40377,25686,23541,21460,27571,40053,35958,23508,25588,27602,29419,14825,29419,10599,10632,10665,6472,8552,6504,2278,4326,4358,4359,2245,2245,2213,165,133,100,2245,133,132,100,2181,4326,8552,10632,14792,12712,10631,10631,6438,4326,2213,6439,4326,4326,6407,8552,4294,6309,133,16873,29453,25098,27502,21163,27469,16938,16938,12776,6502,2276,6405,14858,29551,31696,35923,42261,44373,35987,27568,25455,14759,25357,21328,14892,14890,14890,23408,12778,21196,37969,19117,21228,23340,19082,25388,35889,27503,25325,35889,35922,35987,25390,23310,25423,33809,44308,31696,29615,23310,27471,38134,31958,25423,48665,59262,42294,33808,40114,38067,40213,44373,33907,40279,37903,44242,27372,39950,27502,37935,31661,33771,33962,36043,27625,23399,21286,25545,25511,21285,14981,12869,14980,14917,12868,10820,10788,6498,10725,15014,8677,8677,15052,31761,46290,44177,39984,27437,21065,35727,42098,37840,37774,33613,35691,39723,49900,45771,39530,255},
{34007,34039,34039,34007,34007,38265,40345,36152,36152,36152,36152,40345,42457,44505,40344,57050,61177,63128,52761,40313,23573,23573,23541,33780,37973,33845,23476,25589,23344,27339,14825,27307,8487,10664,10697,6472,6472,4391,2278,4326,2278,2278,2245,2245,2213,165,101,101,2246,133,100,100,133,2245,10632,12810,10631,10632,10631,12744,8519,6439,2213,4359,165,2213,6406,10665,6374,16874,2181,14760,29452,25066,25422,16970,27469,16938,16938,16938,12744,10630,14791,16970,29583,25389,25519,35954,42130,43724,27374,23343,21098,35889,15022,12778,14858,19083,17069,12746,19084,38002,21197,21230,31761,31663,35889,35889,31696,31696,38002,33874,29648,23342,23310,25455,42195,38002,31696,27502,23310,33841,36020,25783,23473,50810,61343,42227,37969,42227,33875,29682,35889,29616,33973,35758,39917,44110,48336,42095,27400,23239,38090,36041,25480,21288,21352,21319,17093,17029,15012,10755,10756,10755,12836,12901,10757,8612,6404,10726,17062,10789,10790,6500,4516,23371,40049,44242,31663,14759,29518,40018,35727,35694,35661,43948,47916,51980,52142,47915,255},
{34007,34039,34007,31926,31959,38265,38232,36120,36152,34072,36152,40377,40377,42425,40313,54970,61177,63160,54841,38232,21493,21525,27636,31732,29652,29749,23476,25589,21198,29419,16905,27339,10599,10664,10665,8584,10664,4391,4359,4359,4326,2245,2213,4359,2245,165,133,101,165,2213,133,101,100,2245,6439,14858,8519,8486,8519,12712,8518,8518,4294,6439,4326,2181,4359,12745,6439,14890,6439,14760,29452,27178,27534,19051,27502,14858,16906,16938,14857,14792,18984,21163,27470,27470,27470,27405,33646,46064,31665,23375,21164,29648,21328,23408,14826,16971,21100,21099,16971,37969,25390,19150,38002,37937,33743,31663,31663,31663,35888,29550,27502,25423,25423,25422,40082,33809,31696,23342,27503,44340,38067,27502,25422,50810,59262,44275,40081,42194,36054,29780,38034,40115,25487,35824,44177,37870,35822,31627,23206,21190,38123,33930,27625,25480,21256,21288,12836,6499,8676,8675,14981,12932,12868,17128,19211,19179,14986,21257,19143,4387,2211,97,6660,12934,14951,17034,17002,14824,27568,44538,40180,35857,35758,39918,47981,51980,47884,39529,255},
{34007,34007,34007,31926,34007,44570,38200,36152,34072,34071,36152,40377,40377,40345,38265,52890,63257,61081,54841,36119,21493,21525,21427,23410,27604,31797,25588,25589,23344,27339,18986,27339,8486,10632,10697,10664,14923,6471,4359,4359,4326,2245,165,4326,165,133,133,133,133,133,4359,2246,165,2278,6471,8552,6439,6439,8519,10631,8518,6438,2245,4294,4293,4294,4326,6406,6439,12744,4326,14760,23178,23244,27535,21162,27437,16905,16905,16938,16938,16937,21098,23244,29518,31663,29550,31631,33775,44373,29682,23342,19019,23276,33973,19117,12778,18922,10600,19017,14890,33808,29583,17004,33776,40114,38002,35857,35889,35889,42162,33809,27503,25423,25455,33808,46421,56787,52496,35757,25418,29545,23304,21192,21192,38163,50810,33710,35856,42194,44340,42326,40115,42227,40147,46486,44309,31696,27469,25352,21190,16997,17062,27657,33994,25512,17094,27656,21254,17093,21286,12901,17094,17094,12870,21356,21292,17098,10792,17064,14950,2276,131,6403,8805,12967,8774,2404,195,18920,38164,50844,31892,42457,50679,48500,52142,49899,47852,35336,255},
{31927,31959,31959,31926,31959,46650,36119,34071,31991,31991,36152,40345,40345,38265,38265,52858,63257,59001,50681,34007,21493,23573,17234,21330,29716,27636,23508,25589,25556,25260,18985,27306,8519,12745,12777,12777,17003,8552,2278,4326,198,133,133,133,133,133,133,100,101,101,4359,4391,2246,6406,6439,6439,2280,167,6406,14825,14858,8551,4293,8519,6406,2213,6439,8552,8552,10599,2149,19018,33484,17001,25422,19018,25389,16938,16938,16938,16906,18985,23177,23276,31535,21165,27470,31663,37969,44341,33875,23343,23244,18920,27635,25456,14858,18728,6374,14792,14859,29615,31696,14956,27535,33809,31664,35889,33808,35856,42194,35889,27535,25455,27535,44340,35922,35856,31663,29578,21157,16965,21191,16966,14822,19144,31825,20938,31566,42227,44242,44307,44340,42227,35889,27470,27502,29549,27436,25321,21191,10757,12969,27696,36047,31818,23399,36009,23366,19206,21287,17095,19240,12902,21388,25583,19212,10760,12840,10759,8614,6502,6405,14790,449,19209,19080,14887,16903,29354,38099,52923,42359,53021,52824,50580,50094,49899,45804,35303,255},
{31927,31926,31926,31926,31959,38265,31959,34039,31959,31959,34072,38297,38297,38265,38265,52858,63290,54872,50681,29879,21493,21525,17234,19282,23443,25556,23476,25589,25556,16972,16938,18986,8552,10697,10697,10697,14891,10665,8552,10665,8552,10664,6503,10599,6439,2246,4326,2245,2246,4294,6504,8552,8552,8553,10666,8552,6538,4392,6471,8584,10632,8487,4261,6406,10566,8454,8487,8487,8519,10566,2180,21098,42130,29258,29486,21163,27502,16938,16970,16937,16905,16905,18984,23244,29616,14892,12778,33743,35856,42195,36020,25488,25390,14825,19183,23246,17004,21197,8552,14858,12810,23341,33808,17004,25390,19019,25390,35889,31695,46421,54806,42161,27535,25422,33776,46388,31696,31695,27502,25351,19078,14885,21191,16998,16965,17032,25518,23244,33775,42195,44274,48501,44340,38001,25389,23244,19083,21196,25389,33710,31627,16999,15114,23505,36084,33931,27656,23401,25545,12901,19144,6563,6596,10789,17128,17163,17132,12905,14954,8647,10760,6534,6535,25290,19045,23240,27468,46160,43982,35627,42226,52758,48533,46519,40146,35887,41773,47787,41642,33255,255},
{31926,31926,31926,29846,31959,38233,31926,31959,29911,31959,34072,38265,40345,38264,38265,50810,63290,61080,52761,29846,21493,21525,17234,15153,17234,23508,23476,23541,23541,17201,19248,15055,15055,12974,10861,8748,17102,21295,19118,31794,25455,25456,19182,35889,35857,17069,14956,6568,10730,23344,21231,17102,21361,21329,25522,19183,17070,12843,12909,6570,16840,16872,16840,16840,14760,14759,14727,12647,23178,23146,18985,35889,42260,37840,27340,19051,27470,16938,16938,14857,14825,16905,21097,21164,31566,23181,14793,35856,33743,46453,40279,29682,19119,12845,17004,23181,14858,14956,8553,16971,17004,23342,35889,19117,21230,33711,31695,33776,35889,50777,48499,44274,29583,27503,42195,38002,31696,29582,25353,21159,21190,16965,16997,12773,16997,14951,17067,17035,33775,44275,46354,42259,35952,27565,17035,19083,21164,14890,33906,52824,50645,31691,23304,10693,21356,36044,23432,19241,12936,15015,21289,10756,8676,12934,17095,8709,12937,12905,10825,4487,8680,8648,10760,29549,35659,27302,31694,50355,41870,33514,46387,54806,48531,35789,14792,14854,23240,44142,39946,31560,255},
{31894,31894,31926,29846,34007,40345,31926,31959,29879,31959,34072,40313,40377,38232,40313,52890,63290,61080,50681,31959,21493,21493,17202,15154,17234,21428,23508,23509,23541,17233,17200,19249,19216,17135,10861,10828,21328,25489,19182,29714,21295,21295,17102,25455,29583,19149,12843,10762,17036,19183,23344,19151,23442,23409,23474,21328,14956,10763,19117,25456,16872,18953,18920,18920,16840,16840,14760,14727,25226,23113,18985,33743,27470,16906,19083,21131,27470,19018,19018,16905,12775,12710,18984,21131,31566,27536,25292,37936,31630,48664,40214,31663,31401,14633,19051,23376,19084,12811,17004,17004,14892,12745,35921,21229,19149,40114,37937,31696,46519,59196,46419,44339,31695,29615,46388,31696,31696,27502,25353,23239,19079,21190,10660,12805,10692,8612,8582,19149,35920,42226,33805,31790,12902,12807,16970,19050,19083,16971,42325,44373,40245,48630,40146,27468,17065,27627,27629,29743,10758,10790,19209,19079,19112,21225,23338,10725,2372,16969,17000,10792,12873,12841,12710,14886,23374,25420,40048,52533,52793,44079,48402,52692,52692,37837,14757,31657,37994,33801,35881,29543,255},
{31894,31894,31894,29847,34039,40377,31927,31927,29879,31959,34072,40345,42458,38264,40313,52890,63290,58968,48633,38264,23573,21493,15186,15154,15154,21428,25556,23508,23541,17201,17168,19281,17135,15022,10861,10796,21328,21295,23343,38100,21295,23376,17102,14956,17068,19117,17069,10729,8649,19182,17069,19150,21361,23442,23442,25489,14988,14924,23342,29649,16872,18920,16872,16840,16840,14760,14727,14759,25225,23080,18986,37903,35922,12745,19051,33775,33808,33808,33776,14919,4452,10663,23212,37936,44242,33842,27469,37903,33743,42228,38100,33646,23149,14763,14826,21231,27504,8520,12810,12778,10632,12777,38001,25390,17004,38001,40049,31696,55068,65535,50645,50646,37936,38034,38035,29615,29583,27534,25385,21159,16966,16998,12774,14951,10759,12838,14952,25357,35888,33837,23337,19144,6565,12808,16938,21164,19083,19051,46485,50677,50711,44307,27567,46453,29482,21161,21260,27661,17097,12873,14890,21033,18920,21001,23210,10598,4421,4419,16903,29614,27470,10695,19079,14951,27634,31860,50485,52467,50452,39885,42030,48500,40147,38002,40045,40042,42155,33801,31656,25318,255},
{31926,31927,29846,31927,36120,40345,31927,31927,29879,31959,34072,38264,42457,38265,40313,50777,63290,59000,48633,40312,21525,21525,17234,15121,19282,23508,23508,21428,23508,17201,15088,21361,19216,12942,10828,10796,17070,17102,31697,38133,29649,27601,23408,14923,17036,25455,14956,4456,10730,19182,19182,21263,21329,23409,27602,25488,14956,19150,27502,25325,16840,16872,16840,16840,16807,14759,14727,14727,25257,23080,21164,40016,40180,16939,25324,35888,35889,38001,35921,17000,4452,10695,19116,27437,52725,33808,31663,33743,33743,38034,42228,29747,31601,18923,12713,23344,19019,10632,14890,14891,17003,14891,38034,29583,17004,31728,40017,31729,52956,61374,50613,52727,40049,31827,27569,31663,27502,27502,33905,25417,14885,14918,10725,14951,17065,12838,12778,31729,37968,23369,14982,12871,19146,8615,14858,19116,19051,21164,46550,38001,46485,40114,31500,37968,39952,10764,14923,19116,19116,21227,21195,19051,14825,14890,19084,19052,10791,2306,8484,29615,29484,10758,21191,21196,31828,33973,52597,54482,52305,48369,44209,44177,29551,25587,38132,40076,29576,27496,29576,19045,255},
{31926,31926,29846,31927,36152,38265,31894,29879,29879,31959,34040,38232,44505,42393,40312,46585,63258,56920,46553,38232,21493,21525,17267,17202,23475,25588,23476,21428,23540,15153,15088,19248,17103,12942,12909,12941,12908,17102,29649,40246,27504,21295,19215,21197,23342,23407,21196,19082,10697,19150,14957,17037,23211,16872,6472,16938,29680,33874,35954,25357,18920,16840,25356,33710,33709,31597,18953,19018,23276,16906,19051,40016,42325,27503,27404,29549,23243,31695,35889,31695,17002,10599,19018,29517,50644,31663,25357,33743,31696,40050,44341,38068,40147,21132,16939,16972,27238,14792,16971,12810,19051,12810,33808,33776,17004,27503,42227,50745,59262,61374,50613,46518,42260,29584,25390,31663,25390,27535,40213,29582,23306,17064,14952,19178,25485,23307,14956,29616,33807,21256,12902,10757,8614,6502,16938,16971,19018,21196,50743,59064,54903,35856,33451,37870,29583,12779,21229,23342,27373,21032,21066,21098,16872,12744,16938,21131,21196,21163,18952,16839,12646,10725,23305,29549,29780,36085,50484,52402,54417,54741,52757,56919,35987,25554,40242,35881,31656,29608,19045,25383,255},
{31926,31926,29846,29846,36184,36152,31894,29879,29879,31959,34039,36152,40313,42393,40313,48697,63257,56920,44473,40312,23573,21493,17234,21363,25524,25556,21427,21428,21460,17201,15120,17135,15054,12974,10828,17069,21262,21262,25423,35955,27535,23408,21262,21196,25454,27567,27469,19050,16970,19182,19118,19150,20967,10469,134,10632,33808,38067,33874,27469,21033,10567,27469,40049,40113,40048,23210,14825,17004,8584,19018,35822,40147,31728,31597,33710,27469,33775,35921,33808,21229,4293,14825,40114,48532,23245,21099,33776,31663,35889,46421,38100,42228,25325,19117,21295,23210,12745,19051,14891,25292,14858,29615,38001,17036,23310,46552,59262,63455,61374,42293,40180,40180,29583,29615,27503,25390,31761,40180,31729,35921,38066,33906,42423,46617,29582,12811,27568,27531,17063,14983,8613,6533,14889,21162,17002,16971,23309,50742,42227,48662,40081,41967,35789,17001,6504,19116,23342,33646,33646,33580,27176,25291,16938,16906,23211,25357,33711,35856,35823,33644,17031,31725,37840,29747,36053,52499,52402,54450,52692,52757,63258,38068,27633,35948,29641,33834,25415,25383,29576,255},
{31926,31894,29846,29846,34072,36152,29846,29878,29879,31959,31992,34072,40280,42393,40313,48697,63289,59000,44473,42425,29847,19413,17234,23443,25524,25556,21428,21428,21428,17201,19281,21361,12942,12941,10828,27503,44307,42227,42226,42227,42227,44340,42227,40146,42194,42194,42227,33776,31533,42195,42227,33743,23113,12614,2246,14793,31728,29713,29550,25259,18888,33743,33743,27404,27437,27436,14791,8486,12778,12778,21131,42095,42260,33808,31629,35823,31630,33776,35921,35921,27469,25421,23309,42162,52692,31597,23244,31663,29615,35889,46421,38100,40148,29583,19117,17037,12779,12745,16939,14891,19051,14891,23310,40114,19117,23310,42326,48730,63455,54971,23277,29582,35889,29583,31663,25422,25423,38068,38067,33809,38034,38035,40278,55037,52891,29485,17069,25455,21256,21289,17065,19147,19114,23338,21193,23340,25356,21226,46450,35888,46484,25258,31208,31563,23335,19112,19051,23277,35726,37807,41869,31464,21193,14886,21194,14791,10567,14859,27470,42162,44209,31662,38001,42032,29681,38100,48306,54450,52402,50580,56951,63324,42294,29713,37995,25384,27497,21191,23303,29609,255},
{31894,31894,29846,29814,29879,34040,29846,29846,29879,31959,31959,34040,38232,40312,38264,44505,63225,59033,44505,42393,34072,19413,17234,19282,19315,17235,19347,21396,21395,15121,19249,19248,12942,12941,12909,29616,46387,44307,40113,42226,42226,42194,40114,40113,40113,40114,40114,40049,37839,40113,40179,31695,35823,35888,31662,33808,35888,27535,27307,27209,25226,40082,33808,25356,27437,27437,21130,16937,19050,16938,23243,37903,42260,31728,31629,37903,31662,33808,35921,37969,27469,31695,29616,35856,44307,31630,25357,29517,29582,31695,42228,38100,40180,35857,16971,12810,8552,14857,14858,14890,16971,16971,21228,40114,25390,42261,40181,50842,63487,50746,40214,46519,31695,27502,29583,25422,29616,40148,38035,31696,35889,31728,44439,55069,52792,31565,14859,21164,29645,38164,42359,36020,36018,31726,21193,21226,25421,19113,35852,31660,42290,21195,33905,31660,25448,25419,16971,21197,37839,39887,39819,33705,23272,12773,16935,12708,14789,16873,8518,29550,35824,25390,25454,38098,46356,48468,52467,56530,50288,52693,61177,61244,38068,27667,38064,33802,25352,21159,21190,19078,255},
{31894,29846,29846,27766,29846,31959,29814,29846,29879,29911,31959,34040,38200,38232,38232,40313,59033,59033,46585,42393,34072,19413,15154,15121,17234,15186,19347,21396,21395,17169,17168,15087,12942,15022,12909,21262,35856,42194,40081,42194,42194,42194,40081,40113,40113,40114,42194,40082,40050,38033,40146,40081,44208,44241,31596,31564,31596,31596,31596,31564,31596,31564,29516,29516,29517,29516,27436,29484,29484,27436,27404,35822,38067,31695,31596,35823,31694,33808,35921,35921,29549,29615,27470,23277,33809,38035,25389,25356,35921,31631,44276,40115,40148,38035,16939,14957,12778,16971,14891,16971,19019,16971,17003,35888,40148,59262,48665,52923,59294,40312,38135,38100,27502,29583,27503,25390,33842,40180,38035,31728,35921,29648,46584,57149,54938,35823,19182,27438,42195,42357,31792,38132,38130,29644,21159,16998,14919,21192,25418,19111,29644,23337,29614,25322,27400,27467,21226,17065,25388,37871,37675,23174,12870,19047,14854,14853,16902,35757,33644,18985,12743,23211,23244,25422,29680,38035,37872,39952,39984,44340,56985,61211,33874,27634,40180,40077,23336,27529,23303,14917,255},
{29846,29846,29846,27766,27798,29879,29814,27798,29879,29911,31959,34040,36152,38232,38232,40313,56921,63192,46585,42393,29879,19413,15154,13073,17202,23476,23508,21428,21395,15121,17168,17200,12974,12941,14956,14923,31695,40081,40114,40082,42162,42195,42227,42194,40114,42195,37904,37872,29356,31436,35662,50515,46321,46321,37870,29451,31563,31531,31532,31531,31564,31532,31532,29484,29452,27404,27404,27404,27404,27404,27404,31597,31662,21098,31564,35823,31662,35888,38001,38001,29517,35921,25422,25357,40115,44374,29616,21131,33775,31630,42162,42260,40148,33809,31794,23342,12778,16971,14859,19051,14891,19051,14891,35888,54937,61375,61343,63455,50811,36054,36020,31695,25389,31663,25390,25390,38100,38067,35987,33808,37969,33808,50810,59295,55003,33678,27732,36050,31693,38130,21191,23339,31759,25417,16998,14918,14853,25448,33770,37963,29640,23367,21063,23208,27560,29578,27529,19206,17062,23272,29419,16806,8548,14886,14918,16965,37869,52495,50382,37805,35789,35756,25290,27469,27535,29616,29616,29616,29616,31761,44438,52825,31762,21327,42293,50777,42357,33869,25417,23338,255},
{29846,29846,27766,27766,27766,29846,27766,27798,29879,31959,31959,31992,36120,38232,38232,38264,50681,61081,46553,44473,29846,19413,15154,13073,17234,25556,23508,23508,19347,17201,17200,15055,14990,12811,10730,12810,31728,40017,42130,42129,35823,33743,33743,33711,33711,33711,31598,31630,27340,29485,31598,42129,37936,48434,46322,29451,31531,31564,31564,31532,31532,31532,31532,29484,29452,27404,27372,27371,25323,25323,27404,29484,29516,27436,35855,35823,31662,37969,38033,38001,31662,33808,27470,21163,33807,44307,40148,29582,31565,31598,38034,44340,38067,40115,31827,25456,12843,14858,14891,19051,16939,21132,14859,31695,50711,63455,61407,59262,42424,42425,44439,29550,27470,29583,25357,27536,42261,38034,35987,33808,38001,38067,46585,48698,46518,29452,23275,31691,21159,27498,19078,14918,21191,21255,14917,12806,21223,33897,33897,29641,29640,21253,31785,29705,21350,17030,17094,17158,23271,19109,21224,21126,25418,23241,14918,31563,50448,52430,48271,50515,44210,44177,42161,44307,38001,33841,35922,31761,35987,40213,42293,42293,27601,33940,50811,55167,57247,50744,50680,48599,255},
{29814,29846,27766,27734,27766,27766,27734,27766,29879,31959,31959,31992,36120,36152,38232,38265,48601,65240,48633,44473,29846,19413,15154,17202,21395,21395,19347,21460,19347,15120,19249,12974,12942,12909,10796,12876,17036,31598,42064,39984,31598,27405,27405,27372,27372,27372,27372,27405,27405,27405,27405,44275,40147,46354,50580,35757,29451,31564,31564,31564,31564,31564,31564,31564,29484,29484,29452,27404,27404,27372,27404,29516,29516,27436,31597,33775,31597,35888,35888,35888,35954,36019,25324,19050,27437,39984,40082,29583,29388,29485,37969,44373,40148,40115,25456,31795,14826,12745,14891,16971,14891,19083,14859,27502,48566,63455,61343,50811,31828,31827,33809,25357,29583,27470,25390,31762,38035,35954,38035,35922,35921,35920,31663,14953,31725,25160,27433,27464,19045,19143,10724,10693,17032,21224,17030,14886,29640,38026,33864,27560,23366,23430,23430,23399,17126,10756,10851,12932,12805,33674,29672,23366,29512,23270,17093,27432,46255,48271,52529,54971,23309,29616,44341,48599,48501,46354,31628,25388,33874,44406,44406,42293,27633,38133,52892,55167,55134,52858,52858,50712,255},
{29814,29846,27766,27766,27766,27766,27766,27798,29879,31959,31959,31992,36152,36152,38265,38265,44440,63128,48633,42393,27734,21461,17234,19282,17202,15154,21428,23541,21427,15120,21329,17135,10862,10861,12909,14989,12908,31598,42064,42065,31598,27405,27372,25292,25292,27372,25324,25324,27372,25292,23179,33743,29583,37936,44274,42128,39983,42096,42063,42064,42096,42096,42064,42096,40016,40016,37935,37935,35855,35855,35888,37936,35887,35855,35823,35823,33775,35856,33808,31695,29615,29614,21066,23211,29421,21098,23276,21197,29583,29615,35856,42261,40148,40115,27502,21197,16971,16971,14858,16939,16939,12745,14891,23309,46453,54938,50810,46618,42424,44439,29583,25357,31663,27470,25390,33842,40180,35922,38035,35954,38064,27565,27502,25388,38030,31596,27465,25351,23238,19078,8581,2211,12805,17030,16998,16968,23336,38092,29673,27529,19206,17093,17061,14918,19207,15013,12899,8707,19173,33832,27559,21254,21189,21285,12930,10787,44175,50349,52593,50745,23309,23374,27405,43982,48273,37739,23175,12710,19051,33842,40180,42293,42358,46486,38067,44538,53021,57051,57051,50679,255},
{29814,29814,27734,27734,27766,27766,27766,27766,29879,31959,31991,34040,34072,36152,38265,38265,42360,56889,44505,42393,23605,21493,19347,19282,15154,19315,21428,23541,19315,15120,25522,21329,10894,12941,12909,14957,14989,31631,44177,42129,33711,27405,27405,25324,27372,27405,27405,25324,27372,35758,35791,31598,29485,33710,35822,31629,18921,21065,25291,23211,18985,23210,25323,25324,23146,23113,23179,23243,19018,21131,21131,21098,21130,19018,18986,23276,35856,29582,31663,21194,12839,21195,14792,25356,35889,25324,19019,19084,25357,29616,31696,40148,40180,42228,33808,14891,14826,14890,14858,16971,14825,8454,14891,19084,42195,59229,50811,42327,42359,40181,25357,27470,29615,25390,25390,29583,35954,42293,38067,35987,44404,27597,19146,25420,40047,35888,27464,25383,21190,16998,8516,2242,6499,14949,19142,14950,17062,23335,25481,27592,19205,23429,12867,12868,14981,12900,8675,10788,21317,25541,23366,19142,19142,19172,10818,10691,25322,33641,44275,46520,19116,17068,33646,52107,49995,43818,21095,16966,23114,23243,25389,27568,42325,40213,38100,33841,38133,50745,50713,42324,255},
{29814,27766,27733,27734,27766,27734,27766,27766,29847,31960,31992,34072,34072,36152,38233,38232,40312,58969,46585,42393,25686,21493,19347,15121,15154,23476,21428,21460,19282,15088,21361,17168,12942,12941,12876,14989,14989,29551,40017,42097,33679,27437,27438,27373,25292,27373,25292,25292,29485,35791,35758,35823,37871,37936,37935,35790,27339,29452,29517,29484,27403,29516,31597,31597,29484,29484,29517,29517,27436,27469,27469,27436,27437,27404,25356,29549,31662,29614,27501,8645,8581,14792,16840,25291,35954,27405,14761,21099,23244,25390,29583,40147,35857,40148,29616,8585,12745,14858,16939,14890,16970,14825,16939,16971,35921,57116,44505,44405,40213,33808,25390,35889,29583,25357,25422,29583,29583,35955,40180,35921,38031,44403,29548,21161,35853,25291,27498,21191,19079,19078,10692,6499,10724,14917,17062,17029,10725,17031,29643,29673,23365,17092,10787,12867,12900,15045,10788,6532,14948,19172,14948,17030,19143,17092,14979,8611,14854,10662,36019,42293,19084,17068,37774,52140,50059,39722,27468,29581,35922,31727,23112,25323,35954,31728,33841,33809,27535,27535,27502,27502,255},
{27766,27766,25685,27766,27766,27734,27734,27766,27799,31992,31992,34072,34072,34072,38232,38265,40280,59000,46585,42393,27766,19445,17234,15154,17234,21395,21428,23508,17234,15120,21361,15055,12942,12909,12876,12876,8715,25325,35791,35791,27438,25325,25292,25292,25260,25260,23180,23179,31565,37839,37839,37839,42096,46289,37935,37903,40016,42096,42097,40048,40049,42097,40048,40048,40049,40049,40049,37969,38001,37969,38001,35920,35920,35888,35888,33775,29549,31663,27501,10694,27436,29257,27177,27242,31534,27470,19051,14729,16906,23277,25390,33744,23018,38002,23277,12778,16938,14858,16938,12778,16971,19051,19019,14858,33775,33841,29649,38003,40148,29583,33809,42293,25390,25390,27503,27503,27470,27470,29583,29582,37966,37934,42193,27371,17000,12744,27466,23270,19077,19111,10725,12806,10660,8612,17062,17030,10725,19112,33866,31785,19173,10788,14980,12899,12903,17062,17129,19082,6531,4418,16997,19110,10691,10755,10787,10627,16934,23177,44406,38035,17036,19116,41934,52140,50059,43818,35823,42097,29844,26137,32086,31630,25227,18986,27535,31728,35954,35987,33841,38067,255},
{27766,27734,25653,27734,27766,27734,27734,27766,27799,31992,31992,34072,34072,36120,38232,38233,38232,56921,46585,42425,29846,21493,15186,13073,17234,19315,23508,23541,17234,15120,21361,15055,15022,12909,12908,12876,21197,31599,35791,35792,29518,23244,23180,23212,23212,25260,23180,23179,31565,37871,39919,39919,33710,42129,39983,37935,40016,40048,40048,42096,40048,40048,42096,40048,40016,40048,40049,37969,37969,35888,37968,37968,37969,35920,35888,33775,29549,31662,29582,8646,25388,31370,31370,33710,12713,31696,31696,14859,12745,23277,23277,31631,27406,38035,38034,18923,20938,14890,19019,12778,16938,21100,19019,12778,33808,29583,19149,27471,35792,25325,42260,44374,25357,25390,27535,29583,27503,29615,29615,29615,40146,40111,40078,31724,25419,23339,27465,19110,14917,14886,8613,10693,6468,4388,14919,19144,12838,10757,14982,17061,17029,10724,12836,4387,17132,23400,25515,27594,25417,23208,25320,16996,10722,6498,6499,18950,29513,39947,29549,23244,19116,21229,46030,52140,50027,43753,37807,48340,29909,30362,24154,44698,54775,39952,29453,19084,19116,31761,33842,38100,255},
{27766,27734,25685,27733,27734,27766,25686,25686,27798,29912,31992,34040,34072,36120,38200,36152,38232,56889,50713,44473,31959,19445,15187,13073,13074,19315,21428,21460,17202,15121,21361,15022,12942,12941,14989,21165,19117,29550,37871,35824,29518,25292,23180,23212,23212,25260,23180,25228,33711,37839,35758,37838,25226,40016,40015,33710,23178,27339,29484,27404,27404,25259,25259,27436,27436,27404,25291,23243,23211,25324,23211,21131,23243,21131,23243,27501,31662,31662,25388,4420,23308,31370,31467,25259,12713,31696,29583,17003,16971,23244,25357,35856,44341,38068,35921,18890,18857,12811,14858,14858,19050,19051,16971,12745,29615,35856,23343,21197,31631,27470,50679,42261,25390,23310,40147,33777,27503,29583,29615,27503,31696,25389,33772,29610,29644,38065,40112,19047,16998,17031,12806,8613,2309,2276,12777,27596,21255,23367,23335,27592,31784,21286,19142,14983,23401,23367,25480,27561,29578,27498,29547,16902,6499,12836,12708,20999,35756,50480,39915,27303,12742,17003,48110,54155,39984,15541,31500,50387,23764,28314,24089,53052,65535,63357,48436,35824,33808,42292,33809,31761,255},
{27766,27734,25685,25685,27734,27766,25686,25686,27798,29912,31991,34040,34040,34072,36152,36152,40280,61048,52825,46553,34039,19445,17267,15122,15122,15154,21428,21428,17202,15120,19281,15055,12942,10861,12909,12908,8715,25358,31598,35759,29486,25260,23147,23180,23180,23179,23147,23147,33711,33678,31532,27307,14662,35822,39983,31629,18952,23146,25291,25259,25291,23113,23113,25324,27404,25291,23178,23178,21098,23243,21131,21098,23211,21131,21163,29550,31662,29582,27469,10728,29614,37806,31500,25226,14823,33776,25390,16939,19084,19116,21196,29615,44308,35922,44308,23277,12778,12778,19051,14858,16970,14858,10633,12746,23309,38034,23310,17004,23310,35889,52792,40115,29648,35858,50777,48501,33776,29583,27503,27470,27470,17070,19084,33805,29545,25353,40146,42227,25451,17031,14985,6534,4453,6534,14890,31756,35947,31722,31691,31722,23334,17030,19176,23400,19174,23367,27593,25449,29642,21191,17030,16998,19110,16869,16901,18918,27338,29517,46353,42028,12709,6501,35626,33479,19668,7609,25259,39985,27892,26169,24089,57213,65535,65535,52824,52923,55003,50744,46486,38035,255},
{27734,27733,25653,25653,27766,27734,25686,27734,27798,29911,31959,34040,34040,34040,36120,36152,40280,61080,52793,46553,40280,21493,17267,15154,17235,15154,19347,21428,17234,15121,17168,15055,15022,12909,12876,14989,10828,23245,29518,31599,23213,27437,35791,33678,35791,35791,35758,35758,37904,37903,35791,31598,25291,29549,29549,29549,29549,29517,29517,27469,27469,27437,27436,25357,25356,25324,23276,23276,23276,23244,19051,27470,25389,25356,23276,21163,16872,14793,8552,6504,31728,40049,29257,29290,39717,40016,23277,12713,21197,19084,19116,27470,44373,35954,40114,27437,10600,19117,27535,12777,14858,12778,16971,14891,19083,40115,21197,17036,25422,44373,52792,38034,23343,25424,50777,54872,48566,35856,27502,25390,27438,25358,25390,25455,21194,29514,35983,54873,48665,40277,33906,27632,23373,10694,25420,35949,33866,31754,31787,23367,19110,19110,21287,23400,17062,27625,25448,23370,29674,16966,10692,14950,14949,14981,14885,21031,29483,29484,35790,39984,19047,8612,25354,14981,11019,17296,35661,44114,44244,36117,27989,61341,65534,65535,46518,46552,48663,50679,44178,41773,255},
{27733,25653,25653,25653,27734,25686,25653,25686,27766,29911,31959,34040,34040,34040,34072,36120,42393,61081,56953,48633,42392,23606,15187,15122,19315,17235,19347,21428,17202,15121,15088,17135,15022,10861,10828,12876,10796,17036,29551,29518,21132,31663,37968,33677,33742,37935,37935,37903,35823,35790,31662,27502,25389,23309,23276,21196,21163,19083,19083,19050,19050,19050,17002,16970,16970,16970,14890,14922,16970,14890,12777,21197,21163,21131,19050,21130,14792,14825,8552,10633,40114,37903,29289,29322,27274,33679,23278,17004,21197,19084,19149,25390,31631,25390,31663,31663,12810,14891,23309,14858,14858,14858,16971,14858,17036,37969,21164,19084,29616,48534,50711,38002,21230,27601,50745,46452,44338,44338,33808,25357,23276,23276,27470,27536,21229,33807,44371,50679,50679,50712,46617,44472,29648,21129,29644,35948,33869,31787,27593,21190,14950,14916,23368,23368,17062,27562,23304,17030,25480,16997,10724,12837,14950,17094,8579,16838,41996,31563,37903,35823,25353,12773,33744,37871,25258,25226,44145,52597,40083,46292,46454,63422,65502,65534,42227,40179,42227,48663,59098,50549,255},
{25653,25653,25653,25653,27734,25653,25653,25686,27766,29879,31959,31992,34040,34040,34072,34072,44505,61145,59033,50713,42392,23606,15187,15154,19315,17235,17267,21428,17234,15121,19249,17135,12942,10861,10796,12876,12908,12876,21262,14924,14923,31664,37968,33742,33710,37903,37903,35823,35823,35823,33742,27534,25389,23309,23276,21164,19083,19050,16970,16970,16970,16970,16938,14890,14857,14857,14857,12809,12777,14857,12777,21163,23309,19050,19018,19018,12744,8486,14825,8552,38034,35791,27209,29289,29355,31534,27504,21197,12778,19117,19116,23277,27405,25325,37969,35888,14956,10665,14924,14826,12810,16938,12811,10665,14890,35857,25357,19084,31761,50647,50679,35889,23310,33874,42192,29545,27465,25418,37968,23244,19018,21163,23244,27438,31664,33841,40115,48599,50712,50679,44372,35953,21259,14886,23306,33838,31789,27562,23368,25449,14948,17093,25448,23400,19175,21256,23336,25480,21287,21254,21255,12837,12837,10725,14918,23144,50351,46223,42097,40016,23240,12740,35889,33743,35855,31533,31696,46551,44536,33645,44308,65502,65502,65437,44438,57116,48663,54970,65534,61308,255},
{25653,25653,25653,25653,25654,25653,25653,25686,27766,29911,31959,31992,34040,34040,34072,34072,44505,59097,59065,54873,42360,23574,15187,15154,15154,15154,17267,21428,17234,15153,29715,17135,15022,12909,10796,14956,14956,14956,23342,19117,12810,29615,35856,40048,44242,46355,46355,46355,46355,46322,44306,42194,38034,38034,35953,33841,33809,33808,31728,31728,31696,31696,29615,29615,29615,29583,29582,29582,29582,29582,29615,27469,29550,19050,19050,19050,19050,10599,14857,12810,14923,35790,29257,29289,27209,35889,25390,17004,16971,23343,21164,21164,35922,38067,42260,37969,14891,21164,10665,14826,12810,16938,12745,14890,19051,33711,27470,16971,31728,52759,52759,35857,23309,29580,27464,23271,23239,19046,25384,16935,8453,21163,21131,23244,27438,29615,31728,38034,50679,48532,25352,19013,17000,14918,12806,31790,38096,27531,29678,33902,21288,25482,19110,17062,21256,21256,19175,21288,19174,25513,19143,6531,4419,6499,130,25225,48270,44110,48403,44177,25225,14854,35854,46323,37903,42162,52727,52824,38001,25193,40179,65502,65502,61210,40241,44501,42356,57083,57049,42321,255},
{25653,25653,25653,25653,25653,25653,25653,25686,27767,29879,31992,31992,34040,34040,34040,36152,52825,59033,59065,52825,40280,21493,15154,17234,17234,17234,19348,21428,17234,17233,27603,19215,12974,12909,10796,12941,14989,12876,21262,19149,12811,27535,29582,42162,59000,44307,31598,31631,31631,31630,31631,29551,27503,29615,25422,23310,25358,23278,23245,23276,23244,21164,21197,21196,21196,21197,23244,23212,23211,23179,27503,27437,33743,25357,21163,23243,21163,21098,19050,19018,8519,21099,27274,23081,25194,29648,21230,21132,21132,19116,23277,21196,31729,40148,42228,27503,27471,23276,10697,14858,14826,16970,12778,6374,21132,40050,31663,17004,29648,52759,52759,33776,23276,27465,25383,21158,19078,19077,29576,27494,23208,25323,21130,21098,23244,27438,29583,35955,33873,33772,21126,14886,16967,12805,10725,29709,35950,29645,33871,31790,27596,25514,17062,21288,16998,14950,25481,21256,19175,19143,12869,6467,19014,21095,14822,31498,44012,37805,42097,37969,37871,41869,35660,31501,31500,29355,37936,50613,42064,39919,48566,65502,63356,40174,23495,21350,19304,27660,25608,23527,255},
{25653,25653,25621,25621,25653,25621,25654,25686,27766,29879,31992,31992,34040,34040,34072,34072,52825,56985,57017,54873,42360,21493,15154,15154,17235,17235,21428,21428,17202,19282,23442,17167,12974,12941,10828,10796,14956,14956,29616,23310,14891,27470,33742,44242,56887,52693,48500,48500,48500,50548,50581,48501,46453,44405,44372,44340,44340,42260,42260,42259,42227,42227,42227,42195,42195,42195,42227,42194,42194,44307,42194,25291,31597,35889,25356,27468,27436,27436,29549,25323,19018,14826,17003,16971,19116,38067,23277,21164,21164,19084,25325,23277,27535,40148,35922,38067,23244,21098,12746,19018,12778,16938,14858,8454,23309,40082,29551,17004,25423,50679,52759,31696,23277,31725,27529,23303,21189,27559,29639,27494,23303,25320,27403,21162,21163,23244,27470,31729,33907,23305,21192,14886,10693,12837,14917,19078,12838,6501,10726,17064,25385,27530,19143,17063,23337,21255,23432,19142,6499,6467,4451,21193,50481,50448,52561,54674,48302,42097,48502,50648,50616,44113,33483,29387,31467,29387,37871,35823,25160,31370,39984,54904,63323,35980,19302,17158,10884,15078,23527,21416,255},
{25653,25653,25621,25621,25653,23573,25654,25686,27767,29879,32024,34040,34072,34040,34072,34072,50745,54937,57017,54873,44440,21525,15154,15154,15154,17235,21428,21428,17201,15121,23442,19248,12974,12941,12876,17070,17102,12844,33810,31729,21165,29583,46387,52693,54774,54806,54806,54806,54806,54806,54806,52726,50646,50646,48566,48565,48533,48533,48533,46453,46420,46420,46420,44372,44340,44307,44307,44307,44307,46420,38001,25292,27469,42260,35921,33775,35855,33742,31662,31662,27371,23276,19051,19051,21197,33809,31728,17003,19116,19084,23277,19052,25390,40115,19019,44308,27503,21197,14826,16938,14826,16938,10632,8552,35954,33776,29551,19116,23310,46485,52727,31664,25357,27562,23303,25384,27558,23300,19076,21189,21222,19046,23241,29484,23211,23276,25389,29583,31697,27533,21193,19145,14886,16998,10724,16998,21162,6469,163,12774,14886,19047,27594,21288,21290,14951,17095,19175,8580,4386,162,16903,41965,48271,46222,48370,48435,48502,52696,50583,50616,44178,31435,29387,29387,29387,42129,46354,25031,31402,25225,27469,48663,27625,19270,15046,17189,15110,23559,29804,255},
{25621,23573,23573,25621,25653,23573,25686,25686,27799,29911,34072,34072,34072,34040,34040,36120,50713,50680,57017,48600,42360,21493,15154,15154,15154,15154,19315,21428,17202,15153,25490,19248,12942,10829,10828,14957,17037,14924,35922,29681,19117,25422,46387,52726,54774,54806,54774,54774,54774,54774,54806,52725,50645,48565,48565,48533,48533,48533,46453,46452,46420,46420,46420,44372,44307,44307,44307,44307,44339,42226,25324,38001,35856,42260,38034,40146,42226,42194,40113,35855,27404,29583,21164,19083,21132,25423,42195,33743,21196,19084,21230,19085,25357,42195,21100,35921,27470,19052,16906,16971,14825,25358,16971,17003,33842,27470,38002,23277,21197,42260,50679,29582,21195,25417,17030,21223,29671,27558,19140,21222,19109,16997,16965,25191,25259,14826,27470,29583,29616,31728,29582,25386,12806,17032,10757,10725,23307,23211,14822,14883,14915,14853,27499,21224,23371,17096,14982,12837,12805,10725,2307,27434,46190,46190,44110,37772,29450,44308,50615,50551,50583,48470,33613,29355,29355,35823,56985,48143,33450,33579,23145,31662,40272,29802,23494,17221,17188,15077,15142,23529,255},
{25621,23573,23573,25621,23573,23573,25686,25686,27799,29912,34104,34072,34072,34072,34040,36120,50681,50680,57017,44472,46520,21461,15154,15154,15154,15154,19315,21428,17201,17201,25522,19248,15022,12909,10828,10795,10796,14924,33809,21263,12843,29583,42162,48500,54774,54806,54806,54806,54806,56886,56886,54806,50678,50678,50678,50646,50646,50646,48566,48533,48533,46453,46452,46420,46452,46420,46420,46452,48500,42226,27437,44340,38034,27502,25291,48533,46485,44373,40179,38066,33808,27502,27503,21164,19083,23245,27470,44306,37968,21164,19084,25488,33906,40148,29616,29583,35855,12681,12713,10698,12712,27470,16939,17069,19019,31728,46453,25389,17003,38034,50646,29582,21196,29613,23336,25415,29671,23333,16996,17029,21190,16997,17030,14821,16806,12712,27437,33808,31696,31696,31728,27501,14951,10725,14919,6532,194,8484,25416,23302,14883,12805,10693,19080,23369,12838,17030,16902,16935,12774,10661,37869,46191,44110,42030,42161,35953,40147,46357,46324,46357,46324,31468,29355,27274,38001,65535,61178,41706,39496,29160,23242,29802,27688,23400,29801,23525,10883,12997,13029,255},
{25621,23540,23573,25621,23573,23573,25686,25718,27767,29912,34105,34072,34072,34040,34040,36120,52729,50680,56985,44472,44440,19380,15187,15186,13106,15186,21428,21427,15121,15121,25522,17168,12942,12909,10796,12909,10763,12876,29681,21295,14924,27503,29582,42129,56887,46420,40049,40049,40049,40049,40049,37969,35889,33808,33776,33775,31727,31695,31696,31696,31631,29583,29550,27502,27502,29518,29517,29549,31662,40113,35822,37903,42227,38034,27372,46420,40212,38099,36019,33906,31760,23275,25390,25390,19051,21196,23277,27470,35921,42194,23309,19117,23375,35954,35955,27438,38034,14858,16905,12745,12712,12712,16906,19084,16938,40147,50614,31663,16971,31728,48566,27502,23309,35888,19113,29610,27559,27526,21222,16997,17030,12804,10693,12773,14789,21127,37967,25359,27504,33809,29616,27533,14983,4451,4420,2307,226,4418,21189,21191,19110,10755,4386,19016,25354,14983,12837,12774,27403,16904,14823,41997,46190,46223,52630,52728,52728,48535,46454,42261,38002,35856,31435,33581,25193,42194,65502,61146,35367,35303,29127,18920,25512,23494,25544,25608,19300,10883,8771,10885,255},
{23573,23540,23573,25653,23573,23605,25686,25718,25719,29912,34105,34072,34040,34040,34040,36120,52697,44440,54905,46520,40280,17267,15187,15154,15186,17267,23476,21395,15121,15088,23442,17168,12942,10829,8716,12876,10796,14956,29616,23311,14923,25422,33743,44242,56887,44275,33743,35823,35856,35888,37936,37904,33776,33776,33776,33775,31695,31696,31695,33776,33743,31695,31662,31663,31630,31630,31630,31662,33776,42226,35887,27338,44307,46518,33742,46453,40212,38100,36019,40179,23306,6499,8645,21161,23211,21164,25358,23245,21196,40082,44307,27502,23277,33809,38067,44308,48566,35855,29517,29549,29549,31630,37903,42128,40015,37935,44339,35889,16971,25422,48566,29583,23309,40049,27405,35953,29608,23334,21222,19142,17029,14885,14853,14918,14854,19014,31658,17069,17006,35889,31696,29616,21258,8676,4483,2339,10728,8613,10755,19109,17029,12837,8644,12774,21065,23274,19144,23242,29321,21001,21033,44110,46223,54807,56922,54841,56921,58969,42228,31761,31695,25292,27274,29387,23081,40147,63356,42000,39887,42064,35857,42293,42321,29770,25576,23496,21414,21446,15140,10884,255},
{23540,23541,23573,25653,23573,25653,25686,25718,27799,31992,34105,36152,34072,31992,34040,36120,46520,42392,56985,46521,36152,15219,15187,15154,17234,19315,23508,21395,15121,15121,21361,17168,12942,10861,10796,12876,12908,14956,27504,23311,19084,23374,35921,35921,35987,38002,42227,40180,35987,40179,38001,38001,35920,35888,33808,33840,29614,42326,31696,27339,27372,23212,25194,27307,25194,21066,14792,19018,23114,35855,31597,27404,46452,50711,38000,44340,40179,38067,35986,40146,14886,6532,10756,6531,21162,23244,21196,23277,23277,25390,35889,40081,31694,31695,38001,42194,61078,56820,35855,35855,35855,35855,50513,33773,31726,29580,31694,40147,21229,19116,46421,29582,21163,40114,40114,33972,29581,19079,19110,23335,21255,14917,14918,14886,12742,23241,23240,23241,23178,33775,35889,31696,27535,23339,17063,10791,17069,6439,12807,14948,12901,10692,6500,4419,4388,10663,17002,19112,23113,23179,23209,46190,46158,42129,50680,52761,54841,44308,29713,40211,44209,42032,35693,27274,23081,44341,63259,33451,33842,31532,29451,29419,29647,38033,27499,21352,19367,17254,15141,10852,255},
{23541,23541,23573,25653,25653,25654,25686,25718,27799,31992,36153,34072,34040,31992,34040,34040,42360,42392,56985,46521,29879,15219,15187,15186,15154,19347,19315,19315,15121,15121,25554,17135,12942,10829,10796,10795,12908,14956,17037,21197,23245,25390,33809,25423,25455,25455,19182,29714,31826,33939,31794,31793,29713,29713,29681,27600,25324,38198,36020,25194,23146,14857,12582,18888,18823,8549,2244,8487,14760,42194,35855,27371,33710,44372,33743,44308,40179,38067,35986,42227,19017,10661,12806,8677,12807,33743,27470,21164,23277,23277,25390,27470,40082,38001,37902,48434,61078,58965,50482,52627,52660,50579,52626,42127,27436,29548,35853,35887,19051,14891,44340,29647,21163,38067,44374,37903,33645,25258,21095,23303,19110,12805,10724,10661,6467,14951,29516,27403,21032,37968,40115,33841,31696,29616,21226,23341,25455,25554,23441,17031,6530,8643,4418,2274,4387,4357,14889,12742,17001,25356,27402,48271,48271,37707,44211,46423,44341,40146,27632,42162,44177,39984,39919,33581,35726,54970,54775,33451,31664,27404,29549,39788,44146,63422,52759,27626,23560,17190,15078,12996,255},
{23541,23541,23573,25653,25653,25654,25686,25718,25751,29944,34105,34072,31992,31992,31992,34040,38200,42393,56985,44441,25686,17300,15187,17235,17235,19347,19347,19315,17201,15121,23442,15055,12942,10861,10796,12876,12876,14957,19150,21230,40081,29550,29681,25359,27471,23376,17069,38100,44405,40114,38033,35921,35920,33840,33807,33776,27535,38166,40280,21001,23049,14761,8389,14695,12550,6469,6340,10535,12745,12776,25356,33644,27339,33743,48534,46485,38099,36019,35986,38034,33743,23242,12807,14920,14856,23274,29549,25389,23244,23245,23277,25390,31696,40016,33710,48467,61078,61046,56787,61046,61046,58998,54707,29484,4294,6470,25387,40081,19051,10697,38034,33809,23277,23277,33841,37968,39918,33579,29451,23337,19046,14854,10661,4323,290,2466,33806,42096,29484,42193,48501,38001,33841,29648,27535,27536,27471,25423,34071,25483,14980,21285,14948,2274,4356,8550,12744,10629,14855,12869,21192,46256,48337,35562,46324,48502,44309,44308,29648,23081,27242,27241,33547,33548,31695,61309,65535,50419,29290,35889,33841,33775,40049,63389,63389,33740,25545,19239,17096,21417,255},
{23573,23541,23573,25621,25653,25654,25686,25686,25751,31992,34105,34072,31992,31992,31992,34072,36152,40313,56985,40312,21525,17300,15154,17235,19315,21395,21395,17234,15153,15121,21329,12975,12942,10861,8716,10796,10796,12843,21262,25390,48468,33679,25456,23278,23343,27634,17134,23342,35921,35856,35856,33775,31695,31695,31662,29550,25291,40214,38232,29517,29517,21130,21098,23178,21098,19050,23243,27370,12743,10663,33775,37870,27371,29517,52791,48598,38066,35986,35954,35921,27468,12773,10630,19051,21229,14888,29548,31661,27469,23277,23245,21229,36049,39981,29451,40244,61046,61046,56787,56853,56885,56853,52627,46320,39982,37902,27403,40081,25356,14858,35921,31728,25422,27502,35922,33743,35693,33579,31499,25225,23047,23112,18919,4290,2403,25451,37935,31596,46387,44339,52727,46388,35888,31696,29616,27535,27503,29614,33837,27561,25479,25446,17027,14918,12775,14887,17002,21097,16903,8675,17062,46224,41965,37870,48502,48502,44309,44277,37937,29354,29354,29387,33613,19114,29810,63422,65535,48306,39985,57181,52858,21131,33905,63356,63324,29451,25257,25257,14760,17001,255},
{23541,23541,23541,25621,25653,25653,25654,25686,27767,32057,34105,34072,34040,31992,31992,34072,36152,40345,54906,34007,19413,17332,15154,17234,19315,21395,21428,17234,15121,15121,17168,12975,12942,10829,10828,10796,12876,14956,25423,21165,42195,31599,27535,23375,23342,23343,14956,10729,27502,27437,27437,25357,25357,23276,23243,31695,40082,42262,36086,35823,40080,21130,19050,21130,19050,19018,21163,25291,27403,40081,46419,46387,31532,29517,50711,48566,38066,38034,35954,35921,27501,12740,8517,14825,21230,23180,14757,10660,17032,27532,25451,23309,27696,37965,42160,38326,50547,46387,46354,31662,29582,31662,29582,29582,50579,35723,27370,44307,31664,19086,25422,27535,27535,35725,37969,31630,35725,33546,25256,16838,27305,29482,16870,8515,12838,17062,23402,25256,31597,48565,54839,52726,40113,35888,31696,29616,27536,31727,29674,23334,21222,16996,12837,17062,17030,14886,19079,27436,21098,10724,19046,35756,44110,39951,48534,48502,46389,44277,39985,29354,29354,29322,23113,15018,36083,65470,65470,42129,44536,65535,54938,33808,44404,63356,57050,35921,25422,31728,23146,21097,255},
{23541,23541,23541,23573,23605,25653,25654,25686,27767,34105,34105,34072,31992,31992,31992,34072,36152,42425,50778,29911,19413,17365,13106,19315,19315,21395,23476,17234,15121,15121,15088,12975,12942,10861,12908,10796,12876,14924,23310,19084,33776,21164,29649,21263,23277,23309,25357,10760,12808,10696,14922,27535,31827,14923,14922,19083,21132,23309,29649,29485,40081,27436,23211,19018,19017,23179,19018,18985,23145,44241,44306,50613,33709,29517,52759,44340,38034,38034,35986,35921,35888,25290,19018,25455,21197,27374,8548,8613,8612,16997,12804,27466,21290,25354,33839,34199,54707,48500,50547,31662,29582,29582,29615,27502,46386,35692,16807,37968,35922,19217,23309,23309,29648,31661,33809,31630,37805,25256,14853,12708,23143,29513,23239,23238,29546,8707,15079,17032,25291,40081,54872,50646,42226,46420,38002,31696,29612,29641,27560,27560,21255,21192,17031,19143,27529,19143,17061,12805,14918,14855,21127,27369,42063,42129,48534,46422,44277,44244,37872,29322,29354,29322,27242,23113,33905,61276,65437,39724,50679,65535,59196,55003,59097,63324,52825,46584,29746,40246,27339,23178,255},
{23541,23573,23541,23573,23573,25653,23605,25686,25718,34105,34105,32024,31992,31992,31992,34072,34104,42425,52826,31992,19413,19413,15187,17202,19315,21395,21428,17234,15121,15121,17168,15055,12942,10861,10828,10828,17102,12876,17037,14923,35856,25292,29680,31697,25390,23341,27503,10761,8679,6567,8584,25357,36019,12875,14986,14889,10663,19084,23309,29452,37839,29452,35856,21163,19050,31662,19017,23178,25291,40016,37968,44339,31695,25357,44340,31630,35888,31662,38034,40114,33808,33743,37936,29615,29583,29550,21225,21194,21226,23307,23306,31693,25319,25320,38098,32020,50546,44307,50580,31663,29550,29582,27502,27470,42194,42063,16741,31630,46420,29616,23277,21196,33776,37967,31695,35987,25419,16934,12806,18981,39880,27431,23303,17029,23302,14917,17063,23305,31564,37969,44340,52726,48500,50678,50646,38001,31722,23301,17061,21286,16998,16999,19112,17030,14982,14918,12837,8643,17094,16999,16968,19045,12804,31695,46389,46389,46389,56921,42064,29322,29355,29355,27274,27242,29615,54937,63324,37742,54938,65535,57051,55003,56984,61178,50777,44406,27666,40213,12646,6372,255},
{23541,23573,23541,23573,23573,25653,23605,25686,25751,36217,34105,32024,32024,31992,31992,34072,34072,40313,54874,34072,19413,19413,15187,17202,19315,19282,23476,17234,15089,15121,19249,12975,12942,10861,10828,12908,14989,29550,37870,35822,42096,39982,39983,42063,42095,39982,39950,35756,35756,33708,23241,39917,42063,35789,35789,35789,35789,35757,37869,33644,37871,35887,40049,33743,33840,37968,35887,37968,35887,40048,35823,37903,37936,35920,40081,37968,40080,38000,38032,40081,37935,40113,42193,29549,29646,42226,35920,33905,40211,40211,35953,35985,29742,27465,38066,29777,50546,46419,52692,33743,29550,29550,27469,25421,38001,48368,12548,27436,42259,35921,23277,21164,33808,42096,39887,40343,25485,12838,14950,29640,29575,23238,14885,12772,21222,6626,6659,19207,29580,35888,42194,37967,48532,54904,56985,48532,37965,27529,23336,17061,12836,12838,17031,21255,14918,10724,8611,12837,14950,12837,8484,12740,4449,2242,10630,19050,29518,42195,35726,29355,29355,29355,29322,27307,46486,65502,61211,33873,57148,65535,54970,55003,50678,56952,46518,48632,46584,38002,10566,6405,255},
{23573,23573,23541,23573,23605,25654,25653,25686,27799,38330,34104,32024,31992,31992,31992,32024,34072,40313,48633,38200,19445,19413,15219,15122,17202,19282,23476,19282,15121,15121,15088,12975,12942,12909,10860,10828,10796,37903,46223,44142,44143,46191,46223,46223,46255,46255,46222,46223,46223,27531,10726,44110,46223,44111,44110,42030,39949,39949,42029,33644,33677,33839,33872,29646,27533,25291,33645,27339,29451,33677,29451,27371,31564,33677,27371,29483,35790,29419,27370,33677,31532,27371,29451,35855,31726,40178,46452,44404,48630,50678,46420,46485,48630,48565,42225,33840,48433,48467,54773,42128,40080,40048,40048,40048,42193,52658,35691,23176,31726,42195,23277,21164,27502,39984,39919,40343,29582,16999,19143,25415,16997,14886,10725,4386,10757,4514,6659,17094,23306,35920,42194,40016,33742,50645,56985,48500,40112,31755,23369,19111,21225,19143,21256,27500,16999,21256,12805,8644,10725,14918,4322,14789,14917,6434,6466,19015,18919,23209,29387,31467,31435,29355,27274,29388,48599,65502,56855,35661,57083,61276,54938,54970,44307,59162,48501,23243,25291,27209,25257,14951,255},
{23573,23573,23573,23573,25653,25654,25654,25686,27799,42490,32024,31992,31992,31992,31992,32024,34072,40313,48601,42393,23606,19413,15219,13073,19282,19315,21395,23443,17201,15153,15088,15023,12942,12941,12908,10828,8715,33775,46255,42062,44142,42062,44110,44110,44143,46223,46223,46223,44175,14984,8549,31628,33709,33741,31661,31628,29580,29548,25322,25420,27469,33839,31791,33871,29678,23243,33677,25226,29483,31564,33677,29484,29516,35822,29548,33774,35855,33710,33742,33710,39983,35822,35790,40016,29483,29516,33742,42161,40112,40113,40080,38000,40080,42193,40079,33774,44240,58965,56885,52594,50579,50579,50547,48434,50514,46288,31629,29612,40146,44372,21196,21164,25422,33678,39920,40343,27469,12806,10757,10724,10724,12772,12772,6499,8644,2370,6627,15015,25421,37968,42162,35856,31662,40081,54871,52758,40111,31690,23336,31693,29611,25418,19111,17030,12805,14917,19142,12804,8645,17063,8547,12774,21190,25287,29481,35821,29451,31596,33548,33516,33516,31435,29322,29485,44405,59195,52727,38002,57051,54937,52890,55002,52791,65534,46322,27598,29452,37415,27271,12934,255},
{23605,23605,23573,23573,25653,25654,25654,25718,27831,42490,32024,31992,31992,31992,31992,34072,34072,38265,46553,44441,27767,19413,15187,15154,19282,19315,21395,19314,15121,15088,17168,12975,12942,10861,12909,10828,12876,31662,46256,42062,44110,44110,44110,44142,44142,46223,44175,46255,42094,10791,17097,21389,19308,19244,21389,21388,19276,19276,12840,19243,25517,39983,35855,37871,33709,38000,40049,33710,37903,35855,40016,37903,35790,37903,37967,40048,37935,37935,37967,35790,37903,37935,37903,35790,35855,31726,31758,46420,46485,48630,48598,46517,48564,46320,52625,35821,44272,50547,48499,42129,27469,27502,27470,27469,40081,35823,4423,19372,42291,46420,23244,23244,27470,29420,37937,40311,21290,8676,8741,8676,14981,12836,10692,8612,10725,8709,10789,12870,27600,37968,42162,40213,33907,33776,31662,42193,44337,37997,27562,23336,23335,25416,12773,12805,19110,12803,10756,6563,8644,14983,10662,12741,29607,27431,29447,23207,21128,29548,33643,21063,21095,25225,27306,31565,52922,63357,48534,40212,65535,63389,52857,57084,46453,57050,39983,29483,31595,25288,16998,8677,255},
{25686,25686,25654,23605,25653,25654,25686,25718,27831,40442,32024,32024,31992,31960,31960,31992,34072,38233,44505,42393,34072,19413,15187,17202,19282,21395,21395,17202,15121,15120,15088,12975,12974,10861,10829,10828,17069,42194,46288,44142,46223,46223,46255,46288,46288,46288,46255,46255,37934,8743,21388,23502,21421,17195,21421,19373,19341,19373,12938,17131,17098,37870,27337,33677,20967,25224,29515,31564,25322,25290,29516,18885,27338,27370,29483,27500,27435,29483,27370,29516,23177,29548,31694,29483,40081,40048,42193,48532,50645,50678,52790,52758,50645,50514,52658,42160,42192,54707,48467,46354,27469,27469,27469,27469,35888,42160,8519,21389,40210,46420,25324,23244,23276,33613,40082,40311,21289,12901,12934,15046,12901,10724,10692,12709,16965,10757,12870,12806,19117,33776,42162,35889,27437,37936,17101,21227,48467,46419,33804,25416,25480,21222,12805,17032,21223,12836,17031,17065,21225,21225,27465,29544,29608,27400,27432,23270,21094,19014,18982,10628,4513,2402,14855,21196,55002,65437,41901,44210,61244,61211,46551,50745,44307,52824,50548,23145,23273,23369,10789,8677,255},
{25718,25718,25686,23605,25653,25686,25686,25718,27831,40442,32024,32024,31992,31992,29911,31992,34072,36185,42393,40313,38233,21526,17300,17202,21363,21363,23475,17202,15089,15121,15088,12975,12942,10861,10828,10796,14957,42193,48368,44142,46255,46255,46255,46255,46255,46255,46255,46255,37934,14984,31855,36049,36082,31856,34001,36081,38162,36049,35985,35920,38065,44274,42193,46387,40016,42226,44306,48499,44338,46451,46452,44371,48532,44339,50645,48597,50710,50645,48565,52758,48565,52823,50710,52791,54871,52790,50710,50742,56984,48565,48597,56984,52823,48663,50776,50743,46451,54707,52660,52659,44241,46354,46354,46386,46386,52627,40015,44272,50579,46452,29550,16971,16939,33645,42163,40278,21257,15013,15014,12933,10789,10724,10725,10629,14886,12838,14983,14985,16906,33743,42227,31696,25325,37969,33809,25421,42162,46451,33834,27561,23336,14917,21193,19144,14917,17065,23309,29644,29545,25351,31656,29512,29543,25287,19078,19110,16933,21159,16966,12773,6498,4450,16967,21356,57115,61243,37611,44373,52792,54937,52890,57083,54839,57017,50548,14726,16967,29384,19015,10758,255},
{27831,27799,25686,23605,23605,25686,25686,25686,29911,44635,32024,34072,31992,31992,29879,31960,31992,34105,40345,40313,38265,21558,17300,15122,17202,19282,23475,17201,15089,17169,17168,13007,12942,12909,12909,10828,25455,42193,48368,44142,46223,46223,46255,46288,46255,46288,46256,46255,40047,21258,56885,54806,44371,46484,46484,46452,52758,50580,54806,50645,52758,54839,52758,54839,50678,54871,52694,52758,52726,52726,54838,52758,54838,50612,54871,52758,52790,54871,52758,52726,50612,52725,52726,54838,56951,52758,48532,48532,56951,54806,48532,56951,50645,52823,52758,46420,52692,56820,50579,54740,46289,44241,44241,42161,40048,50514,25291,23340,35984,42259,31663,10732,12780,33678,38132,38165,29483,17031,12933,15047,10821,10789,8644,8516,6501,12838,4482,10759,16906,35953,48698,31696,29517,40082,40114,35920,44274,44304,33770,23271,21159,21224,19111,14950,12837,21196,27502,27529,21159,31688,27528,19046,25319,29512,21189,21158,14853,19046,16934,12741,10661,6467,14853,15081,55003,59098,35465,52760,65502,54937,52922,59163,56951,57017,42129,27404,27404,18888,14759,17033,255},
{29912,27799,25686,23605,23605,25686,25686,25654,29911,44667,32024,34104,34072,31992,29879,29911,31992,34105,40345,38265,36185,21526,17332,15121,13041,19282,25524,17201,15121,15120,13007,13007,12942,12909,10861,10796,35888,42160,48368,46223,46255,46288,46288,48368,48336,48336,48368,48336,44208,17098,44175,48434,48467,56919,56919,59000,52758,50547,44306,52627,48466,52692,48434,54806,46386,48499,48401,44209,52627,46354,50579,48499,42225,40047,50612,48498,50645,48499,44273,40080,40047,42193,42160,42226,46418,46419,33709,37967,44435,42290,40210,35919,35919,38065,29581,31694,35919,50578,44306,52660,33743,27501,29582,27502,27470,42193,16938,10891,23502,40179,33775,12779,16973,35888,38165,36020,29420,27468,12935,12902,10821,8644,8644,10693,10694,10726,10725,17066,29550,35920,38002,31662,40081,40114,38066,38032,42193,42193,35916,23335,33869,29610,19143,23336,12837,25422,31696,21192,23304,27527,29544,14820,19046,27463,25383,21126,16933,10660,10661,10629,19016,16872,14823,6532,19276,48598,33515,54970,65502,52824,55003,57050,61177,54937,48664,44406,42325,19080,8646,19177,255},
{29912,27799,25718,25654,25654,25686,25686,25653,29911,44667,32056,34105,34104,31992,29911,29912,31992,34105,38265,38265,34105,21525,19413,15154,17169,23475,27604,17201,13040,15120,13007,13007,12942,15054,15021,12908,31728,33775,42031,37870,35757,35789,35757,35757,35757,33677,35725,33644,33645,17132,33772,56852,44305,38064,38097,33806,31661,29515,39885,27403,33741,40144,37999,36048,33838,31757,25289,27402,31725,38097,27564,31855,34000,27468,21161,33902,38258,29774,27597,14823,29580,29710,23242,23307,31758,42225,14759,27533,29808,31920,36179,16969,23307,29807,23308,21195,25452,46320,46386,50580,35856,27501,29614,27502,27502,44273,25388,15083,27598,40179,29550,14923,23277,40114,40246,35987,25291,33841,33775,19111,10853,12901,10788,10693,10694,14921,16904,10664,23243,37968,37968,35823,44306,42194,40114,38000,42193,40114,42193,37998,48565,35917,27562,25449,19178,29616,27533,27470,29643,25414,23239,21157,27496,29544,25383,19014,8547,4322,6403,10629,12709,14758,10597,4388,6533,19051,31664,59229,63389,50744,55035,57017,61243,52824,48632,27502,27597,17095,6596,23370,255},
{29912,27831,25718,25686,23605,25686,25686,25621,31959,46715,34104,34105,34072,32024,29911,29911,31992,34105,36185,38265,34105,21493,19413,17202,19250,19282,25555,17201,13040,15088,15088,12974,21328,34036,25519,23373,35987,29615,37870,25259,21065,23114,23114,23114,23114,23146,23146,23146,23178,17100,21192,56754,38031,25549,25549,23372,21162,23242,35854,23242,29548,33870,33839,29742,31758,29644,27402,27370,29580,29581,27564,33903,38128,33773,27435,35983,38193,31822,36016,23177,31693,31725,31693,29613,33838,35951,27435,35952,36017,38129,40242,31661,27468,38097,40146,35888,35887,46353,56853,56853,50547,50579,52660,52660,52660,48466,48466,37967,44240,35888,31631,19051,29582,48665,42359,33874,35725,31728,37871,27305,21160,12869,6596,6564,12807,19082,4228,10665,23243,38001,40081,40016,44307,42162,40114,40113,40081,40082,42194,44274,29614,33806,35953,23341,25455,27565,19176,29582,31723,27463,21158,31719,21126,14820,12741,12741,8515,12708,12676,10659,8611,8676,4419,2338,6500,10662,25324,42358,61276,50776,57116,56984,63323,50744,44406,21229,29711,17063,8677,19080,255},
{32025,27831,25718,25686,23605,25686,25686,23573,31959,48762,34105,36185,34072,31992,29911,29912,31992,34105,36185,38265,27831,19445,19380,19250,21363,23443,27603,17201,13040,15088,15088,15055,33972,36051,21228,21228,40180,42227,44176,27371,23146,25226,25226,25226,23146,23146,23146,25194,29485,19180,19080,54641,44337,38064,36016,40177,40080,37902,38032,37934,35854,42224,42193,46451,42225,44338,40047,44274,44241,46419,46354,46451,52724,42161,50612,48499,50678,48532,50645,50580,40081,52790,48565,52791,52725,50645,52758,44307,56952,52759,52759,50678,44372,54904,52759,56985,52792,52693,48467,50547,44241,42129,42161,40081,37968,42128,37903,27469,27533,35920,33743,19019,29582,44406,40311,33841,29452,35921,35790,31435,29419,21160,8677,8677,12807,14920,14890,27601,29549,38001,40081,40048,46355,40114,40081,42161,44274,42195,42194,40114,25422,35888,33809,21262,23375,29581,25322,27562,29608,21158,23239,29608,27431,21062,12709,23240,23238,14852,14821,10692,10788,12869,6596,4451,6532,10662,21096,16967,40213,40180,44406,59097,65469,48500,31565,29485,21098,16935,10790,19015,255},
{32025,27864,25751,25686,23605,25654,25686,23605,31959,50810,34105,38233,34072,31992,29911,29912,32024,34105,36185,38265,25686,19445,19315,19282,21395,25556,25523,19314,13041,15121,17169,23343,46453,40180,25454,25421,27567,38033,44241,27371,25194,25226,25226,25194,23146,23146,23146,25226,31630,17034,14887,44143,48435,56919,54872,54839,52759,48500,50646,50613,46453,52726,48533,52791,48533,52727,48533,50646,48566,50711,50646,50647,50614,48598,50679,48566,50711,48566,50679,46485,48566,48598,46453,48631,44470,50711,38067,36083,46518,46550,38196,38066,50679,33938,36051,36083,36050,46386,37936,44274,33742,27437,27502,27501,25389,40048,27372,8584,17098,33872,33775,16970,31663,44275,40279,31696,23211,42227,37838,29386,23145,31499,23209,19080,12774,21195,27503,40279,31662,35856,40016,42129,44307,40114,40081,44241,44275,38002,21164,37968,50613,48468,29616,19149,23407,35985,33774,35917,25384,23270,23238,21158,19078,21127,14854,23208,23206,10628,4354,8644,10756,12869,10788,4451,226,4388,19017,16934,12873,31859,31565,44178,63389,44209,27338,29419,14759,10597,17094,27401,255},
{29944,27831,27799,25686,23605,25654,25686,25654,29879,48730,36185,40345,34072,31992,29879,29912,32024,34105,36185,36217,23638,19380,15121,15121,19249,21362,23410,19249,15055,17135,19183,21262,40082,31728,21228,23309,21196,27469,31597,25258,23178,23146,23146,23146,21065,21097,23146,23178,29550,14922,14887,42095,31727,29711,27566,27436,23340,21228,25454,19083,25486,19147,44405,38099,44405,40147,42195,46421,42292,46485,38131,48598,40146,48566,44340,46485,48598,44437,52759,44372,52791,48598,48598,52759,48663,54904,46486,48631,52824,54905,50744,50743,56985,52824,52857,54937,54937,50547,54772,54773,50514,54773,54773,54773,52660,46386,48433,42160,29547,25387,29550,16970,33776,46453,42326,31695,33613,35922,31500,27306,29354,27306,29452,31662,29581,31695,29517,33809,31630,35856,37904,40048,46387,40114,42161,42193,46355,40082,21328,27601,48533,46420,27535,21229,25422,42291,48468,35822,29545,31688,25350,14755,10660,19046,10596,12708,14821,12708,8579,10756,8643,10756,10789,2338,4419,194,6437,25323,19112,6631,27340,33483,37937,29550,21097,23310,19084,29647,21227,27338,255},
{29944,27831,27799,25686,23605,25654,25686,25654,29879,48763,40345,40345,32024,31992,27831,29912,32024,34105,36185,36185,23638,17235,15024,21229,23373,21196,21196,19115,21131,25258,18951,23144,23079,12712,14824,10631,14824,12743,12711,16937,12743,16937,16872,16904,19049,14824,21163,16937,31695,17035,14887,44176,27534,23405,23438,19083,19050,19083,23309,21293,25486,21325,48566,54872,54872,54840,54839,54872,54839,54872,52792,54904,54872,54840,54840,52824,54904,50678,54872,50711,52824,52824,48534,54872,48598,54904,44469,40244,50711,44276,40243,42324,50646,36051,38196,40308,40276,48467,48402,50515,42096,44209,42161,40049,35855,42193,33677,25323,23242,29483,27437,19051,31696,38001,40214,33776,35824,29518,27339,27306,21000,29484,31629,35823,33776,35856,33711,31662,37936,40049,42161,42129,44307,42194,42194,44241,44275,42195,35921,35954,48533,44307,25455,19181,25455,29578,44209,44144,35820,33737,21093,14820,23239,25320,16933,12708,14853,16902,12773,10723,8643,6563,6563,226,4484,226,161,8677,33839,23306,21195,35725,33547,19050,4482,10856,31762,25484,14985,27370,255},
{29944,27864,27799,25686,23573,25654,25686,23573,29911,50875,40377,38265,31992,31992,27831,29912,31992,34105,36185,36185,27799,17267,12943,10568,41997,44175,44305,40047,40079,42160,29581,40080,35822,31694,42096,29549,40080,33709,33774,40047,31629,44241,33709,37935,42063,29548,42161,29549,42194,14955,14886,42063,25454,19244,21389,16938,14824,12873,19147,23567,23470,27696,44372,40211,44372,44372,38067,48565,40081,48565,40146,50678,44372,46420,46452,46485,50678,44339,52726,46453,50678,50678,46453,52758,48597,54871,46549,46485,52791,50613,46484,50678,52758,50710,50710,50743,50710,48434,31597,46322,27469,23244,23277,23276,21131,40080,10599,4293,25258,33644,25292,17004,29648,35856,31860,33809,38166,33875,31695,29485,23113,23309,29550,35856,33775,35888,33711,35823,40081,40081,42162,42161,44275,42162,40081,42161,44307,42195,42161,46388,46452,42259,23342,27532,48459,33806,35855,42096,46290,37933,27466,27467,25352,25320,19110,14788,10660,10628,10756,12868,8675,8676,8675,2370,6563,2306,258,288,10821,27597,42292,27436,23079,27467,6657,13064,33904,12902,6596,10660,255},
{29977,29912,27831,25718,23573,25654,25686,23573,31959,46747,44505,38297,31992,31992,27831,29912,31992,34105,36185,36185,29912,17267,15057,12680,41965,50416,44305,40015,40080,44241,33774,42128,35854,33775,42128,31597,42129,33677,33774,40015,31629,44241,31629,37935,40015,31597,42161,29516,42193,12874,16934,46256,48500,48597,42259,31629,42128,46354,48500,48532,46387,50613,50612,48434,48434,46419,48467,44274,48499,48500,48499,48467,48500,46419,44306,44274,44306,44338,44306,46452,42258,42291,42226,38033,42290,38000,35887,35920,33807,31694,29549,33936,31727,29712,36017,33904,29711,46321,35823,46355,27437,23276,23276,21229,21196,40048,6439,4325,31563,31566,18921,16971,31728,35824,33809,35856,40213,44537,33842,29518,33711,33873,31695,35856,35856,35888,35855,37936,40114,40049,42162,42161,42195,42194,42194,46322,42162,40082,40081,48468,46387,42227,25423,23373,44299,35887,37936,40081,42194,46257,42161,42194,33870,29545,25319,25355,25354,19081,17031,8675,10756,6595,10788,4483,6563,225,2338,2401,2498,4611,23403,42259,25387,25419,12997,15047,10789,6596,6595,2371,255},
{29944,27831,27831,25718,23573,25686,25718,23573,34039,46780,46586,40345,31992,31992,27831,29912,31992,34137,36185,36185,29912,19380,15089,12680,41932,50448,42160,37935,40080,44240,35854,42128,35822,33807,40047,29581,42161,31629,35855,39983,31629,44209,31629,37968,37935,31629,42161,29484,42162,12906,10693,29548,33904,35952,31792,19017,18953,27468,25388,27565,23405,25485,27566,25550,23372,27696,21260,23470,19082,21163,19082,25453,12841,25485,23438,17001,23308,17000,23373,25647,23437,25680,27663,27598,25615,23405,14921,25485,27760,14954,19082,25680,25518,15051,27695,27663,23405,46354,37935,48435,37968,40048,40081,40081,37968,44273,27436,25323,42127,33775,14794,16971,33777,35856,35856,35856,37904,36020,33908,23212,31663,29583,33775,33743,35856,37969,37936,40016,40114,38001,37936,42129,42194,42194,42161,44209,42194,35856,37902,48500,46387,40114,27568,23374,27535,33740,42129,42259,40146,42194,50613,50711,50645,29546,27530,31759,42390,31728,23339,10756,10756,6530,6595,4483,2370,260,6405,6564,4578,4610,8707,17193,42259,38065,12902,15048,14984,4515,2370,2339,255},
{27864,27831,29879,27799,23605,25718,27767,25654,36184,48860,44505,40345,34072,31992,27831,29912,31992,34105,36185,36185,25719,19413,17202,12680,39884,52529,44273,37935,40080,44241,35854,42161,35822,35887,42096,29581,42160,31629,37935,37903,31629,42161,31596,40048,37902,31661,42128,27436,42194,14955,2404,15018,19309,17196,21390,12647,10631,19178,17066,19276,21357,17131,21325,23502,21292,21325,17066,23470,19179,21260,21292,25550,17066,25453,23470,19179,25454,19179,27534,17002,19115,23438,23308,25454,21292,23308,19147,23340,23405,19082,19082,19147,25421,19115,21228,25486,19082,48434,48435,50515,42128,42161,42129,40016,27371,25291,23210,23307,33871,37903,19018,16970,33777,23244,31663,35889,37936,38002,38035,23212,31629,29550,29549,29550,33808,40049,42129,37936,40114,40049,42129,42161,42195,42195,40114,42128,42162,27535,29615,44339,44307,40115,25422,25488,29614,35821,44210,40179,40147,38034,46485,52791,46387,33741,29547,27531,40374,42358,27469,17032,10788,8676,4483,4419,2339,19247,16971,4292,12934,10853,8707,2466,12966,38163,42291,25484,17096,6628,2338,227,255},
{27864,29912,31992,29879,25686,27766,27799,27799,42490,50940,48666,40377,34104,32024,29879,29911,31992,34137,36185,36185,25686,19380,17202,10632,41964,52561,44272,37902,42192,46321,33806,44241,35822,35855,40048,29581,42160,31597,37968,37903,31629,44209,29517,40048,37870,33742,42128,27469,40113,14955,4517,17163,21454,21357,16970,16937,14922,14856,17066,14792,21163,19179,21228,14888,16937,12744,19114,23405,12743,19115,12841,23341,14889,23308,19147,17002,21228,14825,21195,10632,19050,16970,14857,23341,21292,23309,14825,25453,27631,12744,19050,12776,19147,14922,14954,23308,25517,42128,27469,42129,23244,23244,23276,19083,2213,165,101,4552,25582,40016,25162,16971,35889,23245,29550,37969,35888,37936,35888,25357,31662,29582,29582,31663,31696,40082,42129,37936,40049,38001,40049,44242,44275,42162,40113,42161,31696,25489,27601,44340,44274,33840,21229,23342,29613,37869,44242,40147,40115,40147,42227,48565,50548,42096,33741,25385,23369,27596,29583,25421,17031,6531,4420,10728,14922,21197,14858,8614,14951,8676,2371,321,2530,10950,36082,50745,40178,12871,4453,292,255},
{29912,31992,32024,29911,27766,27766,27799,29912,44602,50972,46586,40377,34105,34072,29911,29911,31992,36185,36185,34072,23573,19413,15154,10632,41965,50514,44240,35822,44305,44273,31694,44241,33709,35887,40015,31629,44208,31596,37968,37902,33710,42160,29516,42128,35790,33742,42128,27501,40081,14987,4485,17098,21454,15051,8518,10664,10631,10695,14921,8582,14889,19276,17034,10630,12776,10631,17001,21292,10695,19049,10760,19179,10663,17034,17002,17001,21260,12841,21195,17034,21195,17002,16969,25421,25452,25421,21163,25453,29679,21163,23275,23373,27533,27501,27533,31727,31694,48434,44242,46322,40081,42194,44274,42194,31662,31661,27468,31694,44273,39822,22986,17037,37969,33743,33742,37969,35889,37937,37969,37967,37936,29614,31695,29582,31728,38001,40048,37968,38001,40049,42129,42162,42194,40081,40048,44242,35889,31893,27470,50711,46452,31695,21197,21229,29614,39983,44242,40147,40147,40147,42227,42259,42194,48403,44209,25353,21256,19175,27531,31695,29648,25421,23309,23277,23277,21197,21196,19246,15051,8645,12872,8774,2530,6755,10948,27726,36017,14952,2340,259,255},
{31992,36185,34072,31992,27799,25686,27799,27799,44602,50940,48665,42457,34105,34072,29911,29911,32024,36217,36185,29847,21493,19445,15187,10633,44143,52660,42160,35790,44305,44273,33742,44241,31661,35887,40015,31662,44241,31597,40048,35822,33742,42128,29516,42128,33709,35823,40016,27468,42194,15052,6533,21226,25485,23308,19082,19017,19050,21130,21195,21194,25356,27566,25356,25388,25388,25388,29581,29614,31726,33808,35888,33840,33775,33839,33775,35888,35921,33807,33775,31695,35855,31760,31694,31727,29647,31695,31760,31728,31727,27469,23276,31727,25421,35954,31564,31760,31597,56820,56821,50514,52660,52693,52693,52692,46321,50514,46353,42128,44241,37807,23051,21131,37936,35823,37903,37936,37969,40082,40147,37904,39983,33742,27404,23243,33808,33808,35855,40081,40049,40049,37903,37968,42195,37968,40080,44242,40114,38002,33776,48500,48468,31728,19149,21261,31694,44209,42194,38066,40115,40147,42227,44340,42259,40114,46323,42128,27466,23337,31691,33803,29615,29616,29648,25422,23277,23277,23309,23309,23309,25421,31728,31792,19209,6722,8868,10916,19273,21323,12773,10756,255},
{34072,36185,34105,34104,29879,25653,27799,25686,44602,50972,46585,42457,34105,34072,29911,29912,31992,38265,34105,25654,21493,21493,19380,10633,42063,56852,46353,37934,44305,44240,35919,44273,31629,40048,37935,31629,44208,29549,42128,35789,33742,42128,27469,42161,31629,35855,39983,27468,44274,15051,14920,37936,33808,42194,29614,33775,23276,25388,33808,27566,25324,27502,25422,29615,23244,31662,29549,31695,37968,35889,42194,40114,35921,42194,31662,40048,31727,33743,31694,25356,33775,29647,29614,31662,23309,31695,27567,25389,31727,21196,25389,29614,23309,33808,25323,27469,27371,27403,23210,23211,25292,25324,31695,35855,33709,31564,23211,14890,29615,38034,27307,25194,33743,33775,39984,42096,35888,35857,35889,37936,35823,25355,31662,16970,29550,35889,33776,37968,40082,37969,21163,25324,42194,37968,37968,42194,42162,40081,40081,50581,48500,29648,21197,23374,35887,46290,44307,40146,38066,40147,42260,44340,42259,40147,27466,40048,44177,25353,29514,25352,21192,29614,29615,29648,25422,23309,25390,27470,27535,31696,33808,31728,33939,21322,8836,10884,6755,10949,27596,23207,255},
{34105,36185,36153,36185,31992,25686,27767,25718,44570,48892,46585,42457,34105,34072,29911,29911,31992,38265,34072,23573,21525,21493,19445,10697,41997,52594,48465,40047,46385,44240,35919,46321,33741,40048,37935,31662,42128,29516,42128,35789,35855,42095,29517,42160,31597,35887,37902,29549,42193,19179,25420,35823,29646,42161,25453,35888,25388,27501,33840,25453,31695,27469,29614,33807,23309,35920,27469,33808,35823,27469,40081,29581,35823,35823,27501,37968,27436,33742,33774,25356,35887,27501,31662,33775,25356,35855,27469,29581,33807,23308,33807,27469,25356,33742,16872,19115,23341,14890,12809,8551,12777,19083,21163,31728,27437,25225,27371,14858,19116,35889,23179,21067,29583,31663,35823,40048,37936,35856,35889,35857,33776,35856,37968,29550,23244,31630,33743,33775,38001,37936,25291,31662,42162,37968,42128,40081,40114,38001,44274,50613,48468,27535,21197,25422,44307,46355,42195,40147,38001,40114,42260,42259,42227,40146,25385,21223,40048,48338,35788,29546,25385,31691,31726,31696,31663,27470,25422,27470,27535,29616,31696,33907,40408,40277,25516,15046,10883,8771,8772,19142,255},
{36153,34104,36152,40345,34104,27734,27799,27767,44570,48892,46586,46585,34105,34072,29911,29911,31992,36185,34072,23573,23573,21493,19446,10698,41965,52594,48433,37966,46353,44272,35886,44240,33741,40080,37902,33710,42128,29516,42128,33709,35855,40015,29549,42128,29516,37967,37903,29614,40113,29516,40049,33710,31694,40081,27533,40113,31629,33807,37968,27469,40113,27469,33808,33808,27534,38033,25421,35888,33743,27469,38000,25388,33775,31662,27469,37968,25388,35855,31662,27469,35855,25356,33775,31662,27469,35887,25356,31662,31694,23308,33807,25356,27469,31662,14792,17035,25454,21229,19117,19149,14825,16872,16905,31695,27470,25258,29418,25324,19084,33809,23277,27114,33710,31663,31663,37936,42063,37904,37937,35857,33744,37969,37968,33841,33808,27470,33808,33743,33808,40016,35855,35920,40114,37936,40048,40049,44275,40081,42226,48467,44275,25422,19149,25454,46387,48468,40146,40115,38001,40146,42259,42259,40146,38000,23368,25449,25417,40047,50483,37934,33708,27465,40144,44308,38035,29583,27503,27535,27503,29615,31696,29616,36117,46747,35953,27563,14980,8674,10788,6594,255},
{36185,34072,31959,42393,36185,27766,27799,27799,44602,46812,46586,46585,34105,32024,29911,29944,31992,34105,34105,23606,23573,21493,19446,10698,39917,54642,48401,35854,42160,42128,33774,44208,31629,40047,35789,33742,42128,29516,42128,31629,35854,37935,29581,42128,29484,40016,35790,29582,40081,29516,40048,31597,31727,38000,27501,40081,27469,35888,35855,27469,38000,25388,35888,31695,27534,38000,25389,37968,29582,27501,35888,25356,35887,29582,29582,35855,23308,35888,27501,27501,35855,25356,35855,27501,27469,35855,23276,33775,29549,25292,33775,23244,31662,29581,19017,14857,23342,29681,31795,38133,31728,21000,16807,25389,40213,27502,25290,33677,23309,27471,23115,20904,31500,37937,29550,35791,37870,40016,37936,35889,33776,35856,37968,48566,52792,48632,44373,25356,31663,29582,33774,40081,42162,40049,42128,40081,40114,38001,46419,46387,42194,25390,19149,25454,35854,46355,40114,38001,35921,38034,42227,42194,40082,33773,19174,25417,29579,25449,37966,48435,40047,27433,33805,50646,50810,44504,29583,27535,29583,29583,29583,29616,29583,35955,29680,19207,10787,6562,8675,6594,255},
{38265,36152,31927,42393,38265,27766,27799,27799,44570,46812,42425,42457,36153,34072,29911,29944,31992,34104,34105,25686,21525,21493,19446,8683,39917,54674,46353,33773,40112,40047,33741,42128,31629,37967,35757,33742,42096,29517,42128,31629,37935,37902,29581,42128,29483,40048,33677,31662,40048,29516,40080,29516,33807,35920,27501,40081,27469,38000,33774,29582,37968,25388,35920,29582,29614,35887,25388,38001,27501,29614,35887,25356,35887,25389,29615,33775,23308,35888,25389,29614,33775,25356,35887,27469,29582,33775,23276,35855,25389,27437,33710,21163,31662,25356,29517,23211,23244,29681,29714,31827,42326,33711,31630,23244,35954,33775,25323,35790,31695,27438,20970,16678,20936,37935,31663,31663,33743,40016,40048,37969,35857,29581,27468,54709,44340,48631,38002,25357,29550,29550,33645,40048,40081,37969,35822,35823,37969,35855,44307,46355,42194,23310,19149,25486,37966,46323,42260,40114,40114,40146,25324,12679,25388,29579,17061,19143,29579,27530,23336,29644,46485,40047,35919,50679,50744,40148,31859,27470,31696,29583,27503,29583,29616,29648,27565,15013,10755,15012,12899,8706,255},
{40377,36120,31959,40313,40313,27766,27799,29879,46682,44699,44505,44505,34105,34072,29911,29944,29944,32024,34105,27831,21525,21493,19478,8651,39852,54674,48433,33774,42224,40047,31693,44208,31661,40047,33709,35822,42095,29517,42128,31596,37967,35822,31661,42128,29483,40048,31596,31694,37967,29516,40081,27436,35952,35920,29614,40048,27437,38000,31662,27534,37936,25356,38000,25421,31695,33807,23340,38001,25388,31695,31727,25388,35888,25324,33775,31694,25388,35887,23308,31694,29614,25388,35887,25356,31694,31630,25356,35855,25356,31662,29549,23243,33743,23243,27404,10599,16970,29681,29746,27633,38100,35856,38033,29614,23276,42226,31661,29549,33776,27438,27375,14631,20969,25259,21099,31663,31630,38067,40048,37936,40181,25487,21162,52596,46420,50647,48599,48567,35856,31695,33775,38001,38001,31795,29584,35823,40082,37936,48533,46387,40082,21229,21197,29615,42192,46290,38033,38034,38001,33840,19052,2181,4228,21095,19110,21223,27434,25385,25449,21288,29646,50646,46452,52791,42161,31628,31825,27501,31696,31696,29615,27535,29583,31696,27531,17062,12869,17092,12898,4481,255},
{42393,36120,31959,40313,40313,27766,27799,29944,46682,42587,46617,42457,34105,34072,29911,29944,31992,32024,34104,31992,23573,21493,19478,8683,37772,52594,48465,35854,44305,42159,35887,44208,31661,40048,33709,33774,37934,29516,44208,29516,40047,35822,31662,42095,29483,42095,31564,33742,35822,27436,40081,27404,37968,33807,29647,40081,27469,38000,29549,31662,35855,25356,38033,27469,33807,33775,27501,38000,25420,33839,31662,27501,38001,25389,35887,29614,29582,35920,25389,35888,29582,27501,35887,25356,33775,29549,27469,33807,23276,33743,27469,25324,31694,21163,31661,10598,14858,27633,29747,29746,29714,29615,14857,21131,16938,35921,42193,33709,35953,29518,25359,14598,23081,19050,17004,31663,31630,31761,33678,40015,35857,27502,29582,48402,46453,52792,52792,48631,37969,37969,33776,35889,35888,35921,29812,29583,40082,40049,46420,44372,38034,21229,21229,29646,37966,31660,21258,35920,27467,19178,25357,33352,37447,27271,23207,25353,29547,21159,21223,19207,25420,31728,50678,52758,37999,31627,33739,33804,33807,33809,31696,29616,29583,29615,29647,27565,17061,19269,15043,4481,255},
{40345,34072,34039,44473,40313,29846,27799,32057,46715,42555,50745,44505,34104,31992,29911,29911,31992,32024,34104,31992,23573,21493,19478,8683,35790,54740,48465,35854,44272,42127,37999,42128,31629,42128,31628,33774,37902,29517,42128,29516,40048,35789,33742,42095,27436,42128,29516,35854,33774,29517,40048,27404,38000,31695,31727,37968,27437,38001,27469,31727,33775,25389,38000,25356,35855,31630,27501,38000,23308,35888,27501,27469,35888,23308,35855,27501,29582,33807,25356,35888,25388,29581,33775,25356,35855,25356,29549,31662,23243,33743,25324,27436,31629,21162,33774,12646,19083,31827,25521,25520,29747,27601,21229,21164,25390,19083,42194,39983,42162,29485,25327,14598,12613,10661,12809,21098,29550,29583,33711,39983,31662,27468,40048,48403,44308,46420,46421,42228,31597,33743,31662,33776,33744,31565,35823,35889,40081,35856,46420,35889,33841,21229,21262,27532,21223,19112,21226,23306,19113,23340,23405,27436,39560,35496,21061,16901,18950,16901,19143,15014,27501,29583,40146,54872,44338,33739,33707,42189,42223,48599,33809,31696,31728,29616,29648,25451,17156,23493,12929,12963,255},
{36153,31959,34039,44473,40313,29846,27799,32025,46747,40475,52825,44537,34104,31992,29911,29912,31992,32024,34104,29912,23573,21525,19478,8651,37838,54708,50546,37966,44305,40047,37967,42128,31629,42128,31597,35855,37902,29549,42128,29484,40048,33677,31662,40015,29484,42128,29484,35855,33774,29581,40048,27404,38033,29614,31727,35887,25389,40081,27469,33807,31662,25421,38000,23276,35920,27501,29614,35920,23308,37968,25421,29614,33807,23308,35888,25421,31694,31695,25356,35888,23340,31694,31694,25388,35887,25388,33742,31662,25356,35888,25324,29581,29549,23178,27436,23178,23244,31794,29680,27568,31795,31827,25422,29648,38034,14891,25357,42193,33743,29421,23246,14533,12613,8612,8614,14824,29549,29550,33743,35922,40246,27502,37935,52628,50646,48566,48534,44307,37935,35855,35823,31630,29550,27469,40048,40082,44242,46288,46420,35889,31761,21229,21262,29613,19110,14918,17031,19112,14951,19179,23406,25518,29516,37545,39592,29222,16772,12773,6596,8645,23308,29615,27534,40114,46420,48532,40045,40012,48464,52824,48599,35922,29615,29616,31728,27593,21381,19268,10817,15011,255},
{34040,31959,31959,42393,40281,29846,27799,32057,46747,42555,52857,44505,34104,31992,29911,31992,31992,32024,34072,27799,23573,21525,19445,15023,31664,44243,50546,42159,46385,40080,37999,42160,29581,42160,31629,37967,37870,29581,42096,27436,40048,31597,33742,40015,27468,42128,27404,37935,31629,31662,37968,27436,38000,29581,33807,35855,25388,38000,27469,35888,29581,27502,37968,25356,37968,27501,31727,35887,25389,35888,25389,33775,33743,27469,37968,25389,33807,29614,27469,37968,23308,33775,29581,29549,35855,25355,33775,29517,27404,33775,23211,31662,27436,21098,2245,8486,16905,31827,27666,29714,31794,27601,25389,29583,31794,27602,19084,46420,42161,27340,23181,12420,10533,6532,10694,16904,27436,29517,31630,40246,48829,31890,35888,50548,52760,52760,50712,44406,35790,42129,44275,44275,33808,29582,31695,38001,44340,48401,50548,35889,29648,21229,21260,29644,23305,21257,12837,12838,17032,23373,25518,25518,23470,27371,43721,47881,39594,25160,21160,16967,25389,29582,27502,25389,29582,48566,50644,37997,44304,52824,54905,48565,19018,10696,25546,25541,19236,15010,12929,17155,255},
{31992,29911,31959,40280,38232,29846,27831,34169,48827,44635,54970,44505,34072,31992,29911,31992,31992,32024,34104,25686,23573,21526,19413,15154,19282,27537,50514,44304,46386,40079,40079,42160,31694,44273,33741,40048,37903,31662,40048,27468,42128,31596,35854,40015,29517,42128,27403,40048,31661,33742,40016,29517,40081,27468,35887,33742,27469,40048,25356,35920,29549,29582,35855,23276,37936,25356,31695,31662,25357,37936,23276,35855,29549,27469,35888,23276,37968,27437,29550,35855,23276,35888,27469,31630,33742,25323,35855,25356,29517,33710,23211,35855,23276,27436,10566,12646,21131,29713,27634,29682,29714,29648,25389,21131,17069,27601,14825,38034,44307,23147,18857,18856,10564,10564,12676,14822,23145,29484,29549,40311,46683,40376,35987,42260,52792,52759,50712,44373,19083,37935,42193,44274,38001,31695,31696,31728,36053,44274,40081,35889,29615,21228,19178,17095,19176,21258,8612,8613,16968,29679,29711,23405,21258,19048,33287,37479,31271,25063,31628,21193,25389,29582,29583,29615,29615,31727,46453,52790,42258,50744,54937,46385,23308,15019,21350,21381,19204,12962,19203,17123,255},
{34072,31959,29879,36120,38232,31926,29911,32057,48827,44602,52857,42425,36152,31991,29911,31992,31992,34072,34105,27799,23574,23606,19478,13106,19250,29583,50481,42191,48465,40079,40079,42160,31726,44241,31693,40080,35854,31662,40048,27436,42161,29548,35887,37902,29549,44208,27436,40048,31597,35822,37935,29517,40081,25388,35920,31662,29550,37968,25356,38001,27436,31695,33775,25356,37968,25356,35888,31662,29550,37968,25356,37968,29517,31662,35888,25389,38001,27437,33743,33775,27469,37968,27436,33775,31662,27404,37936,25292,33710,31630,25324,35855,23276,35822,14662,16807,18952,21163,25357,25389,25422,25389,23276,21196,21196,21262,19149,29583,40147,23276,27438,35856,19112,12773,8644,8644,19081,25291,29549,42424,44570,36053,31762,38067,52759,50679,50712,44405,14858,31662,44208,40016,35790,31597,27437,25325,23244,27502,17099,33808,27535,19178,19144,19144,17063,12805,12805,14887,17001,27599,27565,21225,12805,8580,10596,12676,6467,8580,16902,21161,25389,31695,31694,27502,29647,31695,31695,44339,52792,50712,54904,33836,35917,23308,19112,27656,19269,19236,15043,12930,255},
{34040,31959,29847,34007,38232,31927,29911,34137,46747,42522,46585,42425,36152,31992,29911,31992,31992,34072,34105,29879,23606,23606,21558,15220,17202,25391,48400,40079,46385,40015,40079,42160,31694,44241,31661,40081,35822,33742,40015,27468,42129,29516,37968,37870,29581,42128,27436,40048,29484,35855,35854,29517,40048,25388,38000,31662,31695,37968,25389,40081,25356,35855,33742,27501,37968,25356,38000,29614,31695,35887,25389,40049,27469,33775,33807,27469,40049,25389,35888,31662,27469,37936,25356,35856,29581,29549,37936,25324,35855,29517,27436,33807,19018,29484,25258,25258,27371,25291,25421,27470,27503,29615,25389,21164,23374,21295,8584,21164,35954,23277,23277,33775,23242,14887,6499,4386,12807,21098,27468,44537,40344,29713,35790,44307,50711,50646,50680,44373,29517,35823,40048,42128,40081,37903,33776,23376,21263,27568,31760,31728,25455,21261,21257,17094,17062,14950,10692,12805,17033,25421,19175,16997,12836,6499,8611,6498,8676,6563,6435,19048,25356,31663,33775,27469,27502,27502,31728,29582,44373,52792,46418,31658,37997,35852,27499,33871,27625,19269,17156,15044,255},
{34040,29879,29846,34007,40280,29846,29911,34169,44602,40410,48665,42425,36152,31991,29911,31991,31959,31992,34072,27799,23606,23574,21558,17299,19314,25424,50481,42191,46353,40015,40112,42160,33742,44241,29581,40048,33741,33775,40015,27468,42161,29516,37968,35789,31662,42128,27404,42128,29516,37968,35822,29581,40048,25356,40081,29581,33775,35855,27469,40081,25324,35888,31662,29582,37936,23341,38001,27437,33775,35823,25389,40048,27404,35888,31662,27469,35888,23308,37968,29550,29582,35887,25388,37968,29549,31694,35888,25356,37936,27437,31662,33808,16937,8485,18919,18952,21032,18985,21196,29615,27535,31728,31498,21131,25456,19118,10697,25357,38002,23277,21196,27501,16967,10725,8579,10692,10693,21129,25323,44570,25519,23439,35791,48500,52759,50679,50744,44405,33775,37968,40081,35823,42129,38001,40146,35921,31728,38067,44406,35953,23342,21261,21290,23369,23337,10724,8581,12838,17031,21224,17029,12836,14949,8611,4450,8643,10724,4450,6435,14823,27469,27470,29615,35888,27469,21195,29615,31695,35953,50679,52791,37998,31627,33804,35885,38030,33869,25514,12964,12932,255},
{34040,29879,29847,34039,40280,29814,31992,38362,44635,38361,46617,40279,25357,23277,23244,23244,23212,23212,23212,23211,21099,23179,23179,23114,23113,23145,50481,46384,48466,42160,42192,42128,33774,44241,29549,40080,33709,33774,40015,29549,42161,29516,40080,33709,33742,40048,27436,42161,27436,40048,35790,31630,40016,25356,40080,27501,35856,33775,27469,40048,25356,38000,29549,31663,35855,25389,40049,25388,35855,33742,27502,37968,25388,38001,29582,31663,37936,25389,40081,27502,33743,33775,25356,38001,25389,33743,33743,27437,37936,25324,33807,31695,27404,12646,14791,21064,23112,21097,19115,29648,29648,31761,31500,21131,25455,19118,17036,25422,40114,23277,21229,29647,14887,8644,12773,12805,12805,10692,16968,40344,21358,21293,31663,46453,48534,46453,44405,40114,31662,33775,40081,37968,37935,44306,40082,38000,31663,35987,44471,38100,21229,21229,29647,38031,17031,6564,8645,23177,25353,17062,14981,17029,12804,12836,8611,12869,12869,6466,2210,14791,25356,29582,25453,25420,17032,8677,17001,31761,31631,31728,42194,52758,37998,31659,33804,31723,38031,25482,10819,12932,255},
{34040,29879,29847,34039,40280,29814,32024,42587,44635,36249,46682,36021,20967,23079,23079,23079,23047,23047,23079,25159,23047,25159,25159,25159,25159,25159,48368,44304,48465,42159,40112,40015,35886,42128,29549,42161,31661,35855,37935,29549,42128,27404,40080,33709,33775,39983,27436,42128,25324,40081,33677,33710,40015,25356,40048,27469,35920,31694,29582,40048,25356,40081,27501,33775,35855,27501,40081,25421,37968,31662,31662,37936,25389,40081,29549,33775,35856,27469,40081,27437,35888,33742,29582,40049,27437,37968,31662,31630,37968,25356,37968,29549,35855,21163,23243,31661,33709,33774,31695,27567,29648,33874,27569,21196,23244,19052,25423,27535,35954,19083,23277,44308,25421,16999,16999,12805,12741,8516,14888,23342,25519,33807,46355,42227,38035,40114,40147,35855,31662,29550,31662,37968,33775,44274,40048,35888,35888,40180,42326,35955,21229,21229,27533,42226,25386,12870,12838,21161,23273,19110,14949,19142,12804,10724,10724,12837,17029,6499,2177,14759,21163,23308,17064,15016,12871,8742,10824,36053,37937,29615,27501,35952,52791,40111,31659,31692,33836,21318,8739,12964,255},
{34040,29847,29846,34007,36120,27766,32024,46715,40442,34072,46650,31860,29287,33544,33543,35623,33479,31431,35592,31432,29351,31431,31431,33447,31399,29319,48335,42159,46353,40047,42160,37935,42224,44241,29549,42161,33709,37935,37935,29581,42128,27436,42160,31596,35822,37902,29516,44209,27404,42161,31629,33775,37935,27469,42128,27469,40049,31629,31662,37935,25324,40048,27436,37936,33742,29550,40049,25356,40081,29550,33743,37936,25357,40049,25388,35888,31630,25356,33742,21130,29549,23211,23243,31630,23243,29549,23275,25356,23275,16969,25356,14856,21065,18952,18920,25258,23144,12710,14889,23244,29648,31729,21164,16971,23309,23277,25389,27535,33841,19083,23276,38066,35921,23308,16966,12773,12774,10597,14823,19050,21325,40049,50549,50712,50679,50712,50679,35856,35855,31630,29517,33743,35823,40049,33710,35823,40048,46453,44439,33874,23309,21229,31825,48501,42161,27531,12838,21160,25286,21190,19143,21158,16965,10724,10724,8611,6499,4386,4354,14791,25356,25389,25421,44536,50842,42423,31825,27469,29648,29615,27502,29647,38033,52758,42192,29579,25450,23432,17157,19238,255},
{31959,29846,29846,31927,36120,27766,31992,42522,42619,29944,44602,29813,29319,33543,37671,35591,31431,29351,31464,29352,29287,31399,31432,29287,29287,31367,50416,44304,48433,40047,44273,40015,42160,44241,29549,42161,31597,37967,37903,29581,42096,27404,42128,29516,35855,35790,29516,37935,25291,35855,25323,29549,29484,21195,31630,19050,27469,21098,21163,23211,16905,23243,14857,21098,16905,14857,19050,14922,25486,17068,17003,21293,12939,14954,17067,23341,12841,6502,6470,2277,2277,4325,2245,10663,16969,12776,12809,8583,4422,4487,14953,14889,31662,33742,33774,37936,23241,6532,10696,19083,29681,21165,6407,14890,25390,25357,25422,29583,38034,21229,25389,31727,46453,31663,16968,12774,14854,10692,10661,23242,27502,44242,50581,40115,44373,48598,48598,37936,37968,33743,29550,27437,31662,36021,23277,33741,40048,46388,46486,33841,21229,23342,38165,46420,33773,23274,10725,21127,27398,19045,12804,12805,12772,6499,14949,6499,129,4387,8483,18984,25324,29550,25389,40278,59262,48730,38133,27470,29648,27535,29583,29583,27534,33840,50645,42225,23304,23433,23431,21286,255},
{31959,29847,29846,31927,36120,27766,31992,38264,38132,27503,33776,27438,29319,35591,35623,35623,31463,31431,35656,31400,29319,31399,31432,31367,29319,27239,27404,23308,23309,19116,21196,19116,14890,16970,12777,16905,12679,31564,37901,23210,21065,18952,18984,18984,18952,18984,18984,16872,10664,10664,8583,8551,6471,6471,6471,4390,4358,4390,4358,4326,4358,4358,4358,4325,4358,4358,4358,12777,19148,12809,10664,16969,12776,10631,23374,29614,18985,18985,18953,18952,18920,18953,16840,18920,21033,16840,8486,12680,12842,10825,12906,27534,44306,39983,31565,37935,12838,4451,10631,14922,29616,23342,14891,29681,23309,12745,23309,29616,50675,42225,29648,23341,40114,44340,25355,16999,17000,21161,14854,19049,29615,46322,50581,33776,44340,40179,46452,40049,37903,35855,35856,33776,31695,31860,25389,37935,40048,48500,44340,31696,19116,23310,40278,35952,19079,12838,4451,10692,27398,25350,16965,12707,12772,6564,10724,6499,2338,4322,8483,21097,25324,29550,31695,29582,42359,46586,17233,29615,27502,29583,27503,29583,27502,27502,27501,44338,38032,27561,27626,27626,255},
{31959,29879,29846,29879,36120,29846,32057,29846,23048,23014,23047,25095,29287,35591,37703,35624,31431,31431,37672,31432,29319,31399,31432,31399,31367,27239,10697,8682,10730,8650,6569,8649,6536,4423,6471,6438,6406,25225,33643,21064,14758,14759,16871,21032,21064,16904,16839,14759,14759,12679,14759,14759,12679,14759,16839,16839,16839,16839,16872,16840,16840,16839,16839,16807,16839,21000,12615,21033,18887,18920,18887,18887,18887,14662,33841,42227,23114,23081,23081,23081,23081,21033,18921,18920,16840,14728,10501,10567,17035,14986,17067,35920,44241,40047,40048,37967,12805,258,4357,12810,27568,31794,33874,35988,23277,10632,21164,31728,35953,21196,19116,17036,23308,44340,31695,21163,21196,25357,31661,31629,33775,50515,50613,48598,50647,48534,48534,40081,40015,37903,40049,38002,31630,33842,29583,37968,35855,48533,46387,27534,19148,23342,40279,40212,19112,10758,4419,14885,29511,25318,19109,10692,6434,4418,6532,8645,8613,8516,12677,19016,25323,29549,33743,33775,31760,35890,23276,27469,29583,29648,29583,27502,27502,27535,44536,40080,44338,44370,33870,36015,255},
{31959,29879,29846,29846,34039,29879,32089,31665,20934,22982,23047,23015,29287,35591,35623,37672,33512,31431,33544,31432,31399,31399,33512,29319,31400,29319,27272,27240,27272,12614,10534,20968,21032,16839,18887,18920,18887,16807,16807,18855,16774,18887,23112,25160,23080,18887,18887,18855,16807,18887,20968,20968,18887,20968,21000,20968,18919,20968,21000,20967,18920,18920,18887,16807,16807,21000,12647,21000,18855,18919,18887,18887,18887,14727,33841,42293,29485,21001,21034,21033,21001,21001,18921,16872,16873,16808,12615,10501,16904,15019,17099,40080,31564,17033,21259,33709,10757,290,2309,14890,23407,27569,35955,23245,23309,14891,12745,31728,31729,19083,25422,17036,14857,29582,27503,8552,23277,21164,33776,40016,40016,52563,50581,42259,48566,42227,50646,37970,31566,37902,40049,40081,33776,33808,31663,35855,35888,46388,44275,25454,19116,25455,42359,44439,25419,12871,6532,14885,29511,25318,19109,10724,4387,4418,4419,10630,16904,14725,16871,21228,23243,29582,31662,35888,31662,29550,33808,33808,31728,29647,29615,29583,29582,27633,46747,35954,27533,44371,48564,29611,255},
{29879,29879,29847,29879,31927,29879,32056,31533,22982,23015,23047,23015,29287,35624,37704,35591,33544,35624,31432,31400,31399,33480,33512,31400,33480,31432,29320,27240,27240,12614,10501,20967,21000,18887,16774,18887,18887,16807,18855,16807,16742,20999,20967,18887,14694,16775,16807,16775,16774,18887,18887,18887,18887,20968,18919,18887,18920,21000,20968,18919,18887,21000,21000,18887,18920,23081,12679,23081,21000,21000,21000,18920,18887,18920,38002,40180,35889,23081,25194,23114,23114,23146,21033,18921,21033,21001,18953,16840,16937,17066,19211,42193,31597,14985,23340,35822,21193,291,6502,16969,19280,19247,31761,12681,25488,21230,21196,31760,31696,19083,27535,21197,14923,16970,33874,27667,21197,21164,21164,35791,40049,46323,50613,50646,50679,48599,44340,33743,25195,33676,40080,37968,37969,31695,27469,33775,38000,50712,46519,23342,19116,25455,42391,40277,29679,17065,8645,17030,23237,25318,21222,10724,6467,8579,8546,2242,12677,21031,18984,31858,27437,29515,33742,35856,35856,33776,40049,35889,33776,31696,31695,29615,27503,42456,44601,29648,25422,29614,40210,50677,255},
{31959,31959,29879,29846,29814,25718,29878,27471,20967,23015,25127,23047,29286,35624,37704,33543,33512,35656,31432,31432,31400,31431,33512,31400,33480,33480,33512,31433,29352,12614,10501,23048,20968,23080,18887,18887,18920,18887,18887,18855,16774,27273,23080,18887,16774,16807,18887,16807,16774,18887,20967,18887,18887,21000,18919,18887,20967,21000,23080,20968,21000,21000,18920,18887,18920,23081,14727,21000,23145,21000,21000,18920,18888,21033,38067,40179,38002,16808,16808,16808,14728,25195,23179,29550,35888,33742,35855,33742,25420,15018,21259,44241,29484,14985,25453,37903,23241,17000,23275,17000,19279,21328,35922,19084,25489,21165,25422,33841,31696,19083,25422,17003,33972,25455,27502,44472,31762,21164,19083,29550,44210,46355,50614,50679,50679,50712,48598,35823,23050,31630,42161,37968,40082,31663,29550,29582,35889,52890,44439,21229,19148,27600,46650,46552,42325,21257,10725,8612,12772,27398,19142,10724,4450,8579,8611,10661,17002,23177,21163,40343,27501,35953,35855,35888,35856,35856,44243,35888,29582,29615,31696,27535,29616,44601,46649,27470,25454,25454,27534,44373,255},
{31992,31959,29879,27766,27766,25718,29912,29748,23047,25127,25128,25127,31367,37704,37704,37672,35624,33512,31432,33513,33513,33544,35592,33512,35560,31432,37673,33513,31433,12614,10469,20968,20967,23047,18887,18887,18887,18887,18887,18855,18855,18855,20935,18919,16775,16807,16807,16807,16807,18887,18887,18887,18887,18888,16807,14727,16807,18887,18887,16807,14727,16807,14727,14695,14727,16840,8454,14760,12614,16807,16807,12647,12647,21065,40180,38067,38002,18953,18889,18921,16808,23147,25259,48533,50613,44242,35790,46355,31694,15018,21260,46322,29516,14985,27533,29580,10692,16935,21227,19114,23342,27503,31761,27503,17069,21197,25390,35889,31663,17003,27502,23342,40312,29681,29681,44340,29583,14858,19083,19083,31630,40082,48468,37968,31694,27469,33808,35888,31598,33775,37936,40048,38001,37936,29582,31663,35921,46552,38100,21196,23276,29679,35984,33871,27531,14949,8611,2274,2275,8579,10756,8644,14918,21191,18982,14854,27467,23145,21098,33842,25356,38164,33841,27501,33742,33775,46355,38001,31663,27470,27502,31728,29647,33842,38035,25389,29615,27535,29615,33776,255},
{34072,31959,29879,27766,25685,25718,29912,25620,20967,23014,25095,23047,20934,23046,23014,22982,20934,20934,18854,20902,20934,23015,20934,20967,20935,18822,20935,18855,14662,10502,4228,12646,12614,12614,12614,14694,10533,10534,12614,12582,12581,12582,12582,12582,10502,12614,12614,10534,10534,12614,12646,12646,12582,12647,12615,8454,12614,14727,14695,10534,10534,12614,10566,10501,10534,14759,4326,12712,10534,16775,16807,14727,12647,23146,38001,38067,38002,21034,14728,12647,12615,16906,23114,31500,40016,37903,31597,35758,25388,17131,25452,42160,25322,14953,29614,25354,6500,14823,29647,23275,21261,29713,33907,38067,27633,21196,25389,35889,29550,17003,29615,33809,40343,38159,38124,46448,33840,17036,21164,19116,27470,42129,27402,6531,4483,4419,27502,40147,35856,38068,33710,40048,42161,37936,33710,31663,35954,42359,33907,19083,19081,19113,21190,17028,14949,10724,8643,8676,4355,2274,4419,10692,25385,33771,31691,31691,35852,25128,21098,19018,23308,42358,36019,19116,35822,37936,42130,40082,44307,31663,27470,29615,31728,31696,27470,27502,29615,29583,31696,29648,255},
{34072,31992,29911,27766,25653,25751,29944,25588,23015,23015,25160,27240,16774,16742,12613,14693,16742,14694,14662,16742,14694,16774,14726,16775,14694,14662,16807,16775,10534,6341,36,10534,10502,10534,10501,10534,10501,8454,10534,10501,10533,14694,12582,10534,12614,12614,12646,12614,10534,12646,14727,14695,10534,14695,14695,10534,12646,16807,16807,14727,12647,14727,14727,14695,14727,18920,10567,16840,14727,18920,18920,18888,14727,33744,29452,31695,40148,18889,18889,18889,16840,16905,21066,18887,16775,16808,16776,12614,14889,19212,27533,35854,31661,21194,27500,27435,10725,8549,29613,21226,21229,29681,31794,42293,31696,16971,25357,35889,25357,19083,29583,31793,44503,54928,52882,36082,42324,40114,27469,21131,21131,37936,40016,27500,19145,17001,35856,42161,38035,27503,27436,35855,40015,37936,35888,31630,35856,38002,29582,25356,25356,29581,23335,17028,12836,12868,12836,10724,2274,193,2274,6403,25385,33804,37965,35916,35917,29516,29484,35723,27436,44439,38099,23341,35855,46354,35823,40050,52694,35824,29582,27470,31728,33841,29615,27535,27470,27534,29583,29615,255},
{36152,34072,31959,27766,23605,27799,29911,25555,20935,23014,25128,25161,18854,18886,14693,16774,18854,16742,16774,16774,16774,18822,18855,18887,16774,16775,18888,16775,12646,8454,2180,12615,12614,14694,12646,14727,12646,12614,12646,14694,14662,16774,14695,14695,14695,14727,14759,14695,12647,14759,14727,14695,12614,14695,14727,14695,14759,16807,16808,14727,14727,14727,14727,14695,14695,14793,8519,14760,14727,14695,12647,12647,10534,27438,31597,29582,40147,21066,16840,16808,14728,14728,18953,18888,14728,14760,14727,12615,10599,12776,29614,40081,40080,21226,33741,25354,14887,4452,27599,29647,25487,33940,27536,31761,31629,27469,25389,35888,23244,19083,31695,33874,42456,48467,57018,44373,37937,42194,38001,23244,19051,23277,42097,46290,42129,33776,40049,42161,40148,29550,29582,33743,35855,37968,42292,42162,27338,35789,44208,35822,46321,29420,27498,14948,12835,17060,10691,6499,4418,193,193,10628,27465,33803,40077,37997,37997,29548,29515,46156,27404,25356,27535,23341,29549,37903,35823,35855,42129,33743,35888,29583,29615,31728,29615,29648,27535,27535,25421,29583,255},
{38265,38233,31992,25686,23573,27831,32025,25588,23015,25095,27208,27241,14662,10501,10501,10501,10469,8421,10469,10501,10501,10501,10501,10501,10501,8421,10502,10502,8422,6374,2149,10502,8421,8421,10502,10502,8421,8421,10502,10502,8422,8421,10534,10534,8421,10502,10534,10534,10502,10534,12614,10502,8453,10534,12647,12614,12614,12614,12614,10566,10534,10534,12614,12614,10534,10567,6374,10566,12614,14694,10534,14727,12582,23212,37969,40115,38002,18921,16840,16808,16808,19018,21034,16808,10567,12615,12615,10534,8486,8485,21196,27502,31663,29614,42160,23307,29515,19080,23405,31728,31729,48698,29682,10567,16807,27404,25389,33776,23244,19083,33808,29648,42457,48500,42093,37936,27404,33678,44307,31662,21131,19083,31662,44177,44177,33711,29615,33939,40278,29550,31695,33743,33743,42227,42357,52890,35822,25290,48401,33644,42095,35725,27434,19079,14980,12836,10723,8676,4354,225,2306,12741,31626,35851,37997,37997,40110,33676,23178,25324,23243,23211,21163,16938,29517,37903,31662,35855,37968,33776,31663,31728,31695,27502,25389,27502,29648,27535,25389,29648,255},
{42425,40313,34040,25686,23573,25751,32057,23540,18854,18854,20902,20935,12582,6340,8389,8421,8389,6341,8421,8421,10501,10501,10501,10501,10501,10502,10501,10534,8421,6341,36,8421,8421,8421,10502,8453,8421,8421,10469,10501,8421,10501,14694,14662,10501,8453,12614,12614,12582,10534,14695,12614,8421,12614,12614,10534,12614,12582,10534,10534,10502,10501,10534,10534,10502,8487,4326,12614,12614,12646,12614,16840,16808,25194,40081,48599,33776,18889,18921,18921,18888,29583,23146,18888,14760,16840,16808,14728,8519,8517,8518,23244,25389,23276,31630,27404,21194,10726,19179,31792,21162,38003,29584,10664,10728,25354,25324,33776,21196,21196,27501,27470,29649,54971,42158,37967,40048,42128,42194,42194,25324,21131,21163,37968,44177,42096,42162,46617,29747,27437,33743,31663,33775,38099,38132,46552,50744,33677,29483,42127,31596,40015,31596,29547,16997,8610,10724,8643,4386,2340,10760,23209,31658,35852,37964,42158,46415,33676,23243,21163,21130,23243,25324,23243,29549,33775,31630,31630,33808,37969,31663,31696,31728,29614,25421,27470,29615,29615,25389,29615,255},
{46586,40313,34072,27766,23605,25718,32057,25620,16775,18822,18855,18822,18822,18919,14726,14694,14726,14662,16774,16774,16742,16742,16774,16774,16742,14727,14694,14695,12614,6341,3,8422,8389,8421,12582,10534,8421,8421,8421,10469,8421,12549,16775,14694,10501,8454,12614,12614,10534,12582,14695,12614,10534,12647,14727,14695,16806,14727,14727,14727,12647,12647,14695,14727,14727,14760,12648,16808,16808,16840,16808,16808,23178,21065,33808,46486,31631,16808,18888,16840,16840,16938,23146,18888,12647,12680,14760,16840,12743,4356,2275,8581,17001,21196,12777,14856,12808,10727,12872,35985,17032,31664,25292,21132,8615,23566,27436,33743,21132,17003,21230,25324,29713,57084,52756,46283,25259,44405,46518,44307,35888,21131,19018,25357,42129,46290,44145,48501,31729,29549,35888,42358,31663,40213,44471,35954,46517,46420,31564,46288,54771,46288,52691,39949,23273,12805,6498,8675,15015,27632,27534,29646,33772,35884,40077,44303,46384,29549,29549,23243,21130,21163,23276,23243,25389,29582,31663,31630,31630,35888,33807,29582,31727,37743,27146,25389,27535,29583,25422,29615,255},
{50778,40345,36152,27798,23605,27799,32089,23605,18856,18822,18854,18855,18855,16806,14694,16774,14726,14726,16807,16774,16742,16774,16775,16807,20967,16807,16775,16775,14727,8454,2116,12582,10502,12582,14727,14695,10566,12614,12614,12614,12614,14662,14727,16807,16807,14728,14759,14759,14727,16840,16840,16840,16808,16840,18920,16840,18953,18920,16840,18953,16873,16840,16808,18921,16841,10600,12680,12647,14727,14727,14695,12647,10567,23212,38001,44373,33678,27274,27339,27307,25227,27470,23114,18856,14728,14760,14760,12680,8614,2307,2275,194,8614,21196,19081,10662,6501,8614,12840,35986,17064,25423,23213,19052,16938,11084,25615,29550,19084,21196,21197,12712,29550,44406,57083,48462,35789,48532,54773,42161,44274,27501,21163,19083,33775,42161,40016,40113,42259,33807,35985,50809,40180,38230,46618,29581,25254,42226,42194,29386,44208,39982,35822,35757,25290,25290,14919,17000,27501,38034,35986,31760,40146,37997,40077,44303,42158,31629,33775,35855,23211,21163,23276,23276,25389,25389,31663,29550,29582,33776,33807,31694,37872,47532,28934,25422,27535,29583,27535,29648,255},
{52858,40345,36184,27798,23605,29911,34202,25685,14728,16808,19019,12614,12614,16873,18953,21034,21098,21065,21066,18986,18954,12680,12648,12680,10600,12680,12680,12680,12680,10567,6374,12647,10567,10567,10599,10567,10567,8454,8486,10535,10535,8454,12615,14760,16840,16840,14760,12647,14727,14760,14727,14728,14727,14727,14727,14760,16808,16840,16808,14728,14727,14760,14760,21131,16873,133,12647,14726,16807,12646,12646,12614,6309,25357,38001,42260,27373,18888,18953,18921,16873,25292,25194,18888,16808,18953,16873,14760,8646,2372,2307,2307,2275,21130,21193,12806,12838,6500,6567,36019,19145,23373,31729,29616,27469,19146,31952,31662,19116,23309,21261,23309,35757,44372,46583,38066,38031,29548,29613,23243,27533,31759,27566,23373,21195,29679,21259,25453,27598,25485,27566,27566,48696,42292,42195,38066,23271,29578,48598,37903,27371,40015,33676,33741,31596,25258,27502,25422,8421,25291,38067,38099,40179,46452,42190,44302,42157,31530,29549,35856,31629,23211,23243,21163,25389,27469,31663,29550,29550,29550,29614,37968,37806,36932,24804,27535,27535,27502,29648,31760,255},
{54906,42393,36185,27766,23605,29944,36314,27799,14924,12582,21262,10632,10502,16873,19051,21098,23210,23146,21098,16938,14793,8520,8488,8488,8520,8520,10568,8520,10600,8487,2246,10567,8519,8519,10567,10599,10599,14760,12679,14760,14792,12680,14760,14792,16840,16905,14728,12647,12679,16808,14760,14728,16808,16808,16808,16840,16840,16840,18920,16840,14695,14728,16808,27470,18986,101,12647,12646,18919,14726,16807,14727,8421,25357,38034,42293,25260,16840,16808,14727,14728,25357,25161,14727,14760,14760,12711,8518,10630,6532,259,2275,226,12743,27534,27697,17066,6533,10760,38100,23339,19148,40212,46453,23340,21195,29678,21259,21228,23340,19146,25486,27598,25420,23340,17066,23340,21292,19147,25453,19082,27566,31791,31856,23340,27566,33937,23372,31857,34001,31857,29711,38163,50745,33874,40246,38067,25351,35853,48599,33644,37901,54771,44240,50578,46288,33676,27437,8485,4226,27437,40212,42260,44405,46484,42190,33675,19017,29450,31630,33710,27469,23243,16937,21131,27469,31727,33743,27502,27469,25356,31695,40017,37224,23016,27502,29647,27502,25389,31696,255},
{54938,42425,36185,27766,23638,29911,38427,27863,19346,12778,21263,19182,17004,19117,21295,21295,23375,23408,23408,21328,15055,15056,10895,10863,10863,15023,17104,17136,15056,15056,12942,12877,10796,12909,12876,10795,10795,16971,25293,14793,18986,12680,14793,16938,12680,16873,10599,8486,10567,14728,12680,10567,12647,12647,12615,12647,12647,10567,12680,18986,25292,27535,27471,35987,18986,8552,16873,16840,16840,16840,16808,14728,12647,27470,38067,42292,25227,21001,21001,21001,21034,27470,23113,16840,16872,14791,14856,8615,12809,10759,6533,8647,8711,4452,14888,21162,19080,4515,6598,36019,38065,21228,46584,59064,38097,21227,21260,31824,19115,27534,25486,21227,31824,23339,25517,25452,23339,31792,23372,29711,29678,27598,33969,34001,31792,29678,27599,31759,27533,36017,29678,31760,25485,42325,48631,37935,25325,27499,33772,48599,44307,33579,35789,52594,33644,46288,29451,27371,21129,14791,18984,29549,42324,44405,46519,46451,27370,16904,21097,31563,29549,35855,25356,18985,16937,21098,27502,31695,27502,27502,25357,29582,33808,29517,29582,27470,29615,31695,23276,27534,255},
{59098,42425,36153,27766,25686,25751,36250,27864,27799,27863,29911,36120,44440,38232,36152,29912,29912,32024,32025,29912,25719,23639,17398,15253,13140,21429,25556,25621,19347,25555,27536,25423,25455,27568,25519,23342,23342,25390,29583,14793,12615,12648,12648,14825,12648,10600,10567,10567,10568,10568,10568,10600,10600,10600,10600,12680,12680,12680,12680,14793,27340,38132,31729,31696,12713,12745,16808,14727,14695,12647,12615,12615,10534,23245,38099,42260,21034,18921,18888,16840,14695,21099,25162,14727,10630,10630,31695,33807,38066,33840,27468,29647,25420,4420,4388,10630,19081,8677,4517,33906,44372,31727,50810,57017,54871,29646,23340,31792,25421,23340,29712,25453,25454,36114,36081,31760,23306,25485,31824,23404,25486,19082,27598,36081,31824,25485,19115,25453,21195,25453,23308,23308,23341,23340,48631,29680,25421,38000,33808,38032,46518,42161,29451,35789,40014,29516,39982,29451,31564,27338,21064,21064,33807,46551,46486,46551,35888,16872,16936,27402,35788,31694,31630,18985,19018,16905,19050,29550,31695,27502,25357,31695,35888,27534,31695,33808,27502,29583,29582,27469,255},
{59130,40377,34104,25718,25686,25751,40475,29944,27831,31992,29911,38232,52793,42392,38232,31959,29879,32024,32024,29912,25686,21558,17333,15252,13107,21428,23476,23508,17267,33842,31695,27535,23374,25520,23374,25455,21262,19149,27535,25325,23212,23244,23244,23212,23244,23212,23212,23245,23245,23277,23277,23277,23244,23244,21196,21164,19084,19051,12778,19051,27372,46551,31729,23212,12746,16971,21164,23277,23277,23211,23276,25356,25389,33874,40180,42195,18921,18889,18921,18889,16873,23244,23049,12647,10598,23275,38000,31694,38001,38033,35920,35920,31759,19146,8614,10726,10663,14856,12776,27568,50678,31694,52923,54905,56951,38065,14921,23373,23340,12775,25485,25485,19147,31791,31791,23373,21194,19114,27566,19146,21260,19147,19147,27534,21195,25486,21195,23308,29679,23275,25421,19114,21260,21227,29679,46551,23341,27534,27534,27563,27531,48663,37903,31564,48433,46353,46353,52626,44175,33677,25257,23145,23177,40179,48632,44438,44470,27469,16904,21129,31595,31596,27436,23210,19017,16937,16905,23243,29615,27502,25421,35921,31695,23308,27502,29582,29614,27470,29615,31695,255},
{57018,40345,34104,25718,25718,27831,44700,29944,27831,32024,31992,40312,59033,46553,40312,34039,29911,32024,32025,29977,25719,21493,17300,15252,15187,23476,23476,23508,21296,42162,25390,14891,8650,12908,8682,8617,8650,10665,21131,21131,21164,19051,16906,23244,27502,25357,25325,25357,23309,25389,25389,25390,23244,21164,21164,19083,10762,12811,6505,23277,25325,48632,38100,25422,17003,25454,38133,38067,38066,31694,33807,33808,33840,38034,38034,40082,20969,21001,20969,20968,18954,29550,23049,14759,12711,29615,40047,35888,35888,40114,38033,38001,29614,17032,4452,4419,6468,6374,19052,25455,37774,39984,52792,46518,52758,52790,25485,19147,25485,25485,19082,27598,23339,21195,27630,29775,25518,16968,17033,23308,17001,23340,21226,25486,25421,23373,25454,23340,31791,31759,31791,33872,35985,35985,40177,48564,46419,33839,31792,19210,14950,31822,46485,35789,37869,52594,39949,44208,37837,31629,29516,25290,25290,25323,44373,46551,44438,44406,23276,18984,21098,31564,29451,23178,23210,21065,16905,19018,23243,27502,27502,33841,29582,25357,25389,27502,31663,33807,29615,29615,255},
{50746,40345,34072,25718,25751,29912,44668,29944,27831,32024,31992,40312,59033,48633,44473,34072,31992,32024,29944,29977,25719,19445,15252,17300,19315,25588,29748,31829,21262,29583,21099,12648,8520,14793,12712,6374,8455,8487,6407,4294,6439,6439,4326,12713,14891,10665,10633,10730,14858,16971,16971,14890,12778,14890,14858,14858,10698,8617,2344,19084,25390,40180,42294,29615,23310,31761,46519,40212,33808,31694,33775,27371,27306,16807,29583,35889,18921,16808,18921,18921,16905,29517,18888,12647,16970,33907,35855,38000,33742,38065,38065,38033,23307,6532,4452,6500,4387,132,14825,25455,23244,42260,50646,50679,46517,59096,46516,27565,23340,31856,17033,25453,29678,21227,25486,29710,31759,29646,29678,35952,35952,38032,40113,42258,40113,48531,44370,48563,48531,46451,52724,46386,52756,46451,48531,52757,46451,50612,31727,21292,17130,17162,34003,38099,38001,38066,38099,42357,46550,48631,46550,37967,37967,31661,25388,46551,46551,44406,42293,23211,19017,21131,33644,21065,25290,19018,18985,16905,16905,21163,25421,29583,29615,29583,27534,31695,33807,35854,27501,25421,255},
{44506,38265,32024,25686,25751,29944,44700,29976,27831,29944,32056,40313,59033,48665,46553,36152,31992,31992,29944,29977,27799,21493,15252,15220,13106,19315,23475,25556,19183,23343,12810,12680,12680,10697,19051,16970,16938,16970,16938,16939,16939,17036,14891,12778,14891,12811,12811,12843,12778,12810,12810,12746,10697,12777,12745,10665,16938,19019,12745,16906,23342,35987,35987,23342,23342,29615,33841,44405,38034,31694,35987,25259,25161,21000,29582,33743,23113,23146,25259,25259,25357,29517,16840,12679,19051,33939,33775,40047,33775,35952,40114,38033,17032,6531,8612,8612,6533,6405,14696,21229,23310,40277,48533,52759,42292,54839,54871,33936,27565,27534,38195,25420,29679,40307,31791,42226,50611,42193,44306,44338,50579,50579,44273,52692,44338,52757,52790,48596,56951,48564,52757,48564,48500,56984,48565,52758,50742,46516,44338,42324,50743,48696,40342,44503,40343,34102,27861,34102,48697,48664,50809,42293,33839,37999,27435,29582,48632,42293,44438,42260,21130,19049,23211,29450,21097,23210,18985,19017,14825,16905,19083,27502,25389,23309,29583,31695,29615,27502,25388,25420,255},
{42425,36217,29944,25686,25751,32056,46845,29944,27831,29944,34104,40313,59065,50745,44505,38232,34072,31992,29944,32025,25719,21558,17300,15219,13106,21395,21395,23508,21395,23409,10860,6570,2409,12941,21229,19116,19084,16971,14858,14891,14891,21197,33874,23374,16971,8520,8520,10600,8552,8520,8520,10600,8552,8552,10600,10600,10601,10633,10633,10600,21230,33939,38068,23309,25422,31728,31762,35987,40147,33775,36020,25227,25161,23113,33775,38034,29420,23081,21001,20969,33776,29550,16839,14760,19051,31826,31761,35822,37968,31694,40114,38033,17031,14916,12836,17029,19079,16903,21064,27435,29549,36051,42260,52726,48598,40147,59096,46485,25452,21260,29679,21226,23340,27566,23340,38034,52693,46451,44306,50645,46420,54871,46452,44306,50677,44403,52791,42226,44339,48533,31662,48532,31661,44372,46484,38032,52758,44403,46451,42260,52791,57049,57017,57017,54937,48664,48696,44536,36182,38295,36150,27829,29843,33840,38033,25323,35920,44471,42293,46551,38067,23178,19017,25290,33674,21097,23178,18985,16905,16905,14824,23276,27503,23276,23309,29615,27502,27470,29582,33775,255},
{42425,36185,29912,23638,25751,32024,48893,29976,25751,27864,29944,40345,61145,54906,42425,38233,34104,32024,32025,32057,25719,23606,17300,15219,15154,19315,21363,23475,19315,23442,10796,4425,4360,6537,12810,12713,10665,10632,8552,8520,8520,16938,42228,31728,21164,8487,8487,10600,8519,6407,6407,6407,6375,4327,4327,4326,6407,4327,6407,4327,16971,27536,35987,23309,27568,27502,25488,27666,31663,27436,31761,25194,23080,25225,35888,44341,27405,16776,16808,16776,21197,23341,16808,12647,21164,42358,33907,31662,38000,44208,44142,48335,44141,42060,44173,42062,44174,42126,39981,44174,35887,40277,36051,48565,48565,38067,52791,54838,25388,19082,21195,19081,19114,25519,31856,31694,44307,48564,31693,33840,40178,40146,50645,31694,48499,42290,44339,48564,42257,50644,44338,46386,50644,44338,50644,48466,44338,52660,42160,44372,44372,54904,57049,54969,54904,52856,54936,54937,52824,50744,50776,38131,36084,33938,27403,21032,16904,40212,46551,46519,46551,35922,21097,18985,27370,25257,21097,19018,21065,16904,14824,16937,25357,25422,23309,27470,31695,29582,27502,27501,255},
{44473,34137,27831,23638,25751,29944,46812,29976,25718,27863,29912,36185,54905,54938,38265,38265,36153,34072,32025,32057,25751,23606,17332,15187,15154,19315,17234,21395,19315,27635,29682,12910,10829,10829,10797,10796,8715,10796,8683,17004,19149,19116,40180,31760,21164,8520,8552,10632,10600,10600,10600,10600,10600,10632,10632,10632,12713,10633,12681,10600,16939,21229,31728,23309,31761,27568,27568,23375,25454,33905,29648,23081,23081,23113,38034,40180,29453,21001,21001,20968,21131,23276,18986,14760,23277,48697,38165,29615,35887,52725,48335,39949,37902,37836,42094,40046,44207,42095,44207,44207,42258,36083,31825,46454,52726,48598,44372,61144,40178,23340,23340,23340,23307,27534,31857,25453,33873,50613,46450,42225,44338,44338,50579,50611,44241,54773,44273,48531,48467,42193,52757,42161,50580,50612,46419,56984,44371,56952,52758,50678,46486,46453,52790,52790,50613,50645,46452,48565,40080,44338,48565,50678,35887,48565,31629,23177,25323,40081,48599,46583,46519,44471,31728,19017,19017,25290,23177,23145,18985,21097,14824,14825,16905,25389,29615,25389,29582,31663,29582,29582,255},
{42393,32024,27831,23638,25751,29912,48893,30009,25718,27831,29911,36185,46553,54906,38265,40313,36153,32024,29976,29977,27832,23606,17332,13139,13106,19282,19315,21395,17234,23442,31796,17234,13040,10927,10894,12942,8780,19182,12909,23375,25454,19117,39986,33809,21131,6375,4294,6374,2213,2149,69,69,69,68,36,36,68,101,101,69,4327,29680,31729,23309,29648,33874,25454,21295,31793,42325,27536,16841,18986,25227,38001,40180,25227,16808,16808,16808,14728,23179,29550,16873,25357,50777,44504,29681,35888,54938,54806,44109,52495,52495,50414,52527,50382,50415,48302,46221,44273,40212,33938,46519,50646,52759,44372,52791,57016,38129,21227,27533,33872,25420,31825,31824,27632,42324,50612,42193,40113,46484,44339,56983,46419,50612,50644,48532,59064,48565,54838,54871,46354,50612,46484,46420,50678,33775,52823,40178,38098,46484,52758,54806,50612,50645,50711,50744,46419,35788,33774,46518,40146,29615,46452,18886,10533,16937,44307,50712,46519,44471,46519,29550,18985,19017,25290,25225,21065,19017,18985,16905,14825,16937,25389,27535,27470,27469,29583,29550,255},
{40313,29912,27831,23606,27832,27864,50973,32089,25750,27863,29911,36185,38265,44506,38265,40313,36152,31992,29944,29977,29944,23638,17332,13139,15154,19314,21395,21395,17234,19314,29748,21394,19313,19313,21393,23474,25553,27601,25521,27601,27568,27567,29616,33809,23211,6407,4294,6439,4359,4327,4359,6439,8520,8520,8520,8552,10665,10665,12713,10665,14826,33841,31761,23309,25455,33841,25454,27535,33873,42325,33842,16776,12582,21066,33776,42293,25195,20969,21001,21001,18954,27503,33809,14728,23276,44438,52891,33875,33873,57051,54970,48335,42029,42029,39916,46254,42062,46287,42094,46287,40113,50646,52856,48664,48631,50646,50711,50712,59096,48630,23372,23275,40211,29743,25454,36050,38227,38131,50645,50645,44274,46453,46485,46419,54871,35952,46419,40146,38065,48500,29581,50678,33774,40145,46451,35984,50645,42225,46451,50612,46483,52692,52725,46418,52724,46483,48663,48664,50711,37967,25355,31694,50711,27501,38066,35856,10598,17002,33776,46387,46551,46551,44470,42325,27437,16904,21097,23177,25257,16937,23178,16872,18985,14825,16938,27502,27534,27502,27502,29550,255},
{38232,29911,27831,23638,27896,27864,48892,32121,25751,27864,29911,36217,38265,38297,38297,40345,34104,31992,32024,32057,32057,23639,17332,13106,13074,21363,21395,21395,21362,29747,31860,31860,31827,29747,29747,29746,31794,27633,27569,27568,27536,29615,35921,38034,25324,14793,10567,10600,10600,8487,6439,6439,6407,6407,6407,6407,6374,4326,4327,4327,8552,31728,29648,23309,25455,29615,23244,27502,29583,29647,27437,20936,12420,25422,33841,42227,23082,18889,18888,16840,14695,23277,33776,18953,27437,35953,55069,40246,33907,52857,54970,52693,44141,46287,42093,39981,44175,42094,44240,42127,42291,52890,57050,48533,42261,46453,48534,38099,54936,57016,38064,25354,31759,38162,27631,29712,31791,31792,44372,46387,27468,33840,40146,38032,52725,42258,46419,50644,46451,50644,48563,48531,52756,48563,50611,50644,42225,52724,42160,48532,52790,48629,52789,46419,52790,54968,50840,52922,52825,48597,33839,38033,46453,46518,33872,44404,44307,50745,50810,48500,44306,46551,44471,44438,42293,25324,16872,23178,27401,29449,16905,23178,16905,16905,14824,16970,23309,29615,27502,29582,255},
{36152,29879,27831,23638,27896,27864,48893,34202,25751,27896,29944,38265,36217,40345,40345,40345,36185,32024,32057,29977,32057,23671,15252,13106,13074,21395,21362,23507,25554,25553,29779,31860,31860,31860,33973,33941,31762,27536,23375,23375,23375,25422,33841,38099,25324,14826,8520,12681,12745,10665,12713,12713,12745,12745,14826,14825,12745,12713,12713,12713,10632,12713,21132,21164,29615,29616,21163,27502,27502,25421,27437,21001,16808,27633,33841,40049,21001,18920,18921,18921,18986,25455,42260,48401,50481,48401,54971,48730,40213,46584,54937,54970,46287,40079,37869,35788,42127,37901,44240,40013,44305,57084,59196,50679,38067,46453,46421,38067,52889,59097,44339,23307,23308,25454,25453,21195,25453,31856,31825,48566,50612,44306,44306,44273,44273,52757,46483,50612,50676,46516,54902,48596,54902,52823,48597,52757,48564,54871,54904,48565,57016,57048,48597,50677,40080,52791,42291,35986,46681,50744,50645,33709,31662,46485,40113,25420,50710,44274,44241,44208,40015,40179,46552,44471,44471,40180,21130,16904,23209,27338,23145,18985,19017,21065,14824,14824,16970,31662,42062,31662,255},
{31959,29944,27864,23638,29977,27864,50973,34234,25751,29944,29944,42458,42458,40377,40377,40345,36185,32024,32025,29976,32057,23638,15252,13074,15154,23475,25587,29748,29715,29747,31828,31860,33908,31828,33876,31795,14924,12778,12778,12810,12811,19149,35954,40180,25357,16906,6374,8454,8487,8455,6374,6374,6374,6342,6342,6341,2148,2149,101,101,101,36,69,4262,27469,25390,23277,27502,29615,27535,27469,25324,25487,27633,36020,33743,23114,23114,23146,23146,23179,35954,38001,40015,37902,29516,42228,55069,44438,44439,50711,57116,50579,42093,44206,42061,42029,42094,42127,44240,42160,54970,55004,54937,46519,46453,44373,36018,52890,54937,56919,25388,17034,23341,23340,17001,21260,23373,21260,44405,52693,42226,42226,48597,44371,54903,54935,52790,54805,54903,54871,59129,50710,57016,52823,42291,52725,33807,50678,46386,33904,57016,38129,46483,35919,42291,50644,42323,44502,54970,50744,40080,25322,31726,50711,27501,35953,50646,50679,48566,42096,40015,48533,46584,44439,44503,35987,16937,18985,19017,29418,16904,23178,18985,21065,14824,14857,27436,46222,31662,255},
{29879,27831,27864,25686,32122,27864,50941,36347,27831,32057,29944,48665,52890,42458,40377,40345,36185,32024,32024,29976,30009,25751,15252,13074,15122,25523,27602,27602,27570,29714,29715,29715,31795,31795,31795,31795,14924,12745,12778,12810,14891,17068,33841,40147,21164,12713,68,68,68,36,36,36,4,36,35,36,3,4,4,36,37,36,4,2214,27469,25455,29615,33775,31695,31630,29517,29517,33939,27600,38133,33808,25291,25324,31630,31662,29549,35921,29583,35887,37869,27436,31662,50778,52891,42358,44438,57083,54904,44174,40080,35789,33676,39949,35789,42192,42063,54970,55036,54905,42293,48502,44341,29648,35955,54971,59065,42291,19146,21227,29743,29710,19114,29679,38194,42356,42194,52724,40048,37968,35887,33774,56984,44403,40145,50644,31694,54871,42290,44339,54870,42290,50612,48531,46418,54837,44305,48499,54805,44305,52724,50644,48564,52789,44371,52889,55003,50711,35920,27468,38066,46517,23307,46550,50712,52792,46353,40015,42127,44373,44504,44471,42390,33841,14824,21065,18985,27369,18952,23178,21097,16872,16905,16905,21163,29582,255},
{29879,27799,27831,25718,34202,27864,50941,40475,27864,34169,29976,50778,65402,52858,42458,38297,36185,32024,29976,29976,29977,27896,17332,13106,15154,19314,25489,27602,27602,29715,29714,31795,31795,31763,31827,31827,19149,14923,14923,14955,14956,17004,29582,35922,21132,12745,2182,2214,4262,4294,4294,4327,6375,6407,8487,10568,8520,8520,8552,10600,10600,12746,14826,16938,27470,27437,23179,23179,21001,18888,16840,14663,27535,29681,33907,40212,33808,23243,27502,31695,31694,33808,27502,38001,46320,42160,44404,44405,42357,40180,42326,54937,55003,50481,42126,46255,44142,42061,42094,46320,46321,50679,57117,52857,44406,48533,42228,27567,29648,44438,54969,56983,29614,19146,25518,42388,25484,25453,38195,29744,25454,48532,35919,33872,38065,38032,50612,52757,44338,52692,50611,46354,54772,42192,48531,48498,40080,52724,44305,46418,50677,40145,52790,48597,46451,54838,50774,59129,54968,52823,57050,52857,50711,40146,42194,46452,46485,33807,50679,50744,52923,38001,21097,27469,44471,46552,42358,42358,29615,16872,16937,21097,23209,23145,16937,27371,18985,16905,14825,21163,255},
{27799,25718,25751,25718,34170,27864,53021,42587,29912,34169,32057,48698,65402,52858,42458,38265,34105,32024,29944,29976,29977,29977,19445,13138,15186,15121,21296,21328,21296,23408,25521,27602,27602,27602,29714,31794,21262,14956,14956,14988,17069,19117,29583,38002,25357,19019,10568,10568,8487,8487,8455,6375,6374,6342,6342,6342,4229,2181,2149,2116,36,14761,27372,27274,25194,23114,20968,21001,18888,18888,16840,14695,25357,31793,31761,40213,35953,23308,25356,31663,29613,25355,27503,42227,50481,44241,42193,42226,31793,33940,40278,48631,59164,52790,42029,35821,35789,31628,42160,37934,40112,40080,57083,50711,46486,48534,40115,27535,27600,36051,52858,59064,50743,29775,19114,31824,38194,34000,33937,38194,33968,46518,54805,48596,46418,44306,42192,50644,46418,42225,52725,42225,50677,50677,42290,57016,44404,50645,52692,48564,56984,54871,46451,59097,48565,40113,50612,31694,54904,40146,33906,48632,48566,48565,31564,29613,50711,29581,33873,52824,50613,48499,42128,44176,44273,46519,44471,42326,42326,25357,18952,14824,25258,23145,23177,23243,23210,18952,14792,16905,255},
{27798,25718,25751,27799,34170,27864,52989,44667,29944,34201,32089,48698,65435,52858,42458,38265,36153,32024,29944,29944,29976,29977,17365,13139,15154,13073,17135,23441,31860,25489,23376,25489,27569,27601,29682,31794,21262,14924,12876,14956,17036,17036,27535,38034,19051,10601,36,36,36,36,36,36,36,36,36,2149,69,101,101,2181,2181,14729,27405,25194,27274,25162,23081,21033,18920,18953,18888,16840,25358,33874,29649,40213,40147,27469,23244,29582,27533,12774,16970,40114,48400,42128,27469,31597,21197,38198,44406,42325,57050,57051,46255,37868,44142,42094,46254,44174,46320,44240,52759,48631,46486,50614,40212,27535,25455,33907,48762,54969,59096,38064,19114,23372,25517,17066,21260,25485,19179,33873,50646,50677,50774,50742,50677,50677,59097,50677,52725,52757,48500,56984,50580,40114,59064,33741,42226,44305,29678,56951,31694,44372,52790,36016,52725,44338,50676,54805,50644,46419,40180,50743,42226,27403,35920,50743,23275,44437,50612,50547,48433,31531,21130,31728,46519,44439,40245,40245,21163,18984,18985,31562,27337,18985,25258,14824,18985,14824,255},
{27798,25718,25751,27798,32121,27864,50941,42620,31992,40442,36282,48730,65467,59098,42457,40345,36185,34104,32024,29944,29976,30009,21558,13139,13074,13041,17136,23408,33973,23408,23408,27601,27601,27602,29714,31762,21295,14988,14924,17036,17036,17036,27503,38034,25357,16939,8520,8520,8520,10600,10600,10600,10632,10632,10600,12680,10600,10600,10568,10568,8487,16939,27405,25161,27274,25161,25129,23049,20968,18921,18888,18921,29616,35987,29680,36020,42292,31727,23276,27469,31695,17032,8581,42194,48433,37968,27501,35855,31761,42326,48599,42325,50744,57083,52692,39981,37967,35821,33677,37967,35822,37934,42064,48598,48566,50679,42326,23342,25487,38132,33907,50777,59097,46516,25517,19114,29711,33936,21162,27598,38194,25485,40179,52725,48596,42323,35952,29581,44372,52725,25420,50612,35919,38098,52725,33839,52790,46418,46451,54804,50579,52724,52691,50546,52691,50579,48466,48433,40015,50612,35822,42259,42260,42293,52856,35920,23275,42324,42259,27566,50711,48466,50546,42095,37902,42063,44339,44503,42358,42358,40180,21098,14824,21097,19017,25257,14824,21130,18985,14824,255},
{27798,23638,25751,27798,34170,27864,48860,42652,29944,42490,46683,57083,63355,61178,40377,38297,38265,34104,32024,29976,29977,29977,19445,13139,13074,13041,17201,21296,31828,25489,23408,25521,27602,27602,29682,29714,21295,17037,14988,17036,14956,14923,25422,40148,23245,14794,2181,2181,2149,2149,2149,2149,69,69,69,2117,36,36,36,36,4,23278,31663,27274,27306,27242,25194,23049,21001,20968,18856,18888,27535,33906,29680,31826,44406,40114,27469,27469,31695,23339,8581,27467,37935,29582,31662,40080,31728,42325,50711,44471,44373,57050,54905,46255,42159,42093,42062,42094,42094,44239,44207,46353,42227,48599,44438,25455,27599,40213,27600,44439,52824,59096,40242,17033,23373,42356,27533,23372,38131,27566,27502,44339,48531,40210,42258,42258,46451,54837,48531,52724,52724,50579,52659,50514,48434,50579,40015,48434,40079,40112,48499,33806,52758,46484,44306,48499,46484,56951,52726,48598,42260,42293,44438,50711,38065,40113,48598,42227,38033,52824,50547,52660,44208,27370,25291,38099,44471,42358,42390,35987,21098,14824,21097,21064,21064,21065,16905,23145,255},
{29846,23670,27831,27799,32089,27864,48828,44733,32024,48762,46650,65435,65403,61210,40377,38265,38265,34105,32024,29976,32057,27864,17332,13139,13106,10993,15153,21296,25521,21296,21296,25521,27634,27601,29682,31794,21295,14989,14989,14988,14988,12876,21229,35889,21262,12811,4360,4392,4424,10698,2247,69,102,102,101,102,69,69,102,69,6310,23114,25357,27372,27274,27274,25226,25194,23146,21001,18921,18920,31761,33938,29647,27568,42326,44372,31727,27469,31695,27533,10726,10727,27534,27502,33775,38066,27502,42293,48598,48599,42326,57018,57083,50514,42159,40047,37901,35821,40047,37934,40112,37967,35887,42325,52922,36052,25455,33874,27600,29745,46584,59097,52791,29743,23340,25421,23275,19081,23341,27566,16970,35954,50579,52659,48499,46353,42127,50612,44273,37967,48466,33806,50645,42193,44339,54838,44339,48466,50677,54838,56886,52725,56951,50612,48498,42095,42226,46354,27468,44372,40180,44406,42261,48599,48533,23242,31760,50711,25355,42357,52726,50547,50580,40245,40311,46519,44438,44471,42358,44439,31793,16937,18985,16905,25257,16872,21129,18985,255},
{29847,23638,27831,27799,32089,27864,46716,46813,34137,52955,44570,63323,65467,61210,38297,40313,40345,36153,32057,29976,32057,25784,17332,13139,15186,13073,19315,21361,21263,21295,23376,25489,27569,25521,27602,29747,21295,17004,17036,17036,19149,17036,14988,19117,14956,14989,17102,17069,17036,23407,6441,69,70,69,37,69,2247,37,69,37,10503,25293,25390,27340,27242,27242,25194,25161,25194,21001,21001,18920,33841,35986,29615,27567,40213,46453,35953,27502,29582,33807,31726,21227,27534,31661,37902,44372,27502,42293,40180,44373,48631,54937,57083,54871,42126,40080,35821,37901,40013,40013,44272,42127,44240,44305,59196,54970,27568,29713,27568,25520,42326,54904,59064,36017,21292,21260,23373,23340,23373,27599,23373,29647,46386,44371,42291,42259,44371,54871,54838,50612,52660,52725,56919,50515,52725,48466,44241,48433,29483,46451,40080,29613,52758,29645,42192,25387,35985,40047,27598,42291,40179,44374,44406,42261,50743,40113,21162,42292,46452,23307,52824,50612,50580,52825,48533,40049,33775,42358,44471,42358,42358,31696,14824,21097,14824,23176,21032,14857,255},
{29879,23638,25783,27799,34202,27896,44603,48925,32089,55035,46650,61242,65467,54970,36217,42425,42425,36185,34105,29976,32057,25751,17332,13106,15154,15122,21395,21395,21362,21328,23408,23440,25521,25553,27634,29747,23343,14923,17036,17036,21229,17068,12875,14956,14956,17069,17101,14988,14956,19150,4361,37,69,69,69,102,8553,4295,2182,2182,8455,23212,27308,29518,27274,27307,25194,25162,25161,21000,20968,18856,29550,35954,27469,27600,33906,46518,42227,31662,27469,31727,35920,31727,38001,33741,31628,38001,35986,29648,35987,31792,40212,44406,57050,54970,48368,44304,44207,39981,40046,44305,40047,40080,40047,37967,52792,59196,36020,25488,27601,27600,27600,52825,59065,42227,19179,23373,23373,21227,21227,23340,19082,23308,50580,54871,50645,44273,42128,56919,35887,40080,40080,27500,50580,21128,44339,37869,31757,44240,23339,48532,40079,40112,50611,42192,48433,44305,48466,50546,42159,33775,40147,42325,44406,42293,42293,52824,33742,23308,48598,35920,33905,52791,46354,48467,44241,29549,29582,35986,46551,44439,42326,40278,27502,16872,27175,35529,25224,23177,255},
{29879,23670,27831,27799,34170,27896,42523,51038,34137,57115,48698,61242,63387,50810,36217,46585,46585,38265,32056,29976,32057,23703,17332,13139,13074,17202,19282,19315,21428,23475,19314,23475,21329,21296,21328,21296,23375,21230,17069,19149,25456,23343,17069,14924,14923,33808,25324,21131,23243,27437,21099,18986,19018,21066,21098,21098,23178,23178,19018,19018,16970,21132,29258,29453,27307,27339,25226,25226,23114,23146,21001,18888,23179,35954,33840,33840,29648,44438,44372,33807,27469,31695,27500,21163,33840,42128,33774,35887,38067,29648,35954,29680,33972,40246,52824,55003,52692,42127,40047,37933,35821,46352,40047,46352,42159,44272,48499,61309,50777,27600,25519,29713,29713,42293,56985,40146,21324,14889,27598,27565,12743,27566,14855,25355,44305,33936,29646,19113,27532,52757,27500,42192,37999,35919,50579,37966,50547,46353,46385,48465,48465,48465,50546,50546,50513,50546,50546,50546,50546,50578,40046,23242,33807,42293,40180,33841,38067,44406,52791,38033,40114,48565,37968,40146,42258,27500,46485,38000,35854,27436,38034,44503,42390,40245,40213,25292,47782,47914,31463,25257,255},
{29879,23638,27864,27799,32089,29976,40442,53118,36282,59228,50842,63355,63354,52890,38265,48633,48633,40313,34105,32057,32057,21590,17332,15252,13074,17202,19314,19315,21395,21428,13073,17234,15088,12974,12942,15022,29682,23343,12908,19182,23376,23343,14956,10763,14891,38001,27339,25226,27371,27339,27371,27371,27403,29419,27403,27371,27371,25291,23211,21163,21163,23179,27177,25227,27242,25161,25097,25194,23081,25194,21001,18921,25325,33906,35953,35986,27567,40245,46485,35953,27501,23306,12839,10695,23310,40080,35854,40113,38067,35954,35922,16971,33907,36085,44470,59163,54937,46287,46385,52625,44207,52625,50610,52626,50578,50513,46385,59162,61309,38100,25455,31762,27632,38131,59065,42259,29678,12808,31857,27565,12775,27566,16935,31693,46386,42225,42193,42160,46385,50546,48466,50546,50546,50546,50546,50578,50514,50546,50546,50546,50546,50545,50513,48433,48400,46320,46287,42094,40014,37933,35886,35919,23243,38034,33841,25422,33874,40212,48631,48533,23178,35985,42259,21130,44437,29548,27533,50678,46321,31596,21162,36019,44503,40245,40245,40212,25194,18920,16872,16872,255},
{29846,23638,27864,27799,32089,30009,40410,53118,40443,61308,50810,63355,63258,52890,40345,52793,48601,38265,34105,32057,30009,19445,17332,17332,13106,13041,17202,21395,19347,21428,17234,17233,15088,12975,12974,25521,33842,21263,12876,17069,23408,23344,17036,12843,17036,40114,31597,27371,31597,31596,29516,31532,31564,29484,29484,29484,29452,29484,25356,25356,25324,23114,27308,27275,27372,27274,25161,25194,23081,25162,20968,20968,31631,36019,33841,38100,29648,33906,46518,40178,25452,8677,6532,4420,19116,33808,40047,37968,33775,40114,35954,14923,36019,46584,40245,54937,57083,52692,42127,54804,48368,50513,50578,52658,48465,50512,44240,50547,63389,46551,25488,25455,31826,44438,56984,40211,27566,17034,29711,25452,17002,23340,14920,33839,52627,52627,50578,50578,50578,50546,50578,50546,50546,50514,48433,48433,46352,48400,42127,44207,39981,35821,35820,31595,35820,33674,29547,35819,27434,31692,29580,46517,31661,27501,31728,27567,27535,38132,40180,50743,38000,23243,46485,33807,23341,46453,35687,42193,48532,37869,29483,31629,44406,42326,40245,40278,36019,19050,14792,21064,255},
{27798,23670,27896,27831,34169,32089,38330,55198,40443,61340,50777,63355,61146,52826,52825,54873,46553,38233,36185,34105,27864,17300,17332,17333,13139,13041,13041,17266,21427,19347,19315,17233,15088,12974,12974,19215,23376,19215,14989,25520,21263,21296,19150,14956,19084,42227,33710,27436,29517,27436,25323,23243,23243,23243,23243,29517,29517,27436,25324,23211,21098,18986,31697,37840,29485,27372,27405,27405,25357,27502,25357,25455,29583,40213,33841,36019,29680,29680,46518,46484,19145,6596,4484,227,12809,27535,42192,35887,35854,35854,37935,19017,27502,46551,40278,48631,57083,54872,42029,42094,42094,39949,42127,40047,40048,35855,35920,31662,54970,57083,36019,25455,40311,50712,56952,31792,19179,23405,23373,14953,21260,25421,14921,40080,50546,50514,48433,46320,44207,46287,44206,37934,39981,35756,33708,33675,29515,40012,29482,29579,35787,25322,33740,27434,31692,33739,29580,37965,33805,38031,38064,54970,48532,21129,33808,33841,23276,25422,40180,42293,52791,31694,27501,46485,19083,31793,46286,25289,44404,31661,31661,33807,40146,42293,40180,40213,42326,33874,19017,18985,255},
{27766,25718,29977,29911,34137,34137,36282,55198,36250,59227,48697,63387,57017,61177,63257,50713,44473,36185,36217,34137,25783,17300,17332,17365,15219,13073,15121,17267,19315,19347,19347,17201,15120,12975,12974,15054,31730,21327,14989,21262,19182,25489,17070,12844,21230,42260,35823,25324,17003,14890,12745,12777,12745,12777,12809,23244,25356,25389,27437,27469,27469,27469,33809,44243,33841,29550,29615,29550,29518,29518,27372,25324,25227,40245,35954,33873,29615,27600,40212,46517,25485,10789,6597,2340,8646,21230,40080,37967,38000,31628,31596,27403,27436,46486,48632,40278,55002,50744,31563,27469,27469,27437,29582,29582,27469,25356,25324,23276,48598,61308,48599,27567,42326,52824,54839,31727,14887,23307,25420,19015,21194,27499,27433,31660,35820,35755,29515,35787,29514,29579,37899,25322,33739,31595,27434,35852,27467,33772,31659,33773,37965,37999,40079,40112,46451,46483,50643,48563,52822,54902,50774,52856,46418,27369,25356,35953,29615,23308,36019,40213,44405,50678,31759,42291,44372,33872,46550,40178,33840,48630,27370,21097,27501,38066,38067,40245,40245,40278,31728,14825,255},
{27798,25719,32057,29912,34169,36217,38330,55198,34169,57082,48730,63387,52825,61145,65305,48665,40345,36185,36217,34137,27864,17332,17332,17365,15252,13073,15121,17234,19347,19347,21427,15121,13040,13007,12974,17103,25456,25456,19182,15021,21295,23409,14957,10796,23311,42260,35855,23244,25389,23309,25389,23309,25357,25389,25389,35823,37936,35855,35823,33742,31662,29550,35857,33483,29387,27209,27242,27209,27242,25162,23049,23049,20936,40180,38099,31793,23276,27535,36019,48664,36018,14983,6597,4517,2372,19148,33808,35822,35854,33741,33741,33709,31595,37968,52825,40278,50777,50712,19083,21196,21228,21228,21196,21196,23374,21196,23373,19115,40114,59196,54970,33907,29713,50711,54872,35886,37899,29548,27532,37965,27467,25387,40012,25354,29547,35852,25354,33739,33740,31660,37932,35854,37966,37998,44305,37934,46418,48531,48628,50579,40112,52725,52757,44338,54838,50644,42193,50611,42290,44370,48563,38163,33806,31661,27403,25389,35954,23341,27534,31793,40212,48631,50678,27436,42324,38001,27502,50711,23243,40211,40114,14791,25356,31727,33840,40212,42326,40277,40278,29615,255},
{27799,25718,34170,29944,34105,36217,38362,57278,32122,48762,50810,63388,52857,61145,65305,48665,38265,36217,36185,34137,29976,17365,17332,17365,15252,15154,19282,17234,17267,19347,19347,15121,13040,13007,15055,27602,23376,23375,23375,17101,17037,19216,17037,17037,19150,42260,35888,25389,25389,27502,25422,29614,29614,31662,31662,33742,33742,33743,33775,33775,33743,31695,35824,27340,33809,29420,27404,27339,27372,25259,23114,23114,18888,33744,38132,33905,23406,27567,36051,46550,38098,17097,8710,4484,291,12873,33841,33742,37901,37901,35821,33708,31595,31596,50711,44406,46616,48632,19115,25486,21228,23276,23309,21196,23341,21163,21196,19050,21163,44405,61309,44438,33939,52857,57017,38033,40079,35854,29515,33609,27402,33773,37965,35886,40079,37966,48531,42192,40112,52757,42257,48499,46417,42225,56919,48531,46386,56983,48532,42257,48466,31628,46418,35885,33773,48531,38097,48531,48563,46418,50644,48563,33773,42292,42259,25355,33841,31728,25454,23341,40180,40212,50744,40114,25388,48598,27534,44536,46517,16970,46518,31726,21097,23243,27469,40212,42390,42358,40245,40213,255},
{29879,25718,34170,29944,32057,36217,38362,57278,32121,48762,48730,61275,54970,61178,63193,48665,38265,38265,36185,34137,34137,21590,17332,17333,15252,15121,19282,19347,19347,19380,19347,15121,15120,12975,15054,31794,25488,21327,23408,21295,14989,15022,14989,14989,23343,42293,35888,25389,23276,21163,25356,35855,35823,35823,35790,35823,33742,33710,31630,31597,29549,27437,23243,23211,27274,25096,25128,25129,25096,23048,23048,23016,20903,27372,40245,35953,25584,27599,38100,44437,40244,33970,21422,12937,4484,8680,25454,40015,35789,37967,35821,33708,31628,31628,46453,40181,46584,46519,17035,23406,23308,23309,21228,23276,25551,23341,27599,19147,17034,25422,57083,50776,44536,54937,56985,52758,52790,54903,50611,39948,33773,44305,42192,42226,46419,42193,50644,56951,42193,48532,52757,33773,48466,37966,35886,54870,29580,48499,50676,42257,50611,42192,44305,50611,44305,46418,52724,44370,52724,46418,44305,50611,40112,46518,46518,29514,23276,31761,27567,23341,31793,38067,42325,52856,31694,31727,46518,38099,48598,31663,19148,50678,27435,21227,27534,38066,44406,42391,40245,40213,255},
{29879,23670,34170,29944,29976,34137,38330,57279,32121,46682,44570,57083,55002,50746,61146,52825,38297,38265,36185,34105,34137,27864,17332,17332,17332,13073,17202,19315,21395,19379,19347,15121,15120,12975,12974,29682,25456,21262,23343,25488,19182,19182,25521,19247,31730,44373,35889,19083,21163,17002,16937,25323,25291,25291,23211,23211,23211,21130,21130,21098,19050,19018,16905,21131,31728,27372,27404,29452,27404,27436,23114,21066,18920,21066,38133,33873,29745,27632,38132,52824,42259,42324,40244,31792,21324,29711,21261,29615,37999,40080,37967,35821,33708,31629,42358,42326,50809,42261,21261,31858,21196,23308,23276,21196,25421,21228,23276,19115,19147,19083,42325,59196,54970,57083,54904,56950,59031,56952,59064,46288,35854,40080,46385,29579,29548,27467,29580,54870,46418,35919,54837,38031,46385,50611,44272,50579,50579,42127,50579,46450,44338,52724,42224,48531,48531,44273,52724,50677,46451,52724,42225,52790,52790,40146,29680,31594,27402,23276,33873,25487,23276,29648,42294,46519,50743,27501,44405,42259,33873,48598,31825,42259,46550,35887,31694,27534,29679,42358,42326,40245,255},
{29879,27799,38362,29944,29976,34137,40410,57279,32122,44602,44570,46650,48730,40377,56986,52826,38297,38297,38265,34105,34137,32057,17365,17332,15252,13041,17202,19315,19347,19380,19347,15121,15120,12975,12974,17135,14989,23311,25423,27568,17069,25456,21262,17069,25455,44373,35921,14956,25357,25389,19083,25356,27469,27469,27469,27469,29549,27469,29517,29517,29517,27469,25356,23212,29387,27177,25161,25128,23016,25096,22983,20936,20871,18856,33777,33906,38067,31793,38132,48598,42292,40147,35953,38098,38034,38001,25422,21261,40080,37934,42161,35854,33708,35854,50809,42358,50777,38067,23406,27599,23276,23308,21163,23308,29679,25388,27566,23275,23340,12776,23276,59196,57017,54937,54969,56951,59063,54871,56983,54773,42160,42226,46418,42224,42192,44337,44305,46353,52724,42159,44305,52691,42160,50611,46353,44273,52692,44305,46385,54837,46483,50611,50644,44338,59096,46484,50645,59097,50710,48596,46419,38000,50678,46581,31791,29482,40113,25323,25454,31793,27503,25454,38100,40278,48664,50743,35888,48630,40081,31726,48631,25453,48729,42194,23209,29549,29581,33840,44438,40245,255},
{29879,25751,36314,31992,32057,34137,38298,57311,34202,46715,48762,38330,38330,36185,52826,50746,38297,38297,40345,34137,34137,34137,21526,17332,15284,13041,15121,19315,19347,21428,21428,15153,13040,12975,12974,25488,19214,29680,25423,25456,12908,23343,21230,21197,27502,40180,33808,19083,23277,19051,19083,29582,31694,33742,31694,31662,33743,31662,31662,31662,31630,29581,29549,25357,25357,25258,27339,27436,23178,25291,21033,18953,16808,16840,29421,38132,35986,29712,40212,48630,42292,38099,35985,31694,23275,23242,23275,19149,38000,35854,42193,35886,33741,37968,48664,48664,48631,31760,34003,31760,16937,19050,16937,19017,21195,17001,19114,16969,17034,14922,14955,44405,59163,50679,55035,54871,59064,59096,54871,61144,50547,44241,40080,46386,40079,42225,44305,42192,50611,48563,44240,52757,50677,44338,52724,42193,52758,54871,44306,56984,52822,48597,48531,44338,42193,52758,29613,42291,48629,42420,48596,31759,42258,52822,50676,35919,44404,33641,21162,29680,27535,23341,36019,46585,44439,52824,38033,27534,50711,25323,35953,46583,35921,48631,38000,27337,27370,33806,44405,42358,255},
{29879,25718,36282,32024,34169,32089,36217,59326,38330,48827,48762,36249,36249,34104,48666,46618,40345,40345,40345,36185,34137,34137,23703,17332,17332,15154,13073,19315,19347,19347,19347,15153,13040,12975,15055,33810,29681,38002,27568,19182,23408,27601,21230,19149,14988,40180,33775,21131,25422,19083,19083,29549,33774,33742,33742,33742,31662,33710,33742,31662,31630,29549,29549,25324,23146,23081,23081,25194,21001,21033,20968,21066,18953,19051,21099,40213,33874,29713,40212,48598,40244,38098,33872,14918,6500,6532,14824,17004,29647,40047,40048,40048,33741,38033,42358,36019,50744,35954,31792,29711,21195,21195,25388,21195,29711,25485,31760,25486,29679,23341,23406,29615,57018,52824,55003,57083,61144,63257,56985,57016,56886,46385,42194,46386,46386,40145,42258,40145,48532,59096,44371,50645,56984,44371,44306,48532,44467,52790,35855,29613,48597,42387,46515,48564,35983,52725,46450,44306,52724,50611,44338,52724,42160,46418,50644,46548,37967,21064,25387,21228,31793,27567,40245,48665,46617,42358,52856,31663,31760,46485,31857,50776,35921,21195,48663,27371,12677,25388,35985,44405,255},
{29879,27799,42523,32024,32089,32089,34137,57246,36282,50875,50842,34169,32089,34136,46618,44538,40345,40345,40345,36185,34137,34137,25783,17332,17300,15154,13073,17234,21427,21428,19347,15153,15120,12975,17135,25456,29649,33809,19149,21327,38068,27601,17069,19149,14956,42293,35888,18986,23309,19051,17003,25356,29549,27437,27436,27437,25388,25389,27437,25388,25324,25324,23244,21164,19083,19018,18986,16937,14824,14825,12712,12744,12647,14694,16645,38002,33939,29680,40212,48598,38131,38098,31726,10757,6533,8613,12710,12777,23374,42160,35854,42225,35854,40081,48697,34005,54970,44470,31760,40309,31727,27469,29581,25388,29614,27501,27501,25421,23308,19050,19115,17002,38001,44308,48664,57148,54904,59064,61177,54936,61177,44240,31629,38001,50579,40113,38000,33806,29580,46484,48597,27532,48532,44403,31725,48564,48628,50676,50612,42224,48499,52691,44240,48531,52692,40079,52724,40112,44306,50611,42193,48499,48531,40112,50677,50742,42289,27468,35854,23209,29615,38067,42325,44439,48731,44472,44406,50678,14825,38098,46452,27469,42161,23274,31629,31596,21292,31792,38099,38098,255},
{29847,27799,42555,32056,32089,32057,32025,55166,38362,50875,52954,34137,32056,34104,44538,42458,40377,40345,42425,38265,34137,32089,27896,17332,15252,13073,13073,15154,19347,21428,21428,15153,13040,13007,17168,15022,19182,29648,23342,27601,29616,27569,21295,19149,12908,40148,35921,17035,19116,25356,21163,23276,27469,27469,29517,27469,27469,29549,29581,29582,29549,29517,27469,27436,23211,18985,14792,12679,12711,12711,19017,18985,31272,35367,35335,42033,38133,29680,40244,46517,40179,38066,27565,8676,6532,8614,10629,10694,21197,38000,40079,42225,33774,40179,52891,40278,52889,50777,31760,33937,27533,23275,23276,21195,23308,27598,23340,27631,25420,25388,27533,29613,31628,29581,46616,52923,52791,46485,59064,59097,59097,50612,19015,31727,44306,46515,40209,35984,40144,44338,54837,46450,46386,52724,46450,44305,52724,40079,48498,46385,37999,50611,42192,42192,50644,44338,44305,52790,38032,52790,48597,42324,52757,44436,48662,57017,44404,29711,27435,18918,23242,29647,40212,40213,48730,46585,42326,44307,31563,29418,35821,37933,27370,46385,31530,27403,33774,35954,23209,25356,255},
{29847,27799,44603,32056,34170,32089,32024,55133,40442,50842,52922,34137,32089,32056,42490,40410,38297,38265,40345,36217,34137,32089,32057,19445,15219,10993,10993,17234,17267,23508,21460,15153,13008,12975,19184,17102,21327,27536,19117,19214,12876,14924,17036,19149,14956,31761,38001,19148,12842,19050,16938,19051,29517,29549,29549,29549,29581,31662,31662,31662,31662,33710,31630,31662,29549,29516,27404,27404,27371,27371,27436,27436,27372,25291,23178,27404,31793,29712,42358,48663,40212,42325,31791,10789,8645,12807,8613,23338,25421,33742,39982,38032,38098,44437,35921,36019,48631,52857,40180,29711,29744,27534,33807,31628,42192,46352,44240,48400,46288,50545,48498,50545,48530,46352,46551,42326,57017,42357,52856,61210,54937,59064,42193,42225,44306,50611,48530,42160,42193,37966,46418,52692,38032,48531,48563,42257,50579,48531,40112,54870,40113,44339,54903,40146,50645,50644,44371,52790,48533,37935,52791,42356,38097,46451,33936,46484,42291,38130,25322,25519,35952,21194,35953,40245,48763,46584,42358,44437,40015,29417,33676,44142,31563,31563,40047,31563,29548,35888,31694,21129,255},
{27799,29911,46683,34104,36282,32089,29944,55133,40442,46682,48794,34137,34169,32056,40410,40410,36249,36217,38265,36185,34137,32089,32089,23671,15219,13073,10993,17202,19347,21428,21428,15153,13040,12975,23377,21295,27568,31761,19149,23440,17101,14956,8683,19149,12875,27568,38033,25389,19050,14825,10632,10664,29484,33677,33677,31597,31564,29484,29419,27371,25259,23178,23146,21065,18985,18985,16937,16905,16905,14792,12777,16969,14857,14857,16905,16937,27568,29713,42293,44372,42325,44470,25484,8645,4452,8614,14920,33839,46320,42160,33741,40080,40146,40211,36018,40245,42325,54937,46519,29647,40276,29712,48630,44207,48563,50513,44208,50512,44239,50545,48498,50578,46385,46352,44372,38165,33841,33874,46518,61177,59129,57016,54806,27370,29549,44273,50611,42160,42193,44338,38032,54903,48564,40146,57016,48629,46451,52725,46452,50612,52791,35854,48532,48565,33872,46451,33839,27533,48565,25420,42291,48564,42322,48531,48563,46451,48531,50644,38064,33872,46291,27370,21195,36019,46618,44439,40245,48729,52792,35789,27337,40047,56883,40078,56916,54803,46352,33709,35921,25389,255},
{27798,29944,48795,32024,38362,34169,27864,55067,44570,44570,48795,36185,34137,32056,38329,40410,36249,36217,34137,34137,34137,32089,32089,23671,15220,13074,13073,15154,21427,21428,21460,17234,13040,12975,23377,19183,21295,27536,23375,31794,15021,23374,12876,19182,15021,21229,38067,27567,21164,10664,8487,8552,18985,18986,19017,19017,18985,18985,18985,21033,18985,19017,21066,18985,19018,21066,19018,19018,19018,18985,18985,18985,16905,16938,14825,12778,17004,29745,44438,44405,44405,46584,40244,14986,8679,14953,23307,25389,42161,42160,37967,40080,42227,38066,44470,55003,40277,50744,52857,35954,29679,36083,55036,50514,42160,54771,42126,48400,44239,48367,48400,48399,46254,46221,44109,46551,36117,27567,40212,57017,61242,54969,59097,29580,23240,38033,46451,42258,42258,48597,44371,50580,57017,42258,42226,52791,27533,38032,40145,23307,48597,27565,33839,50645,40177,46418,48563,44305,46385,52692,40047,46418,50676,44371,50611,48564,46450,50676,48532,42323,44308,37969,23243,27501,38034,35888,33775,52889,57116,44339,33611,44142,52626,61044,33644,52756,46255,23177,33677,33841,255},
{27766,34104,50907,32056,38362,34169,27831,48730,44602,42490,46715,34137,34137,34105,38297,38362,36217,34137,34137,32057,32089,32089,32089,19477,15252,13074,13073,15122,19347,21428,23540,17234,13040,15088,25554,12974,10829,10796,19182,29681,25488,21294,12875,17069,17069,14955,33907,23374,16938,16937,12712,14825,23210,25258,23178,23178,23146,23113,21065,21033,18985,18953,16872,16840,14792,14760,12680,10632,10632,8552,8519,12778,29746,29747,12779,12779,10698,29648,42293,40179,29582,29582,31695,29647,29712,27533,25356,27568,40145,46352,37999,33807,42226,38066,42292,52858,46552,44438,54937,44470,29679,44503,57149,52725,39882,48334,48333,48301,50381,50381,48301,48334,48334,50382,46221,48499,44439,27601,33905,52922,61210,59130,59097,50645,27368,38000,44307,37935,21096,27469,31759,27566,52790,38129,31791,50677,40209,42257,50611,46450,44305,50644,42224,42193,50578,35853,48531,48498,40112,50611,46418,42160,50644,46483,44370,46419,40145,44338,42193,37999,40015,37902,33611,27370,31531,31531,25290,46419,50810,44535,42161,29385,21097,52626,35756,29451,42094,29451,27370,29483,255},
{25718,34105,55067,36217,38362,34169,25751,46649,44570,42458,42587,34105,34105,34169,38297,38329,36217,34137,34105,32057,32057,32089,30009,19445,15252,13074,13041,13073,19315,19347,23508,17234,13040,15088,27602,12974,8781,8716,17134,27568,23407,17036,12843,17036,14988,12875,27568,23342,12712,14824,10632,10664,14793,14792,12745,12745,12777,12777,12778,12842,12843,14923,14955,17036,17101,19181,21262,21294,23375,25455,25455,25422,38165,36085,14924,12779,12811,12779,19085,27632,6500,2308,6471,21195,35888,27436,23275,27535,40114,40015,35920,29647,46386,40179,50776,55003,52890,40277,52857,50777,31695,40244,55003,52758,50446,52527,52527,52527,52527,52494,50414,50414,48334,48334,46253,46287,44536,27633,31793,54970,57050,59097,50679,59097,44272,29548,40114,42225,38032,42225,44338,46483,48563,52692,48563,44338,52692,40080,44338,50644,40144,48563,48531,42160,48531,46419,35853,48499,40048,35854,46387,31596,39983,37869,33708,33611,33676,31531,27338,33644,29385,27370,35756,27370,29483,33708,33708,27403,38261,48826,52889,37934,31530,27337,42126,37836,29515,48432,25257,29451,255},
{25718,36217,57147,36217,38394,34202,27799,48697,40410,42490,46747,36217,32056,34137,38330,36249,34169,34137,32057,32025,32057,32089,30009,17365,15252,13106,13041,15154,17267,17267,21428,15154,13040,13007,23409,15055,10829,8748,17102,19214,25488,19246,21328,23408,23440,23440,33906,31858,25487,27600,25487,25520,25520,27600,27633,27601,29681,29713,29649,29681,29648,27568,25423,25390,23277,19084,19019,16939,14826,12713,19084,31728,35987,38230,19150,12779,12811,12811,12844,17034,17098,33905,31694,33774,35855,33774,33774,31695,40146,40080,33807,29615,44306,40212,42260,44372,52923,42423,48663,52857,33808,33906,57083,48663,46254,46156,52495,52527,52527,52527,52560,52560,52560,52560,52528,48399,54970,38133,31826,44406,54969,50678,31760,52823,56983,42192,42193,44306,46386,35886,38032,42290,46483,50611,48564,44338,48564,48564,37999,48499,42225,33774,50580,31628,37902,39983,31595,33643,33643,31498,29417,33611,27337,27403,33611,27337,29483,33676,31563,33611,40014,37804,31595,35757,29515,46384,58964,46417,48628,57114,59197,48566,35724,25257,37804,37836,29450,29514,42159,27337,255},
{25719,40378,57180,38265,38394,34202,27831,46650,38329,40409,50875,38297,32056,34137,38298,36250,34137,34137,32057,32057,32025,32057,27929,17332,15252,13106,10993,15122,17267,19347,19380,15186,13040,19281,23409,15055,10829,10828,8747,17102,36052,33907,31761,31728,29616,29583,27503,25358,23277,21165,19084,16971,14859,14826,12746,10697,10665,12810,12778,10698,10730,10763,10795,12876,14956,17037,17069,19182,21295,23407,27568,33874,33907,38230,25521,10699,12811,12811,12779,12842,25518,48630,37967,37935,35855,33742,31662,29614,42194,48499,31694,29648,40113,40212,42325,44437,52890,48730,42358,54970,42325,40277,48664,46583,48498,42028,54672,54673,54673,54640,54640,52592,52592,52560,52527,50415,52660,48762,36052,31793,50743,44340,25486,46551,61177,37934,16968,35920,48499,42225,37999,42258,42323,44436,54871,42323,46485,46484,35952,38033,35789,31531,31498,31563,25257,29483,33643,27370,31563,31530,29450,31563,35788,31563,31563,33643,27369,44239,54706,40013,58964,58931,52690,48433,37901,44174,52626,61141,48725,52790,42195,35986,46420,31530,27305,50578,54770,44272,58997,54771,255},
{27831,44668,52987,36217,40507,36282,27831,44570,40410,40378,48860,36217,34137,34137,36249,36217,34137,34137,32057,32057,29977,32057,27864,15252,15252,13074,13041,13041,17267,19347,21460,17267,17266,25522,21361,15055,12942,10828,8715,17069,33907,21262,10730,10795,12875,12908,14989,17102,17134,19247,21359,23440,23472,25553,27633,27665,27665,31826,31826,33906,33906,35954,35954,35921,35888,33840,33776,31695,31695,31630,27502,31761,27535,40278,31892,12811,12779,12779,12779,19149,38197,50777,35920,31662,31662,29581,29614,29613,31695,42292,19114,33840,40146,40212,40211,42324,46551,55003,38165,52857,50777,48697,44439,44536,54904,44141,50414,54640,54640,54640,54640,52560,52560,50480,50480,48399,46352,55035,44439,31826,50711,42357,27600,48697,57017,54838,27465,27501,42226,44371,40178,42226,48598,59162,48565,25388,23340,25486,23404,19179,31694,29418,27337,31563,31530,29450,31564,33643,29450,46352,46286,35820,58964,52592,50545,44142,42061,54738,58931,58866,37901,54803,56948,44468,33774,23209,25420,52593,44272,35854,35921,31858,50810,40080,33642,44110,54804,56819,35854,54804,255},
{27831,50973,50908,36185,42587,36314,29879,46649,42554,40410,53020,34169,34137,36185,36217,36217,34137,34137,34137,32057,29977,30009,27896,17332,15252,13074,13073,15154,17266,17299,21428,17267,19314,23442,23474,15087,17135,10860,12940,25423,33906,38099,38131,40147,40146,40146,40114,40114,40081,40048,40048,40016,37935,37903,37902,35789,35757,35725,33644,33612,33611,31531,31499,29419,27371,27339,25291,25291,25291,23211,21163,19084,21164,33939,36118,14957,12747,12779,12779,12811,42359,52922,44339,35855,35887,35887,35855,35822,33774,42260,25453,31727,44307,40212,42259,42291,40212,52923,42358,46551,54938,52890,40245,50810,57083,46320,39981,50512,46287,48368,42094,46288,42258,46386,42258,46418,40145,50710,46617,36117,57017,46551,29680,33939,50809,61177,44305,23241,35953,46419,25419,19146,42390,59130,59064,29646,17000,19147,36049,34001,25421,35790,29450,33675,40111,40078,46385,35756,48399,56818,63124,52592,46287,61076,42093,29581,33709,38031,33806,56786,29482,33741,48335,35853,33676,33676,31531,29385,33644,27370,25323,33840,55036,46486,35757,23112,27436,54673,33611,33676,255},
{27831,53053,50940,38265,42588,36347,29912,46617,46714,38330,53021,34202,34137,38297,36217,36217,34137,34137,34137,32057,32057,30009,27896,17332,15252,13106,15154,17234,17234,17267,21460,17267,17234,23474,21361,15055,15054,10861,17037,23277,52594,65302,48335,37740,35692,35659,35659,33579,33579,33579,33579,31499,31499,31499,31467,31467,29418,29419,27371,27371,29418,29418,27370,27339,27339,25291,25291,25291,23243,23243,21131,14890,21229,33874,38198,21295,14956,17037,17005,19149,40146,46485,48598,37903,35855,35887,35855,35855,33774,38001,33905,21161,35953,42325,46550,48630,46518,48631,48729,40277,54970,50777,38165,55003,57083,44208,36017,48531,35822,44207,35822,42095,40015,40015,35822,35822,31597,31662,50810,55035,57017,46551,29681,29680,35987,57017,54903,23274,31727,44339,44370,40145,55035,57115,59096,48597,14953,14921,29679,31823,23404,31760,42094,50511,46287,46385,52821,42193,35788,29580,46385,52560,23274,46321,46222,25322,33644,33676,31530,33611,35756,29417,27370,33611,31628,31628,31531,29450,35821,37902,40014,46353,55002,52923,48598,35724,29385,29353,29385,25257,255},
{27831,53053,53020,38265,42652,38459,27864,44569,52922,38297,53053,36282,34137,38297,38297,36217,32057,34137,34137,32057,32057,32057,25784,15252,15252,15154,17234,19315,19315,17267,21428,19347,17234,23474,15087,12974,12941,12941,14956,23278,52562,65302,48303,33579,33579,33579,33579,33579,33579,33579,33579,31499,29451,29419,29451,29452,29452,29484,27437,27437,29484,29484,27437,27437,27437,25389,25357,23277,23245,21197,21164,19117,19085,19084,19052,16971,14891,12811,10698,29648,42161,42193,50711,40048,35822,33774,31662,31630,29582,31695,38099,14824,23244,33839,23305,19112,17000,25485,52922,40278,48664,50711,38165,55003,57116,42095,31564,31596,29484,27436,27404,23276,21164,21163,19083,19115,19115,21195,40180,59164,52759,48631,27568,25455,33938,52857,61177,50644,42161,38001,48597,35887,57116,61309,56985,59096,36050,25484,25485,33971,42484,29776,35822,31659,19081,25420,31725,31694,33676,31595,33611,39884,33643,29417,33611,33579,25224,31563,29483,25289,33676,31563,33708,37933,42127,46351,44142,42062,54706,58964,61044,46320,40146,55036,50712,33644,25224,25192,23112,23144,255},
{27863,53053,52988,36185,46812,40604,29912,44569,55034,36249,53020,36314,32057,36217,38298,36217,32056,34137,34137,34105,32057,32057,25783,15252,15252,13106,17202,17234,19315,19347,19380,19347,17234,21362,13007,15022,15022,17102,19117,27406,50449,65302,50416,35659,33611,33611,33579,33611,33579,33579,33579,31531,29483,31663,31760,25422,21132,21132,19051,19051,16971,16939,14858,14826,14826,12778,12746,10665,10633,10665,12746,12778,12778,12746,12778,12778,10698,10698,10666,33907,38001,27370,44405,40178,31694,31694,31694,31727,33774,33840,42357,17002,12808,14920,6564,8709,2404,12903,48663,44504,38099,46518,38133,55035,57050,39982,19082,21163,23275,23275,27468,29516,29548,33774,35887,37999,40145,42192,42323,54970,52825,46551,27568,27600,40245,52988,57050,59031,42192,38065,42259,46550,59261,61309,57148,57016,54936,27564,19113,29679,38162,29710,29647,35821,31595,31498,29450,29385,29450,33611,25224,27370,33611,25257,31595,35756,35788,42094,35756,42094,52625,56851,56818,54673,61076,56884,44370,33709,25192,27500,58965,37967,25421,38034,46453,27337,25224,23144,23144,23145,255},
{27831,50973,48828,34105,46813,42685,29944,46617,57114,38297,53053,38362,32089,36217,38298,34169,29976,34137,34137,34137,32057,32057,27896,17332,15252,13106,13041,15154,19315,19347,19380,19347,17234,23442,13007,17135,10861,19150,23278,27406,50449,65302,52529,35659,35691,33611,33579,33579,33611,33579,33579,31531,29484,31760,33906,23342,10633,10633,10633,12713,12746,12746,12746,10698,12746,12746,12746,10666,10633,10665,12778,12811,12843,12778,12811,12778,12778,12778,10698,38132,42227,33741,44372,46517,37967,37967,37968,37968,35823,35888,42292,27534,21162,17066,10823,12935,10823,8710,31854,48697,31760,35987,40278,57149,52824,37902,38065,42127,37934,42127,37967,44208,37967,46385,44371,46353,44273,44240,42031,44373,52858,48664,38100,29648,38067,38099,55003,61177,56918,50644,40179,46517,61341,59261,59263,54969,59097,35985,14953,21324,21292,14953,21292,37936,27305,23144,27402,27370,31563,35724,33675,44174,48400,52592,54705,56850,61011,54576,42063,37804,31497,46353,58866,21031,40112,58899,35984,33742,31563,27402,37837,37837,33611,33709,40016,25225,25224,23144,25193,23144,255},
{27864,50973,46748,34105,44700,46877,29977,46617,57114,38265,48860,38394,32089,36217,38298,34169,29976,34137,34169,34137,34137,32057,29977,17332,15252,13106,13041,13041,19315,19379,19380,19379,15153,19249,12975,12974,12974,17102,14957,14924,48336,65302,52593,35660,35691,33611,33611,33611,33579,33579,33579,31531,27404,29648,33906,27568,10665,10666,10665,12746,12746,12746,12746,12746,12746,12778,12746,12746,10665,10666,12778,12811,14923,12811,12811,12811,12811,12778,12778,40246,44406,40016,44339,48631,25356,18985,16873,12712,10599,10631,31695,33873,14824,23276,23437,29744,17064,12870,21290,50777,31826,36052,36020,52890,50678,37902,44339,44207,40047,42127,37967,40048,33775,29484,27404,40147,35953,33840,29550,31694,42358,48730,42358,29745,31826,31760,48730,57082,61177,46385,37968,44437,61308,54937,40181,48664,57016,52790,23274,21226,23372,21193,14887,25453,35790,46287,52625,54737,56753,54641,35756,48400,48368,61044,46189,29548,58964,37803,19082,33710,23144,27403,46255,35756,31595,37804,35756,33675,33675,33644,33579,33611,29418,27337,25225,25225,23144,23080,23144,23144,255},
{27831,48925,40507,32056,44668,48990,29977,44537,59195,36217,46780,38427,32089,34169,38298,34137,32024,34137,36217,34137,34137,32057,30009,19478,15252,13106,17202,15122,15154,19347,21428,21460,19346,19313,13007,12974,12941,19183,12941,10731,46223,65302,54706,35659,35692,33611,33611,33611,33579,33579,33579,31531,27404,29648,31826,29713,12746,12746,10665,12746,12746,12746,12778,12746,12778,12778,12778,12778,10666,10666,12778,12811,12843,12811,12779,12779,12779,10698,10730,40278,46584,35855,40081,48599,19148,4358,4390,4423,6503,8584,21163,33874,19115,23308,17034,36019,19145,17063,10758,25358,21295,31859,27633,38230,46386,38000,40212,31663,31695,31695,29646,31727,31662,27501,27501,33741,29548,33708,27435,35788,48632,48698,40212,44471,36052,29680,29713,52858,61210,44273,23241,46517,59162,48598,25455,38132,54937,59097,38065,17065,23372,27598,21291,21259,35888,39916,31432,29451,25290,14726,29582,33676,23339,42127,50415,25290,37869,39949,33643,33676,35724,35724,33643,35724,33643,31530,31531,31531,29418,29418,27273,23112,25192,25192,25192,23144,29483,31530,25321,44240,255}
};

const uint16_t Pittsburgh [320][181] = {
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57148,57116,57116,57116,57116,57116,57116,57116,55068,50843,50679,34100,29973,31988,46453,54904,61177,63290,59096,56854,54675,46354,40081,42193,42128,42064,44143,37935,17197,33806,50481,44274,48304,31630,46355,65077,58999,42291,44340,48566,29745,33808,27436,48532,63258,65436,65468,65468,65404,65436,65468,65436,65436,65436,65436,65436,65436,65403,65436,65436,65436,65468,65436,65436,65403,65403,65404,65403,65403,65403,65403,65371,65371,65371,65371,65371,65371,63290,63291,63291,63290,63258,61145,63225,56852,52492,43976,50022,41669,35461,43878,43910,37703,33741,46288,46190,50251,46089,37669,48134,48005,50150,45957,48069,48070,39816,33640,37767,41960,43976,43911,46025,58737,54771,42057,50379,42089,42090,42090,43944,52070,54245,48006,50053,45797,52071,52135,45894,52199,48071,35687,39784,39686,23045,33512,50316,37770,43946,54380,60948,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57149,57148,57148,57148,57149,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,55068,50843,42455,36149,38229,44470,50679,48598,48565,59097,56983,48500,50482,44274,40048,40080,42128,35888,35887,35887,19375,31791,44176,46419,46322,31662,33807,65143,56984,21391,17230,40211,35953,35920,42161,59065,61145,61178,50613,48500,56952,56887,44274,50547,52693,54740,58999,46289,46257,59032,54774,54806,48370,37903,44176,37935,56919,56854,35790,46257,56886,44144,35757,39918,37869,52660,48370,31564,42063,33709,37870,42095,46223,42095,31596,46289,54871,50415,39816,50087,50054,45926,31365,35525,44009,56984,56919,56952,54640,52458,39749,41829,45989,45990,48005,39749,48101,46124,46386,46090,56654,52395,37606,43913,60915,58900,44170,46218,42089,42057,46121,47814,47846,56294,54181,56294,47974,56263,54247,50054,52166,50151,37767,37703,39750,29252,25029,46025,54442,56491,58703,60981,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,55101,57149,57149,57149,57149,57149,57148,57149,57149,57149,57149,57148,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,55036,50843,42456,38261,40277,50614,46518,36116,40244,48565,44405,46419,40080,35920,42097,44241,31792,29679,33840,52758,54871,33937,27664,29745,27632,27664,29615,50483,46420,19278,21358,44372,33710,33677,23242,46517,61145,59032,46355,46354,56919,54839,44306,52693,54806,56886,61112,52693,52693,63226,61112,61145,58999,54838,56951,56919,63258,63258,56952,61145,63258,61145,61113,61177,61178,63290,63290,63258,63291,63323,65371,65371,65371,65403,65371,65404,65436,56720,39782,48269,54345,52230,35590,45991,39686,50547,54806,48500,52528,58799,52326,48134,41797,48005,49988,41668,35558,41898,46256,52332,60882,50381,43846,48009,60947,58933,44138,44170,42090,42058,48201,47846,39525,47846,43653,45894,52135,56263,56360,56327,54278,48039,41862,39848,43878,41765,31300,22980,52297,58603,58736,61013,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,55068,50843,40408,32085,32053,38230,44405,40244,56984,65305,56854,44274,46256,40048,44241,35953,25584,31791,38000,56951,63226,56919,56919,56951,56951,61112,42031,27370,29451,29451,35790,63226,40015,31629,40048,56985,61178,63323,63323,63291,65371,65371,63258,63226,63258,61177,59065,63258,63290,61178,61145,54839,56919,54806,56887,54774,56887,56887,56886,54774,61113,56886,52693,50515,50515,52660,50547,52725,50515,44241,50547,54708,46354,50548,59032,52628,56919,52659,41961,37738,58735,56554,48169,50249,46123,54806,59032,37967,37706,60914,50379,43974,35557,54374,58403,52036,41637,35626,41997,56525,60915,54738,39621,45928,60948,58966,46219,42057,40009,42090,48233,41766,47846,41637,41605,29286,33478,43814,54215,56295,52166,50183,50152,39751,45958,37637,35493,16707,35558,58668,60914,61013,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,55068,50843,38327,34134,40342,46518,44405,29875,54904,65241,54741,54708,48336,37968,42161,35920,29711,31726,42062,40015,44339,61080,65305,65337,65273,65273,46192,31499,31531,31531,37805,58967,52661,35855,21194,46452,59032,35790,39982,35789,52628,52661,33709,42095,50547,46257,35790,50515,52661,50580,52628,35789,44208,37903,44209,42096,46322,48434,48466,48434,54838,52660,48467,46354,48434,50612,52628,52725,54741,50548,54773,56886,54806,56919,61178,59032,61145,63258,54739,54739,63224,58799,48201,39750,42094,56952,54773,33708,29385,60948,52526,48101,41894,54405,58500,56356,52101,37704,37868,56557,60949,56819,41799,45993,58835,58998,50445,42057,40009,40010,44170,48072,43846,41864,31333,41670,39686,35751,37767,33510,41926,39880,44072,37671,29220,18819,10467,8419,29318,58603,60882,60981,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57149,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,50843,36215,27925,44437,56952,46517,40179,54839,61080,52726,40081,42096,31695,38000,46320,35951,35918,46222,39983,40114,56887,65273,65305,63224,65338,46257,31498,31563,31563,37837,54709,65338,42161,37968,56985,63226,63291,63291,63291,65371,65371,65371,65403,65403,65404,65404,65404,65403,65403,65403,65436,65436,65436,65436,65436,65436,65436,65436,65436,65404,65436,65436,65468,65468,65436,65469,65468,65469,65468,65468,65436,65436,65436,65436,65468,65436,65436,65436,65469,65370,58831,48136,33575,39948,52660,50316,48138,48108,58737,58769,58569,50250,60844,58632,52231,48072,39818,33643,52299,58900,58900,46024,41800,60981,61079,50445,40009,37929,40009,44105,44008,43976,31624,16804,20900,37574,35816,25447,14821,37831,37832,41992,31430,18723,18691,18755,8419,20964,54410,60914,58933,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,50843,42423,36213,44405,54872,52693,42258,34035,59000,35985,35887,42096,31760,42160,44272,40112,27566,33742,33775,38001,58999,65370,65337,65338,65370,46354,31498,31531,31531,35757,58967,63258,44306,23242,48533,63258,65501,65469,65468,65436,65436,65436,65436,65436,65436,65436,65436,65404,65404,65403,65403,65403,65403,65371,65371,65371,65371,65371,65339,65371,65338,63290,63258,63226,63258,63225,65371,63258,59065,61145,63225,63258,63258,63258,61112,61145,63323,63323,56952,61079,58732,39814,21096,25289,29417,35656,41928,48335,60947,58867,58834,54608,60915,60947,48172,41867,33643,29483,54476,58900,58999,44174,41932,56820,54805,44205,40009,37961,39977,44105,29447,25319,23239,4323,4323,14821,31656,31656,16837,46185,50377,37637,29059,20739,31075,27011,8418,16772,52298,60915,61112,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,48794,44503,46518,42357,40309,44405,48500,33969,38098,23503,42128,35888,35920,44240,46288,44143,35855,33775,21325,46485,65371,65338,65337,65338,65370,46289,29418,31531,33579,35724,63225,61145,40048,37903,56952,59065,44306,50483,44209,54773,56886,48434,50482,52660,50515,54806,50515,54741,50580,52660,31596,41998,31564,39918,31531,52595,54774,44143,44078,52628,48336,39983,35659,33546,39950,37772,54740,42063,23144,39885,44143,48434,52596,48435,44111,44207,56919,59097,33611,52595,50511,31527,19014,23241,25354,27433,33609,44143,60947,58900,58867,56754,60947,58966,48238,41899,33644,25322,54541,60980,61047,41963,41932,58934,40112,33705,40041,37961,42025,44137,21094,8516,14789,6371,12709,16869,21093,31559,12676,23077,45797,29027,31043,26947,26947,26979,12579,16836,54476,60948,61112,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57051,46551,44438,40309,48630,50646,52726,44307,29744,33872,38001,31760,40048,40080,42063,37902,35854,35887,17197,10989,54806,65273,65305,63192,65273,48435,42030,44143,46256,44144,52726,52726,40081,19017,38001,59065,25257,35626,25192,46191,48401,29450,35691,42062,41965,44241,44078,46321,42095,44241,21031,35594,23112,35626,21031,48336,52628,37804,39819,46353,41965,23144,35626,33545,37804,35658,50547,41997,23112,37772,44110,48369,52596,48402,48239,44208,56951,61178,39950,50548,35852,27399,23207,25289,25288,14821,12644,29384,62962,56755,58834,58801,60915,58900,50351,41899,35724,25290,52429,61013,61079,41930,46124,61046,54805,46318,40009,40009,42057,44169,21062,6436,8516,8516,23174,18949,23141,27398,25189,31140,39300,28995,31075,35203,37284,33187,16739,20998,56655,58932,58933,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,61211,44471,32021,38294,48630,52726,50548,52791,44339,42128,38000,38000,40112,37968,35822,29614,29646,35887,25518,8940,46453,65241,63225,63192,63225,61113,61112,63193,61145,56952,46452,40212,38000,29548,50645,59032,31629,39885,33709,46256,50515,35789,42030,46320,46223,48435,46289,50548,44274,48467,33709,44110,37935,44143,35822,52596,54774,46321,46321,52661,50514,42193,48402,48434,48467,50547,52725,52660,48467,50580,52660,56886,56919,56886,56854,56919,61145,61145,56887,44272,21094,23174,23174,23239,21127,14789,25157,39849,60947,58966,60881,58801,60947,58900,50416,41931,35724,23242,50317,63061,61079,50447,52462,54773,61047,54738,37929,31624,33639,33607,12644,6403,6403,8451,19014,21093,27269,29381,43878,47620,37220,33155,33220,37316,31107,35267,20899,29384,60882,56787,56788,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,59131,46551,34102,32053,48598,42357,50678,52726,25616,37968,44177,48336,33807,31726,39982,35855,37903,44175,31694,19277,23470,31759,59065,52791,42324,36084,36083,36051,27697,23569,29712,38099,40049,56919,63291,59097,61177,61145,61177,59097,59065,61145,61145,59097,59097,61113,61145,61145,61145,59097,61178,61177,61177,61178,61178,61177,61145,61145,61145,61145,59097,61145,61145,61145,59065,59064,59064,61112,61145,59097,59097,59065,59065,61145,61177,65306,63225,61145,56919,33673,21094,23239,27464,21159,21159,21094,33510,29415,58900,58999,54576,52496,62995,60981,52561,44044,35756,23210,46190,63126,61079,58900,58900,42128,56821,50447,33639,23044,25124,20996,8483,8451,6403,6403,4291,29253,50052,33379,39620,45604,39364,37316,37316,35268,33220,35300,35589,39848,58737,58901,56690,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,59163,44471,36181,38261,44405,25812,40244,40114,17327,35888,42064,37967,27598,31759,33807,39983,39982,44175,27566,19277,13068,23406,50645,56952,44405,33970,19310,6763,6763,4715,15052,35986,48467,63291,59097,61210,61178,61178,61145,61145,61145,61145,61145,61145,59097,59097,59065,61145,61113,61145,61112,59065,59065,59065,59065,59065,59065,59032,59032,61080,59032,59032,59064,59032,56984,56984,56984,59032,61080,61080,59032,59032,59032,61145,63258,63258,63225,56853,50481,35753,25318,27399,29512,23239,16902,25254,23109,16870,58834,61079,46223,46223,60980,60948,54642,46125,39885,25322,42095,63159,61046,61046,54772,29516,56787,46024,31397,31364,33412,25124,16804,12644,8483,6371,18819,49988,56292,50117,50213,54117,45604,45668,39460,41765,41797,29124,23076,46089,58801,56820,54609,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,52955,40342,40342,42422,42390,29940,44372,31824,27664,42097,40016,35887,31759,31759,35855,44143,42127,37999,31726,25518,17229,33839,48500,61145,63226,48565,19212,15084,33938,40244,23438,42194,54839,61145,61145,63226,61177,61145,59097,59097,59097,61145,61145,61145,61145,61145,59064,59065,59065,59065,61112,61144,61112,61113,61112,59064,59065,57017,59065,59064,61080,61112,61112,61080,61112,61145,59097,59065,59065,61112,61112,61112,63225,63225,61112,61112,58999,60948,58802,39978,27367,21094,21126,31624,16933,16901,12741,16902,56754,58867,39982,44208,60980,58900,56723,46157,41997,27435,37934,63159,61046,61046,56820,31433,37803,33413,25124,20932,33412,31333,18884,14756,6371,6371,45828,58340,48004,45989,54405,58598,52132,52132,46021,46053,41861,33606,12579,45993,60915,54740,56787,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57148,50875,40343,40310,42390,40309,27892,36083,27696,33872,37969,31792,35919,25519,33775,40015,29614,35855,27598,33807,25485,17197,40146,52693,61145,61145,56984,52791,46452,59065,65534,50646,48533,59065,59032,61145,59032,59065,56919,59064,56952,56984,54872,56952,56887,56919,54839,56952,54806,54871,52759,54871,54806,56886,52693,54806,52726,52726,50645,52726,50645,52693,50612,50481,37901,33708,29515,27435,29548,31628,31595,23209,21129,21129,21129,19049,35789,52430,46124,31367,35720,23238,21126,23207,21094,12676,18981,19014,27434,58899,56788,42161,46289,60947,60981,56788,48237,42030,25355,33676,63159,61014,61079,52462,22915,10467,22947,22980,12579,25092,20932,10531,6371,8451,18884,54245,56324,54276,50181,52261,56551,50246,43941,46053,46053,43941,33575,29483,52496,58966,56918,56821,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57148,50843,40342,40310,48598,46453,38164,31890,29712,38000,35920,35920,35920,31759,29646,40047,31694,35886,31726,39982,39950,13004,8844,46452,61178,59097,61178,54839,33742,50613,59098,35921,42259,56985,44339,54839,44339,50646,23307,50645,42194,52726,38033,48565,38033,48565,38001,48565,38033,48533,40081,48533,40113,46452,38001,44372,42226,44339,38033,44339,42193,44306,40080,46253,29446,25254,19013,12677,10596,14789,10596,6404,8517,10597,14757,16805,29319,37671,29350,25125,35719,29511,31592,25319,29512,25319,21158,25352,35753,58834,54740,54642,52562,58801,58867,56788,48238,42062,21162,27370,63158,61046,56787,41767,20867,20899,31300,31300,14659,16804,14756,14724,14692,12644,18852,50020,60548,54276,54341,54245,50214,41926,43973,48198,39813,39813,33573,27173,58768,58900,59032,54675,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,55003,36214,42422,44438,48533,48468,29744,31760,40081,33872,40048,35887,37935,29614,35887,37902,40014,44175,39949,31661,15117,10924,48500,59130,59097,59065,56952,50711,56952,52791,17165,40179,54937,42227,52759,40146,50678,38098,48598,40146,50678,38065,50646,40146,48533,42226,50646,46452,52726,44307,50678,46452,48565,44339,48533,46387,48532,46419,50613,48500,48565,46387,50480,37799,29414,23174,23174,16902,16902,8484,8485,10630,18984,33511,31366,29286,31366,31430,25125,33639,33704,35818,27399,33705,25351,23206,16933,25287,56753,54740,58769,58899,58769,58867,56820,46222,42030,14823,23177,63126,61014,46025,27107,20867,33380,25060,31333,27173,14724,29317,31397,20964,23076,20964,50020,62724,56388,60581,58437,45989,39846,39846,50342,48198,41958,33541,25061,58769,58932,61079,63126,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57148,57149,57148,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,55003,38295,38294,44406,42292,46387,31792,44209,40081,33872,35920,27599,33774,37967,29646,29614,29646,33742,27501,33807,21357,6763,38098,59130,59065,59098,56952,44307,56952,54872,10793,40179,59065,46420,52759,44340,52791,50613,52791,46420,52726,40113,48565,44372,50613,42194,50678,44274,52758,40113,50613,40113,48532,40113,48532,42226,46419,42193,50613,42194,48532,42194,50513,37800,23174,25287,21094,16902,8549,6436,6436,8517,6436,23110,33510,29286,33414,31398,23045,31494,35785,39978,29511,29577,27431,23142,14789,14789,52495,56853,56721,60948,58833,58867,56820,46222,35789,6436,21064,63126,56721,41831,25124,22947,31300,27140,23012,25124,29317,31364,31397,25124,29285,27237,35524,62724,60548,58436,62693,52261,41926,39878,41958,44038,39813,14691,27174,60915,58932,58933,63126,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,52955,36214,30006,40277,46354,52595,40113,44241,38000,35920,35920,29711,25518,31694,33807,29646,21325,33742,25454,27533,25486,4715,33905,61145,59065,59097,54840,42161,61178,65469,40146,44340,54905,35953,50646,38001,50678,42226,50646,40081,50678,37968,50678,40244,50678,38033,52726,38032,52694,38000,50646,40113,48565,40114,50678,44372,48532,40145,52726,46452,48532,42226,50612,37866,21062,21094,16901,6436,6436,6404,6436,6436,8517,8549,27238,33478,33478,33478,31397,35623,21095,39979,35817,29544,29479,16869,18949,12676,48367,63093,58835,60948,58802,58834,56820,46223,25290,4291,16871,61046,56688,41765,25092,33412,27140,31300,29220,29284,37605,29284,25157,23044,27237,31429,27237,52261,64836,60676,58532,58597,54438,48231,39878,33573,35686,18819,37672,60980,58933,58900,63126,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,52955,40407,32086,44405,36018,46354,42193,42193,35952,31760,33839,25486,31694,40015,29646,23438,25486,27534,10924,10924,10924,13036,40179,61145,61113,61145,59097,61177,61178,65436,59065,48533,54904,50678,52791,52791,54871,52759,52791,50678,54839,54871,54904,52791,54871,56952,56952,54871,56920,56952,56952,56984,56951,54871,56919,56952,56952,56919,56951,56951,56951,56952,56951,37932,23174,25255,23176,14790,19049,23209,8517,6404,8517,10630,6404,27336,29318,25190,23109,29383,14790,31595,52593,27366,18981,18949,23142,14757,44077,65238,60946,60948,58834,60882,58901,46223,16870,4291,12678,56852,56525,41700,35460,41668,37540,29220,33380,33380,41733,29252,23012,25156,27205,31429,29349,29317,50149,64805,62757,56486,56615,48166,41958,35686,35718,43910,56525,61013,58933,58835,63093,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,55101,57149,57149,57149,57149,57149,57149,57149,57149,57148,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,55035,48728,34133,40277,27794,46386,46321,33840,40081,29679,29679,29647,37967,33807,27566,23405,27533,35854,15116,4715,17164,35887,48533,61145,61145,61145,61177,63225,61177,63225,59065,56920,59065,59097,59097,61178,59097,61177,61145,61177,59097,61178,59065,61145,59065,61177,59065,61177,56984,61145,59097,59097,56984,59097,56952,59064,54839,59064,56952,59032,56951,59064,44272,29447,31593,21128,31661,29516,31629,39950,10597,6436,6436,10630,8517,16936,18950,18982,16901,16838,16968,31661,46190,37768,27302,18949,27367,16837,35723,65207,60980,60947,58867,58801,56820,42062,10564,4291,10597,54577,54216,39588,29155,33380,45893,39588,35428,39621,39685,37637,35589,29284,31365,29317,27204,31397,33509,43877,50182,56486,58663,50343,39878,41958,35686,50216,60849,56755,58933,58868,63126,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57148,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,52955,42488,40309,38229,25746,40178,42160,29647,46224,33807,29711,21390,35887,33807,33774,29614,33774,27533,23373,8844,23372,19212,42292,52758,56919,61178,61178,61178,61178,61145,59033,61178,54872,54839,59065,54872,54871,54871,54872,56952,56984,61146,54871,56984,52726,59065,48565,59065,50613,59065,54904,59065,48532,56952,46452,56952,50580,54871,48500,52726,46419,52725,31527,23174,21095,12709,14790,14822,23242,27370,10597,6436,6404,14789,16901,18982,21126,25319,21127,16934,12775,23275,39786,39914,25222,16869,23110,19014,35690,63159,60980,60947,60884,48141,54675,37901,6371,4291,8484,50449,54281,41701,37541,33413,35460,35428,33413,37573,37605,35557,31429,27269,29317,29349,29317,37670,33574,21028,23141,37637,41862,41927,41991,35590,33444,48104,52527,35691,58868,61013,65240,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,55101,57149,57149,57149,57149,57149,57148,57148,57148,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,55036,46649,40342,34068,36083,35985,29711,31792,38000,31791,25550,27631,44176,35854,35854,31662,19213,25453,23373,25421,27533,21325,17164,17131,52593,61178,59098,59097,59097,59097,57017,59097,54904,54839,59065,56952,54872,54871,52759,54871,52759,56984,54871,56984,50646,56952,48533,59065,54839,59097,52759,56952,50613,56984,44307,54839,46387,52758,46387,50646,42226,52693,33640,25287,21094,12709,16935,10629,8516,10629,8484,6404,16869,27334,21061,21094,19014,25286,19014,21094,16903,29484,39819,46221,31527,31497,27270,25287,37803,63159,61046,60947,60821,58641,60981,33709,4258,4291,6404,43979,47942,37508,27107,27140,20867,37508,25028,35493,39749,31461,29349,23109,16804,27237,27269,27269,29414,25221,21029,21028,29381,33574,25189,35622,48102,52361,35785,25223,56820,58901,65239,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,55036,44568,30005,31923,33937,29744,29712,31792,38032,31791,29711,37967,42095,35823,37934,29581,15084,10956,21260,50254,39982,37934,19245,8843,35886,59032,56952,56952,54839,56952,56952,57017,52791,48533,56984,52824,52726,50646,50678,52758,48533,52758,50678,56952,48533,54839,48533,56984,56984,56984,46517,54871,48500,54871,44339,54839,46387,54871,48500,52726,46419,52725,35720,23142,16902,12709,10597,12710,12710,12710,8517,6404,23142,31527,25318,21094,21094,19014,23174,23142,20965,23079,41834,50512,35686,39980,33643,35755,40014,63159,61079,60884,60821,60785,61013,29548,4258,4291,6404,41900,50055,35460,33348,35396,29188,43781,37509,33413,35525,33542,29381,27301,29381,33509,27301,18948,16836,14756,16868,18981,29446,37798,33573,41861,52262,50281,33672,25222,58934,61047,65239,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57116,57148,57116,57116,57116,57116,57116,57116,57116,57116,55036,52825,40277,36018,42193,33840,31793,31792,35920,31759,29711,31727,31695,35822,33742,31661,23373,13004,27469,37870,44174,39982,27598,19342,21325,46386,48369,48468,29777,52791,56985,56985,54872,50678,56985,54872,56985,56985,59065,59065,56984,59065,56952,59065,56952,59097,56952,61145,59098,61145,54871,59065,54871,59097,52759,59064,52726,56984,52726,54903,50646,52692,31527,27367,21095,16968,8516,8549,16936,14823,8516,6404,14757,29414,27334,25286,25318,23174,21094,23142,39719,23079,41737,54739,44138,37866,33575,29350,35721,63093,63095,60886,62966,60817,60980,29548,2210,4291,10597,54675,54281,41700,39620,43781,25060,37476,43748,27172,27172,25156,21028,25157,33477,29381,21061,21029,18948,16868,18949,23109,31526,37735,35787,37737,52395,44073,27398,31495,58901,61046,65206,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,55036,54873,54709,42226,42193,38033,33840,35952,29711,37999,42128,29647,31727,37870,31662,29581,25421,13004,19212,17164,21292,29613,19244,10988,17164,46320,46288,44372,13330,46615,61146,59065,52791,46452,52791,48533,54904,50711,52759,50646,52759,54839,48533,52726,50646,54839,46420,54839,48598,56952,44274,54871,48435,54839,40113,52758,40080,54839,44306,52758,42194,46385,23174,25254,14790,10597,8549,8517,14823,10629,8517,6437,6404,12676,27334,31558,27398,25318,25318,25287,37768,27304,41834,56852,44203,33607,33607,27302,31528,63061,58902,60951,62966,58801,60980,31661,2210,4291,8484,31530,43717,43716,35492,39620,22980,24995,41668,37573,33413,25221,18981,18916,23044,29349,23141,27333,21061,23109,16804,16804,27269,31462,23144,35689,50447,37899,23205,35624,61080,61046,65206,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,55036,50777,48533,33938,38033,40049,40015,46287,23438,31726,42160,33839,37903,39918,35822,37934,35854,29646,23405,13036,23405,37998,31758,21357,15084,35920,50514,48565,38261,57018,59098,56985,50711,42227,52791,46452,52791,48533,50678,48565,50678,52726,50613,50678,48597,52791,50613,54839,46452,54839,46485,56952,46387,54839,42194,52791,40113,52758,44274,54871,42193,46353,23174,12677,8484,8517,10662,8516,8517,6404,6436,6436,6404,4324,8516,23109,25254,29479,39913,29448,21030,46156,37641,54772,46283,35751,35654,27334,31560,50547,50549,62999,60918,58867,60947,37935,4258,18820,23045,25060,39556,39588,39620,45861,31333,29220,39620,39621,27140,27269,20996,23141,18948,27237,21028,31494,25221,18949,12612,8451,14659,23077,8418,33541,54606,35818,29543,39915,61013,63094,65238,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57148,57116,57116,57116,57116,57116,57116,57116,55036,48697,38132,27729,35921,35888,50480,40014,27598,33807,35920,29679,44078,44110,44111,37902,33774,39982,29614,19212,17132,29613,25453,29646,29613,27533,52693,56952,65404,61178,59065,56952,50711,42194,54904,44405,48598,46420,50678,48533,52759,50678,50646,52726,48565,54839,52759,54871,46452,54871,50678,56952,46419,56919,44307,56919,44339,54839,46419,54839,40047,37867,14821,8516,8549,8549,10630,10629,12710,10630,8517,6437,6436,6404,6436,6404,10565,23175,56655,52462,44012,37870,21065,50546,46283,42024,44039,29381,25354,31891,56888,63031,60918,58867,60980,40048,22980,33381,31333,33380,41766,43846,45893,50053,45861,39653,41701,39621,29220,25189,29381,29381,29381,33542,31494,27333,23141,18916,10531,10564,14724,25157,12611,35558,54574,29579,29514,48433,56919,63126,65206,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57148,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57148,57148,57148,57116,57116,57116,57116,57116,57116,55068,44569,44307,48337,33840,35888,54607,46287,31727,29646,27598,17165,33774,37934,35854,40047,31694,37902,27501,8843,4683,15116,23372,29613,29581,23373,50580,65403,61210,59098,56985,54904,54904,50646,56985,52791,56952,54871,56952,54871,56984,56984,56984,56984,57017,59065,56952,59065,54839,56984,54839,56984,52758,56952,50646,56984,50613,56952,50613,56952,40045,29447,10597,14855,8549,10629,8549,21129,19017,16936,8517,16969,12775,6436,8484,8516,6436,16838,52495,65172,56690,27534,10630,27499,46283,42122,41992,39980,38065,50646,61113,61015,61047,58933,58965,50547,37638,33413,33445,33348,45991,37735,35623,35460,39653,37638,39653,35428,39653,33413,37701,35622,31461,31461,29381,27333,25221,18917,12644,10564,10531,20996,14659,31332,50281,25318,21093,46255,59032,63094,65206,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57148,57116,57116,57116,57116,57116,57116,57116,55068,42456,38066,44209,33840,25519,46223,42062,29646,35920,25518,8876,15116,13004,12971,31661,37869,42095,23373,6795,8876,29678,40014,40014,37967,27533,46452,65404,59130,59098,56952,54904,54872,44307,54839,44307,52791,46452,50678,46452,50678,48532,50678,50613,50678,52726,46420,50646,44307,52726,42226,52726,42194,50646,38001,54839,40081,52726,40081,50678,37899,14821,6436,8549,8517,8517,8549,10597,8485,8485,8517,10662,8517,6404,6436,8484,10597,18919,46093,65172,56657,31629,14758,33805,46315,42154,41927,37703,35688,58834,61078,60849,61046,58933,58867,56721,43878,35590,39718,52133,52070,43879,33607,23077,21029,23174,33477,33380,27140,35492,27172,23076,33542,27333,27301,31461,31462,23109,20997,12612,8419,18884,29252,39718,46121,27398,25286,52529,56919,63094,65174,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57083,40245,38034,35921,33840,27631,27567,29614,29678,31726,25453,25421,19212,10924,15084,33741,29548,31693,15052,6763,6763,15051,44109,48205,42062,39981,46387,63324,59098,59098,56952,54872,54872,42226,54872,44307,54871,44340,52759,46420,52726,46452,48565,46452,48532,50613,46485,50678,44307,50646,44307,52726,42194,52726,40113,50646,40145,52758,40113,54871,35819,10629,8516,8549,8485,8517,6436,6437,8484,8484,8517,6404,4324,6404,8516,10597,14790,18951,31465,50217,39784,25127,27338,31760,46316,40074,44072,41862,33542,56753,63126,60848,61013,56886,56753,48169,29284,41926,41829,50118,47975,43976,33575,27237,18917,16804,14724,18852,16836,16836,14724,10563,20996,31494,31494,31461,33574,31494,27334,14724,6403,10563,31429,31333,35591,27431,23142,50417,52595,65174,65206,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,52890,40115,42161,40048,29712,33808,31727,31726,33807,35822,29549,33612,39918,19212,25453,44110,29581,23308,23340,8843,4651,23372,44142,35789,33741,25387,42227,61243,59098,59098,56952,54872,54872,40113,50711,42259,52791,44339,54871,46419,54839,46452,48565,46452,48565,50613,50678,52759,46419,50646,46420,52758,44307,52791,44306,52726,44339,56984,46387,56952,35818,12677,8516,8517,6436,8484,8517,8517,8484,12710,10597,12743,21129,16902,21062,19014,19014,19014,25222,37638,31365,37381,29353,21326,46350,42189,42189,42059,37835,56754,63126,60848,48334,25256,31496,43943,29285,27236,39717,43813,50087,43976,31462,25189,14788,16836,14724,18916,29381,29382,29381,21029,14724,20996,29382,31429,25221,23109,27302,12612,6371,4258,12611,20900,23110,33736,16869,33611,58900,65174,65206,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57148,57116,57116,57116,57116,57116,57148,52890,40147,44209,40048,25551,31727,29679,33840,35854,37934,33709,31597,39885,29516,23373,37902,31661,39917,29581,6795,4683,10924,17132,15084,21357,10956,36050,61210,57017,59065,59098,54872,54904,48566,54904,54839,56984,54839,56984,54839,56952,54872,54871,54839,56952,56952,56952,56952,54871,54871,54871,54839,54839,54839,54806,50613,48532,48500,46420,46419,39946,16902,10597,8484,6436,8517,8549,10597,10629,12710,12678,12743,19015,33608,29447,27335,19014,21126,43976,43943,35590,39590,31630,17296,40078,40075,40042,42057,46087,56655,63127,58767,33639,21061,23174,33478,37638,31365,37669,50181,46054,46119,39848,31462,16836,12644,14724,21029,20996,14724,16836,25189,20997,16804,18917,23109,27302,23141,23109,12676,10564,10531,16804,27206,27303,31591,31527,29450,58901,65239,65206,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57148,52824,42194,37968,33808,25519,33808,29679,27566,17197,23437,35854,43981,44013,46060,46223,44142,39982,37870,25485,13004,8844,6763,4650,19244,31758,23437,48630,59098,54872,50646,59033,61145,59032,61145,59064,59000,56886,50613,52758,61177,58966,44241,56886,59032,56919,63225,61210,59000,50417,54806,61145,48500,61178,59032,44307,10695,10728,8648,8615,14791,37704,21062,8516,8516,8484,8484,6436,6436,10629,10597,10597,6436,19015,37801,33607,31527,29447,27368,39947,50348,44075,41996,48435,52693,48465,42189,42156,44205,44204,54639,63127,54574,31558,23206,31527,39784,39751,39750,35654,41958,41925,48166,37767,23109,21029,18917,8483,21028,33574,23141,12644,16804,25157,14724,14756,10564,8483,8483,14756,12644,29483,31528,29383,23143,23175,25221,31463,44110,56755,65239,65174,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,57148,48598,42161,37968,31792,27632,33807,29614,33774,15149,21357,29677,25420,44077,50350,52527,52495,37901,33742,25453,17132,8844,4715,4682,29711,50645,54871,61178,61211,61211,63324,65404,65404,52726,63258,65403,65403,65338,40472,42585,63193,65174,58900,63193,61177,58967,65305,63323,61113,46191,54805,63258,44307,65371,44372,12906,6470,6535,6600,6535,20998,39847,23174,8548,8517,8484,6436,6436,6404,8516,8484,6436,6404,8484,14789,29447,31527,29447,25351,25352,39945,41960,23176,37706,58835,48430,40074,40010,42090,40010,50478,63126,42027,31559,27366,31559,37736,39783,37671,37766,46117,37701,45861,39686,25157,27301,16804,6403,10531,25189,29381,27269,27237,21029,14756,12644,8483,8451,8451,8483,8451,18917,25189,25189,25093,27140,29285,37640,54609,58868,65206,65174,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57148,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,46453,35920,33840,29712,31760,27599,31695,37935,25486,33806,40078,38030,40078,44207,52561,44240,23340,19212,10891,6763,6763,4683,10891,48565,54839,56984,63291,63324,65437,65469,65404,65403,52725,63257,65403,65403,65403,55002,52987,65305,63126,52562,56919,56952,61145,65305,63291,61145,56821,56788,61178,38000,44372,10859,6665,6470,6535,6665,6535,25190,41895,23142,8516,8516,8484,8484,6436,8484,8484,8516,8517,14823,10565,8516,10564,16869,21094,21126,16902,27431,33770,19049,27173,52594,50511,40042,37994,44202,40009,50445,54674,52493,42057,35783,31559,33576,37639,39719,39814,46149,56421,43748,31332,20964,23109,25221,23109,16836,21029,29349,35590,31430,21029,16804,14756,14756,10564,8483,8483,8451,14756,18917,27270,31462,31365,35590,44075,58803,63094,65174,65206,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,46387,42128,29712,27631,40016,35823,37935,33774,31726,29645,29645,42158,42093,44240,52627,39983,33709,17100,10891,8843,6731,4682,29744,54871,54871,59065,65404,65437,65437,65437,65404,65403,61178,65371,65403,65371,48598,44535,34069,54806,65174,50514,31629,46387,63258,65305,63291,61178,56853,48336,61145,40114,13004,8746,8778,8615,6600,6600,6568,16838,37670,23142,8484,8484,6436,8484,10596,10597,6436,6404,6436,23209,12709,8484,4356,6404,14757,16901,14821,21126,31689,29483,29385,50515,52591,40074,40074,48331,44170,46284,29450,54608,56719,46218,33703,33608,37705,41863,39781,46053,62726,45893,25156,25189,27237,23109,25253,29382,33542,33541,35590,33510,27270,18949,23110,23110,14757,8451,8451,6371,12612,14724,23077,31430,25189,33574,48172,56788,61013,65173,65206,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,46387,42128,33840,27631,25551,27566,23438,19309,35918,35854,25453,27532,48334,50546,50515,48271,31597,23276,33709,19244,8843,17197,46420,56952,63291,65469,65469,65469,65469,65469,65436,65403,65404,65403,65403,40276,13134,23471,35985,52693,63126,61013,54740,58999,63258,65272,63291,63258,54740,46256,48533,14889,8843,8810,8778,6470,8583,6502,8615,6437,23045,39815,14789,10629,10597,6436,8484,10597,6436,6404,6404,8516,8484,6404,16805,20997,23077,21062,19014,21126,25287,33707,29450,44241,52656,42154,40074,48330,44170,42124,23242,50447,62994,56786,33671,31559,33640,37768,41895,41830,58567,43877,23109,25221,23077,14692,25221,23109,25124,31429,37670,31430,27270,25190,25190,25190,16869,10596,8483,8451,8483,12676,18949,29382,23109,41995,50385,56919,63093,65173,65174,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,54971,40146,37968,35888,27632,23471,37935,23438,21390,37934,42094,29645,27598,35854,21358,29581,42030,25453,29581,25389,17164,10924,8811,25453,40047,52660,56855,50581,48533,54839,60885,63063,65404,65404,65371,44405,21488,38164,50711,65239,58901,63126,50417,56886,59000,59032,65304,61178,50646,58966,46321,19245,8680,10956,8811,8810,6502,8615,6535,8615,6436,12677,39783,27367,12709,10597,6436,8484,8516,6436,6404,6404,6404,6404,14725,39622,35525,29350,23142,19046,27367,31494,44043,33611,37903,56818,46283,42154,42090,44237,54772,48466,54642,60913,58965,48365,44138,42059,27335,31398,33479,37703,33574,33542,33509,27269,21029,23076,27269,25189,29317,33509,33510,29382,23109,25125,21029,16836,16837,18917,21029,12644,14756,23109,27301,16836,25222,52497,58934,63126,65206,63092,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57148,57116,57116,57116,57116,57148,50777,40146,38001,31760,23504,23471,31694,23470,15149,17197,31694,35854,44208,35822,15052,27500,44078,35822,29614,23373,23373,8811,4715,15084,31660,39884,46093,44274,40113,52726,60851,60852,61145,65404,63258,38066,17035,61178,65371,63061,58834,60948,58868,61080,56919,56821,65240,36018,15117,37967,42096,15116,10858,13036,10826,10924,10858,8778,8778,8582,6436,12645,35623,31527,12709,12709,10597,8484,10597,8484,6436,6436,6436,6436,12677,29286,37638,33542,25254,25189,35526,39687,45993,33643,33709,58898,48363,44235,46350,52692,44205,60980,60980,60880,61046,58965,58833,56820,29450,8451,18885,31430,39621,50021,39750,31429,27237,23109,25221,25189,31461,33509,35590,29382,25061,27076,27173,29253,23077,16804,14724,12644,12644,18949,27302,25189,35590,56787,58966,63126,65206,63060,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,55036,48467,42161,38000,29744,29680,31630,25518,13101,11053,13069,6795,29549,39950,46061,46189,33708,44013,37870,29582,23341,19212,6731,6763,8811,23340,25452,35788,44111,42226,50645,56919,56886,54839,65372,63258,44307,38033,61210,65371,58967,52466,50352,45996,50254,59000,48369,35854,13101,10988,21195,27534,15117,10825,13004,10891,13036,10923,10891,8778,8517,8549,8517,31463,39816,25287,23174,19014,10597,12709,6436,6436,6436,6436,8517,10662,10597,16805,23078,21030,31366,41670,41638,39525,20966,37870,58899,48363,52590,52659,40043,40042,60979,61012,60880,61013,61079,58899,58868,44110,10565,22883,37637,45861,58342,39718,33541,31397,23044,23044,27205,35590,35590,29349,27270,31301,33220,27173,29350,27238,27237,27270,18917,12612,12709,29479,25189,43944,58802,58933,65173,65174,63027,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,54970,46322,38000,38000,31792,33775,33743,33807,19277,13101,21390,23405,37837,37869,35756,35821,27468,48173,37773,31597,27500,15084,6763,4683,8811,27500,27532,41997,41996,27501,48532,52661,54773,59065,56952,61210,46387,42194,61178,61178,61210,63323,59065,60721,64718,52661,35789,21227,11053,10988,23373,27632,15149,10891,13036,8810,10924,10891,8810,8778,8550,8516,6436,10564,31462,35687,31526,27366,23174,10596,4323,4323,4323,4291,4324,8516,8484,6404,8549,8516,27077,37413,35301,33252,31433,48401,58931,52524,52557,44204,40009,40010,58899,61045,60881,61013,56886,58932,58868,48303,33546,53861,39685,33509,45861,41701,41733,29381,27237,25092,18884,35557,37670,31462,27302,33478,31366,23110,27238,37639,31398,25190,25222,18949,21095,37933,31562,48205,56853,58933,65173,65206,62995,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57148,52857,40081,31792,35921,33872,23438,29647,39983,23438,8908,23438,29614,23340,27501,23373,10923,25453,46190,48076,44045,33709,29484,17099,6763,6731,4650,33676,50317,44044,25388,27469,40081,37935,54872,54937,61145,40081,40114,61178,61210,61178,59097,59065,60754,58804,63290,52660,27468,17197,17131,23373,33807,33807,25420,27533,21259,19147,21162,21162,23275,23242,25257,25289,25289,33642,46155,42028,44173,44173,33675,31595,33675,33676,33708,35788,40014,42159,23209,8549,10564,29157,41605,41573,39558,46256,56886,61012,50443,50444,44236,37961,40108,58867,61046,58866,61014,50580,52627,61014,48368,46158,56071,37637,27269,31429,47973,60452,50052,37637,29349,33477,35460,39718,37670,33510,33478,33511,27270,27140,37606,33510,31462,29318,29318,25190,37766,43974,45961,61015,60981,65206,65206,62962,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57149,57148,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57148,52857,42129,33872,35952,31760,27599,35887,35822,8908,15117,31694,17165,19245,29582,17132,13003,8811,35821,52366,44013,43948,41965,17131,6731,6763,6731,31596,50284,52495,54806,54545,60786,58836,56887,54904,63290,44307,35887,59065,61178,61178,63258,59097,60982,44175,58901,61013,50514,52626,52528,48368,39950,42062,46288,39949,50449,50480,52561,54674,39916,48336,44142,42029,48335,41997,52561,54641,54674,56787,54641,56754,54673,54641,58867,54674,58867,63126,40015,6404,6436,20869,43685,41605,46157,54806,63192,58964,50444,46283,42156,37962,37962,56720,61013,60881,60948,19049,39982,61046,50448,46223,41832,35589,27269,25189,43845,64547,64610,54148,47876,35396,33316,33380,39750,37541,33413,35558,39685,37605,23076,25157,25157,25060,16642,18884,48263,52391,54411,50483,58900,65206,65206,62995,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57148,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,55002,42226,35952,33872,35920,40048,27598,33806,21325,35790,35822,25453,31694,27534,23405,27533,23373,15051,44045,50221,37740,41997,15019,4683,12971,35789,35756,35691,46223,60982,65011,64978,65011,56822,46387,63226,50581,50581,61210,61178,61113,61113,54806,58933,42030,54674,60979,56787,58899,56754,54707,48401,50514,54674,54674,56787,56755,56787,58867,50449,54707,52594,50481,54739,50481,56819,58867,56787,58899,56754,58932,58965,54674,58899,56786,58867,63093,39982,4291,8485,10565,14693,10532,35953,56886,63160,61045,48363,44203,37995,35881,35849,52625,61046,60913,60979,21162,31563,61046,52529,48336,39914,37701,27204,23109,27269,52068,64483,62307,58148,39491,39588,35492,39750,37638,31365,35525,41669,43749,31429,20932,16707,16739,10531,6371,27269,41863,58638,52628,60981,65206,65206,60914,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57148,57116,57116,57116,57116,57116,57116,57116,44339,40081,38000,25551,31759,25518,35855,40015,35822,25453,44142,35822,25421,21324,29613,27501,19212,27404,50189,35757,39949,21228,4651,10891,31595,37804,31628,44109,62768,64978,64978,64913,61015,46452,50646,63226,56952,59097,61210,61178,65404,56919,58933,42062,52562,60980,52594,54706,52561,56787,56787,54674,56786,54674,56755,54642,52593,54674,39949,48401,44175,46287,50514,44142,56786,56787,54706,58867,56786,56819,56819,56754,58899,56787,58867,61012,54707,14725,6436,8484,8517,6437,23243,56853,59000,61078,46283,42090,37963,37962,37929,52527,63094,60881,63027,44306,37870,60981,52594,48303,41928,37701,23044,25157,23109,23109,39524,45732,56100,43683,35460,39685,45925,41862,35590,37637,53925,47877,39718,35526,31333,31365,18884,12612,8451,29317,58670,58933,63126,65206,65173,60914,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,50580,38000,29711,21487,19375,25551,42063,39982,33742,27501,42061,35821,25420,31726,33774,23340,12971,19147,48173,48206,37901,27468,6731,8811,37836,50284,33675,39884,50417,65043,65010,60753,61113,42194,44307,61145,63258,63291,65371,63226,63095,58869,61013,46320,56755,63125,56819,56819,56787,54706,44175,48369,48400,52593,54707,52594,54642,54706,37869,46288,39949,56721,56754,46255,54641,52560,54608,56721,50383,54673,56753,54608,52561,37836,56721,58866,65304,39917,10565,8484,16773,10597,25323,56886,54839,61079,46283,40009,40043,40042,40009,50446,63094,60881,56753,54740,56853,58933,52595,50285,45990,39781,31429,29381,29413,25253,31494,47909,54019,54083,39555,29252,54181,41829,39749,31461,52069,60101,47877,41701,45733,35493,39654,23045,12644,25093,58639,61013,65174,65206,65141,60947,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57148,52922,44306,38032,29712,25616,19342,31726,46191,37935,39982,33741,31693,33741,39950,39982,35822,27468,10923,15052,35756,46125,33676,31661,6698,27500,48301,44076,33676,29516,40081,65043,65043,60786,63193,27566,35952,61079,61047,61079,63159,63159,63062,56821,58965,44175,54642,60980,54706,56754,56786,54707,46288,54707,54707,54706,56820,54739,56820,58900,50514,56788,54674,58900,60980,58900,58933,58900,58900,61013,56852,58965,58965,58933,61013,58933,61045,61045,65304,65173,39818,23209,52268,20966,14823,56886,54838,61079,46283,40041,40076,40042,44138,48333,63094,62994,35821,42226,63159,58933,54708,50250,50086,41861,37701,31429,25221,27333,33574,50021,54116,56131,47907,29284,43844,41700,20964,21028,31364,39364,53732,45572,41380,16675,29253,27205,25157,33479,56591,58835,65174,65239,63093,60947,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57149,48664,44208,42160,27663,27631,21390,37966,50350,44143,35854,23340,29581,33741,46190,42127,46158,29548,17164,10891,29516,41997,25356,12906,8778,21260,21259,29548,29548,25387,42161,65011,65010,64978,65338,46485,46452,65272,50514,52367,60722,62932,58869,54773,58965,58933,58966,56821,58901,58934,56853,58966,58966,58933,58934,56821,58933,56853,56885,58933,58901,58965,58901,56853,58966,56885,58966,58934,58933,61013,58933,58965,58933,58965,61046,58933,61045,61046,65304,65141,44011,25290,56493,25158,18951,58966,48434,58966,46283,40042,40075,42091,44170,44204,63093,62994,44240,42259,61112,58900,56820,48236,45990,33476,31428,35621,33574,31494,29382,52004,52003,50020,52100,33251,47811,37540,8451,12611,18852,18819,51780,37284,6338,6338,29286,35558,29382,48137,56656,58802,65206,65239,63060,60948,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57148,48762,36018,46321,35919,25551,31759,27631,44207,52365,39949,35887,27533,31693,33741,44142,40047,31661,25453,19244,10891,21228,35724,25355,15019,10858,4650,8778,35853,35821,29580,46354,64978,64977,65011,61112,56952,46420,63160,58933,58739,54481,50287,44242,35855,56820,52594,56820,63126,58932,58900,56787,56788,46353,56819,58899,54674,56819,54706,54707,56820,56754,56819,54673,56754,56786,50448,50481,44175,46223,50449,56753,58867,56786,58834,60980,56753,58899,60979,65337,65140,43979,27337,39687,27205,18885,37837,50482,56886,44236,35881,42190,42091,44170,42123,63061,60947,58866,56886,61079,58932,56820,48205,45958,39781,37669,33541,35686,35622,31462,35428,56100,52003,60259,58115,45667,20867,14691,14659,31332,31397,35460,20867,6370,6371,23109,25190,23045,54410,58769,60981,65207,65206,63028,60980,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57148,48761,36018,38000,35919,27631,31759,29711,44175,46158,31726,35854,29613,27533,27501,35854,31694,21292,27501,17132,12939,31531,43916,29483,23308,21227,25420,23340,35789,33741,19179,42128,65043,64978,63029,59033,54905,52791,61145,61079,59000,56855,52563,54709,46387,56820,44208,52626,63092,56787,54706,52593,54674,44175,56754,58867,54706,56819,54706,56787,58868,56786,58899,56786,58867,58899,52594,56787,56754,56819,58900,58867,58900,56787,58867,60980,56786,60980,60980,65337,65173,43914,31366,39719,25157,25125,29384,50547,58933,46316,35881,42157,44304,44238,44238,61046,58933,58834,61046,61079,58933,56820,48205,52266,46022,41893,35589,33573,35654,31494,23044,31236,56132,62403,60163,47780,18819,20867,37540,25092,33477,35525,39750,18884,6371,14756,10564,31430,56458,56722,60981,65206,65173,60914,61013,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57149,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57148,46583,27730,35952,40080,33871,42160,35919,35919,42063,35919,27533,29646,21292,19212,33742,37902,33741,35757,35756,39884,50285,29547,19147,35789,37836,29515,35789,35788,25420,15019,31694,33710,39983,52726,59065,44340,50678,46420,54904,44339,50678,42259,52791,25453,50514,54706,58867,60947,56754,54641,54609,56786,54608,54674,54706,50448,54642,48335,52561,54674,52560,56754,52527,54641,54673,48368,54674,54641,56722,56754,54641,56787,54641,58834,58899,56754,60980,60980,65271,65141,43914,37607,39654,33446,27173,31432,54806,61079,46317,35914,42158,37996,42090,40010,60980,48401,50415,61046,61145,58933,58934,46191,46124,45990,39781,41861,41862,39846,33574,29349,25157,35460,54116,56068,47876,23044,22947,37476,14659,31365,25156,20996,27301,10531,27334,4258,25125,50186,58967,61014,65206,65141,60914,61046,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57148,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,44405,29777,35920,46224,42128,42128,35919,37935,35855,31726,27565,21292,10923,12971,31661,44110,44045,41965,33708,46157,52429,31629,23340,29548,27436,14986,21195,33676,29548,21259,23307,23341,35920,50613,56985,42226,50646,46452,52791,44307,52726,44307,52758,17034,46321,58932,60980,58932,58932,58900,58901,58965,58900,58933,58933,56852,58965,56853,58933,58933,58933,61013,58901,58933,61013,58934,61014,58933,58933,58966,58933,61014,58933,58934,61014,58933,61013,58965,65271,65108,43979,29417,45864,37509,31333,39884,59032,63192,48397,35914,37995,37995,40042,37930,60947,48369,48269,61013,61079,58933,61046,46255,44076,41929,44008,41861,41893,41861,37766,29382,23077,20932,47876,54052,39620,14659,24931,39459,20931,37541,27237,14724,10531,10531,23141,4258,20964,54380,54806,63094,65206,65173,60914,61046,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57148,57116,57116,57116,57116,57148,48664,33938,38000,42063,48336,44176,33840,44111,40015,27598,21292,13004,15084,23372,39982,42029,39917,35789,33741,33741,48367,42095,33742,29581,27501,19212,25387,52332,44011,29483,27467,12906,31662,50580,57017,42259,48565,44340,50646,58999,65304,63192,61046,63191,63159,58933,58966,56853,58933,58934,56853,58933,58901,58965,58933,56853,58965,56853,58933,58933,58932,61013,58933,58933,58933,58901,61013,58900,58932,58933,54707,58900,58900,58900,60980,58900,61045,61045,65271,65075,43979,25355,50155,35397,16903,25583,58934,63192,48398,35881,35882,37963,40010,35881,58834,60948,58736,60980,61112,58933,61014,48336,44143,40080,54773,54640,52525,46186,35621,35622,27237,18916,43652,47779,35460,20932,35235,29155,29220,39588,33380,33412,8418,6371,4258,4258,29253,50253,54741,63094,65206,65173,60882,61046,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57148,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,50744,33939,40113,46256,52563,48304,33839,37967,40047,25485,21293,25421,15020,19147,39982,39982,37901,31660,35821,35853,48367,46256,37967,33742,31628,27500,19147,35723,33675,19114,27467,15018,31727,56951,59065,50678,52791,50678,48500,58966,65369,65304,58966,65369,65304,44175,50514,56754,56786,54673,54641,54674,37804,52561,54641,52561,54674,52561,54674,56754,54608,56754,50479,54674,56754,54673,56787,54673,56786,56787,46288,54706,56786,58866,58899,56819,60980,58900,65271,65042,43881,21064,50090,20900,6600,33645,54773,63193,50478,35913,35914,37995,37930,33801,54673,63093,60913,60948,61144,58965,61013,50449,42128,40114,56952,61177,61145,54739,46120,43909,39718,39652,51972,47812,25092,25028,31171,10531,37572,37572,29284,37637,12611,6371,6371,14757,39817,48270,58868,63093,65173,63093,60915,58900,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,55068,44340,44209,44177,48305,54676,48370,29646,35855,40047,23437,23405,21260,21260,33741,48237,35756,35789,35821,31693,37901,48334,39982,31661,39982,23308,19147,25355,37772,21227,14954,10826,8745,33807,52693,56985,46420,50646,46452,42259,58966,65369,65304,61046,65369,65272,52594,54707,54707,56820,56787,56786,58900,54706,58867,56819,56787,56852,50481,52594,50448,58899,58932,54706,56787,56754,54641,56787,56754,56754,56722,54641,56754,54576,56754,56786,54640,58867,56820,65271,65043,43881,21129,50090,22948,14889,44015,44339,61112,50510,37961,35914,37995,35881,33801,52559,63093,60946,60947,61079,61013,60981,50515,42128,40146,56919,61112,60949,58900,50411,41863,41765,50021,45700,49828,39620,35460,43749,29317,29252,43812,29252,29253,16739,6371,23209,29483,50415,56788,56886,63125,65173,63093,60915,61013,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,40244,35953,27664,39951,50547,44176,25518,35887,33807,25485,23405,19277,27533,31629,39884,33709,27533,29612,46189,35724,29483,31629,35821,46125,29515,25388,31628,31596,23275,31596,27371,21227,37968,50613,56985,44372,48533,52693,46289,54773,44208,52595,58966,65337,65272,52593,54674,48400,54674,52528,54641,56754,54673,56786,54706,54706,56787,46255,50481,48336,56819,58932,54706,58867,56786,56786,58900,58867,58900,58900,56820,58932,58867,60980,61013,58932,61078,61078,65271,65108,43881,19049,45930,25094,10630,35660,44274,61080,50510,40042,37962,35915,33801,33801,50478,63093,60914,60946,61079,61046,60980,50580,40113,38099,56951,61112,56854,54707,39945,33542,37605,56261,43716,51972,62469,50085,45893,47844,31300,48005,54181,43813,25092,16772,12579,12611,52264,60883,58966,63093,65173,63028,60947,61045,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57148,48697,40309,33970,46289,50514,35854,31661,44175,35887,29646,23438,15084,31693,35886,31661,27533,27533,31660,46124,21162,19147,31630,39918,52236,52268,35756,27468,10825,23274,23242,23178,19082,37967,44274,56985,46452,46452,50645,48435,50515,46387,48401,61013,65337,65272,58933,58965,56853,58966,58933,58933,58966,56853,58966,56853,58901,58933,56853,58965,58934,56853,58933,56853,58933,56885,58901,58966,56853,58933,58933,58933,61014,58901,58965,61014,60981,61046,60981,65271,65109,43881,16968,45897,29254,8582,18919,42063,52660,50543,40042,37962,35914,31721,33801,48398,63093,60947,60947,61079,63159,58867,56886,48500,44307,58999,63258,59065,52725,44106,37735,37638,41830,54181,54148,56196,39684,58469,58212,43845,47909,56196,45829,41798,35460,20835,20996,54440,52529,54708,65174,65206,62995,60980,61013,255},
{55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57148,52857,48532,52562,44176,35854,48205,35757,31662,29614,23405,19244,29580,35821,35789,33741,27500,35724,44012,27435,17067,23340,37870,48108,41899,33644,25323,25421,35985,31857,36018,38131,48565,50645,52824,50711,50711,48630,46452,54773,61079,63224,61047,65337,65304,58965,58965,58933,58965,58900,58900,58933,58900,61046,59031,58965,61046,56787,58900,56820,58900,58932,56787,58900,58899,58900,58932,56754,58867,56787,58867,58899,54673,58867,58866,56786,60980,58866,65271,65174,43881,19016,43784,41670,23045,29223,25258,46321,54672,40041,35913,35915,31721,31720,46284,63061,60947,60947,61014,61014,58867,56721,54641,54707,61111,63323,61244,48533,44203,41992,39815,35622,52101,58308,50181,39781,50052,62436,39620,41700,47940,39653,43878,29284,8354,20996,50216,50319,54643,65206,65206,62995,61013,60948,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55100,55101,55101,57149,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57148,48631,42259,52627,44174,37869,54413,35887,33742,27566,27598,33838,37934,29548,27468,31628,35756,37901,39885,33708,33708,19147,29614,35887,27500,35757,35725,42161,57050,46517,46485,48630,46485,44372,42291,46485,44372,46550,42227,61047,65402,65369,61014,65305,65304,56787,56819,52561,54706,52593,54674,54706,54673,54707,48434,54707,56787,54674,56787,54674,54706,56787,54609,58867,58867,58899,58932,56787,58900,58867,58899,60980,56819,58900,58899,58900,61013,60979,65271,65109,45930,23176,39623,39557,41803,39820,33742,42128,54704,40042,35881,35915,31753,31720,44171,52496,58768,63027,58835,54609,58899,56722,54642,56787,63158,65403,52922,19245,39948,37801,39847,35687,52005,56164,48004,33573,37540,60260,51940,52004,58373,31397,31461,41797,20932,25221,39687,39820,54675,65174,65206,62962,61013,58867,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55100,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57149,57148,57149,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,55068,52661,50385,52562,50448,37869,48238,29646,23373,19212,19212,27532,42094,33644,23307,27468,41964,37869,39885,37837,21226,25420,25453,35854,31693,31693,50678,50678,56985,44372,42291,46517,42324,42291,42227,44404,44372,46518,42259,63192,65434,65402,63127,65370,65337,56819,56787,54706,56819,54674,56787,56819,54673,56787,54674,54675,54707,39949,52627,52561,54673,56786,50415,54673,52528,52593,56754,52528,56786,56721,56721,58866,50480,56754,56721,54673,58867,58866,65271,65207,45930,33447,43718,43719,54580,46127,44241,50482,52656,37961,35913,37962,31753,31688,39978,35723,54575,62994,58868,52562,60948,56722,52529,54707,61078,48368,33678,31401,44045,37963,40009,39944,35525,56036,54116,50149,58179,51907,60292,47779,45860,29317,20932,43781,35654,37863,39817,37804,60981,65206,65173,60881,61045,58801,255},
{55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57148,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57148,44503,40146,58672,50417,48336,37934,44143,27565,21325,17131,17132,29645,39981,35788,29612,31596,41932,37869,31595,41996,21194,21227,27501,35822,39949,31661,48598,40211,54905,44405,42259,44372,40179,46453,40179,46485,44372,46485,27599,44306,48434,46353,44241,44306,58965,56819,56754,56786,58867,56787,58900,58900,56819,58932,56819,58933,58933,52627,58901,56820,58932,58965,56820,61013,58933,58933,61014,58933,61013,58933,58933,61046,58933,61045,58966,58965,61046,58965,65271,65207,45930,29319,43815,33481,48371,35659,42128,63160,52658,42124,40076,40077,37997,33737,29383,44110,56656,62993,60948,52594,58900,54674,52529,54675,58966,39689,37478,41639,43978,42123,40043,39977,37735,33413,45958,60421,62404,33347,45700,49795,41604,33445,25092,24995,37702,37701,31430,37771,58835,65173,65140,60881,63126,56623,255},
{55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,55068,48696,25747,29745,37935,42128,35887,37934,27533,25453,21324,19244,35853,37901,35919,33741,37836,35756,37869,37836,39884,31595,17034,23275,42063,35756,33709,50711,48663,54905,46518,44404,50678,46517,50678,48598,50678,44372,23503,10988,13004,12971,10923,10891,12971,50514,61014,56885,56821,58934,56853,58934,58934,56885,58966,56885,58901,58933,56853,58965,58933,58933,58965,58901,61013,58933,58933,61013,58933,61013,58933,58933,61013,58901,61013,61013,60980,61045,61013,65271,65174,45898,23144,41767,39687,39719,35624,52659,65240,52625,37962,35882,35915,37963,33671,33543,58867,60947,60913,58933,56918,58901,54706,54674,56820,61112,43948,37446,43687,46026,46318,44272,35817,39976,37799,33607,46153,60552,56261,58213,64421,55972,39459,47876,35460,35493,37540,37540,52430,63094,65174,63060,60882,63126,52365,255},
{55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,59228,46746,55035,40310,29777,42064,40016,31759,33807,31726,25453,10891,15051,40046,46353,44273,40013,35788,29548,31596,39917,35788,14986,10858,21195,31628,29515,39950,52759,46453,56985,48598,44372,48598,44405,46485,44372,44372,17132,8908,10923,15052,12939,10891,12906,12938,48369,58933,56820,54674,56819,54674,56819,58867,44175,52627,54740,56819,58900,54674,54707,46255,48368,48400,52495,56754,54673,54674,56787,54674,56786,54673,56721,56786,52593,58835,56754,58802,60947,58834,63158,65174,48011,16935,35528,37446,23012,44109,61046,63192,52625,37961,33801,33801,37963,31591,31495,56754,60979,60913,58932,58901,58933,56754,54707,63258,63257,46158,35366,43687,35528,40011,44204,42090,35880,39976,37799,44137,52558,46088,48038,50085,56069,58053,53988,45797,31333,37573,52332,60980,65206,65141,63061,60947,63093,48171,255},
{55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,59196,59196,57116,48598,35986,46354,42095,35887,29647,31694,33774,25485,17131,44271,50547,46353,39950,29516,21227,17067,37868,46253,23339,12938,29548,41964,29515,27468,52791,50678,54904,44405,40146,46517,38163,46452,35953,19277,6730,10956,10890,15051,12939,12971,12906,12906,46289,56852,52626,52561,56755,56754,56787,56819,48401,54675,52593,56819,56820,56787,56852,54707,56787,56787,54674,58899,56819,58900,58932,56786,56819,50513,56819,58867,54674,58867,56786,58834,58899,56786,63158,65142,47978,16903,33416,33286,4259,42160,63159,63193,52625,37961,35881,35914,37931,12708,12611,52496,60980,60913,63027,60882,60980,58834,61144,63323,63257,50417,35398,39559,35529,44139,46251,44170,35848,35880,37929,46250,48362,37831,41959,46055,45957,39685,31300,47942,39686,43943,56689,58934,65206,65140,63027,60947,63093,43946,255},
{55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57148,54970,44307,42193,44175,40047,33839,31726,29613,27501,17099,35918,31824,46320,37869,31596,12906,23307,29548,29547,19146,12906,19114,33676,25387,31661,50711,40211,54904,46485,38066,44437,40178,42292,12939,10923,8811,10956,12938,12938,12873,12939,12906,12873,44111,58867,54674,44110,48368,52593,54641,52560,35788,48401,54641,54706,54739,50480,54674,50448,54641,54673,54673,56786,54673,56786,56819,56721,56787,52593,56786,58867,54706,58900,58867,58932,61012,58900,63158,63094,50059,16903,31368,35334,6404,40080,61112,61145,52657,40009,35881,35881,27400,16869,18917,48302,63060,60913,62994,60914,60980,56787,56886,56886,58901,52595,37511,37479,37576,52528,50446,39977,35881,33800,35848,46250,48297,48265,48234,44008,50247,48070,35525,41863,45991,56394,56755,61047,65206,65206,63028,60980,63060,41801,255},
{55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,55101,57149,57149,57149,57149,57148,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,50777,46420,46354,46321,37968,37967,35854,27533,27533,31629,31760,23503,42126,46188,44108,27467,39948,29548,29515,35788,37868,21194,23339,33708,42029,50678,46485,54904,46518,40211,48630,38131,17197,8843,10956,10923,10956,10923,12971,12938,12971,12906,21293,44209,61045,58901,58900,58965,56852,58965,58933,58901,61013,56853,58966,58933,58901,61013,56853,58933,58933,56853,61013,58901,58933,58965,56853,58966,56853,58933,58966,58933,61014,58934,58933,61014,58933,63158,63126,52204,19048,29353,37414,2211,33709,61079,58999,54706,40009,31656,19013,21029,16869,16869,44142,61012,60913,60946,58769,60980,54675,43915,46191,54642,54642,37544,39559,43752,54608,27400,27399,35880,33800,33800,44202,48329,52457,54539,41959,41799,50150,33477,37736,48072,58508,58966,58934,65174,65206,63027,61013,62995,37608,255},
{55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57148,54938,46419,40080,33871,33839,33774,31693,29548,42062,48435,59000,46354,42029,41996,39980,29580,33708,25387,37772,41932,29482,6633,25420,31628,44076,50645,48598,54872,48566,42291,44372,15019,8843,8778,10923,12938,10923,10858,12938,12874,12906,10760,29679,48467,61046,58933,58933,58966,56853,58965,58933,58933,61013,56853,58966,58966,58901,58966,56853,58932,58932,56852,58965,58900,58900,58932,58899,58932,56787,58868,58900,56754,58900,56787,58932,61012,58931,63158,65207,52172,18983,27305,39494,4292,29549,61079,50547,54770,42089,37832,35655,29414,21061,16836,39916,56754,60913,60946,58834,58867,56820,41704,41900,52594,54675,37609,39559,39559,35625,8516,23175,37961,33800,33800,42089,48362,52490,52424,43878,35366,31269,22915,33414,56426,58703,61047,61046,65206,65207,62995,61013,60850,33447,255},
{55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,48664,44274,37999,23437,27566,31694,31596,29484,44141,50481,56952,50514,42061,27435,44076,37901,33708,21227,33676,41996,31595,29679,40113,44307,54740,52791,48565,52824,46518,27598,15052,6698,10891,8777,10891,10825,10891,10825,12906,10793,12873,10760,12841,39982,58868,50481,54706,56819,50513,54706,54673,50513,54707,52528,56787,56820,46256,52561,52561,56722,54673,52528,56754,54641,54706,56754,56786,58899,56787,56819,58867,56787,58932,58899,58900,60980,58899,63158,65207,54284,21031,27305,37446,8452,29515,54740,52628,54739,40009,29414,29382,31526,29414,20997,37770,50383,60981,60947,58802,58834,56885,41737,39787,52530,56787,39754,35398,31367,18885,16773,27272,40074,33768,33800,35880,48330,50409,52490,44042,45833,37479,39819,48238,58703,58834,58934,61046,65206,65174,60915,61046,58736,29352,255},
{55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,55101,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,55003,36116,40146,40146,35919,35822,31596,35692,37804,33741,33807,27599,37967,37966,14954,44109,42029,31596,25355,33676,29515,23373,56984,54904,52824,46550,38131,36050,52824,38099,10826,8810,8745,10858,8745,10826,8713,10826,10793,10793,10728,10760,10695,10695,37869,58933,52626,56787,56820,54674,56819,56819,50481,52594,52626,56787,56755,46321,48433,44175,54642,54674,54641,56787,52593,54674,52529,54641,54673,37837,54641,56754,52495,56753,54640,50448,52593,54608,63093,65271,56430,20966,23144,27174,20933,25158,21162,50580,54738,39976,39847,33542,31494,29414,27302,23110,31596,60980,60947,60948,50351,48271,43850,31368,48336,56787,39852,35464,39982,14692,16740,23047,40011,31720,33800,33768,44202,48330,50444,50411,48104,47976,54446,54543,54544,58900,59032,61014,65239,65173,60914,63094,54575,25256,255},
{55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57083,42291,27762,42291,42095,44175,37837,37772,41965,37837,35855,38130,40146,40113,35855,42093,41997,39982,37868,35820,23275,21292,17262,17262,13069,10988,6828,10923,31792,15019,10793,12938,10826,12971,12938,15051,17067,17099,17132,19180,21227,21228,21260,21260,42095,58900,50448,54641,54706,52528,56754,56786,52593,54706,52626,56819,58900,48401,52594,52562,56819,56819,56819,58932,56820,58932,58900,58900,58933,54739,58933,58965,58900,61013,58933,61045,61046,61013,63191,65239,58575,23112,23209,33447,27206,29286,27467,50612,52690,35881,40009,44072,37767,29382,21029,14790,35822,56787,54674,58965,44143,39657,31401,10532,44176,56787,46191,25095,35822,14725,14692,14660,33706,33800,33833,37996,46351,48431,50511,54672,54638,56685,58867,52495,46158,58900,58999,63126,65206,65173,60915,63094,52430,25257,255},
{55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57148,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57148,50645,27729,36018,40047,40080,42129,33708,35789,41964,50449,65403,65371,48532,46190,50349,44110,42030,37901,44305,54839,54839,52791,29679,6698,6698,6697,4552,29647,50679,44405,46518,46517,48630,46518,48598,48598,50678,50646,48565,50678,50678,50710,50678,52660,61046,56853,58933,58934,56853,58966,56853,58933,58966,56853,58965,58901,58933,58966,58966,61014,58934,56853,58965,58901,60981,58933,58901,58966,58933,61013,58965,58933,61046,58933,61013,61046,61013,63190,65272,58608,25159,21064,45800,27173,33577,56853,54773,52690,37929,35881,37896,39814,35654,21030,16936,35789,41997,44109,63060,46256,25127,8517,6372,33676,56723,50384,12645,19082,21031,14692,14660,27369,35913,31720,33800,42089,42089,50410,56818,61046,61013,61013,56820,56787,61046,58999,63126,65173,65141,60915,63093,50284,25322,255},
{55068,55068,55101,55101,55069,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57148,57116,57116,57116,57116,57116,57149,50777,38066,40146,42128,29679,44307,46255,33741,29612,52561,65404,65403,59065,54576,54508,48302,35821,29580,46354,63258,63226,48500,23373,25518,27566,25453,23373,40146,57018,42325,50678,31890,42356,44372,46452,42259,44339,44372,44339,48565,46452,48565,42292,52628,61046,56852,58933,58965,58868,58933,56819,58900,58932,56787,56820,50514,50513,52594,48369,54739,58866,54706,56819,56853,56820,54674,54641,56786,54674,56754,56721,54673,56786,50448,56754,56786,58834,63125,65305,60688,25159,19016,45768,12612,18984,50481,46223,52658,37929,35880,40076,48366,46187,46188,37836,54675,58867,50383,63028,44175,31726,8517,4324,25355,42128,35757,12775,23373,25258,14660,14660,21063,37994,31720,33832,37961,40009,50409,56752,61079,61013,58965,58965,61013,58933,61079,65206,65206,63060,60915,63093,46059,25355,255},
{55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57116,57148,57116,57116,57116,57116,57116,55003,42293,38066,44274,42192,40079,44208,42095,33774,31693,48270,40048,48500,44241,50381,50380,42028,44142,33676,42193,63226,61145,61178,61146,46420,50613,59097,46420,44339,56985,48631,50711,44437,48630,50711,50678,48598,50678,50678,50678,52759,50646,52791,48598,52628,58900,52528,54706,56786,54640,56786,54641,54674,56754,54641,54707,48401,52561,52594,50513,56787,56819,56787,58867,50513,56787,54706,58867,58900,52561,58867,58899,58867,58932,58900,60980,60980,56819,63126,65304,60656,25192,21128,47848,14725,12743,31401,29451,38062,37929,40141,38292,42485,42223,35785,33672,56722,60979,60946,60980,44273,33871,14823,6372,16936,31857,6436,21227,33873,29483,14660,14692,16805,37930,33800,33800,35881,37928,48297,54638,61079,61013,61013,58965,58933,58900,61013,65174,65173,63060,60948,61012,41866,25388,255},
{55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55100,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57148,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,44470,36018,44274,50515,44240,48369,50515,39983,29613,29548,46092,27404,33774,42128,42094,33740,29547,39916,31562,42193,61178,61146,61178,59065,35855,40113,56985,38033,40146,57017,44372,46517,42292,46452,48598,48565,46517,48565,46517,44404,48565,44339,48598,42292,50580,58900,52560,56722,56754,50513,56754,52560,52625,52625,52528,54674,52626,44175,42062,50481,54706,54640,54673,54674,37804,52561,52593,54641,56754,50448,56754,54673,54641,58835,56786,58899,58899,58899,63158,65337,58575,20999,18983,47848,16741,19082,29548,25387,40142,39977,48596,28345,28345,38032,18916,27367,58867,58834,60947,63028,40080,31791,29711,6339,12775,29971,12775,16936,29744,31662,14693,14692,14692,31625,35880,33800,35881,35848,42089,52557,61046,61014,61013,58965,58900,58900,60915,65206,65206,63027,60980,60979,37673,27533,255},
{55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,46518,35985,40113,46255,48369,48435,42096,27533,19211,42095,42096,35789,37902,40015,33806,29613,29613,33742,46420,61178,59098,61146,57017,52792,56952,56985,46485,44339,54937,42324,46485,42259,44339,46485,46452,44437,44404,44372,42259,46485,42259,46517,40178,48467,58900,54706,58900,58900,56820,58932,56852,58900,58900,56852,58965,58933,56852,56853,56852,58965,58933,58933,58965,58933,61013,58933,58933,58966,58933,61014,58933,58933,61014,58934,61046,61014,61014,63159,65337,58542,25224,21129,47913,14660,16936,27403,25290,50545,39977,44402,40634,28280,33805,16901,27368,52594,56819,60979,50449,35952,33969,29679,14823,19114,32117,17034,10597,27664,33742,16838,14692,14660,27401,40041,37961,35913,35881,37928,50444,61046,61046,58965,58965,58900,58900,60948,65206,65206,60947,61013,60914,33545,29646,255},
{55068,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57148,52923,34035,48500,40080,33839,38033,37935,29580,21259,46387,54806,29679,29712,33872,31760,33840,35953,35952,46452,59097,59097,61178,59097,40081,40113,56985,40146,38033,57017,46550,48630,48533,46485,48598,46517,48598,46485,48598,46485,50646,46452,48566,46485,50580,58933,56853,58933,56886,58933,58966,56853,58933,58933,56885,58965,58901,58933,58966,56853,61014,58933,58933,61013,58933,61013,58933,58933,61013,58900,61013,61013,58932,60981,58900,61013,58932,58900,63126,65337,58510,23176,19048,45864,22948,27141,35626,23177,46351,42189,48760,36407,32180,42030,33707,44207,56821,58900,60947,50546,31824,27630,36050,25485,23405,30069,21357,6371,27566,31727,23144,14692,14692,23111,42122,37961,37961,35880,35848,48331,61046,61046,58965,58933,58900,56820,58901,65239,65206,60915,61013,58769,29417,29646,255},
{55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,54905,52660,44273,27630,31726,33806,35822,33709,52693,56952,29679,31760,33872,33840,35920,35953,35952,48532,59065,59065,59097,56985,40146,46419,59065,46453,42259,56985,48566,48598,44437,44437,48598,46452,46453,42259,48565,42259,50646,44339,48598,40243,52628,58900,54674,56787,56786,52593,56787,54641,54706,54674,54641,56786,52562,50449,46288,50448,56754,54673,54673,54673,56754,56787,48401,54706,58834,54609,58867,56786,56754,58867,56754,58900,58867,56787,61045,65272,56396,23177,23144,41638,29124,29189,35626,21032,46318,37930,39978,29479,29512,33577,27236,33542,58867,58900,60914,44272,29711,34035,34067,29711,25648,27957,23633,6371,23340,29679,27370,12612,12612,16838,37962,40041,40009,35848,33768,46250,58965,61079,58965,58966,56886,52693,58999,65238,65206,60947,61046,54543,25256,29647,255},
{55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,57148,50744,50548,48401,46354,35725,29549,33741,33741,44274,48533,33840,35920,33905,35953,35953,35985,38033,48533,61145,61145,61145,59097,61178,63258,61177,61178,56984,52824,42324,44404,40276,38131,46485,42259,46453,40146,48565,42291,50678,44372,50678,42324,52628,58900,54674,56819,56786,56787,58900,54706,56820,56819,56787,58900,54674,54739,54707,54739,58900,56754,56819,56819,54706,56819,50513,56754,56786,50513,56754,56721,56786,58867,54641,58867,56786,60979,63126,65272,52235,23177,31399,39557,35364,33349,46223,29418,44270,35881,39880,25189,25221,35689,33609,31561,58835,61014,54675,37999,36083,31954,31987,27696,25746,27924,27859,12710,19114,29679,29516,12644,12612,12612,35818,40073,37961,33800,31687,44169,60980,61047,58933,61112,58966,58966,63127,65206,65206,60980,61046,52398,25257,31759,255},
{55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,55101,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,50744,48500,50482,54741,39983,29516,29613,50613,48565,38066,33808,35920,35953,33872,35953,35985,38033,44340,59032,59065,61145,61177,61177,63226,61177,61177,54871,56985,50711,52824,52791,54904,50711,54872,50646,56952,52824,56984,52726,56984,50711,56985,50580,58933,52561,54674,52561,50448,52593,52593,54674,52561,52560,56786,54674,54674,52594,52562,56787,54706,56787,56786,54706,58868,56754,58835,58867,56787,58932,58900,58932,61013,58900,61045,61013,61046,63159,65206,45994,21129,33447,41637,33284,33316,33383,35691,48432,33639,29382,27237,25125,27336,31627,31528,58834,60981,54707,38032,31922,29906,29874,25551,25811,25876,30004,12775,14791,27631,29581,14725,12612,12580,31561,42154,37961,31720,29607,39976,58899,61046,58965,63193,63192,61078,65207,65173,65141,60915,61046,48172,27370,31759,255},
{55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55100,55101,55101,55101,55101,55101,55101,57149,57149,55101,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57148,57116,57116,57116,57116,57116,57116,55036,42422,46452,44209,38033,42129,29549,35887,65371,52791,35986,29647,33840,35921,33872,33872,35953,38001,40081,40113,52726,63258,63258,61178,61178,61178,59097,59065,59097,42227,56984,46452,59065,46419,56984,46420,56984,48565,59032,48565,59065,48630,59065,50580,61078,56853,58966,58933,58933,58966,56852,58933,58901,58901,58965,56853,58933,58933,58901,58933,56821,58933,58901,58901,58966,58901,58933,58966,58933,61014,58933,58965,61014,58934,61046,61014,61014,61079,65109,39786,23274,31431,47879,41572,33317,31303,43947,52495,35300,25060,18949,10532,18950,14756,14724,54608,60947,54674,38032,31921,29906,27761,23503,25811,25843,30037,17099,10565,29647,31694,18951,12612,12612,25223,46283,40041,31720,29607,37896,58866,61047,61046,63225,61111,63094,65207,65206,63093,60947,61045,43978,27403,33839,255},
{55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,50744,48467,40080,29679,40047,27500,35854,63290,54839,33905,29679,31760,35920,35920,35953,35985,38033,38033,38001,48533,61210,59098,59065,61146,61178,61178,59097,59065,42227,56952,46420,56984,44339,56984,46485,56984,48630,57017,50645,59065,48598,56984,50580,61079,56853,58966,58965,58933,58965,56820,61014,61078,58900,58933,56820,58933,56853,56787,58900,56787,58899,58900,56787,58900,54674,56819,58867,56755,58900,56786,58867,58899,54641,58867,58867,58899,61046,65042,33545,23242,25224,47911,43685,33382,42063,43980,41736,29350,23174,21094,10564,8451,8484,10564,52496,60946,56754,38032,31921,31954,25648,23568,23795,25811,30004,23470,8484,25486,29647,25225,12612,14660,18918,44203,40041,31687,29607,35816,56819,59031,61112,61112,56886,58868,65239,65173,63060,60948,63061,39785,25388,33839,255},
{55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57148,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57051,48500,42128,40047,44110,42063,46223,65306,52759,40146,35920,35920,35953,35952,35953,38033,35985,38033,35953,44339,52725,58999,61145,59097,61178,52726,52791,59097,42259,56952,44372,54904,46452,56984,46484,54904,50711,56984,48500,56952,50678,57017,50613,58965,39949,52593,56819,52626,54739,52495,58900,61111,54706,56787,52528,54674,54642,50481,54674,50448,54706,54674,56722,56819,52594,58867,58900,54706,58867,58867,58900,58932,58867,58932,56787,58867,65240,62864,29385,25355,25257,50122,33414,25224,52628,48075,41605,27334,14789,16901,18982,14821,14757,18949,52463,60946,56754,40113,29873,31922,23502,23633,25811,25811,27956,25713,10597,23340,29712,29483,12612,14692,14693,39979,44169,33735,29607,33767,52625,61079,61112,61080,59032,54642,63126,65173,63060,61013,60947,35592,25453,33807,255},
{55068,55068,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,55003,44372,42161,44175,35853,48336,46256,63258,61145,56952,38033,35920,35920,35920,33872,35953,35920,42226,21326,33872,56854,59032,61177,61177,61145,56985,57017,59097,52791,59065,54872,59065,54904,59097,54871,59097,56952,59097,54872,59097,54904,59097,54806,61014,54674,56819,54674,54706,56787,50481,58900,59030,52626,54706,52561,54707,52561,48401,52562,54673,56754,54641,52496,54641,50382,54641,54608,48335,54641,56689,56721,54673,56721,56786,50448,58900,65239,58638,25257,25355,23242,50155,27207,18918,54541,49993,39621,25286,21062,23174,18982,21062,12709,18981,50415,56721,56755,42193,33969,31889,23438,25746,25811,25811,27924,29971,12742,19049,27632,29581,14693,14692,12612,35722,44203,35882,33802,37963,50545,58966,63192,63257,61145,58933,65206,65238,63028,61013,60882,31432,27534,31759,255},
{55068,55068,55101,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57083,38164,36018,46288,44175,46256,48272,63258,65469,65371,58999,48467,38000,40081,40081,42194,42194,48500,21325,35953,65338,61177,61112,63257,61177,50646,50678,59098,44437,56952,46452,54904,44405,54904,46420,54904,46484,54871,48597,56952,46485,54872,48500,58966,52528,54706,52561,54674,54707,54674,58900,56885,56819,56852,56820,58901,56820,56820,58933,58900,58933,58933,58900,58933,56852,58965,58933,58933,61013,58933,61013,61014,58966,61046,58965,63126,65206,50252,23209,23275,23274,50252,27174,23110,58700,52008,35429,25286,23174,21029,25222,23109,18982,12644,41996,46255,58835,44273,33969,29776,23470,25778,25811,25811,25844,30037,17033,14823,29712,38001,18918,14692,12612,27337,42123,35882,33802,35882,52592,58966,63192,63225,63225,63192,65239,65206,60947,61046,58769,29352,27566,29647,255},
{55068,55068,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,55003,25714,31922,46353,54576,39918,35789,61145,65404,61178,40146,54838,58966,56886,56886,58966,56886,58999,36017,35952,50645,50612,48532,50580,54839,50711,50711,59098,42324,54871,46452,54872,46485,54872,46485,54904,48630,54904,48565,54904,46582,54904,52726,56820,56885,58934,56853,58933,58934,56821,58933,56853,58933,58933,56821,58965,58933,58933,58965,56853,58933,58933,58933,61014,58966,61013,58933,58933,61013,58933,61013,61045,58933,61045,61013,63159,65140,37771,23209,25355,21162,48172,29352,14790,56722,56331,39621,25221,29480,25222,29414,25222,23142,21029,48237,52528,58802,46321,35985,27631,25551,25811,25811,25811,25844,30037,21325,12677,33807,50581,25257,12580,12580,18886,42090,35848,33768,33767,50478,58966,63225,63225,63225,63192,65239,65173,60882,61046,56623,27305,25518,27566,255},
{55068,55068,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,52824,46321,44307,46354,50448,37837,33741,61210,65469,63291,40114,42259,33872,33839,33872,31824,29711,42258,42259,29776,31857,35952,35984,35985,46452,54904,54840,59098,42259,52791,44372,54839,48565,54872,46485,54871,50743,56984,48565,54871,48663,56985,50645,58966,56819,58932,61012,56820,56787,54674,56819,56754,54706,56755,54707,54707,46320,48369,50448,52560,56754,52560,52560,54674,50579,56754,54608,54608,56721,52495,54673,54608,54608,56786,52593,63159,65042,29418,23209,25354,21129,48140,33577,14823,54739,56526,49990,39750,37736,35722,31594,29481,29482,31594,52560,60947,56722,46321,33904,23405,25616,25811,25811,25843,25844,30037,27696,10564,31661,50580,40015,25192,27305,31498,44204,33767,33768,33768,48397,58966,63225,63225,63225,63192,63192,65206,60882,61046,52430,25257,25518,25518,255},
{55068,55068,55101,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,55003,52563,42193,52594,46288,44078,42030,59065,65436,63258,31759,40178,33840,33840,33840,29744,31792,40146,27598,17164,19277,21325,21357,19309,38098,56985,54904,59098,50711,56952,54871,56984,54871,56984,52791,56952,54904,59065,56952,59065,56952,59065,54839,58933,52528,56754,58866,54706,54674,52561,56755,52561,54706,56755,50449,54707,52594,50514,50514,54674,58867,54706,56787,58867,52561,56787,56754,54673,56786,56754,58867,56754,56786,58931,58867,65272,54478,25225,33774,33839,33839,54511,35658,23242,56788,50351,56754,46121,39686,29253,25286,23206,25254,20997,42028,60979,56721,46288,33871,25453,31922,32019,34067,32052,32052,34165,36082,14725,46387,63323,63094,62863,62863,64945,48430,31719,33768,31719,48364,58966,63225,61145,63225,63192,61144,63158,60947,61046,48204,23209,25518,27566,255},
{55068,55068,55101,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,46355,42193,48400,46288,40047,42128,42226,65436,65436,44339,44306,44307,44306,44307,46387,46387,50613,27631,19244,23438,25518,21292,33775,48500,54839,50678,61178,44372,52759,48565,52791,44339,52758,44339,52758,44372,52759,50646,54839,46485,52791,48500,56788,58868,58900,58834,52594,52561,52592,52593,33643,50480,52593,42127,52562,54642,44143,42095,52560,54674,50480,56754,56818,52528,56755,54673,54674,56787,56818,58900,58867,58900,61012,58900,65206,35593,18918,38032,40145,40178,56688,29319,14823,56886,52529,48368,46219,35654,27269,31526,29414,31462,25222,46156,60947,56754,33643,29614,36017,31987,27956,29972,30004,27956,30037,33969,18886,56984,65501,62995,62764,64845,62831,48364,33768,33768,33767,46283,58901,63225,63225,63225,61144,61145,63094,58867,61046,43946,23242,27566,27566,255},
{55068,55068,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,55101,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,52726,40113,40048,44046,35855,35921,27468,40081,52726,48435,42161,44241,44241,44209,44209,42161,44209,37968,35953,33807,33807,29614,29516,40113,52791,48533,61178,44372,52758,48598,52823,44339,50646,44372,50678,44307,50613,48565,52791,48630,52824,48532,56788,58933,58965,58900,58933,58900,56852,58933,56853,58933,58933,58933,61014,56852,58965,58966,58901,58965,58933,58933,58933,58901,61014,56853,58933,58966,56853,61013,58933,58933,61014,65240,65075,27304,21097,38032,40145,40177,58769,33480,16903,56886,48336,35724,48333,37832,31527,35654,31494,31494,25221,48301,58801,50253,48206,40113,31922,29874,25876,23827,25876,25876,30037,29743,20999,61210,65436,62929,62797,62797,62831,48363,33768,31687,33768,50512,58933,63192,63225,63192,61144,61145,61014,60948,61013,39785,23307,25486,27566,255},
{55068,55068,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55100,55101,55101,55101,55101,55101,57149,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,52792,42194,44208,41901,42064,52661,50580,46321,48434,50482,46322,50514,44241,52627,44176,54708,42063,56821,42063,56789,42063,56821,35790,37903,44339,52759,61178,44372,50678,50678,54839,44339,50646,44372,50646,44372,50646,48598,52791,44372,50678,48533,56788,58933,58933,56853,58933,58933,56853,58965,58933,58933,58933,58933,61013,58933,58933,58900,58900,61013,58932,58933,58965,54707,58900,56852,58900,58932,58900,58900,56754,58932,61045,65272,56624,21031,19146,38065,40145,40145,56688,33545,21096,56853,41965,54708,60946,35720,27334,33574,31462,31430,25189,48236,60882,50124,52334,42030,31922,29841,27891,25843,25843,25843,30036,27533,23112,65404,65371,62864,62798,62896,60848,48362,40009,31687,33768,48431,58966,63225,63192,65273,61112,61047,61047,61078,60948,35625,23340,25486,25518,255},
{55068,55068,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,55101,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,52824,42161,42128,48271,44143,65272,54806,46321,52595,50482,50515,54675,46322,56788,46321,58901,44241,58934,44176,58901,46289,58934,48402,52693,40047,48467,57017,48598,50678,54839,52759,52759,52726,52759,52726,54839,52694,54871,50646,54839,50645,56887,58869,58900,58933,58801,56786,52594,50448,54641,54673,54674,52560,50481,54675,54642,52562,52529,50448,54674,54640,56786,56819,44142,54674,54674,56754,56786,56721,58867,56754,58899,61013,65173,37804,19016,19146,38065,42225,40145,56656,39851,29516,52660,44045,47945,48204,31431,16739,37606,37734,35622,39717,54443,60915,46061,50320,46159,33937,27826,27891,25843,25843,25875,30036,25322,25258,65469,65306,62831,56493,52399,54576,48330,40009,31720,33767,50446,58933,50547,46386,52628,61112,61046,61079,61111,58802,31432,23373,27566,25518,255},
{55068,55068,55068,55068,55101,55101,55101,55069,55069,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57148,57149,50712,21292,23373,46321,44143,63159,56854,46224,50547,48337,46354,52530,44209,54643,42096,56756,39983,58869,39982,56821,42063,56821,58902,65370,42096,56788,50547,58999,52628,61047,48467,61047,48434,61047,50482,61047,48402,61047,46321,61014,46289,63095,58869,58932,61013,60947,56819,50513,56787,58900,54674,58899,56819,54674,54674,54707,54707,52594,58899,58932,56786,54740,52627,50481,54706,52593,54674,56722,54673,58867,56786,56786,63094,62962,25257,18919,23210,38064,42226,40145,56656,58834,37837,50613,54382,43556,24964,29156,22915,24963,31268,45861,49988,56459,60914,60916,61047,54610,40113,27826,27859,25843,23795,25843,32052,23176,31629,65502,65272,62766,62765,62700,56590,42121,37961,40077,37997,48465,56919,54773,48467,39950,56821,61078,61079,61111,56656,27304,25486,29646,27566,255},
{55069,55068,55068,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55100,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57148,57116,50777,44340,40081,29614,31694,37967,40015,63160,58999,48402,54741,50482,50547,52595,46354,54675,44209,56788,42096,56821,42031,58869,42030,56788,54740,65338,40015,56788,40015,56821,44176,58901,39983,58869,39982,58901,42063,60981,39950,58934,42063,58934,42095,61047,56820,56787,56819,58834,52561,39949,52593,56754,54641,56787,54706,50481,52562,52594,54707,52626,56819,58932,58899,56787,54674,52594,56852,56787,56819,58867,58867,58932,58899,63126,65206,48270,16871,16838,23177,40112,42193,40145,58671,62929,56820,48434,58738,43557,31107,39492,47876,37508,12547,29123,53987,56394,60947,58770,56788,46060,44208,31890,29874,25843,23795,25875,32019,23014,42096,65534,63127,62733,62765,64814,52526,40041,37961,33801,35882,48431,61014,63126,65206,63060,61078,61046,61047,61079,54543,27304,25486,27566,27566,255},
{55068,55068,55068,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57149,52923,48598,56854,63160,63192,65273,65305,65305,63160,65240,58967,46321,54741,50482,52628,52595,48435,54708,46354,56821,46289,58902,44209,58901,44208,58901,56821,65338,46289,56821,50514,58901,44241,58901,42128,58902,42096,60982,44143,61014,46289,61014,42063,61014,42030,63094,58901,61013,63126,60947,56819,48368,56754,56787,54641,56819,56786,44174,50449,50448,54674,50481,52528,54673,58866,56754,52528,50447,52561,50415,54641,52496,54641,54641,50415,63127,62995,31596,27435,25354,25354,46386,42225,42225,56755,58835,56885,54676,54577,43589,35267,31235,31300,18755,12547,16707,39428,54250,60947,58867,52626,54708,42030,33937,29874,27891,23795,25843,31987,18853,48468,65502,63061,62732,62765,64814,50413,37928,33800,33768,35848,48397,58901,61013,63094,60980,61046,61078,61079,61111,52365,23176,25453,25486,25518,255},
{55068,55068,55068,55101,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57148,55036,52824,54838,65272,65305,65272,65273,61047,58901,65272,63128,65240,56887,42063,52628,44176,50515,48369,46354,52562,46289,54708,44176,58869,42128,58901,46257,61014,58902,65338,46321,56821,50515,58901,46321,58901,46354,52627,46321,52595,46289,50515,44241,48402,42160,46289,40048,42161,44208,42095,42094,42029,39949,35723,35756,37836,35755,33676,31595,31563,31530,29418,29417,29482,56755,42063,18982,23176,23242,21161,14790,23110,37934,29549,31661,35821,25159,50481,60981,52660,56853,42060,40143,50512,50448,58966,52562,56721,58899,58934,52236,47652,41508,31236,10467,6339,6371,8419,20868,45994,60979,58867,50481,56820,41900,35854,29841,27891,25843,25875,31921,18821,54807,65469,62995,62733,62797,62798,48364,35848,31720,33768,33768,46250,60980,60981,63093,63061,63126,61079,61079,61079,48204,23242,25485,27566,25518,255},
{55068,55068,55068,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,54970,54872,63192,65337,65305,65305,65240,65272,56920,48435,58869,56854,58999,63193,56853,61080,56853,58999,58934,56886,58934,56854,61046,54708,61079,52595,65240,58967,35822,52660,65370,44209,54675,44176,56723,42128,56788,29516,14791,14823,14823,14823,12743,14855,14823,14823,12743,12775,14823,16903,12743,12743,14791,14823,14823,12775,14855,14888,14888,16968,19048,19048,14823,14823,14822,50514,37935,6371,8484,8517,6469,6436,10564,27468,29614,29614,40048,44174,50514,54740,54740,52660,27436,52530,60879,56655,61013,60915,60816,61013,54415,49863,47716,43555,16675,20835,24996,6371,6403,6371,33610,63060,58867,52594,56853,52464,39982,31824,29907,25843,27924,29743,18853,59065,65436,62929,62733,62733,62798,46251,35848,31688,31688,33800,44170,60980,61013,63093,63061,61013,61112,61112,61079,43979,23242,25485,27566,25486,255},
{55068,55069,55068,55068,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,55101,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,55035,56985,61144,65337,65337,65305,65305,65305,65240,65240,61145,54774,50482,58902,61079,61112,48336,56886,48402,54741,52562,52660,54707,50547,58901,48402,61046,61112,44339,25486,12776,42128,65370,48402,56756,46321,56756,44241,56788,27436,10663,10695,12743,14888,12775,12743,12775,16968,12775,12775,12775,12775,12775,12743,12775,12808,14823,14855,14856,16968,16968,16968,16936,19016,16903,16935,14790,48401,46256,42095,50482,31596,14856,14856,12710,27467,38033,29581,29581,52560,46288,46322,46321,46386,12776,33514,58966,63093,60848,61046,60948,61046,58804,54186,41443,29059,33316,22851,31171,16739,10564,6371,33577,63060,60980,58933,56853,60947,46191,31693,29874,25843,27924,29646,20999,63291,65371,62864,62733,62733,62831,44171,35848,31688,31720,33800,42089,58867,61013,63093,63060,60980,61112,59064,61013,37673,21227,25485,27566,25485,255},
{55068,55069,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,55101,55101,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57116,57050,61145,65305,65337,65305,65305,65305,65305,65305,65240,65240,59065,56919,44176,50482,56886,54773,48402,54741,44176,46321,44176,42161,42096,40015,40015,37902,40015,33872,19407,19342,16969,42128,65370,48467,54708,48434,56756,48434,56788,27468,12743,14856,12776,19081,14856,14856,14856,14855,12775,14856,12775,14856,12775,12775,12775,12808,12775,12775,14823,16968,14856,14888,14791,14823,14790,16871,14757,48336,42095,50449,63029,21064,8550,8582,8517,12743,17034,33742,31530,42028,37771,44176,33677,44241,10695,19114,52660,61046,60947,56854,58966,58900,56853,50058,31042,33252,37444,43619,45732,39621,16804,4290,31465,65140,52529,46288,61177,63159,52464,37869,31824,27891,27924,25420,25225,65437,65338,62831,62700,62733,60783,42090,35848,31688,33769,33801,40042,56819,63093,63094,60980,63093,61079,61112,60948,35560,21260,25485,25486,25485,255},
{55068,55068,55068,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,59164,63226,65305,65305,65305,65337,65337,65337,65337,65338,65338,65272,63192,40179,44372,16969,10793,19244,21357,29614,33775,12776,12743,12743,10663,10695,10630,10630,10662,10695,13069,17359,19310,17001,44273,65370,46322,52530,46322,52595,46321,56723,29549,10663,12743,12775,16968,12776,14823,14856,14856,14823,14823,12808,16969,14856,12808,14856,14856,14856,14888,14888,17001,16936,16936,14823,14855,14790,14790,14757,46224,44176,48369,42062,6372,6437,6437,6437,10662,14888,50249,52296,44076,44110,48369,35757,37837,12775,14824,44274,58934,52627,52693,56688,52461,35626,41509,33155,35364,31268,41700,39620,35525,29382,8515,29385,63092,52561,23046,23210,48369,63027,48368,33806,29906,27956,23242,31564,65501,65273,62798,62700,62700,60783,40041,35913,35915,35916,35916,42189,56820,63093,63126,60947,60980,61079,61112,60883,31400,23341,23405,23406,23405,255},
{55068,55068,55068,55068,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,55101,57149,57149,55100,57149,57148,57116,57148,57148,57148,57116,57116,57116,57115,63258,63226,63225,61145,61080,58999,56886,54774,54806,52693,54740,60949,54675,38066,48533,19147,8713,17131,19342,25485,33807,14888,12776,14856,12776,12808,10695,12743,14856,14856,17165,19407,19310,17001,44208,65370,50547,52530,46354,52563,46321,54610,31629,10630,14823,12743,12743,12743,12743,12775,14856,12775,12775,12775,12776,14823,12775,12775,14856,14823,14888,14888,16968,14888,16936,14855,16968,16903,14823,16871,46289,44209,46256,33643,12710,8550,10630,10597,10630,31495,64804,62693,58502,50218,56820,31497,27239,14791,12743,40016,58933,44208,50383,54474,37606,39428,49731,43523,41571,31300,27172,35428,33348,29382,16869,31498,63093,54641,23013,2210,33643,58801,54544,39819,38130,29971,18951,35822,65534,65240,62797,62668,62732,56655,42089,37961,33768,31688,23206,35786,54707,63126,63093,60914,60947,61046,61079,58737,29320,21325,23406,23406,21357,255},
{55068,55068,55068,55068,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,55101,55101,57148,61244,59196,61244,61244,61243,61243,61243,61244,61243,61244,61243,61243,61211,54905,50678,46452,44275,42129,35855,31629,31629,29516,27338,35562,35659,38098,50678,19180,8713,17131,19342,25453,35887,12808,12776,12776,12775,14856,12776,12776,12775,12775,15084,19375,19342,17001,39950,65370,52660,54643,50547,54675,50547,56756,31662,10662,12743,12775,12775,12775,12775,12743,12775,12743,12775,12775,12775,12775,12743,12775,17001,12775,12775,14856,17001,14888,16968,16936,16968,16935,16935,14823,44208,46354,27370,29451,21162,21130,16904,12677,10630,41895,64933,62628,58468,58635,54706,21062,10564,8484,10630,40015,56788,46289,54509,46023,41637,47715,51875,45635,43748,43781,35428,47908,41733,16804,21028,40046,65370,54642,27271,4291,25289,46189,60880,58802,48499,31987,14757,42162,65502,63126,62733,62700,62765,52493,40008,35880,33800,31655,10628,39623,56625,63126,63093,60947,58834,61013,61046,54543,25225,21325,23405,23406,21358,255},
{55069,55068,55068,55068,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,57148,63258,65305,63225,61112,61079,61047,58999,58967,58966,58966,58966,61014,58966,40178,50678,17035,4584,10890,8778,17099,33872,14921,12775,14921,10695,12808,12775,12776,14823,14856,15116,17327,19342,17002,33742,65370,50547,50482,50547,52562,50515,54643,33742,10663,14856,14856,14888,14856,14856,14856,14856,12808,14856,14856,14888,14856,12808,14856,16969,14856,16936,14888,16969,16969,17001,17001,17001,17001,17001,14888,37902,35789,8485,10597,10596,10597,10564,8484,14725,60645,64933,60580,56356,52297,46288,14757,8484,6371,18951,39950,58900,52530,52364,37638,43813,45764,45667,29123,27075,29285,35557,37605,43813,35654,27204,37934,65370,54609,41962,10628,18983,52463,60847,60914,52594,36049,14725,50646,65502,63028,62700,62700,62766,48365,37928,35880,33768,33736,12708,33543,58867,63126,61013,60947,58769,61045,61046,52430,23209,21325,23405,21357,19309,255},
{55069,55069,55068,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,55101,55101,57149,57149,55101,57149,57149,57148,57148,57148,57148,57148,57148,57148,57116,61211,65338,65337,65337,65337,65338,65338,65338,65338,65338,65273,65272,52726,54839,33775,35887,31662,25323,23243,35822,31629,35789,31629,33709,33677,35789,33709,33741,35757,40048,23568,19310,19050,33709,65370,50547,48336,50482,50417,48402,50450,35823,8582,12743,12743,14856,12775,12776,12775,12775,12775,12775,12775,12775,12775,12743,12776,14888,14856,12808,14856,14888,14888,14888,16936,14888,14920,14888,14888,23209,21097,6404,10565,10597,6437,8517,12645,16804,62821,64933,64837,60548,52198,48235,25158,14692,37509,49958,43783,54511,56754,56588,52167,41733,35460,45796,41733,37605,25157,20997,25221,29317,33542,31429,37902,65370,54641,44075,16934,18984,58867,60914,60947,56722,42095,16805,50547,61178,62962,62700,62668,62798,46284,37896,37896,33768,33768,14821,25255,58867,63126,60980,58834,58769,61046,61046,46156,21129,21325,21325,19277,17229,255},
{55068,55068,55068,55068,55101,55101,55101,55101,55101,55069,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,55101,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57148,57116,61211,65306,65305,65305,65305,65305,65305,65305,65272,65240,65305,61178,54676,65272,50385,50385,31596,42031,29548,39983,31564,39950,31564,37870,33676,35790,35725,42031,37903,33840,19049,33676,65370,54741,50450,52628,52530,50580,52562,37903,8550,12711,12743,12743,12743,14824,14823,16904,16903,16936,16968,19049,19049,21130,23242,25355,25355,27468,27468,31629,29548,31661,33709,33709,35822,37902,29516,21162,25323,19016,19049,19049,16968,19016,12677,18885,62758,64869,64804,58468,49989,33445,29253,31269,60421,60422,45798,48139,56557,54282,54216,50054,41733,49925,54343,48167,27269,23109,29382,27334,31462,20996,35757,65371,56853,46287,25322,23242,54740,60947,58900,56722,41931,18918,54642,50514,62864,62700,62668,62766,44171,37896,52358,46085,37863,19078,23110,56787,63126,56754,50351,54543,61045,61013,41931,21129,23340,21292,19244,17196,255},
{55068,55068,55068,55068,55068,55101,55101,55101,55101,55101,55069,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57116,57116,61211,65306,65305,65305,65305,65305,65240,65240,65273,61178,56821,63160,48305,48337,35887,44176,37903,44176,40016,46289,42128,46321,44209,46322,46289,46354,48434,54708,48434,52628,65337,54741,50417,52660,50482,52628,52562,52660,44241,44274,48402,46321,50482,46354,52595,46354,54708,46321,56788,46289,58869,44241,58901,46321,60981,44176,60981,48401,61014,42063,63094,50481,61014,42030,33644,10662,16936,12743,17001,12808,16936,12677,6404,14692,60709,64836,64805,39555,27043,27108,23110,33414,62566,56327,50023,54279,56295,58345,56072,52040,45829,52036,52134,48102,41894,35622,27301,29382,27301,27269,33676,65371,56788,41930,10531,4291,46255,62961,60914,58802,41931,14725,52758,63192,62798,62668,62668,60751,46186,44006,58499,56387,43941,27430,23174,58899,61046,56754,54642,56689,61045,60980,39818,23209,21227,19179,19212,17164,255},
{55068,55068,55068,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,55101,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,59164,63258,65305,65305,65305,65272,65240,65273,63226,63160,63160,56788,63192,44241,58902,44208,58901,44208,56853,44176,54740,48337,50515,50482,46321,52595,42096,56723,52562,65337,52660,46256,52596,46256,50547,50417,50482,52530,50515,52595,48434,54642,48402,56756,46354,56788,46354,58869,46321,58901,46322,58933,48402,60982,46321,60981,48402,61014,44176,60982,46288,61014,35789,19049,12743,16936,12743,19049,12775,14823,12677,8484,10564,48134,62662,58470,31204,22916,23045,29351,43847,62631,54215,50087,60517,49990,58313,56137,47783,37444,45925,48038,39750,33509,35654,18948,16836,23076,23044,31596,65371,56754,39818,12677,14791,37869,62962,60914,58835,41963,12644,12710,50416,64846,62603,60555,54380,56486,56323,56355,50179,43941,35783,31592,58867,61013,56754,48336,54577,61046,60948,35625,23177,21227,19179,17132,15084,255},
{55068,55068,55068,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,59163,63258,65305,65272,65240,65273,65273,65305,65240,58869,65305,44208,58934,44209,58934,44241,58934,46321,56853,50482,52660,52563,50515,54643,48402,54708,54676,65305,54773,48337,54740,50417,52660,48369,52628,52562,50483,50450,48434,52530,46322,52562,46289,54643,44208,56723,44176,56788,42128,58868,44176,58869,44144,58901,44208,60949,42095,60981,44175,61014,37902,23210,12743,14888,12743,19017,12776,14856,14790,8516,8517,12775,35559,54214,29156,20835,29351,37771,39754,52232,58407,58470,58536,48139,54283,54284,52008,41668,45990,50182,41862,39846,27237,14692,16836,27205,33444,37804,65370,56754,39817,10532,4291,25257,62994,60881,58867,41963,25289,23275,44110,60751,60621,62636,48107,52293,60580,54307,41796,46021,39911,42025,58867,60980,60915,56853,56722,61045,60915,33512,21161,19179,17164,15084,15084,255},
{55068,55069,55068,55068,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,55068,57116,59163,63258,63225,61047,61112,63160,65240,65273,65273,42063,58869,39983,58869,42063,56853,44176,56821,46288,52628,48402,50547,52595,48402,54708,54740,65305,56854,48369,56821,50449,54741,50482,54741,52563,52660,52562,50548,52595,50515,54643,50514,56755,46322,56756,46321,56788,44176,56788,44144,58836,40015,58836,42030,58868,39950,58869,39917,60981,50481,52595,25290,25323,14823,19017,12743,16936,12743,6404,12742,14954,16904,50119,35396,27076,29221,44044,48205,56524,50023,58437,60548,54344,54348,56235,49830,49892,50053,50182,46022,41734,31333,29285,31430,27205,46023,46090,63192,58835,39785,14692,4291,12677,56721,62929,58867,44044,42062,65435,44143,14758,27370,35789,39948,33638,58565,58500,52228,50180,42023,41993,54674,61012,60915,56788,54642,61045,58802,29352,21227,17132,15116,15116,13068,255},
{55068,55069,55069,55068,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57148,57149,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,55035,48631,50678,50547,46288,50547,65338,44209,56821,42063,58869,40015,56821,42031,56789,44111,50580,46256,48434,50417,46289,52562,54740,65305,54773,42062,54708,44143,54708,48337,52660,48337,52628,50417,50547,52530,50547,52595,50515,54675,48434,56756,48434,56788,48369,58836,46321,58869,46289,58869,44176,58901,44143,60949,42063,60981,44143,60981,44110,54707,31499,52595,27403,46256,19016,8484,18984,23275,14856,31528,41766,41702,41734,54543,58669,60584,43848,58469,60580,60613,56391,60199,60135,54055,49991,50086,54246,52038,37605,31333,39750,29349,43976,39785,63192,58868,39785,18820,6371,8452,52496,62928,60947,41898,35724,63257,37837,8517,4356,6502,23144,29479,42023,46183,44038,44038,39976,39880,48303,60980,60947,58834,58769,61046,56656,25257,19245,17197,15149,13069,15116,255},
{55069,55069,55068,55068,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,55036,36084,33873,35952,40014,48434,65338,46322,58901,46289,58934,44209,58934,44209,58902,46288,54741,48369,52628,50482,48466,54643,50547,58900,56886,46288,56821,58966,54773,46256,54708,46256,52627,48304,50515,48337,50482,50449,48402,52530,46321,52562,46289,54675,46289,56755,44208,58836,44176,58836,44176,58869,44176,60981,44176,60981,46288,60981,46256,58901,46223,65272,46289,60948,27337,12612,18951,21130,14856,10695,12743,39850,56557,44012,54248,58473,56424,54278,56390,58533,45990,41702,52203,47912,58704,58572,52069,54214,50118,43910,43910,29382,33447,43948,65338,58834,35657,16740,6371,6371,44142,62961,60947,31465,29418,52725,39983,27108,27076,20900,14757,33639,27463,35913,25383,23238,40008,35752,41998,60947,58834,58802,58802,61045,52430,25257,21325,17197,17196,15149,15117,255},
{53021,55068,55068,55068,55068,55068,55101,55069,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,52890,33970,40146,35952,46255,52594,65370,42161,56821,42128,58869,44176,58901,46289,58934,46289,54773,50482,54740,52595,52628,52628,54773,63159,56886,48369,58934,61015,58934,48369,56853,50449,56821,50450,54708,50449,52627,50449,52660,54642,46321,52530,46289,54610,46256,54675,40015,54675,42063,58836,42095,58869,42031,60949,42030,60981,44175,60949,44111,58869,44143,65207,46288,58868,44176,8451,8517,27338,27338,8582,8616,25289,63092,46224,56426,60585,62696,43847,41767,60616,54443,45960,39882,33641,58899,60620,51973,52102,48038,50118,39750,35655,37607,43980,65371,58835,33577,20868,10499,4291,35723,62928,58867,23111,25192,35887,48171,58307,56099,43748,10532,33607,23173,33736,31623,29349,48263,39913,39917,60882,58866,58801,58801,61013,48172,23176,23340,19212,17164,17164,15116,255},
{53021,55069,55068,55068,55068,55068,55101,55069,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,52825,42226,42193,42160,40015,31662,54577,54609,52693,63193,52628,54578,56658,61047,61079,48435,46420,40179,40146,40114,38033,35985,46419,65305,56854,50450,58869,61014,58934,48369,56821,48369,56821,50449,52660,50482,50547,52595,58999,58869,56788,56756,58869,58966,63192,63127,63192,65338,63160,40015,33741,33709,31629,31629,29516,27435,27435,25291,23275,21130,35854,27435,16936,14856,16936,14790,8549,18984,23275,21163,21196,25256,54607,41996,56723,60750,64809,47942,47942,54280,52431,52461,39882,48334,60914,58474,52006,50054,50086,56423,46022,41896,37607,44012,65339,58867,35658,41900,23046,4259,39719,58505,54476,27173,23079,46387,54541,64739,58306,37540,21032,39915,23174,31625,50345,58436,60581,52462,44110,58769,58801,58769,58802,61013,43946,27239,25290,21227,19180,19212,15116,255},
{53021,55069,55068,55068,55068,55068,55068,55101,55101,55069,55069,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,55101,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,42390,35953,40081,38033,38000,19245,46225,52595,37968,54806,44176,50255,56560,60884,63192,65338,52758,36019,36018,35986,35953,35953,38066,42226,40048,33677,31531,35757,29483,29418,25258,25258,25192,25192,23144,21065,18952,18984,35790,60754,60624,48239,37804,41998,50515,42095,40048,40080,29581,6469,4357,4356,4357,4389,4357,4389,4422,4422,4390,4390,23242,19114,6502,10695,16903,39982,42095,27468,29777,23243,33709,50314,35622,29383,48401,42063,58472,62599,58373,52265,58900,63093,56755,54541,60914,56393,49893,39557,33348,35493,52327,41928,39883,46223,65339,58835,35658,27402,27402,14660,41669,56325,45927,25093,25093,35821,50382,64709,56258,29124,29321,41930,45957,52165,62758,62659,58436,56688,50351,58769,58834,58769,58834,60980,43914,27206,25257,21194,19179,19180,15084,255},
{53021,55069,55068,55068,55068,55068,55068,55101,55101,55101,55069,55069,55069,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,50809,38098,38033,46387,40080,29646,46225,46321,38000,52595,56592,54413,56494,58738,63192,63160,54839,35986,33905,33938,33906,33905,33873,35953,29647,25355,25258,25290,16936,18887,16839,16839,16839,16839,18919,16871,14791,14758,21064,58511,60689,35758,12710,10565,8517,6437,4357,4356,4356,6437,6438,6469,6437,6437,6437,6470,6470,6502,6502,6470,21130,33742,17002,31693,33705,37965,46353,37967,38131,25355,46025,46120,41960,39753,39949,39982,39852,50054,62598,41833,50515,50515,54708,56754,60882,58505,56295,49926,41669,29220,43910,35623,33479,43980,63290,58835,37771,6371,14660,43846,45926,52198,48039,29253,25092,8418,25094,37477,54313,54281,50152,54342,62659,62594,62692,62627,60483,56656,54478,58768,60915,58736,58835,60947,39721,29254,25257,21162,21227,19180,15084,255},
{53021,55069,55068,55068,55068,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,48761,40211,40146,52628,54609,42062,35854,46255,42126,39981,48304,54413,62898,62996,56788,39949,46452,44372,42292,44372,44372,44404,46485,46452,33872,25388,25322,25323,19049,20935,18887,16871,16871,16871,18919,16871,14791,14791,14791,25128,39951,29549,12711,6535,6502,6502,6470,6502,6470,6470,6470,6470,6469,6437,6437,6437,6470,6469,8615,6502,12776,27436,6502,6502,23207,25351,23175,35788,46419,44240,50214,44039,37800,43946,39819,50384,50514,14726,35461,29352,48434,54772,54707,58900,63028,54640,48135,52070,45862,37606,27236,29350,37671,43979,63258,58900,39884,6404,29221,50053,39685,43845,50118,31332,35460,41996,25192,27011,60484,56195,60420,64739,62628,62627,62692,64803,62722,62926,56656,60882,60915,56656,58867,58834,33447,29286,25257,21194,21195,17132,17132,255},
{53021,55069,55068,55068,55068,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57148,57148,57148,57148,57148,57149,48729,36018,38066,50580,48368,42095,46321,50480,48334,29580,42162,46126,65141,58901,48467,48435,52694,59098,59097,59097,61178,59097,59130,56984,38033,25355,25290,27403,19049,18887,18887,16871,16839,16839,16839,14759,12711,14791,16839,10598,23210,25323,10598,8550,6470,6469,6469,8517,6437,8517,8485,6437,6437,6437,6437,6437,6437,6437,8583,6502,8582,25388,8583,6502,14921,29547,35820,29515,39950,48369,48070,43942,37767,29447,18917,16805,37803,21096,6437,8582,40048,56820,54740,54740,58966,54805,41962,45927,41897,33478,27302,33543,41928,46123,63226,58900,41996,12644,39621,50085,39685,37638,29252,27107,29187,33446,27108,20835,56323,60482,60451,62692,64870,64835,58564,58533,64869,62925,60915,60947,60915,58703,60948,58704,33415,29320,23210,19147,19147,15084,15084,255},
{53021,55069,55068,55068,55068,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,55101,57148,57148,57148,57148,57148,57148,57116,57148,57116,57116,57116,55068,55003,52923,52922,52890,52890,50809,50744,40211,42129,46322,42030,37837,37837,44077,39787,27305,33677,33514,37675,35627,31532,25323,25323,27436,25356,25355,25323,23242,21130,19017,14824,10630,12710,12711,10598,10598,16871,14758,14791,12743,10598,6437,6437,18951,16871,6437,6405,6405,8485,8485,6437,6437,6437,6437,6437,6437,6437,6405,6437,6404,8582,4389,4389,6437,10695,8615,8550,21195,10695,10663,6535,23275,50579,35693,35595,44176,50151,50151,33610,27239,12644,6403,14757,29483,12776,8583,25388,52660,54773,54741,56919,56885,50218,48071,39849,42027,39947,37835,37834,44173,63258,61013,44076,45992,52166,50085,35524,33477,20964,31300,31299,33283,35397,18788,33348,52131,64738,62760,60878,58699,52426,46087,52363,63028,60947,60947,60915,58801,60980,56558,27239,25257,21162,17067,17099,13004,10988,255},
{53021,55069,55068,55068,55068,55068,55068,55100,55101,55069,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,57148,39919,27273,23210,16937,25161,33515,29321,29321,27241,27176,27143,27143,27111,25095,25095,25063,27111,25063,25030,22982,22982,12646,8518,8518,8517,8517,8518,8517,10598,10598,10598,10598,12678,12646,10598,10598,12646,18919,18886,16806,16871,16806,8517,10565,14726,14758,10598,10598,10565,10565,10566,10598,10598,12645,10565,10565,12613,8485,10533,10565,6437,8582,4389,4357,12775,14856,17034,23275,23275,8615,8583,8615,16969,31595,18984,42031,40015,25223,33576,29450,33611,16870,8484,12710,37870,16871,12776,19180,25388,50548,56853,58967,48465,44009,50151,39814,41927,44040,37702,37734,37768,61145,61014,44109,39719,50149,52197,35492,41765,33445,31301,35396,41605,29124,18820,10532,25027,52100,54411,58835,56788,56721,50381,39885,60981,60915,60947,56722,50253,61013,52397,23111,19114,19114,15019,15051,13004,10956,255},
{53021,55069,55069,55068,55068,55068,55068,55101,55101,55069,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57148,57148,57148,57148,57148,57116,57116,57116,57116,57116,39757,27143,35888,19050,25031,33450,31304,31337,31337,29224,27143,27143,27143,27143,27143,27143,27111,25063,27111,25063,16806,10598,10598,10598,10598,10598,10598,10598,10598,14726,14726,14758,14726,10598,10598,10598,14694,20967,18886,20966,18886,18854,10598,12646,16774,12678,14758,14758,14726,14758,16806,12678,12678,14726,12711,10630,12711,12743,14823,14791,10696,10695,10663,8615,10663,8582,10663,6469,16969,8615,6502,6534,14888,29548,14824,23275,40014,23239,23241,25354,40081,35887,16968,14789,23176,16936,23308,27501,44339,54838,58999,56853,46354,44009,54440,37670,33477,43910,43943,39750,29350,59032,61046,46189,29415,43942,52132,41765,43878,52103,39590,39525,43653,27012,16740,14693,12645,14627,41670,58736,58900,58867,56754,37837,58900,63060,60948,60882,56656,61013,48140,21031,19114,19114,15018,15019,13003,13004,255},
{53021,53021,55069,55068,55068,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,55101,55101,57149,57149,57149,57149,57149,57148,57148,57148,57148,57116,57116,57116,57116,57149,41837,29224,35920,21195,25063,35497,33384,33417,31304,29224,29224,27143,29191,27143,27143,27143,27143,25063,25063,18887,10598,10598,10598,10598,10598,10598,10598,10598,10598,14726,12678,12678,10598,10598,10598,10598,12646,18886,23014,20934,18886,20902,10566,10565,16774,12678,12678,14726,12678,12678,14726,12678,12678,12646,8583,8550,8518,8550,8550,8518,16969,16937,8550,14856,19017,16969,10663,6469,14889,10695,4421,17066,29711,33709,16935,18983,25288,27431,21126,23209,27434,25321,14887,18982,19048,14856,14889,25323,63160,58933,61112,52628,39950,50546,56619,50247,50247,54344,50151,52295,41895,61112,61046,46190,29415,39847,52230,39686,45896,60457,54184,47845,53989,45636,43653,22949,10565,12612,37510,58604,60947,58736,56721,39917,56754,60980,61012,60882,60881,61012,46026,23111,21129,19114,17066,15019,13003,13003,255},
{53021,53021,55068,55068,55068,55068,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,55101,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57116,57116,57116,57116,57149,41902,27111,29484,19017,27111,35497,35432,35497,33384,29223,29223,29191,29191,29223,27143,27111,27111,27111,22982,12646,10598,10598,10598,10598,10598,10598,10598,10630,10598,10598,10598,10598,10598,12646,12646,12646,10598,18886,20902,20934,18854,20902,8485,8485,12613,12678,16806,14726,12645,10597,10565,10565,10565,10597,8550,8517,8485,8485,8485,6437,10662,33708,21162,23275,25355,21162,14856,8549,10662,10662,8550,17002,27566,35789,25255,21095,21094,29544,27464,23239,21127,21062,10596,21127,10629,10663,10695,16936,61080,58933,58933,61113,54027,48013,58897,56553,50215,52360,50312,48167,46087,59031,61047,46222,23078,43944,58473,52169,47944,58345,62569,54053,51876,54021,54054,27076,16806,16773,41768,54279,64839,58567,56720,35724,52495,60915,63060,60882,60914,60948,41833,25159,23177,19114,17066,15019,15051,13004,255},
{53021,55069,55068,55068,55068,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57148,57148,57148,57148,57148,57148,57116,57116,57116,57116,57149,41902,29191,29549,19082,27111,35497,35432,33417,31272,31272,29191,29191,31239,29191,27143,29159,27111,25063,14726,10598,10598,10598,10598,10598,10598,10598,10598,12678,10598,10598,12678,12678,10598,8518,8517,14726,14791,18951,18919,16871,14791,16839,12711,10663,12743,12743,14823,14823,14823,14823,12775,12775,12775,12775,12776,10727,10728,12775,12775,12775,12776,14855,14856,16968,14888,14856,12775,12710,12710,12710,10662,10630,10630,14790,19015,23175,23206,33736,33769,27464,25351,25351,31594,27369,10630,8615,14823,14823,46354,52660,52595,56886,62381,54091,56853,58867,54377,54473,54504,48200,50280,61111,61079,46189,18917,37639,60587,49959,49992,52104,58442,58247,54021,54085,54118,24963,18853,16772,45961,58504,64804,62726,58734,39852,52398,58866,63060,60881,60882,60915,39688,27239,25224,21161,19114,17066,15051,13003,255},
{53021,55069,55068,55068,55068,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57116,57116,57116,57148,55035,41837,29159,33775,19082,27079,37545,33352,35465,31304,31239,27143,27143,27111,27143,23015,22982,23015,16806,10598,8550,8550,8550,8550,8550,8550,8550,8550,8550,8550,10630,10630,10630,10630,10630,10598,14856,14953,12840,10792,12840,10760,12840,10760,10760,10792,10760,12840,12840,10760,10760,12840,12841,12808,10727,10727,10727,10727,10727,10695,12775,10727,10727,10695,10727,10695,10695,12743,10662,10662,10662,10630,10630,10630,10662,10630,16902,21127,25320,23240,21127,21159,19047,25321,14790,12711,8549,12742,25322,35854,35822,54675,56854,61047,58868,50514,56853,54607,37832,35786,42060,50346,61111,61079,44077,27270,41864,54282,52040,54184,52169,58475,54087,43653,39589,58342,29221,31432,37673,54380,60651,62761,62727,62859,56591,56591,58834,60980,60947,60947,60882,35527,27239,25257,21162,19114,17066,15051,13003,255},
{53021,55069,55068,55068,55068,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,55101,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57116,57116,57116,57148,57018,39658,29224,33807,19082,25030,37545,35400,33417,33384,29224,14791,12711,10631,10695,12808,14856,10663,10631,10630,8550,8583,8550,8583,8583,8583,6502,8583,8615,8615,10695,10663,10663,10695,10663,10663,19147,12905,10760,8680,10728,10760,10760,10728,10728,10760,10760,12873,12840,12808,10727,10728,19114,12808,10695,10695,10663,12775,10695,12775,10663,12775,10695,12775,12775,12743,14823,10662,14824,10630,14856,10630,14856,10630,14823,12710,12710,12742,10630,12743,8517,14823,10565,14823,10597,16903,19049,6436,16903,23176,18983,52561,46289,59064,56885,42094,50547,52627,25060,35658,42126,39946,58966,61112,39916,27238,48203,52234,54184,47912,50089,54217,56231,41572,22947,39587,47975,39753,46027,58703,60683,62759,64805,62925,58736,58834,58866,60882,58802,61013,58769,31366,29287,25225,21162,17066,15018,15019,13003,255},
{53021,55069,55068,55068,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57148,57148,57148,57148,57148,57116,57116,57148,59098,43851,29224,31662,19050,25031,35497,33352,33385,31304,29224,12743,10663,10663,8615,10696,10728,10696,10663,8615,10663,10728,12841,10695,8583,8615,8615,10695,14954,14889,17001,14856,12776,12776,12776,12776,23308,14986,10792,10760,10728,10760,10793,10728,10728,10760,10728,12840,10728,10727,10727,10727,12808,14888,8582,10695,10630,12776,10630,12710,10630,10630,12743,8517,12775,8484,12775,8485,12775,8517,12710,10597,10630,10630,10598,12710,10597,12743,10597,14823,8517,12743,10565,12710,10597,12710,21194,8484,12710,31660,31660,52627,48467,61144,54773,37901,46354,50548,20836,33414,35720,31559,50580,63193,37804,20998,35691,54346,58377,52137,58410,62635,60423,56132,24963,29220,45863,50154,52234,48074,56424,64871,62760,60912,56624,58802,60980,58834,58736,61013,54543,29254,27239,23177,21162,17066,15019,12971,13003,255},
{53021,55069,55069,55068,55068,55068,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55069,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57148,57148,57148,57148,57116,57116,57116,57148,54937,43884,29191,31597,25291,27079,33449,31304,31336,31304,27143,37772,27339,8615,8647,8647,10728,10696,8647,8647,10695,10728,10727,12776,10695,8615,12841,10728,19147,16969,14954,12776,10728,12776,10695,10695,25420,14986,10760,10792,10760,10760,10792,10728,10760,10760,10760,12840,10695,10728,8647,10727,14888,21097,10630,14823,10630,12743,12710,12710,12743,10597,12743,12677,12775,10597,12743,10597,12743,12678,12710,12710,10630,12710,10597,12743,10565,12743,10597,14823,10597,12743,10597,12710,12678,12743,16936,12776,21162,31594,40079,48336,54675,61079,50546,31529,44142,58966,25322,14822,33707,35852,48532,63225,35756,25322,42128,58607,62667,60457,62602,64812,64714,64550,56198,41605,43783,48074,52235,48009,48072,60813,52464,56689,56655,58801,60947,60915,58736,61013,52397,27174,27272,21162,19114,15018,12970,12971,13003,255},
{55069,55069,55069,55068,55068,55068,55068,55068,55101,55101,55069,55069,55101,55069,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57149,57149,57148,57148,57116,57116,57116,57116,57116,40017,37448,33287,29191,31239,35335,41674,39561,39593,41641,37513,33677,23210,8615,10663,10696,10696,10728,10696,8615,10728,12808,12776,10728,10663,8615,10695,10728,14889,14856,14921,14856,10695,12743,10728,10727,27533,19211,12840,10728,10728,10727,10760,10728,10760,10728,10760,10760,10760,10760,10760,10727,16969,23210,10598,14791,10630,12710,12710,10630,12743,8517,12775,10597,12775,10597,12775,12677,12743,12710,12710,12742,10630,14791,10597,12743,10597,14823,12678,14823,12677,12710,10630,10598,12710,42193,59032,36083,33872,48466,44273,37869,52595,61014,56886,52595,50415,58901,42160,16869,29352,25321,44274,65306,35756,25289,52627,56821,54349,60392,60521,64877,64745,49957,45829,50023,45961,43946,41965,58570,60679,62861,54674,52463,56656,58801,60914,58834,58768,61045,48172,25159,23209,19114,17067,15019,12971,12971,10955,255},
{53021,53021,53021,55068,55068,55068,55068,55068,55101,55101,55101,55101,55101,55069,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57148,57148,57117,57148,57148,57116,57116,57116,57116,55068,50711,56464,60364,60364,60332,62510,56236,58381,52108,52075,45867,35888,23308,8615,10695,10728,10696,10728,10728,8615,10728,17001,12841,10695,10663,8615,8583,10695,17034,17001,10728,12776,12776,12743,10695,10695,29646,21259,10792,10728,10760,10825,10793,10760,10825,10793,12873,10792,12905,10792,12840,10792,19146,29516,12710,14823,12710,10662,12743,10629,12775,10565,14823,10597,12775,10597,12743,12678,14790,12742,10630,14791,12678,14823,10597,14823,8517,12775,12677,14791,14758,12710,12710,10597,16871,44241,37968,38196,29777,40080,39850,37574,50220,48107,48368,31530,41995,54642,52660,12677,14692,10531,37935,65338,33709,23144,50612,37903,41737,31270,31432,60815,62766,41670,12514,12612,41801,43914,46026,60551,62693,64973,58769,52365,58737,58801,60882,58769,58769,63060,43946,21064,21162,17099,15019,12971,12971,10923,10923,255},
{55069,53021,55069,55068,55068,55068,55068,55068,55068,55101,55101,55101,55101,55101,55101,55069,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57148,57149,57149,57148,57148,57116,57116,57116,57116,57116,62867,64524,64492,64492,64589,52173,58381,45834,50027,39886,31727,21227,8615,10663,10663,10695,10696,8647,8647,10728,12808,12808,10663,8615,8615,8583,8583,10695,12808,10728,12776,12808,10695,10695,10695,25453,19147,10792,10760,10760,12808,12873,12873,12873,10792,12873,12840,12873,12840,12840,12840,23242,31596,12743,14791,12743,10630,12775,12678,12776,10629,14824,12677,14823,12677,12743,12710,12710,14791,10630,14823,12645,14823,10565,12775,10597,14823,10629,12710,12710,12678,12710,8517,18984,46288,12743,21195,23340,18918,37542,49926,49991,37444,43847,23143,25223,46222,58933,23210,6436,8451,31661,65338,35821,18983,31661,25355,25322,23275,29483,58703,56755,39721,18787,8452,39851,44012,54347,62729,58503,58668,58834,54478,58736,58769,58833,60816,60882,60980,37705,19017,17066,15051,15051,12971,10923,10923,8875,255},
{53021,53021,55069,55068,55068,55068,55068,55068,55068,55101,55101,55101,55069,55069,55069,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,55101,55101,55101,57149,57149,57149,57149,57148,57116,57148,57148,57116,57116,57148,55036,58641,64524,64492,64492,64589,54253,56301,47914,54285,56952,21228,8647,10728,10728,10728,10761,10760,10760,10760,12841,12906,10793,10793,10760,10760,10793,10761,12841,14921,12841,12841,12841,17034,14921,8647,17067,14986,10760,10760,10760,10792,12873,12873,12873,10792,12873,12840,12873,10825,17001,27729,21586,25486,12775,12775,12775,10663,12776,10597,12808,10565,14823,12678,12743,12710,12710,12743,12678,14823,10597,14823,10597,14823,10597,14791,10630,12710,12678,12710,14790,10597,12743,8484,21064,50449,16936,8517,12710,41607,56039,49894,47845,41605,54380,37835,25256,44174,58933,40080,6436,12708,31661,61177,31661,16838,8451,4323,6404,4356,12677,56558,56755,39753,20900,6371,18951,18951,31498,56656,54312,58636,60915,58736,58801,58801,58801,58736,58900,60947,31432,16969,15019,12971,13003,10923,8875,8875,8875,255},
{53021,53021,55069,55068,55068,55068,55068,55101,55101,55101,55101,55101,55101,55069,55069,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,55101,55101,55101,57148,57148,57149,57149,57148,57116,57116,57148,57116,57116,57148,55003,58577,64524,64492,64492,64557,52205,56333,45769,54253,54839,25519,12906,10793,12971,12938,10825,10793,10793,10825,10793,10793,12906,12841,17002,17034,10825,10793,8744,10792,10955,10955,8940,11085,11053,11085,19309,17067,8647,10728,10727,10728,10760,10760,10760,10727,10728,8647,10728,10695,10663,23568,17556,23536,12743,10630,12775,8582,12776,10597,14856,10597,12743,12678,12710,12710,12678,12743,10597,14823,8517,12775,10597,14823,10629,12743,10630,12710,12710,10629,14823,10565,12775,8484,23177,54609,21162,10630,16903,43687,56038,51909,49925,45766,43881,48170,41963,46157,52463,50514,23210,12709,29548,54904,27501,16870,25290,8484,6404,6437,10597,52365,58867,39786,18885,14790,37772,39916,41932,50253,58537,60847,58867,58769,58834,58801,58768,56624,58901,60882,31400,17001,14986,10923,8875,8875,8843,8875,8843,255},
{53021,53021,55069,55068,55068,55068,55068,55068,55101,55101,55101,55101,55101,55101,55069,55101,55101,55101,55101,55101,55101,55101,55101,55101,55100,55101,55101,55101,55101,55101,57149,57149,57148,57149,57116,57116,57116,57116,57116,57116,57116,57116,60754,64524,62412,62412,64557,54285,56301,43722,52238,54807,29777,10826,8680,10858,10826,10793,8713,10760,10793,10761,8745,23405,17035,10826,14986,8745,8712,8745,8745,11020,8940,9005,7054,9070,9070,17261,19179,10760,10760,10760,8615,8583,8615,8615,6567,8615,8582,8615,8583,10695,44405,50777,40245,14823,10598,12775,8517,12775,10597,12775,10597,12743,12710,12710,12743,12678,14823,10597,14823,8517,12775,10597,12743,10630,12710,12710,10630,12743,10597,14823,8517,12743,8452,25257,56657,25355,8517,16871,41640,56103,58151,49829,58376,50317,44435,56718,50252,52495,61046,31628,6436,27403,52759,35888,18951,48369,25355,14823,8550,8549,50219,60915,39851,23046,12678,18984,23210,23209,33611,52297,63059,58867,58769,60914,58834,58768,58803,58932,58704,27239,14921,12906,10891,8875,6827,6795,6827,6795,255},
{53021,53021,55068,55068,55068,55068,55068,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55069,55101,55101,55101,55100,55101,55101,55101,55101,55101,55101,57149,57149,57149,57116,57148,57148,57116,57116,57116,57116,57116,57116,55068,58707,64525,62411,62411,64525,54220,54221,45802,52108,52531,29745,8778,8680,12938,10858,10793,10793,10826,8713,8745,10826,19147,14921,21195,21260,8745,8810,6729,8777,11020,8972,9005,6989,4909,6957,13068,15084,8647,10727,8615,8583,8583,6535,6567,8615,8615,8582,8615,6534,14953,52759,63291,50711,14856,10597,14824,8517,12775,10597,12743,12678,12742,12710,10597,12775,12677,14855,10597,14823,8517,12775,12677,12710,10630,10630,12743,12678,14823,8517,12775,8485,12743,8484,21031,54576,31628,6436,10630,29191,53992,49927,52038,58473,52658,48824,65099,52300,58801,61112,29483,6469,19081,56952,52693,16870,39917,29515,4291,6371,6372,43978,60948,41964,27206,8484,6371,4291,4291,4226,14692,56753,58866,58801,58834,60881,60881,58900,60947,54478,23079,12840,10825,8810,6795,6795,6795,6795,6795,255},
{53021,53021,55068,55068,55068,55068,55068,55068,55068,55101,55101,55101,55101,55101,55069,55101,55101,55101,55069,55101,55101,55101,55100,55101,55101,55101,55101,55101,55101,57149,57149,57149,57148,57148,57148,57116,57116,57116,57116,57116,57116,57149,58838,64525,60592,58609,62477,56333,56333,43754,49995,47947,35920,10890,8712,10826,10825,8713,12938,15084,8713,10793,12938,15019,12874,17066,17099,10825,8745,8680,8680,8907,8940,6989,6957,6957,6957,8842,10825,8680,8647,8583,8582,6567,8615,8615,8615,8615,8647,8615,8615,17001,54871,63324,56985,16969,8549,14856,10597,12775,10630,10695,12710,12710,12743,10597,12775,10597,14823,10597,12775,10597,12743,12678,12710,12710,10597,12743,10629,12775,8485,12775,8485,12743,8517,14790,52430,35822,8517,12743,14791,18918,27367,31528,44044,42322,40599,65066,56524,56689,50515,31596,10630,16936,56984,54773,16871,27337,46288,6404,6371,4291,39785,62995,44077,29319,10531,6339,6339,10597,14791,12743,46256,58900,58802,58801,60848,58867,58899,60980,50285,20998,12808,10825,8810,6795,6795,6795,6795,6827,255},
{53021,53021,55069,55068,55068,55068,55068,55068,55068,55068,55068,55101,55069,55101,55101,55101,55069,55069,55101,55101,55101,55101,55101,55100,55101,55101,55101,55101,55101,57149,57149,57149,57148,57149,57148,57116,57116,57116,57116,57116,57116,55101,59001,64557,58739,59000,62510,54221,54221,45802,49995,45802,39918,12971,10761,19147,19180,10793,15051,17197,14986,12906,12906,14954,19408,17425,31793,10825,8744,8712,8647,8907,8972,6957,6957,6957,6989,6730,8713,10728,8583,8582,8615,6567,8615,8615,8615,8615,8647,12808,14856,14888,50613,65404,61211,19114,8549,14856,10597,12743,10598,10630,12710,8550,12775,8517,12775,8517,12775,10597,12775,12710,12775,12710,10630,12743,8517,12743,10597,12775,6437,12743,8517,10662,8517,12678,48270,42095,8517,14823,14856,14823,21030,16837,16804,23306,36277,54703,54444,54674,50481,52530,19017,12711,52726,58966,19016,18918,44175,14823,8549,6469,35624,62962,46223,29319,12612,6371,6371,8517,12710,10597,31596,60980,58801,60849,60882,56786,54576,60980,48172,16838,12775,10793,8778,6762,6795,6795,6827,6827,255},
{53021,53021,55069,55068,55068,55068,55068,55068,55068,55101,55101,55101,55101,55101,55069,55069,55101,55101,55069,55101,55101,55069,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57148,57116,57116,57116,57116,57116,57148,57149,59034,64590,60592,56789,62510,54253,52140,45834,49995,45801,41999,12939,14921,14986,15018,12873,12841,12841,12841,12808,12808,17001,23634,17523,29810,10825,8809,8810,8874,6892,6892,6957,4909,4909,8972,10923,10858,8647,8582,8615,8615,6534,8583,8583,8615,8615,8615,8582,8582,14889,46452,65437,63324,23307,10598,14855,10630,10695,12743,10695,12743,10630,12775,8549,12808,8517,12775,10597,12743,12710,12743,10662,8549,12775,8517,12775,8485,12775,8485,12743,8550,10630,10598,10565,44077,46288,8549,10630,25093,25125,20997,21062,16901,14788,36147,40536,48237,50514,41961,46253,42226,23275,44405,61079,21129,16838,10564,8549,8550,6469,31400,60882,48336,27271,14724,6371,6404,6372,4323,4323,14790,56786,58801,60817,58867,58834,52496,60980,43946,16838,12775,10792,8777,8810,6794,6795,6795,6795,255},
{53021,53021,53021,55069,55068,55068,55068,55068,55068,55101,55101,55101,55101,55101,55069,55069,55101,55101,55069,55069,55069,55101,55100,55100,55100,55101,55101,55101,55101,57149,57149,57148,57149,57149,57148,57116,57116,57116,57116,57148,55036,52955,56920,62477,56463,54709,58284,56301,52107,45834,49995,45802,37740,10793,8648,10858,12971,12906,10793,10793,10760,10728,10728,17066,25747,17555,17425,10825,17066,17066,14985,13133,13165,15116,10858,8810,12873,12840,10793,8582,6535,6535,8582,8582,8583,8583,8615,8615,8615,8615,8583,23307,48598,65469,65436,25388,10630,12776,10663,10728,12743,10630,12775,10597,12776,8517,12808,8517,12743,10598,10663,12742,10662,12743,8517,12775,8485,12775,8485,12775,8517,10663,10598,8550,10630,8484,39819,50416,12711,14758,39622,33542,31430,25222,23174,23109,34033,42649,33610,39982,27370,14823,50547,19016,35986,58999,27435,16838,10565,14823,6404,4324,25159,58769,50449,27272,18885,6371,6404,6404,6372,6404,6404,48368,60914,58834,58867,60947,60914,60947,37673,14790,12775,10760,10793,8810,6762,6795,6827,6827,255},
{53021,53021,53021,55069,55069,55068,55068,55101,55101,55068,55101,55101,55101,55101,55069,55069,55101,55101,55101,55069,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57148,57148,57148,57116,57148,50810,23536,25583,50483,60396,52238,54871,54123,58381,52140,47882,49994,45801,39755,21097,18985,23178,25323,23210,25226,27274,27273,29354,31402,33644,36148,15475,23699,31857,48532,46452,29581,50678,56985,31727,10793,12971,14986,12776,10760,6535,6535,6534,6534,8582,8615,8615,8583,8615,8615,10728,10728,23340,48630,61243,59065,25356,10598,12743,10630,8582,12743,8517,12775,8517,12776,8517,12775,8549,10663,10662,10662,12743,10630,12775,8517,12776,8485,12743,8517,10695,8549,10630,10630,8517,10662,8484,33610,52497,16936,12710,33382,35493,35558,29414,27334,27301,31985,36472,40015,25224,18951,21096,46321,16936,27599,59064,33709,14790,16870,42127,8484,4323,20966,58672,52594,25192,39851,25289,4259,14758,14758,6372,4324,31530,60914,58834,60947,63027,60979,58834,33447,14758,12775,12808,10793,8778,6762,6795,6827,6827,255},
{53021,53021,53021,55069,55069,55068,55068,55101,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55069,55069,55101,55101,55101,55101,55101,57149,55101,57149,57149,57149,57116,57148,57116,57148,57148,57116,36084,8713,23341,50450,60397,54416,52758,56236,58381,52173,45867,49995,45769,50059,52108,43754,45834,47915,43721,47914,49995,45834,47882,49962,41836,40341,17555,23666,36050,52757,52758,38065,54839,61178,33937,10858,12971,12906,12808,12808,8615,6534,8583,8583,8582,8615,8615,8615,8583,8583,8583,8615,10695,48598,65404,63291,27501,10630,12743,10662,8550,12743,8517,12776,8485,12776,8517,10695,10597,10630,12710,10630,12775,10629,12775,6437,12776,8485,12743,8517,10663,10630,8550,10663,8517,10663,6404,29450,54576,21129,8517,12710,29319,33510,25254,27302,25254,37901,48238,39851,31431,27304,21096,37902,31629,27534,59032,37967,14822,12677,37837,16936,8484,16805,56526,56755,23144,33545,25224,4324,12677,16870,4324,4324,14758,56722,60915,63093,61012,60947,58769,27206,12709,12742,10760,10792,8777,6762,6795,6827,6827,255},
{53021,53021,53021,55069,55069,55068,55068,55068,55068,55101,55101,55101,55069,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55100,55101,55101,55101,57149,55101,57149,57149,57149,57149,57116,57148,57116,54937,44372,31759,12906,23373,50515,60461,52239,52694,56236,60429,52172,49995,49963,43689,52075,54155,43689,45801,47882,43689,47881,49962,45802,47883,47947,43754,46388,17555,21553,36049,59064,56984,48564,54871,59098,36018,10858,12971,12938,10760,12841,8583,6534,8582,8582,8583,8615,8582,8615,8582,8615,6534,8615,10663,48533,65437,65437,31727,10630,12743,10663,8517,12775,8517,12776,8485,10695,8517,10663,10630,10630,12743,10598,12775,10597,12775,6469,12776,10565,10695,8550,10630,10662,8549,12743,8485,12743,6404,25224,54512,25355,8485,16904,12678,27335,33639,37638,41668,39653,47909,31432,33643,27435,27435,40080,46419,31727,52791,44273,14790,12645,23176,25322,8549,12612,52332,56819,21064,20998,6404,6404,6371,8484,6372,6404,4356,39949,58802,65206,60980,60914,56656,23045,10629,12710,10727,10760,8745,6730,6762,6827,6827,255},
{53021,53021,55069,53021,55069,55068,55068,55068,55068,55068,55101,55101,55069,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55100,55101,55101,55101,55101,55101,55101,57149,57149,57149,57148,57116,57116,57116,59131,59065,48533,29646,42193,63193,62770,52238,54383,58479,60690,56529,56529,56497,52368,56626,56626,54546,56626,56627,54611,58772,58804,54578,52563,58967,59000,56985,52889,52824,40210,50677,48597,33871,52791,59129,40179,10858,15052,12938,10760,12841,8615,8582,8582,8582,6535,8583,8582,8582,8582,8615,6534,8615,8550,33807,65436,65437,35953,10630,12743,12743,8582,12776,8485,12776,8517,10695,10598,10630,10662,8550,12743,10597,12775,10597,12776,8517,12775,10630,10662,10630,8549,10663,8517,12775,8485,12743,6436,18983,54512,31629,8517,16968,14855,19015,39656,60324,60387,41570,50055,39752,31365,25126,20965,23176,42160,25388,48598,50547,14823,14758,10565,21129,8550,10565,46059,58867,21096,21030,8517,4324,6372,6404,6372,6372,4324,23177,35723,65239,60914,60881,54511,20933,10597,10629,10695,10728,8745,6729,6762,6795,6827,255},
{53021,53021,53021,53021,53021,55069,55068,55068,55068,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55100,55100,55101,55101,55101,55101,55101,57149,57149,57149,57148,57116,57116,57116,55100,57149,48696,31760,44274,65337,65305,65305,65305,63258,63225,63193,61177,63225,63225,63225,61112,63225,63225,61177,63225,61145,42259,21293,40178,56952,59032,59097,65404,61211,40243,50645,48532,29646,52758,61146,40211,12938,12971,12938,10760,12841,8615,8582,8550,8582,6534,8582,8582,8582,8583,8583,8582,8614,6502,25420,65372,65404,44339,10663,10663,12775,8550,12808,8485,12775,8517,10695,10630,10630,12743,8517,12775,10597,14856,8517,12776,8517,10695,10630,10630,10630,8517,10695,8485,12776,8517,12743,6437,16871,52430,35854,6437,12743,12743,18919,53829,62435,60419,39523,50120,41733,43748,33380,33445,25192,40015,31629,42324,54740,16904,14790,6371,14823,8582,10597,39753,39916,23209,21030,10564,4291,6372,6372,4324,4323,4324,10597,10597,39982,60946,60881,50285,16804,12677,10629,10694,10728,8712,8745,6762,6795,6827,255},
{53021,53021,53021,53021,53021,55068,55068,55068,55068,55068,55068,55068,55101,55101,55101,55069,55101,55101,55101,55101,55101,55101,55101,55101,55100,55101,55101,55101,55101,55101,57149,57149,57149,57148,57148,57116,57116,57116,55068,55068,46649,46583,63258,65305,65305,65305,63258,63225,61113,61112,61145,61145,61144,61079,61112,61112,61144,59032,25486,8811,6698,31759,61079,58999,50613,65404,61210,40243,54839,50678,23372,52758,61210,42291,12905,10857,10825,12873,23340,10728,8582,8582,8615,8615,8615,8615,8615,8615,8647,8615,10695,8615,25453,63291,61211,48565,12775,10630,12775,8485,12808,8517,12743,10597,10663,10662,8550,12775,8517,12808,10597,14888,8549,12775,8550,10663,10663,10598,10663,8517,12776,8485,12775,10565,12743,8517,12710,50285,42095,8517,10630,10630,14725,55973,60323,58307,45731,50087,45861,39620,45925,48102,31400,31628,40015,33970,54805,21129,18951,10597,14790,6437,14823,44273,33709,31661,23143,12677,4356,6404,6404,6436,6437,8485,6437,16903,16903,52495,62962,46059,14724,12677,10629,10662,10727,8712,8745,6730,6795,6827,255},
{53021,53021,53021,55069,55069,55068,55068,55068,55068,55068,55068,55101,55101,55069,55069,55069,55069,55069,55069,55101,55069,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57148,57116,57148,57116,57116,57116,57116,57116,57149,57149,57116,61210,65306,65305,63225,63225,61112,61112,63225,61144,61144,59032,61112,61112,61144,56919,15084,8810,6698,25453,65337,63224,52694,63323,61210,40211,52758,52758,35985,46419,46419,35953,8647,10760,10760,8680,25453,17066,10728,8647,10760,8680,10760,10728,10792,10760,10728,10760,12840,10760,25420,52825,38327,42292,14856,10630,14856,8517,12808,8517,10695,10630,10630,10695,8517,12776,6437,12808,12677,14888,8549,10695,10630,10630,12743,10597,12775,8517,12808,8517,12775,10565,12710,8550,10597,44044,46288,10598,12743,14823,25257,56135,60419,54115,54115,56260,50053,41700,41700,39653,35526,27305,46289,29777,54806,27403,25256,16903,10760,8582,10663,29450,21162,29515,21031,12710,6469,8517,12743,12743,12743,12710,8517,18983,21129,18918,60881,39785,12644,12677,10597,10662,8647,8712,8745,8778,6794,6795,255},
{53021,53021,53021,53021,55069,55069,55068,55068,55068,55068,55068,55101,55101,55069,55069,55069,55101,55101,55069,55101,55101,55101,55069,55069,55069,55101,55101,55101,57149,57149,57149,57116,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,59163,63225,61080,63225,61112,61112,63225,61112,61144,59032,61112,61112,61112,56886,17132,10826,10794,23340,40080,37903,48468,65404,61210,40243,48564,50644,44371,29646,25420,37968,10728,10728,10760,10728,27533,25453,8647,8615,8680,8680,10760,10727,10760,8647,10760,10727,10760,10727,12808,34036,32151,40277,16936,8549,14856,8517,12776,10597,10695,10662,8550,10695,8485,12808,6437,12808,12677,14856,8550,10663,10663,10630,12775,8517,12775,8517,12776,8517,12743,10597,12710,10662,8517,41900,50416,12711,10630,14823,23079,50022,62499,52068,56260,54180,47940,43812,41732,41732,41734,27272,46288,31792,52725,33741,10564,40015,12775,4291,4323,23046,37837,37934,14822,10597,8517,8517,8549,8550,8549,8549,8549,6437,14823,8517,54543,37640,12644,10596,10597,8581,8615,8680,8712,6729,6762,6795,255},
{53021,53021,53021,55069,55068,55069,55068,55068,55068,55068,55068,55068,55101,55101,55101,55069,55069,55101,55101,55101,55101,55101,55069,55101,55101,55101,55101,55101,57149,57149,55101,57149,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,59163,61210,63258,63192,63160,63225,63225,63225,40016,23210,21162,21130,23242,16969,17001,19017,19049,19049,21065,46387,65404,61210,42291,48564,50677,44371,25518,25485,36018,8647,8647,10760,10728,21292,31825,17067,8679,10760,10728,10760,10760,10792,8712,10760,10760,10760,10760,10728,27631,27697,38098,19081,10597,14888,8517,10695,10630,10662,10663,8517,12776,8485,12808,8485,12776,12678,14856,10630,10630,12743,8549,12776,8517,12775,8517,12775,8549,10663,10630,10630,10663,6436,33578,52464,14856,10565,33286,39492,56131,58274,56195,56259,60451,54244,45892,50116,48036,47973,39785,44175,40211,48565,42128,12677,39950,21064,4323,6469,16805,54511,48401,16871,14790,6404,6436,8517,6437,6469,6437,6437,6436,6437,6404,44044,31399,10564,10564,8516,8549,8582,8647,8712,6697,6762,6795,255},
{53021,53021,55069,55069,55069,55069,55068,55068,55068,55068,55068,55101,55101,55101,55069,55101,55101,55101,55069,55069,55069,55101,55069,55101,55101,55100,55101,55101,55101,55101,55101,57149,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,55068,57116,59163,61211,61210,61211,56984,48532,29582,10696,10696,10728,16937,14856,19017,19017,16969,19017,16936,42194,65404,61210,38098,21357,36082,29938,21325,21389,21519,10728,10728,10728,10727,17099,27761,17131,8647,10760,10728,10760,8679,10760,10760,10760,10760,10760,10760,10727,27566,29875,34036,19082,10662,14856,10630,10760,10630,8582,12743,8517,12808,8485,12808,8517,12775,12710,12775,10663,10598,12775,8549,12808,8485,12776,8517,12743,10630,10630,10663,10630,12743,6404,25258,50449,19081,27110,49797,60451,56130,47779,56227,60451,58372,60547,56324,54276,45988,39684,41800,35724,48533,44339,48467,14790,21096,14790,12678,14856,23177,52431,52594,18983,20998,6404,6372,6372,4323,6404,6436,6372,6404,6437,4389,27304,27206,10564,10564,8516,8517,6502,6535,8680,6665,6730,6762,255},
{53020,53021,53021,55069,53021,55068,55068,55068,55068,55068,55101,55101,55101,55101,55069,55069,55101,55101,55101,55069,55069,55069,55101,55069,55101,55100,55101,55101,55101,55101,55101,57148,57149,57149,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,55068,55068,55068,55068,57116,50809,42259,29582,10728,10728,10728,16969,14888,19017,16969,19016,19017,16936,38033,65404,61211,23502,13002,31857,30036,17196,17228,19439,12840,19147,10760,10793,17131,29777,19212,8647,10760,10728,10760,10728,10792,10760,10760,10760,10728,10728,10728,17067,19603,21619,17002,10663,12808,10663,10728,10663,8550,12776,8517,12808,8485,12808,8517,10695,12710,12742,12743,8517,12776,8517,12808,8517,12743,10598,10695,10662,10630,12743,8517,10695,6404,21097,46191,41998,47814,58245,60322,58178,43651,41571,54179,58372,60452,54149,41764,29317,23077,31366,31465,50580,38131,54741,21097,23209,10597,8484,8550,14823,46092,58835,21096,21030,10564,4291,4324,4323,6372,6372,6372,6404,6404,6404,10565,10531,8484,8516,8484,6436,4389,4422,6535,6632,6697,6762,255},
{53021,53020,53021,53021,53021,55068,55068,55068,55068,55101,55101,55101,55101,55101,55069,55069,55069,55069,55101,55101,55069,55069,55069,55101,55101,55100,55101,55101,55101,55101,55101,57149,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,55068,55068,55068,55068,57116,52890,42324,29614,12776,10728,10728,17002,14888,16969,16969,16969,16937,16936,42226,65404,63291,25583,15278,34132,23859,21584,19568,19374,12906,17034,12938,12938,17132,27696,23373,8680,10760,10728,10760,10760,10792,10760,10792,10760,10727,10760,10728,17034,44503,46616,21228,8582,12808,10663,10695,12743,8517,12776,8485,12808,8485,12775,8549,10663,12743,12710,12775,8517,12808,8485,12776,8517,10663,10630,10662,12743,10598,12775,8549,12743,6437,27436,44110,60751,58311,62532,62498,56163,43619,45763,43618,39459,54181,56357,33477,25189,21061,25190,29319,48402,42259,52692,27468,25224,29481,10597,4324,8582,41866,60915,25290,18950,12677,4291,4324,4323,6371,6371,6372,6404,6372,6372,6372,6339,8483,8484,8484,6372,6437,4422,6502,6567,6665,6730,255},
{53020,53020,53021,53021,53021,55068,55068,55068,55068,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55069,55069,55069,55101,55101,55101,55100,55101,55101,55101,57149,57149,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,55068,55068,55068,55068,55035,46550,29614,10728,10728,10728,14921,16936,16969,16937,16969,16969,16904,40113,65404,63291,27663,17423,36277,19666,19438,21519,17391,15019,12939,17132,17164,19245,25583,21260,8647,10728,10727,10760,10728,10760,10792,10760,10760,10760,10760,10760,17034,56985,61211,27534,10630,12775,10630,8550,12775,8517,12808,8485,12808,8517,10663,10598,10630,12743,12710,12776,8517,12808,8485,12775,8549,10630,10630,12710,12743,8517,12776,8517,12775,8517,16936,31466,58477,62568,64643,62530,56227,49956,54147,47843,39523,45796,50085,31429,23109,16869,12676,23437,42225,50547,50515,31629,16870,25287,16837,4324,8582,23111,52529,29548,18918,16870,4323,4324,4323,6371,6371,6372,6404,6372,6372,6371,4291,8483,8483,8451,6371,6437,6470,6502,4487,6600,6697,255},
{53020,53021,53021,53021,53021,53021,55069,55068,55068,55068,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55069,55101,55101,55101,55101,55101,55101,55101,57149,57149,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,55068,57116,55068,55068,57116,54970,46485,27566,12808,10728,12776,14889,14889,16969,16969,16969,16969,16904,38000,65404,63291,27663,13262,34164,21746,19471,19471,21617,31955,31988,31988,29940,34068,29810,19212,8679,10792,10760,12873,10793,10792,10825,10792,12840,12808,12873,10792,25486,59130,65404,33807,10630,12775,12743,8550,12776,8485,12808,8485,10728,8549,10662,10662,8549,12775,12710,12808,8484,12808,8517,10663,10630,10630,10662,8517,12743,10597,12808,8485,12743,8549,10630,23177,56298,60424,62596,64642,52068,52068,52035,45828,47908,54244,41764,27269,27269,23141,16836,21258,31661,54740,52562,42128,14790,27335,21030,6404,8549,8517,31595,35789,16870,21063,6371,6372,6372,6372,6371,6372,6372,6372,6372,4291,4259,8451,8483,6403,6371,6436,6469,6534,6535,6568,6665,255},
{53020,53021,53021,53021,53021,55069,55068,55068,55068,55068,55068,55068,55101,55069,55101,55101,55069,55069,55101,55101,55069,55101,55069,55069,55101,55101,55101,55101,57149,55101,55101,57148,57148,57148,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,55068,55068,55068,57116,50809,40114,33775,25421,12809,10728,10728,14889,14856,16969,19017,19017,16969,16904,35887,65404,63323,25648,15342,36244,23859,19568,19601,21649,27761,23698,23731,25811,25811,25648,25486,10695,12840,10793,12840,12873,12840,10857,10792,12840,12840,12873,10760,33970,63291,65437,38033,10630,12743,12743,8517,12808,8485,12808,8517,12743,10630,10630,12743,8517,12775,12677,14856,8485,12776,8549,10630,10630,8549,10695,6437,12775,8517,12775,8517,10663,10662,19049,19016,54315,62569,62468,62594,50020,56324,58340,56259,54147,45859,50117,27269,31429,31462,27303,29384,29450,56819,65173,46354,14790,27335,21094,6436,8484,8485,14855,35789,14790,23143,8484,6371,6404,6372,6371,6371,6372,6372,6372,4291,4259,6371,8451,6371,6371,6436,6501,6534,6567,6567,6600,255},
{53020,53021,53021,53021,53021,55069,55069,55068,55068,55068,55068,55068,55101,55101,55101,55101,55069,55069,55069,55101,55069,55101,55069,55069,55101,55101,55101,55101,55101,55101,57149,55100,57149,57116,57116,57116,57116,57116,57116,55068,55068,57116,57116,57116,57116,57116,57116,57116,55068,50809,38000,31694,29614,27501,12809,10696,10728,14889,14856,16969,16969,16969,16969,16936,35887,65404,63323,27696,13295,36244,23827,17488,17520,21617,27761,21618,21650,21650,25746,31922,27599,10760,10792,8712,12840,12873,12873,10825,12905,12873,12873,14953,12840,40211,63291,65469,42259,10662,12710,12775,8517,12808,8517,10728,8549,10695,10630,8550,10695,8517,12775,10565,12776,8517,10695,10630,8550,10663,8517,12743,6436,12775,8517,12743,10597,10662,12743,16969,10663,37739,64681,62499,60387,47875,43715,47908,50019,58371,47940,45860,39749,33509,37801,31528,35656,33610,48402,65240,54805,18984,33610,16870,6436,6404,6404,8582,25322,12742,21096,8484,4291,6339,6371,6371,6371,6372,6372,6372,4291,4291,6339,6403,6371,6371,6436,8549,8582,8647,8615,6567,255},
{53020,53020,53021,53021,53021,55068,55069,55068,55068,55068,55068,55068,55101,55068,55101,55101,55069,55101,55101,55101,55069,55069,55069,55069,55101,55101,55101,55100,55100,55101,57149,57149,57148,57116,57116,57116,57116,57116,57116,57116,55068,57116,57116,55068,55068,57116,57116,55035,48696,44470,44339,42161,42226,33808,12809,10728,10728,14889,16936,16969,19017,16969,16969,16936,33839,65404,63323,27664,15375,36277,25777,19536,19568,19601,34164,15472,15505,15472,30036,40179,21227,12873,10825,10793,12840,12905,12905,12840,10792,12905,12905,14953,10792,27566,61210,65502,48565,12743,10662,12776,8517,12808,8517,10728,8550,10630,10663,6469,10695,6436,12776,8517,12775,8549,10662,10630,8517,10695,6436,10695,6404,10663,8517,10630,10630,8549,10630,21194,25388,37935,65141,62629,62498,56227,45828,35492,39588,50019,52099,45795,52132,39750,39849,33477,39750,39816,35789,63192,63160,27402,8484,10564,6404,4291,6372,8550,10662,10630,21031,16838,4291,4291,4291,4259,4291,4291,4291,4291,4259,4291,4291,6371,6371,6371,8517,10629,10662,10695,10695,10695,255},
{53021,53021,53021,53021,53021,55069,53021,55069,55068,55068,55068,55068,55068,55069,55069,55069,55101,55101,55101,55101,55101,55101,55069,55069,55069,55101,55101,55101,55100,55101,55101,57149,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,55068,57116,57116,55068,57083,59097,57017,56919,58999,58934,42129,12808,10728,10728,14889,14888,19017,19017,16969,16969,16936,33807,65403,63291,27663,13327,36244,25777,21584,21616,17553,34197,15505,15505,15505,30100,31858,10760,10760,10760,10727,12840,12841,12905,12873,10792,12873,12840,14953,12840,17001,56984,65534,50679,12743,8517,12775,6404,10695,8485,8582,8550,6469,10663,6437,8615,8485,10663,12678,10695,10630,10662,12743,10662,12776,12743,14856,14824,14888,16936,16969,19081,19082,19082,40080,50580,31694,42029,64740,62594,60451,49988,45828,37572,50052,41635,52034,49923,50085,35560,29385,41963,46255,42128,50547,54806,40113,17001,12742,8517,4323,6372,8550,6469,8550,18918,31531,16903,8484,10565,12678,14790,18951,21097,21129,6437,6404,6404,6371,6403,8516,10629,12710,12742,14855,16936,19049,255},
{53020,53021,53021,55069,55069,53021,55069,55069,55068,55068,55068,55068,55101,55101,55069,55101,55069,55069,55101,55101,55101,55069,55069,55101,55101,55101,55101,55100,55100,55100,55101,57149,57149,55100,57116,57116,57116,57116,57116,57116,57116,55068,57116,57116,57116,57116,55068,57083,59098,59065,54806,58999,61112,46355,14857,10728,10728,14889,16937,19017,19017,19049,16969,16936,33807,63031,58740,27631,11214,34164,27890,21584,21616,19601,36212,15472,15537,15505,32116,31858,15051,15083,19147,19147,19147,19180,17132,17131,17099,17067,14986,17099,19114,19114,59065,65535,56985,21195,19114,21227,23275,23275,25388,25420,25421,27501,27533,29581,29646,31694,31726,31726,33775,33807,33807,35887,33774,35920,31694,37968,31694,35919,31694,33774,33774,29548,37935,33741,48434,23243,8451,56291,64642,60483,49987,50019,31299,50019,43715,54147,33316,35397,16642,37870,46419,46353,54573,58899,59032,42161,14888,14757,23144,8517,4291,8517,31530,50481,52562,54707,54707,54707,54772,56853,61014,61046,50514,21162,8615,8550,6436,4291,6404,8549,12709,12742,14823,16903,19016,23177,255},
{53020,53020,53021,53021,53021,55069,53021,55068,55068,55068,55068,55068,55068,55069,55069,55101,55101,55069,55069,55069,55101,55069,55069,55101,55100,55100,55100,55101,55100,55101,55100,57116,57148,57149,57116,57116,57116,57116,57116,55068,57116,57116,57116,57116,57116,55068,55068,57083,61145,59097,56886,63192,63193,46387,14857,10696,10696,16969,16969,19049,19017,19049,19017,16936,31662,63096,58773,25583,13262,34164,25842,19536,19568,19633,34197,17520,15505,15505,32116,31922,10761,10793,10728,10728,8647,12873,10857,12841,12840,10760,12808,14953,12872,12840,33840,42226,56952,40113,29549,40113,27468,38033,29549,33774,31694,27436,35887,19049,38032,16936,35920,19049,29581,23275,21162,29548,14823,31726,10598,31694,12710,29581,16936,23210,23242,14791,25355,6404,44078,25322,2244,37572,64707,56259,54147,45795,39555,43715,39555,41700,29352,20901,27337,31888,36080,50312,35656,48402,63192,40080,16903,18885,41867,37901,31563,37869,46223,46222,50416,46288,44175,44208,46256,48369,44208,31628,12775,6535,6469,6469,6404,4291,6371,8484,10629,12709,14822,16903,18983,23144,255},
{53020,53021,53021,53021,53021,55069,53021,55069,55068,55068,55068,55068,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55069,55069,55100,55101,55100,55101,55101,55100,55100,57149,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,55068,57083,61145,61145,56886,63160,44241,33742,14921,10728,10728,16969,16969,17001,19017,19049,19017,16969,27501,60983,58838,25615,13327,36277,25842,21616,19568,19633,34196,15440,15472,15440,32084,31889,8680,10760,8679,10727,10695,10793,10825,12840,10760,10760,10727,12840,10760,10760,8647,10695,46354,31726,14823,33839,10598,33807,14856,27468,23275,19049,29614,12710,35887,10630,33807,12743,27533,19081,21162,25355,14823,29613,10630,31726,10630,29613,14823,25355,16968,6404,6437,4356,31499,21162,2244,29285,58435,52067,54115,49955,47908,52099,43715,33379,31463,29351,54901,34522,34453,62985,37867,37902,61079,40048,21096,20998,37804,65367,59031,29548,48336,54576,54609,50383,50350,52398,46124,27272,12710,6436,6436,6436,6436,6436,6371,4291,4291,6403,8516,10597,12710,12742,14822,16902,255},
{53020,53021,53021,53021,53021,53021,53021,53021,55068,55068,55068,55068,55101,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55100,55100,55101,55100,55100,57148,57116,57116,57116,57116,57116,57116,57116,57116,55068,55068,57116,57116,55068,55068,55068,55068,59131,59098,54839,61112,40048,29614,14922,10696,10728,16969,16969,19049,19049,19049,19049,23275,35888,60951,58643,25615,11246,36244,27890,19536,17488,19601,34164,17488,17520,15407,30003,31889,10728,10728,8679,10792,10792,10728,10728,12840,10760,10728,10695,10792,10760,10760,10727,10727,42129,29646,14856,33839,10662,33807,12775,29614,21195,21162,27501,14823,33839,10630,33807,10662,29613,16936,27436,25355,16936,27501,12710,31694,12678,33742,12742,29548,14823,4292,8582,12775,25257,16969,4356,29317,56324,56259,54147,54179,45893,56292,45827,37507,33478,35821,38520,28313,32340,60843,46288,31596,58966,27436,23079,16870,37803,65399,48532,4259,10564,29417,27271,16805,16805,16805,12612,4291,4291,6371,6372,6371,6404,6404,6371,6371,6371,6371,8484,10564,12677,12677,14757,14757,255},
{53020,53020,53021,53021,53021,53021,53021,55069,55068,55068,55068,55068,55101,55101,55101,55101,55069,55069,55069,55069,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55100,57148,55100,57148,57148,57116,57116,57116,57116,55068,55068,55068,57116,57116,57116,57116,55068,55068,57116,57050,56854,63127,42161,31662,14922,10696,10728,14889,16969,19017,19017,19049,19049,19049,29549,60853,60593,25550,9101,32083,23729,17455,15407,17488,31954,17261,15407,15375,30003,29841,10760,10760,8680,10793,10792,10793,10792,12873,10760,10760,10727,12905,12840,10728,10727,10727,37968,27533,14856,31759,10630,33839,12743,31694,19081,23275,25388,16936,31726,12710,33807,10662,31694,16903,29549,21162,23210,27468,14823,31661,12710,33807,10630,29581,12743,12711,12775,19081,19049,14822,6404,14724,45957,56259,47907,52164,48004,58404,54148,43813,35492,39686,46614,32409,32340,60874,54608,33643,54772,42064,41998,14758,39884,65432,48434,4258,4323,19016,21096,12644,10563,8451,8451,6371,6371,6339,6339,4291,6372,8484,8516,8516,8484,8452,8484,10564,10629,10629,14789,12709,255},
{53020,53020,53021,53021,53021,53021,55069,55069,55068,55068,55068,55068,55068,55101,55101,55101,55069,55069,55101,55101,55101,55101,55101,55069,55069,55069,55101,55069,55100,55100,55101,55100,55100,57148,57116,57116,57116,57116,55068,57116,55068,55068,57116,57116,55068,55068,55068,57116,57017,56854,58901,61047,46322,35823,16970,10696,12776,14889,17002,19017,19049,19049,19049,19017,27468,65339,65307,25583,4908,27858,17488,13294,13262,13294,32051,15375,17520,17488,32148,27826,10728,10760,10760,10760,10760,10825,10825,12873,10760,10792,10728,12873,10728,10695,10695,10760,29581,25421,16936,31726,10630,35920,12711,31726,16968,25355,23275,19017,29613,12743,33807,10630,33774,12743,27533,16969,23242,23275,16936,29581,12710,33806,10630,31694,12710,29548,23242,21129,16936,21062,25222,23174,37669,58403,47973,45861,43813,56324,56292,50020,50020,45893,46614,42715,46740,63020,60882,33610,48434,52628,58934,16903,39916,65497,44240,4258,4291,16936,21097,16805,18917,8451,8451,6372,6372,6339,4291,4291,14757,21064,21096,12710,10597,10565,8484,10564,10597,10629,14789,14789,255},
{53020,53020,53021,53021,53021,53021,55069,55068,55068,55068,55068,55101,55068,55069,55101,55069,55069,55069,55101,55069,55069,55069,55101,55069,55101,55101,55069,55069,55101,55100,55100,55100,55100,55068,57116,57116,57116,57116,57116,57116,55068,55068,55068,55068,55068,55068,57116,52955,56952,61047,61047,61080,61080,48500,17002,10728,10728,14889,16969,16969,19049,19049,19017,19017,23242,40146,40113,21357,9133,32051,21649,15375,13327,17455,31986,15342,17358,15245,25680,25550,10728,10792,10760,12840,10793,12873,12840,14985,14921,12840,12808,14920,12840,14889,14888,19081,33742,23340,19017,29646,10662,33839,10662,33807,14856,27468,21162,21129,29581,12743,31726,10598,33774,10630,29614,14823,25355,21162,19049,27468,12743,31694,10630,33742,10630,31694,16904,18951,16837,21029,23141,23238,33542,58437,54213,52133,50053,47908,58339,50052,50052,50085,50612,42714,48788,63021,60881,35690,39983,56821,63192,29483,31529,52625,25257,4291,4291,10597,19048,14789,21062,8451,6371,6404,6371,6339,4291,6371,21064,27370,27403,14823,12710,10597,8484,10565,10596,10629,12709,10597,255},
{53020,53020,53021,53021,53021,55069,55068,55068,55068,55068,55068,55101,55068,55101,55069,55069,55069,55069,55069,55069,55101,55101,55101,55069,55101,55101,55101,55069,55069,55100,55100,55100,55100,55068,57116,57116,57116,55068,55068,57116,57116,57116,55068,55068,57116,57116,57116,52890,56984,65272,65207,63160,54872,38033,19050,12776,10728,12808,16937,16969,19049,19049,19049,19049,19049,16936,16936,14921,14921,17034,17001,14921,14888,16968,16968,16936,16936,16936,16936,19049,19082,21129,19049,19049,16969,19049,19017,19049,19049,16969,19016,18984,16936,16936,16936,16936,29613,23340,21195,31694,17001,35952,12775,35920,16969,31694,23275,25387,29613,21130,31726,16969,33807,19049,33774,21194,29581,25355,25387,29548,25355,33741,25322,31628,23242,29580,29547,35721,31494,16901,14789,14789,21093,31429,50085,47941,56293,50052,54212,56291,47907,52067,50316,40634,52915,65101,60882,37803,31564,58934,63192,44208,16805,12644,27403,10597,4291,6404,16936,12710,21062,10564,6403,8484,6371,6339,4291,6404,12808,12906,14954,10695,8582,8550,8485,8484,8516,10597,10597,10564,255},
{53020,53020,53021,53021,53021,55069,55068,55068,55068,55068,55068,55068,55068,55068,55069,55101,55101,55101,55069,55069,55101,55101,55069,55069,55069,55101,55069,55101,55100,55100,57148,55100,55100,57116,57116,57116,57116,55068,57116,57116,57116,57116,55068,57116,57116,57116,55068,55002,63225,58869,60981,61080,50744,31825,19082,12776,10728,12808,16937,19017,19049,19049,19049,19049,19049,19017,19017,19017,19017,19017,19016,19017,19016,18984,18984,19016,19016,19016,19016,16936,18984,18984,16936,16936,16904,16904,16936,16936,16904,16904,16904,16904,16904,16904,16904,16871,29549,31759,31694,33807,27468,25387,21130,23242,19049,19081,23242,23275,23275,23274,23274,23275,23243,23274,23242,23275,23243,23242,25323,25355,27402,31431,27270,21030,14789,12709,27366,33542,33606,23206,18981,16869,18981,18981,41862,41669,49988,62563,56260,56227,49955,49955,44076,40601,38482,65069,58769,39915,25289,56821,63192,52595,27239,27205,37902,25356,4259,4324,14823,14791,18982,14724,8451,8484,6403,6339,4291,4389,6632,6698,6698,8615,8615,8550,6469,6436,8484,8516,8516,8484,255},
{53020,53020,53020,53021,53021,53021,55068,55068,55068,55068,55068,55068,55068,55069,55101,55101,55101,55069,55101,55101,55101,55069,55069,55069,55069,55069,55101,55101,55100,55100,55100,57116,57116,55068,57116,57116,57116,55068,57116,55068,55068,57116,55068,55068,57116,55068,57116,52857,61080,63160,63192,59000,56984,42260,19082,12776,12776,12808,14889,19049,21129,19049,19017,19049,19017,19049,19017,16936,16936,16936,16936,16936,16936,16936,16936,16936,16936,16936,18984,16936,16936,16936,16936,16936,16936,16936,16936,16936,18984,16936,16936,16904,16904,16936,14856,14823,27436,25486,27599,35920,29646,4356,6437,4356,6405,6437,16969,21130,21162,21162,21162,21162,21162,21162,21162,21162,21162,21129,33774,31662,33677,35592,29350,27302,14821,8516,12676,14789,35687,27398,19013,21062,19013,12676,16869,20997,31300,58372,62531,62532,58308,56261,50283,36342,42514,65004,56656,29416,29482,48434,63159,58999,31563,33446,44109,48533,8484,4291,10662,12775,14821,14756,8451,8452,6403,6371,4291,4389,4585,4650,6665,6567,8615,6502,6437,6436,6404,8484,8483,8484,255},
{53020,53020,53021,53021,53021,53021,55068,55068,55069,55068,55068,55068,55101,55101,55068,55101,55069,55069,55069,55069,55069,55069,55069,55069,55101,55101,55069,55101,55100,55100,55100,57148,57149,57148,57117,57116,57116,57116,57116,57116,55068,57116,55068,57116,57116,57116,57116,59131,63225,65305,52693,27436,31629,37935,21163,12776,12776,12808,16937,19017,21129,19082,19049,19049,19049,19017,16969,16936,16937,16936,16936,16936,16904,16936,16936,16936,16904,16904,16904,14856,16904,16904,16904,16936,16904,16904,16904,16936,16936,19016,18984,19016,21065,21097,21097,21097,33742,33840,31760,38131,38066,4356,4389,4356,4357,6437,16936,19017,19049,21129,21130,21162,21130,21162,23210,23242,23242,21162,31694,31629,33709,33577,27302,23142,12677,8484,10564,6403,29414,25286,21093,18981,23174,14789,12676,21126,23206,29317,41797,58373,60389,58374,54672,38586,48754,65069,54609,27369,33577,37902,63159,63160,40048,25190,35625,52661,12710,4291,8517,10630,14757,16869,8452,6371,6371,6371,4291,4422,4585,4650,6633,6568,6567,6502,6437,6404,6403,6403,8451,8484,255},
{53020,53021,53020,53021,53021,55069,55069,55069,55068,55068,55068,55068,55068,55068,55069,55101,55101,55069,55069,55069,55069,55069,55069,55069,55069,55069,55069,55101,55100,55100,57116,57116,55036,55036,55068,57116,57116,57116,55035,57051,57083,57116,57116,57115,57051,57018,57018,59131,63258,63225,52693,31661,33742,35920,21163,10696,10695,12776,14856,18985,19049,19049,19049,21097,21129,21097,21130,23177,23178,23210,25290,25323,25323,27403,27436,29516,29548,31596,33677,33709,35790,35822,37902,39950,37935,40016,40015,42063,42063,42096,44177,39983,44176,42096,40016,44144,44274,44339,29581,38098,33873,10663,12775,14856,14888,16969,25323,31629,29549,31662,29581,31694,29549,29549,29549,29613,29581,29549,31662,35887,23210,23144,18950,16903,14790,14790,16871,14823,25223,31527,29478,18981,21062,23174,23174,23174,25318,25254,27399,39815,47942,54346,48760,32410,52850,65102,50319,31661,39914,27370,61079,63160,50548,21063,29351,52496,21064,4259,6404,8550,14790,18982,8452,6371,6371,6339,4291,4487,4617,6698,6633,6567,6567,6469,6436,6371,6371,6371,6403,8484,255},
{53020,53020,53021,53021,53021,53021,55069,55069,55068,55068,55068,55068,55068,55068,55069,55069,55101,55069,55069,55069,55069,55101,55069,55069,55069,55069,55069,55100,55100,55100,55068,57116,57083,55035,57116,57116,57116,55036,55036,57083,57084,57116,57116,57116,57084,57083,57083,59163,65339,63193,56886,37870,35757,39983,42096,37935,40048,40016,42128,42063,42128,42161,42128,44209,42063,44209,42128,42096,46289,40015,46289,40015,40015,44176,35790,44209,35789,39983,42064,31628,42128,31564,37903,35790,27403,39983,25290,35822,29516,25322,37870,21097,35757,27403,25290,35757,42226,46452,23275,27501,29581,29581,29549,29613,29581,29581,27500,27468,27436,27468,25388,27436,25388,25388,31630,27468,25355,23243,23307,38033,16969,14823,16936,14823,14823,16903,14823,14823,16871,21031,33639,29446,27366,25286,27399,19014,23174,25255,23207,35754,54640,50413,50873,32442,44658,63022,39787,33644,44075,23177,56853,63159,56886,25257,23142,46189,35821,4258,6404,6534,12710,18983,10564,8452,8452,8452,6436,6469,6469,4356,4356,6437,6437,6404,6372,6371,6371,6371,6371,8451,255},
{53020,53020,53020,53021,53021,53021,53021,53021,55068,55068,55068,55068,55068,55068,55069,55101,55101,55069,55069,55069,55069,55069,55101,55069,55069,55069,55069,55069,55101,55100,55100,55068,57148,55101,57116,57116,57116,57116,57116,57116,57116,55068,55068,55068,55068,55068,55068,55068,59163,58934,56756,56723,61079,63160,50548,27436,27436,31596,48370,31498,37870,33709,27371,37903,21129,33742,27403,25323,35822,21097,35822,25290,27435,33709,21097,37902,23210,29516,33677,21129,37903,23177,31629,31596,21130,35822,21097,31629,29483,23210,35822,21097,33677,27403,25290,35756,48434,48533,19082,23340,29581,27501,27468,27501,27468,25421,27468,25420,27436,25420,25388,25388,25355,27501,46258,27436,23307,25322,25355,46387,19049,12678,12742,12678,10630,12678,12678,12678,12678,12678,31495,31526,33639,29382,31559,31591,25286,25255,16870,25257,58900,52560,50644,44599,50609,52395,25288,33612,46156,25256,48402,61046,48434,29516,21030,29449,25257,4291,6502,6633,10630,16935,14790,10597,10597,10565,8517,8517,6404,4259,4291,6339,6371,6371,6371,6371,6339,6339,6371,6371,255},
{53020,53020,53020,53021,53021,53021,53021,55068,55068,55068,55068,55068,55068,55068,55101,55069,55069,55069,55069,55069,55069,55101,55069,55069,55069,55069,55069,55101,55100,55100,55100,55068,55068,57116,57116,57116,57116,57116,55068,55068,55068,55068,55068,57116,55068,55068,55068,55068,59163,63192,63159,63192,65305,63159,50548,19082,17034,23243,46257,25257,33742,29548,25323,35855,21097,33742,25355,25323,35822,21097,35822,25290,29483,33709,21129,35822,23210,29516,33677,21129,35854,21161,31596,31629,23210,35822,21097,31596,29516,23178,35822,21097,35855,35790,35887,44143,35789,31727,19082,23308,27533,27501,27501,27468,27436,25420,25355,25388,25388,25388,25355,25355,25355,29646,42162,27468,27468,27436,29549,52725,23307,16871,16936,18984,18984,19016,19016,19016,21064,21096,21096,23176,29481,27368,23144,29513,23207,14790,14757,29451,54707,52494,48300,52660,46387,46386,40146,44307,48532,33741,39983,40047,14823,37967,18983,23175,8484,6371,4324,6600,8582,16902,16902,12677,12709,12742,12742,10630,6436,4259,6339,6371,6371,6371,6371,6371,6371,6371,6403,6371,255},
{53020,53020,53020,53021,53021,53021,55069,55069,55068,55068,55068,55068,55068,55101,55101,55069,55069,55101,55069,55069,55069,55069,55069,55069,55069,55069,55069,55069,55100,55100,57116,55068,55068,57116,57116,55068,55068,57116,55068,55068,55068,55068,57116,55068,55068,55068,55068,55068,57116,59163,59098,56919,58967,63160,52596,19114,19082,21194,46289,21064,35790,29516,25323,35822,21097,35822,27403,25355,35789,21129,35822,25290,27435,33742,23177,37903,25323,29548,33709,23177,35854,23210,29548,31597,23177,35822,23177,31596,31596,23177,35822,21129,35822,37903,27403,48467,27533,23340,19114,21228,27501,27501,27469,27501,27468,27469,25356,23340,25355,25355,23307,23275,23307,27468,23243,25355,25355,23275,27435,58966,25420,19016,25355,21097,19016,19017,19049,16903,16871,14823,14823,12743,12678,10630,10597,21162,14791,10629,12644,21194,56787,54607,50413,56722,50449,42027,35786,40047,52594,41963,31596,46453,23178,46354,19016,23175,12709,4291,4291,6437,8582,14822,19015,12710,14790,14823,12775,10695,8549,4291,6404,6404,6404,6404,6404,6404,6404,6437,6436,6404,255},
{53020,53020,53021,53021,53021,53021,53021,53021,55068,55069,55068,55068,55068,55068,55069,55069,55101,55069,55069,55069,55069,55101,55069,55069,55069,55069,55069,55069,55069,55100,55068,57116,55068,55068,57116,55068,55068,55068,57116,55068,57116,55068,57116,57116,55068,55068,55068,55068,55068,55068,57083,56920,54709,58999,52660,19114,17034,21162,46289,18951,33741,27403,25290,35822,19016,35822,27370,25355,35789,21097,35822,27370,29516,35822,23210,39983,27403,31629,35790,25322,37902,27403,33677,33709,27403,37902,29483,33709,33677,27435,33709,29484,31629,29548,29548,40048,40113,31662,21162,21195,29614,27501,27501,27501,27468,25420,25388,25420,23308,25388,23307,25323,23308,25388,23275,23275,23308,23275,29516,61112,27533,8517,10662,12710,12743,10598,10630,12710,10598,10598,12710,12710,10630,12710,12710,23242,12743,12678,16805,27501,54740,54706,54608,58770,48335,33675,37736,23175,48270,52396,23177,35986,35887,56853,25323,18982,29482,31530,6339,4323,8550,12710,19015,10564,8452,6371,6437,12873,10826,8680,6567,6535,6535,6502,6469,6437,6437,6470,6469,6436,255},
{53020,53020,53021,53021,53021,55069,53021,55069,55069,55068,55068,55068,55068,55068,55069,55069,55069,55069,55069,55069,55101,55069,55101,55069,55069,55069,55069,55101,55069,55100,55069,55068,55068,57116,57116,57116,55068,55068,57116,55068,55068,57116,57116,57116,55068,55068,55068,55068,55068,55068,57116,56855,56725,48466,54708,25388,25355,27436,48402,29484,40015,33709,33709,46289,35822,33742,29516,29516,31596,25355,29548,25323,25323,25322,23210,23242,21129,21129,19049,16969,16936,14856,14823,12775,12743,10662,10662,10630,8550,8550,8550,10826,8680,8550,10728,25453,31727,27664,21195,19115,27468,27501,25388,25421,25355,23308,25356,27468,25388,25388,23307,23307,25355,27468,23307,23275,23275,21162,27435,52659,25388,16904,21097,21097,21129,19049,21129,21097,21129,21129,21129,21097,21129,21129,19049,21129,10597,16838,23046,25290,50514,60980,56787,56755,42062,27534,25322,12678,48270,50382,29547,38001,54740,63160,35822,16870,29481,48335,8484,4291,6469,10630,18983,10629,4291,4291,6437,12873,12938,10858,6665,6632,6600,6535,6502,6437,6469,6469,6469,6436,255},
{53020,53020,53021,53021,53021,53021,55069,55069,55068,55068,55068,55068,55068,55068,55068,55069,55069,55069,55069,55069,55069,55069,55069,55069,55069,55069,55069,55101,55069,55100,55068,55100,55068,55068,55068,55068,55068,55068,57116,57116,57116,57116,57116,57116,57116,57116,57116,57116,57148,57116,57148,59001,61015,52693,48435,40081,21261,25453,27566,25486,29614,42129,40015,48433,54773,19049,10631,8582,8550,8550,6470,6502,8550,8550,8583,8583,10663,10695,10695,12743,12776,12776,14856,16969,16969,10663,8615,8615,8615,8615,10696,19213,6600,6470,10695,38065,35953,40113,27468,19082,27436,25421,25356,23308,25356,25388,25356,27436,25388,25388,23308,25323,16936,16936,14823,14823,14791,16903,17033,10791,17001,16936,23242,23177,21097,18984,19049,16903,16903,16936,14823,14791,12742,18984,25322,37967,21161,33710,37935,27435,46321,63125,48401,50416,33807,21325,23503,25388,29515,33708,33708,44273,63159,63160,46354,16870,23175,35756,8484,4291,6437,8582,16903,12742,8451,37737,14823,10793,12906,10825,8745,6632,6567,6502,6470,6437,6437,6404,6404,6404,255},
{53020,53020,53020,53021,53020,53021,53021,55069,55068,55068,55068,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57149,57149,57149,57149,57149,57149,57181,57181,57181,57181,57181,57149,57149,57149,57148,57116,55068,55068,55036,55036,55003,52955,52923,52890,50842,50810,50809,48729,48696,48696,48533,50451,37968,29582,27566,8876,10923,17132,29647,40146,65402,42193,25290,19081,14954,12841,25420,33807,33774,21195,27500,29516,27500,29581,29548,29548,31661,27436,27435,31629,27435,27435,29548,23242,10728,10728,10663,10663,10695,12743,21260,6633,6470,12776,40178,38000,37968,27468,17002,29549,27501,25420,25388,25388,25388,25388,25388,25388,27436,23275,29581,21097,14790,14791,14791,12710,21129,27597,10857,14888,8550,8549,10630,12710,10598,10598,10597,10597,8517,10630,10630,10598,14791,12742,16871,12743,27501,40113,37903,44241,58933,50481,46125,35725,36083,26168,50677,40081,10663,35756,31661,58934,63160,54773,19016,21063,14789,4291,4291,6404,6470,10695,14822,35527,48138,10597,6469,8517,8549,8549,6469,8550,6469,6437,6469,6404,4291,4291,4291,255},
{53020,53020,53021,53021,53021,53021,53021,55069,55069,55068,55101,55068,53020,52988,52955,52955,50875,50875,50842,50810,48729,48729,48729,46616,46583,46551,44503,42390,42390,42357,40277,38164,40211,40211,38066,35986,35986,35985,33840,33840,31792,31760,29647,29647,29647,27566,27566,27501,25389,23275,23308,23243,21162,21162,23275,23373,13069,15084,19245,40114,61112,65435,44274,25323,12776,12874,14954,33807,37967,37935,23275,29581,29549,27468,29581,27468,27468,29549,27435,25355,29516,27403,27435,27435,12776,10695,10696,8615,8615,10663,10663,19180,6633,6470,17001,38066,25551,33906,27566,14954,25388,27501,25421,25355,25388,25420,23308,25355,23275,23307,23275,27436,19016,12742,14790,12710,12710,19016,23371,10825,14920,16904,18984,16968,19017,19017,21097,19017,19016,21097,21097,21129,21097,21129,21064,33742,16936,16936,33709,25289,48336,46322,42095,52496,39820,38130,24152,54804,60746,39783,48368,44208,52562,63160,58999,27435,16934,16935,4291,4291,4324,6469,8582,16838,52234,39882,6372,6404,6404,6404,6436,6404,6404,6436,6436,6404,6404,4291,4291,4291,255},
{53020,53020,53020,53020,53021,53021,53021,55069,55068,55101,36116,25552,29778,31793,25584,27632,23503,23471,29647,27567,25486,23406,23405,23341,23309,19245,17132,23341,21228,19212,19212,19148,17067,17099,23308,17034,14986,14987,19115,14954,12906,19147,12874,12841,12874,17034,12841,10761,10761,10696,8615,8615,8615,6567,8616,12906,10956,12971,10858,35985,61080,58999,40048,27403,12808,12873,12840,14888,14888,19017,21162,27468,27468,27436,29548,27468,27468,29548,27435,25355,29516,25355,25355,14921,8648,10696,10696,8615,10663,10695,10663,12841,6600,6535,10728,40146,21390,19408,21325,14954,25453,27501,25388,25356,25421,27468,25356,23275,23308,25356,23275,25323,21129,16935,19016,21064,21096,25225,19048,10857,14920,16936,23177,25323,19049,19016,21097,18984,16903,16903,16903,14823,14791,16903,14758,29516,21162,16871,46092,14692,29318,42127,42062,56754,39983,27599,35985,58866,58567,56687,54806,60979,63092,61080,61080,46353,25289,21095,14790,14822,14790,10662,8550,6436,18885,16870,6404,6371,6371,6372,6371,6372,6436,8713,6436,6404,6404,4291,4291,4291,255},
{53020,53020,53020,53020,53020,53021,53021,53021,55069,55101,27697,12907,15052,10826,19213,10924,12972,8746,12906,10826,14987,10793,8745,8778,10794,8746,6665,10826,8713,6697,6698,8713,6633,6633,8713,6600,6633,6633,6633,6633,8713,8745,6600,6600,6633,6600,6600,6600,6568,4455,4455,6535,6535,6535,4455,21260,46453,42292,42324,50678,52693,50482,33644,29516,12808,19114,23275,29549,29549,29549,21162,25356,27436,25388,27468,27436,27403,29516,25355,25322,29516,27435,19049,10728,10728,10696,10728,10663,8615,10663,10695,23373,6633,4520,31695,42291,15084,13102,21391,14922,23340,27501,25389,25388,27468,25388,25388,25388,25356,23308,23307,25388,42095,46158,48271,50384,48304,50416,35821,12937,14920,12743,8517,10662,12678,10630,8517,8550,10630,8517,8549,10630,10598,8550,10630,23242,23242,4323,12612,20997,25157,37736,39850,54609,36148,21488,44110,58769,48205,31662,31629,42095,63191,61079,63160,48467,21063,21095,19015,14789,14757,10597,8550,8582,10596,6403,6403,6372,6404,6404,6404,6404,8517,8550,6436,6404,6404,6339,4291,4291,255},
{53020,53020,53020,53020,53021,53021,53021,53021,55069,55101,31891,8746,6600,6633,6601,4617,6601,6665,6633,6665,6633,6633,6633,6633,6600,6633,6600,6600,4520,4552,4552,4520,4487,4519,4520,4487,4487,4487,6535,4455,4455,4487,4455,4455,4455,6503,4455,6503,6503,6503,6503,6535,6535,8615,8615,29582,59065,52759,48598,57017,56919,50482,35790,31596,19049,35822,31629,40081,40081,40048,35855,40113,44242,44274,46386,48434,48467,50580,52660,44241,33741,29548,14889,10728,8615,8615,8583,8582,8582,8582,8550,35888,8746,4487,21228,42226,12939,13101,21390,14921,25388,27501,27469,25420,25421,25356,25356,23308,23340,25356,23275,27468,48336,48271,50384,50384,48304,50416,46255,15050,12872,16969,14855,16968,18984,19016,19049,19049,19017,21096,19049,19049,19049,21097,21097,19016,19049,8484,8484,18917,23077,46088,44010,41997,14856,21684,58835,54577,35758,35855,27435,48369,63192,63160,61079,35853,18983,19015,16902,4258,6403,8516,6437,6502,14758,33709,6371,6371,6404,6404,6404,6436,8484,8484,8484,6436,6404,6339,4291,4291,255},
{53020,53020,53020,53021,53021,53021,53021,55069,55069,55101,23504,2374,4455,4487,4487,4487,4487,4455,4455,4487,6535,6535,6535,6567,6567,6567,8616,10728,8648,10761,12809,12809,14921,17002,17002,14922,19082,21195,21195,21228,23308,27469,23275,27469,29582,27534,27436,29582,31727,29517,31597,31662,27436,31596,33710,40113,56985,50678,42227,56952,56919,56821,54774,56820,54707,63224,63192,63257,63224,63225,65305,63224,65305,65305,63257,63225,63257,63257,65305,48435,19081,19049,21162,12808,6502,6502,6470,6502,6470,6470,6470,33807,10826,4487,19147,38033,14987,15117,25551,14921,23308,27468,25421,25388,25420,25355,23307,23308,25388,25323,23275,23308,27435,29483,31563,27403,27403,27370,46288,17065,12872,19082,18984,25323,21129,21097,21129,21129,16936,16903,19016,14823,14791,14823,14823,12710,16936,8517,6372,18918,27337,56721,56754,31564,14564,33742,60948,46289,39659,42128,27403,52627,63159,58966,35821,18982,10531,16870,19047,12677,10564,6371,6404,6502,8484,46321,21064,6338,6371,6371,6403,6403,6404,6404,6404,6404,6403,4291,4291,4291,255},
{53020,53020,53020,53020,53021,53021,55069,53021,55069,55069,25552,19148,23308,25453,27534,12841,25454,31727,35888,35920,31695,33840,35920,35888,29647,38033,42194,40048,35920,38033,38033,33775,35888,35888,35888,31662,33775,33775,35855,31662,31629,35790,29549,29517,29549,31629,27404,25323,27436,27403,25258,27404,27404,27371,29484,37935,59065,52791,44307,56952,56919,61112,65338,65207,58933,63224,58966,52595,52594,54675,63160,58999,61111,61112,61112,59032,61112,61111,61112,46387,6469,6470,8582,8615,6502,10663,10695,6470,10696,10696,6470,25356,12874,6632,23341,27729,25616,29875,31890,17034,21227,27469,25453,25356,25388,25388,25388,25355,25388,23340,23308,21195,21162,23243,25388,21194,23275,23275,50579,19178,12872,19114,8485,10597,10630,12678,8517,8549,10598,8517,8517,10598,10598,8517,8549,10598,21162,10630,6404,14757,33709,54806,50547,29450,27338,56723,58867,33840,29452,37969,27403,56853,56853,33675,18982,23144,25322,14790,23208,19047,10597,8484,6436,6502,8484,23176,21161,10629,12677,14757,14790,12709,6403,8484,8485,6404,6371,4290,4291,4291,255},
{53020,53020,53020,53020,53021,53021,55069,55069,55069,52988,38034,35888,33775,29581,37968,21293,33775,35855,37968,35888,33710,31694,31694,31662,29549,31727,33742,31662,29582,29582,31662,31662,33775,33775,33775,33742,35888,33775,35855,37968,35855,37936,35855,35855,37935,42096,40016,37871,42096,37870,33644,35757,37935,39983,42063,40048,44274,40081,42162,42161,44209,61046,65338,63159,58900,63192,56853,50482,52562,52595,61079,61111,61112,61144,63224,61079,61112,59031,61079,46387,8550,6502,10695,12776,6502,10663,10695,6470,8615,8583,6470,12841,8681,8680,25453,29809,17099,27794,31955,19114,21195,27469,27469,27501,25421,27469,27468,25388,27469,25356,25387,23275,23275,23275,27468,23275,23275,25355,52660,19178,12872,21259,12743,16904,16904,19016,16936,16936,19016,19016,19017,19016,19016,19016,19049,19016,23210,21097,12678,18983,27402,56918,41901,35432,54674,60979,52562,31857,23340,25290,31628,56821,31595,18982,16837,54741,42128,12710,23208,14822,10564,10597,8517,6502,8549,10596,12743,12775,12742,12677,12677,12677,6403,8517,8517,8484,6371,4290,6339,4291,255},
{53020,53020,53020,53020,53020,53021,53021,55069,55069,52955,35953,40081,46420,44307,35856,25486,38001,42226,50645,48533,42161,46387,48533,42260,37968,44307,42259,42194,44274,42259,42259,38000,44307,42194,40114,35888,44242,35888,40049,42194,44209,42129,37936,40016,40016,46289,44209,44177,37935,39951,35758,35758,35887,44144,42064,40016,33612,29419,33645,31630,31564,44078,56788,63159,60981,65305,58934,50482,52530,54643,63159,61144,61111,61111,58999,58999,61112,42323,21227,23275,10728,8583,6470,6470,6470,6470,6469,6502,6470,6470,8550,12808,8648,8615,23243,36051,17099,27730,34036,19147,19114,27436,25421,25388,25420,25388,23340,23308,25388,25323,25388,23308,23242,23275,27435,23275,21195,27436,52692,17065,8711,23340,16936,23242,25290,21129,21097,23242,19016,16936,21161,19016,14823,16903,19016,14791,16904,19016,8484,18886,20965,50416,48402,27305,60947,60947,40015,33938,25388,27403,29515,29514,18950,23144,23112,52595,46386,10630,16935,25289,8484,6371,8517,8550,6502,12677,14823,12807,12742,12677,12676,12677,8484,8549,8550,8517,6371,4290,6339,4291,255},
{53020,53020,53020,53020,53021,53021,53021,55069,55069,52955,35953,42226,40114,40081,44242,21326,38033,42227,52726,50613,42162,42227,44372,46420,42161,44307,42227,42162,44274,40179,42227,37968,44307,42194,40114,35888,42129,37968,42129,40081,40016,40048,35823,39983,35822,42128,40016,33710,33742,33710,29549,29516,29582,31629,25323,29548,23243,19049,21130,19114,16969,21065,27338,37869,37902,40048,33709,29548,29516,29548,31629,31629,31629,31596,29516,29548,31661,25355,17002,19082,21162,21162,21195,21227,23275,23275,25388,23308,25420,23307,27468,25355,29549,25323,44274,40179,19310,25715,33938,23308,17034,27468,25388,23307,25388,23340,23308,23308,25355,23308,25355,23275,23242,23275,25388,23275,21194,29549,56885,33839,33839,35953,10630,10597,12710,12710,10598,10630,10598,10597,8517,10597,8550,8517,10662,16936,29581,29548,21064,23145,25159,52431,50547,19016,50416,58867,25290,29451,14986,25355,19015,21063,23110,31563,42064,54642,50546,35657,33609,19015,10597,8484,8484,6437,6502,10629,14790,14855,12742,12677,12677,12676,8484,10597,8550,8484,6371,4290,6339,6339,255},
{53020,53020,53020,53020,53021,53021,53021,53021,55069,53020,40180,38033,44274,33808,33775,19212,35921,35921,44339,44307,40049,35953,35953,40114,35855,31792,29712,33840,29679,27600,25551,25518,23438,23405,25486,21293,19245,21292,23406,19245,17197,21325,21325,19245,17229,23406,21358,21358,21390,23438,21358,23406,21325,21325,21228,25388,21227,25421,21228,27501,23275,27501,25388,27469,25355,27501,25388,29549,25388,27501,25420,29549,27501,27501,27501,27468,27501,27500,27468,25388,27468,25355,25388,23275,25355,23275,23275,21162,23242,21130,21195,21130,21162,19049,29548,54774,48631,52824,46452,25421,17002,25356,27436,25356,23308,23308,23275,23275,23275,23308,23275,23275,23275,23275,25387,25355,21195,33742,52627,59032,65534,54904,14856,14823,16903,16936,16904,16904,18984,19016,16936,19016,19016,19016,19049,16936,23209,33479,16772,12677,33545,52431,27371,12678,44110,48401,12776,44209,38001,21128,21062,25092,31399,42030,58900,61013,35822,25224,20998,21128,10564,4258,6404,8516,6469,8517,12677,14822,12709,10629,10596,10596,8516,10629,10630,8484,6371,4291,6339,6339,255},
{53020,53020,53020,53020,53021,53021,53021,55069,53021,55101,46518,31661,52726,52726,35855,23341,31695,31695,35888,35888,33775,35855,35920,35888,31727,23536,25681,29810,27762,31923,29874,36083,36083,38164,36083,40276,36116,42324,38196,44437,40309,44405,40276,46518,42357,44405,42324,42292,42324,40179,33905,35953,33872,33840,27501,31694,27469,29581,25388,27501,25356,25388,23307,23307,23275,23275,23243,21194,21162,19082,21162,19114,19114,19082,16969,16936,16968,14888,14888,14856,12808,12775,12743,10695,12743,10662,10663,8582,10662,10630,10662,10630,10663,10630,27436,56919,46452,27533,46420,31694,14922,25355,25388,23308,23275,25356,23275,23340,23275,23307,23242,23275,23243,23243,25355,25388,21162,33774,48434,61145,65501,56985,19049,21162,27435,23210,21129,25322,23209,19049,21097,21097,18984,16903,16936,16871,25224,43880,31333,14725,58868,63061,58933,23274,18983,23242,21195,38000,29515,23142,33543,35559,48402,29516,54675,61078,40113,21194,14790,23176,23208,14790,8484,6371,6437,8582,12676,14789,12677,10596,10596,10564,10565,14758,16871,10597,6371,4291,6371,6371,255},
{53020,53020,53020,53020,53021,53021,53021,55069,53021,55101,48664,40081,44339,35888,37936,23438,38034,40146,48533,50613,46420,46420,36018,36051,46485,44437,38196,40244,36116,40244,36083,40212,38130,36050,33873,33937,29776,31792,27632,29679,25551,25518,23438,25518,23438,23405,21325,21325,19212,19212,19212,19180,17132,15084,14986,14954,12873,12841,12840,12808,12776,10728,10695,10695,10695,10695,10695,10695,12776,12776,12776,12808,12808,12776,12808,12808,14888,14856,16969,14889,17001,16937,19049,17001,19082,16969,21130,17001,19114,16969,19082,16969,19114,14888,33807,54839,40179,21390,38066,27533,12906,23308,25388,25421,23275,23340,23275,23308,23243,23307,21162,23243,23243,23275,21227,21195,19114,31661,54805,54871,50547,50580,17002,10630,14855,14791,12710,10597,10662,10630,8517,10598,10598,8549,10565,25094,18918,29286,22980,29189,43979,42029,44110,29580,4324,19114,42291,25354,21062,37737,52493,44044,58999,40048,31596,63126,42161,10760,14823,25288,21160,19015,10564,8484,6437,6535,8516,14757,12676,10596,10596,8516,10564,31563,35788,16838,18886,12612,10564,8484,255},
{53020,53020,53020,53020,53021,53021,53021,53021,55069,55101,48697,38001,48533,56984,42161,23405,35985,38066,48565,48565,48500,48565,46518,46551,46486,44437,38164,42357,38196,42357,40276,44437,23536,13101,13069,13101,13101,11021,10988,13068,11021,13036,15149,15149,13134,15182,17262,17262,15181,17229,19278,19245,17229,19277,19180,19147,17067,19147,19115,21163,21162,19147,19114,21162,21163,21162,21195,19114,21162,19049,19114,19049,19082,14889,16969,14856,14888,12775,12808,10695,12776,10663,10695,8614,10663,8550,8582,8550,8582,8550,8550,8550,8550,6469,23275,56919,40081,21358,42324,35888,14922,23308,25388,25388,23275,23340,23275,23307,23243,23308,23275,23275,21194,17001,14921,12840,10727,33741,58999,54806,48401,48467,19147,12743,14824,14823,14855,14823,14856,16903,16904,14855,16904,16904,21032,33447,27238,25158,22980,37477,25093,23045,35591,25290,12743,23405,27467,21095,33479,63025,48235,44077,65239,63223,29515,50482,38000,8680,14888,18951,21128,12677,12677,10597,8517,6502,8517,12676,12709,14757,16903,14790,16871,37804,33643,52561,52429,37607,25158,16805,255},
{53020,53020,53020,53020,53021,53021,53021,55069,53021,55101,48697,35855,46420,48565,42162,21228,29581,31662,35887,35855,33710,29549,31662,31694,42161,50646,46518,48598,46485,48533,46518,52791,36051,31922,29874,31955,29875,34002,29874,31922,29874,31890,31922,34002,31922,29842,31890,29777,25616,21422,19277,19245,15084,15084,12938,14954,10793,12841,12809,12808,10728,10695,10695,10695,8647,8615,10695,8615,10695,10695,12775,10728,10728,10728,10695,10695,10728,10695,12776,12776,12808,12776,14856,14856,14889,12808,14889,14856,16969,14888,16969,16936,16969,16936,16969,52726,44339,15149,36050,37968,14921,23340,25388,25388,23275,23308,23275,23276,21227,23276,23275,23275,12841,6535,6567,6600,4422,33807,50612,37968,52693,50613,23308,19049,25323,23209,21129,23209,25290,21096,21097,21161,19016,18984,21096,35559,41733,37605,33381,35461,27173,29253,23045,10564,14823,23274,23175,23078,50448,50413,52526,48303,65239,63255,35821,27468,29581,19147,23275,10662,19048,14790,6404,8484,10597,8549,8550,14757,33675,39981,37934,35788,23112,46288,65239,65270,52429,43912,35624,23078,255},
{53020,53020,53020,53020,53020,53020,55069,53021,53021,55101,50745,35887,42226,44340,35856,25388,31630,35823,40113,42194,40048,40016,46387,44242,39983,42129,40049,35887,44209,38001,46452,48533,31889,17392,17392,17359,17360,15279,15247,13231,13231,13166,13199,13166,13166,11118,13166,15214,15182,13134,15182,17230,17230,17229,17164,15019,17067,14986,14986,17034,17002,17001,17001,17001,17001,16969,17002,17001,17002,19049,17002,16969,17001,16936,16969,12808,14889,12776,14888,12776,14856,12743,12776,10663,10695,10630,10663,8582,8582,8550,8582,8550,8582,6470,8582,31727,33873,19310,21456,23340,14954,23340,25420,23373,23308,23340,23307,23308,23275,23308,23275,14953,6535,6535,6535,6535,4422,37968,56952,54871,59097,50580,25388,10630,16904,16904,14791,12678,12743,12678,10597,10597,10597,10597,12709,25159,41767,43847,45895,45861,31334,31400,31466,29483,18983,23175,23110,21096,50448,46188,56817,52463,65336,58964,37967,48533,37902,46289,37902,12742,19015,16935,10597,8484,8484,6436,6534,12709,21063,16870,12677,14725,54642,65272,63159,65173,50284,41800,35624,20998,255},
{53020,53020,53020,53020,53020,53021,55069,55069,53021,55101,52890,38001,48533,40113,48500,27567,31792,38066,46485,48533,44307,42162,48532,48468,42129,38001,37969,37968,42129,38001,38033,33905,27664,19408,21455,19407,19375,21423,21390,21423,19374,19342,19342,21390,19310,21358,21325,21357,21292,19244,19212,19212,17131,17131,17099,14954,14921,12873,12841,12808,12808,10728,10727,10695,10695,8615,10695,10663,10695,8615,8647,8615,10695,10695,6567,6535,8583,6534,6535,6535,8583,6534,6535,6502,8582,6502,6535,6535,8583,6502,6502,6502,8550,6502,6470,29647,31727,17230,25519,44307,17034,23308,25388,25421,23308,23308,23276,23308,23275,23308,19115,8615,6535,6535,6535,6535,4454,44306,58999,61177,52530,48369,27501,10630,12743,12775,14823,12742,12743,12743,14791,12742,14791,14823,16871,21064,25257,31432,43880,35462,37674,54740,60982,44208,21095,20997,27239,37803,56687,52429,56784,54544,65368,52624,31466,52628,46190,46255,44143,14757,12709,19015,8484,6371,6404,8517,6502,8516,8484,16838,25159,29320,50318,56689,54608,56654,39785,27205,25190,16805,255},
{53020,53020,53020,53020,53021,53020,53021,53021,55069,55101,50810,38001,44339,44307,46387,31728,29647,38001,44372,46452,44242,37968,40114,40113,37936,33775,31727,33775,40081,42226,40179,35986,23438,15149,13101,13133,13101,13101,11021,13101,13101,11053,11053,13101,11085,11086,13134,13134,13101,13036,10956,10956,10923,8843,8810,8713,8680,8680,8680,8648,8648,8647,8648,8647,8648,8615,8647,8615,8647,6535,8615,8583,8648,8647,6535,6502,6502,6470,6502,6470,6502,6470,4422,6469,6470,4389,4389,6437,6469,4389,6470,6469,6470,6470,6470,33840,46419,17230,10956,31760,17066,21228,25388,25421,25388,23372,23308,23308,21227,21260,12841,6535,6535,6567,6535,6567,6535,50580,54642,54740,48271,48304,40048,25290,27403,27435,29483,29483,31564,31596,31596,31596,35757,35789,33741,37870,37870,44012,48139,50416,52496,63127,56787,29449,25190,31366,27436,29548,56655,54607,56784,54609,65433,46351,23111,35723,23079,31334,52529,31629,10662,21128,10629,8516,8516,6371,6470,8550,16805,50350,54543,54510,52430,54510,54542,58735,44043,27205,23110,16805,255},
{53020,53020,53020,53020,53020,53021,53021,53021,55069,55101,50842,31727,33775,33807,33807,27534,25421,31662,31694,31727,33742,31630,31694,33775,33743,31662,29582,38066,46453,52791,46518,38164,29842,17392,19505,19473,19505,19472,19505,19473,19505,19440,21553,19472,21553,19440,21520,17327,19407,15181,10923,10891,8843,8778,8745,6633,6632,6600,8615,6567,6535,8583,6535,6535,6535,8582,8615,8615,10663,10663,10696,10696,12808,12808,10728,12776,14857,14824,14921,14889,19082,16969,21195,19082,23276,21162,25388,23275,27501,25388,29582,25421,29646,27436,31662,29614,46387,48566,23471,35986,19114,14954,19082,14987,12873,14921,14889,12841,10761,10728,6567,6535,6535,6534,6535,6502,8583,52660,52529,50384,46191,48304,54741,46288,37967,48401,50384,40015,40080,46223,39950,31628,41998,44046,31596,39950,41997,50351,54641,52496,60981,61078,33740,21062,37736,60945,42160,42127,44140,44141,56752,54609,65400,46254,25191,31563,14823,16871,58901,46321,12742,19015,21128,14822,8451,8484,6469,6534,10596,41897,52331,52331,54444,56557,56557,58670,44043,23045,25158,20997,255},
{53020,53020,53020,53020,53020,53021,53021,53021,53021,55101,50843,35920,42161,44242,42194,35921,29679,42194,46420,48533,46420,40049,42227,46420,46355,44242,35888,38000,42194,46452,46453,50679,36115,11053,13166,11086,11118,11053,11086,8973,9006,11021,11053,11053,11053,13102,13134,15182,17229,17230,17198,17230,17229,17197,19212,19180,21260,19179,23340,23275,25421,23308,27534,25388,31694,25420,29646,27469,33807,29549,33840,27501,35888,29581,33840,31694,35887,29548,31759,27501,31727,27468,29614,25420,27501,23275,23308,21194,23275,19114,21162,17001,19081,14889,14856,21227,50613,61177,61210,54806,31629,25388,25388,29614,29582,33775,37968,40048,37968,12808,6567,6567,6535,8615,6535,6534,8583,31530,54676,65469,54774,46223,52661,46223,40016,48401,48304,42095,44241,46224,44111,39982,42063,42030,39982,44110,42030,52596,61046,41997,41963,31529,23175,31496,48333,39948,61076,44076,23143,37868,56752,54608,65203,54706,39917,21064,14791,35757,58933,54707,19016,16903,19015,12709,12677,8484,6436,6535,8484,33577,58736,58736,58769,58866,58834,60914,48236,29286,35624,29383,255},
{53020,53020,53020,53020,53021,53021,53021,53021,53021,55069,50875,35953,42194,44274,44242,35953,25551,40114,46420,50613,48500,37968,44307,46420,44274,38000,35888,35920,42162,33873,38033,46355,38099,31858,31890,34002,34003,38131,36083,40244,38164,42292,42292,42324,42324,44372,44372,44340,42292,40146,38033,35920,33872,31759,33775,29614,29646,27501,27534,25388,25420,21227,25388,21194,23275,19081,21162,16969,19082,16936,14921,12808,14888,12776,12808,12776,12808,10728,10695,8615,10695,8647,10695,10663,10695,10695,10695,10695,12776,12776,12808,12776,14856,14888,14888,25421,46387,59065,61177,52726,61079,65305,65273,65305,65273,65305,65370,65337,42128,12808,6535,6535,6534,6502,6502,6502,6502,19049,54741,63258,46322,44307,52693,46256,46321,48369,48369,46321,48402,46223,42030,39950,42030,42030,33741,39917,33577,44175,44108,25125,20964,23175,23110,52493,56849,23275,46253,52559,31432,39916,52526,52495,65302,44109,35689,27303,25257,50481,61013,58934,29548,12742,21095,8451,6403,10564,10597,6502,8517,25192,65174,65173,65272,65338,65272,65237,48204,37639,41930,35690,255},
{53020,53020,53020,53020,53020,53020,53021,53021,53021,55069,52955,33840,40048,40081,38000,33808,21260,33807,35920,38001,35887,31630,31694,29614,31662,27468,35920,42324,50679,48663,48598,50678,42292,33905,29744,31792,27631,29679,23470,25518,23438,23438,19309,19277,17197,17197,15084,15116,13003,12971,13004,13004,12971,12939,10858,10793,10760,10728,10760,10728,10728,12776,12808,12775,14888,14856,14921,14856,17002,14889,17034,16969,19114,17002,19114,17001,21195,17002,21163,16969,21162,17001,19082,16969,19049,14888,16969,14921,16969,14856,12776,12743,12743,10663,10630,14856,42161,61178,59097,56919,63192,63192,56853,52594,50482,54642,54675,46256,10695,8583,8583,6535,6534,6535,6502,6502,6502,12775,46387,58966,50449,59130,52693,42062,38000,50417,48336,35822,42095,44110,37870,39983,44078,44078,39983,39916,29285,33511,31464,33478,23175,23175,23012,50348,46320,16937,37835,65299,41931,42062,54639,56688,65302,35656,33445,37574,29417,42062,61013,61046,37902,14790,21095,12709,6403,6403,8516,8549,6534,16870,35788,39916,37901,37902,39949,37868,29416,27336,27369,25289,255},
{53020,53020,53020,53020,53020,53020,53021,53021,53021,55069,52988,35953,33807,38000,37968,35888,25486,35888,38001,38033,40081,35888,40049,40081,40016,35823,37968,38001,48500,48565,44372,50613,42292,13069,13101,15182,17262,15246,17295,17327,19375,21455,21488,23568,25617,25649,27697,27729,27729,27632,23470,23406,23406,21260,23340,19212,21260,17034,21195,19082,19115,16969,19114,14888,17034,14888,16969,12776,14921,10728,12808,10695,12808,8583,8615,8550,8582,6502,8550,8518,8550,6470,6470,6469,6502,6502,8550,8550,8582,8582,8550,10662,10663,10695,12743,10662,37935,63291,61210,52693,63160,61112,46322,35692,35724,42030,41998,19016,10695,8615,8583,6535,6534,6502,6502,6502,6502,10695,31563,52366,54610,50547,52693,46321,48467,50482,48401,46289,48369,46256,42095,42095,44111,42030,37902,46123,37670,37702,29350,27238,21127,23110,33544,60976,31497,23112,46155,58831,52527,52494,52493,54607,48333,41896,50283,39850,37771,35691,54674,56755,33611,29350,25288,14822,8452,8452,6404,8517,6534,8516,12677,14789,14822,16903,18983,19015,19048,19048,19048,17000,255},
{53020,53020,53020,53020,53020,53021,53021,53021,53021,55069,55068,42260,40113,42227,44274,42194,23438,44274,46420,48533,52661,44242,46354,50548,48403,38001,25551,23503,25583,23503,33905,54839,46518,31922,31922,31890,29842,31890,27794,27761,27761,27729,27697,25648,23568,21488,21487,19375,19343,17294,15117,13069,10955,10891,10891,10923,10794,8681,8713,10728,10728,10728,10728,10727,12808,12776,12840,12873,12873,12808,12841,12841,12841,14856,14888,14888,14921,14888,14889,14888,14889,14856,14856,14888,14888,14856,14856,14856,14856,14856,14823,12775,12775,12743,12711,10630,31694,56984,61178,56919,63192,61112,56951,56886,50580,54871,46420,6534,6502,6502,6502,6502,6470,6470,6470,6470,6470,8615,27337,54381,52497,50449,50515,39917,42128,48238,46191,33741,42062,44110,33676,37902,44046,39917,35822,50349,41895,33477,35590,21127,18917,27238,52395,35655,37770,44076,58831,52462,52527,60945,41864,41831,35525,41798,27205,8452,16870,25257,56821,61013,54740,27337,25223,19015,8452,8451,10564,8452,6470,8517,12677,16902,16935,19015,21096,21096,21129,19048,19048,17000,255},
{53020,53020,53020,53020,53020,53021,53021,53021,53021,55069,55069,40212,40113,42227,44274,44275,23373,42162,40146,50581,42226,42129,42194,35986,36018,46453,46518,42357,44438,42357,46518,44438,27794,11150,15247,13199,13231,15247,13199,15247,15247,15246,15247,17327,17295,15247,17295,19342,19310,19310,19342,21358,21325,21293,19245,17100,17132,14986,17067,14954,19082,16969,17001,14889,16969,14856,17001,17002,17001,14856,12808,12775,12776,10695,10727,10663,10663,8615,8582,8550,8550,8550,6502,6469,6470,6470,6470,6470,6470,6469,6469,6470,6469,6470,6469,4389,27533,65371,63291,61177,63192,58999,54806,56887,50580,54839,46420,17002,6535,6502,6502,6502,6502,6470,6470,6470,6470,6535,23177,52333,50417,50482,50547,46289,50482,50449,48369,48402,48369,48336,44176,46256,46256,44175,46289,50416,50282,46154,29415,23175,35624,39718,52395,50413,54640,48302,58864,48301,35756,41995,31300,35427,39686,27141,12612,8484,21031,27305,50449,61013,61046,35822,16902,21128,16935,12709,8451,6404,6470,8550,12677,16902,18983,19047,21128,21128,21128,19081,19049,17001,255},
{53020,53020,53020,53020,53020,53020,53021,53021,53021,55069,55069,38099,31694,33775,35823,35855,21260,31662,29614,33774,29582,33742,48532,40277,38229,40244,40212,33971,38131,44372,29745,25584,21423,21422,21390,21390,21390,19310,17229,19277,19277,17197,17165,17196,17164,17164,15084,15116,15051,15084,13004,13036,12938,12906,10890,10956,10760,8648,8680,8648,8648,8615,8615,8615,8615,8615,10695,12808,10760,8583,8615,8647,8647,6567,6567,8583,8615,6535,6535,6534,6534,6502,6534,6502,6502,6502,6502,6534,8583,8583,6502,6502,6470,6502,6469,6469,12776,25388,21195,46354,65272,56919,52725,56919,50613,56919,50613,29614,6535,6502,6502,6502,6502,6470,6470,6470,6470,6535,21097,50253,48304,52563,48401,39918,44208,46126,39917,37903,44078,41997,29516,41997,44077,33708,37934,48303,46223,37965,23175,29318,63058,54607,46154,44010,60947,60914,44174,35855,29483,27173,31333,37508,50315,44042,35690,37769,50413,42029,31596,50482,58933,46321,16903,19015,21128,14822,8484,8484,6469,6534,8484,14822,19015,21096,21128,21128,21128,21129,17000,17001,255},
{53020,53020,53020,53020,53020,53020,53021,53021,53021,55069,55069,38067,37968,42161,42194,42227,33905,42227,44307,46420,46387,42161,42226,44340,44405,48598,54904,46616,52824,54904,54904,44405,29777,9005,11053,11053,11118,11086,11086,13134,13166,13166,13199,15247,17295,17327,17360,17327,17294,15247,13068,10923,8810,8713,8745,8778,8713,8648,8680,8648,8648,8647,8647,8615,8615,8615,8647,10760,10793,10761,10761,12841,10760,8647,10728,8648,10728,8648,6502,6469,4422,4422,4389,4389,4389,4389,4389,4389,4389,4389,6437,6437,6437,6437,6437,6470,6469,6469,6437,42096,65305,56887,54773,56919,46419,56919,50580,25421,6503,6502,6502,6502,6470,6502,6502,6502,6470,6502,16936,46126,48271,50547,50482,46321,50515,48337,44208,46289,48336,46256,42095,46223,46256,46321,46321,48402,50547,29548,23143,46155,60877,63188,35688,23013,48303,65171,35721,39884,46058,41766,46091,56721,54705,16771,8484,8517,16871,29549,25519,40015,58901,54708,19048,16902,16934,8516,10629,10596,8517,6502,8516,14757,21095,21096,21128,21128,19081,19081,19049,17001,255},
{53020,53020,53020,53020,53020,53020,55069,53021,53021,55069,55101,44536,40245,44503,44503,46583,50842,50810,48697,48761,50810,50777,50842,52923,52923,52890,55068,55068,55036,57148,59164,44470,36116,21553,23633,21553,21585,19473,19505,21553,21553,19472,19472,21520,19440,19440,19440,17360,15214,15182,10988,8908,8843,8810,8778,8713,8713,8648,8680,8647,8647,8615,8647,8615,8615,8615,10728,14986,15019,17132,17067,15019,14986,12906,14986,14954,14986,14953,12808,12776,14856,14889,14856,16969,14888,19082,16937,21195,21195,25388,19082,25388,23243,27501,21227,27501,21130,29581,21162,46386,65273,56886,54805,56919,48500,56952,50613,23308,6502,6502,6502,6502,6470,6470,6502,6502,6470,6502,14856,41997,48271,52628,46288,37902,46256,48271,39950,37934,44078,37804,35789,41965,41965,31596,39983,48369,42128,23208,29416,63090,58635,60910,52591,16804,27369,63059,35690,31366,41798,43945,61014,65303,54771,21063,14855,14856,14856,29581,52727,50579,61046,56821,23210,14822,21095,12644,6371,8451,10596,6502,8549,12709,21063,21128,21128,21128,21129,19081,19081,17001,255},
{53020,53020,53020,53020,53020,53020,53021,53021,53021,53021,55069,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,55101,57181,57181,55101,55068,55068,55036,52988,52824,36018,9005,9038,9006,9038,9005,6957,6957,6957,8973,9005,9005,8973,8973,11053,11053,11021,13101,13069,13134,15117,15084,17099,14986,17100,14954,19147,17002,21260,17002,23308,21130,25421,19114,27469,23275,29582,25356,27534,25388,27501,25388,25388,27468,25388,27436,25323,25388,23275,27468,23242,27468,21162,25388,21130,25388,21227,25388,21130,25356,21195,25356,21195,25355,21162,25356,21162,46354,65305,63192,58999,54806,48500,56952,46419,19114,6502,6502,6502,6502,6502,6502,6470,6502,6502,6502,10728,35789,48271,54741,46256,42096,46256,46223,44143,44240,46223,44143,44208,46223,46224,44176,46289,44176,25321,21062,46156,65236,54443,60779,65202,25158,29449,54574,41897,35558,41832,58900,63192,65302,52592,18852,8484,8484,8517,10597,37935,52594,58900,56820,27370,25288,23208,16902,10564,10564,8484,6469,6534,12677,19015,21128,21128,21160,21129,19081,19081,17001,255},
{53020,53020,53020,53020,53020,53020,53020,53021,53021,55069,55069,55069,55068,55068,55068,55068,55068,55068,55068,55068,55069,55101,57149,55068,44536,27795,27795,27794,27762,27762,27762,29809,29745,25649,25681,27762,29810,31922,29842,34003,34003,36083,36083,38164,38196,38131,42292,40243,40244,38099,38066,27599,35953,27501,31727,25388,33807,23275,31694,23275,31662,23275,29581,23275,27501,23243,27501,27501,29614,27533,31694,29614,29646,27534,29646,27534,27501,29581,27468,27468,25388,27501,25356,27501,23308,27533,21195,31694,27468,31727,23275,33807,27468,33807,25355,33775,25355,33775,25355,46387,65305,65272,61079,58999,56886,58999,54806,38000,14921,14921,12809,14954,17002,19115,23275,10663,12776,19049,19049,44306,48271,54741,44208,42128,48337,48303,37902,42095,46158,37869,37869,44077,42030,40015,39982,33610,21127,23110,48300,65137,54475,58732,65169,54673,50415,37736,31397,44010,58834,63159,63158,65269,52559,35657,39883,43979,44009,25223,21064,37836,58868,56788,48269,43976,25255,12741,6371,6371,6403,8517,6502,6436,14790,21128,21160,21160,21161,19081,19081,17001,255},
{53020,53020,53020,53020,53020,53021,53020,53021,53021,55069,55069,55068,55068,55068,55068,55068,55068,55068,55069,55068,55069,50907,38294,38196,46485,44438,40309,44470,40309,44437,40276,44437,42356,44405,40244,42324,38131,40211,36083,38131,36051,38131,36018,36018,33970,33938,35985,31890,33905,31825,31824,29679,31792,27534,31759,27501,31727,25388,31727,23308,29647,23307,29679,25356,31694,25356,31694,27501,31694,25420,29614,27501,31662,29614,27533,33775,31662,31727,27501,35855,29581,35920,29614,35952,29581,35953,29613,40081,33774,38032,29613,38000,31661,38000,31661,38000,31694,38000,31661,40048,35822,40080,33741,37967,31596,35887,31661,35887,29549,33774,25387,33807,33742,37968,44274,25322,23274,31531,29418,44306,48271,52660,42030,37967,46224,48238,39983,44176,46191,44176,46256,44143,44111,44240,42128,27336,21062,20932,48203,50315,41898,63024,52492,63123,46220,29317,33445,44011,63127,63159,63159,65335,54672,16804,4291,14627,25060,21030,21097,31596,50515,48434,33709,25257,27402,16967,4291,8484,10564,6371,6470,8549,12677,21128,21161,21161,21161,19113,19081,17033,255},
{53020,53020,53020,53020,53020,53020,53021,53021,53021,55069,55069,55069,55069,55068,55068,55068,55068,55068,55069,55069,55068,48729,38196,38164,40179,36051,31890,34003,31890,36051,33970,38131,36051,40212,38098,42324,40179,42324,38164,44405,42357,42357,44405,44437,46550,42324,48566,42292,48598,42259,44340,33840,40146,29614,42227,31694,38065,27501,38033,29582,38033,29581,38033,31662,40081,31726,38000,33775,38000,31727,33839,33807,35887,38033,33840,38000,38000,35887,31694,35920,33774,38000,33807,38000,33774,38033,31694,40081,35854,38033,29581,38000,31661,35920,29581,35887,29549,35887,31661,35855,29548,31726,29549,31694,27468,31694,27468,31694,29581,31661,25355,31693,29581,40113,54806,44077,41964,43947,27305,31662,48304,52693,44176,44273,48336,46223,40015,44175,44110,35757,39950,41965,39917,42193,42128,25256,27303,46091,58831,37704,39849,63056,31398,33576,33510,33380,35558,46059,61046,63159,63159,65334,56752,33609,29384,33577,31596,35822,48400,35789,46289,50547,31661,33742,29449,23208,16967,12677,6403,6404,6502,6502,10597,19048,21161,21161,21161,19113,19081,17033,255},
{53020,53020,53020,53020,53020,53020,53020,53021,55069,55069,55069,55069,55068,55068,55068,55068,55068,55069,55069,55069,55069,55101,55068,55003,54937,52857,46583,52824,46615,54905,48631,54904,50744,52824,48630,52791,46550,50711,48630,50711,48631,46550,50711,50711,50678,46518,50678,48565,48565,42259,46420,38001,46420,33840,42259,38033,42258,31694,42194,31694,40113,31726,38033,33774,40145,33839,35920,33774,38000,31727,35887,33774,35887,35920,33775,35887,35887,33807,31694,35887,33774,33807,31694,35888,31694,35920,31726,33839,33774,33774,29581,33839,31726,33807,29613,33774,29581,33807,29581,33774,27468,31694,25355,31694,27436,31694,27435,31629,27468,29613,23242,31628,25323,29549,42095,44011,43947,44013,40114,37967,50384,50515,37837,37967,46158,41998,35854,44143,44078,35822,42063,46158,46223,50580,35854,21095,41996,63091,46154,41830,50315,58798,35525,35460,33347,33348,50316,56785,58932,63158,63126,65334,44173,27271,33674,25516,13034,29480,50218,33578,48369,58933,33741,40015,23111,25288,19047,14790,10564,8451,6436,6534,8484,16903,21161,21161,21194,21194,19114,17033,255},
{53020,53020,53020,53020,53020,53020,53020,53020,53021,53021,55069,55068,55068,55068,55068,55068,55068,55068,55068,55069,55069,55069,55069,55101,57149,55068,55035,55036,52955,52857,44405,52791,59065,52791,48598,50711,46518,50679,48598,48598,48630,48566,50678,48566,48598,44405,48565,44404,46452,40113,44307,35920,42226,35920,40113,35887,40113,31694,38000,35952,38000,31662,33839,31694,35920,33775,33807,31694,33807,31662,33774,29646,33807,31694,31694,31726,31727,31694,31661,31727,31726,33807,31662,35920,31726,35887,31694,38033,33839,33839,29581,35887,27501,35888,29613,31662,23275,25388,19081,23242,19017,19081,14856,16936,14823,14888,12743,12775,10663,10662,10630,10630,10630,10662,25322,23144,25225,29451,52759,42128,48336,50580,44176,46354,48368,44208,44208,46255,44110,37869,44143,42030,35756,46321,31627,23175,54606,65236,35624,35591,58798,54637,41765,48038,41765,48170,56754,48532,50548,58934,63126,65367,27369,20998,40076,4876,650,16933,43783,39982,37837,38033,23242,50547,23144,21095,16902,8483,10629,10629,8549,6502,8516,12677,25354,25354,23242,21194,19146,19114,255},
{53020,53020,53020,53020,53020,53020,53020,53021,53020,53021,53021,55069,55069,55068,55068,55068,55068,55068,55068,55068,55069,55069,55069,55069,55069,55069,55069,55069,48697,48630,46517,40179,46387,44372,38066,42259,38066,40146,38066,38066,40114,35985,40146,35986,42226,35953,40178,38033,42194,35920,38033,33807,40113,33807,35952,31727,38000,31661,35952,35920,38000,31662,35920,31694,35920,33840,35887,33775,35920,31726,35887,33807,35888,33775,33774,35887,33807,33807,31726,33807,33775,35887,31694,35920,33774,37968,31694,38000,33807,35920,29614,35887,31661,35887,27500,25420,21162,37968,29549,27436,27436,10695,8582,8582,6502,8582,6470,6502,6470,6469,6469,6437,6437,6469,4389,4389,2276,14921,46387,37935,50450,48337,35724,42095,46158,39917,33774,44078,41997,33709,42062,44078,37869,44241,25320,29448,50380,56784,52527,39750,50412,37702,39750,39718,23012,50416,54675,61079,46452,50580,65239,65368,27304,16968,15309,617,650,23238,43913,40015,31531,25649,17034,56820,27435,16903,21128,14725,6371,8451,8581,6502,8550,12677,25322,27435,23307,23274,21194,17066,255},
{53020,53020,53020,53020,53020,53020,53021,55069,53021,53021,55069,55069,55069,55068,55068,55068,55068,55068,55069,55068,55100,55069,55069,55069,55069,55069,55069,55069,55101,59196,54970,46551,48565,46518,40277,44405,44405,46485,44437,44437,48598,46517,48598,44469,50711,46518,50711,48598,50678,44404,46485,38034,44339,33839,40178,33775,40146,31694,40145,33775,40081,31694,38033,31726,38000,35888,35952,35887,38001,33839,38000,33840,37968,33807,33839,35855,35887,33807,33774,35888,33807,35887,33774,37968,33807,35920,31694,35887,33775,35887,31694,37967,33774,33872,31662,40081,29581,46387,37935,33742,19017,6470,6502,6470,6470,6469,6470,6469,6469,6469,6469,6437,6437,6437,6437,6437,6437,6470,29614,56886,50547,48434,44208,46353,48336,46256,46353,48336,44175,40015,46256,46223,39982,37934,21127,39850,44043,52524,60976,46088,56750,39784,35558,33446,12644,44045,54543,58999,50679,56919,65206,65335,27271,23144,31823,23599,19731,48591,65203,63258,31628,31825,29549,54675,33643,23143,23176,18982,10564,10564,8484,8517,6502,10629,21161,25387,23339,21227,19146,17066,255},
{53020,53020,53020,53020,53020,53020,53020,53021,53020,53021,55069,55069,55069,55068,55068,55068,55068,55068,55069,55068,55101,55069,55069,55069,55069,55069,55069,55069,55100,48761,46551,54905,59065,52824,48598,48598,48598,46517,50678,48565,48565,44372,46485,44372,46453,42227,44339,40146,42259,35953,40146,35920,40113,35920,40113,33774,38000,33775,38000,33775,38001,33807,38000,33807,38001,35952,38033,37968,38033,33840,38000,38000,38033,35920,35920,38000,35920,35920,35887,40081,38000,38033,35920,40113,35887,40113,33839,38000,33774,38033,35854,37968,31661,35920,29549,27501,14823,29582,35855,23275,6502,6502,6470,6470,6470,6470,6470,6469,6469,6469,6469,6437,6437,6437,6437,6437,6437,4324,29614,63193,50514,44111,33709,44176,48206,37837,37902,46126,39884,31596,44078,44078,42095,29514,21063,44172,46156,48299,61009,56719,48268,39784,46090,48303,23111,41931,44109,54772,59032,61079,65206,65302,35657,46091,63092,61177,48727,58926,65170,63225,37902,19049,25355,54674,41963,37639,25223,14790,8451,6371,6371,8516,6502,6436,14822,25387,23307,21227,19146,14986,255},
{53020,53020,53020,53020,53020,53020,53020,53021,53021,53021,55069,55069,55069,55069,55068,55068,55068,55068,55068,55069,55069,55069,55069,55069,55069,55069,55101,50875,46518,48598,44372,46452,48565,42292,38098,40146,40146,40146,44372,44307,44372,42259,44372,42291,46485,44372,46517,46485,48566,46452,48565,44372,46485,40146,44339,37968,42259,35920,40146,35887,42226,35952,40146,38000,42194,40113,40113,35887,38000,35920,38032,33807,37968,35887,33839,35887,35887,33839,33774,35887,33807,35887,33774,35887,35855,38001,35920,35887,31694,35952,33774,35887,33742,33807,27468,25388,12743,25388,33742,10695,6470,6502,6502,6469,6470,6470,6470,6469,6469,6469,6469,6469,6469,6469,6437,6437,6437,4389,16969,37870,52596,48369,46289,48401,48336,44175,44241,48303,42063,40015,44110,42062,35821,25288,18982,25190,56654,63057,63057,58897,35624,46123,63093,52626,27271,37706,48269,54608,63191,63127,63126,61141,33545,48204,33643,40568,24152,50667,65136,63192,44273,10630,21129,61014,56820,25257,21063,19015,8484,8484,10564,6403,6437,8549,12644,21194,21226,19146,17066,17066,255},
{53020,53020,53020,53020,53020,53020,53020,53020,53020,53021,55069,55069,55069,55068,55068,55068,55068,55068,55068,55068,55069,55069,55069,55069,55069,55069,55069,55068,54970,57018,52857,46550,46485,52791,52792,50743,52791,50711,54904,50711,52824,50711,52824,50711,52823,50678,52791,50678,52759,46485,48565,44404,46517,40179,42259,37968,42194,31727,38033,35855,38033,33775,38000,33775,38000,35920,35919,35855,35952,33839,35920,33807,35920,35887,33807,33807,35855,31727,33774,33807,33807,33807,31694,31727,31694,33807,31694,31726,31662,33775,29613,29614,29581,29581,27468,35920,21129,23308,23275,4422,6502,6470,6502,6470,6470,6470,6470,6469,6469,6469,6469,6469,6469,6437,6437,6437,6437,6437,4357,14791,52628,44077,35790,46191,44045,31596,39982,44012,33611,33709,41932,39885,29515,23175,29416,52526,54509,58864,37769,42027,29220,37672,58900,52627,31563,48303,54706,56754,63159,61046,63092,63156,54542,56688,46288,40633,17976,50635,65039,65139,52495,21162,29483,58900,58965,33741,16902,21128,16967,12677,6403,6403,6469,6502,10597,19081,21226,17098,17098,17066,255},
{53020,53020,53020,53020,53020,53020,53020,53020,53020,53021,55069,55069,55069,55069,55068,55068,55068,55068,55068,55069,55069,55069,55068,55069,55069,55069,55069,55069,55101,55101,55101,55003,52824,52824,50679,48598,50678,46485,50678,46485,48598,44405,50645,42292,46485,42292,46452,40146,44339,38066,40146,40146,42226,35952,38000,33774,35920,31694,33840,31727,35887,33742,33807,29614,33807,33775,31726,31727,33807,33774,33774,31727,33774,33774,31726,31694,33774,31694,31694,31727,31726,31726,31694,33807,33774,33807,31694,33807,33807,35920,31694,33742,31629,31694,25355,35887,37869,16969,8648,6502,6502,6470,6502,6469,6470,6469,6470,6469,6469,6469,6437,6469,6437,6437,6437,6437,6437,6437,4389,12775,50580,46256,44241,48369,48336,44176,46289,46223,40014,42063,44111,44143,37901,23143,46254,52526,52397,50413,35493,37507,27107,39785,60914,60980,44076,50317,56753,50511,56886,63192,63124,65236,56754,48368,25290,23827,5557,44361,65007,65141,54608,27370,39983,58933,61014,44241,14822,21128,19080,14790,8516,8451,6436,6502,8484,14822,21227,19147,17066,15018,255},
{53020,53020,53020,53020,53020,53020,53020,53020,53020,53021,55069,55069,55069,55068,55069,55068,55068,55068,55068,55068,55068,55069,55069,55069,55069,55101,57181,57149,57149,57149,55068,42390,48598,48532,40179,38066,42227,36018,40211,38066,40179,33938,40179,38066,44339,38098,42291,40211,44339,40146,40179,35953,40113,40146,38066,33807,38033,31727,35953,33807,38000,33775,35920,33807,35920,33807,35920,33807,35920,33839,35920,35920,38033,33839,35920,35887,35888,33839,35887,37968,37968,33840,35887,37968,37968,35920,33807,38000,35888,38033,29711,23307,19049,14888,14856,35887,37837,16969,6600,6502,6502,6469,6502,6469,6470,6469,6470,6469,6469,6469,6437,6437,6437,6437,6437,6437,6437,6437,4357,12808,48467,39917,35822,46158,44045,33709,41998,41964,27435,35789,39852,35724,27402,23175,52592,46189,56655,63024,47974,43845,44012,58901,61046,56821,33610,43882,50414,46286,63193,63225,63190,65401,54806,16904,12711,27858,19991,36373,58997,65108,48334,31498,42095,56821,56820,52660,19016,16935,16935,8484,10597,10596,8484,6470,8549,12644,19114,17066,17098,15018,255},
{53020,53020,53020,53020,53020,53020,53020,53020,53020,53021,55069,55069,55069,55069,55068,55068,55068,55068,55068,55068,55069,55069,55069,57149,55101,48762,34069,27859,29875,29842,27762,29809,46453,52759,48631,46517,50711,44470,50744,46550,52791,48598,50743,48631,52791,48598,52759,48598,50710,46485,46485,44372,44404,44340,44307,37968,40113,33840,38001,35920,40113,35888,35952,35887,35920,33839,35920,35887,35920,35855,35887,35920,35920,33807,33839,35920,33839,33775,31726,33807,35887,33774,31694,33774,33775,33774,33742,31759,33775,31727,29614,33807,23308,6469,8550,33742,31563,12808,6600,6470,6470,6470,6470,6469,6470,6469,6469,6469,6437,6469,6469,6437,6437,6437,6437,6437,6437,6437,4357,12776,33774,25322,25322,27370,23209,21129,21064,16903,14791,14823,12710,12678,18983,25255,56817,54673,56688,56654,41766,35558,48434,61112,61079,59032,52563,52399,46287,52593,63192,63160,63190,65401,44274,6469,21227,38585,24152,32376,54903,62994,44011,35691,31563,31661,44208,58998,27435,12710,21128,12677,6371,8451,10564,8549,6502,10564,17033,17066,17066,15018,255},
{53020,53020,53020,53020,53020,53020,53020,53020,53021,53021,55069,55069,55069,55069,55068,55068,55068,55068,55068,55068,55069,55069,53020,44569,38229,44405,44437,40277,46518,40309,44470,42357,50711,50646,48566,44339,46485,40179,44372,42259,42259,38066,44307,40178,42227,38033,40146,35953,40146,35920,35985,38001,38033,31759,35920,33807,35887,33774,33840,31694,35888,31726,33839,31695,33839,31694,33807,29646,31727,31662,31727,31759,33807,33774,33807,33839,33807,31727,33775,33807,35888,38033,38000,42194,42226,46387,46387,46452,48532,48500,50613,50678,31727,14921,14888,33775,19049,8615,6600,6470,6470,6470,6470,6469,6469,6469,6469,6469,6469,6469,6437,6437,6437,6437,6437,6437,6437,6405,6405,6502,4389,4324,4324,4324,4324,4324,4324,4324,4324,4324,4324,4324,16902,29416,63121,63057,63025,44042,35525,33284,41965,61046,61046,61046,56657,56233,54576,52658,63192,63160,63223,65401,35887,6437,23308,40666,20055,18008,48661,62896,37705,37738,23177,14986,37869,61013,33676,12742,19047,16903,10596,8484,8516,8517,6502,10629,16935,15018,14986,14986,255},
{53020,53020,53020,53020,53020,53020,53020,53020,53020,53021,53021,55069,55069,55069,55069,55068,55068,55068,55068,55068,55069,55069,50842,38165,34035,40179,40179,33938,36083,33970,36083,33905,38066,40146,44372,40146,46452,38131,44372,44372,46485,40244,46517,44437,50678,46518,48630,46550,48598,46518,46518,46485,44372,40178,40114,38066,40113,33807,35953,35920,35920,33840,38001,33840,38033,35888,38000,40081,40113,40080,35920,35888,33807,31727,31694,38000,33807,31694,31694,29581,44307,63291,54904,63257,56919,63258,61145,63192,63225,61079,48532,37968,35920,6437,6437,29647,17001,6502,8648,6470,6470,6470,6470,6469,6469,6469,6469,6469,6437,6469,6437,6437,6437,6437,6437,6437,6437,6405,6437,6437,6437,6437,6437,6404,6404,6404,6404,6404,6436,6404,6372,6404,19015,31529,63056,65235,50413,31365,31333,37380,41835,61014,61046,61046,58737,60587,54576,52658,63159,63126,65270,65401,46320,29417,31595,36114,34326,42582,54837,62929,50316,48269,35723,31629,42095,54674,27369,12644,16902,14854,6403,6403,6371,6404,6502,6469,10629,15018,15018,12938,255},
{53020,53020,53020,53020,53020,53020,53020,53020,53020,53021,53020,53021,55069,55069,55069,55068,55068,55068,55068,55068,55068,55068,55101,55068,55003,54905,52857,46583,52824,46583,52857,48696,54937,52856,54937,50744,54937,50776,54937,52889,57018,56984,52758,44372,46485,38098,38066,42292,40243,42259,42259,42227,40146,38066,38033,35953,33840,31695,33807,33807,33774,33807,31727,31694,35822,31694,31694,31694,33742,33742,31629,29581,29549,27501,27501,29581,27501,27501,27500,27468,40081,59098,54904,63193,56886,61177,61144,61046,63160,61014,56952,31727,21130,12743,17001,40212,21227,8582,6600,6502,6470,6470,6470,6469,6469,6469,6469,6469,6437,6469,6437,6437,6437,6437,6437,6437,6437,4357,6405,4357,4356,4356,4324,4356,4324,4324,4324,4324,6404,6403,4323,10564,23175,21062,31463,58832,54639,46122,46026,39558,43947,61013,63126,61046,58769,62798,54609,50513,63127,63158,65270,65304,37868,25191,20999,15212,21908,34293,58900,58801,39752,41898,33545,42129,61047,61014,50514,18984,12742,19015,6371,4291,8484,8484,6437,8550,10564,14953,15018,12938,255},
{53020,53020,53020,53020,53020,53020,53020,53020,53020,53021,53021,55069,55069,55068,55068,55068,55068,55068,55068,55068,55068,55069,55069,55069,55101,57149,57116,55036,55068,55036,55068,55068,55068,55068,55068,55068,55068,57116,55068,55068,57116,63225,52627,35855,38099,23471,29679,35953,35985,35985,35985,35953,35985,35953,35953,35953,35985,31694,33775,31727,33775,33775,33775,33742,31726,31726,31694,31662,31662,31662,29614,31661,31661,29581,29581,33774,31694,27500,27500,27468,27501,29549,42193,63257,59031,63258,63257,63192,63225,58966,56919,48565,40114,8550,16936,54904,17067,8550,6600,6470,6470,6469,6470,6469,6469,6469,6469,6469,6437,6437,6437,6437,6437,6437,6437,6437,6437,6405,6405,4357,4356,4356,4356,4356,4324,4324,4324,4324,6404,6404,4323,14790,25320,21063,39850,58832,46220,33413,31301,35300,39657,56820,63126,61046,54511,64911,60948,58965,63159,63159,65303,65271,39982,33642,37803,36146,13880,11831,54935,62994,50348,58734,48236,31531,60981,58965,56853,27468,10662,19080,12709,10597,6403,6339,6436,6502,10597,14855,12938,12938,255},
{53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53021,55069,55069,55069,55069,55068,55068,55068,55068,55068,55068,55068,55069,55068,55069,55069,55069,55069,55069,55069,55069,55068,55068,55068,55068,55068,55068,55068,55068,55068,57116,59098,56919,44274,38065,33840,33840,35985,38033,35985,35985,35985,35985,35985,35920,35952,35953,33775,33775,31727,31727,33775,33775,31694,31694,31694,31661,31661,31662,29614,29581,31661,31662,31661,29581,31662,33742,27468,33774,29549,27468,25356,48500,58999,48467,54805,52660,52628,48532,42160,48499,54871,44339,16937,16936,38033,15019,8582,6599,6502,6470,6469,6470,6469,6469,6469,6437,6469,6437,6437,6437,6437,6437,6437,6437,6437,6405,4357,6405,6405,4357,4356,4356,4356,4324,4324,4324,4324,4324,4324,4291,12677,25256,37802,58766,50216,29154,27172,50315,50250,54477,58867,63126,63126,58834,65042,63061,63126,63159,63158,65303,63158,29417,21031,21031,23729,7735,28248,56918,54575,35592,41930,39981,27370,54739,58933,58966,37934,10662,16967,21128,14854,8484,8484,6436,6502,8549,10629,14953,12938,255},
{53020,53020,53020,53020,53020,53020,53020,53020,53020,53021,53021,53021,55069,55069,55069,55068,55068,55068,55068,55068,55068,55068,55068,55068,55069,55069,55069,55069,55069,55069,55069,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,52857,52791,46322,35887,31727,33840,35985,35985,35985,38033,35985,35985,35985,33872,33872,33840,29614,31694,31694,29614,31662,31662,29581,29613,31662,31629,31661,31661,31662,31662,33774,35822,35823,35855,35887,37968,37968,48467,44242,42161,44274,54806,29581,14920,33709,33709,33677,19081,25290,46387,50678,40113,10663,6469,12873,19147,8582,8647,6502,6470,6469,6469,6469,6469,6469,6437,6437,6437,6437,6437,6437,6437,6437,6437,6405,6405,4357,4357,4357,4356,4356,4356,4356,4324,4324,4324,4324,4324,4324,4291,12645,25256,31496,63057,54408,39653,39754,35463,33285,37544,50449,56820,54740,52366,64911,60948,61046,63192,63159,65335,58965,12710,8517,10598,33904,44566,50710,54805,50514,39982,44176,40048,29483,46320,61014,61046,46386,14855,14854,19015,12677,10596,8483,4323,6437,6502,10532,14888,12905,255},
{53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53021,53021,53021,55069,55069,55068,55068,55068,55068,55068,55068,55068,55068,55069,55069,55069,55069,55069,55069,55068,55069,55068,55068,55068,55068,55068,55068,55068,55068,55035,50777,52889,54872,44274,35856,33775,35920,40113,40114,40146,40178,42226,44307,44339,44307,44339,44339,46387,46419,48467,48499,50580,50613,52661,52693,54773,54806,56854,56886,56918,56886,56918,58998,58966,58966,58966,56886,56853,56821,56886,50547,50546,48467,19114,17001,33774,33774,33741,21130,29548,44339,35953,23308,12776,12775,14986,10923,10630,8615,6502,6469,6469,6469,6469,6469,6469,6437,6437,6437,6437,6437,6437,6437,6437,6437,6437,6405,6405,4356,4357,4356,4356,4324,4324,4324,4324,4324,4324,4324,4324,4291,10564,23207,35723,54606,46056,35592,46158,31303,31108,33253,50416,46256,40015,52398,64909,58868,61079,63159,63127,65367,54739,12645,10598,12710,48302,63061,63094,63093,48237,37672,39850,31563,31595,37869,61013,61013,52659,21129,12742,19047,10564,8451,10596,10597,8549,6502,8484,12743,12906,255},
{53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53021,53020,55069,55069,55069,55068,55068,55068,55068,55068,55068,55069,55068,55069,55069,55069,55069,55068,55069,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55035,55003,55035,54970,54839,58967,54806,56886,58999,58999,58967,58966,58966,56886,56885,56886,56853,54805,56853,56853,54708,52659,52627,52595,50515,50514,50481,48369,48369,46289,46288,44175,44176,44175,44143,42063,42063,39982,41998,44176,48467,31531,33676,40081,23243,19050,31661,31661,35789,21130,29549,48533,52759,50678,19082,10695,21195,15117,10663,8647,6502,6469,6469,6469,6469,6437,6437,6437,6437,6437,6437,6437,6437,6437,6437,6437,6405,6405,6405,4356,4356,4356,4356,4324,4356,4324,4324,4324,4324,4324,4324,4291,10564,23207,37836,56751,37671,31563,46159,35496,33252,39524,43814,39686,39982,52332,64909,58802,61079,63160,63126,65367,50546,10565,10630,16871,54575,63061,63093,65108,43979,41800,39851,27402,29547,27402,48401,61014,58933,31661,10662,19015,14822,8483,6371,8451,8516,6502,8549,12742,12905,255},
{53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53021,53021,53021,55069,55069,55069,55069,55068,55068,55068,55068,55068,55068,55068,55068,55069,55069,55069,55069,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,57116,52694,48434,44209,44241,46322,46321,46289,44241,44241,44208,44240,44208,42160,42128,39983,39983,44176,42063,42062,42063,39983,42063,42063,39983,39983,40015,40015,39983,40015,42063,42095,42096,42096,42095,44143,48401,50548,27370,29483,44241,46321,52628,56886,54773,54708,33742,44241,52725,54839,52759,19049,6698,15182,17132,8582,8615,6535,6469,6437,6437,6469,6437,6437,6437,6437,6437,6437,6437,6437,6437,6405,6437,6405,6404,6404,4356,4357,4356,4356,4324,4324,4324,4324,4324,4324,4324,4324,4291,10597,23208,39947,54605,31397,33740,44079,37577,43684,54244,48036,37604,41931,56526,58638,56788,61079,61111,63158,65400,44207,8484,8550,23144,58736,65173,65206,65140,43978,48106,48204,37835,37803,31530,35690,60981,56820,31530,14789,21095,16935,10596,10564,8484,8484,6469,6502,10596,14888,255},
{53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,53021,53021,55068,55068,55068,55068,55068,55068,55068,55068,55068,55069,55068,55069,55069,55069,55069,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,57116,50646,38001,40178,42226,42194,44274,44274,44274,46354,46354,46354,46354,48434,48434,46322,46322,48467,48434,50482,50515,50547,52595,52628,52660,54741,54741,54773,56821,56853,58934,56886,58934,58966,58967,58967,58999,54773,31596,25257,37967,58999,65338,65338,65305,63225,61080,61145,54806,48533,42226,16969,4487,10956,17132,6502,6567,6535,6437,6469,6469,6437,6437,6437,6437,6437,6437,6437,6437,6405,6437,6404,6437,6405,6404,6404,4356,4356,4356,4356,4324,4324,4324,4324,4324,4324,4324,4324,4323,10597,21127,31562,33608,29317,37868,44143,41835,41670,52262,52295,45958,39753,48140,54609,58900,61013,54707,60981,65302,52560,37835,39883,48301,62994,63060,65205,63026,43945,52396,52429,46156,46156,37835,35625,58899,33675,25224,20998,23143,19047,8484,8419,6339,8452,8517,6502,6404,12775,255},
{53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53021,55069,53021,55069,55069,55069,55069,55068,55068,55068,55068,55068,55068,55068,55068,55069,55069,55069,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,52825,50581,50613,52693,54806,56854,56854,58934,58966,58967,58999,58999,61047,58999,61145,63193,59032,61080,61112,61112,61112,61145,61144,61112,61112,61144,59064,59064,61112,61112,59032,61112,61112,61112,59032,61112,56854,35692,33611,52660,63225,61144,58999,61047,61079,63160,63225,56919,42259,29614,19082,10663,16969,19213,4356,6502,6567,6437,6437,6437,6437,6437,6437,6437,6437,6437,6437,6437,6405,6437,6405,6437,6405,6404,6404,4356,4356,4356,4356,4324,4324,4324,4324,4324,4324,4324,4324,4291,12710,27433,18982,21030,48300,52526,52529,52463,50218,50119,50150,56521,60748,58701,60882,56787,56853,50547,63125,65270,44076,31497,29449,46222,63027,63060,65173,63060,52397,52462,50382,46188,52494,33643,29451,52595,14856,25322,29515,18950,21128,12709,8451,10564,8484,6371,6502,6436,10597,255},
{53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53021,53021,55069,55069,55069,55068,55068,55068,55068,55068,55068,55069,55068,55069,55069,55069,55069,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,61211,65305,56984,56951,63225,61145,61145,63193,63193,61145,61145,61144,61112,61079,63225,63225,59032,61112,61112,61080,61112,61112,61112,59032,61112,61112,59064,61079,61112,61112,59032,59031,61112,59032,58999,59032,54708,60883,62831,65207,63225,61145,63225,61079,61080,63192,63225,54838,52758,56952,29614,10663,16937,23340,4324,6470,6567,6437,6437,6437,6437,6437,6437,6437,6437,6437,6437,6437,6404,6437,6404,6437,6405,6404,4356,4356,4356,4356,4356,4324,4356,4324,4324,4356,4324,6404,4324,4291,14790,37868,19015,22980,41864,48300,50415,52431,54475,60714,58634,58667,58636,58669,54641,50546,63126,63094,65238,63189,39915,35722,31530,44142,65140,65238,65239,60914,46058,52364,44010,33544,33543,33642,25224,52659,19017,27338,40015,18983,25256,16935,14790,8451,6339,6436,6502,6469,10564,255},
{53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,55069,55069,55069,55069,55068,55068,55068,55068,55068,55068,55068,55068,55068,55069,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,59163,65273,56951,56919,63193,61144,61145,61145,61145,61112,61145,61144,61112,59031,63225,63225,59032,61112,61112,59031,61112,61112,61080,61079,61080,61112,59032,59031,61112,61080,59031,59031,61112,59031,58999,59031,50580,52562,46190,42095,63258,65305,63257,63225,63192,63193,58967,54773,52726,56952,29581,14888,14921,12972,4585,6665,6600,6437,6437,6437,6437,6437,6437,6437,6437,6437,6437,6437,6404,6437,6404,6437,6404,6405,6437,6404,6437,6404,6437,6404,6437,6437,6404,6437,6404,6437,6404,4324,14790,44173,23175,25093,37673,48269,44143,48206,52295,58470,45990,43877,41765,50153,33869,19373,63159,63160,65271,56884,14724,8549,4291,12645,56754,65271,65270,56656,43848,48138,33511,25223,23176,31595,27435,48499,44209,46289,50612,41997,29416,19047,19015,10564,8483,8516,6469,6502,8484,255},
{53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,55069,55069,55069,55068,55068,55068,55068,55068,55068,55068,55068,55068,55069,55068,55068,55069,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,59163,65305,58999,56919,61145,61144,61145,63193,61145,61112,61144,61144,61112,59031,63193,63192,59032,61080,61080,61079,61112,61112,61080,59031,61112,61112,59032,59031,61112,61112,61080,59031,61112,61080,59031,61112,52693,37870,33774,14856,27436,27468,25355,35822,40015,33741,46256,56887,54871,52726,31694,10662,6567,4715,4650,6632,6534,6469,6469,6437,6470,6437,6470,6437,6469,6437,6437,6469,6437,6469,6437,6469,6437,6437,6437,6437,6437,6437,6437,8485,6437,6437,6436,6436,6404,6436,6436,6404,16903,50512,23175,29450,48336,48369,41998,41834,50116,52196,45925,45925,31366,56426,46320,42291,63192,63160,65271,54738,14660,10597,12710,12678,37771,58802,56754,44109,35625,37835,35789,33741,31596,33741,29515,39982,61014,58933,56820,31531,25223,23208,12677,10596,10564,8451,6404,6502,6436,255},
{53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,55069,55069,55069,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55069,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,59163,65305,59032,56919,63225,63193,63193,63225,63225,63193,63225,63225,61112,61144,65305,65305,61112,63192,63192,61112,61112,63160,61112,59032,59031,59031,56919,56919,56854,54773,54773,58999,58966,54806,56886,56886,48500,31661,27533,10663,6469,8582,10630,18984,14856,8550,21129,29548,23275,14823,10630,8550,8518,6502,6469,6437,8517,6437,6437,6437,6437,6437,6436,6437,6437,6437,6437,6436,6437,6437,6437,6437,6437,6437,8549,8549,6437,6437,6437,8485,6437,6437,6436,6436,6404,6436,6436,6404,18951,56753,25288,29515,48434,56621,54309,31203,45859,56356,50052,56453,39688,60719,42192,29808,65240,63160,65303,50545,18820,48336,58967,61080,58999,61079,63192,52463,44011,52528,44142,41897,50247,44041,37901,31563,60981,58966,58933,39982,23079,27368,14789,6371,8451,10596,8549,6502,6469,255},
{52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53021,53020,55069,53021,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55101,57149,57181,57181,57181,57181,57149,57149,57148,55068,55068,55035,52987,52955,50874,54937,63225,56919,54806,58967,56919,54838,54773,52661,48532,46451,46387,44274,42161,40113,38000,35854,33742,31662,29549,27468,25355,23275,21194,21162,21129,19049,16969,16936,16936,21097,29483,14791,12743,12743,10630,10630,8517,8550,8517,6469,6437,6437,6437,6437,6437,6404,4356,6437,6437,8517,6437,8517,8517,6437,8517,8485,6437,6404,6404,6404,6437,6436,6437,6437,6436,6437,6437,6437,6437,6436,6437,6436,6437,10598,8549,6437,6437,6437,8485,6437,6437,6436,6437,6436,6436,6436,6404,18918,58800,31561,27434,46353,58536,54146,47940,41635,50019,39555,31268,41671,56624,46288,36050,63094,63159,65335,46319,31368,63060,65240,65272,63192,63192,65305,56688,48138,52527,46190,43879,54405,44007,35788,25289,54740,58933,58933,46321,21031,21063,16934,10564,6371,6371,8484,6469,6502,255},
{53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53021,55069,55069,55069,55069,55068,55069,55068,55068,55068,55068,55068,55069,57149,57181,55068,48762,36182,29843,29810,27729,25649,25584,23471,21390,19278,19245,17132,17100,15019,14987,17034,21195,19147,19114,19082,19114,17034,17034,19114,19115,19147,19147,19114,21195,23275,25355,25388,27468,31662,31662,33742,35822,35822,37902,37935,40015,40015,39983,40047,42095,48369,31597,6469,6469,8517,6469,6469,6437,8550,8517,6469,6437,6437,6469,6469,6469,6437,6437,8517,6469,8517,8485,8517,8517,6437,8517,8485,6437,6404,6404,4356,6437,6436,6436,6437,6436,6437,6437,6436,6437,6404,6436,6404,6436,6437,6469,6437,6436,6436,6437,6436,6436,6436,6404,6404,6404,6404,4324,18918,62959,37867,23208,50448,64804,58403,50020,45860,58467,50117,22949,33415,58671,50318,52726,52660,61046,65335,42093,41866,44043,50482,65305,65273,63258,63159,54543,54575,52560,48269,44076,39818,33577,37803,35723,54674,61013,60980,58866,48300,31561,19015,12709,8483,8516,6404,6404,6502,255},
{52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53021,53021,55069,55069,55069,55069,55068,55068,55068,55068,55068,55069,52955,42456,29810,17230,10924,12972,19180,19180,19245,23406,27534,27567,29679,31792,33873,35953,38066,40178,42259,44340,46420,48533,48565,48565,50646,52693,52758,52693,54774,50548,44274,44274,44273,42128,37967,35887,35854,33774,31694,29581,27500,29549,27435,27435,25388,25323,23242,21162,21130,46321,52627,10630,6469,8517,6469,6469,6469,8517,6437,6469,6469,6437,8517,6437,6437,6437,6437,8517,8517,8517,8485,6437,8485,6437,6437,6437,6436,6404,6404,4356,6404,6404,6404,6404,6404,6404,6436,6404,6404,6404,6404,6404,6404,6404,6437,6404,6404,6404,6404,6404,6404,6404,6404,6372,6404,6404,4324,18950,62991,44173,21095,37835,54340,58403,52164,39719,50148,62760,48105,33480,54477,52431,59064,61178,63093,65237,56753,54543,37770,52594,65304,65305,65338,62995,56655,60978,58800,54575,54541,48203,37737,52429,54542,48302,63093,35755,33576,52395,29318,23208,10596,4258,6404,6404,8484,6469,255},
{52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,55069,55069,55069,55068,55068,55068,55068,55069,55101,27697,21260,29647,40146,48598,54872,56952,56984,56984,54839,52758,52726,50678,52694,50645,48533,46452,46452,44372,42259,40179,38098,36018,33905,31824,27599,27566,25486,25518,19245,15019,17164,12939,12906,12906,10891,10858,12906,12906,10858,10858,19179,21163,23243,25389,21130,19082,17034,19082,27403,44143,12775,6437,6437,6437,6437,6437,6437,6436,6437,6436,6436,6437,6436,6436,6404,6436,6437,6437,6437,6437,6436,6437,6437,6437,6436,6404,4324,4324,4324,4324,6404,6404,6404,6404,6404,6404,6404,6404,6404,6404,6404,6436,6437,8517,6437,8517,8517,8517,8517,8517,8517,8517,8549,8549,8549,8517,23176,62991,54704,23175,16869,29351,56554,60746,58732,56621,52427,56653,50317,52463,60947,65239,63192,63125,65236,63124,58801,48270,58900,65304,65338,65305,62994,56753,60946,56655,50381,50315,48235,48203,52461,50381,31531,54740,12710,8452,35757,23078,29449,14822,4258,6404,10597,6371,6404,255},
{53020,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,55069,55069,55069,55068,55068,55068,55068,42325,44470,59032,59032,61145,63225,63225,59032,52693,44339,33840,27631,21455,19343,17262,17262,17262,15182,15214,15214,15214,15182,13134,13134,15214,15182,13134,13037,8843,8811,13069,13102,13036,15117,13036,12971,13004,15182,12971,12971,12971,12939,12971,15019,14987,15019,17067,14986,14986,17002,17002,29549,42161,16936,6405,6404,6405,6404,6404,6404,6404,6404,6404,6404,6404,6404,6404,6404,6404,6437,6437,6437,6437,6437,6437,6437,6469,8517,6469,8517,8517,8517,8549,8549,8550,8549,8550,8550,10598,8550,8550,10630,8550,10598,8550,10598,8549,8549,8550,8549,8517,8517,8517,8517,8485,8485,8484,8485,6404,27303,60845,65203,31562,21095,50316,62860,60746,58666,54474,44010,54508,62960,56688,58835,65239,63126,63126,65334,42061,23144,20998,54707,65370,65371,65338,56622,50448,52560,41996,29448,29384,27271,25223,25222,31563,29450,35822,16871,23015,37902,21063,25256,19015,14822,10596,6371,6371,6437,255},
{53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53021,53021,53021,55069,55069,55069,55069,55068,55101,50875,29842,23536,56951,59064,59065,44372,29777,23471,19277,17165,15117,15182,17392,15279,15247,15280,15279,17295,15247,13231,15279,15247,15247,15247,15214,15214,15214,13101,10891,10891,15149,15182,15182,13069,13069,13004,10923,13004,12971,10891,12939,12939,15019,12906,15019,15019,12874,12906,12874,14954,19082,25355,27469,16969,6437,8517,6469,8517,8517,8517,8549,8549,8550,8550,8582,8582,10598,8550,8550,10630,8550,8582,10630,8550,8549,8549,8549,8549,8517,8485,8517,8517,8517,8517,8517,8517,8517,6437,6437,6436,6437,8517,6437,6436,6436,6437,6437,6437,6437,6437,6437,6404,6437,6404,6436,6436,6404,6436,6404,29416,62926,65268,44206,23175,48302,50215,50180,43908,27172,25093,39818,58702,50285,56755,61080,54806,63126,65334,25354,4324,8485,50482,63192,59064,58933,52397,44174,37900,27368,25223,27303,25223,25223,23175,27337,31661,17067,18919,44046,54675,25322,14790,21095,19047,12709,8484,8484,8517,255},
{53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,55069,53021,55069,55069,55069,55068,55101,38295,29777,27567,48532,56919,42292,13167,9039,9071,17360,15312,15312,13199,15312,15279,15247,15279,15279,15247,13199,13199,15247,13166,13166,15182,15182,15182,13102,13036,8778,8746,13004,15117,15117,15117,13003,12906,12939,15052,14987,17067,17067,19180,21227,21195,23275,25388,25388,25388,27469,31597,33709,35789,42128,19049,8517,8549,8550,8550,8517,8517,8517,8517,8517,6469,8517,6437,6469,8485,6437,8517,8485,6437,8485,6437,6437,6437,6437,8517,6437,6372,4324,4324,6404,6437,6437,6437,6437,6437,6437,6437,6469,8517,6437,6437,6436,6437,6437,6436,6437,6436,6437,6404,6436,6404,6404,6404,6404,6404,6404,27270,60911,63124,56753,23175,44273,58932,46055,52228,43975,52497,58868,62995,50351,61014,52759,59097,63126,65302,21161,6404,12743,48434,61047,56952,54674,50284,46288,37868,27369,25255,27303,25223,25191,23175,23175,35920,23438,37869,61014,58933,29548,12710,23208,16870,10564,10596,8451,6371,255},
{53020,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,55069,55069,55068,55068,55068,55069,50712,45996,39853,50613,36051,11151,9039,9038,8974,13101,13069,13069,10988,17327,17262,17230,19310,19342,19310,19342,21423,23471,25519,25551,27631,29712,31792,31792,33840,33840,35920,38033,40113,40113,42194,42161,42128,42096,44241,42128,42128,44176,42096,44208,46321,46321,46256,46288,46288,48336,48369,46288,46288,56788,16969,6437,6469,6437,8517,6437,6437,8485,6437,6469,6437,6437,6437,6437,6437,6437,8517,8517,6437,6437,6437,6437,6437,6437,6437,6437,6404,6404,4356,4356,6436,6436,6436,6437,6436,6436,6436,6437,6437,6436,6404,6404,6404,6436,6404,6404,6404,6404,6404,6404,6404,6372,6404,6372,6404,4324,25158,58832,61044,63058,33707,29482,56852,54673,56589,58769,63160,54708,56788,54675,65207,34101,50776,65206,63221,16936,6404,14856,50580,65403,65403,63060,50252,52593,42062,31530,29416,27335,27303,27303,23175,21062,35854,52791,50515,61013,61013,37934,12710,29416,16935,8483,8451,10564,10597,255},
{52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,55069,55068,55068,55068,52987,52988,54904,50320,52628,40211,13167,15247,21423,31792,38098,42226,42227,44339,46420,48565,50613,52694,52726,52758,54806,54839,56919,56919,56951,58999,59032,59032,59032,59032,58999,61112,61080,58999,56853,52660,56854,52627,50547,50482,52628,50514,50514,50514,50482,52594,54643,52594,52562,52562,52562,52562,52562,52529,52529,54675,16937,6437,8517,6437,6437,6437,6437,6436,6437,6437,6436,6436,6436,6436,6404,6436,6437,6437,6437,6437,6437,6436,6404,6404,6404,6404,6404,6372,4324,4324,6404,6404,6404,6404,6404,6404,6404,6404,6404,6404,6404,6404,6404,6404,6404,6404,6404,6404,6404,6404,6404,6404,6437,8485,8485,6437,25191,63024,65234,56750,44206,21095,44175,48500,50678,50613,56886,63193,58933,52496,61047,56952,54871,65238,61109,12742,8452,25387,61047,63192,63258,63027,46092,46255,33675,29384,27335,27303,25255,25223,23143,18982,25289,35854,52627,58966,61013,50547,18951,21030,19015,12677,8452,6404,6371,255},
{52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,55069,55069,55069,55069,55068,57083,55036,59130,63291,65371,50613,50613,56919,61080,59097,56985,59065,59064,59064,61112,59032,59032,59032,59032,59032,58999,58999,58999,58999,58999,58999,58999,58999,58967,58967,58934,58868,58868,56788,54708,52627,56853,54707,52594,52562,52595,52562,52562,52562,50514,52562,52562,52562,50482,52529,52530,52529,52529,52529,52529,54643,16937,6437,6436,6404,6404,6437,6437,6404,6436,6436,6404,6404,6404,6404,6404,6404,6404,6436,6404,6404,6404,6404,6404,6404,6404,6404,6404,6404,6404,6405,6437,8485,8517,6437,8517,8517,8517,8517,8549,8549,8549,8549,8549,10598,8550,8582,8549,10597,8550,8549,10597,8549,8549,8549,8517,8517,25191,63024,65201,48268,50480,25288,29548,25486,21325,23405,44307,65305,58802,52399,61145,65272,63159,65238,56883,8484,8452,18984,56853,65305,65305,60848,44077,37868,23176,18982,23110,25190,25190,23110,23110,21062,23208,29417,46223,61013,58900,58901,39948,31528,21128,14854,10597,8517,8516,255},
{52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,55069,55069,55068,59164,55036,61210,65403,61145,63192,54905,50809,56984,59032,59032,58999,58967,58999,58999,58999,58967,58999,58999,58999,58967,56919,58967,56919,58967,56919,56919,56919,58967,56918,58934,58835,58836,56788,54675,52627,52595,54675,52627,52562,52562,52562,52562,52562,50514,52595,52594,52561,50481,50482,52562,52529,52529,50481,52529,54675,16936,4356,6404,6404,6437,6437,6437,6437,6437,6469,6437,6469,8517,8517,8517,8517,8549,8549,8549,8550,8550,8550,8550,8550,8549,8549,8549,12775,14791,12646,8582,8549,8549,8517,8517,8517,8517,8517,8517,8485,8485,6437,6437,6437,6436,6437,6436,6437,6404,6404,6404,6404,6436,6436,6404,6404,23110,63058,65203,60944,65235,35787,21128,23405,17132,17067,35856,65272,56624,56657,63225,65239,61111,65270,54770,16805,20998,29450,61046,65305,63191,58768,46157,33610,23143,37770,50348,50381,52493,54573,54573,56654,58766,58767,50382,58867,56755,60980,60911,50248,31496,14854,6371,6339,4291,255},
{52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53021,53021,55069,55069,55069,55069,57116,52889,61145,63291,59032,61080,50809,48729,56952,59032,59000,58967,58967,58999,58999,58999,58999,58999,58999,58999,58967,58967,56919,56919,58967,58967,56919,56919,58967,58967,58934,58835,58836,56821,54740,52594,52594,54740,54708,52562,52562,52562,52562,52530,52562,54675,54675,52562,50449,50482,52529,50449,48368,46256,46255,48368,16936,8517,10598,8549,8550,8550,8550,8550,8550,8550,8517,8549,8517,8517,8549,8517,8517,8517,8517,6437,6437,6469,8485,6437,6437,6437,4356,12808,25161,18627,6437,6437,6437,6437,6436,6437,6404,6436,6437,6404,6437,6436,6437,6437,6436,6437,6436,6437,6436,6404,6436,6404,6436,6404,6404,6404,25192,63091,65169,52558,50412,50512,21095,19015,21127,42095,54708,63126,60914,62995,65206,65206,60980,63124,63123,58734,58767,60913,65238,65271,65172,62993,56655,48269,46188,50348,52428,50347,48234,46122,39881,37768,41961,48300,29385,54707,61013,58965,44208,23046,29384,19047,8516,4291,6403,255},
{52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,53021,53021,53021,57116,59098,61178,63291,61177,61112,50809,50809,56952,59032,59032,56919,58999,58999,58999,58999,58967,58999,58999,58999,58967,58967,56919,56919,56919,56918,56918,56886,56886,56886,56854,54675,56723,54740,54741,52562,54741,52627,50482,48402,48402,48401,48369,48336,50449,52595,52562,48369,46256,46256,46256,42063,14823,12711,12710,12710,8582,6469,8517,6437,6437,6437,6437,6437,6437,6437,6437,6437,6437,6437,6437,6437,6437,8517,6437,6437,6437,6437,6437,6437,6437,6437,6404,10663,19082,18659,8485,6437,6437,6437,6437,6437,6436,6437,6437,6436,6437,6436,6436,6437,6404,6436,6404,6436,6436,6404,6436,6404,6436,6436,6404,6404,25256,52297,56587,56719,58831,65236,33675,18950,39916,65271,65305,65206,58801,65140,63191,63159,63126,65302,50512,23077,25158,29450,54707,65239,65140,50316,33545,21062,16869,18949,23077,23109,23077,18949,16869,16869,14789,23176,27370,46288,61046,46386,37935,25290,18950,21127,14790,10597,10564,255},
{52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53021,55069,55069,53021,55068,52922,61211,63291,63258,63160,50744,48696,54839,56919,56919,56886,56886,56886,56886,56854,56886,56886,56886,56886,56854,56886,56886,56886,56886,56886,56886,56887,56886,56886,56886,54773,52628,52693,54773,54773,54773,52660,48434,46322,44241,46321,46321,46289,50547,54741,54740,50548,50483,50515,52628,48402,12743,10630,10663,10662,8550,6469,6437,6437,6437,6437,6437,6437,6437,6469,6437,6437,8485,6437,6437,6437,6437,8484,6437,6437,6436,6437,6437,6437,6437,6437,6404,10630,17034,8420,8517,6437,6437,6437,6436,6437,6437,6437,6437,6436,6437,6436,6436,6437,6404,6436,6436,6436,6436,6404,6436,6404,6404,6436,6404,6372,23176,56488,54507,58799,58831,65334,52658,23143,48401,65337,65272,60948,50286,63126,63160,63159,63127,65335,40013,4258,8484,6371,21064,65271,65107,44043,23143,16869,14789,18949,23109,23110,23110,21030,18950,18950,16870,18983,29483,35789,60981,27632,29613,35822,16838,25288,19047,16935,8451,255},
{53020,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55068,55069,55069,55068,55068,55068,59163,63323,63290,63290,61145,61145,61080,56952,54904,56919,56919,56952,56952,58999,56952,56952,56951,59000,58999,59000,59032,59032,58999,59032,59032,59032,59031,59032,59032,61112,61112,59032,61080,59032,61112,61080,59032,59032,61112,61112,61145,61145,61145,63193,63193,63225,63225,63225,63257,56919,14824,10663,10663,10662,8582,6469,6437,6437,6437,6437,6437,6437,6437,6437,6437,6437,8485,6437,6437,6437,6437,8484,6437,6437,6436,6437,6436,6437,6437,6437,6404,8517,19114,6437,8517,8517,6437,6437,6404,6436,6437,6436,6437,6436,6437,6436,6404,6436,6404,6404,6404,6404,6436,6436,6404,6404,6404,6437,6404,6404,16871,48234,60910,58896,46254,63156,60978,35788,27368,61079,65272,58834,52399,65207,63192,63159,63126,65335,35820,8451,10564,25290,40014,27336,58735,35624,12676,12676,14789,20997,25190,25158,23110,21062,18982,18982,16902,14822,29515,27370,56853,40244,42193,42160,18951,27336,19047,14854,10596,255},
{52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,55069,55069,55069,55068,55068,59163,63323,61145,63290,63290,65339,63290,63258,61178,61145,61145,61178,63226,61177,61145,61145,61145,61177,61177,61177,63225,63226,63225,63257,63225,63258,63257,63258,63257,65306,65338,63257,61177,63225,63225,63225,61177,63225,61177,61177,63225,61177,61177,61177,63225,61145,61145,61177,63225,54839,14824,10630,10631,10662,10663,6469,6437,6437,6437,6437,6437,6437,6437,6437,6437,6437,6437,6437,6437,6437,6437,8485,6437,6436,6404,6437,6436,6436,6437,6436,6404,6404,8550,6436,6437,8517,8485,6437,6437,6437,8517,8517,8517,8517,8549,8549,8549,10630,10630,10662,12710,12710,12775,12775,14855,12775,12775,14856,14823,14888,16936,44108,50282,58800,61044,63189,60913,56819,23143,46288,65304,56689,54512,65271,54773,50482,63158,65367,33642,12580,16871,31531,37869,23177,50349,35625,27369,27369,27336,31496,31463,29383,25255,23143,21062,21062,18983,16870,27402,27337,52594,59000,58999,44273,23177,25191,23208,10564,8483,255},
{52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,55069,55069,55068,53020,57116,63323,61210,63258,63290,63290,63290,63290,65371,65371,63323,65371,65371,63258,61145,63258,63258,63258,63258,63258,63258,63258,63258,63258,63258,63258,63225,63225,61177,65305,63257,63225,61177,61177,63225,61177,61177,61177,61145,61177,61177,61145,61145,61177,61177,61145,61144,61145,63258,54871,14856,10663,10663,12711,14856,6469,6437,6437,6437,6437,6437,6437,6437,6437,8485,6437,8485,6437,6437,8485,8517,8517,8517,8517,8517,8550,8549,8550,10630,8549,10630,8549,12710,12743,12743,12742,10630,12743,10662,12743,14823,12775,14856,14856,16904,16936,14888,16936,14855,16936,16936,16936,16969,16936,19049,16968,16969,17001,16936,19049,16968,41996,58733,65203,65235,63156,54607,65236,37900,25256,60980,54576,58770,56787,29451,40015,65239,65367,31497,39852,63192,63192,63192,65371,56754,46157,52625,48270,41963,37769,35689,33576,29416,25223,23143,21095,18982,16902,21096,27337,42095,61046,58965,52628,31596,20998,25288,12709,4291,255},
{52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,55069,55069,55069,55068,57116,63291,61178,63290,65339,63291,63290,63290,63290,65338,63323,65371,65371,63290,61145,63258,63258,63258,63258,63258,63258,63258,63258,63258,63258,61210,61177,61177,61177,63258,63258,63257,61177,61177,61177,61177,61177,61177,61177,61177,61177,61177,61177,61177,61177,61177,61177,54838,50580,52791,35790,33677,35757,35757,25323,8582,8550,8550,10630,10597,10662,10630,10630,12711,10630,12743,10662,10662,12743,10630,14823,12710,12743,14823,10662,14823,12710,12775,14856,12743,14823,14823,19049,19049,16968,16968,14856,16968,14888,16936,16969,14856,19049,16936,19049,16969,16968,19081,16969,21162,17001,19049,19081,16968,21162,19017,19081,19049,19017,23242,19017,39949,52493,63058,65136,63024,54609,65205,58931,23175,39948,54512,58835,31596,29581,46354,65239,65303,33480,52430,63127,65337,63159,63258,54609,44077,50447,46156,39882,37704,33544,29383,27303,23143,21063,19015,16902,14822,16903,25289,29483,56787,58901,54772,35854,16838,18982,16902,8516,255},
{52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,55069,55069,55068,55068,55068,55068,57083,57017,61211,63257,63258,63258,63258,65339,63290,63258,63258,63258,63290,61145,63257,63258,63258,63258,63258,63258,63290,63258,63258,63258,63258,63258,63258,63225,65306,65305,63225,61144,61144,61144,61112,61112,59031,58999,58999,58966,56886,56853,56853,54773,54740,50579,33775,19179,31825,44176,48271,46159,48239,35789,14856,12743,12743,14824,10663,14823,12775,12743,14856,12743,14856,14856,14823,14888,12743,14888,14856,14856,16969,14856,16969,14856,16968,16969,14856,16936,25355,42193,42128,27468,16968,14856,19049,14856,16968,16936,14856,19049,16936,19049,16969,16969,19081,16969,21162,19081,21162,19081,19049,21161,16936,21129,16969,19049,21161,16904,35756,46188,61012,56719,56718,58835,63025,65368,40013,23143,44012,63094,37968,50613,54741,63158,61109,39753,46026,33611,63192,63093,63093,48269,25223,29416,27271,29351,31431,31431,29351,29351,23110,21062,21030,21063,29449,31561,44141,42028,50447,60948,61013,54705,50379,39882,19047,12709,255},
{52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,55069,55069,55068,55068,55068,55068,55068,57083,58999,52824,52824,58999,59064,58999,56919,56918,56886,61177,59032,61145,61144,61112,58999,56918,56886,56886,54805,54773,54773,54741,52660,50547,50515,52595,50514,48401,46321,46321,48369,48369,48337,44241,46289,48369,46289,46256,46288,46321,48369,48369,48435,35888,27501,35887,42031,48239,48239,48239,39885,16969,14888,14856,16969,12775,16936,14856,14823,16969,12775,16968,14856,14856,16968,12775,16969,14856,16936,16969,14856,19049,14856,16936,16936,14856,14888,21129,31628,27468,21194,14855,14823,16968,14855,16968,14888,16936,16968,14823,16968,14856,16936,16936,14856,16968,14856,16936,14888,14856,16936,14856,19016,16936,16968,16969,16936,31596,56753,63222,56719,60945,61046,54573,63124,56851,23175,25223,44142,48466,61079,63159,63093,63155,58736,52495,31496,48270,58735,60880,54574,44075,46187,48300,52461,54541,54541,54574,54541,42027,35722,35689,39882,48267,48267,56686,44141,25223,50448,63093,54673,50347,35526,25288,10629,255},
{52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,55069,55069,55068,55068,55068,55068,55068,55068,57083,59098,61113,56984,56984,54871,56951,56952,59032,58999,56952,58999,56951,54806,48500,46354,48467,48500,48500,50581,52693,50645,50613,50613,50646,52759,52759,52791,52792,52792,46518,46518,48566,54806,52692,44208,44175,52530,48368,44142,46254,54741,48565,48533,50646,38001,37837,48239,48239,48239,39918,19049,14856,14823,14888,12743,16936,14856,14823,16936,12743,16936,12775,14855,14856,12743,16936,12743,14823,14823,12743,14856,12743,14823,14823,12743,12743,14823,16936,16936,16968,16936,14856,16968,14888,16968,16936,16969,16969,16969,19049,16968,17001,21162,19049,21162,17001,19081,19049,21129,21162,16969,21162,16969,21129,19049,19017,29548,56753,46089,54508,65169,63158,48269,58832,60946,46287,19014,14789,33577,63059,65174,65205,63090,54608,44108,39849,52429,58800,60881,44043,29383,27335,29383,33543,31463,29415,27303,25222,23142,21062,18982,16870,14790,12709,19015,17001,4291,37869,63094,46354,31596,23078,27336,14855,255},
{52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,55069,55069,55069,55068,55068,55068,55068,55068,55069,55068,55068,55068,57083,57051,57050,57050,57083,57051,57083,57083,57083,57083,57083,57083,57084,57116,57116,57116,57116,57116,57116,55068,55068,55068,55068,55068,55068,52955,34232,40376,27957,38098,48500,33807,33709,48336,42095,37934,40015,59065,33808,40147,48501,50580,42031,48207,48239,48239,37870,14856,12743,12743,14823,10663,14823,12743,12775,14856,14823,14823,12775,14823,14856,14856,14888,16968,16936,14888,14888,16969,14856,16968,14888,14888,14856,35822,48434,46321,25387,19049,19017,19081,14856,19081,16969,19049,21130,19049,23242,19049,21162,21130,19049,21194,16969,21162,16969,21129,21129,17001,19081,16936,21129,19049,19049,23242,52461,52099,46024,56653,63158,56687,60944,56721,65334,33707,21063,54707,65240,63159,65303,50577,10499,4291,2178,41931,62994,58801,23078,8484,10596,14789,23077,23110,23110,21030,18982,18950,18950,16902,14822,14822,14822,14822,25453,35790,42063,61046,52627,31629,18983,18950,19047,255},
{52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,55069,55069,55069,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,52955,34231,36279,34166,42259,48499,35888,33645,37903,33774,33773,46419,61178,38098,48565,52791,52758,44176,46159,46191,46159,39918,16969,14888,14856,17001,14888,16968,14856,14888,16969,14856,16969,14856,16936,16969,14856,19049,14856,16968,16969,14856,17001,14823,16968,14888,14888,14855,29515,35789,31563,23242,16936,16936,19049,14856,19049,16936,19017,16969,16936,19049,14856,19049,16969,16936,16936,14823,16968,14888,16968,14856,14855,16936,14856,16968,16936,16969,19017,48433,50184,50217,65170,56820,50382,63025,65302,65236,58931,27336,33708,63159,63159,65303,42093,8419,6371,6371,48237,62962,56656,18885,10564,12677,16869,23077,23110,21062,18982,18982,16902,16902,16870,14822,14822,14822,12742,19082,27338,48402,58933,50514,31694,14823,14822,21127,255},
{52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53021,55069,55068,53020,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55035,40440,40408,38294,38001,38001,35855,37870,39983,39983,37837,48532,63323,61211,63291,27664,19244,39983,46191,48207,42063,33774,19049,16936,14856,17001,14856,16968,14856,14856,19049,14856,16968,14823,14888,16968,14856,16936,12743,14856,14824,12743,14856,12743,14855,14823,14823,12743,12743,16904,14856,16936,14855,14856,14888,14856,16936,16936,16969,17001,16968,19049,16969,19081,19049,19081,19049,19017,21162,17001,21129,19049,19081,21130,19049,21194,19049,23274,23275,52726,50381,43944,63059,58900,50350,58833,65367,60946,63092,50545,21062,44208,63159,65302,31562,8419,6403,12645,46092,62961,52495,14724,12644,12709,18917,23110,23110,21030,18982,18982,16902,16902,14822,14822,12742,12709,10662,14888,23144,44175,52627,37902,35887,27468,16870,25288,255},
{52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55068,55069,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,44569,40407,46616,42292,33839,31727,35757,37838,37870,44045,54708,63258,48598,48565,19277,10825,37870,46191,48207,52497,40080,14823,12743,12743,14855,12743,12775,12775,14823,14856,14823,14824,14856,14856,14856,12775,14888,14823,14856,14856,14856,14888,14856,16968,16936,16968,14856,40015,46354,42128,19082,14888,16968,17001,14888,19049,14856,19049,16968,16968,21129,16968,21162,19049,21129,19049,19049,21162,16969,21162,19049,21129,21129,19049,23242,19049,23242,23242,33839,50480,41864,63027,65238,61046,61076,63189,52463,56654,65301,37900,23175,54707,65302,21095,8452,10564,31465,48172,60881,48237,14724,12676,14757,20997,23110,21062,21030,18982,18950,16902,16902,14822,14790,27468,42226,44073,27368,27435,23242,19212,21096,42128,37935,21031,25223,255},
{52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55068,55068,53021,55069,55069,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,52987,38360,42456,38327,44405,44209,38000,33710,39919,44111,54414,46419,40146,33905,38066,33906,31793,42096,46224,39917,44078,35822,14920,14888,14856,16969,14888,16969,14888,16936,19049,14856,17001,14856,16936,16969,14856,19049,14824,16968,14856,14856,16936,14823,16936,12743,16936,14823,33708,33741,29515,19049,14856,16968,16936,16904,19016,16904,16936,16936,16936,16936,16936,16968,16936,19017,16936,14888,16936,14856,16968,14856,16936,16936,16936,19049,16968,21129,21162,31695,44240,44010,60879,65270,65238,65168,61011,50318,54542,65170,63157,27401,31529,61044,18950,12645,23144,35659,50318,58833,37737,21030,16870,18917,23078,25158,23110,18982,18950,16902,16902,16902,14822,14822,25355,33839,33608,18982,25421,25747,19505,16936,42128,44209,27402,21063,255},
{52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,55069,55069,55069,55069,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55035,38360,48696,40343,46485,37968,37999,35886,52497,50352,54609,40277,40179,40277,46486,48566,50646,44339,44274,42226,38066,21195,19049,14888,14856,16969,14823,16968,14856,14856,17001,14856,16968,14856,16936,16936,14823,16936,12775,14888,12775,14823,14823,12742,14855,12711,14823,12710,14791,14855,16904,14856,14823,14856,16936,14856,16936,16904,16968,16936,16969,16969,16936,19081,17001,19081,19049,19049,19081,16968,19081,16936,19049,16969,19049,21129,19049,23242,38000,65403,61177,48367,41929,60979,65303,62991,60978,54479,58835,63026,65303,54738,23175,33674,16837,16838,33676,54707,60882,58801,37769,20998,16869,16869,21030,23110,21030,18950,16902,14822,14822,14790,12742,12742,10662,10629,10630,8582,29581,32118,23764,12776,42095,40015,39982,14757,255},
{52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,55069,55069,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,52955,38360,42488,36214,44405,29777,35887,29743,35855,35789,48337,52824,52759,38164,42292,46485,48566,44405,46485,48566,38099,14954,14856,12743,12743,14856,12711,14823,12743,12743,12775,12711,14856,12775,14856,14856,12775,16969,14856,16936,14855,14856,16936,14855,16969,14856,16936,16968,42128,46321,33774,16969,14856,16969,14888,14856,16936,14855,16969,14856,19049,16969,16969,19081,16936,19081,16936,16969,16969,14888,19049,14856,19049,16936,19049,19017,16968,21194,29613,42226,42226,54706,37737,58932,65400,60946,60913,56625,56819,58733,65238,65303,42126,19014,10597,4291,4259,46189,58801,54640,33544,10564,12644,16837,21030,23110,23143,23175,23176,25256,27336,27369,29482,33642,35722,37835,39947,41995,54640,50776,40244,29581,42029,52560,52559,44106,255},
{52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,55069,55069,55069,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,38392,38360,38294,42324,48630,35952,25681,25487,27501,44078,52693,61210,33938,35921,42259,42194,42227,38001,38034,23504,17100,14888,14856,14856,16969,14856,16969,14888,14888,14888,12776,17001,14856,16936,14888,14856,19049,14856,16969,14856,16936,16968,14855,16969,14823,16968,16936,35789,31628,25355,16968,14823,16936,14823,14855,16936,14823,16936,12775,16936,14856,14856,16936,14823,16936,14856,16936,14856,14856,16968,14856,16969,14888,16969,16936,16936,19049,19081,23340,25420,54707,58898,58962,56818,56687,63024,58802,61013,50316,65204,63159,63189,31561,18982,14822,12709,46188,63059,58866,52462,48269,48334,52526,54607,56688,54639,46188,50349,56720,56720,58800,54606,52526,52461,50348,46220,44107,44107,56886,42161,52726,54642,50448,58832,50249,255},
{52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,55069,55069,55069,55069,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,38392,34232,30038,34068,46387,33806,25681,27631,33774,37869,46387,63259,40244,40179,46486,46485,44405,46485,36051,15215,19147,19049,14856,14856,16969,12775,16968,14855,14888,16936,14824,19049,14888,16936,16904,14856,16936,14823,14856,12743,14823,14855,12743,14855,12743,14823,12710,14823,14856,16936,16968,14856,16968,16936,16936,16968,16936,19049,16969,19082,19049,19049,19049,16968,19081,19049,19114,17001,19049,21129,19049,21194,19049,21162,19049,21161,21194,35952,44371,44339,58901,60913,45827,29187,44043,63056,65140,63125,52495,65171,63126,65270,58964,27368,18982,25158,50349,54575,58768,48301,46188,46155,44075,39882,35721,29448,21063,21063,23175,21096,27467,16902,14855,12775,12774,10727,10695,10695,29549,33709,54741,61046,46289,48467,39884,255},
{52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,55069,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,40473,28055,32086,36116,42160,35919,29809,38001,42095,42063,44339,61210,38196,36018,40244,44373,44405,36083,19473,13037,17034,14855,12743,12743,12775,10663,14856,12743,12775,14823,12743,14888,14855,16936,14888,14856,16936,12775,14888,14824,14888,16936,14856,16968,14855,14888,23210,46354,48434,31661,16936,14856,16969,14856,19016,19017,16968,19049,16969,21162,19049,21162,19016,16936,19049,16936,19081,16936,17001,19017,16936,19049,14855,19049,16904,19049,19048,16935,10662,29516,61047,65238,52198,41799,50448,58800,65238,63094,52430,63057,63159,65238,65399,56883,25255,31563,56788,60915,54608,33512,37770,33577,29416,25256,23176,21096,19016,14887,14855,12775,21162,17001,12807,14888,14888,14920,14921,14921,25387,25257,44208,61046,52594,44241,44208,255},
{52988,52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,55069,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,44569,30103,30038,42292,44273,42127,42259,48336,52398,46255,52791,61210,52824,52824,54937,56985,50679,27762,13232,8810,14986,16969,14888,14856,16969,14856,16969,14888,16969,17001,14856,17001,14855,16969,16936,16936,16969,14856,19049,14856,16969,16936,14856,16936,12743,16936,19016,33644,29515,23242,14855,12775,16936,12743,16936,14855,14855,14856,14823,19016,14855,16936,14823,14856,16936,14888,16936,14855,16936,16936,14888,14888,14888,16968,16936,19049,21162,33807,29614,46387,63127,65272,54607,41766,52495,60943,65238,61046,54674,60946,63191,65302,63188,63057,52690,21095,31562,56752,44043,25158,23078,21030,21063,21063,19015,19015,16935,14855,14855,14855,14888,23307,21194,21227,21227,21227,21227,19146,23307,35757,33643,61013,56820,42096,50482,255},
{52988,52988,52988,52988,52988,53020,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53021,53020,55069,55069,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55035,40440,34231,30038,36116,40113,42095,48499,52595,52269,54642,61211,63291,63291,54871,52792,36018,21390,17099,13004,8778,17099,19082,14888,14888,16969,12775,19016,14855,16968,16936,14823,16936,12743,14856,12775,14855,16936,12743,14856,12711,14855,12743,12743,12743,12743,14823,12710,14823,18854,14823,14823,14823,14823,12775,14856,14856,16936,14856,14888,17001,16969,17001,16968,19049,19049,19049,17001,14856,19049,16968,19049,19049,16968,19049,14855,21129,29548,56919,46386,56853,63160,63127,63092,41831,37737,46253,63124,61046,58868,46124,63157,63221,31528,35657,54705,50545,21095,35754,39882,14757,12677,14789,16902,16935,16935,16935,14887,14855,14888,14887,14855,12807,12808,12840,12808,12807,14953,17034,10728,29581,33709,56853,58934,44274,52660,255},
{52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53021,55069,55069,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55035,38392,40407,36247,36084,27729,29646,38000,48337,41966,56821,65436,65437,65436,65404,46518,23406,17165,15019,12939,8811,12938,16936,12775,12743,12775,12710,14823,14823,14823,12775,12775,12775,12743,14856,14856,14856,14856,16968,16936,16936,16936,14856,16936,16936,16936,14888,29581,52661,51914,25225,14856,14856,16936,14823,16936,14823,16936,16968,16936,19049,14855,19049,14856,16969,16968,16936,16968,14823,16936,12743,16936,16936,14856,16936,14791,19016,21031,41901,21030,44011,52463,48271,44304,50446,35559,48334,65171,61013,61111,56818,65334,48432,8419,35690,56588,65334,44239,21094,25191,12676,12676,14789,16902,16935,16935,16936,16968,14888,14888,14888,14888,14888,14888,12840,12840,12840,23340,14953,10792,23339,27337,50482,61013,46321,50514,255},
{52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53021,53021,53020,55069,55069,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55035,38360,38327,38327,31988,25681,33840,31727,46223,50416,46289,48499,59097,63291,54806,44437,21554,15312,13232,11184,11119,15019,16969,16969,16969,16936,14856,17001,19049,19049,14888,16936,16968,14856,19017,14888,16969,16968,16936,19081,14888,19049,16936,16968,16936,14856,14823,27468,46419,20999,19049,12775,14823,14823,12743,14855,12710,14855,14855,14823,14823,14823,14823,12743,14855,14823,14823,12775,12775,14856,14855,14856,14888,16936,19017,16936,25224,33544,35560,33511,35558,41766,41833,46419,54771,37737,48300,65202,60981,65304,63023,65234,39982,6306,27304,52362,63025,65237,40013,19014,16870,14789,18982,21096,21096,19048,19048,16968,16968,16968,14920,14920,14888,12840,14921,12840,14986,17066,10793,12873,17066,25289,39982,61013,50514,46321,255},
{52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,53020,55069,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55035,44569,30103,32118,36116,40146,35887,27566,48207,56559,39982,42062,61145,56985,50711,27794,15247,13199,11021,11086,10956,15019,19049,16936,16968,16969,14856,19049,16936,16968,14824,14855,16936,14823,14855,12743,14856,14823,14791,14823,12743,14823,12742,14823,12743,12743,12743,14856,21162,12808,14888,14856,14856,16969,14888,23275,23242,16969,21162,19049,23275,21162,23275,23275,23275,27500,23242,31662,21162,33742,21162,33774,25323,31661,27468,31563,39752,47974,41702,52198,35590,33511,25157,27337,38096,50447,37737,48300,63061,65368,58832,65137,42095,25225,40015,50382,60913,58801,65302,35820,19015,31529,33610,27369,23241,21161,19081,19049,17001,14920,14920,14920,12873,12840,12840,12840,12873,10793,10793,10793,14953,31563,31531,61013,54740,42128,255},
{52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,55069,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,57084,44633,34199,34166,34036,42259,50416,39982,50353,56592,50253,39982,59097,50711,33873,19441,13166,13232,13200,11152,11119,13036,14824,12743,12743,12743,10662,12775,12743,14823,14824,16871,19016,18984,23177,21097,14888,14921,17002,23307,31694,29581,29614,23275,27534,21195,33775,23340,35953,27501,31726,23340,29548,27533,31662,23275,44307,23243,35920,21162,35887,23275,31661,27468,27436,29613,23242,35855,21130,35887,19017,37935,21162,35789,25323,31628,37605,56323,41733,50118,33509,27238,33545,42030,50514,58964,44076,35624,65302,65399,58899,63092,52528,27304,40015,48335,58831,60946,56654,61076,31626,21063,25256,25289,23241,23209,21161,21161,21161,23242,23274,25354,27435,27467,29548,33676,33740,35853,37901,39948,46254,52494,27337,54707,58933,40015,255},
{52988,52988,52988,52988,52988,52988,53020,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,46714,36279,36214,25779,34036,48368,52397,48271,46158,54381,42030,59065,50712,23406,13069,13003,13101,11021,8941,8876,12939,19114,21162,21162,35790,42096,48239,48174,50286,50255,52367,52367,54447,54447,50417,23601,17425,17392,40179,56951,42193,50645,27468,40113,23242,40081,19114,38033,21227,33807,21260,29581,25421,35855,10728,40113,21194,35920,19081,37935,21162,33774,23275,31661,27468,25355,31694,21162,35887,21129,37935,19049,35854,23209,35822,50054,60516,52165,39654,41863,29382,25191,46190,52627,54772,63124,56785,56751,46221,48401,56686,58833,33577,42029,50447,56653,63058,52461,56654,63156,27369,16934,25289,35755,42060,50414,52527,52527,54606,56655,56655,56687,56687,56687,58767,52462,39916,46189,56687,46188,35722,27337,39950,54707,42030,255},
{52988,52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,55069,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,48794,34199,34199,32020,36116,46354,50382,40015,42030,52365,37934,59065,52889,17295,8778,12874,17034,10826,8778,12841,19115,23243,23242,25355,46257,56691,48239,52335,50287,48206,52433,52531,52465,54578,54741,29907,19570,21586,46452,56919,35855,38065,27500,35952,23275,38033,21162,38033,19147,35920,21195,33807,23308,38000,10695,40081,25355,35888,19082,35888,19049,35855,19082,31694,23275,27468,29549,23242,33742,21162,35855,21064,37935,19016,37902,37574,56293,47843,43749,39750,33542,31497,54576,54609,52432,65302,52362,41634,27139,48301,54575,58864,39882,33544,50383,56654,65170,52462,31463,44140,58963,27368,16934,16869,33543,48236,50413,48301,48301,46221,44108,39980,39948,35788,33708,25354,14921,23274,25386,17065,17067,31628,33676,63094,48466,255},
{52988,52988,52988,52988,52988,52988,53020,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53021,55069,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,52955,40408,32086,36084,36115,46353,42063,35887,46190,44110,35886,59065,65469,42357,8811,10891,13069,10989,10956,8876,19180,23242,21194,25323,27435,33644,33709,33709,33709,33676,40015,46387,44241,60916,61015,34036,21651,25747,33970,52726,31661,29646,31629,33807,23307,35920,21162,35952,17034,35920,19082,35888,21195,40145,8550,35920,29581,33807,21162,38000,21130,38033,21162,38000,25388,33807,31662,31629,37968,27468,42161,27468,42194,27436,42161,39784,62564,45698,41669,52328,48203,56755,58768,54511,52399,65238,63025,48004,43977,63159,52594,52494,10564,2146,44044,48268,63024,44043,20965,29416,65334,61076,29481,18982,29416,23209,21161,19081,17033,17001,17001,14953,14953,14954,12906,12938,14986,12938,12971,12906,15019,27501,29516,54740,46353,255},
{52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,55069,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55035,55035,42488,34134,29875,42292,44307,42193,42095,37837,37934,35854,56952,65469,59065,27632,17230,25584,25616,38131,36018,25453,21162,23242,23275,27435,27468,27500,29549,31629,29548,31596,33677,44274,60883,60949,36116,19570,23634,21390,46485,33775,27533,33775,33807,29581,38000,25388,38065,23340,40146,25388,40113,27533,44307,31662,48532,31727,38033,29582,40113,27501,42194,25388,40113,25388,37968,27500,33774,31661,29548,33774,25323,37935,21129,37935,29319,60517,54114,43782,52462,39786,52463,56591,50351,54577,65174,65270,54573,39653,54739,54609,60878,31530,25160,52398,50415,58799,39882,33545,61044,65301,65202,61108,31594,18983,19081,19113,19113,19114,19114,17066,17034,14986,14986,15018,15018,15018,12938,17131,31695,31760,35921,33774,50547,52627,255},
{52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53021,55069,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55035,55035,44569,32118,36116,42259,38163,34003,46353,42062,37902,39949,48467,65469,63291,61177,52759,56919,48533,50645,48565,35952,23275,21195,23275,23340,23308,23275,27468,27468,27468,27468,29516,42128,60882,60916,40244,29908,36148,17002,46452,46387,48500,38033,33839,33775,35952,27501,35952,25388,38000,21194,38000,21194,42194,23210,35887,33775,29582,25388,31694,23307,35920,19049,35920,17001,35888,21162,33774,25355,29549,29549,25355,33774,21129,35887,23144,54246,58338,50020,43880,41998,54674,60881,48238,58770,65173,63191,65303,43977,37704,54707,50381,58899,52595,58803,58867,46123,44043,65237,61074,41994,50348,54606,63222,33675,19014,19081,19114,19114,19114,17066,17034,17066,17099,15051,15051,23340,21422,13262,19569,27758,54539,31530,39982,63094,255},
{52988,52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55068,55069,55068,55069,55069,53020,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,46681,36247,29940,44339,29874,23698,31824,48270,48270,50317,42095,61210,65404,65371,54839,21098,21227,17067,10891,15052,25388,17001,21227,25420,21228,19115,27468,27468,25388,27435,29516,31596,50286,56756,50646,50711,56984,19081,42193,46387,44241,37968,25421,31662,29614,27468,29679,23307,35888,19082,35920,17001,40146,16936,27501,35920,27501,27501,29614,25388,35887,21130,37968,17001,38000,19082,37968,23275,33774,27468,29516,31629,27403,35854,21129,44043,43877,27237,33513,46256,56821,58867,48336,60948,63094,63192,65304,58931,33510,39915,48301,56719,46223,58834,60947,44141,61076,58929,31495,23143,42029,46057,63057,63189,35787,18982,19081,21194,19146,17066,17098,17099,17099,17099,17099,52656,46742,19991,7671,26129,65096,39918,31531,61013,255},
{52988,52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,55069,53020,53020,53020,55069,55069,55069,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,46682,34199,31988,36083,34003,25779,40146,40015,42094,39982,35854,48466,56919,65338,54839,16937,21130,14986,10858,12939,23307,23275,23307,25388,29516,29548,29549,31629,31629,29516,29516,31596,29516,40080,56919,61178,63291,23243,35855,46419,29581,38000,25420,33807,29581,29613,27598,27501,33807,21162,35920,19114,42194,19049,21227,38032,23307,31694,27501,27436,31694,21162,33807,19049,37968,16969,37968,19082,35887,25355,33742,29549,31629,35855,25355,37935,27369,19015,31563,46223,54773,56755,48205,63060,63126,65272,65240,65270,50414,31430,48236,54638,35658,58769,63125,65203,65167,33641,18950,23143,31562,48170,52427,48366,63221,37868,18982,23241,21259,19147,17098,19179,19212,19179,19212,48592,38518,19991,5623,28175,65096,42128,23144,54707,255},
{52988,52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,55069,55069,55069,55069,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55035,55036,50875,36247,23699,17522,36083,29874,50547,44240,40047,35854,37967,39982,44207,63257,50613,16807,21130,12906,10858,15051,23275,21162,23242,25323,27435,29549,29548,31596,31629,29548,29516,33742,25258,29483,59032,63290,65339,54871,54839,46387,21227,38065,23307,35888,25388,31694,27501,29581,31695,23307,35888,21163,42194,23275,27469,42161,25388,35920,29614,31727,35887,29581,40081,27501,42194,27469,42226,29549,42194,31661,40048,33742,35887,35887,33709,37935,37934,37543,46061,50384,54675,54708,52431,63158,63191,65272,63191,63126,65270,39882,35689,35688,48204,63027,65335,60977,58698,37867,18983,25256,27369,44141,46155,39949,42061,65270,39981,19014,21161,21227,19211,19211,21260,19212,23373,19893,36537,7702,5622,32239,60775,37935,23144,46288,255},
{50940,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,55069,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55035,55035,55036,48762,34199,23732,21651,40179,31890,44241,44207,35919,27565,35886,33773,23339,44208,35953,10663,12743,12808,10793,14986,25355,21162,21195,23275,25355,29581,29516,25355,27435,27403,27338,29483,21064,27370,61145,65371,65371,65404,61178,46420,27533,44307,29614,40146,31727,38033,31759,33840,35952,33775,40081,29614,42226,35920,42194,46420,29581,38000,27468,35887,29613,31662,31726,25388,35887,23275,38000,21129,38000,19082,35887,23242,35854,25388,29549,27501,42161,27305,31368,50318,52627,48369,52431,63159,63192,65272,63127,56853,65271,58898,41963,23044,48270,65367,65236,54607,39784,48333,23209,27402,31530,44142,43977,48398,25322,39981,63221,40045,18982,21161,25420,23340,23340,23372,25453,29905,34098,15797,7638,38285,58533,46255,39883,35724,255},
{50940,52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55035,55036,55036,42553,32119,25812,23667,40147,29680,37935,42062,37935,35887,31694,33774,31726,39949,31693,10761,14791,12776,10760,12939,23307,21130,23275,23275,25355,31661,21064,14758,16806,18886,18886,18919,21097,25225,61144,65404,65404,65404,65371,52726,46387,48532,25388,40113,25355,35920,23308,31726,25421,27501,29614,25355,33840,29581,19082,44307,23308,35920,19114,35887,25388,31694,27533,27468,29646,23275,35920,21162,38000,19082,38000,21162,37967,25323,33742,25388,48500,25290,25192,50318,54773,48336,56690,65206,65240,65272,61047,58999,58966,56786,63091,48367,58962,61010,58769,44011,44043,58799,37804,35755,41996,48335,46123,54573,44175,42061,54672,65334,44174,18982,29482,46287,50480,50480,50448,48368,50448,34261,9751,44491,62855,54574,50349,29418,255},
{52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,53020,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55035,55036,50875,34199,29972,27827,36051,29647,44079,42062,46191,44175,35887,33806,37967,44141,39916,12841,12841,12841,10761,10858,27469,42097,21227,17034,17001,31628,21032,14726,16806,18854,20934,20967,23112,23177,61079,65436,65436,65437,63291,52693,35855,46420,21162,40114,21195,38033,19147,33839,23340,29614,27533,27469,29679,33775,14954,44274,19114,38001,19114,38001,23340,33807,25388,31662,27566,25388,33807,23275,38000,21162,38000,21130,40048,23242,35887,23242,46485,29451,27305,46125,56821,48271,60948,63126,65239,65239,63192,63225,56853,44273,58930,63057,41700,31299,35559,50251,48268,54572,56719,50381,52495,52495,52560,54573,54640,44141,44142,46287,63189,44206,18982,21062,25288,25288,31595,42094,48532,50774,40470,56813,62923,50448,54576,50382,255},
{52988,52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53021,53020,55069,55069,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55035,55036,52923,34199,34068,27827,38099,38002,48370,39982,42030,42030,37999,33806,37966,42030,39949,17066,17066,23340,23340,21227,19115,25390,14954,12841,10728,31662,21032,16806,18886,23210,18951,21000,25258,25192,61112,65437,65437,65469,63323,52726,29549,40146,23242,40146,21195,38065,19147,38000,21260,33807,23372,29582,27566,35920,12906,44307,19082,38033,19082,38033,21162,37968,23243,33774,25388,29581,29581,25355,33839,23210,37935,23242,40048,23210,40048,23242,50645,38000,35855,52562,56820,50383,46189,46288,63159,63160,63127,63160,48434,6371,23143,63091,52231,41700,52429,37672,39883,41962,46286,29482,33708,37836,46288,43977,50479,31661,33742,31694,44174,65334,50512,23175,14789,25190,44109,44142,48629,44631,32278,56778,56618,27533,29613,35756,255},
{52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55035,55035,55035,52955,32151,31988,23699,40179,44274,48370,42063,31629,33709,37934,31693,44142,44207,37868,35821,33774,33741,21227,27500,19180,19180,19147,19082,19082,33775,14791,10597,12646,21065,16839,14758,21064,21032,56887,65469,65437,65469,63323,54806,25387,38098,21162,40114,19082,38065,17001,38001,19146,35887,21227,31727,25420,40113,12841,42194,27436,40081,25388,42194,27501,44274,33742,46355,38001,46387,44307,46420,48565,48532,54807,52726,56952,54839,59065,56952,61210,59000,59032,61047,54708,39917,37640,44175,65239,63192,63127,63192,42128,4291,4258,39948,63156,43910,39719,27206,27336,46123,56751,31595,35821,39981,44175,44043,52461,37967,35854,35822,50546,65366,65398,56915,29449,21095,27500,25486,44502,34424,9719,52680,52423,19277,19244,35789,255},
{50940,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,53020,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55035,55036,55035,52955,36247,29908,31923,42259,44306,44177,39917,29549,39917,33773,31726,25453,42127,35821,31661,37902,27532,14986,35789,27467,17001,23306,10728,12776,31629,25290,14725,14726,16806,18886,18886,25258,29353,52693,65469,65437,65469,63324,52726,33807,44307,35888,46420,37968,48533,38033,50646,44307,50678,48501,54839,52758,59032,52758,61145,56919,61178,59065,63259,59097,63258,61178,63258,63291,61145,65404,61113,65436,59065,65436,59065,65371,61145,63258,61145,63291,52693,61080,63127,40047,25257,39786,56788,63192,65207,63126,63192,37934,8419,6339,39786,63091,58866,37638,25125,25223,44076,56718,37933,39982,44142,42094,48400,48301,44239,42096,58965,65301,54705,58897,60977,63189,35787,19014,23307,33937,26069,9686,38123,29447,19245,17164,29613,255},
{52988,52988,52988,52988,52988,52988,53020,53020,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,55068,53020,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55035,55036,55035,55035,55003,40375,38196,36083,36083,23666,42161,37902,27533,29613,25485,25517,31726,40047,40014,35821,33708,31660,17066,27435,44175,31661,29548,12808,14856,31629,25258,20934,23047,27175,29288,29288,46094,60623,58935,65469,65469,59097,61047,63323,59032,63323,59032,65404,59000,65404,59064,63323,61113,61210,61178,61145,63291,61178,63193,65469,56919,65404,56984,63323,59032,61210,61146,61146,61210,59065,63323,61113,65371,59032,63323,59032,63290,61145,63225,63193,63258,54806,61047,63061,27370,31531,41899,61079,63192,65239,63159,63159,46289,37902,44209,52562,58802,65269,52591,33445,35624,48335,50381,46319,37901,44175,42095,48401,35591,39883,63222,63188,46319,35919,48401,48269,58832,65366,44206,21062,25485,32279,17877,13132,19276,19245,17132,21292,255},
{52988,52988,52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,55068,53020,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55035,55035,55035,52955,40375,34068,36083,34003,21618,46452,35855,27565,29646,25485,19277,25453,42062,42061,41997,37868,31660,31628,37902,63225,63290,59032,16969,10695,40015,48174,58509,60621,62734,60622,60654,58608,60590,61014,65469,65469,59065,61080,65437,54839,65404,56887,65372,54807,63323,56919,63291,59065,61178,61145,61113,63258,61178,61112,65404,61080,63323,61112,63291,61145,63291,63226,63258,63258,61178,63291,61177,65339,61145,63291,63225,63258,63258,61145,63291,61177,54806,63192,58932,29483,44144,46224,63224,63159,63159,63159,63159,52725,33709,50481,60947,60914,60914,63123,48333,29285,39883,48267,54704,35821,42095,42127,46288,56786,63154,61042,42127,33839,35887,40080,50414,48071,52592,65301,52625,23175,19243,13294,5103,42420,41929,39913,25420,255},
{50940,50940,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55035,55035,55036,55035,40407,29940,34003,25746,23666,42194,31726,33774,27533,23405,15084,12971,33741,50316,37804,39916,42061,33708,46255,54774,52693,50548,14889,8582,31629,58511,62637,62734,64847,62767,60655,60655,60655,60949,63291,63258,63258,59064,65371,59032,63323,61145,63323,61113,63323,61145,63291,63258,63258,63258,63258,65371,61178,63258,65372,61145,63291,61178,63259,63291,61178,63324,59032,65404,59032,65371,59032,63291,61145,61178,61178,61145,63291,59032,65371,59032,50515,63126,61046,52595,44209,56886,58901,63159,63159,63159,61046,18984,4291,20998,56689,58834,60915,44010,61043,41995,31431,41995,56752,37934,37934,42095,58932,65268,60680,54673,37968,33806,33839,33807,48400,45991,44174,37966,63188,58963,27401,16999,9361,33836,50053,41959,23307,255},
{50940,50940,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,55069,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55035,55036,55035,55003,34199,36116,36051,23699,21586,35985,29646,33774,35854,27533,21292,15052,19211,54509,39949,33708,35821,27500,42160,61080,48467,35887,12808,6502,25323,62735,62734,64814,64847,62735,60655,60654,60655,60720,60721,60720,56723,56822,65404,56984,65404,59032,63323,59000,63291,59065,63258,63258,59032,63258,61145,65436,59000,63225,63323,59032,63258,61113,61178,63258,61113,63290,61080,63291,61112,63291,61112,63290,63225,63226,63225,63193,63258,61112,65339,63226,52628,56658,60948,54707,46289,56886,54741,63159,63158,63191,56821,10565,2211,25192,58834,58867,60947,27239,29383,61076,39817,39883,35689,33675,44143,63157,63187,54672,50217,54671,40048,33807,31759,29646,38000,46254,46156,31758,31693,56850,63253,35787,16902,23274,25453,15052,15051,255},
{50940,50940,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55035,55035,55035,55035,55036,38360,25779,25779,25747,25714,40112,35919,35854,42126,35854,27500,23372,25452,44109,42062,33741,35821,25419,42193,65305,31694,6567,10728,8583,31564,62702,62701,62734,64847,62767,60687,62734,60654,62734,62734,60654,54577,56952,65404,56887,65371,59000,63291,59032,63291,61145,63258,63226,61177,63258,61177,65371,61177,63225,63323,63258,63291,63290,61178,63323,61145,65371,61145,63291,61145,63258,61178,61145,63291,59032,65371,59032,65371,59000,65404,56919,50481,58802,58867,54675,56820,58999,61144,63159,63126,63192,52628,10564,6306,35625,58768,58802,56689,25158,18918,44108,61011,48334,27238,42061,65334,58929,42094,40015,44174,52493,40079,33774,33774,29614,27566,48400,43879,42094,29614,31628,44205,65302,42126,21062,19081,33773,39981,255},
{50940,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55035,55036,55035,55035,55036,42488,27892,21651,27827,29810,46255,37934,29646,37967,37966,35853,29581,29581,44078,44144,44241,29580,27500,29646,31694,14889,8615,8615,14921,33709,60525,62637,62734,64847,62799,60719,62767,62766,62799,62799,62734,44078,56919,65404,59097,65372,61178,63323,61210,61210,61210,61146,63323,59065,65404,59032,65437,56887,65371,63258,63259,61178,63323,59032,65404,59032,65404,61145,63323,63258,63291,65371,63258,65404,63258,65436,63290,65436,63323,65404,54772,50382,60850,54642,54642,61046,61111,63159,63159,63159,63159,54708,37837,44208,54610,58802,60914,50415,37705,46156,44043,54639,65301,61010,52525,48201,33511,37836,48335,52528,46056,56753,50480,50480,50480,50448,56785,46057,52461,52560,46352,11117,34227,65399,50544,23143,29415,37834,255},
{50940,52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55035,55035,55036,44569,29940,23699,29875,25714,46255,42062,31661,35854,33774,31661,25453,27533,41997,41997,46223,44175,33741,27566,21260,8615,8615,8648,14921,39951,60525,62637,62702,62767,62735,60687,60654,60589,60589,60621,58542,37838,54806,65436,56984,65404,61145,63291,63258,61178,63323,63226,65404,61178,65436,63258,65469,63226,65468,65404,65404,65371,65404,63290,65404,63226,63323,61145,61178,61112,59000,58999,54773,54773,58868,56821,54610,54642,52432,48303,39851,46125,58803,50384,54643,63127,58901,63127,63159,58932,63127,56886,35789,37836,58835,63027,60914,48237,27238,25158,31497,33610,54705,65268,45860,35394,33413,46156,46221,48367,41962,56719,40014,37901,35854,31693,33773,48400,44043,35853,23502,9750,5622,38518,65334,56850,27336,16869,255},
{50940,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55035,55035,55035,55036,42520,32021,29908,44340,29842,48271,46125,35822,35854,37934,35789,29548,37869,37869,31596,23308,42095,50382,42094,23307,8615,8680,8680,14888,52497,60590,62637,64782,64847,62767,62767,60688,60622,60654,62702,58608,40048,54676,65436,65371,65404,63290,63291,61177,61177,59065,59032,56952,54806,56886,50580,54806,44241,50547,44242,48369,37902,46224,35756,42062,33611,39917,31466,29418,31465,29385,37674,25159,33448,35495,45896,45863,45831,47912,45929,48434,50612,54838,52562,56788,58966,58966,63127,61046,39982,63159,29515,4291,4291,33578,60914,63027,44044,25125,18918,25191,27369,31562,56817,60977,45925,37606,31563,27468,31661,44142,50381,35854,25421,21325,21325,23373,44240,41832,42093,23470,19925,21940,30101,42258,65334,63189,37899,255},
{50940,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55035,55035,55035,55035,55036,46649,32053,25747,34035,25714,44078,52333,39950,35822,39982,37869,33676,46092,42061,29580,23340,33709,50384,37869,17033,8680,6632,8647,12808,21130,46061,48043,50156,50187,48108,46060,56559,62702,62767,64815,60720,50417,65272,63192,42062,37903,29483,39983,23177,35724,23144,31499,23112,33546,31465,31465,35594,25192,35626,23111,33513,20966,35593,23046,37674,20998,35626,27239,29320,27272,29352,37673,25191,33448,29287,47976,47976,45962,39982,44241,50678,52791,54871,50547,56854,50580,50547,63126,63126,52660,61079,19048,4259,4259,23112,58802,60914,33577,10564,14789,23143,27337,25322,27369,54769,60978,39718,31430,27467,25420,42094,46056,44239,21260,21292,23373,21325,31694,46155,44043,27566,31792,25518,33807,46353,65333,65398,65366,255},
{50940,52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55035,55035,55035,55035,55036,48762,32086,23699,27859,38065,52333,48238,44142,35822,29581,29646,35821,48204,35756,35789,31661,35788,44175,39950,21162,6567,6600,8615,10728,12841,12776,10663,12808,14856,14856,16969,43980,52236,50220,48107,43947,46224,65304,56886,25323,25224,16838,37804,14725,33578,14758,31465,16838,35626,29352,35625,33545,33546,33578,27272,31465,23079,35593,23079,37738,16838,37739,27239,33513,25192,29385,35593,29352,31367,33447,45896,47944,43914,25355,25356,46452,59065,56886,48238,58934,54774,54805,63126,63126,63127,58966,16936,6371,6371,21064,56656,60914,31432,20998,23143,29417,29450,25322,21194,25322,54769,58930,37638,29351,25322,35822,44010,50479,23372,19212,21260,21292,21292,44240,35722,29548,17099,29614,56883,61042,40013,61076,65398,255},
{50940,50940,52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55068,53020,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55035,55035,55035,55035,50777,44471,40309,34004,46353,60653,54445,46222,37902,31693,29645,23340,39916,37836,33676,35821,40014,44142,46191,48239,21130,4455,6502,8615,10695,10695,8582,10663,10695,12743,12743,12710,12710,10662,8550,6469,33742,65206,56919,42259,25225,12709,37804,14726,33578,12677,31498,16806,37739,29352,37706,31465,41899,35626,29385,29352,25159,31433,23079,35658,14758,37739,23079,35625,20999,31465,29320,29352,27207,41736,45864,45864,43914,31727,33807,46420,54839,46387,48434,56821,58967,61047,63094,63126,63126,56853,35757,44176,44208,46256,56624,54575,33545,39883,39883,37802,31562,25322,21194,21194,25322,54737,58931,35590,27271,27468,42094,50348,31726,17132,21260,19244,19212,35887,37769,25158,46385,65236,48462,21291,19212,59029,65365,255},
{50940,52988,52988,52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55035,55035,55035,55036,55003,54839,58935,50646,27827,31890,50285,50285,44174,39982,33742,31693,37901,44012,35724,39884,37869,31725,40014,52336,56462,27403,8680,8615,8550,8582,8583,8550,8582,8582,10630,10630,8582,8582,8582,8582,6470,37968,65141,56887,63259,27338,12677,37837,14726,33578,12677,33578,16806,35658,23079,33578,25224,33611,31465,31466,23176,27305,27337,31498,37804,21064,31498,33611,31563,31498,31563,35724,27370,20966,45896,45896,45896,48009,46191,25355,35822,42128,35920,40113,61046,61112,63159,63126,63126,63159,52659,33774,16870,21064,12645,50383,56689,31399,23110,25191,27336,27369,23242,19114,19114,21194,23242,54737,58963,35591,25223,42061,46056,44271,19180,19212,17164,17164,29581,58964,58896,63154,33772,15084,13036,21292,63189,65234,255},
{50940,52988,52988,52988,52988,52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55068,53020,53020,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55035,55035,55035,55035,55035,55036,52857,52726,48566,25747,31857,35790,42030,37934,40014,35854,33741,33708,44044,33677,39885,33709,33839,37902,52530,56658,37837,29452,19017,6469,6502,6502,6470,6502,8582,8550,8582,8550,8582,8582,8582,6502,27435,44110,39983,35822,31531,18983,48466,25290,29451,23177,33644,25257,39885,33643,42063,48368,46256,52562,33644,40048,39884,46289,54576,52627,23177,50547,52496,48369,41998,50481,56755,44241,16805,43816,45831,45929,45897,45994,21064,29418,31531,27501,31694,54740,61014,63094,63127,63126,50482,21064,2211,10532,37804,4324,37835,50382,16772,12676,14789,18983,23176,21161,19114,19114,21194,19114,23241,54737,58963,33511,35657,39915,46286,21292,19212,17099,27533,54771,65366,60745,52460,17164,15116,13036,23405,63221,65201,255},
{50940,52988,52988,52988,52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55035,55035,55035,55035,55036,48762,34134,34069,25811,36018,42127,40015,40047,40047,46222,44078,37902,35853,25420,39917,29581,48303,41932,52531,54741,37838,39789,31499,14857,16839,18920,18952,16937,10663,12776,10696,10695,8582,12776,14889,14856,16936,10662,29385,27207,35724,16870,50580,25257,46354,25257,48467,33611,58933,52529,61046,58900,60981,61013,48401,52627,54577,60949,60882,60981,50416,63028,58770,58867,54609,56689,56689,50481,25224,50285,56526,56559,58737,56592,44012,52463,46288,38066,31727,56788,63126,60980,63159,61013,19049,6372,4291,16805,52431,6436,31562,41963,10596,12677,14789,18951,21096,21129,19114,19114,19114,19114,19146,29450,56786,58963,35624,39980,27270,21194,21292,42192,63189,52624,35885,52396,48170,25518,13036,13036,27566,65301,65103,255},
{50940,50940,50940,52988,52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,55068,53020,53020,53020,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55036,55035,55035,55035,55035,55035,46682,32118,34068,29907,36050,44207,44175,37934,37934,46189,48205,39917,46157,33741,42061,33709,48140,50188,48208,50287,41901,39756,35724,48468,43852,51978,54254,39918,21194,23340,14921,12841,19050,27468,29581,29581,25323,19049,29418,33579,48369,50351,58900,52463,58900,50350,58867,52495,56754,52463,54576,52431,50318,50350,44077,48237,35658,46092,31433,41899,29320,37673,27239,33513,29320,27240,31400,42029,35756,65238,65238,65270,65205,54608,18886,39852,52562,48500,33774,52595,63061,56755,61013,56852,14823,6404,6372,16838,41996,8517,23144,31497,10564,12709,14822,18983,23176,21161,19114,19082,19114,19147,19147,25355,27403,54705,58931,52560,31463,31562,58996,61042,35884,19179,17132,42160,39850,37966,15052,15084,31759,65301,65169,255},
{50940,50940,52988,52988,52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55069,55069,53020,53020,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55036,55036,55036,55036,55036,55036,55068,55068,55068,55068,55068,55068,57116,48762,32086,27860,21618,40211,42160,42127,37935,35854,42094,42095,39950,46157,42028,39981,39950,31629,37903,35531,41901,31597,23178,25323,27501,25258,27306,27403,23275,17067,19180,17034,17100,21228,19179,21292,21292,21227,23373,31498,33611,46191,29319,39754,29287,39754,20998,33545,20966,33480,23079,31401,29385,33545,39819,31465,35724,27305,31499,27370,33611,25225,31563,31597,31596,39950,29483,44208,42095,37837,65238,65205,65238,60882,33545,25257,39917,46223,38001,25356,29614,52627,58933,63159,54708,12743,8549,12710,21064,29450,12678,18951,23078,12677,14822,18983,23144,25256,21161,19114,17034,17066,19147,19147,25355,23307,23274,52625,65365,63188,54606,48201,33510,27369,37902,42094,52561,48138,50283,48367,48302,54673,65301,65201,255},
{50940,52988,52988,52988,52988,52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55068,55068,55068,55068,55068,55068,55068,55068,55068,55100,57148,57148,57148,57148,57148,57116,57116,55068,55068,55035,55035,52955,52923,52890,50842,50809,48729,48696,46584,44503,42422,40310,34068,27762,25616,21455,29679,29646,27566,27501,35953,38066,42291,33873,31792,21325,21390,19278,15117,17262,17197,15117,17230,15084,19310,17295,17262,19375,21455,27696,21455,21455,19245,21391,21358,19245,23471,21358,21325,25552,29451,31368,50482,27338,37772,41931,37805,25257,44175,39949,37837,31596,52530,52595,50384,54708,37772,52627,39885,50547,31563,50547,37837,50514,44208,48401,52562,50449,58933,46288,44078,65270,65270,56753,27206,23078,18917,41964,39884,44242,54806,25682,48532,63126,65239,52627,21130,10597,10564,23079,58768,18983,4324,8484,12709,18983,23143,23143,23144,19081,17033,14986,17034,17066,19147,25355,23307,19179,21227,52625,65398,52264,41602,31300,39882,37901,35821,33773,48334,41864,50513,23372,40079,65300,65136,255},
{50940,52988,52988,52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,44569,38327,38294,38262,36181,34101,34068,29907,29875,27795,25681,27729,25649,21488,21521,19440,19408,19408,19408,19408,17360,15279,17360,17360,15214,15247,17295,15182,15247,17295,17230,17327,15214,15182,15247,15182,15215,17360,15247,15247,19408,17295,17262,17327,17197,19343,21456,21423,23568,23568,25583,21456,21456,19245,19375,19278,21293,25552,21358,21326,23504,33644,37674,54675,33579,58901,56559,54740,37836,61013,56689,56755,52496,63028,60948,58834,61013,54544,58834,54544,58802,50318,56657,50350,52431,48270,46125,48173,39819,48205,39884,48303,65270,65238,58899,31496,27238,33544,50448,41998,54708,65239,52693,61014,65239,65239,65272,48466,6372,4323,10532,27271,8516,6404,6404,10597,14757,14789,14757,14822,14887,14921,14953,14986,17066,17098,21227,21227,17132,17132,21259,50544,65301,52362,41733,27369,17132,15116,15084,37999,37835,46254,13036,35984,65333,65201,255},
{50940,52988,52988,52988,52988,52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55068,55068,55068,55068,55068,55068,55068,55068,55068,52956,19538,11152,13199,13297,13329,13329,13330,13362,13361,13362,13362,13362,13362,13395,13394,13362,13394,13394,13394,15442,13362,13297,15345,15377,13199,13199,13231,13134,13232,15247,13134,15280,13166,13102,15279,15182,17295,17328,15215,17295,17327,15149,15214,17327,15117,21456,21456,23503,25616,27664,25551,23568,23503,19245,21423,21325,19278,25584,21325,23438,27599,44175,52430,56689,48205,54544,44044,52463,41931,48237,37738,44012,39786,37673,37673,31400,37738,29319,33512,23079,31432,27239,33480,23079,27240,27272,25192,29386,23112,33643,27305,54642,65270,65238,65237,43881,29221,33511,48368,39820,60948,65173,56721,44142,44175,39949,31563,19016,4323,14758,8452,4291,6372,6372,6371,8484,8484,10564,10564,10597,10694,12840,12905,12938,15018,15019,19147,17131,15084,17164,17164,17131,42191,65302,52493,37637,27368,17196,15149,21389,46221,46024,25453,40113,65300,65169,255},
{50940,52988,52988,52988,52988,52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55068,55068,55068,55068,55068,55068,55068,55068,55068,52956,19603,13264,13264,13394,13427,13427,13427,13427,15474,15475,13426,13394,13394,11379,13395,13394,13394,13426,13426,13297,13297,11119,13199,13199,11086,13199,13199,13134,13199,13199,13134,15247,13134,13134,15279,13134,15247,17360,17295,17295,17360,15182,17295,19375,21423,23568,23568,25584,25617,25616,23503,23568,23503,19277,23504,21326,21358,25584,23374,25519,27664,42096,25160,44111,20999,31433,23111,29385,21031,31466,27305,31498,29418,29385,31531,33579,37837,33546,33676,29418,37902,37836,35789,29483,31563,37837,27338,37935,23177,42063,18951,56754,65238,65238,50317,35528,25093,39786,48303,37739,63093,63028,31530,8484,6371,6372,4324,4324,6404,18918,8484,6404,6404,6404,6404,8484,8516,8516,8516,8549,10662,10792,12873,12906,12938,15019,17099,17132,15116,17164,19244,17164,15083,35885,65301,56719,37638,27335,17196,13068,42159,41864,40047,44338,65268,63088,255},
{50940,50940,52988,52988,52988,52988,52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55068,55068,55068,55068,55068,55068,55068,55068,55068,52956,19603,13264,13264,13362,11411,13427,13426,13394,15474,15442,13394,13394,13394,11379,13427,11379,13394,13394,13394,13362,13329,13232,13199,13232,11119,13232,15279,13134,15280,13167,13102,15312,15247,13167,15280,15182,15312,17425,15312,17295,17327,15149,19375,17295,23503,23568,23535,27664,23568,23536,27664,25616,21423,19310,23504,21325,21390,27632,25454,29680,31760,52693,35757,54708,39983,46321,42062,44176,39885,42128,35756,48369,39918,29418,37837,27337,44176,25224,39983,23177,42063,29418,44144,35724,37870,35724,33644,42063,27370,46321,44142,60948,65238,65238,50350,33545,25223,39917,48337,44046,63192,61046,46223,14725,6404,8484,8484,6436,6404,16870,10597,8484,12677,14758,16838,10597,10629,10597,10597,10629,10694,12840,12873,12938,12938,12971,15084,17164,15116,17164,17197,17196,15116,13036,29645,61108,58930,39719,29383,17131,27631,40013,41963,48433,65300,63121,255},
{50940,50940,52988,52988,52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55068,55068,55068,55068,55068,55068,55068,55068,55068,52988,19636,11216,13265,13394,11379,13427,13426,13394,13426,13394,13394,13426,13394,13427,13427,15475,13296,15410,15474,13427,13394,13199,13232,13232,13232,13264,13232,13167,13232,13166,13134,15312,13167,13166,15279,15182,17360,17425,15312,17360,19408,19375,21456,21455,21358,25649,25551,31857,33970,31825,36018,40211,36018,35986,40211,35953,40147,42292,38033,44372,42292,38065,38098,44307,63225,61112,56886,37935,42095,48336,35724,50449,39982,33709,40015,52529,58901,33611,52563,39917,52627,41997,58868,54610,44209,46257,46256,54740,42063,58933,50384,63125,65238,65205,65205,58801,50285,54609,46256,50384,65174,63093,50351,18886,14790,14790,10630,12677,10565,18951,25160,18983,23112,29385,39786,25191,16870,14790,14790,14822,14823,12873,12906,12938,12971,15051,15116,17196,15116,17197,17229,15181,13101,13101,13068,23404,56883,63124,41929,29350,21227,46254,43846,58899,65236,63024,255},
{50940,50940,52988,52988,52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55068,55068,55068,55068,55068,55068,55068,55068,52988,19604,11216,13297,13362,11411,11378,11379,13395,11346,13427,13394,11346,11314,13394,13394,13394,13394,15442,15475,15475,15474,15442,17490,17490,19538,21553,21521,21488,25714,25681,25649,31955,31825,31858,36083,33873,42357,44437,44405,38163,40179,33905,40211,36050,31825,36083,31857,29744,34003,27664,27664,29809,23471,23535,23536,19278,21423,19343,15117,17262,13069,8843,10956,44339,63258,61177,35855,23242,44241,58999,58967,44273,40047,42030,50514,52594,58966,56755,61013,60883,61013,58802,63061,62995,60915,62995,60882,60882,60816,58737,60816,58638,60817,54543,58638,54544,54511,63028,39852,52497,65239,63126,39819,20934,21097,27337,18983,16870,18951,23079,35625,39786,39819,50252,54510,37672,27271,21030,18982,19015,19016,14953,12938,12971,13003,15084,17197,19277,17229,17197,17229,15181,15149,13133,15149,13069,19244,52657,65269,44042,29285,39948,39849,54672,65300,63089,255},
{50940,50940,52988,52988,52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55068,53020,53020,53020,53020,55068,55068,55068,55068,55068,55068,55068,52988,21652,13264,15377,17490,17555,19603,19635,23764,25877,27957,27957,34133,34133,36246,40374,40374,42422,44535,40342,42422,44470,36083,40276,38228,33938,38164,33970,29777,34035,29777,27664,27761,23471,23503,21488,15149,19375,17262,15149,13069,11021,8875,10989,8876,8811,8908,8811,6763,8875,8778,8811,8875,8778,8811,10891,8745,10891,10859,10826,12971,12906,10794,17100,59065,61177,50678,44242,48500,61211,46485,59130,35888,35562,50157,56853,59031,56853,50383,60653,56460,58606,54413,56460,58541,54380,58605,54348,56460,54412,52299,58573,52267,61079,54511,54413,46093,52431,60980,39820,52367,60981,65239,41932,33448,50547,52496,39786,37609,39754,43947,43914,44044,43979,56558,48236,33447,29319,23143,21095,21096,21129,17066,12938,13003,13036,15116,17229,19277,15181,15181,17262,15214,13101,13101,15149,15149,13069,17164,46352,65334,48268,35558,42061,46287,63122,60975,255},
{50940,52988,52988,52988,52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55068,53020,53020,53020,55068,53020,55068,55068,55068,55068,55068,55068,55036,54970,54905,57018,59130,54969,59130,61243,54970,46616,44535,44535,40374,40374,31987,29940,21585,27827,21651,13166,13199,11119,8908,11054,8941,6795,6860,6795,4683,6828,4682,6730,6762,4617,6698,6730,6633,6698,8713,6633,8713,6698,6665,8810,8746,8778,10891,10826,10891,13004,12971,15084,17165,15084,19278,21326,25421,27599,31727,33743,35953,35888,29679,27665,54871,61113,50678,50613,54872,52791,59032,61145,42031,43851,54220,58966,65403,46321,40014,56525,52267,52463,48237,50350,56493,54347,58605,54412,56428,58541,52333,60686,56526,61080,56657,54512,50319,60883,56787,39755,60916,63093,65207,46190,33448,52628,48401,48237,43914,41834,41931,44012,46124,44044,58801,48204,35624,31432,23143,21128,23176,21194,17099,13003,13003,13068,15149,15213,19342,15214,15246,15246,15214,13134,13133,15181,15181,15149,15149,15116,38030,65301,50447,48301,56818,56850,35493,255},
{50940,52988,52988,52988,52988,52988,52988,52988,52988,53020,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55068,53020,53020,55068,55068,55068,55068,55068,55068,55068,55068,55068,65404,65371,65404,65404,61243,63323,54937,23568,9006,8973,10989,8941,6860,4682,6795,4682,4682,6763,4617,6730,6730,6665,6763,6730,6698,8843,6763,8811,8876,8843,8875,10988,10956,10988,13069,13004,15214,15215,15182,17295,15182,13102,15279,17229,15182,19408,17230,19343,19408,19343,23504,23503,21358,29745,29712,29647,33905,31760,35920,38066,33840,35985,25616,46485,61145,50646,56952,31727,17002,50416,54577,48141,52205,54253,60786,63094,56820,54511,56428,52235,52332,52300,50253,56526,60851,63061,60981,63126,63127,63159,63159,63160,63192,61111,63225,52692,58933,54641,39787,63126,65173,65239,50383,35561,52692,50449,54575,44011,33545,35626,39851,41931,48172,58768,44011,35560,25223,21096,21161,23274,23372,17229,13068,13068,13101,15214,17294,21455,19375,15246,17294,15246,15214,13133,13133,15181,15181,15181,13101,13069,31725,63188,65301,65366,65301,25092,255},
{50940,50940,52988,52988,52988,52988,52988,52988,52988,53020,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,55068,55068,53020,53020,53020,55068,55068,53020,55068,55068,55068,55068,55068,63324,63291,63324,63324,61211,63324,31956,9006,9005,8973,11054,11086,11087,11086,11119,11151,13232,11184,13297,13297,13297,13264,15410,15377,13297,13297,13264,13199,15312,15214,13199,17360,19375,15280,17328,15182,17393,17393,17393,19473,15214,15182,17360,17230,15182,19375,17197,17295,19375,17197,21423,21423,21358,27664,25519,21358,25616,23406,25551,31825,29679,33905,21391,35986,61178,48565,54904,31694,21097,52497,54577,27240,31271,31271,31239,29223,27175,25029,20869,12612,12645,23080,44209,54773,65370,63224,61144,65338,63225,63224,63257,61112,63257,61112,63224,44273,58900,52496,46093,65239,63093,63159,54610,44013,56788,52497,33578,25159,33545,35626,41932,39884,39884,39786,23078,25256,25355,25388,27533,27566,25583,19375,15181,13101,15246,15246,17327,23535,19407,17327,17327,15279,13166,13166,15214,13133,13133,15181,13133,13133,13101,27532,58962,65365,65398,42028,255},
{50940,50940,52988,52988,52988,52988,52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55068,55068,55068,55068,55068,55068,55068,55036,63324,63291,63324,63356,59163,65404,32053,13427,13427,13459,13459,15475,15507,13426,15475,15507,13427,15442,13427,13426,15442,13232,13329,13264,13232,15312,13134,13167,15280,13102,13199,15279,13101,13231,15247,13069,15312,15312,17360,17392,15181,15182,17327,15149,17295,19408,15117,19343,19343,17197,21456,21391,19278,25616,21358,21358,27664,23406,25551,31792,29646,29712,21390,31825,63258,48533,54839,44307,44307,50515,39885,24965,22917,18821,20869,22917,18789,20869,16708,8452,29549,23113,33612,56919,65337,61079,61046,61079,61014,60981,56788,58901,56788,56723,58966,54773,58933,46223,48238,65272,63126,63159,63126,63159,63159,61111,18984,4258,41964,41964,52495,60915,37738,21031,25355,33774,35919,31759,29711,29712,27696,21487,15214,15181,17294,15246,15279,21520,19440,17359,17327,17327,15247,13166,15214,13133,13133,13133,15181,13133,13101,13101,21324,54737,65365,63220,255},
{50940,50940,52988,52988,52988,52988,52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55068,55068,55068,55068,55068,55068,55036,63324,63291,65372,63356,59195,65404,30037,11379,13394,13395,13427,13394,15442,15442,15442,13427,13297,13329,13394,13394,13394,11086,13265,11151,13134,15280,11086,11086,15279,11021,13166,13167,13069,13199,13134,13069,15312,15312,15312,15344,15149,15214,17327,13069,17295,19375,15117,19375,17262,17165,19407,19278,19310,23568,19278,21390,25616,21325,25551,29712,23373,27664,23471,33937,56920,50613,52758,50646,54871,52758,31434,24965,22949,22885,22885,22884,22884,24932,16708,6404,29548,33611,35659,44242,58999,39625,29191,27175,35464,49799,35269,37479,43721,48076,46191,46354,58901,44078,54577,65271,63126,65207,63126,63159,63159,58934,25290,21031,37673,35593,54543,60980,41898,37738,37902,40080,38032,33872,29744,29744,27696,21488,15214,15214,17294,15246,15279,21520,19440,17392,15311,15279,15279,13166,13166,15214,13133,13101,13101,13101,15181,13101,13101,15116,42190,65333,255},
{50940,52988,52988,52988,52988,52988,52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,55068,55068,53020,53020,53020,53020,55068,55068,55068,55068,55068,55068,55036,61211,59130,61210,61178,54937,61210,27957,13427,13394,13362,13426,13394,15442,15442,13394,13427,13394,13362,13329,15442,13394,11054,13264,13166,11054,13232,11021,13134,13199,10989,13167,13166,13069,15279,13134,13069,15312,13232,15312,15312,15149,15214,15247,13101,15247,17295,15117,19375,17230,15149,21423,19277,19310,25584,21325,25519,29712,25454,29745,31792,27599,36018,33905,35953,54839,50646,54872,52791,59065,52759,31434,24965,22949,22885,22917,22885,22885,20837,10532,6404,16968,48270,46027,41934,46257,33254,29061,27045,29223,45605,47686,45866,43818,48044,37740,27370,52627,50482,60982,65239,63127,63126,56788,63159,63159,58999,46255,41963,52397,48171,56623,58867,31464,31497,35854,40080,38033,33904,27664,25648,25648,21488,15246,15214,15246,15246,15279,19472,19440,17359,15311,15279,13231,13199,13166,13166,13133,13101,13101,13101,15181,13069,13069,13101,11021,29677,255},
{50940,52988,52988,52988,52988,52988,52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,55068,55068,53020,53020,55068,55068,55068,55068,55068,55068,55068,55036,55068,59163,57017,59098,59098,52857,59130,30005,13394,13427,15475,13427,13427,15474,13362,13394,13394,13394,13362,13329,13394,13394,11151,13297,11086,11054,11152,11021,11086,13167,10956,13167,13134,13037,15247,13101,15117,17360,19408,21521,23633,21391,23536,27697,27632,29810,31825,29712,38131,35986,35986,42325,38098,42292,48566,42259,48566,50646,46420,52759,50678,48501,56952,50678,48565,56952,46452,56984,56984,44339,48533,31499,24965,22949,18821,20901,18821,18789,12613,8485,8485,8517,46060,60525,52237,29289,29158,31109,29061,27143,47718,51846,49961,41510,43818,46061,19016,52659,58998,61013,63159,63191,58966,56886,63126,63192,44273,41959,39846,41930,37672,56591,56721,25191,27401,33806,40145,38033,31824,25616,23568,21520,19440,15247,15246,15246,13198,15279,19505,17392,15279,15311,15279,13199,13199,13166,13198,13133,13133,13133,13101,13101,13069,11053,11053,11053,11020,255},
{50940,50940,52988,52988,52988,52988,52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,55068,55068,53020,53020,55068,53020,55068,55068,55068,55068,55036,55036,55068,59163,57050,59130,59098,52889,59130,32086,9298,11346,13362,11346,11314,13394,15442,13394,15474,15475,17523,19603,19603,21651,21586,25714,23536,25616,27762,27664,31890,34003,31825,40212,40211,36018,46518,42292,42324,52824,59065,59130,61178,46420,52759,52791,48533,54904,50678,48565,56985,50646,50678,56985,48566,52759,54904,48565,54872,52791,48533,54904,52727,48565,56952,50646,50646,56952,48500,56919,54839,29581,48565,37903,29353,23014,18789,22917,22885,18854,14856,12744,12743,10631,50252,56396,48141,23275,27111,29029,29061,25095,41542,49896,47816,47914,54220,41965,21130,52627,61047,46321,44143,61078,63126,63160,63126,65240,31629,25188,50278,44009,48106,58769,52528,25191,31595,33839,40145,38065,31857,23568,23568,21488,17359,15279,13198,13133,13198,15279,19473,17392,15279,15311,15279,15247,15279,13166,13166,13101,13101,13133,13133,13101,13101,11020,11021,11021,11020,255},
{50940,50940,52988,52988,52988,52988,52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,55068,55068,53020,53020,53020,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,55036,55068,55068,44568,32118,36246,38294,40407,44535,44567,48696,50776,48696,50776,52856,48631,54937,52824,48598,56985,48566,52759,56985,50614,54872,54904,48598,56985,52759,48565,56985,50646,50679,59097,65371,65372,63323,46420,54840,52759,46485,54904,50678,48565,54904,48565,50678,54904,48565,52759,52791,48533,52791,50678,46485,52791,50646,46485,52791,48565,48533,52726,44339,48500,50645,29581,50710,40049,37903,16969,12775,12775,12743,12775,10727,12743,12743,16903,54412,52171,58510,37903,25095,31109,26981,25062,37414,45801,47849,43786,52106,43948,25356,44176,61047,40080,10565,54740,65206,63159,63127,63159,29515,14692,43975,50249,48106,60914,44109,27337,35821,33839,40145,40145,33905,25616,23568,21455,17327,15279,13134,11085,13166,13199,17424,17360,13231,15279,15279,13199,13199,11086,13166,13134,13133,13134,13134,11053,13101,11021,11021,11053,11021,255},
{50940,50940,52988,52988,52988,52988,52988,52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,55068,55068,53020,53020,53020,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55036,63356,61243,63324,61178,57017,63259,54872,56985,59065,52792,56985,52824,50679,57017,50711,50646,56985,48566,54840,56952,48533,54904,54872,48565,54904,50678,48533,54872,48533,50678,56952,61210,63259,61210,44372,52791,50678,44404,52791,48565,46453,50711,46485,46485,50678,44372,48565,50678,46453,50711,50711,46420,50646,46485,44340,50678,46452,44340,48565,42227,40113,25420,16936,38065,40081,38001,17099,14888,18984,23210,23210,21096,27370,27371,33643,54478,48141,39689,40048,27306,31109,26981,25030,35399,43721,45670,47653,51944,37609,14986,37935,63126,31596,10597,58933,65206,63159,63126,63159,48433,46088,52168,52267,43881,63028,41964,33611,37901,33839,35984,38065,31824,23568,19439,17359,17327,15279,11053,11053,13166,13199,13263,15312,13199,15279,13231,13199,13166,11086,11086,11086,11086,11086,11053,11053,13101,11021,9005,11053,8940,255},
{50940,50940,52988,52988,52988,52988,52988,52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,55068,55068,53020,53020,53020,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,61276,61243,63323,59130,57050,61210,56985,59098,59130,57049,59130,54937,54904,59098,54905,52824,54937,46518,50711,52791,46453,52791,50678,44372,50711,46485,44405,50711,44372,46485,52759,59097,59098,59097,42292,48598,46518,42292,50646,46452,44372,50711,46485,46485,50678,44340,46485,50678,46452,50679,52759,46452,48598,48565,44340,50646,48533,44372,50646,46420,35953,8615,12711,40114,33742,27599,12874,14856,23112,33644,27338,25192,35724,33611,33579,33579,25257,23242,35920,27371,31141,29061,27045,29190,41673,43622,45605,47750,29288,17392,46322,63061,31628,18984,63126,65206,63159,63127,56886,33707,50311,48037,41735,54412,63028,35690,27402,33709,31726,33840,35952,31824,23568,19407,15279,15279,15279,11085,11053,11086,13199,15312,15312,13199,13231,13231,13199,13199,13166,11086,11086,11085,11086,11053,11053,11053,8973,9005,11021,10988,255},
{50940,52988,52988,52988,52988,53020,52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,55068,55068,53020,53020,53020,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55036,55068,55036,59163,54937,57050,52889,54969,57017,50776,54937,54937,50776,54937,50744,50743,52856,48663,48631,50711,42292,48566,48598,42292,48598,46485,42259,50679,44372,44372,50711,44372,44437,50711,59097,59097,59065,42292,48598,48566,42324,50679,48533,44372,52759,48565,48566,54872,48566,48566,54871,50614,52759,54872,48565,52791,54904,50646,56952,56952,50645,54839,54838,35888,10663,10728,25519,31564,29419,35757,19049,16871,29484,25225,20967,29451,27338,31466,29418,23144,25355,35952,18985,29126,29061,31141,27175,41477,41445,43558,35366,14790,29581,58934,61013,37902,31564,65206,63158,63159,63191,48467,6371,37669,54343,43911,54477,60914,29385,23307,31661,27598,29711,33840,29712,21488,17359,15279,17327,15247,11086,11053,11086,13166,13231,15279,13199,13199,13231,13199,11150,13166,11086,11054,11053,11085,11053,11053,11053,11021,11053,11053,11020,255},
{50940,50940,52988,52988,52988,53020,52988,52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,55068,53020,52988,55068,53020,53020,55068,55068,55068,55068,55068,55068,55068,55036,55068,55068,55068,55036,57115,52857,54937,50776,54937,52889,48696,54937,52824,50776,54937,52824,52856,54937,50776,50744,52824,48566,50678,48598,46453,52759,48566,46452,52791,46485,46485,52792,46485,48598,54904,63258,61210,61210,46485,52791,52759,48565,54872,52759,48565,56952,50679,50646,56984,50678,50678,54904,48565,52759,54872,48533,50678,52759,46452,50678,50678,46420,50645,48533,25421,8647,11022,17458,27469,27208,31466,17002,18919,23243,21097,14791,23177,23112,21065,21032,18951,25290,38000,16871,29126,35205,33157,25095,41607,45736,45996,44176,33806,35854,61047,61013,29482,40015,65238,63159,63126,65240,44241,8484,31237,54150,48008,56623,56689,27337,25420,29613,27598,29679,31759,27663,19407,17327,15279,15279,15247,13134,11053,11086,11118,13199,13199,13166,13199,13199,13199,11118,11086,11086,11053,11053,11085,11053,11053,11053,11053,11053,9005,10955,255},
{50940,50940,52988,52988,52988,53020,52988,52988,52988,52988,52988,52988,52988,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,53020,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,55068,57115,54970,54970,52889,54970,54970,52922,59131,57050,57017,59130,57018,59130,61211,54872,54905,56985,50711,56985,54904,50678,56985,54840,50678,56985,50646,50646,56952,48566,50678,56952,61210,61178,61178,46452,50711,50678,44405,50711,48598,46453,52791,48598,46485,52759,46485,46485,52759,46453,46485,50678,44372,46485,50646,42259,46485,50646,42226,44339,42194,21163,14856,29680,38359,29679,29451,23340,23308,39787,41998,39917,33578,33513,33512,33513,33481,33480,31531,42226,18984,27111,33124,31076,25062,54611,63029,58867,52627,40080,46353,61047,61014,33709,52628,65206,63159,63126,63159,46354,39950,49895,47814,50120,56720,54641,33610,29613,29614,29646,29646,29646,25551,19407,17327,15279,13166,11119,11086,8973,11086,11118,13199,13199,13166,13167,13167,13199,11118,9038,9006,11053,11085,11053,11053,9005,11053,9005,9005,8973,10955,255}
};

const bool mdb_icon [306][78] = {
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,1,1,1