/*
 * Decompiled with CFR 0.152.
 */
package org.rz.midiplayer.plugin.renderer;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.image.BufferStrategy;
import java.util.logging.Level;
import org.rz.midiplayer.context.Context;
import org.rz.midiplayer.plugin.renderer.RendererPlugin;

public abstract class SimpleRenderer
implements RendererPlugin {
    private volatile boolean alive;
    private final Toolkit toolkit = Toolkit.getDefaultToolkit();
    protected final Canvas canvas = new Canvas();
    private BufferStrategy bufferStrategy;
    private Thread thread;

    @Override
    public synchronized void startRendering() {
        this.stopRendering();
        if (this.bufferStrategy == null) {
            logger.info("create a bufferStrategy...");
            try {
                this.canvas.createBufferStrategy(3);
                this.bufferStrategy = this.canvas.getBufferStrategy();
                logger.info("bufferStrategy was created...");
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "failed to create bufferStrategy instance.", e);
            }
        }
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                SimpleRenderer.this.mainLoop();
            }
        });
        this.thread.start();
    }

    @Override
    public void stopRendering() {
        if (this.thread != null && this.thread.isAlive()) {
            try {
                this.alive = false;
                this.thread.join();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.thread = null;
        }
    }

    private void mainLoop() {
        long period = 16666666L;
        long sleepDiffTime = 0L;
        boolean except = false;
        long before = System.nanoTime();
        this.alive = true;
        while (this.alive) {
            try {
                this.update();
                this.render();
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Renderer ERROR", e);
                except = true;
                break;
            }
            long after = System.nanoTime();
            long diffTime = after - before;
            long sleepTime = period - diffTime - sleepDiffTime;
            if (sleepTime > 0L) {
                try {
                    Thread.sleep(sleepTime / 1000000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                sleepDiffTime = System.nanoTime() - after - sleepTime;
            } else {
                sleepDiffTime = 0L;
            }
            before = System.nanoTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void render() {
        BufferStrategy b = this.bufferStrategy;
        if (b != null) {
            Graphics2D g = (Graphics2D)b.getDrawGraphics();
            try {
                if (!b.contentsLost()) {
                    this.draw(g);
                    b.show();
                    this.toolkit.sync();
                }
            }
            finally {
                g.dispose();
            }
        }
    }

    @Override
    public Component getComponent() {
        return this.canvas;
    }

    @Override
    public synchronized void onDispose(Context ctx) {
        this.bufferStrategy.dispose();
        this.bufferStrategy = null;
    }

    protected abstract void update();

    protected abstract void draw(Graphics2D var1);
}

