//******************************************************************************
//
// Simple MIDI Library / SMEventMIDI
//
// MIDICxgNX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// MEMO:
// CxgNXh݌vzAnew̎{񐔂
// ߁AX^bNŏłf[^̓[eBeBNXƂĎB

#pragma once

#ifdef SMIDILIB_EXPORTS
#define SMIDILIB_API __declspec(dllexport)
#else
#define SMIDILIB_API __declspec(dllimport)
#endif

#include "SMEvent.h"


namespace SMIDILib {

//******************************************************************************
// MIDICxgNX
//******************************************************************************
class SMIDILIB_API SMEventMIDI
{
public:

	//`lbZ[W
	enum ChMsg {
		None					= 0x00, // none
		NoteOff					= 0x80, // 8n kk vv
		NoteOn					= 0x90, // 9n kk vv
		PolyphonicKeyPressure	= 0xA0, // An kk vv
		ControlChange			= 0xB0, // Bn cc vv
		ProgramChange			= 0xC0, // Cn pp   
		ChannelPressure			= 0xD0, // Dn vv   
		PitchBend				= 0xE0  // En mm ll
	};

public:

	//RXgN^^fXgN^
	SMEventMIDI();
	virtual ~SMEventMIDI(void);

	//CxgA^b`
	void Attach(SMEvent* pEvent);

	//MIDIo̓bZ[W擾
	int GetMIDIOutShortMsg(unsigned long* pMsg);

	//`lbZ[W
	ChMsg GetChMsg();

	//`lԍ擾
	unsigned char GetChNo();

	//m[gԍ擾
	unsigned char GetNoteNo();

	//xVeB擾
	unsigned char GetVelocity();

	//Rg[`FWԍ擾
	unsigned char GetCCNo();

	//Rg[`FWl擾
	unsigned char GetCCValue();

	//vOԍ擾
	unsigned char GetProgramNo();

	//`lvbV[l擾
	unsigned char GetPressureValue();

	//sb`xhl擾
	short GetPichBendValue();

private:

	SMEvent* m_pEvent;

	//ƃRs[RXgN^̋֎~
	void operator=(const SMEventMIDI&);
	SMEventMIDI(const SMEventMIDI&);

};

} // end of namespace

