//******************************************************************************
//
// MIDITrail / MTNoteBox
//
// m[g{bNX`NX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "MTNoteBox.h"

using namespace YNBaseLib;


//******************************************************************************
// p[^`
//******************************************************************************
//1m[g̒_ = 1`4_ * 6 
#define NOTE_VERTEX_NUM  (4 * 6)

//1m[g̃CfbNX = 1Op`3_ * 2 * 6
#define NOTE_INDEX_NUM   (3 * 2 * 6)

//******************************************************************************
// RXgN^
//******************************************************************************
MTNoteBox::MTNoteBox(void)
{
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTNoteBox::~MTNoteBox(void)
{
	Release();
}

//******************************************************************************
// m[g{bNX
//******************************************************************************
int MTNoteBox::Create(
		LPDIRECT3DDEVICE9 pD3DDevice,
		SMSeqData* pSeqData
   )
{
	int result = 0;
	SMTrack track;
	unsigned long vertexNum = 0;
	unsigned long indexNum = 0;
	MTNOTEBOX_VERTEX* pVertex = NULL;
	unsigned long* pIndex = NULL;
	unsigned long i = 0;
	D3DMATERIAL9 material;

	Release();

	if (pSeqData == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	//m[gfUCIuWFNg
	result = m_NoteDesign.Initialize(pSeqData);
	if (result != 0) goto EXIT;

	//gbN擾
	result = pSeqData->GetMergedTrack(&track);
	if (result != 0) goto EXIT;

	//m[gXg擾
	result = track.GetNoteList(&m_NoteList);
	if (result != 0) goto EXIT;

	//v~eBu
	result = m_Primitive.Initialize(
					sizeof(MTNOTEBOX_VERTEX),	//_TCY
					_GetFVFFormat(),			//_FVFtH[}bg
					D3DPT_TRIANGLELIST			//v~eBu
				);
	if (result != 0) goto EXIT;

	//_obt@
	vertexNum = NOTE_VERTEX_NUM * m_NoteList.GetSize();
	result = m_Primitive.CreateVertexBuffer(pD3DDevice, vertexNum);
	if (result != 0) goto EXIT;

	//CfbNXobt@
	indexNum = NOTE_INDEX_NUM * m_NoteList.GetSize();
	result = m_Primitive.CreateIndexBuffer(pD3DDevice, indexNum);
	if (result != 0) goto EXIT;

	//obt@̃bN
	result = m_Primitive.LockVertex((void**)&pVertex);
	if (result != 0) goto EXIT;
	result = m_Primitive.LockIndex(&pIndex);
	if (result != 0) goto EXIT;

	//obt@ɒ_ƃCfbNX
	for (i = 0; i < m_NoteList.GetSize(); i++) {
		SMNote note;
		result = m_NoteList.GetNote(i, &note);
		if (result != 0) goto EXIT;

		result = _CreateVertexOfNote(
						note,								//m[g
						&(pVertex[NOTE_VERTEX_NUM * i]),	//_obt@݈ʒu
						NOTE_VERTEX_NUM * i,				//_obt@CfbNXItZbg
						&(pIndex[NOTE_INDEX_NUM * i])		//CfbNXobt@݈ʒu
					);
		if (result != 0) goto EXIT;
	}

	//obt@̃bN
	result = m_Primitive.UnlockVertex();
	if (result != 0) goto EXIT;
	result = m_Primitive.UnlockIndex();
	if (result != 0) goto EXIT;

	//}eA쐬
	_MakeMaterial(&material);
	m_Primitive.SetMaterial(material);

EXIT:;
	return result;
}

//******************************************************************************
// ړ
//******************************************************************************
int MTNoteBox::Transform(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	D3DXMATRIX worldMatrix;

	//ړȂ
	D3DXMatrixIdentity(&worldMatrix);
	m_Primitive.Transform(worldMatrix);

	return result;
}

//******************************************************************************
// `
//******************************************************************************
int MTNoteBox::Draw(
		LPDIRECT3DDEVICE9 pD3DDevice
   )
{
	int result = 0;

	result = m_Primitive.Draw(pD3DDevice);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// 
//******************************************************************************
void MTNoteBox::Release()
{
	m_Primitive.Release();
	m_NoteList.Clear();
}

//******************************************************************************
// m[g{bNX̒_
//******************************************************************************
int MTNoteBox::_CreateVertexOfNote(
		SMNote note,
		MTNOTEBOX_VERTEX* pVertex,
		unsigned long vertexOffset,
		unsigned long* pIndex
	)
{
	int result = 0;
	unsigned long i;
	D3DXVECTOR3 vectorStartLU;
	D3DXVECTOR3 vectorStartRU;
	D3DXVECTOR3 vectorStartLD;
	D3DXVECTOR3 vectorStartRD;
	D3DXVECTOR3 vectorEndLU;
	D3DXVECTOR3 vectorEndRU;
	D3DXVECTOR3 vectorEndLD;
	D3DXVECTOR3 vectorEndRD;

	//     +   1+----+3   +
	//    /|   /  /    /|         y x
	//   + | 0+----+2   + |E       |/
	// | +   7+----+5 | +      z--+0
	//   |/    /  /   |/
	//   +   6+----+4   +  4 _(0,0,0)
	//

	//m[g{bNX_W擾
	m_NoteDesign.GetNoteBoxVirtexPos(
			note.startTime,
			note.portNo,
			note.chNo,
			note.noteNo,
			&vectorStartLU,
			&vectorStartRU,
			&vectorStartLD,
			&vectorStartRD
		);
	m_NoteDesign.GetNoteBoxVirtexPos(
			note.endTime,
			note.portNo,
			note.chNo,
			note.noteNo,
			&vectorEndLU,
			&vectorEndRU,
			&vectorEndLD,
			&vectorEndRD
		);

	//_WEEE@قȂ̂Œ_8ɏWłȂ
	//̖
	pVertex[0].p = vectorStartLU;
	pVertex[1].p = vectorEndLU;
	pVertex[2].p = vectorStartRU;
	pVertex[3].p = vectorEndRU;
	//̖
	pVertex[4].p = vectorStartRD;
	pVertex[5].p = vectorEndRD;
	pVertex[6].p = vectorStartLD;
	pVertex[7].p = vectorEndLD;
	//E̖
	pVertex[8].p  = pVertex[2].p;
	pVertex[9].p  = pVertex[3].p;
	pVertex[10].p = pVertex[4].p;
	pVertex[11].p = pVertex[5].p;
	//̖
	pVertex[12].p = pVertex[6].p;
	pVertex[13].p = pVertex[7].p;
	pVertex[14].p = pVertex[0].p;
	pVertex[15].p = pVertex[1].p;
	//O̖
	pVertex[16].p = pVertex[0].p;
	pVertex[17].p = pVertex[2].p;
	pVertex[18].p = pVertex[6].p;
	pVertex[19].p = pVertex[4].p;
	//̖
	pVertex[20].p = pVertex[3].p;
	pVertex[21].p = pVertex[1].p;
	pVertex[22].p = pVertex[5].p;
	pVertex[23].p = pVertex[7].p;

	//@
	//̖
	pVertex[0].n = D3DXVECTOR3( 0.0f, 1.0f, 0.0f);
	pVertex[1].n = D3DXVECTOR3( 0.0f, 1.0f, 0.0f);
	pVertex[2].n = D3DXVECTOR3( 0.0f, 1.0f, 0.0f);
	pVertex[3].n = D3DXVECTOR3( 0.0f, 1.0f, 0.0f);
	//̖
	pVertex[4].n = D3DXVECTOR3( 0.0f,-1.0f, 0.0f);
	pVertex[5].n = D3DXVECTOR3( 0.0f,-1.0f, 0.0f);
	pVertex[6].n = D3DXVECTOR3( 0.0f,-1.0f, 0.0f);
	pVertex[7].n = D3DXVECTOR3( 0.0f,-1.0f, 0.0f);
	//E̖
	pVertex[8].n  = D3DXVECTOR3( 0.0f, 0.0f,-1.0f);
	pVertex[9].n  = D3DXVECTOR3( 0.0f, 0.0f,-1.0f);
	pVertex[10].n = D3DXVECTOR3( 0.0f, 0.0f,-1.0f);
	pVertex[11].n = D3DXVECTOR3( 0.0f, 0.0f,-1.0f);
	//̖
	pVertex[12].n = D3DXVECTOR3( 0.0f, 0.0f, 1.0f);
	pVertex[13].n = D3DXVECTOR3( 0.0f, 0.0f, 1.0f);
	pVertex[14].n = D3DXVECTOR3( 0.0f, 0.0f, 1.0f);
	pVertex[15].n = D3DXVECTOR3( 0.0f, 0.0f, 1.0f);
	//O̖
	pVertex[16].n = D3DXVECTOR3(-1.0f, 0.0f, 0.0f);
	pVertex[17].n = D3DXVECTOR3(-1.0f, 0.0f, 0.0f);
	pVertex[18].n = D3DXVECTOR3(-1.0f, 0.0f, 0.0f);
	pVertex[19].n = D3DXVECTOR3(-1.0f, 0.0f, 0.0f);
	//̖
	pVertex[20].n = D3DXVECTOR3( 1.0f, 0.0f, 0.0f);
	pVertex[21].n = D3DXVECTOR3( 1.0f, 0.0f, 0.0f);
	pVertex[22].n = D3DXVECTOR3( 1.0f, 0.0f, 0.0f);
	pVertex[23].n = D3DXVECTOR3( 1.0f, 0.0f, 0.0f);

	//e_̃fBt[YF
	for (i = 0; i < NOTE_VERTEX_NUM; i++) {
		pVertex[i].c = m_NoteDesign.GetNoteBoxColor(note.portNo, note.chNo, note.noteNo);
	}

	//CfbNXFDrawIndexdPrimitiveĂяo1ōςނ悤TRIANGLELISTƂ
	unsigned long index[NOTE_INDEX_NUM] = {
		//TRIANGLE-1   TRIANGLE-2
		 0,  1,  2,     2,  1,  3,	//
		 4,  5,  6,     6,  5,  7,	//
		 8,  9, 10,    10,  9, 11,	//E
		12, 13, 14,    14, 13, 15,	//
		16, 17, 18,    18, 17, 19,	//O
		20, 21, 22,    22, 21, 23,	//
	};
	for (i = 0; i < NOTE_INDEX_NUM; i++) {
		pIndex[i] = vertexOffset + index[i];
	}

	return result;
}

//******************************************************************************
// }eA쐬
//******************************************************************************
void MTNoteBox::_MakeMaterial(
		D3DMATERIAL9* pMaterial
	)
{
	ZeroMemory(pMaterial, sizeof(D3DMATERIAL9));
	
	//gU
	pMaterial->Diffuse.r = 1.0f;
	pMaterial->Diffuse.g = 1.0f;
	pMaterial->Diffuse.b = 1.0f;
	pMaterial->Diffuse.a = 1.0f;
	//Fe̐F
	pMaterial->Ambient.r = 0.5f;
	pMaterial->Ambient.g = 0.5f;
	pMaterial->Ambient.b = 0.5f;
	pMaterial->Ambient.a = 1.0f;
	//ʔˌ
	pMaterial->Specular.r = 0.2f;
	pMaterial->Specular.g = 0.2f;
	pMaterial->Specular.b = 0.2f;
	pMaterial->Specular.a = 1.0f;
	//ʔˌ̑Nx
	pMaterial->Power = 40.0f;
	//F
	pMaterial->Emissive.r = 0.0f;
	pMaterial->Emissive.g = 0.0f;
	pMaterial->Emissive.b = 0.0f;
	pMaterial->Emissive.a = 0.0f;
}

