//******************************************************************************
//
// MIDITrail / MTNoteDesign
//
// m[gfUCNX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// MEMO:
// m[g{bNX̐ʂ0-1-2-3̎lpƂB
// ̎lp̒SW_łA|[g^`l^m[g̔ԍ
// ɂČ肳B
//
//           +--+
//          /  /|
//         /  / +
//        /  / /      +x
//       /  / /      /
//     0+--+1/ +y   /
//      |  |/   |  /
//     2+--+3   | /
//              |/
//   +z---------+0
//

#pragma once

#include <d3d9.h>
#include <d3dx9.h>
#include "SMIDILib.h"

using namespace YNBaseLib;
using namespace SMIDILib;


//******************************************************************************
// m[gfUCNX
//******************************************************************************
class MTNoteDesign
{
public:

	//RXgN^^fXgN^
	MTNoteDesign(void);
	virtual ~MTNoteDesign(void);

	//
	int Initialize(SMSeqData* pSeqData);

	//tʒu擾
	float GetPlayPosX(unsigned long curTickTime);

	//m[g{bNXSW擾
	D3DXVECTOR3 GetNoteBoxCenterPosX(
				unsigned long curTickTime,
				unsigned char portNo,
				unsigned char chNo,
				unsigned char noteNo
			);

	//m[g{bNXcTCY擾
	float GetNoteBoxHeight();
	float GetNoteBoxWidht();

	//m[gԊu擾
	float GetNoteStep();

	//`lԊu擾
	float GetChStep();

	//m[g{bNX_W擾
	void GetNoteBoxVirtexPos(
				unsigned long curTickTime,
				unsigned char portNo,
				unsigned char chNo,
				unsigned char noteNo,
				D3DXVECTOR3* pVector0,	//YZ+Xč
				D3DXVECTOR3* pVector1,	//YZ+XĉE
				D3DXVECTOR3* pVector2,	//YZ+Xč
				D3DXVECTOR3* pVector3	//YZ+XĉE
			);

	//Obh{bNX_W擾
	void GetGridBoxVirtexPos(
				unsigned long curTickTime,
				unsigned char portNo,
				D3DXVECTOR3* pVector0,	//YZ+Xč
				D3DXVECTOR3* pVector1,	//YZ+XĉE
				D3DXVECTOR3* pVector2,	//YZ+Xč
				D3DXVECTOR3* pVector3 	//YZ+XĉE
			);

	//Đʒ_W擾
	void GetPlaybackSectionVirtexPos(
				unsigned long curTickTime,
				D3DXVECTOR3* pVector0,	//YZ+Xč
				D3DXVECTOR3* pVector1,	//YZ+XĉE
				D3DXVECTOR3* pVector2,	//YZ+Xč
				D3DXVECTOR3* pVector3 	//YZ+XĉE
			);

	//gTCY擾
	float GetRippleHeight();
	float GetRippleWidth();

	//sN`{[hΈʒu擾
	float GetPictBoardRelativePos();

	//|[g_ZW擾
	float GetPortOriginZ(unsigned char portNo);

	//m[g{bNXJ[擾
	D3DXCOLOR GetNoteBoxColor(
				unsigned char portNo,
				unsigned char chNo,
				unsigned char noteNo
			);

	//ObhCJ[擾
	D3DXCOLOR GetGridLineColor();

	//ĐʃJ[擾
	D3DXCOLOR GetPlaybackSectionColor();

private:

	unsigned long m_TimeDivision;
	float m_QuarterNoteLength;
	float m_NoteBoxHeight;
	float m_NoteBoxWidth;
	float m_NoteStep;
	float m_ChStep;
	float m_RippleHeight;
	float m_RippleWidth;
	float m_PictBoardRelativePos;
	SMPortList m_PortList;
	unsigned char m_PortIndex[256];

	D3DXCOLOR m_NoteColor[16];
	D3DXCOLOR m_GridLineColor;
	D3DXCOLOR m_PlaybackSectionColor;

	void _Clear();
	int _LoadConfFile();
	D3DXCOLOR _MakeColorFromHexRGBA(TCHAR* pHexRGB);

};


