//******************************************************************************
//
// Simple MIDI Library / SMTrack
//
// gbNNX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// MEMO:
// SysEXCxgƃ^Cxg͉ϒTCŶ߁APXgNX
// ̂܂ܗpłȂB̃CxǵAK4byteɎ܂MIDI
// CxgɔׂĈ|IɏȂ̂ŁAXnew邱ƂeFA
// mapŊǗB
//
// TODO:
// SMEventNXɃf^^Cƃ|[gԍׂB
// Cxg^f^^C^|[gԍ𕪗Ă邽߁A
// SMTrackNXp҂̏ώGɂȂĂB

#pragma once

#ifdef SMIDILIB_EXPORTS
#define SMIDILIB_API __declspec(dllexport)
#else
#define SMIDILIB_API __declspec(dllimport)
#endif

#include "SMSimpleList.h"
#include "SMEvent.h"
#include "SMNoteList.h"
#include <map>

#pragma warning(disable:4251)

namespace SMIDILib {


//******************************************************************************
// gbNNX
//******************************************************************************
class SMIDILIB_API SMTrack
{

public:

	//RXgN^^fXgN^
	SMTrack(void);
	virtual ~SMTrack(void);

	//NA
	void Clear();

	//f[^Zbgo^
	int AddDataSet(unsigned long deltaTime, SMEvent* pEvent, unsigned char portNo);

	//f[^Zbg擾
	int GetDataSet(unsigned long index, unsigned long* pDeltaTime, SMEvent* pEvent, unsigned char* pPortNo);

	//f[^Zbg擾
	unsigned long GetSize();

	//m[gXg擾
	int GetNoteList(SMNoteList* pNoteList);

	//Rs[
	int CopyFrom(SMTrack* pSrcTrack);

private:

	//Cxgf[^
	typedef struct {
		SMEvent::EventType type;
		unsigned char status;
		unsigned char meta;
		unsigned long size;
		unsigned char data[4];
	} SMEventData;

	//f[^Zbg
	typedef struct {
		unsigned long deltaTime;
		SMEventData eventData;
		unsigned char portNo;
	} SMDataSet;

	//gf[^}bvFCfbNXf[^ʒu
	typedef std::map<unsigned long, unsigned char*> SMExDataMap;
	typedef std::pair<unsigned long, unsigned char*> SMExDataMapPair;

	//m[g}bvFm[gL[m[g
	typedef std::map<unsigned long, SMNote> SMNoteMap;
	typedef std::pair<unsigned long, SMNote> SMNoteMapPair;

private:

	SMSimpleList m_List;
	SMExDataMap m_ExDataMap;

	unsigned long _GetNoteKey(unsigned char portNo, unsigned char chNo, unsigned char noteNo);

	//ƃRs[RXgN^̋֎~
	void operator=(const SMTrack&);
	SMTrack(const SMTrack&);

};

} // end of namespace

#pragma warning(default:4251)

