//******************************************************************************
//
// MIDITrail / MTNoteBox
//
// m[g{bNX`NX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// MEMO:
// m[g{bNX`悷B

#pragma once

#include <d3d9.h>
#include <d3dx9.h>
#include "SMIDILib.h"
#include "DXPrimitive.h"
#include "MTNoteDesign.h"
#include "MTNotePitchBend.h"

using namespace SMIDILib;


//******************************************************************************
// p[^`
//******************************************************************************
//őg`搔
#define MTNOTEBOX_MAX_ACTIVENOTE_NUM  (100)

//******************************************************************************
// m[g{bNX`NX
//******************************************************************************
class MTNoteBox
{
public:

	//RXgN^^fXgN^
	MTNoteBox(void);
	virtual ~MTNoteBox(void);

	//
	int Create(
			LPDIRECT3DDEVICE9 pD3DDevice,
			const TCHAR* pSceneName,
			SMSeqData* pSeqData,
			MTNotePitchBend* pNotePitchBend
		);

	//XV
	int Transform(LPDIRECT3DDEVICE9 pD3DDevice);

	//`
	int Draw(LPDIRECT3DDEVICE9 pD3DDevice);

	//
	void Release();

	//t`bN^Co^
	void SetCurTickTime(unsigned long curTickTime);

	//Zbg
	void Reset();

private:

	//m[g\
	struct NoteStatus {
		bool isActive;
		bool isHide;
		unsigned long index;
		unsigned long startTime;
	};

	//_obt@\
	struct MTNOTEBOX_VERTEX {
		D3DXVECTOR3 p;	//_W
		D3DXVECTOR3 n;	//@
		DWORD		c;	//fBt[YF
	};

private:

	//m[gfUC
	MTNoteDesign m_NoteDesign;

	//m[gXg
	SMNoteList m_NoteList;

	//Sm[g{bNX
	DXPrimitive m_PrimitiveAllNotes;

	//m[g{bNX
	DXPrimitive m_PrimitiveActiveNotes;
	unsigned long m_CurTickTime;
	unsigned long m_CurNoteIndex;
	unsigned long m_ActiveNoteNum;
	NoteStatus m_NoteStatus[MTNOTEBOX_MAX_ACTIVENOTE_NUM];

	//sb`xh
	MTNotePitchBend* m_pNotePitchBend;

	//_obt@FVFtH[}bg
	DWORD _GetFVFFormat(){ return (D3DFVF_XYZ | D3DFVF_NORMAL | D3DFVF_DIFFUSE); }

	int _CreateAllNoteBox(LPDIRECT3DDEVICE9 pD3DDevice);
	int _CreateActiveNoteBox(LPDIRECT3DDEVICE9 pD3DDevice);

	int _CreateVertexOfNote(
			SMNote note,
			MTNOTEBOX_VERTEX* pVertex,
			unsigned long vertexOffset,
			unsigned long* pIbIndex,
			unsigned long elapsedTime = 0xFFFFFFFF,
			bool isEnablePitchBend = false
		);
	unsigned long _GetVertexIndexOfNote(unsigned long index);

	void _MakeMaterial(D3DMATERIAL9* pMaterial);
	void _MakeMaterialForActiveNote(D3DMATERIAL9* pMaterial);

	int _TransformActiveNotes(LPDIRECT3DDEVICE9 pD3DDevice);
	int _UpdateStatusOfActiveNotes(LPDIRECT3DDEVICE9 pD3DDevice);
	int _UpdateVertexOfActiveNotes(LPDIRECT3DDEVICE9 pD3DDevice);

	int _HideNoteBox(unsigned long index);
	int _ShowNoteBox(unsigned long index);

};


