//******************************************************************************
//
// MIDITrail / MTStars
//
// `NX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "MTParam.h"
#include "MTStars.h"

using namespace YNBaseLib;


//******************************************************************************
// RXgN^
//******************************************************************************
MTStars::MTStars(void)
{
	m_pTexture = NULL;
	m_NumOfStars = 2000;
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTStars::~MTStars(void)
{
	Release();
}

//******************************************************************************
// 
//******************************************************************************
int MTStars::Create(
		LPDIRECT3DDEVICE9 pD3DDevice,
		const TCHAR* pSceneName
	)
{
	int result = 0;
	HRESULT hresult = D3D_OK;
	MTSTARS_VERTEX* pVertex = NULL;
	D3DMATERIAL9 material;

	Release();

	if (pD3DDevice == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	//p[^ݒt@Cǂݍ
	result = _LoadConfFile(pSceneName);
	if (result != 0) goto EXIT;

	//v~eBu
	result = m_Primitive.Initialize(
					sizeof(MTSTARS_VERTEX),	//_TCY
					_GetFVFFormat(),		//_FVFtH[}bg
					D3DPT_POINTLIST			//v~eBu
				);
	if (result != 0) goto EXIT;

	//_obt@
	result = m_Primitive.CreateVertexBuffer(pD3DDevice, m_NumOfStars);
	if (result != 0) goto EXIT;

	//obt@̃bN
	result = m_Primitive.LockVertex((void**)&pVertex);
	if (result != 0) goto EXIT;

	//obt@ɒ_
	result = _CreateVertexOfStars(pVertex);
	if (result != 0) goto EXIT;

	//obt@̃bN
	result = m_Primitive.UnlockVertex();
	if (result != 0) goto EXIT;

	//}eA쐬
	_MakeMaterial(&material);
	m_Primitive.SetMaterial(material);

EXIT:;
	return result;
}

//******************************************************************************
// ړ
//******************************************************************************
int MTStars::Transform(
		LPDIRECT3DDEVICE9 pD3DDevice,
		D3DXVECTOR3 camVector
	)
{
	int result = 0;
	D3DXMATRIX worldMatrix;
	
	//E͔̐ɉɑ݂̂
	//ςɃJړĂ͓Ȃ悤Ɍ
	//[IɍČ邽߃Jɍ킹Đړ
	D3DXMatrixIdentity(&worldMatrix);
	D3DXMatrixTranslation(&worldMatrix, camVector.x, camVector.y, camVector.z);
	m_Primitive.Transform(worldMatrix);
	
	return result;
}

//******************************************************************************
// `
//******************************************************************************
int MTStars::Draw(
		LPDIRECT3DDEVICE9 pD3DDevice
   )
{
	int result = 0;

	result = m_Primitive.Draw(pD3DDevice, m_pTexture);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// 
//******************************************************************************
void MTStars::Release()
{
	m_Primitive.Release();
	
	if (m_pTexture != NULL) {
		m_pTexture->Release();
		m_pTexture = NULL;
	}
}

//******************************************************************************
// _
//******************************************************************************
int MTStars::_CreateVertexOfStars(
		MTSTARS_VERTEX* pVertex
	)
{
	int result = 0;
	float r = 0.0f;
	float phi = 0.0f;
	//float theta = 0.0f;
	float x, y, z = 0.0f;
	float cr, cg, cb = 0.0f;
	int i = 0;

	//_W
	for (i = 0; i < m_NumOfStars; i++) {

		//ɍW(theta,phi)ɗKpƖkɂƓɂŐ̕zxȂĂ܂
		//
		//ɍWFʏɐzu
		//r     = 500.0f;
		//phi   = ((float)rand() / RAND_MAX) * 360.0f;
		//theta = ((float)rand() / RAND_MAX) * 180.0f;
		//sWɕϊ
		//x = r * sin(D3DXToRadian(theta)) * cos(D3DXToRadian(phi));
		//y = r * cos(D3DXToRadian(theta));
		//z = r * sin(D3DXToRadian(theta)) * sin(D3DXToRadian(phi));

		//ʏɐlz邽(y, phi)ɗKp
		r   = 500.0f;
		phi = ((float)rand() / RAND_MAX) * 2.0f * 3.1415926f;
		y   = ((float)rand() / RAND_MAX) * 2.0f * r - r;
		x = sqrt((r * r) - (y * y)) * cos(phi);
		z = sqrt((r * r) - (y * y)) * sin(phi);

		//F
		cr = ((float)rand() / RAND_MAX);
		cg = cr;
		cb = cr;
		//cg = ((float)rand() / RAND_MAX);
		//cb = ((float)rand() / RAND_MAX);

		//_W
		pVertex[i].p = D3DXVECTOR3(x, y, z);
		//@
		pVertex[i].n = D3DXVECTOR3(0.0f, 0.0f, -1.0f);
		//fBt[YF
		pVertex[i].c = D3DXCOLOR(cr, cg, cb, 1.0f);
	}

	return result;
}

//******************************************************************************
// }eA쐬
//******************************************************************************
void MTStars::_MakeMaterial(
		D3DMATERIAL9* pMaterial
	)
{
	ZeroMemory(pMaterial, sizeof(D3DMATERIAL9));

	//gU
	pMaterial->Diffuse.r = 1.0f;
	pMaterial->Diffuse.g = 1.0f;
	pMaterial->Diffuse.b = 1.0f;
	pMaterial->Diffuse.a = 1.0f;
	//Fe̐F
	pMaterial->Ambient.r = 0.5f;
	pMaterial->Ambient.g = 0.5f;
	pMaterial->Ambient.b = 0.5f;
	pMaterial->Ambient.a = 1.0f;
	//ʔˌ
	pMaterial->Specular.r = 0.2f;
	pMaterial->Specular.g = 0.2f;
	pMaterial->Specular.b = 0.2f;
	pMaterial->Specular.a = 1.0f;
	//ʔˌ̑Nx
	pMaterial->Power = 100.0f;
	//F
	pMaterial->Emissive.r = 0.0f;
	pMaterial->Emissive.g = 0.0f;
	pMaterial->Emissive.b = 0.0f;
	pMaterial->Emissive.a = 0.0f;
}

//******************************************************************************
// ݒt@Cǂݍ
//******************************************************************************
int MTStars::_LoadConfFile(
		const TCHAR* pSceneName
	)
{
	int result = 0;
	TCHAR confFilePath[_MAX_PATH] = {_T('\0')};
	YNConfFile confFile;

	//vZXst@CfBNgpX擾
	result = YNPathUtil::GetModuleDirPath(confFilePath, _MAX_PATH);
	if (result != 0) goto EXIT;

	//ݒt@CpXo^
	_tcscat_s(confFilePath, _MAX_PATH, MT_CONFFILE_DIR);
	_tcscat_s(confFilePath, _MAX_PATH, pSceneName);
	_tcscat_s(confFilePath, _MAX_PATH, _T(".ini"));
	result = confFile.Initialize(confFilePath);
	if (result != 0) goto EXIT;

	//̐
	result = confFile.SetCurSection(_T("Stars"));
	if (result != 0) goto EXIT;
	result = confFile.GetInt(_T("NumberOfStars"), &m_NumOfStars, 2000);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}


