//******************************************************************************
//
// MIDITrail / MIDITrailApp
//
// MIDITrail AvP[VNX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "imagehlp.h"
#include "shellapi.h"
#include "YNBaseLib.h"
#include "MTParam.h"
#include "MIDITrailApp.h"
#include "MTSceneTitle.h"
#include "MTScenePianoRoll3D.h"
#include "MTScenePianoRoll2D.h"

using namespace YNBaseLib;


//******************************************************************************
// EBhEvV[Wpp[^ݒ
//******************************************************************************
MIDITrailApp* MIDITrailApp::m_pThis = NULL;

//******************************************************************************
// RXgN^
//******************************************************************************
MIDITrailApp::MIDITrailApp(void)
{
	m_pThis = this;
	m_hInstance = NULL;

	//EBhEn
	m_hWnd = NULL;
	m_Accel = NULL;
	m_Title[0] = _T('\0');
	m_WndClassName[0] = _T('\0');

	//_On
	m_pScene = NULL;

	//FPS\n
	m_PrevTime = 0;
	m_FPSCount = 0;

	//t
	m_PlayStatus = NoData;
	m_isRepeat = false;
	m_isRewind = false;
	ZeroMemory(&m_SequencerLastMsg, sizeof(MTSequencerLastMsg));

	//\
	m_isEnablePianoKeyboard = true;
	m_isEnableRipple = true;
	m_isEnablePitchBend = true;

	//V[
	m_SceneType = Title;
	m_SelectedSceneType = PianoRoll3D;
}

//******************************************************************************
// fXgN^
//******************************************************************************
MIDITrailApp::~MIDITrailApp(void)
{
	Terminate();
}

//******************************************************************************
// 
//******************************************************************************
int MIDITrailApp::Initialize(
		HINSTANCE hInstance,
		LPTSTR pCmdLine,
		int nCmdShow
	)
{
	int result = 0;

	m_hInstance = hInstance;

	//񏉊
	LoadString(hInstance, IDS_APP_TITLE, m_Title, MAX_LOADSTRING);
	LoadString(hInstance, IDC_MIDITRAIL, m_WndClassName, MAX_LOADSTRING);

	//ݒt@C
	result = _InitConfFile();
	if (result != 0) goto EXIT;

	//EBhENXo^
	result = _RegisterClass(hInstance);
	if (result != 0) goto EXIT;

	//CEBhE
	result = _CreateWindow(hInstance, nCmdShow);
	if (result != 0) goto EXIT;

	//ANZ[^e[uǂݍ
	m_Accel = LoadAccelerators(hInstance, MAKEINTRESOURCE(IDC_MIDITRAIL));
	if (m_Accel == NULL) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), (DWORD)hInstance);
		goto EXIT;
	}

	//tԕύX
	result = _ChangePlayStatus(NoData);
	if (result != 0) goto EXIT;

	//_
	result = m_Renderer.Initialize(m_hWnd);
	if (result != 0) goto EXIT;

	//V[IuWFNg
	m_SceneType = Title;
	result = _CreateScene(m_SceneType, &m_SeqData);
	if (result != 0) goto EXIT;

	//V[ʓǂݍ
	result = _LoadSceneType();
	if (result != 0) goto EXIT;

	//j[I}[NXV
	result = _UpdateMenuCheckmark();
	if (result != 0) goto EXIT;

	//RCPt@CRo[^
	result = m_RcpConv.Initialize();
	if (result != 0) goto EXIT;

	//R}hC͂Ǝs
	result = _ParseCmdLine(pCmdLine);
	if (result != 0) goto EXIT;

	//^C}[Jn
	result = _StartTimer();
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// I
//******************************************************************************
int MIDITrailApp::Terminate()
{
	int result = 0;

	_StopTimer();

	m_Renderer.Terminate();

	if (m_pScene != NULL) {
		m_pScene->Release();
		delete m_pScene;
		m_pScene = NULL;
	}

	return result;
}

//******************************************************************************
// s
//******************************************************************************
int MIDITrailApp::Run()
{
	int result = 0;
	int quitCode = 0;
	BOOL isExist = FALSE;
	MSG msg;
	WINDOWPLACEMENT wndpl;

	m_PrevTime = timeGetTime();

	//bZ[W[v
	while (TRUE) {
		isExist = PeekMessage(
						&msg,		//擾bZ[W
						NULL,		//擾EBhEnh
						0,			//擾ΏۃbZ[Wŏl
						0,			//擾ΏۃbZ[Wől
						PM_REMOVE	//bZ[W@FL[폜
					);
		if (isExist) {
			if (msg.message == WM_QUIT) {
				quitCode = msg.wParam;
				break;
			}
			else {
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
		}
		else if (m_pScene != NULL) {
			//EBhE\Ԃł̂ݕ`s
			GetWindowPlacement(m_hWnd, &wndpl);
			if ((wndpl.showCmd != SW_HIDE) &&
				(wndpl.showCmd != SW_MINIMIZE) &&
				(wndpl.showCmd != SW_SHOWMINIMIZED) &&
				(wndpl.showCmd != SW_SHOWMINNOACTIVE)) {
				//`
				result = m_Renderer.RenderScene(m_pScene);
				if (result != 0) {
					if (result == DXRENDERER_ERR_DEVICE_LOST) {
						//foCXXg
						//bI΍ƂăV[Đ
						result = _RebuildScene();
						if (result != 0) {
							YN_SHOW_ERR(m_hWnd);
							PostMessage(m_hWnd, WM_DESTROY, 0, 0);
						}
					}
					else {
						YN_SHOW_ERR(m_hWnd);
						PostMessage(m_hWnd, WM_DESTROY, 0, 0);
					}
				}
				_UpdateFPS();
			}
		}

    }

	//֐WM_QUITbZ[W󂯎ĐɏIꍇ
	//wParamɊi[ĂIR[hԂ
	//bZ[W[vɓOɏIꍇ0Ԃ
	return quitCode;
}

//******************************************************************************
// EBhENXo^
//******************************************************************************
int MIDITrailApp::_RegisterClass(
		HINSTANCE hInstance
	)
{
	int result = 0;
	ATOM aresult = 0;
	WNDCLASSEX wcex;

	wcex.cbSize			= sizeof(WNDCLASSEX);				//\̃TCY
	wcex.style			= CS_HREDRAW | CS_VREDRAW;			//NXX^C
	wcex.lpfnWndProc	= _WndProc;							//EBhEvV[W
	wcex.cbClsExtra		= 0;								//ǉ̃TCY
	wcex.cbWndExtra		= 0;								//ǉ̃TCY
	wcex.hInstance		= hInstance;						//AvP[VCX^Xnh
	wcex.hIcon			= LoadIcon(hInstance, MAKEINTRESOURCE(IDI_MIDITRAIL));
															//ACR\[Xnh
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);		//J[\\[Xnh
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);			//wipuVnh
	wcex.lpszMenuName	= MAKEINTRESOURCE(IDC_MIDITRAIL);	//j[\[X
	wcex.lpszClassName	= m_WndClassName;					//EBhENX
	wcex.hIconSm		= LoadIcon(wcex.hInstance, MAKEINTRESOURCE(IDI_SMALL));
				 											//ACR\[Xnh

	//ړTCYύXɂEChË̍ĕ`w
	// CS_HREDRAW NCAg̈̕ωƂɍĕ`悷
	// CS_VREDRAW NCAg̈̍ωƂɍĕ`悷

	aresult = RegisterClassEx(&wcex);
	if (aresult == 0) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// CEBhE
//******************************************************************************
int MIDITrailApp::_CreateWindow(
		HINSTANCE hInstance,
		int nCmdShow
	)
{
	int result = 0;
	BOOL bresult = FALSE;

	m_hWnd = CreateWindow(
				m_WndClassName,			//EBhENX
				m_Title,				//EBhE
				MIDITRAIL_WINDOW_STYLE,	//EBhEX^C
				CW_USEDEFAULT,			//EBhẺ̈ʒuFftHg
				0,						//EBhȄc̈ʒu
				CW_USEDEFAULT,			//EBhE̕FftHg
				0,						//EBhE̍
				NULL,					//e܂̓I[i[̃EBhEnh
				NULL,					//j[nh܂͎qEBhEID
				hInstance,				//AvP[VCX^Xnh
				NULL					//EBhE쐬f[^
			);
	if (m_hWnd == NULL) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}

	//[U[ݒEBhETCYύX
	result = _SetWindowSize();
	if (result != 0) goto EXIT;

	//EBhE\
	ShowWindow(m_hWnd, nCmdShow);

	//WM_PAINTĂяo~߂
	ValidateRect(m_hWnd, 0);

	UpdateWindow(m_hWnd);

EXIT:;
	return result;
}

//******************************************************************************
// EBhETCYύX
//******************************************************************************
int MIDITrailApp::_SetWindowSize()
{
	int result = 0;
	BOOL bresult = FALSE;
	int width = 0;
	int height = 0;
	RECT wrect, crect;
	int ww, wh, cw, ch, framew, frameh;

	//[UIEBhETCY擾
	result = m_ViewConf.SetCurSection(_T("WindowSize"));
	if (result != 0) goto EXIT;
	result = m_ViewConf.GetInt(_T("Width"), &width, 0);
	if (result != 0) goto EXIT;
	result = m_ViewConf.GetInt(_T("Height"), &height, 0);
	if (result != 0) goto EXIT;

	//ÑEBhETCY
	if ((width <= 0) || (height <= 0)) {
		width = 800;
		height = 600;
	}

	//EBhẼTCY
	GetWindowRect(m_hWnd, &wrect);
	ww = wrect.right - wrect.left;
	wh = wrect.bottom - wrect.top;

	//NCAg̈̃TCY
	GetClientRect(m_hWnd, &crect);
	cw = crect.right - crect.left;
	ch = crect.bottom - crect.top;

	//g̃TCY
	framew = ww - cw;
	frameh = wh - ch;

	//tXN[[hłȂΘg܂߂TCYƂ
	//TODO: tXN[[hΉ
	framew = 0;
	frameh = 0;

	//EBhETCYύX
	bresult = SetWindowPos(
					m_hWnd,			//EBhEnh
					HWND_TOP,		//zuFZI[_[擪
					0,				//̈ʒu
					0,				//c̈ʒu
					width + framew,	//
					height + frameh,//
					SWP_NOMOVE		//EBhEʒuw
				);
	if (!bresult) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), (DWORD)m_hWnd);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// ݒt@C
//******************************************************************************
int MIDITrailApp::_InitConfFile()
{
	int result = 0;
	BOOL bresult = FALSE;
	TCHAR userConfDirPath[_MAX_PATH] = {_T('\0')};
	TCHAR viewConfPath[_MAX_PATH] = {_T('\0')};
	TCHAR midiOutConfPath[_MAX_PATH] = {_T('\0')};

	//[Uݒt@Ci[fBNgpX쐬
	result = YNPathUtil::GetAppDataDirPath(userConfDirPath, _MAX_PATH);
	if (result != 0) goto EXIT;
	_tcscat_s(userConfDirPath, _MAX_PATH, MT_USER_CONFFILE_DIR);

	//[Uݒt@Ci[fBNg쐬
	bresult = MakeSureDirectoryPathExists(userConfDirPath);
	if (!bresult) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}

	//r[ݒt@C
	_tcscat_s(viewConfPath, _MAX_PATH, userConfDirPath);
	_tcscat_s(viewConfPath, _MAX_PATH, MT_USER_CONFFILE_VIEW);
	result = m_ViewConf.Initialize(viewConfPath);
	if (result != 0) goto EXIT;

	//MIDIݒt@C
	_tcscat_s(midiOutConfPath, _MAX_PATH, userConfDirPath);
	_tcscat_s(midiOutConfPath, _MAX_PATH, MT_USER_CONFFILE_MIDI);
	result = m_MIDIConf.Initialize(midiOutConfPath);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// CEBhEFEBhEvV[W
//******************************************************************************
LRESULT CALLBACK MIDITrailApp::_WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	return m_pThis->_WndProcImpl(hWnd, message, wParam, lParam);
}

//******************************************************************************
// CEBhEFEBhEvV[WF
//******************************************************************************
LRESULT MIDITrailApp::_WndProcImpl(
		HWND hWnd,
		UINT message,
		WPARAM wParam,
		LPARAM lParam
	)
{
	int result = 0;
	LRESULT lresult = 0;
	int wmId = 0;
	int wmEvent = 0;
	HDC hdc = NULL;
	PAINTSTRUCT ps;

	switch (message) {
		case WM_COMMAND:
			wmId    = LOWORD(wParam);
			wmEvent = HIWORD(wParam);
			switch (wmId) {
				case IDM_OPEN_FILE:
					//t@CI[v
					result = _OnMenuFileOpen();
					if (result != 0) goto EXIT;
					break;
				case IDM_EXIT:
					//I
					DestroyWindow(hWnd);
					break;
				case IDM_PLAY:
					//tJn^ꎞ~^ĊJ
					result = _OnMenuPlay();
					if (result != 0) goto EXIT;
					break;
				case IDM_STOP:
					//t~
					result = _OnMenuStop();
					if (result != 0) goto EXIT;
					break;
				case IDM_REPEAT:
					//s[g
					result = _OnMenuRepeat();
					if (result != 0) goto EXIT;
					break;
				case IDM_VIEW_3DPIANOROLL:
					//r[ύXF3DsAm[
					result = _OnMenuSelectSceneType(PianoRoll3D);
					if (result != 0) goto EXIT;
					break;
				case IDM_VIEW_2DPIANOROLL:
					//r[ύXF2DsAm[
					result = _OnMenuSelectSceneType(PianoRoll2D);
					if (result != 0) goto EXIT;
					break;
				case IDM_RESET_VIEWPOINT:
					//_Zbg
					result = _OnMenuResetViewpoint();
					if (result != 0) goto EXIT;
					break;
				case IDM_SAVE_VIEWPOINT:
					//_ۑ
					result = _OnMenuSaveViewpoint();
					if (result != 0) goto EXIT;
					break;
				case IDM_ENABLE_PIANOKEYBOARD:
					//\ʁFsAmL[{[h
					result = _OnMenuEnableEffect(MTScene::EffectPianoKeyboard);
					if (result != 0) goto EXIT;
					break;
				case IDM_ENABLE_RIPPLE:
					//\ʁFg
					result = _OnMenuEnableEffect(MTScene::EffectRipple);
					if (result != 0) goto EXIT;
					break;
				case IDM_ENABLE_PITCHBEND:
					//\ʁFsb`xh
					result = _OnMenuEnableEffect(MTScene::EffectPitchBend);
					if (result != 0) goto EXIT;
					break;
				case IDM_WINDOWSIZE:
					//EBhETCYݒ
					result = _OnMenuWindowSize();
					if (result != 0) goto EXIT;
					break;
				case IDM_OPTION_MIDIOUT:
					//MIDIo̓foCXݒ
					result = _OnMenuOptionMIDIOUT();
					if (result != 0) goto EXIT;
					break;
				case IDM_HOWTOVIEW:
					//@_CAO\
					m_HowToViewDlg.Show(m_hWnd);
					break;
				case IDM_MANUAL:
					//}jA\
					result = _OnMenuManual();
					if (result != 0) goto EXIT;
					break;
				case IDM_ABOUT:
					//o[W_CAO\
					m_AboutDlg.Show(m_hWnd);
					break;
				default:
					lresult = DefWindowProc(hWnd, message, wParam, lParam);
					break;
			}
			break;
		case WM_PAINT:
			hdc = BeginPaint(hWnd, &ps);
			EndPaint(hWnd, &ps);
			break;
		case WM_SEQUENCER_MESSAGE:
			//V[PTbZ[W
			result = _OnRecvSequencerMsg(wParam, lParam);
			if (result != 0) goto EXIT;
			break;
		case WM_KEYDOWN:
			//L[bZ[W
			result = _OnKeyDown(wParam, lParam);
			if (result != 0) goto EXIT;
			break;
		case WM_LBUTTONDOWN:
		case WM_RBUTTONDOWN:
		case WM_MBUTTONDOWN:
			//}EX{^bZ[W
			result = _OnMouseButtonDown(message, wParam, lParam);
			if (result != 0) goto EXIT;
			break;
		case WM_DROPFILES:
			//t@Chbv
			result = _OnDropFiles(wParam, lParam);
			if (result != 0) goto EXIT;
			break;
		case WM_TIMER:
			//^C}[
			result = _OnTimer(wParam);
			if (result != 0) goto EXIT;
			break;
		case WM_DESTROY:
			//j
			result = _OnDestroy();
			//߂l͖
			PostQuitMessage(0);
			break;
		default:
			lresult = DefWindowProc(hWnd, message, wParam, lParam);
			break;
	}

EXIT:;
	if (result != 0) {
		YN_SHOW_ERR(m_hWnd);
	}
	return lresult;
}

//******************************************************************************
// t@CI[v
//******************************************************************************
int MIDITrailApp::_OnMenuFileOpen()
{
	int result = 0;
	TCHAR filePath[MAX_PATH] = {_T('\0')};
	bool isSelected = false;

	//t̓t@CI[vȂ
	if ((m_PlayStatus != NoData) && (m_PlayStatus != Stop)) {
		goto EXIT;
	}

	//t@CI_CAO\
	result = _SelectMIDIFile(filePath, MAX_PATH, &isSelected);
	if (result != 0) goto EXIT;

	//t@CȈ
	if (isSelected) {
		//MIDIt@Cǂݍݏ
		result = _LoadMIDIFile(filePath);
		if (result != 0) goto EXIT;

		//HowToView\
		result = _DispHowToView();
		if (result != 0) goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// j[IFĐ^ꎞ~^ĊJ
//******************************************************************************
int MIDITrailApp::_OnMenuPlay()
{
	int result = 0;

	if (m_PlayStatus == Stop) {
		//V[PT
		result = m_Sequencer.Initialize(m_hWnd, WM_SEQUENCER_MESSAGE);
		if (result != 0) goto EXIT;

		//V[PTɃ|[go^
		result = _SetPortDev(&m_Sequencer);
		if (result != 0) goto EXIT;

		//V[PTɃV[PXf[^o^
		result = m_Sequencer.SetSeqData(&m_SeqData);
		if (result != 0) goto EXIT;

		//߂
		if (m_isRewind) {
			m_isRewind = false;
			result = m_pScene->Rewind();
			if (result != 0) goto EXIT;
		}

		//V[ɉtJnʒm
		result = m_pScene->OnPlayStart();
		if (result != 0) goto EXIT;

		//ŐVV[PTbZ[WNA
		ZeroMemory(&m_SequencerLastMsg, sizeof(MTSequencerLastMsg));

		//tJn
		result = m_Sequencer.Play();
		if (result != 0) goto EXIT;

		//tԕύX
		result = _ChangePlayStatus(Play);
		if (result != 0) goto EXIT;
	}
	else if (m_PlayStatus == Play) {
		//tꎞ~
		m_Sequencer.Pause();
		if (result != 0) goto EXIT;

		//tԕύX
		result = _ChangePlayStatus(Pause);
		if (result != 0) goto EXIT;
	}
	else if (m_PlayStatus == Pause) {
		//tĊJ
		result = m_Sequencer.Resume();
		if (result != 0) goto EXIT;

		//tԕύX
		result = _ChangePlayStatus(Play);
		if (result != 0) goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// j[IF~
//******************************************************************************
int MIDITrailApp::_OnMenuStop()
{
	int result = 0;

	if ((m_PlayStatus == Play) || (m_PlayStatus == Pause)) {
		m_Sequencer.Stop();
		//tԒʒm͂܂ōĐƂ݂Ȃ
		//ł͉tԂύXȂ

		//IɊ߂
		m_isRewind = true;
	}

	return result;
}

//******************************************************************************
// j[IFs[g
//******************************************************************************
int MIDITrailApp::_OnMenuRepeat()
{
	int result = 0;

	//s[g؂ւ
	if (m_isRepeat) {
		m_isRepeat = false;
	}
	else {
		m_isRepeat = true;
	}

	//j[I}[NXV
	result = _UpdateMenuCheckmark();
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// j[IF
//******************************************************************************
int MIDITrailApp::_OnMenuSelectSceneType(
		MIDITrailApp::SceneType type
	)
{
	int result = 0;

	//t͕ύXs
	if ((m_PlayStatus != NoData) && (m_PlayStatus != Stop)) {
		goto EXIT;
	}

	//ۑ
	m_SelectedSceneType = type;
	result = _SaveSceneType();
	if (result != 0) goto EXIT;

	//j[I}[NXV
	result = _UpdateMenuCheckmark();
	if (result != 0) goto EXIT;

	//~̏ꍇ̓V[č\z
	if (m_PlayStatus == Stop) {
		m_SceneType = m_SelectedSceneType;
		result = _CreateScene(m_SceneType, &m_SeqData);
		if (result != 0) goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// j[IF_Zbg
//******************************************************************************
int MIDITrailApp::_OnMenuResetViewpoint()
{
	int result = 0;

	if (m_PlayStatus == NoData) goto EXIT;

	//V[̎_Zbg
	m_pScene->ResetViewpoint();

	//_ۑ
	result = _SaveViewpoint();
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// j[IF_ۑ
//******************************************************************************
int MIDITrailApp::_OnMenuSaveViewpoint()
{
	int result = 0;

	if (m_PlayStatus == NoData) goto EXIT;

	//_ۑ
	result = _SaveViewpoint();
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// j[IF\ʐݒ
//******************************************************************************
int MIDITrailApp::_OnMenuEnableEffect(
		MTScene::EffectType type
	)
{
	int result = 0;

	switch (type) {
		case MTScene::EffectPianoKeyboard:
			m_isEnablePianoKeyboard = m_isEnablePianoKeyboard ? false : true;
			break;
		case MTScene::EffectRipple:
			m_isEnableRipple = m_isEnableRipple ? false : true;
			break;
		case MTScene::EffectPitchBend:
			m_isEnablePitchBend = m_isEnablePitchBend ? false : true;
			break;
		default:
			break;
	}

	_UpdateEffect();
	_UpdateMenuCheckmark();

//EXIT:;
	return result;
}

//******************************************************************************
// j[IFEBhETCYύX
//******************************************************************************
int MIDITrailApp::_OnMenuWindowSize()
{
	int result = 0;

	//ݒ_CAO\
	result = m_WindowSizeCfgDlg.Show(m_hWnd);
	if (result != 0) goto EXIT;

	//ύXꂽꍇ̓EBhETCYXV
	if (m_WindowSizeCfgDlg.IsCahnged()) {
		result = _ChangeWindowSize();
		if (result != 0) goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// j[IFMIDIo̓foCXݒ
//******************************************************************************
int MIDITrailApp::_OnMenuOptionMIDIOUT()
{
	int result = 0;

	//ݒ_CAO\
	result = m_MIDIOUTCfgDlg.Show(m_hWnd);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// }jA\
//******************************************************************************
int MIDITrailApp::_OnMenuManual()
{
	int result = 0;
	HINSTANCE hresult = 0;
	TCHAR manualPath[_MAX_PATH] = {_T('\0')};

	//vZXst@CfBNgpX擾
	result = YNPathUtil::GetModuleDirPath(manualPath, _MAX_PATH);
	if (result != 0) goto EXIT;

	//}jAt@CpX쐬
	_tcscat_s(manualPath, _MAX_PATH, MT_MANUALFILE);

	//}jAt@CJ
	hresult = ShellExecute(
					NULL,			//eEBhEnh
					_T("open"),		//
					manualPath,		//Ώۂ̃t@C
					NULL,			//p[^
					NULL,			//fBNg
					SW_SHOWNORMAL	//\
				);
	if (hresult <= (HINSTANCE)32) {
		result = YN_SET_ERR("File open error.", (unsigned long)hresult, 0);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// V[PTbZ[WM
//******************************************************************************
int MIDITrailApp::_OnRecvSequencerMsg(
		unsigned long wParam,
		unsigned long lParam
	)
{
	int result = 0;
	SMMsgParser parser;

	//V[ɃV[PTbZ[Wn
	if (m_pScene != NULL) {
		result = m_pScene->OnRecvSequencerMsg(wParam, lParam);
		if (result != 0) goto EXIT;
	}

	//tԕύXʒmւ̑Ή
	parser.Parse(wParam, lParam);
	if (parser.GetMsg() == SMMsgParser::MsgPlayStatus) {
		//ꎞ~
		if (parser.GetPlayStatus() == SMMsgParser::StatusPause) {
			result = _ChangePlayStatus(Pause);
			if (result != 0) goto EXIT;
		}
		//~itIj
		if (parser.GetPlayStatus() == SMMsgParser::StatusStop) {
			result = _ChangePlayStatus(Stop);
			if (result != 0) goto EXIT;

			//V[ɉtIʒm
			if (m_pScene != NULL) {
				result = m_pScene->OnPlayEnd();
				if (result != 0) goto EXIT;
			}

			//[U[̗vɂĒ~ꍇ͊߂
			if ((m_isRewind) && (m_pScene != NULL)) {
				m_isRewind = false;
				result = m_pScene->Rewind();
				if (result != 0) goto EXIT;
			}
			//ʏ̉tȈꍇ͎̉tɊ߂
			else {
				m_isRewind = true;
				//s[gLȂĐJn
				if (m_isRepeat) {
					result = _OnMenuPlay();
					if (result != 0) goto EXIT;
				}
			}

			//R}hCŏIw肳Ăꍇ
			if (m_CmdLineParser.GetSwitch(CMDSW_QUIET) == CMDSW_ON) {
				DestroyWindow(m_hWnd);
			}
		}
	}

	//foCXXg΍
	//V[ɓnŐVbZ[WL^Ă
	if (parser.GetMsg() == SMMsgParser::MsgPlayTime) {
		//t`bN^Cʒm
		m_SequencerLastMsg.isRecvPlayTime = true;
		m_SequencerLastMsg.playTime.wParam = wParam;
		m_SequencerLastMsg.playTime.lParam = lParam;
	}
	else if (parser.GetMsg() == SMMsgParser::MsgTempo) {
		//e|ύXʒm
		m_SequencerLastMsg.isRecvTempo = true;
		m_SequencerLastMsg.tempo.wParam = wParam;
		m_SequencerLastMsg.tempo.lParam = lParam;
	}
	else if (parser.GetMsg() == SMMsgParser::MsgBar) {
		//ߔԍʒm
		m_SequencerLastMsg.isRecvBar = true;
		m_SequencerLastMsg.bar.wParam = wParam;
		m_SequencerLastMsg.bar.lParam = lParam;
	}
	else if (parser.GetMsg() == SMMsgParser::MsgBeat) {
		//qLύXʒm
		m_SequencerLastMsg.isRecvBeat = true;
		m_SequencerLastMsg.beat.wParam = wParam;
		m_SequencerLastMsg.beat.lParam = lParam;
	}

EXIT:;
	return result;
}

//******************************************************************************
// EBhENbNCxg
//******************************************************************************
int MIDITrailApp::_OnMouseButtonDown(
		unsigned long button,
		unsigned long wParam,
		unsigned long lParam
	)
{
	int result = 0;

	if ((m_pScene != NULL) && (m_PlayStatus != NoData)) {
		result = m_pScene->OnWindowClicked(button, wParam, lParam);
		if (result != 0) goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// L[̓Cxg
//******************************************************************************
int MIDITrailApp::_OnKeyDown(
		unsigned long wParam,
		unsigned long lParam
	)
{
	int result = 0;

	//Xy[XL[FtJn^ꎞ~^ĊJ
	if (LOWORD(wParam) == VK_SPACE) {
		result = _OnMenuPlay();
		if (result != 0) goto EXIT;
	}

	//ESCL[Ft~
	if (LOWORD(wParam) == VK_ESCAPE) {
		result = _OnMenuStop();
		if (result != 0) goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// t@ChbvCxg
//******************************************************************************
int MIDITrailApp::_OnDropFiles(
		unsigned long wParam,
		unsigned long lParam
	)
{
	int result = 0;
	errno_t eresult = 0;
	UINT fileNum = 0;
	UINT charNum = 0;
	HDROP hDrop = NULL;
	TCHAR path[_MAX_PATH] = {_T('\0')};
	bool isMIDIDataFile = false;

	//~łȂ΃t@Chbv͖
	if ((m_PlayStatus != NoData) && (m_PlayStatus != Stop)) {
		goto EXIT;
	}

	hDrop = (HDROP)wParam;

	//t@CmF
	fileNum = DragQueryFile(
					hDrop,		//wParam
					0xFFFFFFFF,	//t@CCfbNX
					NULL,		//t@C擾obt@
					0			//obt@TCY
				); 

	//t@C̏ꍇ͖
	if (fileNum != 1) goto EXIT;

	//t@CpX擾
	charNum = DragQueryFile(
					hDrop,		//wParam
					0,			//t@CCfbNX
					path,		//t@C擾obt@
					_MAX_PATH	//obt@TCY
				); 
	if (charNum == 0) {
		result = YN_SET_ERR("Windows API error.", wParam, lParam);
		goto EXIT;
	}

	//t@Cgq̊mF
	if (YNPathUtil::IsFileExtMatch(path, _T(".mid"))) {
		isMIDIDataFile = true;
	}
	//rcpcv.dllLȂT|[gΏۃt@Cł邩ǉmF
	else if (m_RcpConv.IsAvailable() && m_RcpConv.IsSupportFileExt(path)) {
		isMIDIDataFile = true;
	}

	if (isMIDIDataFile) {
		//MIDIt@Cǂݍ
		result = _LoadMIDIFile(path);
		if (result != 0) goto EXIT;

		//HowToView\
		result = _DispHowToView();
		if (result != 0) goto EXIT;
	}

EXIT:;
	if (hDrop != NULL) {
		DragFinish(hDrop);
	}
	return result;
}

//******************************************************************************
// t@CI
//******************************************************************************
int MIDITrailApp::_SelectMIDIFile(
		TCHAR* pFilePath,
		unsigned long bufSize,
		bool* pIsSelected
	)
{
	int result = 0;
	BOOL apiresult = FALSE;
	OPENFILENAME ofn;

	if ((pFilePath == NULL) || (bufSize == 0) || (pIsSelected ==NULL)) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	pFilePath[0] = _T('\0');
	ZeroMemory(&ofn, sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner   = NULL;
	ofn.lpstrFilter = _T("Standerd MIDI File (*.mid)\0*.mid\0\0");
	ofn.lpstrFile   = pFilePath;
	ofn.nMaxFile    = bufSize;
	ofn.lpstrTitle  = _T("Select Standerd MIDI File.");
	ofn.Flags       = OFN_FILEMUSTEXIST;  //OFN_HIDEREADONLY

	//rcpcv.dllLȂt@CtB^ύX
	if (m_RcpConv.IsAvailable()) {
		ofn.lpstrFilter = m_RcpConv.GetOpenFileNameFilter();
	}

	//t@CI_CAO\
	apiresult = GetOpenFileName(&ofn);
	if (!apiresult) {
		//LZ܂̓G[FG[̓`FbNȂ
		*pIsSelected = false;
		goto EXIT;
	}

	*pIsSelected = true;

EXIT:;
	return result;
}

//******************************************************************************
// MIDIt@Cǂݍ
//******************************************************************************
int MIDITrailApp::_LoadMIDIFile(
		const TCHAR* pFilePath
	)
{
	int result = 0;
	TCHAR* pPath = NULL;
	TCHAR smfTempPath[_MAX_PATH] = {_T('\0')};
	SMFileReader smfReader;

	//gq*.mid̏ꍇ
	if (YNPathUtil::IsFileExtMatch(pFilePath, _T(".mid"))) {
		pPath = (TCHAR*)pFilePath;
	}
	//gq*.midȊȌꍇ
	else {
		//R|[Ũf[^t@CƂ݂ȂSMFɕϊ
		result = YNPathUtil::GetTempFilePath(smfTempPath, _MAX_PATH, _T("RCP"));
		if (result != 0) goto EXIT;
		result = m_RcpConv.Convert(pFilePath, smfTempPath);
		if (result != 0) goto EXIT;
		pPath = smfTempPath;
	}

	//t@Cǂݍ
	result = smfReader.Load(pPath, &m_SeqData);
	if (result != 0) goto EXIT;

	//V[IuWFNg
	m_SceneType = m_SelectedSceneType;
	result = _CreateScene(m_SceneType, &m_SeqData);
	if (result != 0) goto EXIT;

	//tԕύX
	result = _ChangePlayStatus(Stop);
	if (result != 0) goto EXIT;

	m_isRewind = false;

EXIT:;
	if (_tcslen(smfTempPath) != 0) {
		DeleteFile(smfTempPath);
	}
	return result;
}

//******************************************************************************
// FPSXV
//******************************************************************************
void MIDITrailApp::_UpdateFPS()
{
	unsigned long curTime = 0;
	unsigned long diffTime = 0;
	double fps = 0;
	TCHAR title[256];

	curTime = timeGetTime();
	m_FPSCount += 1;

	//1bƂFPSvZ
	diffTime = curTime - m_PrevTime;
	if (diffTime > 1000) {

		//FPS
		fps = (double)m_FPSCount / ((double)diffTime / 1000.0f);
		m_PrevTime = curTime;
		m_FPSCount = 0;

		//V[IuWFNgFPSݒ
		if (m_pScene != NULL) {
			m_pScene->SetFPS(fps);
		}

		//EBhE^Cgɐݒ
		_stprintf_s(title, 256, _T("%s - FPS:%.1f"), m_Title, fps);
		SetWindowText(m_hWnd, title);
	}

	return;
}

//******************************************************************************
// |[go^
//******************************************************************************
int MIDITrailApp::_SetPortDev(
		SMSequencer* pSequencer
	)
{
	int result = 0;
	unsigned char portNo = 0;
	TCHAR devName[MAXPNAMELEN];
	char* portName[] = {"PortA", "PortB", "PortC", "PortD", "PortE", "PortF"};

	result = m_MIDIConf.SetCurSection(_T("MIDIOUT"));
	if (result != 0) goto EXIT;

	//ݒt@C烆[UIfoCX擾ăV[PTɓo^
	for (portNo = 0; portNo < SM_MIDIOUT_PORT_NUM_MAX; portNo++) {

		result = m_MIDIConf.GetStr(portName[portNo], devName, MAXPNAMELEN, _T(""));
		if (result != 0) goto EXIT;

		result = pSequencer->SetPortDev(portNo, devName);
		if (result != 0) goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// EBhETCYύX
//******************************************************************************
int MIDITrailApp::_ChangeWindowSize()
{
	int result = 0;

	//~łȂ΃TCYύX͋֎~
	if ((m_PlayStatus != NoData)
	 && (m_PlayStatus != Stop)
	 && (m_PlayStatus != Pause)) {
		goto EXIT;
	}

	//V[j
	if (m_pScene != NULL) {
		m_pScene->Release();
		delete m_pScene;
		m_pScene = NULL;
	}

	//_I
	m_Renderer.Terminate();

	//[U[ݒEBhETCYύX
	result = _SetWindowSize();
	if (result != 0) goto EXIT;

	//_
	result = m_Renderer.Initialize(m_hWnd);
	if (result != 0) goto EXIT;

	//V[IuWFNg
	result = _CreateScene(m_SceneType, &m_SeqData);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// tԕύX
//******************************************************************************
int MIDITrailApp::_ChangePlayStatus(
		PlayStatus status
	)
{
	int result = 0;

	//tԕύX
	m_PlayStatus = status;

	//t@ChbN
	if ((m_PlayStatus == NoData) || (m_PlayStatus == Stop)) {
		DragAcceptFiles(m_hWnd, TRUE);
	}
	else {
		DragAcceptFiles(m_hWnd, FALSE);
	}

	//j[X^CXV
	result = _ChangeMenuStyle();
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// j[X^CXV
//******************************************************************************
int MIDITrailApp::_ChangeMenuStyle()
{
	int result = 0;
	unsigned long menuIndex = 0;
	unsigned long statusIndex = 0;
	unsigned long style = 0;

	//j[IDꗗ
	unsigned long menuID[MT_MENU_NUM] = {
		IDM_OPEN_FILE,
		IDM_EXIT,
		IDM_PLAY,
		IDM_STOP,
		IDM_REPEAT,
		IDM_VIEW_3DPIANOROLL,
		IDM_VIEW_2DPIANOROLL,
		IDM_RESET_VIEWPOINT,
		IDM_SAVE_VIEWPOINT,
		IDM_ENABLE_PIANOKEYBOARD,
		IDM_ENABLE_RIPPLE,
		IDM_ENABLE_PITCHBEND,
		IDM_WINDOWSIZE,
		IDM_OPTION_MIDIOUT,
		IDM_HOWTOVIEW,
		IDM_MANUAL,
		IDM_ABOUT
	};

	//j[X^Cꗗ
	unsigned long menuStyle[MT_MENU_NUM][MT_PLAYSTATUS_NUM] = {
		//	f[^Ȃ	~		Đ		ꎞ~		j[ID
		{	MF_ENABLED,	MF_ENABLED,	MF_GRAYED,	MF_GRAYED	},	//IDM_OPEN_FILE
		{	MF_ENABLED,	MF_ENABLED,	MF_ENABLED,	MF_ENABLED	},	//IDM_EXIT
		{	MF_GRAYED,	MF_ENABLED,	MF_ENABLED,	MF_ENABLED	},	//IDM_PLAY
		{	MF_GRAYED,	MF_GRAYED,	MF_ENABLED,	MF_ENABLED	},	//IDM_STOP
		{	MF_ENABLED,	MF_ENABLED,	MF_ENABLED,	MF_ENABLED	},	//IDM_REPEAT
		{	MF_ENABLED,	MF_ENABLED,	MF_GRAYED,	MF_GRAYED	},	//IDM_VIEW_3DPIANOROLL
		{	MF_ENABLED,	MF_ENABLED,	MF_GRAYED,	MF_GRAYED	},	//IDM_VIEW_2DPIANOROLL
		{	MF_GRAYED,	MF_ENABLED,	MF_ENABLED,	MF_ENABLED	},	//IDM_RESET_VIEWPOINT
		{	MF_GRAYED,	MF_ENABLED,	MF_ENABLED,	MF_ENABLED	},	//IDM_SAVE_VIEWPOINT
		{	MF_ENABLED,	MF_ENABLED,	MF_ENABLED,	MF_ENABLED	},	//IDM_ENABLE_PIANOKEYBOARD
		{	MF_ENABLED,	MF_ENABLED,	MF_ENABLED,	MF_ENABLED	},	//IDM_ENABLE_RIPPLE
		{	MF_ENABLED,	MF_ENABLED,	MF_ENABLED,	MF_ENABLED	},	//IDM_ENABLE_PITCHBEND
		{	MF_ENABLED,	MF_ENABLED,	MF_GRAYED,	MF_GRAYED	},	//IDM_WINDOWSIZE
		{	MF_ENABLED,	MF_ENABLED,	MF_GRAYED,	MF_GRAYED	},	//IDM_OPTION_MIDIOUT
		{	MF_ENABLED,	MF_ENABLED,	MF_ENABLED,	MF_ENABLED	},	//IDM_HOWTOVIEW
		{	MF_ENABLED,	MF_ENABLED,	MF_ENABLED,	MF_ENABLED	},	//IDM_MANUAL
		{	MF_ENABLED,	MF_ENABLED,	MF_ENABLED,	MF_ENABLED	}	//IDM_ABOUT
	};

	switch (m_PlayStatus) {
		case NoData: statusIndex = 0; break;
		case Stop:   statusIndex = 1; break;
		case Play:   statusIndex = 2; break;
		case Pause:  statusIndex = 3; break;
	}

	//j[X^CXV
	for (menuIndex = 0; menuIndex < MT_MENU_NUM; menuIndex++) {
		style = menuStyle[menuIndex][statusIndex];
		EnableMenuItem(GetMenu(m_hWnd), menuID[menuIndex], style);
	}

	return result;
}

//******************************************************************************
// V[
//******************************************************************************
int MIDITrailApp::_CreateScene(
		SceneType type,
		SMSeqData* pSeqData
	)
{
	int result = 0;

	//V[j
	if (m_pScene != NULL) {
		m_pScene->Release();
		delete m_pScene;
		m_pScene = NULL;
	}

	//V[IuWFNg
	try {
		if (type == Title) {
			m_pScene = new MTSceneTitle();
		}
		else if (type == PianoRoll3D) {
			m_pScene = new MTScenePianoRoll3D();
		}
		else if (type == PianoRoll2D) {
			m_pScene = new MTScenePianoRoll2D();
		}
	}
	catch (std::bad_alloc) {
		result = YN_SET_ERR("Could not allocate memory.", type, 0);
		goto EXIT;
	}

	//V[̐
	result = m_pScene->Create(m_hWnd, m_Renderer.GetDevice(), pSeqData);
	if (result != 0) goto EXIT;

	//ۑĂ鎋_V[ɔf
	if (type != Title) {
		result = _LoadViewpoint();
		if (result != 0) goto EXIT;
	}

	//\ʔf
	_UpdateEffect();

EXIT:;
	return result;
}

//******************************************************************************
// V[ʓǂݍ
//******************************************************************************
int MIDITrailApp::_LoadSceneType()
{
	int result = 0;
	TCHAR type[256];

	result = m_ViewConf.SetCurSection(_T("Scene"));
	if (result != 0) goto EXIT;

	result = m_ViewConf.GetStr(_T("Type"), type, 256, _T(""));
	if (result != 0) goto EXIT;

	if (_tcscmp(type, _T("PianoRoll3D")) == 0) {
		m_SelectedSceneType = PianoRoll3D;
	}
	else if (_tcscmp(type, _T("PianoRoll2D")) == 0) {
		m_SelectedSceneType = PianoRoll2D;
	}
	else {
		m_SelectedSceneType = PianoRoll3D;
	}

EXIT:;
	return result;
}

//******************************************************************************
// V[ʕۑ
//******************************************************************************
int MIDITrailApp::_SaveSceneType()
{
	int result = 0;
	TCHAR* pType = _T("");

	switch (m_SelectedSceneType) {
		case PianoRoll3D:
			pType = _T("PianoRoll3D");
			break;
		case PianoRoll2D:
			pType = _T("PianoRoll2D");
			break;
		default:
			result = YN_SET_ERR("Program error.", m_SelectedSceneType, 0);
			goto EXIT;
			break;
	}

	result = m_ViewConf.SetCurSection(_T("Scene"));
	if (result != 0) goto EXIT;

	result = m_ViewConf.SetStr(_T("Type"), pType);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// _ǂݍ
//******************************************************************************
int MIDITrailApp::_LoadViewpoint()
{
	int result = 0;
	D3DXVECTOR3 vector;
	D3DXVECTOR3 defVector;
	float phi, theta = 0.0f;
	float defPhi, defTheta = 0.0f;
	TCHAR section[256] = {_T('\0')};

	//V[ftHg̎_擾
	m_pScene->GetDefaultViewpoint(&defVector, &defPhi, &defTheta);

	_tcscat_s(section, 256, _T("Viewpoint-"));
	_tcscat_s(section, 256, m_pScene->GetName());
	result = m_ViewConf.SetCurSection(section);
	if (result != 0) goto EXIT;
	result = m_ViewConf.GetFloat(_T("X"), &(vector.x), defVector.x);
	if (result != 0) goto EXIT;
	result = m_ViewConf.GetFloat(_T("Y"), &(vector.y), defVector.y);
	if (result != 0) goto EXIT;
	result = m_ViewConf.GetFloat(_T("Z"), &(vector.z), defVector.z);
	if (result != 0) goto EXIT;
	result = m_ViewConf.GetFloat(_T("Phi"), &phi, defPhi);
	if (result != 0) goto EXIT;
	result = m_ViewConf.GetFloat(_T("Theta"), &theta, defTheta);
	if (result != 0) goto EXIT;

	//V[Ɏ_o^
	m_pScene->SetViewpoint(vector, phi, theta);

EXIT:;
	return result;
}

//******************************************************************************
// _ۑ
//******************************************************************************
int MIDITrailApp::_SaveViewpoint()
{
	int result = 0;
	D3DXVECTOR3 vector;
	float phi, theta = 0.0f;
	TCHAR section[256] = {_T('\0')};

	//V[猻݂̎_擾
	m_pScene->GetViewpoint(&vector, &phi, &theta);

	//_t@Cۑ
	_tcscat_s(section, 256, _T("Viewpoint-"));
	_tcscat_s(section, 256, m_pScene->GetName());
	result = m_ViewConf.SetCurSection(section);
	if (result != 0) goto EXIT;
	result = m_ViewConf.SetFloat(_T("X"), vector.x);
	if (result != 0) goto EXIT;
	result = m_ViewConf.SetFloat(_T("Y"), vector.y);
	if (result != 0) goto EXIT;
	result = m_ViewConf.SetFloat(_T("Z"), vector.z);
	if (result != 0) goto EXIT;
	result = m_ViewConf.SetFloat(_T("Phi"), phi);
	if (result != 0) goto EXIT;
	result = m_ViewConf.SetFloat(_T("Theta"), theta);
	if (result != 0) goto EXIT;

	//_؂ւꂽƂV[ɓ`B
	m_pScene->SetViewpoint(vector, phi, theta);

EXIT:;
	return result;
}

//******************************************************************************
// EBhEj
//******************************************************************************
int MIDITrailApp::_OnDestroy()
{
	int result = 0;

	//t~߂
	if (m_PlayStatus == Play) {
		m_Sequencer.Stop();
		//V[PT̃XbhI҂킹ׂ𔲂
		Sleep(100);
	}

	return result;
}

//******************************************************************************
// V[Đ
//******************************************************************************
int MIDITrailApp::_RebuildScene()
{
	int result = 0;
	int apiresult = 0;
	bool m_isResume = false;
	D3DXVECTOR3 vector = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	float phi, theta = 0.0f;

	//b΍
	//  bZ[W{bNX\邱Ƃɂ
	//  [U[OK{^܂ł̊Ԃ
	//  foCXZbg\ԂɂȂ邱Ƃ҂

	//݂̎_ޔ
	if (m_pScene != NULL) {
		m_pScene->GetViewpoint(&vector, &phi, &theta);
	}

	//tꎞ~
	//  Ȃꎞ~ȂƃfoCXĐĂ
	//  foCXXg畜AłȂ
	if (m_PlayStatus == Play) {
		m_Sequencer.Pause();
		m_isResume = true;
	}
	//bZ[W{bNX\
	apiresult = MessageBox(
					m_hWnd,						//I[i[EBhE
					MIDITRAIL_MSG_DEVICELOST,	//bZ[W
					_T("WARNING"),				//^Cg
					MB_OK | MB_ICONWARNING		//tO
				);
	if (apiresult == 0) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}

	//_ƃV[IuWFNg̍Đ
	result = _ChangeWindowSize();
	if (result != 0) goto EXIT;

	//V[̍Đݒ
	if (m_pScene != NULL) {
		//_𕜋A
		m_pScene->SetViewpoint(vector, phi, theta);

		//t̏ꍇ̓V[ɉtJnʒm
		if ((m_PlayStatus == Play) || (m_PlayStatus == Pause)) {
			result = m_pScene->OnPlayStart();
			if (result != 0) goto EXIT;
		}
		//t`bN^Cʒm
		if (m_SequencerLastMsg.isRecvPlayTime) {
			result = m_pScene->OnRecvSequencerMsg(
							m_SequencerLastMsg.playTime.wParam,
							m_SequencerLastMsg.playTime.lParam
						);
			if (result != 0) goto EXIT;
		}
		//e|ύXʒm
		if (m_SequencerLastMsg.isRecvTempo) {
			result = m_pScene->OnRecvSequencerMsg(
							m_SequencerLastMsg.tempo.wParam,
							m_SequencerLastMsg.tempo.lParam
						);
			if (result != 0) goto EXIT;
		}
		//ߔԍʒm
		if (m_SequencerLastMsg.isRecvBar) {
			result = m_pScene->OnRecvSequencerMsg(
							m_SequencerLastMsg.bar.wParam,
							m_SequencerLastMsg.bar.lParam
						);
			if (result != 0) goto EXIT;
		}
		//qLύXʒm
		if (m_SequencerLastMsg.isRecvBeat) {
			result = m_pScene->OnRecvSequencerMsg(
							m_SequencerLastMsg.beat.wParam,
							m_SequencerLastMsg.beat.lParam
						);
			if (result != 0) goto EXIT;
		}
		//TODO: m[g̃JE^\łĂȂ
		//TODO: sb`xhłĂȂ
	}

	//ꎞ~ꍇ͉tĊJ
	if (m_isResume) {
		result = m_Sequencer.Resume();
		if (result != 0) goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// HowToView\
//******************************************************************************
int MIDITrailApp::_DispHowToView()
{
	int result = 0;
	int count = 0;

	result = m_ViewConf.SetCurSection(_T("HowToView"));
	if (result != 0) goto EXIT;

	result = m_ViewConf.GetInt(_T("DispCount"), &count, 0);
	if (result != 0) goto EXIT;

	if (count == 0) {
		//@_CAO\
		m_HowToViewDlg.Show(m_hWnd);
	}

	count = 1;
	result = m_ViewConf.SetInt(_T("DispCount"), count);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// j[I}[NXV
//******************************************************************************
int MIDITrailApp::_UpdateMenuCheckmark()
{
	int result = 0;

	//s[g
	_CheckMenuItem(IDM_REPEAT, m_isRepeat);

	//V[ʑI
	_CheckMenuItem(IDM_VIEW_3DPIANOROLL, false);
	_CheckMenuItem(IDM_VIEW_2DPIANOROLL, false);
	switch (m_SelectedSceneType) {
		case PianoRoll3D:
			_CheckMenuItem(IDM_VIEW_3DPIANOROLL, true);
			break;
		case PianoRoll2D:
			_CheckMenuItem(IDM_VIEW_2DPIANOROLL, true);
			break;
		default:
			result = YN_SET_ERR("Program error.", m_SelectedSceneType, 0);
			goto EXIT;
			break;
	}

	//sAmL[{[h\
	_CheckMenuItem(IDM_ENABLE_PIANOKEYBOARD, m_isEnablePianoKeyboard);

	//g
	_CheckMenuItem(IDM_ENABLE_RIPPLE, m_isEnableRipple);

	//sb`xh
	_CheckMenuItem(IDM_ENABLE_PITCHBEND, m_isEnablePitchBend);

EXIT:;
	return result;
}

//******************************************************************************
// j[I}[Nݒ
//******************************************************************************
void MIDITrailApp::_CheckMenuItem(
		UINT uIDCheckItem,
		bool isEnable
	)
{
	UINT uCheck = 0;

	if (isEnable) {
		uCheck = MF_CHECKED;
	}
	else {
		uCheck = MF_UNCHECKED;
	}

	CheckMenuItem(GetMenu(m_hWnd), uIDCheckItem, MF_BYCOMMAND | uCheck);

	return;
}

//******************************************************************************
// \ʔf
//******************************************************************************
void MIDITrailApp::_UpdateEffect()
{
	if (m_pScene != NULL) {
		m_pScene->SetEffect(MTScene::EffectPianoKeyboard, m_isEnablePianoKeyboard);
		m_pScene->SetEffect(MTScene::EffectRipple, m_isEnableRipple);
		m_pScene->SetEffect(MTScene::EffectPitchBend, m_isEnablePitchBend);
	}
	return;
}

//******************************************************************************
// R}hC
//******************************************************************************
int MIDITrailApp::_ParseCmdLine(
		LPTSTR pCmdLine
	)
{
	int result = 0;

	//R}hC
	result = m_CmdLineParser.Initialize(pCmdLine);
	if (result != 0) goto EXIT;

	//R}hCŃt@Cw肳Ăꍇ
	if (m_CmdLineParser.GetSwitch(CMDSW_FILE_PATH) == CMDSW_ON) {

		//t@CJ
		result = _LoadMIDIFile(m_CmdLineParser.GetFilePath());
		if (result != 0) goto EXIT;

		//Đw肳Ăꍇ͍ĐJn
		if (m_CmdLineParser.GetSwitch(CMDSW_PLAY) == CMDSW_ON) {
			result = _OnMenuPlay();
			if (result != 0) goto EXIT;
		}
	}

EXIT:;
	return result;
}

//******************************************************************************
// ^C}[Jn
//******************************************************************************
int MIDITrailApp::_StartTimer()
{
	int result = 0;
	UINT apiresult = 0;

	//L[ԊmF^C}[
	apiresult = SetTimer(
						m_hWnd,			//ʒmEBhE
						MIDITRAIL_TIMER_CHECK_KEY,	//^C}[ID
						200,			//^CAEgli~bj
						NULL			//^C}[֐
					);
	if (apiresult == 0) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// ^C}[~
//******************************************************************************
int MIDITrailApp::_StopTimer()
{
	int result = 0;

	KillTimer(m_hWnd, MIDITRAIL_TIMER_CHECK_KEY);

	return result;
}

//******************************************************************************
// ^C}[Ăяo
//******************************************************************************
int MIDITrailApp::_OnTimer(
		WPARAM timerId
	)
{
	int result = 0;

	//L[ԊmF^C}[
	if (timerId == MIDITRAIL_TIMER_CHECK_KEY) {
		//Đx
		if ((GetKeyState(VK_F2) & 0x80) && (GetForegroundWindow() == m_hWnd)) {
			m_Sequencer.SetPlaybackSpeed(2);  //2{
		}
		else {
			m_Sequencer.SetPlaybackSpeed(1);
		}
	}

	return result;
}


