//******************************************************************************
//
// MIDITrail / MTCmdLineParser
//
// R}hC̓NX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "SMRcpConv.h"
#include "MTCmdLineParser.h"
#include <tchar.h>
#include <stdlib.h>

using namespace YNBaseLib;
using namespace SMIDILib;


//******************************************************************************
// RXgN^
//******************************************************************************
MTCmdLineParser::MTCmdLineParser(void)
{
	m_pFilePath = _T("");
	ZeroMemory(m_CmdSwitchStatus, sizeof(unsigned char)*CMDSW_MAX);
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTCmdLineParser::~MTCmdLineParser(void)
{
}

//******************************************************************************
// 
//******************************************************************************
int MTCmdLineParser::Initialize(
		LPTSTR pCmdLine
	)
{
	int result = 0;

	//R}hC
	result = _AnalyzeCmdLine(pCmdLine);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// R}hC
//******************************************************************************
int MTCmdLineParser::_AnalyzeCmdLine(
		LPTSTR pCmdLine
	)
{
	int result = 0;
	int i = 0;
	TCHAR* pArg = NULL;
	SMRcpConv rcpConv;

	//CommandLineToArgvW ݂͑邪 CommandLineToArgvA ݂͑Ȃ
	//̂APIł̉͂͂߂ __argc, __targv 𗘗p
	//cOȂpCmdLine͎QƂȂ

	//RCPǂݍ݉ۊmF̂RCPt@CϊIuWFNgpӂ
	result = rcpConv.Initialize();
	if (result != 0) goto EXIT;

	//̉
	for (i = 1; i < __argc; i++) {
		pArg = __targv[i];

		//MessageBox(NULL, pArg, _T(""), MB_OK);

		//t@CpX
		//  t@CpXw肳ꂽꍇ͐擪݂̗̂p
		if ((_tcslen(m_pFilePath) == 0) && (_tcslen(pArg) > 4)) {
			if (YNPathUtil::IsFileExtMatch(pArg, ".mid")) {
				m_pFilePath = pArg;
				m_CmdSwitchStatus[CMDSW_FILE_PATH] = CMDSW_ON;
			}
			else if (rcpConv.IsAvailable() && rcpConv.IsSupportFileExt(pArg)) {
				m_pFilePath = pArg;
				m_CmdSwitchStatus[CMDSW_FILE_PATH] = CMDSW_ON;
			}
		}
		//NɍĐJn
		if (_tcscmp(pArg, _T("-p")) == 0) {
			m_CmdSwitchStatus[CMDSW_PLAY] = CMDSW_ON;
		}
		//ĐIɃAvI
		if (_tcscmp(pArg, _T("-q")) == 0) {
			m_CmdSwitchStatus[CMDSW_QUIET] = CMDSW_ON;
		}
	}

	//t@CpXw̏ꍇ
	if (m_CmdSwitchStatus[CMDSW_FILE_PATH] != CMDSW_ON) {
		//Đ^ItO͋ɖ
		m_CmdSwitchStatus[CMDSW_PLAY] = CMDSW_NONE;
		m_CmdSwitchStatus[CMDSW_QUIET] = CMDSW_NONE;
	}

	//ĐtOONłȂΏItO͖
	if (m_CmdSwitchStatus[CMDSW_PLAY] != CMDSW_ON) {
		m_CmdSwitchStatus[CMDSW_QUIET] = CMDSW_NONE;
	}

EXIT:;
	return result;
}

//******************************************************************************
// XCb`Ԏ擾
//******************************************************************************
int MTCmdLineParser::GetSwitch(
		unsigned long switchType
	)
{
	int switchStatus = CMDSW_NONE;

	if (switchType < CMDSW_MAX) {
		switchStatus = m_CmdSwitchStatus[switchType];
	}

	return switchStatus;
}

//******************************************************************************
// t@CpX擾
//******************************************************************************
const TCHAR* MTCmdLineParser::GetFilePath()
{
	return m_pFilePath;
}


