//******************************************************************************
//
// Simple MIDI Library / SMMsgTransmitter
//
// bZ[W]NX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#pragma once

#ifdef SMIDILIB_EXPORTS
#define SMIDILIB_API __declspec(dllexport)
#else
#define SMIDILIB_API __declspec(dllimport)
#endif

#include "SMEvent.h"

namespace SMIDILib {


//******************************************************************************
// p[^`
//******************************************************************************
//bZ[W
#define SM_MSG_PLAY_STATUS     (0x00)
#define SM_MSG_TIME            (0x01)
#define SM_MSG_TEMPO           (0x02)
#define SM_MSG_BAR             (0x03)
#define SM_MSG_BEAT            (0x04)
#define SM_MSG_NOTE_OFF        (0x10)
#define SM_MSG_NOTE_ON         (0x11)
#define SM_MSG_PITCHBEND       (0x12)

//t
#define SM_PLAYSTATUS_STOP       (0x00)
#define SM_PLAYSTATUS_PLAY       (0x01)
#define SM_PLAYSTATUS_PAUSE      (0x02)


//******************************************************************************
// bZ[W]NX
//******************************************************************************
class SMIDILIB_API SMMsgTransmitter
{
public:

	//RXgN^^fXgN^
	SMMsgTransmitter(void);
	virtual ~SMMsgTransmitter(void);

	//
	int Initialize(HWND hTargetWnd, unsigned long msgId);

	//t
	int PostPlayStatus(unsigned long playStatus);

	//tԒʒm
	//  bPʎ̑Mf[^TCY2byteɂĂ邽ߍő999őM
	int PostPlayTime(unsigned long playTimeSec, unsigned long tickTime);

	//e|ʒm
	int PostTempo(unsigned long bpm);

	//ߔԍʒmF1Jn
	int PostBar(unsigned long barNo);

	//qLʒm
	//  ͍ő65535܂œn邪
	//  MIDI̎dlł͕q255^2255܂ŕ\ł
	int PostBeat(unsigned short numerator, unsigned short denominator);

	//m[gONʒm
	int PostNoteOn(
				unsigned char portNo,
				unsigned char chNo,
				unsigned char noteNo,
				unsigned char verocity
			);

	//m[gOFFʒm
	int PostNoteOff(
				unsigned char portNo,
				unsigned char chNo,
				unsigned char noteNo
			);

	//sb`xhʒm
	int PostPitchBend(
				unsigned char portNo,
				unsigned char chNo,
				short pitchBendValue,
				unsigned char pitchBendSensitivity
			);

private:

	HWND m_hTargetWnd;
	unsigned long m_MsgId;

	int _Post(
			unsigned char msg,
			unsigned short param1,
			unsigned long param2
		);
	
	//ƃRs[RXgN^̋֎~
	void operator=(const SMMsgTransmitter&);
	SMMsgTransmitter(const SMMsgTransmitter&);

};

} // end of namespace

