//******************************************************************************
//
// MIDITrail / MTHowToViewDlg
//
// @_CAO
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "resource.h"
#include "YNBaseLib.h"
#include "MTHowToViewDlg.h"

using namespace YNBaseLib;


//******************************************************************************
// EBhEvV[Wpp[^ݒ
//******************************************************************************
MTHowToViewDlg* MTHowToViewDlg::m_pThis = NULL;

//******************************************************************************
// RXgN^
//******************************************************************************
MTHowToViewDlg::MTHowToViewDlg(void)
{
	m_pThis = this;
	m_hMemBmpPixel = NULL;
	m_pBmpPixcel = NULL;
	m_PageNo = 0;
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTHowToViewDlg::~MTHowToViewDlg(void)
{
	_Clear();
}

//******************************************************************************
// EBhEvV[W
//******************************************************************************
INT_PTR CALLBACK MTHowToViewDlg::_WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	return m_pThis->_WndProcImpl(hWnd, message, wParam, lParam);
}

//******************************************************************************
// EBhEvV[WF
//******************************************************************************
INT_PTR MTHowToViewDlg::_WndProcImpl(
		HWND hDlg,
		UINT message,
		WPARAM wParam,
		LPARAM lParam
	)
{
	int result = 0;
	BOOL bresult = FALSE;

	UNREFERENCED_PARAMETER(lParam);

	switch (message) {
		case WM_INITDIALOG:
			result = _OnInitDlg(hDlg);
			if (result != 0) goto EXIT;
			bresult = TRUE;
			break;
		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK) {
				EndDialog(hDlg, LOWORD(wParam));
				bresult = TRUE;
			}
			else if (LOWORD(wParam) == IDCANCEL) {
				EndDialog(hDlg, LOWORD(wParam));
				bresult = TRUE;
			}
			break;
		case WM_PAINT:
			result = _DrawHowToBmp(hDlg);
			if (result != 0) goto EXIT;
			bresult = TRUE;
			break;
		case WM_LBUTTONDOWN:
			m_PageNo++;
			if (m_PageNo < 2) {
				result = _UpdateBmp(hDlg);
				if (result != 0) goto EXIT;
				bresult = TRUE;
			}
			else {
				EndDialog(hDlg, LOWORD(wParam));
				bresult = TRUE;
			}
			break;
	}

EXIT:;
	if (result != 0) {
		YN_SHOW_ERR(hDlg);
	}
	return (INT_PTR)bresult;
}

//******************************************************************************
// \
//******************************************************************************
int MTHowToViewDlg::Show(
		HWND hParentWnd
	)
{
	int result = 0;
	INT_PTR dresult = 0;
	HINSTANCE hInstance = NULL;

	m_PageNo = 0;

	//AvP[VCX^Xnh擾
	hInstance = (HINSTANCE)GetWindowLongPtr(hParentWnd, GWLP_HINSTANCE);
	if (hInstance == NULL) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), (DWORD)hParentWnd);
		goto EXIT;
	}

	//_CAO\
	dresult = DialogBox(
					hInstance,							//CX^Xnh
					MAKEINTRESOURCE(IDD_HOWTOVIEW),		//_CAO{bNXev[g
					hParentWnd,							//eEBhEnh
					_WndProc							//_CAO{bNXvV[W
				);
	if ((dresult == 0) || (dresult == -1)) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), (DWORD)hInstance);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// _CAO\O
//******************************************************************************
int MTHowToViewDlg::_OnInitDlg(
		HWND hDlg
	)
{
	int result = 0;

	//HowTorbg}bvǂݍ
	result = _LoadHowToBmp();
	if (result != 0) goto EXIT;

	//EBhETCYXV
	result = _UpdateWindowSize(hDlg);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// HowTorbg}bvǂݍ
//******************************************************************************
int MTHowToViewDlg::_LoadHowToBmp()
{
	int result = 0;
	HANDLE hFile = NULL;
	BOOL bresult = FALSE;
	DWORD numOfBytesRead = 0;
	DWORD fp = 0;
	HANDLE hMemBmpPixel = NULL;
	BYTE* pBmpPixcel = NULL;
	TCHAR bmpFilePath[_MAX_PATH] = {_T('\0')};
	TCHAR* pBmpFileName[2] = { MTHOWTOVIEWDLG_BMPFILE1, MTHOWTOVIEWDLG_BMPFILE2 };

	_Clear();

	//----------------------------------------------------------------
	//t@CI[v
	//----------------------------------------------------------------
	//vZXst@CfBNgpX擾
	result = YNPathUtil::GetModuleDirPath(bmpFilePath, _MAX_PATH);
	if (result != 0) goto EXIT;

	if (m_PageNo >= 2) {
		result = YN_SET_ERR("Program error.", m_PageNo, 0);
		goto EXIT;
	}

	//BMPt@CpX쐬
	_tcscat_s(bmpFilePath, _MAX_PATH, pBmpFileName[m_PageNo]);

	//BMPt@CJ
	hFile = CreateFile(
				bmpFilePath,			//t@CpX
				GENERIC_READ,			//ANZX^Cv
				0,						//L@
				NULL,					//ZLeB
				OPEN_EXISTING,			//w
				FILE_ATTRIBUTE_NORMAL,	//t@CƃtO
				NULL					//ev[gt@Cnh
			);
	if (hFile == INVALID_HANDLE_VALUE) {
		result = YN_SET_ERR("File open error.", GetLastError(), 0);
		goto EXIT;
	}

	//----------------------------------------------------------------
	//BMPt@Cwb_
	//----------------------------------------------------------------
	//BMPt@Cwb_ǂݍ
	bresult = ReadFile(
					hFile,							//t@Cnh
					(LPBITMAPFILEHEADER)&m_BmpHead,	//obt@ʒu
					sizeof(BITMAPFILEHEADER),		//obt@TCY
					&numOfBytesRead,				//ǂݎTCY
					NULL							//I[o[bv\̃obt@
				);
	if (!bresult) {
		result = YN_SET_ERR("File read error.", GetLastError(), 0);
		goto EXIT;
	}

	//t@C^Cv̊mF "BM"
	if (m_BmpHead.bfType != 0x4D42) {
		result = YN_SET_ERR("Invalid data found.", m_BmpHead.bfType, 0);
		goto EXIT;
	}

	//----------------------------------------------------------------
	//BMPwb_
	//----------------------------------------------------------------
	//BMPwb_ǂݍ
	bresult = ReadFile(
					hFile,							//t@Cnh
					(LPBITMAPINFOHEADER)&m_BmpInfo,	//obt@ʒu
					sizeof(BITMAPINFOHEADER),		//obt@TCY
					&numOfBytesRead,				//ǂݎTCY
					NULL							//I[o[bv\̃obt@
				);
	if (!bresult) {
		result = YN_SET_ERR("File read error.", GetLastError(), 0);
		goto EXIT;
	}

	//24bit摜ȊO͓ǂ݂܂
	if ((m_BmpInfo.biBitCount != 24) || (m_BmpInfo.biClrUsed != 0)) {
		result = YN_SET_ERR("Invalid BMP file.", m_BmpInfo.biBitCount, m_BmpInfo.biClrUsed);
		goto EXIT;
	}

	//----------------------------------------------------------------
	//BMPsNZf[^
	//----------------------------------------------------------------
	//sNZf[^JnʒuɃt@C|C^ݒ
	fp = SetFilePointer(
				hFile,					//t@Cnh
				m_BmpHead.bfOffBits,	//t@C|C^ړoCgF32bit
				0,						//t@C|C^ړoCgF32bit
				FILE_BEGIN				//Jn_
			);
	if (fp == INVALID_SET_FILE_POINTER) {
		result = YN_SET_ERR("File access error.", GetLastError(), m_BmpHead.bfOffBits);
		goto EXIT;
	}

	//sNZf[^ǂݍݗpm
	hMemBmpPixel = GlobalAlloc(GHND, m_BmpHead.bfSize);
	if (hMemBmpPixel == NULL) {
		result = YN_SET_ERR("Could not allocate memory.", 0, 0);
		goto EXIT;
	}
	pBmpPixcel = (BYTE*)GlobalLock(hMemBmpPixel);
	if (pBmpPixcel == NULL) {
		result = YN_SET_ERR("Could not allocate memory.", 0, 0);
		goto EXIT;
	}

	//BMPsNZf[^ǂݍ
	bresult = ReadFile(
					hFile,				//t@Cnh
					pBmpPixcel,			//obt@ʒu
					m_BmpHead.bfSize,	//obt@TCY
					&numOfBytesRead,	//ǂݎTCY
					NULL				//I[o[bv\̃obt@
				);
	if (!bresult) {
		result = YN_SET_ERR("File read error.", GetLastError(), 0);
		goto EXIT;
	}

	m_hMemBmpPixel = hMemBmpPixel;
	m_pBmpPixcel = pBmpPixcel;

EXIT:;
	if (hFile != NULL) {
		CloseHandle(hFile);
	}
	if (result != 0) {
		if (hMemBmpPixel != NULL) {
			GlobalUnlock(hMemBmpPixel);
			GlobalFree(hMemBmpPixel);
		}
	}
	return result;
}

//******************************************************************************
// HowTorbg}bv`
//******************************************************************************
int MTHowToViewDlg::_DrawHowToBmp(
		HWND hDlg
	)
{
	int result = 0;
	int apiresult = 0;
	HDC hdc = NULL;
	HWND hWnd = NULL;
	PAINTSTRUCT ps;

	if (m_pBmpPixcel == NULL) goto EXIT;

	//`ΏۃEBhEnh擾
	hWnd = GetDlgItem(hDlg, IDC_HOWTO_PICTURE);

	//`揀
	hdc = BeginPaint(hWnd, &ps);

	apiresult = SetDIBitsToDevice(
					hdc,					//foCXReLXgnh
					0,						//]捶̍WFx
					0,						//]捶̍WFy
					m_BmpInfo.biWidth,		//]TCYF
					m_BmpInfo.biHeight,		//]TCYF
					0,						//]W̍WFx
					0,						//]W̍WFy
					0,						//Jns
					m_BmpInfo.biHeight,		//s
					m_pBmpPixcel,			//rbg}bvf[^JñAhX
					(BITMAPINFO*)&m_BmpInfo,//BMPwb_
					DIB_RGB_COLORS			//Fw
				);
	if (apiresult == 0) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}

	//`I
	EndPaint(hWnd, &ps);

EXIT:;
	return result;
}

//******************************************************************************
// NA
//******************************************************************************
void MTHowToViewDlg::_Clear()
{
	ZeroMemory(&m_BmpHead, sizeof(BITMAPFILEHEADER));
	ZeroMemory(&m_BmpInfo, sizeof(BITMAPINFO));

	if (m_hMemBmpPixel != NULL) {
		GlobalUnlock(m_hMemBmpPixel);
		GlobalFree(m_hMemBmpPixel);
		m_hMemBmpPixel = NULL;
	}
	m_pBmpPixcel = NULL;
}

//******************************************************************************
// EBhETCYXV
//******************************************************************************
int MTHowToViewDlg::_UpdateWindowSize(
		HWND hDlg
	)
{
	int result = 0;
	BOOL bresult = FALSE;
	unsigned long width = 0;
	unsigned long height = 0;
	RECT wrect, crect;
	int ww, wh, cw, ch, framew, frameh;

	//EBhẼTCY
	GetWindowRect(hDlg, &wrect);
	ww = wrect.right - wrect.left;
	wh = wrect.bottom - wrect.top;

	//NCAg̈̃TCY
	GetClientRect(hDlg, &crect);
	cw = crect.right - crect.left;
	ch = crect.bottom - crect.top;

	//g̃TCY
	framew = ww - cw;
	frameh = wh - ch;

	//NCAg̈Ƀrbg}bv傤ǎ܂悤
	//EBhETCYXV
	width = m_BmpInfo.biWidth + framew;
	height = m_BmpInfo.biHeight + frameh;

	//EBhETCYύX
	bresult = SetWindowPos(
					hDlg,		//EBhEnh
					HWND_TOP,	//zuFZI[_[擪
					0,			//̈ʒu
					0,			//c̈ʒu
					width,		//
					height,		//
					SWP_NOMOVE	//EBhEʒuw
				);
	if (!bresult) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), (DWORD)hDlg);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// HowTorbg}bvXV
//******************************************************************************
int MTHowToViewDlg::_UpdateBmp(
		HWND hDlg
	)
{
	int result = 0;

	//HowTorbg}bvǂݍ
	result = _LoadHowToBmp();
	if (result != 0) goto EXIT;

	//EBhETCYXV
	result = _UpdateWindowSize(hDlg);
	if (result != 0) goto EXIT;

	//ĕ`
	InvalidateRect(
			hDlg,	//EBhEnh
			NULL,	//XV[WwFS
			FALSE	//wiFȂ
		);
	UpdateWindow(hDlg);

EXIT:;
	return result;
}


