#//******************************************************************************
//
// Simple MIDI Library / SMMsgParser
//
// bZ[W̓NX
//
// Copyright (C) 2010-2012 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "SMMsgParser.h"
#include "SMMsgTransmitter.h"

namespace SMIDILib {


//******************************************************************************
// RXgN^
//******************************************************************************
SMMsgParser::SMMsgParser(void)
{
	m_WParam = 0;
	m_LParam = 0;
	m_Msg = MsgUnknown;
}

//******************************************************************************
// fXgN^
//******************************************************************************
SMMsgParser::~SMMsgParser(void)
{
}

//******************************************************************************
// bZ[W
//******************************************************************************
void SMMsgParser::Parse(
		unsigned long wParam,
		unsigned long lParam
	)
{
	m_WParam = wParam;
	m_LParam = lParam;

	switch (m_WParam >> 24) {
		case SM_MSG_PLAY_STATUS:
			m_Msg = MsgPlayStatus;
			break;
		case SM_MSG_TIME:
			m_Msg = MsgPlayTime;
			break;
		case SM_MSG_TEMPO:
			m_Msg = MsgTempo;
			break;
		case SM_MSG_BAR:
			m_Msg = MsgBar;
			break;
		case SM_MSG_BEAT:
			m_Msg = MsgBeat;
			break;
		case SM_MSG_NOTE_OFF:
			m_Msg = MsgNoteOff;
			break;
		case SM_MSG_NOTE_ON:
			m_Msg = MsgNoteOn;
			break;
		case SM_MSG_PITCHBEND:
			m_Msg = MsgPitchBend;
			break;
		case SM_MSG_SKIP_START:
			m_Msg = MsgSkipStart;
			break;
		case SM_MSG_SKIP_END:
			m_Msg = MsgSkipEnd;
			break;
		default:
			m_Msg = MsgUnknown;
	}

	return;
}

//******************************************************************************
// bZ[Wʎ擾
//******************************************************************************
SMMsgParser::Message SMMsgParser::GetMsg()
{
	return m_Msg;
}

//******************************************************************************
// tԎ擾
//******************************************************************************
SMMsgParser::PlayStatus SMMsgParser::GetPlayStatus()
{
	PlayStatus status = StatusUnknown;

	if (m_Msg != MsgPlayStatus) {
		goto EXIT;
	}

	switch (m_LParam) {
		case SM_PLAYSTATUS_STOP:
			status = StatusStop;
			break;
		case SM_PLAYSTATUS_PLAY:
			status = StatusPlay;
			break;
		case SM_PLAYSTATUS_PAUSE:
			status = StatusPause;
			break;
		default:
			status = StatusUnknown;
			break;
	}

EXIT:;
	return status;
}

//******************************************************************************
// tԎ擾ibj
//******************************************************************************
unsigned long SMMsgParser::GetPlayTimeSec()
{
	unsigned long timeSec = 0;

	if (m_Msg != MsgPlayTime) {
		goto EXIT;
	}

	timeSec = (m_WParam & 0x00FFFFFF) / 1000;

EXIT:;
	return timeSec;
}

//******************************************************************************
// tԎ擾i~bj
//******************************************************************************
unsigned long SMMsgParser::GetPlayTimeMSec()
{
	unsigned long timeSec = 0;

	if (m_Msg != MsgPlayTime) {
		goto EXIT;
	}

	timeSec = m_WParam & 0x00FFFFFF;

EXIT:;
	return timeSec;
}

//******************************************************************************
// `bN^C擾
//******************************************************************************
unsigned long SMMsgParser::GetPlayTickTime()
{
	unsigned long tickTime = 0;

	if (m_Msg != MsgPlayTime) {
		goto EXIT;
	}

	tickTime = m_LParam;

EXIT:;
	return tickTime;
}

//******************************************************************************
// e|擾(BPM)
//******************************************************************************
unsigned long SMMsgParser::GetTempoBPM()
{
	unsigned long tempo = 0;
	unsigned long tempoBPM = 0;

	if (m_Msg != MsgTempo) {
		goto EXIT;
	}

	tempo = m_LParam;
	tempoBPM = (60 * 1000 * 1000) / tempo;

EXIT:;
	return tempoBPM;
}

//******************************************************************************
// ߔԍ擾
//******************************************************************************
unsigned long SMMsgParser::GetBarNo()
{
	unsigned long barNo = 0;

	if (m_Msg != MsgBar) {
		goto EXIT;
	}

	barNo = m_LParam;

EXIT:;
	return barNo;
}

//******************************************************************************
// qL擾Fq
//******************************************************************************
unsigned long SMMsgParser::GetBeatNumerator()
{
	unsigned long numerator = 0;

	if (m_Msg != MsgBeat) {
		goto EXIT;
	}

	numerator = m_LParam >> 16;

EXIT:;
	return numerator;
}

//******************************************************************************
// qL擾F
//******************************************************************************
unsigned long SMMsgParser::GetBeatDenominator()
{
	unsigned long denominator = 0;

	if (m_Msg != MsgBeat) {
		goto EXIT;
	}

	denominator = m_LParam & 0x0000FFFF;

EXIT:;
	return denominator;
}

//******************************************************************************
// |[gԍ擾
//******************************************************************************
unsigned char SMMsgParser::GetPortNo()
{
	unsigned char portNo = 0;

	if ((m_Msg != MsgNoteOff) && (m_Msg != MsgNoteOn) && (m_Msg != MsgPitchBend)) {
		goto EXIT;
	}

	portNo = (m_LParam & 0xFF000000) >> 24;

EXIT:;
	return portNo;
}

//******************************************************************************
// m[gF`lԍ擾
//******************************************************************************
unsigned char SMMsgParser::GetChNo()
{
	unsigned char chNo = 0;

	if ((m_Msg != MsgNoteOff) && (m_Msg != MsgNoteOn) && (m_Msg != MsgPitchBend)) {
		goto EXIT;
	}

	chNo = (unsigned char)((m_LParam & 0x00FF0000) >> 16);

EXIT:;
	return chNo;
}

//******************************************************************************
// m[gFm[gԍ擾
//******************************************************************************
unsigned char SMMsgParser::GetNoteNo()
{
	unsigned char noteNo = 0;

	if ((m_Msg != MsgNoteOff) && (m_Msg != MsgNoteOn)) {
		goto EXIT;
	}

	noteNo = (unsigned char)((m_LParam & 0x0000FF00) >> 8);

EXIT:;
	return noteNo;
}

//******************************************************************************
// m[gFxVeB擾
//******************************************************************************
unsigned char SMMsgParser::GetVelocity()
{
	unsigned char velocity = 0;

	if ((m_Msg != MsgNoteOff) && (m_Msg != MsgNoteOn)) {
		goto EXIT;
	}

	velocity = (unsigned char)(m_LParam & 0x000000FF);

EXIT:;
	return velocity;
}

//******************************************************************************
// sb`xh擾
//******************************************************************************
short SMMsgParser::GetPitchBendValue()
{
	short pitchBend = 0;

	if (m_Msg != MsgPitchBend) {
		goto EXIT;
	}

	pitchBend = (short)(m_LParam & 0x0000FFFF);

EXIT:;
	return pitchBend;
}

//******************************************************************************
// sb`xhx擾
//******************************************************************************
unsigned char SMMsgParser::GetPitchBendSensitivity()
{
	unsigned char sensitivity = 0;

	if (m_Msg != MsgPitchBend) {
		goto EXIT;
	}

	sensitivity = (unsigned char)(m_WParam & 0x000000FF);

EXIT:;
	return sensitivity;
}

//******************************************************************************
// XLbvJn擾
//******************************************************************************
SMMsgParser::SkipDirection SMMsgParser::GetSkipStartDirection()
{
	SkipDirection direction = SkipBack;

	if (m_Msg != MsgSkipStart) {
		goto EXIT;
	}

	if (m_LParam == SM_SKIP_BACK) {
		direction = SkipBack;
	}
	else if (m_LParam == SM_SKIP_FORWARD) {
		direction = SkipForward;
	}

EXIT:;
	return direction;
}

//******************************************************************************
// XLbvI擾
//******************************************************************************
unsigned long SMMsgParser::GetSkipEndNotesCount()
{
	unsigned long notesCount = 0;

	if (m_Msg != MsgSkipEnd) {
		goto EXIT;
	}

	notesCount = m_LParam;

EXIT:;
	return notesCount;
}

} // end of namespace

