//******************************************************************************
//
// Simple Base Library / YNErrInfo
//
// G[NX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNErrInfo.h"

namespace YNBaseLib {

//******************************************************************************
// RXgN^
//******************************************************************************
YNErrInfo::YNErrInfo(
		ErrLevel errLevel,
		unsigned long lineNo,
		const TCHAR* pFuncName,
		const TCHAR* pMessage,
		unsigned long errInfo1,
		unsigned long errInfo2
	)
{	
	m_ErrLevel = errLevel;
	m_LineNo = lineNo;
	m_FuncName = pFuncName; 
	m_Message = pMessage;
	m_ErrInfo1 = errInfo1;
	m_ErrInfo2 = errInfo2;
	return;
}

//******************************************************************************
// fXgN^
//******************************************************************************
YNErrInfo::~YNErrInfo(void)
{
}

//******************************************************************************
// G[x擾
//******************************************************************************
YNErrInfo::ErrLevel YNErrInfo::GetErrLevel()
{
	return m_ErrLevel;
}

//******************************************************************************
// sԍ擾
//******************************************************************************
unsigned long YNErrInfo::GetLineNo()
{
	return m_LineNo;
}

//******************************************************************************
// t@C擾
//******************************************************************************
const TCHAR* YNErrInfo::GetFuncName()
{
	return m_FuncName.c_str();
}

//******************************************************************************
// bZ[W擾
//******************************************************************************
const TCHAR* YNErrInfo::GetMessage()
{
	return m_Message.c_str();
}

//******************************************************************************
// G[1擾
//******************************************************************************
unsigned long YNErrInfo::GetErrInfo1()
{
	return m_ErrInfo1;
}

//******************************************************************************
// G[2擾
//******************************************************************************
unsigned long YNErrInfo::GetErrInfo2()
{
	return m_ErrInfo2;
}

} // end of namespace

