//******************************************************************************
//
// MIDITrail / DXCamera
//
// JNX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "DXCamera.h"
#include "YNBaseLib.h"

using namespace YNBaseLib;


//******************************************************************************
// RXgN^
//******************************************************************************
DXCamera::DXCamera(void)
{
	_Clear();
}

//******************************************************************************
// fXgN^
//******************************************************************************
DXCamera::~DXCamera(void)
{
}

//******************************************************************************
// 
//******************************************************************************
int DXCamera::Initialize()
{
	_Clear();
	return 0;
}

//******************************************************************************
// {p[^ݒ
//******************************************************************************
void DXCamera::SetBaseParam(
		float viewAngle,
		float nearPlane,
		float farPlane
	)
{
	m_ViewAngle = viewAngle;
	m_NearPlane = nearPlane;
	m_FarPlane = farPlane;
}

//******************************************************************************
// Jʒuݒ
//******************************************************************************
void DXCamera::SetPosition(
		D3DXVECTOR3 camVector,
		D3DXVECTOR3 camLookAtVector,
		D3DXVECTOR3 camUpVector
	)
{
	m_CamVector = camVector;
	m_CamLookAtVector = camLookAtVector;
	m_CamUpVector = camUpVector;
}

//******************************************************************************
// ϊ
//******************************************************************************
int DXCamera::Transform(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	HRESULT hresult = D3D_OK;
	D3DXMATRIX viewMatrix;
	D3DXMATRIX projMatrix;

	//ˉes擾
	result = _GetProjMatrix(pD3DDevice, &projMatrix);
	if (result != 0) goto EXIT;

	//ˉes_OpCvCɐݒ
	hresult = pD3DDevice->SetTransform(D3DTS_PROJECTION, &projMatrix);
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectX API error.", hresult, 0);
		goto EXIT;
	}

	//r[COs擾
	result = _GetViewMatrix(&viewMatrix);
	if (result != 0) goto EXIT;

	//r[COs_OpCvCɐݒ
	hresult = pD3DDevice->SetTransform(D3DTS_VIEW, &viewMatrix);
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectX API error.", hresult, 0);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// NA
//******************************************************************************
void DXCamera::_Clear()
{
	m_ViewAngle = 45.0f;
	m_NearPlane = 1.0f;
	m_FarPlane = 1000.0f;
	m_CamVector = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	m_CamLookAtVector = D3DXVECTOR3(0.0f, 0.0f, 1.0f);
	m_CamUpVector = D3DXVECTOR3(0.0f, 1.0f, 0.0f);
}

//******************************************************************************
// ˉe擾
//******************************************************************************
int DXCamera::_GetProjMatrix(
		LPDIRECT3DDEVICE9 pD3DDevice,
		D3DXMATRIX* pViewMatrix
	)
{
	int result = 0;
	HRESULT hresult = D3D_OK;
	D3DVIEWPORT9 viewPort;
	float aspect = 0.0f;

	//s񏉊
	D3DXMatrixIdentity(pViewMatrix);

	//r[|[g擾
	hresult = pD3DDevice->GetViewport(&viewPort);
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectX API error.", hresult, 0);
		goto EXIT;
	}

	//AXyNg
	aspect = (float)viewPort.Width / (float)viewPort.Height;
	
	//nˉe}gbNX쐬
	D3DXMatrixPerspectiveFovLH(
			pViewMatrix,				//ꂽs
			D3DXToRadian(m_ViewAngle),	//J̉p
			aspect,						//AXyNg
			m_NearPlane,				//nearv[
			m_FarPlane					//farv[
		);

EXIT:;
	return result;
}

//******************************************************************************
// r[ϊs擾
//******************************************************************************
int DXCamera::_GetViewMatrix(
		D3DXMATRIX* pViewMatrix
	)
{
	int result = 0;

	//r[ϊs񐶐
	D3DXMatrixLookAtLH(
			pViewMatrix,		//쐬ꂽs
			&m_CamVector,		//Jʒu
			&m_CamLookAtVector,	//ړ_
			&m_CamUpVector		//J̏
		);

	return result;
}

