//******************************************************************************
//
// MIDITrail / MTScenePianoRollRainLive
//
// Cuj^psAm[CV[`NX
//
// Copyright (C) 2012 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#pragma once

#include <d3d9.h>
#include <d3dx9.h>
#include "DXDirLight.h"
#include "MTScene.h"
#include "MTFirstPersonCam.h"
#include "MTStars.h"
#include "MTPianoKeyboardCtrlLive.h"
#include "MTNoteRainLive.h"
#include "MTDashboardLive.h"
#include "MTNotePitchBend.h"
#include "SMIDILib.h"

using namespace SMIDILib;


//******************************************************************************
// sAm[CV[`NX
//******************************************************************************
class MTScenePianoRollRainLive : public MTScene
{
public:
	
	//RXgN^^fXgN^
	MTScenePianoRollRainLive(void);
	virtual ~MTScenePianoRollRainLive(void);
	
	//̎擾
	const TCHAR* GetName();
	
	//
	virtual int Create(
			HWND hWnd,
			LPDIRECT3DDEVICE9 pD3DDevice,
			SMSeqData* pSeqData
		);
	
	//ϊ
	int Transform(LPDIRECT3DDEVICE9 pD3DDevice);
	
	//`
	int Draw(LPDIRECT3DDEVICE9 pD3DDevice);
	
	//j
	void Release();
	
	//EBhENbNCxgM
	int OnWindowClicked(
			unsigned long button,
			unsigned long wParam,
			unsigned long lParam
		);
	
	//tJnCxgM
	int OnPlayStart(LPDIRECT3DDEVICE9 pD3DDevice);
	
	//tICxgM
	int OnPlayEnd(LPDIRECT3DDEVICE9 pD3DDevice);
	
	//V[PTbZ[WM
	int OnRecvSequencerMsg(
			unsigned long wParam,
			unsigned long lParam
		);
	
	//߂
	int Rewind();
	
	//_擾^o^
	void GetDefaultViewParam(MTViewParamMap* pParamMap);
	void GetViewParam(MTViewParamMap* pParamMap);
	void SetViewParam(MTViewParamMap* pParamMap);
	
	//_Zbg
	void ResetViewpoint();
	
	//GtFNgݒ
	void SetEffect(MTScene::EffectType type, bool isEnable);
	
protected:
	
	//CgL
	bool m_IsEnableLight;
	
private:
	
	//Cg
	DXDirLight m_DirLight;
	
	//l̃J
	MTFirstPersonCam m_FirstPersonCam;
	
	//`IuWFNg
	MTStars m_Stars;
	MTPianoKeyboardCtrlLive m_PianoKeyboardCtrlLive;
	MTNoteRainLive m_NoteRainLive;
	MTNotePitchBend m_NotePitchBend;
	MTDashboardLive m_DashboardLive;
	
	//}EXړ[h
	bool m_IsMouseCamMode;
	
	//][h
	bool m_IsAutoRollMode;
	
	//_
	MTViewParamMap m_ViewParamMap;
	
	void _Reset();
	
};

