//******************************************************************************
//
// Simple MIDI Library / SMInDevCtrl
//
// MIDI̓foCXNX
//
// Copyright (C) 2012 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#pragma once

#ifdef SMIDILIB_EXPORTS
#define SMIDILIB_API __declspec(dllexport)
#else
#define SMIDILIB_API __declspec(dllimport)
#endif

#include <list>
#include "mmsystem.h"
#include "SMEvent.h"

#pragma warning(disable:4251)

namespace SMIDILib {


//******************************************************************************
// p[^`
//******************************************************************************
//MIDICxgǂݍ݃R[obN֐
typedef int (*SMInReadCallBack)(SMEvent* pEvent, void* pUserParam);

//VXeGNXN[Vupobt@TCY
//  TCY͓̍ɂȂ
#define SM_MIDIIN_BUF_SIZE  (1024 * 10)


//******************************************************************************
// MIDI̓foCXNX
//******************************************************************************
class SMIDILIB_API SMInDevCtrl
{
public:
	
	//RXgN^^fXgN^
	SMInDevCtrl(void);
	virtual ~SMInDevCtrl(void);
	
	//
	int Initialize();
	
	//foCX擾
	unsigned long GetDevNum();
	
	//foCXv_Ng̎擾
	int GetDevProductName(unsigned long index, std::string& name);
	
	//|[gΉfoCXo^
	int SetPortDev(const char* pProductName);
	
	//MIDICxgǂݍ݃R[obN֐o^
	void SetInReadCallBack(SMInReadCallBack pCallBack, void* pUserParam);
	
	//SfoCX̃I[v^N[Y
	int OpenPortDev();
	int ClosePortDev();
	
	//|[gNA
	int ClearPortInfo();
	
private:
	
	//|[g
	typedef struct {
		bool isExist;
		unsigned long devId;
		HMIDIIN hMidiIn;
		MIDIHDR midiHdr;
	} SMPortInfo;
	
	//foCX
	typedef struct {
		unsigned long devId;
		char productName[MAXPNAMELEN];
	} SMInDevInfo;
	
	//̓foCXXg
	typedef std::list<SMInDevInfo> SMInDevList;
	typedef std::list<SMInDevInfo>::iterator SMInDevListItr;
	SMInDevList m_InDevList;
	
	//|[g
	SMPortInfo m_PortInfo;
	
	//R[obN֐
	SMInReadCallBack m_pInReadCallBack;
	void* m_pCallBackUserParam;
	
	//pPbg͌n
	bool m_isContinueSysEx;
	
	int _InitDevList();
	static void CALLBACK _InReadCallBack(
			HMIDIIN hMidiIn,
			UINT wMsg,
			DWORD dwInstance,
			DWORD dwParam1,
			DWORD dwParam2
		);
	void _InReadProc(
			HMIDIIN hMidiIn,
			UINT wMsg,
			DWORD dwParam1,
			DWORD dwParam2
		);
	int _InReadProcMIDI(
			DWORD midiMessage,
			DWORD timestamp,
			SMEvent* pEvent
		);
	int _InReadProcSysEx(
			MIDIHDR* pMIDIHDR,
			DWORD timestamp,
			bool* pIsContinueSysEx,
			SMEvent* pEvent
		);
	unsigned long _GetMIDIMsgSize(unsigned char status);
	unsigned long _GetSysMsgSize(unsigned char status);
	
};

} // end of namespace

#pragma warning(default:4251)


