//******************************************************************************
//
// MIDITrail / MTDashboardLive
//
// Cuj^p_bV{[h`NX
//
// Copyright (C) 2012 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "MTParam.h"
#include "MTConfFile.h"
#include "MTDashboardLive.h"

using namespace YNBaseLib;


//******************************************************************************
// RXgN^
//******************************************************************************
MTDashboardLive::MTDashboardLive(void)
{
	m_hWnd = NULL;
	m_PosCounterX = 0.0f;
	m_PosCounterY = 0.0f;
	m_CounterMag = MTDASHBOARDLIVE_DEFAULT_MAGRATE;
	m_isMonitoring = false;
	m_NoteCount = 0;
	m_CaptionColor = D3DXCOLOR(1.0f, 1.0f, 1.0f, 1.0f);
	m_isEnable = true;
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTDashboardLive::~MTDashboardLive(void)
{
	Release();
}

//******************************************************************************
// _bV{[h
//******************************************************************************
int MTDashboardLive::Create(
		LPDIRECT3DDEVICE9 pD3DDevice,
		const TCHAR* pSceneName,
		HWND hWnd
   )
{
	int result = 0;
	TCHAR counter[100];
	
	Release();
	
	m_hWnd = hWnd;
	
	//ݒǂݍ
	result = _LoadConfFile(pSceneName);
	if (result != 0) goto EXIT;
	
	//^CgLvV
	result = SetMIDIINDeviceName(pD3DDevice, _T(""));
	if (result != 0) goto EXIT;
	
	//JE^LvV
	result = m_Counter.Create(
					pD3DDevice,
					MTDASHBOARDLIVE_FONTNAME,		//tHg
					MTDASHBOARDLIVE_FONTSIZE,		//tHgTCY
					MTDASHBOARDLIVE_COUNTER_CHARS,	//\
					MTDASHBOARDLIVE_COUNTER_SIZE	//LvVTCY
				);
	if (result != 0) goto EXIT;
	m_Counter.SetColor(m_CaptionColor);
	
	//JE^\񐶐
	result = _GetCounterStr(counter, 100);
	if (result != 0) goto EXIT;
	
	result = m_Counter.SetString(counter);
	if (result != 0) goto EXIT;
	
	//JE^\ʒuZo
	result = _GetCounterPos(&m_PosCounterX, &m_PosCounterY);
	if (result != 0) goto EXIT;
	
EXIT:;
	return result;
}

//******************************************************************************
// ړ
//******************************************************************************
int MTDashboardLive::Transform(
		LPDIRECT3DDEVICE9 pD3DDevice,
		D3DXVECTOR3 camVector
	)
{
	int result = 0;
	return result;
}

//******************************************************************************
// `
//******************************************************************************
int MTDashboardLive::Draw(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	TCHAR counter[100];
	
	if (pD3DDevice == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}
	
	if (!m_isEnable) goto EXIT;
	
	//^Cg`FJE^Ɠg嗦ŕ\
	result = m_Title.Draw(pD3DDevice, MTDASHBOARDLIVE_FRAMESIZE, MTDASHBOARDLIVE_FRAMESIZE, m_CounterMag);
	if (result != 0) goto EXIT;
	
	//JE^`
	result = _GetCounterStr(counter, 100);
	if (result != 0) goto EXIT;
	
	result = m_Counter.SetString(counter);
	if (result != 0) goto EXIT;
	
	result = m_Counter.Draw(pD3DDevice, m_PosCounterX, m_PosCounterY, m_CounterMag);
	if (result != 0) goto EXIT;
	
EXIT:;
	return result;
}

//******************************************************************************
// 
//******************************************************************************
void MTDashboardLive::Release()
{
	m_Title.Release();
	m_Counter.Release();
}

//******************************************************************************
// JE^\ʒu擾
//******************************************************************************
int MTDashboardLive::_GetCounterPos(
		float* pX,
		float* pY
	)
{
	int result = 0;
	BOOL bresult = 0;
	RECT rect;
	unsigned long cw, ch = 0;
	unsigned long tw, th = 0;
	unsigned long charHeight, charWidth = 0;
	unsigned long captionWidth = 0;
	float newMag = 0.0f;
	
	//NCAg̈̃TCY擾
	bresult = GetClientRect(m_hWnd, &rect);
	if (!bresult) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}
	cw = rect.right - rect.left;
	ch = rect.bottom - rect.top;
	
	//eNX`TCY擾
	m_Counter.GetTextureSize(&th, &tw);
	
	//TCY
	charHeight = th;
	charWidth = tw / _tcslen(MTDASHBOARDLIVE_COUNTER_CHARS);
	
	//g嗦1.0̃LvVTCY
	captionWidth = (unsigned long)(charWidth * MTDASHBOARDLIVE_COUNTER_SIZE);
	
	//JE^񂪉ʂ͂ݏoꍇ͉ʂɎ܂悤Ɋg嗦XV
	//  ^Cg͂ݏô͋CɂȂƂɂ
	if (((cw - (MTDASHBOARDLIVE_FRAMESIZE*2)) < captionWidth) && (tw > 0)) {
		newMag = (float)(cw - (MTDASHBOARDLIVE_FRAMESIZE*2)) / (float)captionWidth;
		if (m_CounterMag > newMag) {
			m_CounterMag = newMag;
		}
	}
	
	//eNX`̕\{lĕ\ʒuZo
	*pX = MTDASHBOARDLIVE_FRAMESIZE;
	*pY = (float)ch - ((float)th * m_CounterMag) - MTDASHBOARDLIVE_FRAMESIZE;

EXIT:;
	return result;
}

//******************************************************************************
// j^ԓo^
//******************************************************************************
void MTDashboardLive::SetMonitoringStatus(
		bool isMonitoring
	)
{
	m_isMonitoring = isMonitoring;
}

//******************************************************************************
// m[gONo^
//******************************************************************************
void MTDashboardLive::SetNoteOn()
{
	m_NoteCount++;
}

//******************************************************************************
// JE^擾
//******************************************************************************
int MTDashboardLive::_GetCounterStr(
		TCHAR* pStr,
		unsigned long bufSize
	)
{
	int result = 0;
	int eresult = 0;
	const TCHAR* pMonitorStatus = _T("");
	
	if (m_isMonitoring) {
		pMonitorStatus = _T("");
	}
	else {
		pMonitorStatus = _T("[MONITERING OFF]");
	}
	
	eresult = _stprintf_s(
				pStr,
				bufSize,
				_T("NOTES:%08lu %s"),
				m_NoteCount,
				pMonitorStatus
			);
	if (eresult < 0) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}
	
EXIT:;
	return result;
}

//******************************************************************************
// Zbg
//******************************************************************************
void MTDashboardLive::Reset()
{
	m_isMonitoring = false;
	m_NoteCount = 0;
}

//******************************************************************************
// ݒt@Cǂݍ
//******************************************************************************
int MTDashboardLive::_LoadConfFile(
		const TCHAR* pSceneName
	)
{
	int result = 0;
	TCHAR hexColor[16] = {_T('\0')};
	MTConfFile confFile;
	
	result = confFile.Initialize(pSceneName);
	if (result != 0) goto EXIT;
	
	//----------------------------------
	//F
	//----------------------------------
	result = confFile.SetCurSection(_T("Color"));
	if (result != 0) goto EXIT;
	
	//LvVJ[
	result = confFile.GetStr(_T("CaptionRGBA"), hexColor, 16, _T("FFFFFFFF"));
	if (result != 0) goto EXIT;
	m_CaptionColor = DXColorUtil::MakeColorFromHexRGBA(hexColor);
	
EXIT:;
	return result;
}

//******************************************************************************
// \ݒ
//******************************************************************************
void MTDashboardLive::SetEnable(
		bool isEnable
	)
{
	m_isEnable = isEnable;
}

//******************************************************************************
//MIDI IN foCXo^
//******************************************************************************
int MTDashboardLive::SetMIDIINDeviceName(
		LPDIRECT3DDEVICE9 pD3DDevice,
		const TCHAR* pName
	)
{
	int result = 0;
	int eresult = 0;
	TCHAR title[256] = {0}; //MAXPNAMELEN 32 傫TCYɂ
	const TCHAR* pDisplayName = NULL;
	
	m_Title.Release();
	
	if (pName == NULL) {
		pDisplayName = _T("(none)");
	}
	else if (_tcslen(pName) == 0) {
		pDisplayName = _T("(none)");
	}
	else {
		pDisplayName = pName;
	}
	
	//^CgLvV
	eresult = _stprintf_s(
				title,
				256,
				_T("MIDI IN: %s"),
				pDisplayName
			);

	result = m_Title.Create(
					pD3DDevice,					//foCX
					MTDASHBOARDLIVE_FONTNAME,	//tHg
					MTDASHBOARDLIVE_FONTSIZE,	//tHgTCY
					title						//LvV
				);
	if (result != 0) goto EXIT;
	m_Title.SetColor(m_CaptionColor);

EXIT:;
	return result;
}


