//******************************************************************************
//
// MIDITrail / MTScenePianoRollRainLive
//
// Cuj^psAm[CV[`NX
//
// Copyright (C) 2012-2013 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// MEMO:
// Windowsł̃\[XڐAĂ邽߁AW͍n(DirectX)ŏĂB
// n(DirectX)=>En(OpenGL)ւ̕ϊ LH2RH }NŎB

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "DXColorUtil.h"
#include "MTConfFile.h"
#include "MTScenePianoRollRainLive.h"

using namespace YNBaseLib;


//******************************************************************************
// RXgN^
//******************************************************************************
MTScenePianoRollRainLive::MTScenePianoRollRainLive(void)
{
	m_IsEnableLight = true;
	m_IsSingleKeyboard = false;
	m_IsMouseCamMode = false;
	m_IsAutoRollMode = false;
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTScenePianoRollRainLive::~MTScenePianoRollRainLive(void)
{
	Release();
}

//******************************************************************************
// ̎擾
//******************************************************************************
const TCHAR* MTScenePianoRollRainLive::GetName()
{
	return _T("PianoRollRainLive");
}

//******************************************************************************
// V[
//******************************************************************************
int MTScenePianoRollRainLive::Create(
		HWND hWnd,
		LPDIRECT3DDEVICE9 pD3DDevice,
		SMSeqData* pSeqData
	)
{
	int result = 0;
	
	Release();
	
	if (pD3DDevice == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}
	
	//ݒt@Cǂݍ
	result = _LoadConf();
	if (result != 0) goto EXIT;
	
	//----------------------------------
	// J
	//----------------------------------
	//J
	result = m_FirstPersonCam.Initialize(hWnd, GetName(), pSeqData);
	if (result != 0) goto EXIT;
	
	//is
	m_FirstPersonCam.SetProgressDirection(MTFirstPersonCam::DirY);
	
	//ftHg_擾
	GetDefaultViewParam(&m_ViewParamMap);
	
	//_ݒ
	SetViewParam(&m_ViewParamMap);
	
	//----------------------------------
	// Cg
	//----------------------------------
	//Cg
	result = m_DirLight.Initialize();
	if (result != 0) goto EXIT;
	
	//Cg
	//  _ƂĂ̕xNgŕ\
	//m_DirLight.SetDirection(D3DXVECTOR3(1.0f, -1.0f, 2.0f));
	m_DirLight.SetDirection(D3DXVECTOR3(1.0f, -2.0f, 0.5f));
	
	//Cg̃foCXo^
	result = m_DirLight.SetDevice(pD3DDevice, m_IsEnableLight);
	if (result != 0) goto EXIT;
	
	//----------------------------------
	// `IuWFNg
	//----------------------------------
	//sb`xh񏉊
	result = m_NotePitchBend.Initialize();
	if (result != 0) goto EXIT;
	
	//VOL[{[h̓sb`xh
	if (m_IsSingleKeyboard) {
		m_NotePitchBend.SetEnable(false);
	}
	else {
		m_NotePitchBend.SetEnable(true);
	}
	
	//sAmL[{[h
	result = m_PianoKeyboardCtrlLive.Create(pD3DDevice, GetName(), &m_NotePitchBend, m_IsSingleKeyboard);
	if (result != 0) goto EXIT;
	
	//m[gC
	result = m_NoteRainLive.Create(pD3DDevice, GetName(), &m_NotePitchBend);
	if (result != 0) goto EXIT;
	
	//_bV{[h
	result = m_DashboardLive.Create(pD3DDevice, GetName(), hWnd);
	if (result != 0) goto EXIT;
	
	//
	result = m_Stars.Create(pD3DDevice, GetName(), &m_DirLight);
	if (result != 0) goto EXIT;
	
	//bV䐶
	result = m_MeshCtrl.Create(pD3DDevice, GetName());
	if (result != 0) goto EXIT;

	//----------------------------------
	// _OXe[g
	//----------------------------------
	//ʕ`惂[h
	//|S͕`悵ȂiJOj邱Ƃɂ蕉ׂ
	//pD3DDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_NONE); //JOȂ
	pD3DDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_CCW); //JO
	
	//Z[xrFON
	pD3DDevice->SetRenderState(D3DRS_ZENABLE, TRUE);
	
	//fBUO:ON i`
	pD3DDevice->SetRenderState(D3DRS_DITHERENABLE, TRUE);
	
	//}`TvOA`GCAXFL
	pD3DDevice->SetRenderState(D3DRS_MULTISAMPLEANTIALIAS, TRUE);
	
	//_OXe[gݒFʏ̃At@
	pD3DDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE);
	pD3DDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
	pD3DDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);
	
EXIT:;
	return result;
}

//******************************************************************************
// ϊ
//******************************************************************************
int MTScenePianoRollRainLive::Transform(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	float rollAngle = 0.0f;
	D3DXVECTOR3 camVector;
	D3DXVECTOR3 moveVector;
	
	if (pD3DDevice == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}
	
	//JXV
	result = m_FirstPersonCam.Transform(pD3DDevice);
	if (result != 0) goto EXIT;
	
	//JW擾
	 m_FirstPersonCam.GetPosition(&camVector);
	
	//]px擾
	rollAngle = m_FirstPersonCam.GetManualRollAngle();
	
	//sAmL[{[hXV
	result = m_PianoKeyboardCtrlLive.Transform(pD3DDevice, rollAngle);
	if (result != 0) goto EXIT;
	
	//m[gCXV
	result = m_NoteRainLive.Transform(pD3DDevice, rollAngle);
	if (result != 0) goto EXIT;
	
	//_bV{[hXV
	result = m_DashboardLive.Transform(pD3DDevice, camVector);
	if (result != 0) goto EXIT;
	
	//XV
	result = m_Stars.Transform(pD3DDevice, camVector);
	if (result != 0) goto EXIT;
	
	//bVXV
	moveVector = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	result = m_MeshCtrl.Transform(pD3DDevice, moveVector);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// `
//******************************************************************************
int MTScenePianoRollRainLive::Draw(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	
	if (pD3DDevice == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}
	
	//XV
	result = Transform(pD3DDevice);
	if (result != 0) goto EXIT;
	
	//sAmL[{[h`
	result = m_PianoKeyboardCtrlLive.Draw(pD3DDevice);
	if (result != 0) goto EXIT;
	
	//m[gCXV
	result = m_NoteRainLive.Draw(pD3DDevice);
	if (result != 0) goto EXIT;
	
	//`
	result = m_Stars.Draw(pD3DDevice);
	if (result != 0) goto EXIT;
	
	//bV`
	result = m_MeshCtrl.Draw(pD3DDevice);
	if (result != 0) goto EXIT;
	
	//_bV{[h`Fˉê߈ԍŌɕ`悷
	result = m_DashboardLive.Draw(pD3DDevice);
	if (result != 0) goto EXIT;
	
EXIT:;
	return result;
}

//******************************************************************************
// j
//******************************************************************************
void MTScenePianoRollRainLive::Release()
{
	m_PianoKeyboardCtrlLive.Release();
	m_NoteRainLive.Release();
	m_DashboardLive.Release();
	m_Stars.Release();
	m_MeshCtrl.Release();
}

//******************************************************************************
// EBhENbNCxgM
//******************************************************************************
int MTScenePianoRollRainLive::OnWindowClicked(
		unsigned long button,
		unsigned long wParam,
		unsigned long lParam
	)
{
	int result = 0;
	
	//{^
	if (button == WM_LBUTTONDOWN) {
		// ON/OFF
		m_IsMouseCamMode = m_IsMouseCamMode ? false : true;
		m_FirstPersonCam.SetMouseCamMode(m_IsMouseCamMode);
	}
	//E{^
	else if (button == WM_RBUTTONDOWN) {
		//Ȃ
	}
	//{^
	else if (button == WM_MBUTTONDOWN) {
		//][h ON/OFF
		m_IsAutoRollMode = m_IsAutoRollMode ? false : true;
		m_FirstPersonCam.SetAutoRollMode(m_IsAutoRollMode);
		if (m_IsAutoRollMode) {
			m_FirstPersonCam.SwitchAutoRllDirecton();
		}
	}
	
	return result;
}

//******************************************************************************
// tJnCxgM
//******************************************************************************
int MTScenePianoRollRainLive::OnPlayStart(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	
	_Reset();
	
	m_DashboardLive.SetMonitoringStatus(true);
	result = m_DashboardLive.SetMIDIINDeviceName(pD3DDevice, GetParam(_T("MIDI_IN_DEVICE_NAME")));
	if (result != 0) goto EXIT;
	
EXIT:;
	return result;
}

//******************************************************************************
// tICxgM
//******************************************************************************
int MTScenePianoRollRainLive::OnPlayEnd(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	
	m_NoteRainLive.AllNoteOff();
	m_PianoKeyboardCtrlLive.AllNoteOff();
	
	m_DashboardLive.SetMonitoringStatus(false);
	
//EXIT:;
	return result;
}

//******************************************************************************
// V[PTbZ[WM
//******************************************************************************
int MTScenePianoRollRainLive::OnRecvSequencerMsg(
		unsigned long wParam,
		unsigned long lParam
	)
{
	int result = 0;
	SMMsgParser parser;
	
	parser.Parse(wParam, lParam);
	
	//tԒʒm
	if (parser.GetMsg() == SMMsgParser::MsgPlayStatus) {
		if (parser.GetPlayStatus() == SMMsgParser::StatusStop) {
			//~iIj
		}
		else if (parser.GetPlayStatus() == SMMsgParser::StatusPlay) {
			//t
		}
		else if (parser.GetPlayStatus() == SMMsgParser::StatusPause) {
			//ꎞ~
		}
	}
	//m[gOFFʒm
	else if (parser.GetMsg() == SMMsgParser::MsgNoteOff) {
		m_NoteRainLive.SetNoteOff(parser.GetPortNo(), parser.GetChNo(), parser.GetNoteNo());
		m_PianoKeyboardCtrlLive.SetNoteOff(parser.GetPortNo(), parser.GetChNo(), parser.GetNoteNo());
	}
	//m[gONʒm
	else if (parser.GetMsg() == SMMsgParser::MsgNoteOn) {
		m_DashboardLive.SetNoteOn();
		m_NoteRainLive.SetNoteOn(parser.GetPortNo(), parser.GetChNo(), parser.GetNoteNo(), parser.GetVelocity());
		m_PianoKeyboardCtrlLive.SetNoteOn(parser.GetPortNo(), parser.GetChNo(), parser.GetNoteNo(), parser.GetVelocity());
	}
	//sb`xhʒm
	else if (parser.GetMsg() == SMMsgParser::MsgPitchBend) {
		m_NotePitchBend.SetPitchBend(
							parser.GetPortNo(),
							parser.GetChNo(),
							parser.GetPitchBendValue(),
							parser.GetPitchBendSensitivity()
						);
	}
	//I[m[gOFFʒm
	else if (parser.GetMsg() == SMMsgParser::MsgAllNoteOff) {
		m_NoteRainLive.AllNoteOffOnCh(parser.GetPortNo(), parser.GetChNo());
		m_PianoKeyboardCtrlLive.AllNoteOffOnCh(parser.GetPortNo(), parser.GetChNo());
	}
	
//EXIT:;
	return result;
}

//******************************************************************************
// ߂
//******************************************************************************
int MTScenePianoRollRainLive::Rewind()
{
	int result = 0;
	
	_Reset();
	
	//_ݒ
	SetViewParam(&m_ViewParamMap);
	
	return result;
}

//******************************************************************************
// Zbg
//******************************************************************************
void MTScenePianoRollRainLive::_Reset()
{
	m_DashboardLive.Reset();
	m_FirstPersonCam.Reset();
	m_PianoKeyboardCtrlLive.Reset();
	m_NoteRainLive.Reset();
	m_NotePitchBend.Reset();
}

//******************************************************************************
// ftHg_擾
//******************************************************************************
void MTScenePianoRollRainLive::GetDefaultViewParam(
		MTViewParamMap* pParamMap
	)
{
	D3DXVECTOR3 viewPointVector;
	float phi, theta = 0.0f;
	
	//_쐬
	viewPointVector.x = 0.0f;
	viewPointVector.y = 0.0f;
	viewPointVector.z = -(1.5f * 16.0f / 2.0f) - 10.0f;
	phi   = 90.0f;	//+Z
	theta = 90.0f;	//+Z
	
	pParamMap->clear();
	pParamMap->insert(MTViewParamMapPair("X", viewPointVector.x));
	pParamMap->insert(MTViewParamMapPair("Y", viewPointVector.y));
	pParamMap->insert(MTViewParamMapPair("Z", viewPointVector.z));
	pParamMap->insert(MTViewParamMapPair("Phi", phi));
	pParamMap->insert(MTViewParamMapPair("Theta", theta));
	pParamMap->insert(MTViewParamMapPair("ManualRollAngle", 0.0f));
	pParamMap->insert(MTViewParamMapPair("AutoRollVelocity", 0.0f));
	
	return;
}

//******************************************************************************
// _擾
//******************************************************************************
void MTScenePianoRollRainLive::GetViewParam(
		MTViewParamMap* pParamMap
	)
{
	D3DXVECTOR3 viewPointVector;
	float phi, theta = 0.0f;
	float manualRollAngle = 0.0f;
	float autoRollVelocity = 0.0f;
	
	//J̈ʒuƕ擾
	m_FirstPersonCam.GetPosition(&viewPointVector);
	m_FirstPersonCam.GetDirection(&phi, &theta);
	
	//m[gړɃJƃL[{[hړꍇ
	//Đʂɑ΂鎋_ł邽Y͍Đʒul
	//viewPointVector.y -= m_NoteRain.GetPos();
	
	//]px擾
	manualRollAngle = m_FirstPersonCam.GetManualRollAngle();
	if (m_IsAutoRollMode) {
		autoRollVelocity = m_FirstPersonCam.GetAutoRollVelocity();
	}
	
	pParamMap->clear();
	pParamMap->insert(MTViewParamMapPair("X", viewPointVector.x));
	pParamMap->insert(MTViewParamMapPair("Y", viewPointVector.y));
	pParamMap->insert(MTViewParamMapPair("Z", viewPointVector.z));
	pParamMap->insert(MTViewParamMapPair("Phi", phi));
	pParamMap->insert(MTViewParamMapPair("Theta", theta));
	pParamMap->insert(MTViewParamMapPair("ManualRollAngle", manualRollAngle));
	pParamMap->insert(MTViewParamMapPair("AutoRollVelocity", autoRollVelocity));
	
	return;
}

//******************************************************************************
// _o^
//******************************************************************************
void MTScenePianoRollRainLive::SetViewParam(
		MTViewParamMap* pParamMap
	)
{
	D3DXVECTOR3 viewPointVector = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	float phi, theta = 0.0f;
	float manualRollAngle = 0.0f;
	float autoRollVelocity = 0.0f;
	MTViewParamMap::iterator itr;
	
	itr = pParamMap->find("X");
	if (itr != pParamMap->end()) {
		viewPointVector.x = itr->second;
	}
	itr = pParamMap->find("Y");
	if (itr != pParamMap->end()) {
		viewPointVector.y = itr->second;
	}
	itr = pParamMap->find("Z");
	if (itr != pParamMap->end()) {
		viewPointVector.z = itr->second;
	}
	itr = pParamMap->find("Phi");
	if (itr != pParamMap->end()) {
		phi = itr->second;
	}
	itr = pParamMap->find("Theta");
	if (itr != pParamMap->end()) {
		theta = itr->second;
	}
	itr = pParamMap->find("ManualRollAngle");
	if (itr != pParamMap->end()) {
		manualRollAngle = itr->second;
	}
	itr = pParamMap->find("AutoRollVelocity");
	if (itr != pParamMap->end()) {
		autoRollVelocity = itr->second;
	}
	
	//m[gړɃJƃL[{[hړꍇ
	//Đʂɑ΂鎋_ł邽Y͍Đʒul
	//viewPointVector.y += m_NoteRain.GetPos();
	
	//J̈ʒuƕݒ
	m_FirstPersonCam.SetPosition(viewPointVector);
	m_FirstPersonCam.SetDirection(phi, theta);
	
	//蓮]pxݒ
	m_FirstPersonCam.SetManualRollAngle(manualRollAngle);
	
	//]xݒ
	m_IsAutoRollMode = false;
	if (autoRollVelocity != 0.0f) {
		m_IsAutoRollMode = true;
		m_FirstPersonCam.SetAutoRollVelocity(autoRollVelocity);
	}
	m_FirstPersonCam.SetAutoRollMode(m_IsAutoRollMode);
	
	//p[^̕ۑ
	if (pParamMap != (&m_ViewParamMap)) {
		m_ViewParamMap.clear();
		for (itr = pParamMap->begin(); itr != pParamMap->end(); itr++) {
			m_ViewParamMap.insert(MTViewParamMapPair(itr->first, itr->second));
		}
	}
	
	return;
}

//******************************************************************************
// _Zbg
//******************************************************************************
void MTScenePianoRollRainLive::ResetViewpoint()
{
	MTViewParamMap paramMap;
	
	//ftHg_擾
	GetDefaultViewParam(&paramMap);
	
	//_o^
	SetViewParam(&paramMap);
}

//******************************************************************************
// \ʐݒ
//******************************************************************************
void MTScenePianoRollRainLive::SetEffect(
		MTScene::EffectType type,
		bool isEnable
	)
{
	switch (type) {
		case EffectPianoKeyboard:
			m_PianoKeyboardCtrlLive.SetEnable(isEnable);
			break;
		case EffectRipple:
			break;
		case EffectPitchBend:
			if (!m_IsSingleKeyboard) {
				m_NotePitchBend.SetEnable(isEnable);
			}
			break;
		case EffectStars:
			m_Stars.SetEnable(isEnable);
			break;
		case EffectCounter:
			m_DashboardLive.SetEnable(isEnable);
			break;
		default:
			break;
	}
	
	return;
}

//******************************************************************************
// ݒt@Cǂݍ
//******************************************************************************
int MTScenePianoRollRainLive::_LoadConf()
{
	int result = 0;
	TCHAR hexColor[16] = {_T('\0')};
	MTConfFile confFile;

	result = confFile.Initialize(GetName());
	if (result != 0) goto EXIT;

	result = confFile.SetCurSection(_T("Color"));
	if (result != 0) goto EXIT;

	result = confFile.GetStr(_T("BackGroundRGB"), hexColor, 16, _T("000000"));
	if (result != 0) goto EXIT;

	SetBGColor(DXColorUtil::MakeColorFromHexRGBA(hexColor));

EXIT:;
	return result;
}

