//******************************************************************************
//
// MIDITrail / MTStars
//
// `NX
//
// Copyright (C) 2010-2012 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// MEMO:
// _ɔzuĕ`悷B

#pragma once

#include <d3d9.h>
#include <d3dx9.h>
#include "DXDirLight.h"
#include "DXPrimitive.h"


//******************************************************************************
// `NX
//******************************************************************************
class MTStars
{
public:

	//RXgN^^fXgN^
	MTStars(void);
	virtual ~MTStars(void);

	//
	int Create(LPDIRECT3DDEVICE9 pD3DDevice, const TCHAR* pSceneName, DXDirLight* pLight);

	//XV
	int Transform(LPDIRECT3DDEVICE9 pD3DDevice, D3DXVECTOR3 camVector);

	//`
	int Draw(LPDIRECT3DDEVICE9 pD3DDevice);

	//j
	void Release();

	//\ݒ
	void SetEnable(bool isEnable);

private:

	int m_NumOfStars;
	DXPrimitive m_Primitive;
	LPDIRECT3DTEXTURE9 m_pTexture;

	//\
	bool m_isEnable;

	//_obt@\
	struct MTSTARS_VERTEX {
		D3DXVECTOR3 p;		//_W
		D3DXVECTOR3 n;		//@
		DWORD		c;		//fBt[YF
	};

	//_obt@FVFtH[}bg
	DWORD _GetFVFFormat(){ return (D3DFVF_XYZ | D3DFVF_NORMAL | D3DFVF_DIFFUSE); }

	int _CreateVertexOfStars(MTSTARS_VERTEX* pVertex, DXDirLight* pLight);
	void _MakeMaterial(D3DMATERIAL9* pMaterial);
	int _LoadConfFile(const TCHAR* pSceneName);

};


