//******************************************************************************
//
// Simple MIDI Library / SMInDevCtrl
//
// MIDI̓foCXNX
//
// Copyright (C) 2012 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "SMInDevCtrl.h"

using namespace YNBaseLib;

namespace SMIDILib {


//******************************************************************************
// RXgN^
//******************************************************************************
SMInDevCtrl::SMInDevCtrl(void)
{
	//|[g
	m_PortInfo.isExist = false;
	m_PortInfo.devId = 0;
	m_PortInfo.hMidiIn = NULL;
	memset((void*)&(m_PortInfo.midiHdr), 0, sizeof(MIDIHDR));
	
	//R[obN֐
	m_pInReadCallBack = NULL;
	m_pCallBackUserParam = NULL;
	
	//pPbg͌n
	m_isContinueSysEx = false;
}

//******************************************************************************
// fXgN^
//******************************************************************************
SMInDevCtrl::~SMInDevCtrl()
{
	m_InDevList.clear();
	ClosePortDev();
}

//******************************************************************************
// 
//******************************************************************************
int SMInDevCtrl::Initialize()
{
	int result = 0;
	
	//|[gNA
	result = ClearPortInfo();
	if (result != 0) goto EXIT;
	
	//MIDI̓foCXꗗ쐬
	result = _InitDevList();
	if (result != 0) goto EXIT;
	
EXIT:;
	return result;
}

//******************************************************************************
// foCXXg
//******************************************************************************
int SMInDevCtrl::_InitDevList()
{
	int result = 0;
	MMRESULT apiresult = 0;
	unsigned long devId = 0;
	unsigned long devNum = 0;
	MIDIINCAPS mic;
	SMInDevInfo devInfo;

	m_InDevList.clear();

	//MIDIo̓foCX̐
	devNum = midiInGetNumDevs();

	//MIDIo̓foCX̏擾
	for (devId = 0; devId < devNum; devId++) {

		ZeroMemory(&mic, sizeof(MIDIINCAPS));
		ZeroMemory(&devInfo, sizeof(SMInDevInfo));

		apiresult= midiInGetDevCaps(devId, &mic, sizeof(MIDIINCAPS));
		if (apiresult != MMSYSERR_NOERROR) {
			result = YN_SET_ERR("MIDI In device access error.", apiresult, 0);
			goto EXIT;
		}
		devInfo.devId = devId;
		memcpy(devInfo.productName, mic.szPname, MAXPNAMELEN);

		//擾Xgɓo^
		m_InDevList.push_back(devInfo);
	}
	
EXIT:;
	return result;
}

//******************************************************************************
// foCX擾
//******************************************************************************
unsigned long SMInDevCtrl::GetDevNum()
{
	return m_InDevList.size();
}

//******************************************************************************
// foCXv_Ng̎擾
//******************************************************************************
int SMInDevCtrl::GetDevProductName(
		unsigned long index,
		std::string& name
	)
{
	int result = 0;
	SMInDevListItr itr;
	
	if (index >= m_InDevList.size()) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}
	
	itr = m_InDevList.begin();
	advance(itr, index);
	
	name = itr->productName;
	
EXIT:;
	return result;
}

//******************************************************************************
// |[gɑΉfoCXݒ
//******************************************************************************
int SMInDevCtrl::SetPortDev(
		const char* pProductName
	)
{
	int result = 0;
	bool isFound = false;
	SMInDevListItr itr;
	
	if (pProductName == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}
	
	for (itr = m_InDevList.begin(); itr != m_InDevList.end(); itr++) {
		if (strcmp(itr->productName, pProductName) == 0) {
			m_PortInfo.isExist = true;
			m_PortInfo.devId = itr->devId;
			//m_PortInfo.hMidiIn = NULL;
			isFound = true;
			break;
		}
	}
	if (!isFound) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}
	
EXIT:;
	return result;
}

//******************************************************************************
// MIDICxgǂݍ݃R[obN֐o^
//******************************************************************************
void SMInDevCtrl::SetInReadCallBack(
		SMInReadCallBack pCallBack,
		void* pUserParam
	)
{
	m_pInReadCallBack = pCallBack;
	m_pCallBackUserParam = pUserParam;
}

//******************************************************************************
// |[gɑΉfoCXJ
//******************************************************************************
int SMInDevCtrl::OpenPortDev()
{
	int result = 0;
	MMRESULT apiresult = 0;
	HMIDIIN hMidiIn = NULL;
	unsigned char* pBuf = NULL;
	
	result = ClosePortDev();
	if (result != 0) goto EXIT;
	
	//|[g݂Ȃ΃XLbv
	if (!m_PortInfo.isExist) goto EXIT;;
	
	m_isContinueSysEx = false;
	
	//foCXJ
	apiresult = midiInOpen(
					&hMidiIn,			//nh̃AhX
					m_PortInfo.devId,	//foCXʎq
					(DWORD_PTR)_InReadCallBack,	//R[obN֐
					(DWORD_PTR)this,	//R[obN֐ɓn[U[CX^Xf[^
					CALLBACK_FUNCTION	//R[obNtOFR[obN֐
				);
	if (apiresult != MMSYSERR_NOERROR) {
		result = YN_SET_ERR("MIDI OUT device open error.", apiresult, 0);
		goto EXIT;
	}
	m_PortInfo.hMidiIn = hMidiIn;
	
	//MIDI̓obt@쐬
	try {
		pBuf = new unsigned char[SM_MIDIIN_BUF_SIZE];
	}
	catch (std::bad_alloc) {
		result = YN_SET_ERR("Could not allocate memory.", 0, 0);
		goto EXIT;
	}
	
	//wb_쐬
	memset((void*)&(m_PortInfo.midiHdr), 0, sizeof(MIDIHDR));
	m_PortInfo.midiHdr.lpData         = (LPSTR)pBuf;
	m_PortInfo.midiHdr.dwBufferLength = SM_MIDIIN_BUF_SIZE;
	m_PortInfo.midiHdr.dwFlags        = 0;
	pBuf = NULL;
	
	//MIDI̓obt@
	apiresult = midiInPrepareHeader(hMidiIn, &(m_PortInfo.midiHdr), sizeof(MIDIHDR));
	if (apiresult != MMSYSERR_NOERROR) {
		result = YN_SET_ERR("MIDI API error.", apiresult, 0);
		goto EXIT;
	}
	
	//MIDI̓obt@o^
	apiresult = midiInAddBuffer(hMidiIn, &(m_PortInfo.midiHdr), sizeof(MIDIHDR));
	if (apiresult != MMSYSERR_NOERROR) {
		result = YN_SET_ERR("MIDI API error.", apiresult, 0);
		goto EXIT;
	}
	
	//MIDI͊Jn
	apiresult = midiInStart(m_PortInfo.hMidiIn);
	if (apiresult != MMSYSERR_NOERROR) {
		result = YN_SET_ERR("MIDI OUT device open error.", apiresult, 0);
		goto EXIT;
	}
	
EXIT:;
	delete [] pBuf;
	return result;
}

//******************************************************************************
// |[gɑΉfoCX
//******************************************************************************
int SMInDevCtrl::ClosePortDev()
{
	int result = 0;
	UINT apiresult = 0;
	
	//|[g݂Ȃ΃XLbv
	if (!m_PortInfo.isExist) goto EXIT;
	
	//|[gJĂȂ΃XLbv
	if (m_PortInfo.hMidiIn == NULL) goto EXIT;
	
	//MIDI͒~
	//  L[Ƀobt@݂ꍇ݂͌̃obt@͏ς݂ɂ
	//  MIDIHDRdwBytesRecordedoɂ̓f[^̎ۂ̒
	//  L[ɂ̃obt@͎cꏈς݂Ƃ͂Ȃ
	apiresult = midiInStop(m_PortInfo.hMidiIn);
	if (apiresult != MMSYSERR_NOERROR) {
		result = YN_SET_ERR("MIDI OUT device close error.", apiresult, 0);
		goto EXIT;
	}
	
	//MIDI͒~
	//  ̓̓obt@R[obN֐ɕԂ
	//  MIDIHDRdwFlagsoMHDR_DONEtOZbg
	apiresult = midiInReset(m_PortInfo.hMidiIn);
	if (apiresult != MMSYSERR_NOERROR) {
		result = YN_SET_ERR("MIDI OUT device close error.", apiresult, 0);
		goto EXIT;
	}
	
	//MIDI̓obt@
	apiresult = midiInUnprepareHeader(m_PortInfo.hMidiIn, &(m_PortInfo.midiHdr), sizeof(MIDIHDR));
	if (apiresult != MMSYSERR_NOERROR) {
		result = YN_SET_ERR("MIDI OUT device close error.", apiresult, 0);
		goto EXIT;
	}
	
	//obt@j
	delete [] (unsigned char*)(m_PortInfo.midiHdr.lpData);
	m_PortInfo.midiHdr.lpData = NULL;
	
	//foCX
	apiresult = midiInClose(m_PortInfo.hMidiIn);
	if (apiresult != MMSYSERR_NOERROR) {
		result = YN_SET_ERR("MIDI OUT device close error.", 0, 0);
		goto EXIT;
	}
	m_PortInfo.hMidiIn = NULL;
	
EXIT:;
	return result;
}


//******************************************************************************
// |[gNA
//******************************************************************************
int SMInDevCtrl::ClearPortInfo()
{
	int result = 0;
	
	result = ClosePortDev();
	if (result != 0) goto EXIT;
	
	m_PortInfo.isExist = false;
	m_PortInfo.devId = 0;
	m_PortInfo.hMidiIn = NULL;
	memset((void*)&(m_PortInfo.midiHdr), 0, sizeof(MIDIHDR));
	
EXIT:;
	return result;
}

//******************************************************************************
// MIDI IN ǂݍ݃R[obN֐
//******************************************************************************
void SMInDevCtrl::_InReadCallBack(
		HMIDIIN hMidiIn,
		UINT wMsg,
		DWORD dwInstance,
		DWORD dwParam1,
		DWORD dwParam2
	)
{
	SMInDevCtrl* pInDevCtrl = NULL;
	
	pInDevCtrl = (SMInDevCtrl*)dwInstance;
	pInDevCtrl->_InReadProc(hMidiIn, wMsg, dwParam1, dwParam2);
	
	return;
}

//******************************************************************************
// MIDI IN ǂݍݏ
//******************************************************************************
void SMInDevCtrl::_InReadProc(
		HMIDIIN hMidiIn,
		UINT wMsg,
		DWORD dwParam1,
		DWORD dwParam2
	)
{
	int result = 0;
	SMEvent event;
	
	switch (wMsg) {
		case MIM_OPEN:
			//MIDI̓foCXI[v
			break;
		case MIM_CLOSE:
			//MIDI̓foCXN[Y
			break;
		case MIM_DATA:
			//MIDIbZ[WM
			//  dwParam1 MIDIbZ[W
			//  dwParam2 ^CX^v
			m_isContinueSysEx = false;
			result = _InReadProcMIDI(dwParam1, dwParam2, &event);
			if (result != 0) goto EXIT;
			break;
		case MIM_LONGDATA:
			//VXeGNXN[VuM
			//  dwParam1 MIDIHDR\̂ւ̃|C^
			//  dwParam2 ^CX^v
			result = _InReadProcSysEx((MIDIHDR*)dwParam1, dwParam2, &m_isContinueSysEx, &event);
			if (result != 0) goto EXIT;
			break;
		case MIM_ERROR:
			//MIDIbZ[WM
			break;
		case MIM_LONGERROR:
			//ȃGNXN[VubZ[WM
			break;
		case MIM_MOREDATA:
			//MIDIbZ[W
			//midiInOpenMIDI_IO_STATUSw肵ꍇ̂ݔ
			break;
		default:
			break;
	}
	
	//R[obNĂяo
	if ((m_pInReadCallBack != NULL) &&
		(event.GetType() != SMEvent::EventNone)) {
		result = m_pInReadCallBack(&event, m_pCallBackUserParam);
		if (result != 0) goto EXIT;
	}
	
EXIT:;
	if (result != 0) {
		YN_SHOW_ERR(NULL);
	}
	return;
}

//******************************************************************************
// MIDIbZ[Wǂݍݏ
//******************************************************************************
int SMInDevCtrl::_InReadProcMIDI(
		DWORD midiMessage,
		DWORD timestamp,
		SMEvent* pEvent
	)
{
	int result = 0;
	unsigned char status = 0;
	unsigned char data[2] = { 0, 0 };
	unsigned long dataLength = 0;
	
	status  = (unsigned char)((midiMessage      ) & 0x000000FF);
	data[0] = (unsigned char)((midiMessage >>  8) & 0x000000FF);
	data[1] = (unsigned char)((midiMessage >> 16) & 0x000000FF);
	
	if ((status & 0xF0) != 0xF0) {
		//MIDIbZ[W
		dataLength = _GetMIDIMsgSize(status) - 1;
		result = pEvent->SetMIDIData(status, data, dataLength);
		if (result != 0) goto EXIT;
	}
	else if (status == 0xF0) {
		//VXeGNXN[VubZ[W
		//肦ȂAPI̋
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}
	else {
		//VXeRbZ[W܂̓VXeA^CbZ[W
		dataLength = _GetSysMsgSize(status) - 1;
		result = pEvent->SetSysMsgData(status, data, dataLength);
		if (result != 0) goto EXIT;
	}
	
EXIT:;
	return result;
}

//******************************************************************************
// VXeGNXN[Vuǂݍݏ
//******************************************************************************
int SMInDevCtrl::_InReadProcSysEx(
		MIDIHDR* pMIDIHDR,
		DWORD timestamp,
		bool* pIsContinueSysEx,
		SMEvent* pEvent
	)
{
	int result = 0;
	unsigned char* pData = NULL;
	UINT apiresult = 0;
	
	//Mf[^TCY[Ȃ牽Ȃ
	if (pMIDIHDR->dwBytesRecorded == 0) goto EXIT;
	
	//VXeGNXN[Vuǂݍ
	if (!(*pIsContinueSysEx)) {
		pData = (unsigned char*)(pMIDIHDR->lpData);
		result = pEvent->SetSysExData(0xF0, pData + 1, pMIDIHDR->dwBytesRecorded - 1);
		if (result != 0) goto EXIT;
	}
	//2Ԗڈȍ~̃pPbg
	else {
		pData = (unsigned char*)(pMIDIHDR->lpData);
		result = pEvent->SetSysExData(0xF7, pData, pMIDIHDR->dwBytesRecorded);
		if (result != 0) goto EXIT;
	}
	
	//VXeGNXN[VȕI[mF
	if (pData[(pMIDIHDR->dwBytesRecorded)-1] == 0xF7) {
		//VXeGNXN[Vu
		*pIsContinueSysEx = false;
	}
	else {
		//0xF7łȂΎɃf[^܂
		*pIsContinueSysEx = true;
	}
	
	//MIDI̓obt@
	apiresult = midiInPrepareHeader(m_PortInfo.hMidiIn, &(m_PortInfo.midiHdr), sizeof(MIDIHDR));
	if (apiresult != MMSYSERR_NOERROR) {
		result = YN_SET_ERR("MIDI API error.", apiresult, 0);
		goto EXIT;
	}
	
	//MIDI̓obt@o^
	apiresult = midiInAddBuffer(m_PortInfo.hMidiIn, &(m_PortInfo.midiHdr), sizeof(MIDIHDR));
	if (apiresult != MMSYSERR_NOERROR) {
		result = YN_SET_ERR("MIDI API error.", apiresult, 0);
		goto EXIT;
	}
	
EXIT:;
	return result;
}

//******************************************************************************
// MIDIbZ[WTCY擾
//******************************************************************************
unsigned long SMInDevCtrl::_GetMIDIMsgSize(unsigned char status)
{
	unsigned long size = 0;

	switch (status & 0xF0) {
		case 0x80: size = 3; break;  //m[gIt
		case 0x90: size = 3; break;  //m[gI
		case 0xA0: size = 3; break;  //|tHjbNL[vbV[
		case 0xB0: size = 3; break;  //Rg[`FW
		case 0xC0: size = 2; break;  //vO`FW
		case 0xD0: size = 2; break;  //`lvbV[
		case 0xE0: size = 3; break;  //sb`xh
		case 0xF0:
			size = _GetSysMsgSize(status);
			break;
	}
	
	return size;
}

//******************************************************************************
// VXebZ[WTCY擾
//******************************************************************************
unsigned long SMInDevCtrl::_GetSysMsgSize(unsigned char status)
{
	unsigned long size = 0;
	
	switch (status) {
		case 0xF0: size = 0; break;  // F0 ... F7 VXeGNXN[Vu
		case 0xF1: size = 2; break;  // F1 dd     VXeRbZ[WFNI[^[t[(MTC)
		case 0xF2: size = 3; break;  // F2 dl dm  VXeRbZ[WF\O|WV|C^
		case 0xF3: size = 2; break;  // F3 dd     VXeRbZ[WF\OZNg
		case 0xF4: size = 1; break;  // F4 `
		case 0xF5: size = 1; break;  // F5 `
		case 0xF6: size = 1; break;  // F6 VXeRbZ[WF`[NGXg
		case 0xF7: size = 1; break;  // F7 GhIuVXeGNXN[Vu
		case 0xF8: size = 1; break;  // F8 VXeA^CbZ[WF^C~ONbN
		case 0xF9: size = 1; break;  // F9 `
		case 0xFA: size = 1; break;  // FA VXeA^CbZ[WFX^[g
		case 0xFB: size = 1; break;  // FB VXeA^CbZ[WFReBj[
		case 0xFC: size = 1; break;  // FC VXeA^CbZ[WFXgbv
		case 0xFD: size = 1; break;  // FD `
		case 0xFE: size = 1; break;  // FE VXeA^CbZ[WFANeBuZVO
		case 0xFF: size = 1; break;  // FF VXeA^CbZ[WFVXeZbg
	}
	
	return size;
}

} // end of namespace


