//******************************************************************************
//
// Simple MIDI Library / SMLiveMonitor
//
// Cuj^NX
//
// Copyright (C) 2012-2013 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "SMLiveMonitor.h"
#include "SMEventMIDI.h"
#include "SMEventSysEx.h"
#include "SMEventSysMsg.h"

using namespace YNBaseLib;

namespace SMIDILib {


//******************************************************************************
// RXgN^
//******************************************************************************
SMLiveMonitor::SMLiveMonitor(void)
{	
	m_Status = StatusMonitorOFF;
	m_isMIDITHRU = true;
}

//******************************************************************************
// fXgN^
//******************************************************************************
SMLiveMonitor::~SMLiveMonitor()
{
	//|[gNA
	_ClearPortInfo();
	
	//MIDIfoCX
	_CloseMIDIDev();
}

//******************************************************************************
// 
//******************************************************************************
int SMLiveMonitor::Initialize(
		SMMsgQueue* pMsgQueue
	)
{
	int result = 0;
	
	m_pMsgQue = pMsgQueue;	
	
	//MIDIo̓foCX
	result = m_OutDevCtrl.Initialize();
	if (result != 0) goto EXIT;
	
	//MIDI̓foCX
	result = m_InDevCtrl.Initialize();
	if (result != 0) goto EXIT;
	
	//|[gNA
	_ClearPortInfo();
	
	//Cxg]IuWFNg
	result = m_MsgTrans.Initialize(pMsgQueue);
	if (result != 0) goto EXIT;
	
	//CxgEHb`[
	result = m_EventWatcher.Initialize(&m_MsgTrans);
	if (result != 0) goto EXIT;
	
EXIT:;
	return result;
}

//******************************************************************************
// ̓|[gΉfoCXo^
//******************************************************************************
int SMLiveMonitor::SetInPortDev(
		const char* pProductName,
		bool isMIDITHRU
	)
{
	int result = 0;
	errno_t eresult = 0;
	
	eresult = strcpy_s(m_InPortDevName, MAXPNAMELEN, pProductName);
	if (eresult != 0) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}
	
	m_isMIDITHRU = isMIDITHRU;
	
EXIT:;
	return result;
}

//******************************************************************************
// o̓|[gΉfoCXo^
//******************************************************************************
int SMLiveMonitor::SetOutPortDev(
		const char* pProductName
	)
{
	int result = 0;
	errno_t eresult = 0;
	
	eresult = strcpy_s(m_OutPortDevName, MAXPNAMELEN, pProductName);
	if (eresult != 0) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}
	
EXIT:;
	return result;
}

//******************************************************************************
// ̓|[gfoCX\̎擾
//******************************************************************************
int SMLiveMonitor::GetInPortDevDisplayName(
		std::string& name
	)
{
	int result = 0;
	
	name = m_InPortDevName;
	
	return result;
}

//******************************************************************************
// j^Jn
//******************************************************************************
int SMLiveMonitor::Start()
{
	int result = 0;
	
	//j^Ȃ牽Ȃ
	if (m_Status == StatusMonitorON) goto EXIT;
		
	//MIDIfoCXJ
	result = _OpenMIDIDev();
	if (result != 0) goto EXIT;
	
	m_Status = StatusMonitorON;
	
EXIT:;
	return result;
}

//******************************************************************************
// j^~
//******************************************************************************
int SMLiveMonitor::Stop()
{
	int result = 0;
	
	//SgbNm[gIt
	result = m_OutDevCtrl.NoteOffAll();
	if (result != 0) goto EXIT;
	
	//MIDIfoCX
	result = _CloseMIDIDev();
	if (result != 0) goto EXIT;

	m_Status = StatusMonitorOFF;
	
EXIT:;
	return result;
}

//******************************************************************************
// |[gNA
//******************************************************************************
void SMLiveMonitor::_ClearPortInfo()
{
	m_InPortDevName[0] = '\0';
	m_OutPortDevName[0] = '\0';
}

//******************************************************************************
// MIDIfoCXI[v
//******************************************************************************
int SMLiveMonitor::_OpenMIDIDev()
{
	int result = 0;
	
	//o̓|[g̃foCXJ
	if (strlen(m_OutPortDevName) > 0) {
		result = m_OutDevCtrl.SetPortDev(0, m_OutPortDevName);
		if (result != 0) goto EXIT;
	}
	result = m_OutDevCtrl.OpenPortDevAll();
	if (result != 0) goto EXIT;
	
	//̓|[g̃foCXJ
	if (strlen(m_InPortDevName) > 0) {
		result = m_InDevCtrl.SetPortDev(m_InPortDevName);
		if (result != 0) goto EXIT;
		
		//R[obNo^
		m_InDevCtrl.SetInReadCallBack(_InReadCallBack, this);
	}
	result = m_InDevCtrl.OpenPortDev();
	if (result != 0) goto EXIT;
	
EXIT:;
	return result;
}

//******************************************************************************
// MIDIfoCXN[Y
//******************************************************************************
int SMLiveMonitor::_CloseMIDIDev()
{
	int result = 0;
	
	//̓|[g̃foCX
	result = m_InDevCtrl.ClosePortDev();
	if (result != 0) goto EXIT;
	
	//o̓|[g̃foCX
	result = m_OutDevCtrl.ClosePortDevAll();
	if (result != 0) goto EXIT;
	
EXIT:;
	return result;
}

//******************************************************************************
// MIDI IN ǂݍ݃R[obN
//******************************************************************************
int SMLiveMonitor::_InReadCallBack(
		SMEvent* pEvent,
		void* pUserParam
	)
{
	int result = 0;
	SMLiveMonitor* pLiveMonitor = NULL;
	
	pLiveMonitor = (SMLiveMonitor*)pUserParam;
	
	if (pLiveMonitor != NULL) {
		result = pLiveMonitor->_InReadProc(pEvent);
		if (result != 0) goto EXIT;
	}
	
EXIT:;
	return result;
}

//******************************************************************************
// MIDI IN ǂݍݏ
//******************************************************************************
int SMLiveMonitor::_InReadProc(SMEvent* pEvent)
{
	int result = 0;
	
	//MIDICxgIʂăbZ[WL[ɓo^
	//Rg[`FW̊Ď
	result = _InReadProcParseEvent(pEvent);
	if (result != 0) goto EXIT;
	
	//MIDIo̓foCXɏo
	result = _InReadProcMIDITHRU(pEvent);
	if (result != 0) goto EXIT;
	
EXIT:;
	return result;
}

//******************************************************************************
// MIDI IN ǂݍݏFCxg
//******************************************************************************
int SMLiveMonitor::_InReadProcParseEvent(SMEvent* pEvent)
{
	int result = 0;
	unsigned char portNo = 0;
	
	//CxgEHb`
	result = m_EventWatcher.WatchEvent(portNo, pEvent);
	if (result != 0) goto EXIT;
	
EXIT:;
	return result;
}

//******************************************************************************
// MIDI IN ǂݍݏFMIDITHRU
//******************************************************************************
int SMLiveMonitor::_InReadProcMIDITHRU(SMEvent* pEvent)
{
	int result = 0;
	unsigned char portNo = 0;
	
	//MIDITHRUItȂȂɂȂ
	if (!m_isMIDITHRU) goto EXIT;
	
	//MIDICxgM
	if (pEvent->GetType() == SMEvent::EventMIDI) {
		result = _InReadProcSendMIDIEvent(portNo, pEvent);
		if (result != 0) goto EXIT;
	}
	//VXeGNXN[VuM
	else if (pEvent->GetType() == SMEvent::EventSysEx) {
		result = _InReadProcSendSysExEvent(portNo, pEvent);
		if (result != 0) goto EXIT;
	}
	//VXebZ[WM
	else if (pEvent->GetType() == SMEvent::EventSysMsg) {
		result = _InReadProcSendSysMsgEvent(portNo, pEvent);
		if (result != 0) goto EXIT;
	}
	
EXIT:;	
	return result;
}

//******************************************************************************
// MIDICxgM
//******************************************************************************
int SMLiveMonitor::_InReadProcSendMIDIEvent(
		unsigned char portNo,
		SMEvent* pEvent
	)
{
	int result = 0;
	unsigned long msg = 0;
	SMEventMIDI midiEvent;
	
	midiEvent.Attach(pEvent);
	
	//bZ[W擾
	result = midiEvent.GetMIDIOutShortMsg(&msg);
	if (result != 0) goto EXIT;
	
	//bZ[Wo
	result = m_OutDevCtrl.SendShortMsg(portNo, msg);
	if (result != 0) goto EXIT;
	
EXIT:;
	return result;
}

//******************************************************************************
// SysExCxgM
//******************************************************************************
int SMLiveMonitor::_InReadProcSendSysExEvent(
		unsigned char portNo,
		SMEvent* pEvent
	)
{
	int result = 0;
	unsigned char* pVarMsg = NULL;
	unsigned long size = 0;
	SMEventSysEx sysExEvent;
	
	sysExEvent.Attach(pEvent);
	
	//bZ[W擾
	sysExEvent.GetMIDIOutLongMsg(&pVarMsg, &size);
	
	//bZ[WóFo͊܂Ő䂪߂Ȃ
	result = m_OutDevCtrl.SendLongMsg(portNo, pVarMsg, size);
	if (result != 0) goto EXIT;
	
EXIT:;
	return result;
}

//******************************************************************************
// SysMsgCxgM
//******************************************************************************
int SMLiveMonitor::_InReadProcSendSysMsgEvent(
		unsigned char portNo,
		SMEvent* pEvent
	)
{
	int result = 0;
	unsigned long msg = 0;
	unsigned long size = 0;
	SMEventSysMsg sysMsgEvent;
	
	sysMsgEvent.Attach(pEvent);
	
	//bZ[W擾
	result = sysMsgEvent.GetMIDIOutShortMsg(&msg, &size);
	if (result != 0) goto EXIT;
	
	//bZ[Wo
	result = m_OutDevCtrl.SendShortMsg(portNo, msg);
	if (result != 0) goto EXIT;
	
EXIT:;
	return result;
}

} // end of namespace


