//******************************************************************************
//
// Simple MIDI Library / SMPortList
//
// ポートリストクラス
//
// Copyright (C) 2010-2017 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "YNBaseLib.h"
#import "SMPortList.h"


//******************************************************************************
// コンストラクタ
//******************************************************************************
SMPortList::SMPortList(void)
 : m_List(sizeof(unsigned char), 10)
{
}

//******************************************************************************
// デストラクタ
//******************************************************************************
SMPortList::~SMPortList(void)
{
	Clear();
}

//******************************************************************************
// クリア
//******************************************************************************
void SMPortList::Clear(void)
{
	m_List.Clear();
}

//******************************************************************************
// ポート情報追加
//******************************************************************************
int SMPortList::AddPort(
		unsigned char portNo
	)
{
	return m_List.AddItem(&portNo);
}

//******************************************************************************
// ポート情報取得
//******************************************************************************
int SMPortList::GetPort(
		unsigned int index,
		unsigned char* pPortNo
	)
{
	return m_List.GetItem(index, pPortNo);
}

//******************************************************************************
// ポート数取得
//******************************************************************************
unsigned int SMPortList::GetSize()
{
	return m_List.GetSize();
}

//******************************************************************************
// リストコピー
//******************************************************************************
int SMPortList::CopyFrom(
		SMPortList* pSrcList
	)
{
	return m_List.CopyFrom(&(pSrcList->m_List));
}


