//******************************************************************************
//
// MIDITrail / MTBackgroundImage
//
// 背景画像描画クラス
//
// Copyright (C) 2017 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// MEMO:
// 背景画像を描画する。
// 画像ファイルは .jpg .png を指定可能。

#import "OGLUtil.h"
#import "YNBaseLib.h"


//******************************************************************************
//  背景画像描画クラス
//******************************************************************************
class MTBackgroundImage
{
public:
	
	//コンストラクタ／デストラクタ
	MTBackgroundImage(void);
	virtual ~MTBackgroundImage(void);
	
	//生成
	int Create(OGLDevice* pOGLDevice, NSView* pView);
	
	//描画
	int Draw(OGLDevice* pOGLDevice);
	
	//解放
	void Release();
	
	//リセット
	void Reset();
	
	//表示設定
	void SetEnable(bool isEnable);

private:
	
	NSView* m_pView;
	OGLPrimitive m_Primitive;
	OGLTexture m_Texture;
	bool m_isEnable;
	
	//頂点バッファ構造体
	typedef OGLVERTEX_V3CT2 MTBACKGROUNDIMAGE_VERTEX;
	//struct MTBACKGROUNDIMAGE_VERTEX {
	//	OGLVECTOR3  p;		//頂点座標
	//	GLuint		c;		//色(4ub)
	//	OGLVECTOR2  t;		//テクスチャ座標
	//};
	
	//頂点バッファーのフォーマットの定義：座標変換済みを指定
	unsigned int _GetFVFFormat(){ return OGLVERTEX_TYPE_V3CT2; }
	
	//頂点生成
	int _CreateVertexOfBackground(
			MTBACKGROUNDIMAGE_VERTEX* pVertex,
			unsigned int* pIbIndex
		);
	
	//設定ファイル初期化
	int _InitConfFile();
	
	//テクスチャ画像読み込み
	int _LoadTexture(OGLDevice* pD3DDevice);

};

