//******************************************************************************
//
// MIDITrail / MTScenePianoRollRain
//
// ピアノロールレインシーン描画クラス
//
// Copyright (C) 2010-2019 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "OGLUtil.h"
#import "MTScene.h"
#import "MTFirstPersonCam.h"
#import "MTStars.h"
#import "MTPianoKeyboardCtrl.h"
#import "MTNoteRain.h"
#import "MTDashboard.h"
#import "MTNotePitchBend.h"
#import "MTTouchCtrl.h"
#import "MTBackgroundImage.h"
#import "MTConfFile.h"
#import "SMIDILib.h"


//******************************************************************************
// ピアノロールレインシーン描画クラス
//******************************************************************************
class MTScenePianoRollRain : public MTScene
{
public:
	
	//コンストラクタ／デストラクタl
	MTScenePianoRollRain(void);
	virtual ~MTScenePianoRollRain(void);
	
	//名称取得
	NSString* GetName();
	
	//生成
	virtual int Create(
			UIView* pView,
			OGLDevice* pOGLDevice,
			SMSeqData* pSeqData
		);
	
	//変換
	int Transform(OGLDevice* pOGLDevice, OGLScene::CameraType cameraType);
	
	//描画
	int Draw(OGLDevice* pOGLDevice, OGLScene::CameraType cameraType);
	
	//破棄
	void Release();
	
	//ウィンドウクリックイベント受信
	int OnWindowClicked(
			unsigned int button,
			unsigned int wParam,
			unsigned int lParam
		);
	
	//マウスホイールイベント受信
	int OnScrollWheel(
			float deltaWheelX,	//ホイール左右傾斜
			float deltaWheelY,	//ホイール回転
			float deltaWheelZ	//？
		);
	
	//演奏開始イベント受信
	int OnPlayStart();
	
	//演奏終了イベント受信
	int OnPlayEnd();
	
	//シーケンサメッセージ受信
	int OnRecvSequencerMsg(
			unsigned int wParam,
			unsigned int lParam
		);
	
	//巻き戻し
	int Rewind();
	
	//視点取得／登録
	void GetDefaultViewParam(MTViewParamMap* pParamMap);
	void GetViewParam(MTViewParamMap* pParamMap);
	void SetViewParam(MTViewParamMap* pParamMap);
	
	//視点リセット／移動
	void ResetViewpoint();
	void MoveToStaticViewpoint(unsigned int viewpointNo);
	
	//エフェクト設定
	void SetEffect(MTScene::EffectType type, bool isEnable);
	
	//演奏速度設定
	void SetPlaySpeedRatio(unsigned int ratio);
	
	//タッチイベント
	void OnTouchesBegan(NSSet* pTouches);
	void OnTouchesMoved(NSSet* pTouches);
	void OnTouchesEnd(NSSet* pTouches);
	void OnTouchesCanceled(NSSet* pTouches);
	
	//タッチ操作種別取得
	MTTouchCtrl::OperationType GetCurOperationType();
	
	//スクリーンロック
	void LockScreen(bool isLocked);
	
	//スクリーン種別設定
	void SetScreenType(ScreenType type);
	
	//デバイス方向設定
	void SetDeviceDirection(OGLQuaternion quaternion);
	
	//FPS設定
	void SetFPS(float fps);
	
protected:
	
	//ライト有無
	bool m_IsEnableLight;
	
	//シングルキーボードフラグ
	bool m_IsSingleKeyboard;
	
private:
	
	//ビュー
	UIView* m_pView;
	
	//ライト
	OGLDirLight m_DirLight;
	
	//一人称カメラ
	MTFirstPersonCam m_FirstPersonCam;
	
	//描画オブジェクト
	MTStars m_Stars;
	MTPianoKeyboardCtrl m_PianoKeyboardCtrl;
	MTNoteRain m_NoteRain;
	MTNotePitchBend m_NotePitchBend;
	MTDashboard m_Dashboard;
	MTBackgroundImage m_BackgroundImage;
	
	//マウス視線移動モード
	bool m_IsMouseCamMode;
	
	//自動回転モード
	bool m_IsAutoRollMode;
	
	//視点情報
	MTViewParamMap m_ViewParamMap;
	MTViewParamMap m_Viewpoint2;
	MTViewParamMap m_Viewpoint3;
	
	//演奏位置
	unsigned int m_CurTickTime;
	
	//スキップ状態
	bool m_IsSkipping;
	
	//タッチイベント制御
	MTTouchCtrl m_TouchCtrl;
	
	//スクリーン種別
	MTScene::ScreenType m_ScreenType;
	
	void _Reset();
	int _LoadConf();
	int _LoadConfViewpoint(
				MTConfFile* pConfFile,
				unsigned int viewpointNo,
				MTScene::MTViewParamMap* pParamMap
			);
	
};


