//******************************************************************************
//
// MIDITrail / MTDeviceScreenInfo
//
// デバイススクリーン情報クラス
//
// Copyright (C) 2018-2019 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "MTDeviceScreenInfo.h"


//******************************************************************************
// コンストラクタ
//******************************************************************************
MTDeviceScreenInfo::MTDeviceScreenInfo(void)
{
	//セーフエリア情報
	m_isEnableSafeArea = false;
	
	//マージン幅
	m_Margin_LandscapeTop = 0.0f;
	m_Margin_LandscapeLeft = 0.0f;
	m_Margin_LandscapeRight = 0.0f;
	m_Margin_LandscapeBottom = 0.0f;
	m_Margin_RoundedCorner = 0.0f;
	
	return;
}

//******************************************************************************
// デストラクタ
//******************************************************************************
MTDeviceScreenInfo::~MTDeviceScreenInfo(void)
{
}

//******************************************************************************
// 初期化
//******************************************************************************
void MTDeviceScreenInfo::Initialize()
{
	CGFloat height = 0;
	CGFloat width = 0;
	CGFloat longSide = 0;
	
	height = [[UIScreen mainScreen] bounds].size.height;
	width = [[UIScreen mainScreen] bounds].size.width;
	
	longSide = height;
	if (height < width) {
		longSide = width;
	}
	
	//iPhone
	if ([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPhone) {
		//iPhone X,XS,XS Max,XRはセーフエリアあり
		//iPhone XS Max,XRより大きい未知のデバイスはセーフエリアありとみなす
		if ((longSide == 812) || (longSide == 896) || (longSide > 896)) {
			m_isEnableSafeArea = true;
			m_Margin_LandscapeTop = 0.0f;
			m_Margin_LandscapeLeft = 44.0f;
			m_Margin_LandscapeRight = 44.0f;
			m_Margin_LandscapeBottom = 21.0f;
			m_Margin_RoundedCorner = 0.0f;
		}
	}
	//iPad
	else {
		//2018年11月発売の iPad Pro 11 inch, iPad Pro 12.9 inch からホームボタン廃止に伴いセーフエリアあり
		//それ以前から存在するホームボタンありのiPad Pro 12.9 inch モデルはセーフエリアなしであるが
		//識別が困難なためセーフエリアありとして処理する
		//12.9 inch モデルより大きい未知のデバイスはセーフエリアありとみなす
		if ((longSide == 1194) || (longSide == 1366) || (longSide > 1366)) {
			m_isEnableSafeArea = true;
			m_Margin_LandscapeTop = 0.0f;
			m_Margin_LandscapeLeft = 0.0f;
			m_Margin_LandscapeRight = 0.0f;
			m_Margin_LandscapeBottom = 20.0f;
			m_Margin_RoundedCorner = 10.0f;
		}
	}
	
	return;
}

//******************************************************************************
// セーフエリア有無
//******************************************************************************
bool MTDeviceScreenInfo::IsEnableSafeArea()
{
	return m_isEnableSafeArea;
}

//******************************************************************************
// マージン幅取得：横向き/上
//******************************************************************************
float MTDeviceScreenInfo::GetMargin_LandscapeTop()
{
	return m_Margin_LandscapeTop;
}

//******************************************************************************
// マージン幅取得：横向き/左
//******************************************************************************
float MTDeviceScreenInfo::GetMargin_LandscapeLeft()
{
	return m_Margin_LandscapeLeft;
}

//******************************************************************************
// マージン幅取得：横向き/右
//******************************************************************************
float MTDeviceScreenInfo::GetMargin_LandscapeRight()
{
	return m_Margin_LandscapeRight;
}

//******************************************************************************
// マージン幅取得：横向き/下
//******************************************************************************
float MTDeviceScreenInfo::GetMargin_LandscapeBottom()
{
	return m_Margin_LandscapeBottom;
}

//******************************************************************************
// マージン幅取得：角丸
//******************************************************************************
float MTDeviceScreenInfo::GetMargin_RoundedCorner()
{
	return m_Margin_RoundedCorner;
}

