//******************************************************************************
//
// MIDITrail / MTScenePianoRoll3DLive
//
// Cuj^psAm[3DV[`NX
//
// Copyright (C) 2012-2019 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#pragma once

#include <d3d9.h>
#include <d3dx9.h>
#include "DXDirLight.h"
#include "MTScene.h"
#include "MTFirstPersonCam.h"
#include "MTNoteBoxLive.h"
#include "MTNoteRipple.h"
#include "MTNoteDesign.h"
#include "MTNotePitchBend.h"
#include "MTGridBoxLive.h"
#include "MTPictBoard.h"
#include "MTDashboardLive.h"
#include "MTStars.h"
#include "MTTimeIndicator.h"
#include "MTMeshCtrl.h"
#include "MTBackgroundImage.h"
#include "MTConfFile.h"
#include "SMIDILib.h"

using namespace SMIDILib;


//******************************************************************************
// Cuj^psAm[3DV[`NX
//******************************************************************************
class MTScenePianoRoll3DLive : public MTScene
{
public:
	
	//RXgN^^fXgN^l
	MTScenePianoRoll3DLive();
	~MTScenePianoRoll3DLive();
	
	//̎擾
	const TCHAR* GetName();
	
	//
	virtual int Create(
			HWND hWnd,
			LPDIRECT3DDEVICE9 pD3DDevice,
			SMSeqData* pSeqData
		);
	
	//ϊ
	int Transform(LPDIRECT3DDEVICE9 pD3DDevice);
	
	//`
	int Draw(LPDIRECT3DDEVICE9 pD3DDevice);
	
	//j
	void Release();
	
	//EBhENbNCxgM
	int OnWindowClicked(
			UINT button,
			WPARAM wParam,
			LPARAM lParam
		);
	
	//tJnCxgM
	int OnPlayStart(LPDIRECT3DDEVICE9 pD3DDevice);
	
	//tICxgM
	int OnPlayEnd(LPDIRECT3DDEVICE9 pD3DDevice);
	
	//V[PTbZ[WM
	int OnRecvSequencerMsg(
			unsigned long param1,
			unsigned long param2
		);
	
	//߂
	int Rewind();
	
	//_擾^o^
	void GetDefaultViewParam(MTViewParamMap* pParamMap);
	void GetViewParam(MTViewParamMap* pParamMap);
	void SetViewParam(MTViewParamMap* pParamMap);
	void MoveToStaticViewpoint(unsigned long viewpointNo);
	
	//_Zbg
	void ResetViewpoint();
	
	//GtFNgݒ
	void SetEffect(MTScene::EffectType type, bool isEnable);
	
protected:
	
	//CgL
	bool m_IsEnableLight;
	
private:
	
	//Cg
	DXDirLight m_DirLight;
	
	//l̃J
	MTFirstPersonCam m_FirstPersonCam;
	
	//`IuWFNg
	MTNoteBoxLive m_NoteBoxLive;
	MTNoteRipple m_NoteRipple;
	MTNotePitchBend m_NotePitchBend;
	MTGridBoxLive m_GridBoxLive;
	MTPictBoard m_PictBoard;
	MTDashboardLive m_DashboardLive;
	MTStars m_Stars;
	MTTimeIndicator m_TimeIndicator;
	MTMeshCtrl m_MeshCtrl;
	MTBackgroundImage m_BackgroundImage;
	
	//}EXړ[h
	bool m_IsMouseCamMode;
	
	//][h
	bool m_IsAutoRollMode;
	
	//_
	MTViewParamMap m_ViewParamMap;
	MTViewParamMap m_Viewpoint2;
	MTViewParamMap m_Viewpoint3;
	
	//m[gfUCIuWFNg
	MTNoteDesign m_NoteDesign;
	
	//XLbv
	bool m_IsSkipping;
	
	void _Reset();
	int _LoadConf();
	int _LoadConfViewpoint(MTConfFile* pConfFile, unsigned long viewpointNo, MTScene::MTViewParamMap* pParamMap);

};


