//******************************************************************************
//
// MIDITrail / MTSettingNoteLengthViewCtrl
//
// 四分音符長拡大率設定ビュークラス
//
// Copyright (C) 2019 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import <UIKit/UIKit.h>
#import "YNBaseLib.h"


//******************************************************************************
// 四分音符長拡大率選択ビュー制御クラス パラメタ定義
//******************************************************************************
//ノート長拡大率 最小値/最大値
#define MT_QNOTE_LENGTH_MAG_MIN		(0)
#define MT_QNOTE_LENGTH_MAG_MAX		(1000)
#define MT_QNOTE_LENGTH_MAG_STEP	(10)


//******************************************************************************
// 四分音符長拡大率選択ビュー制御クラス
//******************************************************************************
@interface MTSettingNoteLengthViewCtrl : UIViewController {
	
	//テーブルビュー
	IBOutlet UITableView* m_pTableView;
	
	//拡大率リスト
	NSMutableArray* m_pMagArray;
	
	//四分音符長拡大率(%)
	int m_QuarterNoteLengthMag;
	
	//ユーザ設定
	YNUserConf* m_pUserConf;
}

//生成
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil;

//ビュー登録完了
- (void)viewDidLoad;

//インターフェース自動回転確認
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation;

//インターフェース自動回転確認（iOS6以降）
- (BOOL)shouldAutorotate;
- (NSUInteger)supportedInterfaceOrientations;

//ビュー表示
- (void)viewWillAppear:(BOOL)animated;

//ビュー非表示
- (void)viewWillDisappear:(BOOL)animated;

//セクション数
-(NSInteger)numberOfSectionsInTableView:(UITableView*)tableView;

//セクションヘッダ
- (NSString*)tableView:(UITableView*)tableView titleForHeaderInSection:(NSInteger)section;

//セクションごとの項目数
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section;

//項目表示内容
- (UITableViewCell*)tableView:(UITableView*)tableView cellForRowAtIndexPath:(NSIndexPath*)indexPath;

//テーブルセル選択イベント
- (void)tableView:(UITableView*)tableView didSelectRowAtIndexPath:(NSIndexPath*)indexPath;

//選択四分音符長拡大率取得
- (int)selectedQuarterNoteLengthMag;

@end

