#//******************************************************************************
//
// Simple MIDI Library / SMMsgParser
//
// bZ[W̓NX
//
// Copyright (C) 2010-2014 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#pragma once

#ifdef SMIDILIB_EXPORTS
#define SMIDILIB_API __declspec(dllexport)
#else
#define SMIDILIB_API __declspec(dllimport)
#endif

namespace SMIDILib {

//******************************************************************************
// bZ[W̓NX
//******************************************************************************
class SMIDILIB_API SMMsgParser
{
public:

	//V[PTbZ[W
	enum Message {
		MsgUnknown,		//bZ[Ws
		MsgPlayStatus,	//tԒʒm
		MsgPlayTime,	//tԒʒm
		MsgTempo,		//e|ύXʒm
		MsgBar,			//ߔԍʒm
		MsgBeat,		//qLύXʒm
		MsgNoteOff,		//m[gOFFʒm
		MsgNoteOn,		//m[gONʒm
		MsgPitchBend,	//sb`xhʒm
		MsgSkipStart,	//XLbvJnʒm
		MsgSkipEnd,		//XLbvIʒm
		MsgAllNoteOff	//I[m[gOFFʒm
	};

	//t
	enum PlayStatus {
		StatusUnknown,	//bZ[Ws
		StatusStop,		//~
		StatusPlay,		//t
		StatusPause		//ꎞ~
	};

	//XLbv
	enum SkipDirection {
		SkipBack,
		SkipForward
	};

public:

	//RXgN^^fXgN^
	SMMsgParser(void);
	virtual ~SMMsgParser(void);

	//bZ[W
	void Parse(unsigned long param1, unsigned long param2);

	//bZ[Wʎ擾
	Message GetMsg();

	//tԎ擾
	PlayStatus GetPlayStatus();

	//tԎ擾
	unsigned long GetPlayTimeSec();
	unsigned long GetPlayTimeMSec();
	unsigned long GetPlayTickTime();

	//e|擾
	unsigned long GetTempoBPM();

	//ߔԍ擾
	unsigned long GetBarNo();

	//qL擾
	unsigned long GetBeatNumerator();
	unsigned long GetBeatDenominator();

	//m[gON/OFF擾
	unsigned char GetPortNo();
	unsigned char GetChNo();
	unsigned char GetNoteNo();
	unsigned char GetVelocity();

	//sb`xh擾
	short GetPitchBendValue();
	unsigned char GetPitchBendSensitivity();

	//XLbvJn擾
	SkipDirection GetSkipStartDirection();

	//XLbvI擾
	unsigned long GetSkipEndNotesCount();

private:

	unsigned long m_Param1;
	unsigned long m_Param2;
	Message m_Msg;

};

} // end of namespace

