//******************************************************************************
//
// MIDITrail / MTGridRingLive
//
// ライブモニタ用グリッドリング描画クラス
//
// Copyright (C) 2019 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "OGLUtil.h"
#import "SMIDILib.h"
#import "MTNoteDesignRing.h"


//******************************************************************************
// ライブモニタ用グリッドリング描画クラス
//******************************************************************************
class MTGridRingLive
{
public:
	
	//コンストラクタ／デストラクタ
	MTGridRingLive(void);
	virtual ~MTGridRingLive(void);
	
	//生成
	int Create(OGLDevice* pOGLDevice, NSString* pSceneName);
	
	//更新
	int Transform(OGLDevice* pOGLDevice, float rollAngle);
	
	//描画
	int Draw(OGLDevice* pOGLDevice);
	
	//解放
	void Release();
	
private:
	
	OGLPrimitive m_Primitive;
	MTNoteDesignRing m_NoteDesign;
	bool m_isVisible;
	
	//頂点バッファ構造体
	typedef OGLVERTEX_V3N3C MTGRIDBOXLIVE_VERTEX;
	//struct MTGRIDBOXLIVE_VERTEX {
	//	D3DXVECTOR3 p;	//頂点座標
	//	D3DXVECTOR3 n;	//法線
	//	DWORD		c;	//ディフューズ色
	//};
	
	//頂点バッファFVFフォーマット
	unsigned int _GetFVFFormat(){ return OGLVERTEX_TYPE_V3N3C; }
	
	int _CreateVertexOfGrid(
			MTGRIDBOXLIVE_VERTEX* pVertex,
			unsigned int* pIbIndex
		);
	
	void _MakeMaterial(OGLMATERIAL* pMaterial);

};


