//******************************************************************************
//
// MIDITrail / MTDeviceScreenInfo
//
// デバイススクリーン情報クラス
//
// Copyright (C) 2018-2019 WADA Masashi. All Rights Reserved.
//
//******************************************************************************


//******************************************************************************
// デバイススクリーン情報クラス
//******************************************************************************
class MTDeviceScreenInfo
{
	
public:
	
	//コンストラクタ／デストラクタ
	MTDeviceScreenInfo(void);
	virtual ~MTDeviceScreenInfo(void);
	
	//初期化
	void Initialize();
	
	//セーフエリア有無
	bool IsEnableSafeArea();
	
	//マージン幅取得：横向き
	float GetMargin_LandscapeTop();
	float GetMargin_LandscapeLeft();
	float GetMargin_LandscapeRight();
	float GetMargin_LandscapeBottom();
	float GetMargin_RoundedCorner();
	
	//Pixcels per inch 取得：iPhoneのみ対応
	float GetPixcelsPerInch();
	
	//mm per point 取得：iPhoneのみ対応
	float GetMmPerPoint();
	
private:
	
	//セーフエリア情報
	bool m_isEnableSafeArea;
	
	//マージン情報
	float m_Margin_LandscapeTop;
	float m_Margin_LandscapeLeft;
	float m_Margin_LandscapeRight;
	float m_Margin_LandscapeBottom;
	float m_Margin_RoundedCorner;
	
	//解像度情報
	float m_PixcelsPerInch;
	float m_MmPerPoint;
	
	void _InitializeSafeArea();
	void _InitializePPI();
	
};

