//******************************************************************************
//
// MIDITrail / MTFileViewCtrl
//
// ファイルビュー制御クラス
//
// Copyright (C) 2012-2021 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import <UIKit/UIKit.h>
#import "MTFileEditViewCtrl.h"
#import "MTFileSearchResultsViewCtrl.h"


//******************************************************************************
// ファイル検索制御クラス
//******************************************************************************
@interface MTFileSearchController : UISearchController {

}

//検索バー表示前
- (void)viewWillAppear:(BOOL)animated;

//検索バー非表示前
- (void)viewWillDisappear:(BOOL)animated;

@end


//******************************************************************************
// ファイルビュー制御クラス
//******************************************************************************
@interface MTFileViewCtrl : UIViewController <UISearchResultsUpdating, UIDocumentPickerDelegate> {
	
	//テーブルビュー
	IBOutlet UITableView* m_pTableView;
	
	//対象ディレクトリパス
	NSString* m_pTargetDirPath;
	
	//ファイル名一覧
	NSMutableArray* m_pFileArray;
	
	//ファイル属性辞書
	NSMutableDictionary* m_pFileAttributesDictionary;
	
	//選択ファイルインデックス
	NSInteger m_SelectedFileIndex;
	
	//ファイル編集ビュー
	MTFileEditViewCtrl* m_pFileEditViewCtrl;
	
	//検索制御
	MTFileSearchController* m_pSearchController;
	
	//検索結果ビュー制御
	MTFileSearchResultsViewCtrl* m_pFileSearchResultsViewCtrl;
	
	//リフレッシュ制御
	UIRefreshControl* m_pRefreshCtrl;
	
	//子ファイルビュー制御
	MTFileViewCtrl* m_pChildFileViewCtrl;
	
	//追加ボタン
	UIBarButtonItem* m_pAddButton;
	
	//整理ボタン
	UIBarButtonItem* m_pOrganizeButton;
	
	//ファイル選択ビュー制御
	UIDocumentPickerViewController* m_pDocumentPickerViewCtrl;
}

//生成
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil targetDirPath:(NSString *)pTargetDirPath;

//ビュー登録完了
- (void)viewDidLoad;

//インターフェース自動回転確認
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation;

//インターフェース自動回転確認（iOS6以降）
- (BOOL)shouldAutorotate;
- (NSUInteger)supportedInterfaceOrientations;

//ビュー表示
- (void)viewWillAppear:(BOOL)animated;

//ビュー非表示
- (void)viewWillDisappear:(BOOL)animated;

//セクション数
-(NSInteger)numberOfSectionsInTableView:(UITableView*)tableView;

//セクションヘッダ
- (NSString*)tableView:(UITableView*)tableView titleForHeaderInSection:(NSInteger)section;

//セクションごとの項目数
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section;

//項目表示内容
- (UITableViewCell*)tableView:(UITableView*)tableView cellForRowAtIndexPath:(NSIndexPath*)indexPath;

//テーブルセル作成：列の高さ
- (CGFloat)tableView:(UITableView*)tableView heightForRowAtIndexPath:(NSIndexPath*)indexPath;

//テーブルセル選択イベント
- (void)tableView:(UITableView*)tableView didSelectRowAtIndexPath:(NSIndexPath*)indexPath;

//選択行ファイルパス取得
- (NSString*)selectedFilePath;

//編集開始終了通知
- (void)setEditing:(BOOL)editing animated:(BOOL)animated;

//行単位削除可否判定
- (BOOL)tableView:(UITableView *)tableView canEditRowAtIndexPath:(NSIndexPath *)indexPath;

//行削除イベント
- (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath;

//ファイル編集イベント
- (void)onEditFile:(NSNotification*)pNotification;

//ディレクトリ作成イベント
- (void)onCreateDir:(NSNotification*)pNotification;

//検索結果更新
- (void)updateSearchResultsForSearchController:(UISearchController*)pSearchController;

//検索結果でのファイル選択イベント
- (void)onSelectFileInSearchResults:(NSNotification*)pNotification;

//ファイル一覧更新
- (int)updateFileList;

//指定ファイルまでスクロール
- (int)scroolToFilePath:(NSString*)pFilePath;

//追加ボタン押下イベント
- (void)onAddButton:(id)sender;

//破棄
- (void)dealloc;

//次ファイル検索
- (int)findNextFileWithRepeat:(bool)isRepeat isExist:(bool*)pIsExist;

//次ファイル自動選択
- (int)autoSelectNextFileWithRepeat:(bool)isRepeat;

//整理ボタン押下イベント
-(void)onOrganizeButton:(id)sender;

//ファイル選択完了通知 iOS 11以降廃止
- (void)documentPicker:(UIDocumentPickerViewController*)pController didPickDocumentAtURL:(NSURL*)pUrl;

//ファイル選択完了通知 iOS 11以降
- (void)documentPicker:(UIDocumentPickerViewController*)pController didPickDocumentsAtURLs:(NSArray<NSURL*>*)pUrls;

//ファイル選択キャンセル通知
- (void)documentPickerWasCancelled:(UIDocumentPickerViewController*)pController;

@end

