//******************************************************************************
//
// MIDITrail / MTSettingDelayBetweenSongsViewCtrl
//
// 曲間待機時間設定ビュークラスス
//
// Copyright (C) 2021 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "MTParam.h"
#import "MTSettingDelayBetweenSongsViewCtrl.h"


//******************************************************************************
// プライベートメソッド定義
//******************************************************************************
@interface MTSettingDelayBetweenSongsViewCtrl ()

// 待機時間リスト初期化
- (void)initDelaySecondsArray;

@end


@implementation MTSettingDelayBetweenSongsViewCtrl

//******************************************************************************
// 初期化
//******************************************************************************
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
	int result = 0;
	
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
		//ビュー設定
		self.title = @"Delay Between Songs";
		
		//待機時間リスト初期化
		[self initDelaySecondsArray];
		
		//ユーザ設定初期化
		m_pUserConf = [[YNUserConf alloc] init];
		if (m_pUserConf == nil) {
			result = YN_SET_ERR(@"Program error.", 0, 0);
			goto EXIT;
		}
		[m_pUserConf setCategory:MT_CONF_CATEGORY_PLAYER];
		[m_pUserConf setSection:MT_CONF_SECTION_PLAYBACK];
		
		//待機時間（秒）設定
		m_DelaySeconds = [m_pUserConf intValueForKey:@"DelayBetweenSongsInMsec" defaultValue:0] / 1000;
    }
	
EXIT:;
	if (result != 0) YN_SHOW_ERR();
    return self;
}

//******************************************************************************
// ビュー登録完了
//******************************************************************************
- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view.
	
	return;
}

//******************************************************************************
// インターフェース自動回転確認
//******************************************************************************
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    return YES;
}

//******************************************************************************
// インターフェース自動回転確認（iOS6以降）
//******************************************************************************
- (BOOL)shouldAutorotate
{
	//回転を許可する
	return YES;
}

//******************************************************************************
// インターフェース自動回転確認：回転方向（iOS6以降）
//******************************************************************************
- (NSUInteger)supportedInterfaceOrientations
{
	//全方向に対応する
	return UIInterfaceOrientationMaskAll;
}

//******************************************************************************
// ビュー表示
//******************************************************************************
- (void)viewWillAppear:(BOOL)animated
{	
	return;
}

//******************************************************************************
// ビュー非表示
//******************************************************************************
- (void)viewWillDisappear:(BOOL)animated
{
	return;
}

//******************************************************************************
// セクション数
//******************************************************************************
-(NSInteger)numberOfSectionsInTableView:(UITableView*)tableView
{
    return 1;
} 

//******************************************************************************
// セクションヘッダ
//******************************************************************************
- (NSString*)tableView:(UITableView*)tableView titleForHeaderInSection:(NSInteger)section
{
    return nil;
} 

//******************************************************************************
// セクションごとの項目数
//******************************************************************************
- (NSInteger)tableView:(UITableView *)tableView
 numberOfRowsInSection:(NSInteger)section
{
	NSInteger numOfRows = 0;
	
	switch (section) {
		case 0:
			//ビューモード
			numOfRows = [m_pDelaySecondsArray count];
			break;
		default:
			break;
	}
	
	return numOfRows;
}

//******************************************************************************
// 項目表示内容
//******************************************************************************
- (UITableViewCell*)tableView:(UITableView*)tableView
		cellForRowAtIndexPath:(NSIndexPath*)indexPath
{
    static NSString* pCellIdentifier = @"MTSettingDelayBetweenSongsViewCtrl";
	UITableViewCell* pCell = nil;
	int delaySeconds = 0;
	
	//再利用可能セル生成
	pCell = [m_pTableView dequeueReusableCellWithIdentifier:pCellIdentifier];
	if (pCell == nil) {
		pCell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
									   reuseIdentifier:pCellIdentifier];
	}
	
	//範囲外なら処理終了
	if ([m_pDelaySecondsArray count] <= indexPath.row) goto EXIT;
	
	//ラベル設定
	delaySeconds = [[m_pDelaySecondsArray objectAtIndex:indexPath.row] intValue];
	if (delaySeconds == 0) {
		pCell.textLabel.text = [NSString stringWithFormat:@"%d seconds (default)", delaySeconds];
	}
	else if (delaySeconds == 1) {
		pCell.textLabel.text = [NSString stringWithFormat:@"%d second", delaySeconds];
	}
	else {
		pCell.textLabel.text = [NSString stringWithFormat:@"%d seconds", delaySeconds];
	}
	
	//チェックマーク設定
	pCell.accessoryType = UITableViewCellAccessoryNone;
	if (delaySeconds == m_DelaySeconds) {
		pCell.accessoryType = UITableViewCellAccessoryCheckmark;
	}
	
EXIT:;
	return pCell;
}

//******************************************************************************
// テーブルセル選択イベント
//******************************************************************************
- (void)tableView:(UITableView*)tableView didSelectRowAtIndexPath:(NSIndexPath*)indexPath
{
	//選択状態解除
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
	
	//選択行の待機時間（秒）を取得
	m_DelaySeconds = [[m_pDelaySecondsArray objectAtIndex:indexPath.row] intValue];
	
	//選択された待機時間（秒）を保存
	[m_pUserConf setInt:(m_DelaySeconds * 1000) forKey:@"DelayBetweenSongsInMsec"];
	
	//再表示
	[tableView performSelector:@selector(reloadData) withObject:nil afterDelay:0.1f];
	
	//1階層戻る
	//[self.navigationController popViewControllerAnimated:YES];
	
	return;
}

//******************************************************************************
// 選択待機時間（秒）取得
//******************************************************************************
- (int)selectedDelaySeconds
{
	return m_DelaySeconds;
}

//******************************************************************************
// 待機時間リスト初期化
//******************************************************************************
- (void)initDelaySecondsArray
{
	int seconds = 0;
	
	m_pDelaySecondsArray = [[NSMutableArray alloc] init];
	
	for (seconds = MT_DELAY_BETWEEN_SONGS_MIN;
		 seconds <= MT_DELAY_BETWEEN_SONGS_MAX;
		 seconds += MT_DELAY_BETWEEN_SONGS_STEP) {
		[m_pDelaySecondsArray addObject:[NSNumber numberWithInteger:seconds]];
	}
	
	return;
}

@end

