//******************************************************************************
//
// MIDITrail / MTFileList
//
// t@CXgNX
//
// Copyright (C) 2021 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#pragma once

#include "SMRcpConv.h"
#include <list>
#include <string>

using namespace YNBaseLib;
using namespace SMIDILib;


//******************************************************************************
// t@CXgNX
//******************************************************************************
class MTFileList
{
public:

	//RXgN^^fXgN^
	MTFileList(void);
	virtual ~MTFileList(void);

	//fBNgzt@CXg쐬
	int MakeFileListWithDirectory(const TCHAR* pTargetDirPath, SMRcpConv* pRcpConv);

	//t@C
	size_t GetFileCount();

	//t@CpX擾
	const TCHAR* GetFilePath(unsigned long index);

	//t@C擾
	const TCHAR* GetFileName(unsigned long index);

	//NA
	void Clear();

	//It@Co^
	int SetSelectedFileName(const TCHAR* pFileName);

	//擪t@CI
	void SelectFirstFile();

	//Ot@CI
	void SelectPreviousFile(bool* pExist);

	//t@CI
	void SelectNextFile(bool* pExist);

	//It@CCfbNX擾
	unsigned long GetSelectedFileIndex();

private:

	//ƃRs[RXgN^̋֎~
	void operator=(const MTFileList&);
	MTFileList(const MTFileList&);

	TCHAR m_TargetDirPath[_MAX_PATH];
	TCHAR m_CurFilePath[_MAX_PATH];

#ifdef _UNICODE
	typedef std::list<wsting> MTFileNameList;
#else
	typedef std::list<string> MTFileNameList;
#endif

	MTFileNameList m_FileNameList;

	unsigned long m_SelectedFileIndex;


};

