//******************************************************************************
//
// Simple MIDI Library / SMEventSysMsg
//
// VXebZ[WCxgNX
//
// Copyright (C) 2012-2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// MEMO:
// CxgNXh݌vzAnew̎{񐔂
// ߁AX^bNŏłf[^̓[eBeBNXƂĎB

// {NX̑ΏۂƂVXebZ[Wꗗ
//   F1 dd     VXeRbZ[WFNI[^[t[(MTC)
//   F2 dl dm  VXeRbZ[WF\O|WV|C^
//   F3 dd     VXeRbZ[WF\OZNg
//   F4 `
//   F5 `
//   F6 VXeRbZ[WF`[NGXg
//   F8 VXeA^CbZ[WF^C~ONbN
//   F9 `
//   FA VXeA^CbZ[WFX^[g
//   FB VXeA^CbZ[WFReBj[
//   FC VXeA^CbZ[WFXgbv
//   FD `
//   FE VXeA^CbZ[WFANeBuZVO
//   FF VXeA^CbZ[WFVXeZbg
// LbZ[W͖{NX̑ΏۊOƂ
//   F0 ... F7 VXeGNXN[Vu
//   F7 GhIuVXeGNXN[Vu

#pragma once

#ifdef SMIDILIB_EXPORTS
#define SMIDILIB_API __declspec(dllexport)
#else
#define SMIDILIB_API __declspec(dllimport)
#endif

#include "SMEvent.h"


namespace SMIDILib {

//******************************************************************************
// VXebZ[WCxgNX
//******************************************************************************
class SMIDILIB_API SMEventSysMsg
{
public:

	//VXebZ[W
	enum SysMsg {
		None						= 0x00, // none
		//VXeRbZ[W
		Common_QuarterFrame			= 0xF1, // F1 dd
		Common_SongPositionPointer	= 0xF2, // F2 dl dm
		Common_SongSelect			= 0xF3, // F3 dd
		Common_TuneRequest			= 0xF6, // F6
		//VXeA^CbZ[W
		RealTime_TimingClock		= 0xF8, // F8
		RealTime_Start				= 0xFA, // FA
		RealTime_Continue			= 0xFB, // FB
		RealTime_Stop				= 0xFC, // FC
		RealTime_ActiveSensing		= 0xFE, // FE
		RealTime_SystemReset		= 0xFF  // FF
	};

public:

	//RXgN^^fXgN^
	SMEventSysMsg();
	virtual ~SMEventSysMsg(void);
	
	//CxgA^b`
	void Attach(SMEvent* pEvent);
	
	//MIDIo̓bZ[W擾
	int GetMIDIOutShortMsg(unsigned long* pMsg, unsigned long* pSize);
	
	//VXebZ[W擾
	SysMsg GetSysMsg();
	
private:
	
	SMEvent* m_pEvent;
	
	//ƃRs[RXgN^̋֎~
	void operator=(const SMEventSysMsg&);
	SMEventSysMsg(const SMEventSysMsg&);
	
};

} // end of namespace


