//******************************************************************************
//
// MIDITrail / MTFileSearchResultsViewCtrl
//
// ファイル検索結果ビュー制御クラス
//
// Copyright (C) 2019-2020 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import <UIKit/UIKit.h>


//******************************************************************************
// ファイル検索結果ビュー制御クラス
//******************************************************************************
@interface MTFileSearchResultsViewCtrl : UITableViewController {
	
	//選択ファイルインデックス
	NSInteger m_SelectedFileIndex;
	
	//検索結果ファイル名一覧
	NSMutableArray* m_pFilteredFileArray;
	
	//ファイル属性辞書
	NSMutableDictionary* m_pFileAttributesDictionary;
	
	//ファイル選択通知名称
	NSString* m_pNotificationNameForSelectFile;
}

//ビュー登録完了
- (void)viewDidLoad;

//インターフェース自動回転確認（iOS6以降）
//- (BOOL)shouldAutorotate;
//- (NSUInteger)supportedInterfaceOrientations;

//セクション数
-(NSInteger)numberOfSectionsInTableView:(UITableView*)tableView;

//セクションごとの項目数
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section;

//項目表示内容
- (UITableViewCell*)tableView:(UITableView*)tableView cellForRowAtIndexPath:(NSIndexPath*)indexPath;

//検索結果登録
- (int)setResults:(NSMutableArray*)pResultsArray fileAttributesDictionary:(NSMutableDictionary*)pFileAttributesDictionary;

//選択ファイル名取得
- (NSString*)selectedFileName;

//ファイル選択通知名称設定
- (void)setNotificationNameForSelectFile:(NSString*)pNotificationName;

@end

