//******************************************************************************
//
// MIDITrail / MTViewActionViewCtrl
//
// Viewアクションビュー制御クラス
//
// Copyright (C) 2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import <UIKit/UIKit.h>


//******************************************************************************
// パラメータ定義
//******************************************************************************

//Viewアクション通知
#define MT_NOTIFICATION_ON_VIEW_ACTION		@"MT_Notification_onViewAction"


//******************************************************************************
// Viewアクションビュー制御クラス
//******************************************************************************
@interface MTViewActionViewCtrl : UIViewController <UITableViewDelegate, UITableViewDataSource> {
	
	//テーブルビュー
	UITableView* m_pTableView;
	
	//スクリーンロック状態
	BOOL m_isScreenLocked;
	
}

//ビュー登録完了
- (void)viewDidLoad;

//ビュー表示
- (void)viewWillAppear:(BOOL)animated;

//ビュー非表示
- (void)viewDidDisappear:(BOOL)animated;

//スクリーンロック状態設定
- (void)setScreenLockStatus:(BOOL)isLocked;

//セクション数
-(NSInteger)numberOfSectionsInTableView:(UITableView*)tableView;

//セクションヘッダ
- (NSString*)tableView:(UITableView*)tableView titleForHeaderInSection:(NSInteger)section;

//セクションごとの項目数
- (NSInteger)tableView:(UITableView *)tableView
 numberOfRowsInSection:(NSInteger)section;

//項目表示内容
- (UITableViewCell*)tableView:(UITableView*)tableView
		cellForRowAtIndexPath:(NSIndexPath*)indexPath;

//テーブルセル選択イベント
- (void)tableView:(UITableView*)tableView didSelectRowAtIndexPath:(NSIndexPath*)indexPath;

//タッチイベント：開始
- (void)touchesBegan:(NSSet*)touches withEvent:(UIEvent *)event;

//タッチイベント：移動
- (void)touchesMoved:(NSSet*)touches withEvent:(UIEvent *)event;

//タッチイベント：終了
- (void)touchesEnded:(NSSet*)touches withEvent:(UIEvent *)event;

//タッチイベント：キャンセル
- (void)touchesCancelled:(NSSet*)touches withEvent:(UIEvent *)event;

@end

