//******************************************************************************
//
// MIDITrail / MTColorCfgDlg
//
// カラー設定ダイアログ
//
// Copyright (C) 2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "YNBaseLib.h"
#import "MTColorCfgDlg.h"
#import "MTColorPaletteCfgDlg.h"


//##############################################################################
// カラー設定ダイアログクラス
//##############################################################################
@implementation MTColorCfgDlg

//******************************************************************************
// 生成
//******************************************************************************
- (id)init
{
	//Nibファイルを指定してウィンドウコントローラを生成
	return [super initWithWindowNibName:@"ColorCfgDlg"];
}

//******************************************************************************
// 破棄
//******************************************************************************
- (void)dealloc
{
	[super dealloc];
}

//******************************************************************************
// ウィンドウ読み込み完了
//******************************************************************************
- (void)windowDidLoad
{
	int result = 0;
	
	//ウィンドウ表示項目初期化
	//  モーダル終了後に再度モーダル表示してもwindowDidLoadは呼び出されない
	result = [self initDlg];
	if (result != 0) goto EXIT;
	
EXIT:;
	if (result != 0) YN_SHOW_ERR();
}

//******************************************************************************
// モーダルウィンドウ表示
//******************************************************************************
- (void)showModalWindow
{
	m_isChanged = NO;
	
	//モーダルウィンドウ表示
	[NSApp runModalForWindow:[self window]];
	
	//モーダル表示終了後はウィンドウを非表示にする
	[[self window] orderOut:self];
}

//******************************************************************************
// 変更確認
//******************************************************************************
- (BOOL)isCahnged
{
	return m_isChanged;
}

//******************************************************************************
// ダイアログ初期化
//******************************************************************************
- (int)initDlg
{
	int result = 0;
	
	//ラジオボタンリスト初期化
	[self initRadioButtonList];
	
	//カラーウェルリスト初期化
	[self initColorWellList];
	
	//色設定初期化：PianoRoll3D.ini の色設定をデフォルト設定として表示
	result = m_ColorConf.Initialize(@"PianoRoll3D");
	if (result != 0) goto EXIT;
	
	//ラジオボタン初期化
	result = [self initRadioButtons];
	if (result != 0) goto EXIT;
	
	//カラーパレット初期化
	result = [self initColorWells];
	if (result != 0) goto EXIT;
	
EXIT:;
	return result;
}

//******************************************************************************
// ラジオボタンリスト初期化
//******************************************************************************
- (void)initRadioButtonList
{
	m_pBtnRadioPaletteList[0] = m_pBtnRadioDefault;
	m_pBtnRadioPaletteList[1] = m_pBtnRadioPalette1;
	m_pBtnRadioPaletteList[2] = m_pBtnRadioPalette2;
	m_pBtnRadioPaletteList[3] = m_pBtnRadioPalette3;
	m_pBtnRadioPaletteList[4] = m_pBtnRadioPalette4;
	m_pBtnRadioPaletteList[5] = m_pBtnRadioPalette5;
	m_pBtnRadioPaletteList[6] = m_pBtnRadioPalette6;
}

//******************************************************************************
// カラーウェルリスト初期化
//******************************************************************************
- (void)initColorWellList
{
	//カラーパレット 0
	m_pColorWellList[0][0] = m_pColorWell_0_1;
	m_pColorWellList[0][1] = m_pColorWell_0_2;
	m_pColorWellList[0][2] = m_pColorWell_0_3;
	m_pColorWellList[0][3] = m_pColorWell_0_4;
	m_pColorWellList[0][4] = m_pColorWell_0_5;
	m_pColorWellList[0][5] = m_pColorWell_0_6;
	m_pColorWellList[0][6] = m_pColorWell_0_7;
	m_pColorWellList[0][7] = m_pColorWell_0_8;
	m_pColorWellList[0][8] = m_pColorWell_0_9;
	m_pColorWellList[0][9] = m_pColorWell_0_10;
	m_pColorWellList[0][10] = m_pColorWell_0_11;
	m_pColorWellList[0][11] = m_pColorWell_0_12;
	m_pColorWellList[0][12] = m_pColorWell_0_13;
	m_pColorWellList[0][13] = m_pColorWell_0_14;
	m_pColorWellList[0][14] = m_pColorWell_0_15;
	m_pColorWellList[0][15] = m_pColorWell_0_16;
	m_pColorWellList[0][16] = m_pColorWell_0_BG;
	m_pColorWellList[0][17] = m_pColorWell_0_GL;
	m_pColorWellList[0][18] = m_pColorWell_0_CT;
	//カラーパレット 1
	m_pColorWellList[1][0] = m_pColorWell_1_1;
	m_pColorWellList[1][1] = m_pColorWell_1_2;
	m_pColorWellList[1][2] = m_pColorWell_1_3;
	m_pColorWellList[1][3] = m_pColorWell_1_4;
	m_pColorWellList[1][4] = m_pColorWell_1_5;
	m_pColorWellList[1][5] = m_pColorWell_1_6;
	m_pColorWellList[1][6] = m_pColorWell_1_7;
	m_pColorWellList[1][7] = m_pColorWell_1_8;
	m_pColorWellList[1][8] = m_pColorWell_1_9;
	m_pColorWellList[1][9] = m_pColorWell_1_10;
	m_pColorWellList[1][10] = m_pColorWell_1_11;
	m_pColorWellList[1][11] = m_pColorWell_1_12;
	m_pColorWellList[1][12] = m_pColorWell_1_13;
	m_pColorWellList[1][13] = m_pColorWell_1_14;
	m_pColorWellList[1][14] = m_pColorWell_1_15;
	m_pColorWellList[1][15] = m_pColorWell_1_16;
	m_pColorWellList[1][16] = m_pColorWell_1_BG;
	m_pColorWellList[1][17] = m_pColorWell_1_GL;
	m_pColorWellList[1][18] = m_pColorWell_1_CT;
	//カラーパレット 2
	m_pColorWellList[2][0] = m_pColorWell_2_1;
	m_pColorWellList[2][1] = m_pColorWell_2_2;
	m_pColorWellList[2][2] = m_pColorWell_2_3;
	m_pColorWellList[2][3] = m_pColorWell_2_4;
	m_pColorWellList[2][4] = m_pColorWell_2_5;
	m_pColorWellList[2][5] = m_pColorWell_2_6;
	m_pColorWellList[2][6] = m_pColorWell_2_7;
	m_pColorWellList[2][7] = m_pColorWell_2_8;
	m_pColorWellList[2][8] = m_pColorWell_2_9;
	m_pColorWellList[2][9] = m_pColorWell_2_10;
	m_pColorWellList[2][10] = m_pColorWell_2_11;
	m_pColorWellList[2][11] = m_pColorWell_2_12;
	m_pColorWellList[2][12] = m_pColorWell_2_13;
	m_pColorWellList[2][13] = m_pColorWell_2_14;
	m_pColorWellList[2][14] = m_pColorWell_2_15;
	m_pColorWellList[2][15] = m_pColorWell_2_16;
	m_pColorWellList[2][16] = m_pColorWell_2_BG;
	m_pColorWellList[2][17] = m_pColorWell_2_GL;
	m_pColorWellList[2][18] = m_pColorWell_2_CT;
	//カラーパレット 3
	m_pColorWellList[3][0] = m_pColorWell_3_1;
	m_pColorWellList[3][1] = m_pColorWell_3_2;
	m_pColorWellList[3][2] = m_pColorWell_3_3;
	m_pColorWellList[3][3] = m_pColorWell_3_4;
	m_pColorWellList[3][4] = m_pColorWell_3_5;
	m_pColorWellList[3][5] = m_pColorWell_3_6;
	m_pColorWellList[3][6] = m_pColorWell_3_7;
	m_pColorWellList[3][7] = m_pColorWell_3_8;
	m_pColorWellList[3][8] = m_pColorWell_3_9;
	m_pColorWellList[3][9] = m_pColorWell_3_10;
	m_pColorWellList[3][10] = m_pColorWell_3_11;
	m_pColorWellList[3][11] = m_pColorWell_3_12;
	m_pColorWellList[3][12] = m_pColorWell_3_13;
	m_pColorWellList[3][13] = m_pColorWell_3_14;
	m_pColorWellList[3][14] = m_pColorWell_3_15;
	m_pColorWellList[3][15] = m_pColorWell_3_16;
	m_pColorWellList[3][16] = m_pColorWell_3_BG;
	m_pColorWellList[3][17] = m_pColorWell_3_GL;
	m_pColorWellList[3][18] = m_pColorWell_3_CT;
	//カラーパレット 4
	m_pColorWellList[4][0] = m_pColorWell_4_1;
	m_pColorWellList[4][1] = m_pColorWell_4_2;
	m_pColorWellList[4][2] = m_pColorWell_4_3;
	m_pColorWellList[4][3] = m_pColorWell_4_4;
	m_pColorWellList[4][4] = m_pColorWell_4_5;
	m_pColorWellList[4][5] = m_pColorWell_4_6;
	m_pColorWellList[4][6] = m_pColorWell_4_7;
	m_pColorWellList[4][7] = m_pColorWell_4_8;
	m_pColorWellList[4][8] = m_pColorWell_4_9;
	m_pColorWellList[4][9] = m_pColorWell_4_10;
	m_pColorWellList[4][10] = m_pColorWell_4_11;
	m_pColorWellList[4][11] = m_pColorWell_4_12;
	m_pColorWellList[4][12] = m_pColorWell_4_13;
	m_pColorWellList[4][13] = m_pColorWell_4_14;
	m_pColorWellList[4][14] = m_pColorWell_4_15;
	m_pColorWellList[4][15] = m_pColorWell_4_16;
	m_pColorWellList[4][16] = m_pColorWell_4_BG;
	m_pColorWellList[4][17] = m_pColorWell_4_GL;
	m_pColorWellList[4][18] = m_pColorWell_4_CT;
	//カラーパレット 5
	m_pColorWellList[5][0] = m_pColorWell_5_1;
	m_pColorWellList[5][1] = m_pColorWell_5_2;
	m_pColorWellList[5][2] = m_pColorWell_5_3;
	m_pColorWellList[5][3] = m_pColorWell_5_4;
	m_pColorWellList[5][4] = m_pColorWell_5_5;
	m_pColorWellList[5][5] = m_pColorWell_5_6;
	m_pColorWellList[5][6] = m_pColorWell_5_7;
	m_pColorWellList[5][7] = m_pColorWell_5_8;
	m_pColorWellList[5][8] = m_pColorWell_5_9;
	m_pColorWellList[5][9] = m_pColorWell_5_10;
	m_pColorWellList[5][10] = m_pColorWell_5_11;
	m_pColorWellList[5][11] = m_pColorWell_5_12;
	m_pColorWellList[5][12] = m_pColorWell_5_13;
	m_pColorWellList[5][13] = m_pColorWell_5_14;
	m_pColorWellList[5][14] = m_pColorWell_5_15;
	m_pColorWellList[5][15] = m_pColorWell_5_16;
	m_pColorWellList[5][16] = m_pColorWell_5_BG;
	m_pColorWellList[5][17] = m_pColorWell_5_GL;
	m_pColorWellList[5][18] = m_pColorWell_5_CT;
	//カラーパレット 6
	m_pColorWellList[6][0] = m_pColorWell_6_1;
	m_pColorWellList[6][1] = m_pColorWell_6_2;
	m_pColorWellList[6][2] = m_pColorWell_6_3;
	m_pColorWellList[6][3] = m_pColorWell_6_4;
	m_pColorWellList[6][4] = m_pColorWell_6_5;
	m_pColorWellList[6][5] = m_pColorWell_6_6;
	m_pColorWellList[6][6] = m_pColorWell_6_7;
	m_pColorWellList[6][7] = m_pColorWell_6_8;
	m_pColorWellList[6][8] = m_pColorWell_6_9;
	m_pColorWellList[6][9] = m_pColorWell_6_10;
	m_pColorWellList[6][10] = m_pColorWell_6_11;
	m_pColorWellList[6][11] = m_pColorWell_6_12;
	m_pColorWellList[6][12] = m_pColorWell_6_13;
	m_pColorWellList[6][13] = m_pColorWell_6_14;
	m_pColorWellList[6][14] = m_pColorWell_6_15;
	m_pColorWellList[6][15] = m_pColorWell_6_16;
	m_pColorWellList[6][16] = m_pColorWell_6_BG;
	m_pColorWellList[6][17] = m_pColorWell_6_GL;
	m_pColorWellList[6][18] = m_pColorWell_6_CT;
}

//******************************************************************************
// ラジオボタン初期化
//******************************************************************************
- (int)initRadioButtons
{
	int result = 0;
	unsigned int colorPaletteNo = 0;
	
	//選択カラーパレット番号取得
	colorPaletteNo = m_ColorConf.GetSelectedColorPaletteNo();
	if (colorPaletteNo >= MT_COLOR_PALETTE_NUM_MAX) {
			result = YN_SET_ERR(@"Program error.", colorPaletteNo, 0);
			goto EXIT;
	}
	
	//ラジオボタン選択状態設定
	m_pBtnRadioPaletteList[colorPaletteNo].state = NSOnState;
	m_SelectedColorPaletteNo = colorPaletteNo;
	
EXIT:;
	return result;
}

//******************************************************************************
// カラーウェル初期化
//******************************************************************************
- (int)initColorWells
{
	int result = 0;
	unsigned int colorPaletteNo = 0;
	MTColorPalette colorPalette;
	
	//カラーパレット 0-6 初期化
	for (colorPaletteNo = 0; colorPaletteNo < MT_COLOR_PALETTE_NUM_MAX; colorPaletteNo++) {
		//カラーパレット取得
		result = m_ColorConf.GetColorPalette(colorPaletteNo, &colorPalette);
		if (result != 0) goto EXIT;
		//カラーウェル更新
		result = [self updateColorWellForColorPaletteNo:colorPaletteNo];
		if (result != 0) goto EXIT;
	}
	
EXIT:;
	return result;
}

//******************************************************************************
// カラーウェル更新
//******************************************************************************
- (int)updateColorWellForColorPaletteNo:(unsigned int)colorPaletteNo
{
	int result = 0;
	unsigned int chNo = 0;
	MTColorPalette colorPalette;
	OGLCOLOR color;
	
	//カラーパレット取得
	result = m_ColorConf.GetColorPalette(colorPaletteNo, &colorPalette);
	if (result != 0) goto EXIT;
	
	//カラーウェル設定：Ch.1 - 16
	for (chNo = 0; chNo < SM_MAX_CH_NUM; chNo++) {
		colorPalette.GetChColor(chNo, &color);
		m_pColorWellList[colorPaletteNo][chNo].color = [NSColor colorWithRed:color.r green:color.g blue:color.b alpha:color.a];
	}
	
	//カラーウェル設定：BG
	colorPalette.GetBackgroundColor(&color);
	m_pColorWellList[colorPaletteNo][SM_MAX_CH_NUM + 0].color = [NSColor colorWithRed:color.r green:color.g blue:color.b alpha:color.a];
	
	//カラーウェル設定：グリッドライン
	colorPalette.GetGridLineColor(&color);
	m_pColorWellList[colorPaletteNo][SM_MAX_CH_NUM + 1].color = [NSColor colorWithRed:color.r green:color.g blue:color.b alpha:color.a];
	
	//カラーウェル設定：カウンター
	colorPalette.GetCounterColor(&color);
	m_pColorWellList[colorPaletteNo][SM_MAX_CH_NUM + 2].color = [NSColor colorWithRed:color.r green:color.g blue:color.b alpha:color.a];
	
EXIT:;
	return result;
}

//******************************************************************************
// OKボタン押下
//******************************************************************************
- (IBAction)onOK:(id)sender
{
	int result = 0;
	
	//カラー設定を保存
	result = m_ColorConf.Save();
	if (result != 0) goto EXIT;
	
	//ダイアログを閉じる
	m_isChanged = YES;
	[NSApp stopModal];
	
EXIT:;
	if (result != 0) YN_SHOW_ERR();
	return;
}

//******************************************************************************
// Cancelボタン押下：またはESCキー押下
//******************************************************************************
- (IBAction)onCancel:(id)sender
{
	//モーダル表示終了
	[NSApp stopModal];
}

//******************************************************************************
// クローズボタン押下
//******************************************************************************
- (void)windowWillClose:(NSNotification*)aNotification
{
	//モーダル表示終了
	[NSApp stopModal];
}

//******************************************************************************
// ラジオボタン押下
//******************************************************************************
- (IBAction)onBtnRadio:(NSButton *)sender
{
	int result = 0;
	unsigned int colorPaletteNo = 0;
	
	//NSLog(@"onBtnRadio %@", sender.title);
	
	//選択されたラジオボタンを特定
	for (colorPaletteNo = 0; colorPaletteNo < MT_COLOR_PALETTE_NUM_MAX; colorPaletteNo++) {
		if ([m_pBtnRadioPaletteList[colorPaletteNo].title isEqualToString:sender.title]) {
			m_SelectedColorPaletteNo = colorPaletteNo;
			//NSLog(@"onBtnRadio %u", colorPaletteNo);
			break;
		}
	}
	
	//カラー設定に登録
	result = m_ColorConf.SetSelectedColorPaletteNo(m_SelectedColorPaletteNo);
	if (result != 0) goto EXIT;
	
EXIT:;
	if (result != 0) YN_SHOW_ERR();
	return;
}

//******************************************************************************
// 編集1 ボタン押下
//******************************************************************************
- (IBAction)onBtnEdit1:(id)sender
{
	int result = 0;
	
	result = [self showColorPaletteCfgDlgForPaletteNo:1];
	if (result != 0) goto EXIT;
	
EXIT:;
	if (result != 0) YN_SHOW_ERR();
	return;
}

//******************************************************************************
// 編集2 ボタン押下
//******************************************************************************
- (IBAction)onBtnEdit2:(id)sender
{
	int result = 0;
	
	result = [self showColorPaletteCfgDlgForPaletteNo:2];
	if (result != 0) goto EXIT;
	
EXIT:;
	if (result != 0) YN_SHOW_ERR();
	return;
}

//******************************************************************************
// 編集3 ボタン押下
//******************************************************************************
- (IBAction)onBtnEdit3:(id)sender
{
	int result = 0;
	
	result = [self showColorPaletteCfgDlgForPaletteNo:3];
	if (result != 0) goto EXIT;
	
EXIT:;
	if (result != 0) YN_SHOW_ERR();
	return;
}

//******************************************************************************
// 編集4 ボタン押下
//******************************************************************************
- (IBAction)onBtnEdit4:(id)sender
{
	int result = 0;
	
	result = [self showColorPaletteCfgDlgForPaletteNo:4];
	if (result != 0) goto EXIT;
	
EXIT:;
	if (result != 0) YN_SHOW_ERR();
	return;
}

//******************************************************************************
// 編集5 ボタン押下
//******************************************************************************
- (IBAction)onBtnEdit5:(id)sender
{
	int result = 0;
	
	result = [self showColorPaletteCfgDlgForPaletteNo:5];
	if (result != 0) goto EXIT;
	
EXIT:;
	if (result != 0) YN_SHOW_ERR();
	return;
}

//******************************************************************************
// 編集6 ボタン押下
//******************************************************************************
- (IBAction)onBtnEdit6:(id)sender
{
	int result = 0;
	
	result = [self showColorPaletteCfgDlgForPaletteNo:6];
	if (result != 0) goto EXIT;
	
EXIT:;
	if (result != 0) YN_SHOW_ERR();
	return;
}

//******************************************************************************
// カラーパレット設定ダイアログ表示
//******************************************************************************
- (int)showColorPaletteCfgDlgForPaletteNo:(unsigned int)colorPaletteNo
{
	int result = 0;
	MTColorPaletteCfgDlg* pColorPaletteCfgDlg = nil;
	MTColorPalette colorPalette;
	MTColorPalette defaultColorPalette;
	
	//カラーパレット取得
	result = m_ColorConf.GetColorPalette(colorPaletteNo, &colorPalette);
	if (result != 0) goto EXIT;
	result = m_ColorConf.GetColorPalette(0, &defaultColorPalette);
	if (result != 0) goto EXIT;

	//ウィンドウ生成
	pColorPaletteCfgDlg = [[MTColorPaletteCfgDlg alloc] init];
	if (pColorPaletteCfgDlg == nil) {
		result = YN_SET_ERR(@"Program error.", 0, 0);
		goto EXIT;
	}
	
	//カラーパレット設定
	[pColorPaletteCfgDlg setColorPalette:&colorPalette
					 defaultColorPalette:&defaultColorPalette
						  colorPaletteNo:colorPaletteNo];
	
	//モーダルウィンドウ表示
	[pColorPaletteCfgDlg showModalWindow];
	
	//ダイアログで編集されたカラーパレットを画面に反映
	if ([pColorPaletteCfgDlg isCahnged]) {
		//更新されたカラーパレットを取得
		[pColorPaletteCfgDlg getColorPalette:&colorPalette];
		//カラーパレット登録
		result = m_ColorConf.SetColorPalette(colorPaletteNo, &colorPalette);
		if (result != 0) goto EXIT;
		//カラーウェル更新
		result = [self updateColorWellForColorPaletteNo:colorPaletteNo];
		if (result != 0) goto EXIT;
	}
	
EXIT:;
	[pColorPaletteCfgDlg release];
	return result;
}

@end

