//******************************************************************************
//
// MIDITrail / MTMainView
//
// メインビュー制御クラス
//
// Copyright (C) 2010-2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import <Cocoa/Cocoa.h>
#import <GameController/GameController.h>
#import "SMIDILib.h"
#import "OGLUtil.h"
#import "MTMachTime.h"
#import "MTScene.h"
#import "MTMenuCtrl.h"
#import "MTSceneMsgQueue.h"
#import "DIKeyCtrl.h"
#import "MTGamePadCtrl.h"


//******************************************************************************
// メインビュー制御クラス
//******************************************************************************
@interface MTMainView : MTKView <MTKViewDelegate> {
	
	//描画制御系
	id <MTLDevice> m_MTLDevice;
	OGLRenderer m_Renderer;
	OGLRedererParam m_RendererParam;
	MTScene* m_pScene;
	
	//メッセージ制御系
	SMMsgQueue* m_pMsgQueue;
	MTSceneMsgQueue m_SceneMsgQueue;
	
	//画面制御系
	MTMenuCtrl* m_pMenuCtrl;
	float m_FPS;
	MTMachTime m_MachTime;
	uint64_t m_PrevFPSUpdateTime;
	int m_DrawCount;
	
	//ドラッグ処理系
	BOOL m_isDragAcceptable;
	BOOL m_isDragging;
	
	//キーボード情報
	DIKeyCtrl m_DIKeyCtrl;
	
	//モニタフラグ
	BOOL m_isMonitor;
	
	//ゲームコントローラー制御
	MTGamePadCtrl m_GamePadCtrl;
	
	//ゲームパッド用視点番号
	int m_GamePadViewPointNo;
}

//--------------------------------------
// NSView 属性設定

//ファーストレスポンダ受け入れ
- (BOOL)acceptsFirstResponder;

//ディスプレイリンク初期化
- (void)setupCVDisplayLink;

//--------------------------------------
// 公開I/F

//生成
- (id)initWithFrame:(NSRect)frameRect rendererParam:(OGLRedererParam)rendererParam;

//初期化処理
- (int)initialize:(SMMsgQueue*)pMsgQueue menuCtrl:(MTMenuCtrl*)pMenuCtrl;

//終了処理
- (void)terminate;

//シーン生成
- (int)createScene:(MTScene*)pScene seqData:(SMSeqData*)pSeqData;

//シーン開始
- (int)startScene:(MTScene*)pScene isMonitor:(BOOL)isMonitor;

//シーン停止
- (int)stopScene;

//シーン一時停止
- (int)pauseScene;

//シーン再開
- (int)resumeScene;

//シーン操作：演奏開始
- (int)scene_PlayStart;

//シーン操作：演奏終了
- (int)scene_PlayEnd;

//シーン操作：巻き戻し
- (int)scene_Rewind;

//シーン操作：視点リセット
- (int)scene_ResetViewpoint;

//シーン操作：視点登録
- (int)scene_SetViewpoint:(MTScene::MTViewParamMap*)pParamMap;

//シーン操作：視点取得
- (int)scene_GetViewpoint:(MTScene::MTViewParamMap*)pParamMap;

//シーン操作：エフェクト設定
- (int)scene_SetEffect:(MTScene::EffectType)type isEnable:(bool)isEnable;

//シーン操作：マウスクリックイベント
- (int)scene_OnMouseClick:(unsigned int)button;

//シーン操作：マウスホイールイベント
- (int)scene_OnMouseWheelWithDeltaX:(float)dX deltaY:(float)dY deltaZ:(float)dZ;

//アプリケーションアクティブ状態設定
- (void)setActiveState:(BOOL)isActive;

//ドラッグ許可設定
- (void)setDragAcceptable:(BOOL)isAcceptable;

//FPS取得
- (float)FPS;

//フルスクリーン開始
- (int)enterFullScreen;

//フルスクリーン終了
- (int)exitFullScreen;

//--------------------------------------
// シーン描画スレッド

//シーン描画
- (void)thread_DrawScene;

//描画処理
- (int)thread_DrawProc;

//シーケンサメッセージ処理
- (int)thread_SequencerMsgProc;

//シーンメッセージ処理
- (int)thread_SceneMsgProc;

// シーンメッセージ実行
- (int)thread_ExecSceneMsg:(MTSceneMsg*)pMsg;

//演奏状態変更通知受信処理
- (int)thread_PostPlayStatus:(NSString*)pNotificationName;

//FPS更新
- (void)thread_UpdateFPS;

//--------------------------------------
// イベントハンドラ

//キー押下イベント
- (void)keyDown:(NSEvent*)theEvent;

//マウス左クリックイベント
- (void)mouseDown:(NSEvent*)theEvent;

//マウス右クリックイベント
- (void)rightMouseDown:(NSEvent*)theEvent;

//マウス中ボタン押下イベント
- (void)otherMouseDown:(NSEvent*)theEvent;

//マウスホイールイベント
- (void)scrollWheel:(NSEvent*)theEvent;

//ファイルドロップ対応
- (NSDragOperation)draggingEntered:(id)sender;
- (NSDragOperation)draggingUpdated:(id)sender;
- (void)draggingExited:(id)sender;
- (BOOL)prepareForDragOperation:(id)sender;
- (BOOL)performDragOperation:(id <NSDraggingInfo>)sender;
- (void)concludeDragOperation:(id)sender;
- (BOOL)isAcceptableObject:(id)sender path:(NSString**)pPathPtr isDir:(BOOL*)pIsDir;

//ゲームコントローラー対応
- (void)onGameControllerDidConnect;
- (void)onGameControllerDidDisconnect;
- (int)initializeGameController;
- (void)changeViewPoint:(int)step;

@end


