//******************************************************************************
//
// OGL Utility / OGLCameraOrtho
//
// 平行投影カメラクラス
//
// Copyright (C) 2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "OGLCameraOrtho.h"
#import "YNBaseLib.h"
#import <math.h>


//******************************************************************************
// コンストラクタ
//******************************************************************************
OGLCameraOrtho::OGLCameraOrtho(void)
{
}

//******************************************************************************
// デストラクタ
//******************************************************************************
OGLCameraOrtho::~OGLCameraOrtho(void)
{
}

//******************************************************************************
// 変換
//******************************************************************************
int OGLCameraOrtho::Transform(
		OGLDevice* pOGLDevice
	)
{
	int result = 0;
	OGLVIEWPORT viewPort;
	matrix_float4x4 projectionMatrix;
	
	//ビューポート取得
	pOGLDevice->GetViewPort(&viewPort);
	
	//プロジェクション行列
	projectionMatrix = _glOrtho(
								0.0f,				//左
								viewPort.width,		//右
								viewPort.height,	//下
								0.0f,				//上
								-1.0f,				//near
								1.0f				//far
							);
	
	//行列登録
	pOGLDevice->SetModelMatrix(matrix_identity_float4x4);
	pOGLDevice->SetViewMatrix(matrix_identity_float4x4);
	pOGLDevice->SetProjectionMatrix(projectionMatrix);
	
EXIT:;
	return result;
}

//******************************************************************************
// glOrtho 代替関数
//******************************************************************************
matrix_float4x4 OGLCameraOrtho::_glOrtho(
		OGLfloat left,		//左
		OGLfloat right,		//右
		OGLfloat bottom,	//下
		OGLfloat top,		//上
		OGLfloat near,		//near
		OGLfloat far		//far
	)
{
	//座標：左手系
	//行列：Metal,OpenGLは列優先(Column major order)
	matrix_float4x4 matrix = {{
		{ 2.0f / (right - left),            0,                               0,                             0 },
		{ 0,                                2.0f / (top - bottom),           0,                             0 },
		{ 0,                                0,                               2.0f / (far - near),           0 },
		{ -(right + left) / (right - left), -(top + bottom) / (top - bottom), -(far + near) / (far - near), 1 }
	}};
	
	return matrix;
}

