//******************************************************************************
//
// MIDITrail / MTColorConf
//
// J[ݒNX
//
// Copyright (C) 2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#pragma once

#include "MTColorPalette.h"

using namespace YNBaseLib;


//******************************************************************************
// p[^`
//******************************************************************************
//J[pbgőliftHgݒ܂ށj
#define MT_COLOR_PALETTE_NUM_MAX	(7)


//******************************************************************************
// J[ݒNX
//******************************************************************************
class MTColorConf
{
public:
	
	//RXgN^^fXgN^
	MTColorConf(void);
	virtual ~MTColorConf(void);
	
	//
	int Initialize(const TCHAR* pDefaultSceneName);
	
	//IJ[pbgԍ擾F0 ftHgA1-6 pbgԍ
	unsigned long GetSelectedColorPaletteNo();
	
	//IJ[pbgԍo^F0 ftHgA1-6 pbgԍ
	int SetSelectedColorPaletteNo(unsigned long paletteNo);
	
	//J[pbg擾F0 ftHgA1-6 pbgԍ
	int GetColorPalette(unsigned long paletteNo, MTColorPalette* pColorPalette);
	
	//IJ[pbg擾
	void GetSelectedColorPalette(MTColorPalette* pColorPalette);
	
	//J[pbgo^F1-6 pbgԍA0 ftHg͓o^s
	int SetColorPalette(unsigned long paletteNo, MTColorPalette* pColorPalette);
	
	//ݒۑ
	int Save();
	
private:
	
	//ƃRs[RXgN^̋֎~
	void operator=(const MTColorConf&);
	MTColorConf(const MTColorConf&);
	
	YNConfFile m_ConfFile;
	int m_SelectedColorPaletteNo;
	MTColorPalette* m_pColorPalette[MT_COLOR_PALETTE_NUM_MAX];
	
	int _InitConfFile();
	int _LoadColorConf(const TCHAR* pDefaultSceneName);
	int _LoadColorPaletteDefault(const TCHAR* pDefaultSceneName, MTColorPalette* pColorPalette);
	int _LoadColorPalettes(unsigned long paletteNo, MTColorPalette* pColorPalette);
	int _SaveColorPalette(unsigned long paletteNo, MTColorPalette* pColorPalette);
	
};


