//******************************************************************************
//
// MIDITrail / MTColorPalette
//
// J[pbgNX
//
// Copyright (C) 2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "MTColorPalette.h"

using namespace YNBaseLib;


//******************************************************************************
// RXgN^
//******************************************************************************
MTColorPalette::MTColorPalette(void)
{
	_Clear();
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTColorPalette::~MTColorPalette(void)
{
}

//******************************************************************************
// 
//******************************************************************************
int MTColorPalette::Initialize()
{
	int result = 0;
	
	_Clear();
	
	return result;
}

//******************************************************************************
// NA
//******************************************************************************
void MTColorPalette::_Clear()
{
	unsigned int chNo = 0;
	
	//F
	for (chNo = 0; chNo < SM_MAX_CH_NUM; chNo++) {
		m_ChColor[chNo] = D3DXCOLOR(1.0f, 1.0f, 1.0f, 1.0f);
	}
	m_BgColor       = D3DXCOLOR(1.0f, 1.0f, 1.0f, 1.0f);
	m_GridLineColor = D3DXCOLOR(1.0f, 1.0f, 1.0f, 1.0f);
	m_CounterColor  = D3DXCOLOR(1.0f, 1.0f, 1.0f, 1.0f);

	return;
}

//******************************************************************************
// `lF擾
//******************************************************************************
int MTColorPalette::GetChColor(unsigned int chNo, D3DXCOLOR* pColor)
{
	int result = 0;
	
	if (chNo >= SM_MAX_CH_NUM) {
		result = YN_SET_ERR("Program error.", chNo, 0);
		goto EXIT;
	}
	
	*pColor = m_ChColor[chNo];
	
EXIT:;
	return result;
}

//******************************************************************************
// `lFo^
//******************************************************************************
int MTColorPalette::SetChColor(unsigned int chNo, D3DXCOLOR color)
{
	int result = 0;
	
	if (chNo >= SM_MAX_CH_NUM) {
		result = YN_SET_ERR("Program error.", chNo, 0);
		goto EXIT;
	}
	
	m_ChColor[chNo] = color;
	
EXIT:;
	return result;
}

//******************************************************************************
// wiF擾
//******************************************************************************
void MTColorPalette::GetBackgroundColor(D3DXCOLOR* pColor)
{
	*pColor = m_BgColor;
}

//******************************************************************************
// wiFo^
//******************************************************************************
void MTColorPalette::SetBackgroundColor(D3DXCOLOR color)
{
	m_BgColor = color;
}

//******************************************************************************
// ObhCF擾
//******************************************************************************
void MTColorPalette::GetGridLineColor(D3DXCOLOR* pColor)
{
	*pColor = m_GridLineColor;
}

//******************************************************************************
// ObhCFo^
//******************************************************************************
void MTColorPalette::SetGridLineColor(D3DXCOLOR color)
{
	m_GridLineColor = color;
}

//******************************************************************************
// JE^[F擾
//******************************************************************************
void MTColorPalette::GetCounterColor(D3DXCOLOR* pColor)
{
	*pColor = m_CounterColor;
}

//******************************************************************************
// JE^[Fo^
//******************************************************************************
void MTColorPalette::SetCounterColor(D3DXCOLOR color)
{
	m_CounterColor = color;
}

//******************************************************************************
// Rs[
//******************************************************************************
int MTColorPalette::CopyFrom(MTColorPalette* pColorSrc)
{
	int result = 0;
	unsigned int chNo = 0;
	
	//`lF̃Rs[
	for (chNo = 0; chNo < SM_MAX_CH_NUM; chNo++) {
		result = pColorSrc->GetChColor(chNo, &m_ChColor[chNo]);
		if (result != 0) goto EXIT;
	}
	
	//wiF̃Rs[
	pColorSrc->GetBackgroundColor(&m_BgColor);
	
	//ObhCF̃Rs[
	pColorSrc->GetGridLineColor(&m_GridLineColor);
	
	//JE^[F̃Rs[
	pColorSrc->GetCounterColor(&m_CounterColor);
	
EXIT:;
	return result;
}


