//******************************************************************************
//
// MIDITrail / MTColorPaletteCfgDlg
//
// J[pbgݒ_CAO
//
// Copyright (C) 2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "resource.h"
#include "YNBaseLib.h"
#include "DXColorUtil.h"
#include "MTColorPaletteCfgDlg.h"
#include "MTColorParamExportDlg.h"
#include "MTColorParamImportDlg.h"
#include <Commdlg.h>
#include <sstream> //for std::stringstream
#include <istream> //for std::getline

using namespace YNBaseLib;


//******************************************************************************
// EBhEvV[Wpp[^ݒ
//******************************************************************************
MTColorPaletteCfgDlg* MTColorPaletteCfgDlg::m_pThis = NULL;

//******************************************************************************
// RXgN^
//******************************************************************************
MTColorPaletteCfgDlg::MTColorPaletteCfgDlg(void)
{
	unsigned long i = 0;
	
	m_pThis = this;
	m_hInstance = NULL;
	m_hWnd = NULL;
	m_ColorPaletteNo = 0;
	m_isChanged = false;

	//Fݒ Start/End
	m_ColorStart = D3DXCOLOR(1.0f, 1.0f, 1.0f, 1.0f); //RGBA
	m_ColorEnd = D3DXCOLOR(1.0f, 1.0f, 1.0f, 1.0f); //RGBA

	//FI_CAOpp[^
	for (i = 0; i < 16; i++) {
		m_CustColors[i] = RGB(255, 255, 255);
	}

	return;
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTColorPaletteCfgDlg::~MTColorPaletteCfgDlg(void)
{
	return;
}

//******************************************************************************
// J[pbgݒ
//******************************************************************************
void MTColorPaletteCfgDlg::SetColorPalette(
			MTColorPalette* pColorPalette, 
			MTColorPalette* pDefaultColorPalette,
		 	unsigned long colorPaletteNo
		 )
{
	m_ColorPalette.CopyFrom(pColorPalette);
	m_DefaultColorPalette.CopyFrom(pDefaultColorPalette);
	m_ColorPaletteNo = colorPaletteNo;
}

//******************************************************************************
// J[pbg擾
//******************************************************************************
void MTColorPaletteCfgDlg::GetColorPalette(MTColorPalette* pColorPalette)
{
	pColorPalette->CopyFrom(&m_ColorPalette);
}

//******************************************************************************
// \
//******************************************************************************
int MTColorPaletteCfgDlg::Show(
		HWND hParentWnd
	)
{
	int result = 0;
	INT_PTR dresult = 0;
	HINSTANCE hInstance = NULL;

	//AvP[VCX^Xnh擾
	hInstance = (HINSTANCE)(LONG_PTR)GetWindowLongPtr(hParentWnd, GWLP_HINSTANCE);
	if (hInstance == NULL) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), (DWORD64)hParentWnd);
		goto EXIT;
	}

	//_CAO\
	dresult = DialogBox(
					hInstance,							//CX^Xnh
					MAKEINTRESOURCE(IDD_COLOR_PALETTE_CFG),	//_CAO{bNXev[g
					hParentWnd,							//eEBhEnh
					_WndProc							//_CAO{bNXvV[W
				);
	if ((dresult == 0) || (dresult == -1)) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), (DWORD64)hInstance);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// p[^ύXmF
//******************************************************************************
bool MTColorPaletteCfgDlg::IsChanged()
{
	return m_isChanged;
}

//******************************************************************************
// EBhEvV[W
//******************************************************************************
INT_PTR CALLBACK MTColorPaletteCfgDlg::_WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	return m_pThis->_WndProcImpl(hWnd, message, wParam, lParam);
}

//******************************************************************************
// EBhEvV[WF
//******************************************************************************
INT_PTR MTColorPaletteCfgDlg::_WndProcImpl(
		HWND hDlg,
		UINT message,
		WPARAM wParam,
		LPARAM lParam
	)
{
	int result = 0;
	LRESULT lresult = 0;

	UNREFERENCED_PARAMETER(lParam);

	switch (message) {
		case WM_INITDIALOG:
			result = _OnInitDlg(hDlg);
			if (result != 0) goto EXIT;
			break;
		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK) {
				m_isChanged = true;
				EndDialog(hDlg, LOWORD(wParam));
			}
			else if (LOWORD(wParam) == IDCANCEL) {
				EndDialog(hDlg, LOWORD(wParam));
			}
			else if (LOWORD(wParam) == IDC_BTN_COLOR_1) {
				result = _OnBtnColor(0);
				if (result != 0) goto EXIT;
			}
			else if (LOWORD(wParam) == IDC_BTN_COLOR_2) {
				result = _OnBtnColor(1);
				if (result != 0) goto EXIT;
			}
			else if (LOWORD(wParam) == IDC_BTN_COLOR_3) {
				result = _OnBtnColor(2);
				if (result != 0) goto EXIT;
			}
			else if (LOWORD(wParam) == IDC_BTN_COLOR_4) {
				result = _OnBtnColor(3);
				if (result != 0) goto EXIT;
			}
			else if (LOWORD(wParam) == IDC_BTN_COLOR_5) {
				result = _OnBtnColor(4);
				if (result != 0) goto EXIT;
			}
			else if (LOWORD(wParam) == IDC_BTN_COLOR_6) {
				result = _OnBtnColor(5);
				if (result != 0) goto EXIT;
			}
			else if (LOWORD(wParam) == IDC_BTN_COLOR_7) {
				result = _OnBtnColor(6);
				if (result != 0) goto EXIT;
			}
			else if (LOWORD(wParam) == IDC_BTN_COLOR_8) {
				result = _OnBtnColor(7);
				if (result != 0) goto EXIT;
			}
			else if (LOWORD(wParam) == IDC_BTN_COLOR_9) {
				result = _OnBtnColor(8);
				if (result != 0) goto EXIT;
			}
			else if (LOWORD(wParam) == IDC_BTN_COLOR_10) {
				result = _OnBtnColor(9);
				if (result != 0) goto EXIT;
			}
			else if (LOWORD(wParam) == IDC_BTN_COLOR_11) {
				result = _OnBtnColor(10);
				if (result != 0) goto EXIT;
			}
			else if (LOWORD(wParam) == IDC_BTN_COLOR_12) {
				result = _OnBtnColor(11);
				if (result != 0) goto EXIT;
			}
			else if (LOWORD(wParam) == IDC_BTN_COLOR_13) {
				result = _OnBtnColor(12);
				if (result != 0) goto EXIT;
			}
			else if (LOWORD(wParam) == IDC_BTN_COLOR_14) {
				result = _OnBtnColor(13);
				if (result != 0) goto EXIT;
			}
			else if (LOWORD(wParam) == IDC_BTN_COLOR_15) {
				result = _OnBtnColor(14);
				if (result != 0) goto EXIT;
			}
			else if (LOWORD(wParam) == IDC_BTN_COLOR_16) {
				result = _OnBtnColor(15);
				if (result != 0) goto EXIT;
			}
			else if (LOWORD(wParam) == IDC_BTN_COLOR_BG) {
				result = _OnBtnColor(16);
				if (result != 0) goto EXIT;
			}
			else if (LOWORD(wParam) == IDC_BTN_COLOR_GL) {
				result = _OnBtnColor(17);
				if (result != 0) goto EXIT;
			}
			else if (LOWORD(wParam) == IDC_BTN_COLOR_CT) {
				result = _OnBtnColor(18);
				if (result != 0) goto EXIT;
			}
			else if (LOWORD(wParam) == IDC_BTN_COLOR_START) {
				result = _OnBtnColor(19);
				if (result != 0) goto EXIT;
			}
			else if (LOWORD(wParam) == IDC_BTN_COLOR_END) {
				result = _OnBtnColor(20);
				if (result != 0) goto EXIT;
			}
			else if (LOWORD(wParam) == IDC_BTN_SET_GRADATION_COLORS) {
				result = _OnBtnSetGradationColors();
				if (result != 0) goto EXIT;
			}
			else if (LOWORD(wParam) == IDC_BTN_SET_DEFAULT_COLORS) {
				result = _OnBtnSetDefaultColors();
				if (result != 0) goto EXIT;
			}
			else if (LOWORD(wParam) == IDC_BTN_EXPORT_COLOR_PARAMETERS) {
				result = _OonBtnExportColorParameters();
				if (result != 0) goto EXIT;
			}
			else if (LOWORD(wParam) == IDC_BTN_IMPORT_COLOR_PARAMETERS) {
				result = _OnBtnImportColorParameters();
				if (result != 0) goto EXIT;
			}
			break;
		case WM_DRAWITEM:
			//J[{^`
			result = _DrawColorButton((DRAWITEMSTRUCT*)lParam);
			if (result != 0) goto EXIT;
			break;
		default:
			//ȂbZ[W
			break;
	}

EXIT:;
	if (result != 0) {
		YN_SHOW_ERR(hDlg);
	}
	return lresult;
}

//******************************************************************************
// _CAO\O
//******************************************************************************
int MTColorPaletteCfgDlg::_OnInitDlg(HWND hDlg)
{
	int result = 0;

	m_hWnd = hDlg;
	m_isChanged = false;
	TCHAR title[256] = {_T('\0')};

	//J[{^Xg
	_InitColorButtonList();

	//J[{^
	result = _InitColorButtons();
	if (result != 0) goto EXIT;

	//J[eLXg
	result = _InitColorText();
	if (result != 0) goto EXIT;

	//EBhE^Cg
	_stprintf_s(title, 256, _T("Color Palette %u"), m_ColorPaletteNo);
	SetWindowText(m_hWnd, title);

	//R{{bNX Start/End 
	result = _InitCombobox(GetDlgItem(m_hWnd, IDC_COMBO_START), 0);
	if (result != 0) goto EXIT;
	result = _InitCombobox(GetDlgItem(m_hWnd, IDC_COMBO_END), SM_MAX_CH_NUM - 1);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// J[{^Xg
//******************************************************************************
void MTColorPaletteCfgDlg::_InitColorButtonList()
{
	//J[{^Xg
	m_hColorButtonList[0]  = GetDlgItem(m_hWnd, IDC_BTN_COLOR_1);
	m_hColorButtonList[1]  = GetDlgItem(m_hWnd, IDC_BTN_COLOR_2);
	m_hColorButtonList[2]  = GetDlgItem(m_hWnd, IDC_BTN_COLOR_3);
	m_hColorButtonList[3]  = GetDlgItem(m_hWnd, IDC_BTN_COLOR_4);
	m_hColorButtonList[4]  = GetDlgItem(m_hWnd, IDC_BTN_COLOR_5);
	m_hColorButtonList[5]  = GetDlgItem(m_hWnd, IDC_BTN_COLOR_6);
	m_hColorButtonList[6]  = GetDlgItem(m_hWnd, IDC_BTN_COLOR_7);
	m_hColorButtonList[7]  = GetDlgItem(m_hWnd, IDC_BTN_COLOR_8);
	m_hColorButtonList[8]  = GetDlgItem(m_hWnd, IDC_BTN_COLOR_9);
	m_hColorButtonList[9]  = GetDlgItem(m_hWnd, IDC_BTN_COLOR_10);
	m_hColorButtonList[10] = GetDlgItem(m_hWnd, IDC_BTN_COLOR_11);
	m_hColorButtonList[11] = GetDlgItem(m_hWnd, IDC_BTN_COLOR_12);
	m_hColorButtonList[12] = GetDlgItem(m_hWnd, IDC_BTN_COLOR_13);
	m_hColorButtonList[13] = GetDlgItem(m_hWnd, IDC_BTN_COLOR_14);
	m_hColorButtonList[14] = GetDlgItem(m_hWnd, IDC_BTN_COLOR_15);
	m_hColorButtonList[15] = GetDlgItem(m_hWnd, IDC_BTN_COLOR_16);
	m_hColorButtonList[16] = GetDlgItem(m_hWnd, IDC_BTN_COLOR_BG);
	m_hColorButtonList[17] = GetDlgItem(m_hWnd, IDC_BTN_COLOR_GL);
	m_hColorButtonList[18] = GetDlgItem(m_hWnd, IDC_BTN_COLOR_CT);
	m_hColorButtonList[19] = GetDlgItem(m_hWnd, IDC_BTN_COLOR_START);
	m_hColorButtonList[20] = GetDlgItem(m_hWnd, IDC_BTN_COLOR_END);
	//J[eLXgXg
	m_hColorTextList[0]  = GetDlgItem(m_hWnd, IDC_COLOR_TEXT_1);
	m_hColorTextList[1]  = GetDlgItem(m_hWnd, IDC_COLOR_TEXT_2);
	m_hColorTextList[2]  = GetDlgItem(m_hWnd, IDC_COLOR_TEXT_3);
	m_hColorTextList[3]  = GetDlgItem(m_hWnd, IDC_COLOR_TEXT_4);
	m_hColorTextList[4]  = GetDlgItem(m_hWnd, IDC_COLOR_TEXT_5);
	m_hColorTextList[5]  = GetDlgItem(m_hWnd, IDC_COLOR_TEXT_6);
	m_hColorTextList[6]  = GetDlgItem(m_hWnd, IDC_COLOR_TEXT_7);
	m_hColorTextList[7]  = GetDlgItem(m_hWnd, IDC_COLOR_TEXT_8);
	m_hColorTextList[8]  = GetDlgItem(m_hWnd, IDC_COLOR_TEXT_9);
	m_hColorTextList[9]  = GetDlgItem(m_hWnd, IDC_COLOR_TEXT_10);
	m_hColorTextList[10] = GetDlgItem(m_hWnd, IDC_COLOR_TEXT_11);
	m_hColorTextList[11] = GetDlgItem(m_hWnd, IDC_COLOR_TEXT_12);
	m_hColorTextList[12] = GetDlgItem(m_hWnd, IDC_COLOR_TEXT_13);
	m_hColorTextList[13] = GetDlgItem(m_hWnd, IDC_COLOR_TEXT_14);
	m_hColorTextList[14] = GetDlgItem(m_hWnd, IDC_COLOR_TEXT_15);
	m_hColorTextList[15] = GetDlgItem(m_hWnd, IDC_COLOR_TEXT_16);
	m_hColorTextList[16] = GetDlgItem(m_hWnd, IDC_COLOR_TEXT_BG);
	m_hColorTextList[17] = GetDlgItem(m_hWnd, IDC_COLOR_TEXT_GL);
	m_hColorTextList[18] = GetDlgItem(m_hWnd, IDC_COLOR_TEXT_CT);
	m_hColorTextList[19] = GetDlgItem(m_hWnd, IDC_COLOR_TEXT_START);
	m_hColorTextList[20] = GetDlgItem(m_hWnd, IDC_COLOR_TEXT_END);

	return;
}

//******************************************************************************
// J[{^
//******************************************************************************
int MTColorPaletteCfgDlg::_InitColorButtons()
{
	int result = 0;
	
	//WM_DRAWITEMbZ[WMɃ{^`悷邽߂ł͉Ȃ
	
	return result;
}

//******************************************************************************
// J[eLXg
//******************************************************************************
int MTColorPaletteCfgDlg::_InitColorText()
{
	int result = 0;
	unsigned long targetNo = 0;
	D3DXCOLOR color;
	TCHAR hexColor[16] = {_T('\0')};
	BOOL bResult = FALSE;

	for (targetNo = 0; targetNo < SM_MAX_CH_NUM + 3 + 2; targetNo++) {
		//݂̐F擾
		result = _GetCurColor(targetNo, &color);
		if (result != 0) goto EXIT;

		//J[eLXgݒ
		DXColorUtil::MakeHexRGBAFromColor(color, hexColor, 16);
		bResult = SetWindowText(m_hColorTextList[targetNo], hexColor);
		if (!bResult) {
			result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
			goto EXIT;
		}
	}

EXIT:;
	return result;
}

//******************************************************************************
// R{{bNX
//******************************************************************************
int MTColorPaletteCfgDlg::_InitCombobox(HWND hCombobox, int selectedIndex)
{
	int result = 0;
	LRESULT lresult = 0;
	unsigned long chNo = 0;
	TCHAR itemStr[16] = {_T('\0')};
	
	for (chNo = 0; chNo < SM_MAX_CH_NUM; chNo++) {
		_stprintf_s(itemStr, 16, _T("Ch.%u"), chNo + 1);
		lresult = SendMessage(hCombobox, CB_ADDSTRING, 0, (LPARAM)itemStr);
		if ((lresult == CB_ERR) || (lresult == CB_ERRSPACE)) {
			result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
			goto EXIT;
		}
		lresult = SendMessage(hCombobox, CB_SETITEMDATA, chNo, 0);
		if (lresult == CB_ERR) {
			result = YN_SET_ERR("Windows API error.", GetLastError(), chNo);
			goto EXIT;
		}
	}
	
	//IԐݒ
	lresult = SendMessage(hCombobox, CB_SETCURSEL, selectedIndex, 0);
	if (lresult == CB_ERR) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), selectedIndex);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// J[{^
//******************************************************************************
int MTColorPaletteCfgDlg::_OnBtnColor(unsigned long targetNo)
{
	int result = 0;
	D3DXCOLOR color;
	D3DXCOLOR newColor;
	bool isChoosed = false;
	TCHAR hexColor[16] = {_T('\0')};
	BOOL bResult = FALSE;

	//݂̐F擾
	result = _GetCurColor(targetNo, &color);
	if (result != 0) goto EXIT;

	//J[I_CAO\
	newColor = color;
	result = _ShowChooseColorDlg(color, &newColor, &isChoosed);
	if (result != 0) goto EXIT;

	//VFIꂽꍇ
	if (isChoosed) {
		//݂̐Fݒ
		result = _SetCurColor(targetNo, newColor);
		if (result != 0) goto EXIT;

		//J[{^ĕ`wFWM_DRAWITEMbZ[WōXV
		InvalidateRect(m_hColorButtonList[targetNo], NULL, FALSE);

		//J[eLXgXV
		DXColorUtil::MakeHexRGBAFromColor(newColor, hexColor, 16);
		bResult = SetWindowText(m_hColorTextList[targetNo], hexColor);
		if (!bResult) {
			result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
			goto EXIT;
		}
	}

EXIT:;
	return result;
}

//******************************************************************************
// Of[Vc[FSet Gradation Colors {^
//******************************************************************************
int MTColorPaletteCfgDlg::_OnBtnSetGradationColors()
{
	int result = 0;
	LRESULT lresult = 0;
	unsigned long chNoStart = 0;
	unsigned long chNoEnd = 0;

	//Iꂽ`lԍ Start
	lresult = SendMessage(GetDlgItem(m_hWnd, IDC_COMBO_START), CB_GETCURSEL, 0, 0);
	if ((lresult == CB_ERR) || (lresult < 0)) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}
	chNoStart = (unsigned long)lresult;

	//Iꂽ`lԍ End
	lresult = SendMessage(GetDlgItem(m_hWnd, IDC_COMBO_END), CB_GETCURSEL, 0, 0);
	if ((lresult == CB_ERR) || (lresult < 0)) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}
	chNoEnd = (unsigned long)lresult;

	//Of[VJ[ݒ
	result = _SetGradationColor(chNoStart, chNoEnd, m_ColorStart, m_ColorEnd);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// p[^ZbgAbvc[FSet Default Colors {^
//******************************************************************************
int MTColorPaletteCfgDlg::_OnBtnSetDefaultColors()
{
	int result = 0;

	//ftHgJ[pbg𔽉f
	m_ColorPalette.CopyFrom(&m_DefaultColorPalette);

	//J[{^XV
	result = _UpdateColorButtons();
	if (result != 0) goto EXIT;
	
	//J[eLXgXV
	result = _UpdateColorText();
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// p[^ZbgAbvc[FExport Color Parameters {^
//******************************************************************************
int MTColorPaletteCfgDlg::_OonBtnExportColorParameters()
{
	int result = 0;
	TCHAR paramString[2048] = {_T('\0')};
	MTColorParamExportDlg colorParamExportDlg;
	
	//o͗pp[^񐶐
	result = _MakeColorParamForExport(paramString, 2048);
	if (result != 0) goto EXIT;

	//o͗pp[^ݒ
	colorParamExportDlg.SetParamString(paramString);

	//J[p[^o̓_CAO\
	result = colorParamExportDlg.Show(m_hWnd);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// p[^ZbgAbvc[FImport Color Parameters {^
//******************************************************************************
int MTColorPaletteCfgDlg::_OnBtnImportColorParameters()
{
	int result = 0;
	MTColorParamImportDlg colorParamImportDlg;

	//J[p[^̓_CAO\
	result = colorParamImportDlg.Show(m_hWnd);
	if (result != 0) goto EXIT;

	//J[p[^͏
	if (colorParamImportDlg.IsExecImport()) {
		result = _ImportColorParam(colorParamImportDlg.GetParamString());
		if (result != 0) goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// J[{^XV
//******************************************************************************
int MTColorPaletteCfgDlg::_UpdateColorButtons()
{
	int result = 0;
	BOOL bResult = FALSE;
	unsigned long i = 0;

	//{^ĕ`wFWM_DRAWITEMbZ[WōXV
	for (i = 0; i < (SM_MAX_CH_NUM + 3 + 2); i++) {
		bResult = InvalidateRect(m_hColorButtonList[i], NULL, FALSE);
		if (!bResult) {
			result = YN_SET_ERR("Windows API error.", GetLastError(), i);
			goto EXIT;
		}
	}

EXIT:;
	return result;
}

//******************************************************************************
// J[{^`
//******************************************************************************
int MTColorPaletteCfgDlg::_DrawColorButton(DRAWITEMSTRUCT* pDrawItem)
{
	int result = 0;
	BOOL bResult = FALSE;
	bool isFound = false;
	unsigned long i = 0;
	unsigned long targetNo = 0;
	D3DXCOLOR color;
	COLORREF bkColor1;
	COLORREF bkColor2;
	
	//Rg[^Cv{^łȂΉȂ
	if (pDrawItem->CtlType != ODT_BUTTON) goto EXIT;

	//---------------------------------
	// {^ƃJ[
	//---------------------------------	
	//Rg[ID
	for (i = 0; i < (SM_MAX_CH_NUM + 3 + 2); i++) {
		if (pDrawItem->CtlID == GetDlgCtrlID(m_hColorButtonList[i])) {
			//Ώۂ̃{^
			isFound = true;
			targetNo = i;
		}
	}
	//Ώۂ̃{^Ȃ牽Ȃ
	if (!isFound) goto EXIT;

	//J[擾
	result = _GetCurColor(targetNo, &color);
	if (result != 0) goto EXIT;
	
	//---------------------------------
	// {^`
	//---------------------------------
	//foCXReLXg̔wiFݒ
	bkColor1 = SetBkColor(pDrawItem->hDC, RGB(color.r * 255.0f, color.g * 255.0f, color.b * 255.0f));
	if (bkColor1 == CLR_INVALID) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}
	
	//{^̎lp``
	bResult = ExtTextOut(
					pDrawItem->hDC,	//foCXReLXg
					0,				//zuQƃ|CgXWi_Wj
					0,				//zuQƃ|CgYWi_Wj
					ETO_OPAQUE,		//lp`gp@F݂̔wiFgpĎlp`hԂ
					&(pDrawItem->rcItem),	//lp`̘_W
					NULL,			//`悷eLXg
					0,				//̒
					NULL			//אڂ镶Ž_Ԃ̋
				);
	if (!bResult) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}
	
	//{^Ԃ𔽉fE`
	if (pDrawItem->itemState & ODS_SELECTED) {
		//񂾏Ԃ`
		bResult = DrawEdge(pDrawItem->hDC, &(pDrawItem->rcItem), EDGE_SUNKEN, BF_TOPLEFT | BF_BOTTOMRIGHT);
		if (!bResult) {
			result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
			goto EXIT;
		}
	}
	else {
		//Ԃ`
		bResult = DrawEdge(pDrawItem->hDC, &(pDrawItem->rcItem), EDGE_RAISED, BF_TOPLEFT | BF_BOTTOMRIGHT);
		if (!bResult) {
			result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
			goto EXIT;
		}
	}
	
	//foCXReLXg̔wiF߂
	bkColor2 = SetBkColor(pDrawItem->hDC, bkColor1);
	if (bkColor2 == CLR_INVALID) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}
	
EXIT:;
	return result;
}

//******************************************************************************
// J[eLXgXV
//******************************************************************************
int MTColorPaletteCfgDlg::_UpdateColorText()
{
	int result = 0;

	result =_InitColorText();
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// J[擾
//******************************************************************************
int MTColorPaletteCfgDlg::_GetCurColor(
		unsigned long targetNo,
		D3DXCOLOR* pColor
	)
{
	int result = 0;

	if (targetNo < SM_MAX_CH_NUM) {
		//Ch.1 - 16
		m_ColorPalette.GetChColor(targetNo, pColor);
	}
	else if (targetNo == SM_MAX_CH_NUM + 0) {
		//wi
		m_ColorPalette.GetBackgroundColor(pColor);
	}
	else if (targetNo == SM_MAX_CH_NUM + 1) {
		//ObhC
		m_ColorPalette.GetGridLineColor(pColor);
	}
	else if (targetNo == SM_MAX_CH_NUM + 2) {
		//JE^[
		m_ColorPalette.GetCounterColor(pColor);
	}
	else if (targetNo == SM_MAX_CH_NUM + 3) {
		//Start
		*pColor = m_ColorStart;
	}
	else if (targetNo == SM_MAX_CH_NUM + 4) {
		//End
		*pColor = m_ColorEnd;
	}
	else {
		result = YN_SET_ERR("Program error.", targetNo, 0);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// J[ݒ
//******************************************************************************
int MTColorPaletteCfgDlg::_SetCurColor(
	unsigned long targetNo,
	D3DXCOLOR color
)
{
	int result = 0;

	if (targetNo < SM_MAX_CH_NUM) {
		//Ch.1 - 16
		m_ColorPalette.SetChColor(targetNo, color);
	}
	else if (targetNo == SM_MAX_CH_NUM + 0) {
		//wi
		m_ColorPalette.SetBackgroundColor(color);
	}
	else if (targetNo == SM_MAX_CH_NUM + 1) {
		//ObhC
		m_ColorPalette.SetGridLineColor(color);
	}
	else if (targetNo == SM_MAX_CH_NUM + 2) {
		//JE^[
		m_ColorPalette.SetCounterColor(color);
	}
	else if (targetNo == SM_MAX_CH_NUM + 3) {
		//Start
		m_ColorStart = color;
	}
	else if (targetNo == SM_MAX_CH_NUM + 4) {
		//End
		m_ColorEnd = color;
	}
	else {
		result = YN_SET_ERR("Program error.", targetNo, 0);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// J[I_CAO\
//******************************************************************************
int MTColorPaletteCfgDlg::_ShowChooseColorDlg(
		D3DXCOLOR color,
		D3DXCOLOR* pNewColor,
		bool* pIsChoosed
	)
{
	int result = 0;
	CHOOSECOLOR cc;
	BOOL bResult = FALSE;
	DWORD dlgErrorCode;

	//J[I_CAO̐ݒ
	memset(&cc, 0, sizeof(CHOOSECOLOR));
	cc.lStructSize = sizeof(CHOOSECOLOR);
	cc.hwndOwner = m_hWnd;
	cc.hInstance = NULL;
	cc.rgbResult = RGB(color.r * 255.0f, color.g * 255.0f, color.b * 255.0f);
	cc.lpCustColors = m_CustColors;
	cc.Flags = CC_FULLOPEN		//_CAO{bNXŜ\ 
				| CC_RGBINIT;	//rgbResultoŎw肵FJ[ƂĎgp
	cc.lCustData = 0;
	cc.lpfnHook = NULL;
	cc.lpTemplateName = NULL;

	//J[I_CAO\
	bResult = ChooseColor(&cc);
	if (!bResult) {
		dlgErrorCode = CommDlgExtendedError();
		if (dlgErrorCode == 0) {
			//LZ
			*pIsChoosed = false;
		}
		else {
			//G[
			result = YN_SET_ERR("Windows API error.", dlgErrorCode, 0);
			goto EXIT;
		}
	}
	else {
		//VFIꂽꍇ
		*pNewColor = D3DXCOLOR(
							GetRValue(cc.rgbResult) / 255.0f,
							GetGValue(cc.rgbResult) / 255.0f,
							GetBValue(cc.rgbResult) / 255.0f,
							1.0f
						);
		*pIsChoosed = true;
	}

EXIT:;
	return result;
}

//******************************************************************************
// Of[VJ[ݒ
//******************************************************************************
int MTColorPaletteCfgDlg::_SetGradationColor(
		unsigned long chNoStart,
		unsigned long chNoEnd,
		D3DXCOLOR colorStart,
		D3DXCOLOR colorEnd
	)
{
	int result = 0;
	unsigned int chNo = 0;
	D3DXCOLOR color;
	float ratio = 0.0f;

	if ((chNoStart >= SM_MAX_CH_NUM) || (chNoEnd >= SM_MAX_CH_NUM)) {
		//Ȃ
	}

	if (chNoStart == chNoEnd) {
		//Ȃ
	}
	else if (chNoStart < chNoEnd) {
		for (chNo = chNoStart; chNo <= chNoEnd; chNo++) {
			ratio = (float)(chNo - chNoStart) / (float)(chNoEnd - chNoStart);
			color = D3DXCOLOR((colorEnd.r - colorStart.r) * ratio + colorStart.r,
				(colorEnd.g - colorStart.g) * ratio + colorStart.g,
				(colorEnd.b - colorStart.b) * ratio + colorStart.b,
				1.0f);
			//J[ݒ
			m_ColorPalette.SetChColor(chNo, color);
		}
	}
	else {
		for (chNo = chNoEnd; chNo <= chNoStart; chNo++) {
			ratio = (float)(chNo - chNoEnd) / (float)(chNoStart - chNoEnd);
			color = D3DXCOLOR((colorStart.r - colorEnd.r) * ratio + colorEnd.r,
				(colorStart.g - colorEnd.g) * ratio + colorEnd.g,
				(colorStart.b - colorEnd.b) * ratio + colorEnd.b,
				1.0f);
			//J[ݒ
			m_ColorPalette.SetChColor(chNo, color);
		}
	}

	//J[{^XV
	result = _UpdateColorButtons();
	if (result != 0) goto EXIT;

	//J[eLXgXV
	result = _UpdateColorText();
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// o͗pp[^񐶐
//******************************************************************************
int MTColorPaletteCfgDlg::_MakeColorParamForExport(TCHAR* pTextBuf, unsigned long bufSize)
{
	int result = 0;
	unsigned long chNo = 0;
	D3DXCOLOR color;
	TCHAR hexColor[16] = { _T('\0') };
	TCHAR line[64] = {_T('\0')};

	if ((pTextBuf == NULL) || (bufSize < 2048)) {
		result = YN_SET_ERR("Program error.", bufSize, 0);
		goto EXIT;
	}

	pTextBuf[0] = _T('\0');

	//p[^񐶐FCh.1-16
	for (chNo = 0; chNo < SM_MAX_CH_NUM; chNo++) {
		m_ColorPalette.GetChColor(chNo, &color);
		DXColorUtil::MakeHexRGBAFromColor(color, hexColor, 16);
		_stprintf_s(line, 64, _T("Ch-%02u-NoteRGBA=%s\r\n"), chNo + 1, hexColor);
		_tcscat_s(pTextBuf, bufSize, line);
	}

	//p[^񐶐Fwi
	m_ColorPalette.GetBackgroundColor(&color);
	DXColorUtil::MakeHexRGBAFromColor(color, hexColor, 16);
	_stprintf_s(line, 64, _T("BackGroundRGBA=%s\r\n"), hexColor);
	_tcscat_s(pTextBuf, bufSize, line);

	//p[^񐶐FObhC
	m_ColorPalette.GetGridLineColor(&color);
	DXColorUtil::MakeHexRGBAFromColor(color, hexColor, 16);
	_stprintf_s(line, 64, _T("GridLineRGBA=%s\r\n"), hexColor);
	_tcscat_s(pTextBuf, bufSize, line);

	//p[^񐶐FJE^[
	m_ColorPalette.GetCounterColor(&color);
	DXColorUtil::MakeHexRGBAFromColor(color, hexColor, 16);
	_stprintf_s(line, 64, _T("CounterRGBA=%s\r\n"), hexColor);
	_tcscat_s(pTextBuf, bufSize, line);

EXIT:;
	return result;
}

//******************************************************************************
// p[^͏
//******************************************************************************
int MTColorPaletteCfgDlg::_ImportColorParam(TCHAR* pParamString)
{
	int result = 0;
	MTColorParamDictionary paramDictionary;

	//p[^}bv쐬
	result = _MakeImportKeyValueMap(pParamString, &paramDictionary);
	if (result != 0) goto EXIT;

	//p[^ǂݍ
	result = _LoadParam(&paramDictionary);
	if (result != 0) goto EXIT;

	//J[{^XV
	result = _UpdateColorButtons();
	if (result != 0) goto EXIT;

	//J[eLXgXV
	result = _UpdateColorText();
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// p[^}bv쐬
//******************************************************************************
int MTColorPaletteCfgDlg::_MakeImportKeyValueMap(
		TCHAR* pParamString,
		MTColorParamDictionary* pParamDictionary
	)
{
	int result = 0;
	std::string paramString = pParamString;
	std::stringstream stream{ paramString };
	std::string line;
	std::string trimLine;
	std::string key;
	std::string value;
	std::string::size_type trimLeft;
	std::string::size_type trimRight;
	TCHAR* trimCharList = _T(" \t\r\n");
	MTColorParamDictionary::iterator itr;

	//es
	while (std::getline(stream, line, '\n')) {
		//Ő󔒂Ɖsg~O
		trimLeft = line.find_first_not_of(trimCharList);
		trimRight = line.find_last_not_of(trimCharList);

		//g~OƉcȂꍇ͎s֐i
		if ((trimLeft == std::string::npos) || (trimRight == std::string::npos)) {
			continue;
		}

		//_G[o
		if (trimLeft > trimRight) {
			result = YN_SET_ERR("Program error.", trimLeft, trimRight);
			goto EXIT;
		}

		//Rgs𖳎
		trimLine = line.substr(trimLeft, trimRight - trimLeft + 1);
		if ((trimLine.front() == _T('#')) || (trimLine.front() == _T(';'))) {
			//RgsƂĖĎs֐i
			continue;
		}

		//L[
		trimLeft = trimLine.find_first_of(_T("="));
		if ((trimLeft == std::string::npos) || (trimLeft == 0)) {
			//f~^ȂA܂̓f~^擪̂߁AĎs֐i
			continue;
		}
		key = trimLine.substr(0, trimLeft);

		//l
		if ((trimLeft + 1) == trimLine.length()) {
			//f~^ɂȂl͋󕶎
			value = _T("");
		}
		else {
			//f~^lƂ
			value = trimLine.substr(trimLeft + 1, trimLine.length() - trimLeft + 1);
			//l̐擪NI[e[Vň͂܂Ăꍇ̓NI[e[V菜
			//f~^ƃNI[e[V̊Ԃɋ󔒂ꍇ͋󔒂lƂ݂Ȃ
			if (value.length() >= 2) {
				if ((value.front() == _T('\'')) && (value.back() == _T('\''))) {
					value = value.substr(1, value.length() - 2);
				}
				else if ((value.front() == _T('\"')) && (value.back() == _T('\"'))) {
					value = value.substr(1, value.length() - 2);
				}
			}
		}

		//}bvo^
		//łɃL[݂ꍇ͊f[^폜
		itr = pParamDictionary->find(key);
		if (itr != pParamDictionary->end()) {
			pParamDictionary->erase(itr);
		}
		//f[^o^
		pParamDictionary->insert(MTColorParamDictionaryPair(key, value));

		//OutputDebugString(_T("key:"));
		//OutputDebugString(key.c_str());
		//OutputDebugString(_T("\n"));
		//OutputDebugString(_T("value:"));
		//OutputDebugString(value.c_str());
		//OutputDebugString(_T("\n"));
	}

EXIT:;
	return result;
}

//******************************************************************************
// p[^ǂݍ
//******************************************************************************
int MTColorPaletteCfgDlg::_LoadParam(MTColorParamDictionary* pParamDictionary)
{
	int result = 0;
	unsigned long chNo = 0;
	TCHAR hexColor[16] = { _T('\0') };
	TCHAR key[32] = { _T('\0') };
	const TCHAR* pValue = NULL;
	MTColorParamDictionary::iterator itr;
	D3DXCOLOR color;
	D3DCOLOR colorRGB;

	//Ch.1-16
	for (chNo = 0; chNo < SM_MAX_CH_NUM; chNo++) {
		_stprintf_s(key, 32, _T("Ch-%02u-NoteRGBA"), chNo + 1);
		itr = pParamDictionary->find(key);
		if (itr != pParamDictionary->end()) {
			pValue = (itr->second).c_str();
			if (_tcslen(pValue) == 8) {
				color = DXColorUtil::MakeColorFromHexRGBA(pValue);
				m_ColorPalette.SetChColor(chNo, color);
			}
		}
	}

	//wi
	itr = pParamDictionary->find(_T("BackGroundRGBA"));
	if (itr != pParamDictionary->end()) {
		pValue = (itr->second).c_str();
		if (_tcslen(pValue) == 8) {
			color = DXColorUtil::MakeColorFromHexRGBA(pValue);
			m_ColorPalette.SetBackgroundColor(color);
		}
	}
	//݊ۂ ini t@Cɒ`Ă"BackGroundRGB"iAȂjC|[g\Ƃ
	itr = pParamDictionary->find(_T("BackGroundRGB"));
	if (itr != pParamDictionary->end()) {
		pValue = (itr->second).c_str();
		if (_tcslen(pValue) == 6) {
			colorRGB = DXColorUtil::MakeColorFromHexRGB(pValue);
			color = D3DXCOLOR(colorRGB);
			m_ColorPalette.SetBackgroundColor(color);
		}
	}

	//ObhC
	itr = pParamDictionary->find(_T("GridLineRGBA"));
	if (itr != pParamDictionary->end()) {
		pValue = (itr->second).c_str();
		if (_tcslen(pValue) == 8) {
			color = DXColorUtil::MakeColorFromHexRGBA(pValue);
			m_ColorPalette.SetGridLineColor(color);
		}
	}

	//JE^
	itr = pParamDictionary->find(_T("CounterRGBA"));
	if (itr != pParamDictionary->end()) {
		pValue = (itr->second).c_str();
		if (_tcslen(pValue) == 8) {
			color = DXColorUtil::MakeColorFromHexRGBA(pValue);
			m_ColorPalette.SetCounterColor(color);
		}
	}
	//݊ۂ ini t@Cɒ`Ă"CaptionRGBA"C|[g\Ƃ
	itr = pParamDictionary->find(_T("CaptionRGBA"));
	if (itr != pParamDictionary->end()) {
		pValue = (itr->second).c_str();
		if (_tcslen(pValue) == 8) {
			color = DXColorUtil::MakeColorFromHexRGBA(pValue);
			m_ColorPalette.SetCounterColor(color);
		}
	}

//EXIT:;
	return result;
}


